/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "nConfig.h"
#include "tConsole.h"

nConfItemBase::nConfItemBase()
        :tConfItemBase(""){};

//nConfItemBase::nConfItemBase(const char *title,const char *help)
//  :tConfItemBase(title, help){}

nConfItemBase::nConfItemBase(const char *title)
        :tConfItemBase(title){}

nConfItemBase::~nConfItemBase(){}

void nConfItemBase::s_GetConfigMessage(nMessage &m){
    if (sn_GetNetState()==nSERVER){
        nReadError(); // never accept config messages from the clients
    }
    else{
        tString name;
        m >> name;

        //con << "got conf message for " << name << "\n";

        int i=0;

        for(tConfItemBase *item = s_ConfItemAnchor; item ; item = item->Next()){
            nConfItemBase *netitem = dynamic_cast<nConfItemBase*> (item);
            if (netitem && !strcmp(name,netitem->title)){
                netitem->NetReadVal(m);
                i=-10;
            }
        }

        if (i>-5){ // error
            tOutput o;
            o.SetTemplateParameter(1, name);
            o << "$nconfig_error_unknown";
            con << o;
        }
    }
}


static nDescriptor transferConfig(60,nConfItemBase::s_GetConfigMessage,
                                  "transfer config");

void nConfItemBase::s_SendConfig(bool force, int peer){
    if(sn_GetNetState()==nSERVER){
        for(tConfItemBase *item = s_ConfItemAnchor; item ; item = item->Next()){
            nConfItemBase *netitem = dynamic_cast<nConfItemBase*> (item);
            if (netitem)
                netitem->SendConfig(force, peer);
        }
    }
}

void nConfItemBase::SendConfig(bool force, int peer){
    if ( (changed || force) && sn_GetNetState()==nSERVER)
    {
        //con << "sending conf message for " << tConfItems(i)->title << "\n";
        nMessage *m=new nMessage(transferConfig);
        *m << title;
        NetWriteVal(*m);
        if (peer==-1)
        {
            m->BroadCast();
            changed = false;
        }
        else
            m->Send(peer);
    }
}

void nConfItemBase::WasChanged(){
    SendConfig();
}

bool nConfItemBase::Writable(){
    return sn_GetNetState()!=nCLIENT;
}

