#include "config.h"
#ifndef DEDICATED
#include <SDL.h>
#include "tInitExit.h"

extern SDL_Surface *sr_screen;

static void Init(){
    if (!sr_screen){
        if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
            fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
            exit(1);
        }

        if ( (sr_screen=SDL_SetVideoMode
                        (640, 480,    0,
                         //	   SDL_DOUBLEBUF | SDL_SWSURFACE | SDL_FULLSCREEN))
                         SDL_DOUBLEBUF | SDL_SWSURFACE))
                == NULL ) {
            fprintf(stderr, "Couldn't set doublebuffer video mode: %s\n",
                    SDL_GetError());
        }
    }
}

static void exit_at(){
    if (sr_screen){
        SDL_FreeSurface(sr_screen);
        sr_screen=NULL;
        //SDL_Quit();
    }
}

static tInitExit IE(init,exit_at);
#endif
