/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)
#include <stdio>
#include <stdlib.h> 
**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_ADV_WALL_H
#define ArmageTron_ADV_WALL_H

#include "eWall.h"
#include "nNetObject.h"

class eWallRim:public eWall{
protected:
    int rim_id;
    bool bf_cull;
    REAL height;
public:
    eWallRim(eGrid *grid, bool backface_cull=true,REAL h=10000000);
    virtual ~eWallRim();

    virtual bool Splittable() const;

    //  virtual void Split(eWall *& w1,eWall *& w2,REAL a);

#ifndef DEDICATED
    virtual void RenderReal()=0;

    virtual void Render(){
        if (rim_id<0 && Edge() )
            RenderReal();
    }
#endif

virtual REAL SeeHeight() const{return height*40;}

    virtual REAL BlockHeight() const{
        if (bf_cull)
            return 0;
        else
            return SeeHeight();
    }

    static bool IsBound(const eCoord &x,REAL offset=0);
    // is x by offset inside the bounds of the rim eWalls?
    static REAL Bound(eCoord &x,REAL offset=0);
    // brings x into the bounds of the rim eWalls with a min distance of offset
};

extern tList<eWallRim> se_rimWalls;




#endif
