/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "eWall.h"
#include "math.h"
#include "rTexture.h"
#include "eTimer.h"
#include "rScreen.h"
#include "eAdvWall.h"
#include "eCamera.h"
#include "tConfiguration.h"


/* **********************************************
   RimWall
   ********************************************** */

tList<eWallRim> se_rimWalls;

eWallRim::eWallRim(eGrid *grid, bool backface_cull, REAL h)
        :eWall(grid), rim_id(-1),bf_cull(backface_cull), height(h){
    if (h>100 && !sr_highRim)
        height=4;

    //  if(bf_cull && sr_ZTrick)
    se_rimWalls.Add(this,rim_id);
}

eWallRim::~eWallRim(){
    se_rimWalls.Remove(this,rim_id);
}

//ArmageTron_eWalltype gWallRim::type(){return ArmageTron_RIM;}

//void eWallRim::Flip(){}

bool eWallRim::Splittable() const{return 0;}

REAL eWallRim::Bound(eCoord &x,REAL offset)
{
    REAL ret = -1E+30f;
    for(int i=se_rimWalls.Len()-1;i>=0;i--){
        eWallRim *w = se_rimWalls(i);
        eCoord p1 = w->EndPoint(0);
        eCoord p2 = w->EndPoint(1);
        eCoord diff=p2-p1;
        diff=diff*(1/(w->len));
        diff=diff.Turn(0,-1);
        REAL y=eCoord::F(diff,x-p1);
        y+=offset;
        if ( y > ret )
        {
            ret = y;
        }
        if (y>.01){
            //con << "Correction!\n";
            x=x-diff*y;
        }
    }

    return ret;
}

bool eWallRim::IsBound(const eCoord &x, REAL offset){
    for(int i=se_rimWalls.Len()-1;i>=0;i--){
        eWallRim *w = se_rimWalls(i);
        eCoord p1=w->EndPoint(0);
        eCoord p2=w->EndPoint(1);
        eCoord diff=p2-p1;
        diff=diff*(1/(w->len));
        diff=diff.Turn(0,-1);
        REAL y=eCoord::F(diff,x-p1);
        if (y>-offset){
            return false;
        }
    }
    return true;
}





