; Armagetron Advanced Dedicated Server Setup Script
!define PRODUCT_NAME "Armagetron Advanced Dedicated Server"
!define PRODUCT_VERSION "0.2.7.1"
!define PRODUCT_PUBLISHER "Armagetron Advanced Team"
!define PRODUCT_WEB_SITE "http://armagetronad.sf.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\armagetronad_dedicated.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "banner.bmp"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"
!define MUI_WELCOMEPAGE_TITLE_3LINES
!define MUI_FINISHPAGE_TITLE_3LINES

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Spanish"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "armagetronad-windows-dedicated-0.2.7.1.exe"
InstallDir "$PROGRAMFILES\Armagetron Advanced Dedicated"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "Armagetron Forums.url"
  CreateDirectory "$SMPROGRAMS\Armagetron Advanced"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Armagetron Forums.lnk" "$INSTDIR\Armagetron Forums.url"
  File "armagetronad_dedicated.exe"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Armagetron Advanced Server.lnk" "$INSTDIR\armagetronad_dedicated.exe"
  CreateShortCut "$DESKTOP\Armagetron Advanced Server.lnk" "$INSTDIR\armagetronad_dedicated.exe"
  SetOutPath "$INSTDIR\config"
  File ".\config\aiplayers.cfg"
  File ".\config\default.cfg"
  File ".\config\master.srv"
  File ".\config\settings.cfg"
  File ".\config\settings_dedicated.cfg"
  SetOutPath "$INSTDIR"
  File "COPYING.txt"
  SetOutPath "$INSTDIR\doc"
  File ".\doc\bugs.html"
  File ".\doc\changelog.html"
  File ".\doc\commands.html"
  File ".\doc\compile.html"
  File ".\doc\config.html"
  File ".\doc\faq.html"
  File ".\doc\index.html"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Documentation.lnk" "$INSTDIR\doc\index.html"
  File ".\doc\install_windows.html"
  File ".\doc\readme_windows.html"
  SetOutPath "$INSTDIR\doc\net"
  File ".\doc\net\index.html"
  File ".\doc\net\lower.html"
  File ".\doc\net\middle.html"
  File ".\doc\net\upper.html"
  SetOutPath "$INSTDIR\doc"
  File ".\doc\network.html"
  File ".\doc\todo.html"
  File ".\doc\versions.html"
  SetOutPath "$INSTDIR\language"
  File ".\language\deutsch.txt"
  File ".\language\english.txt"
  File ".\language\languages.txt"
  SetOutPath "$INSTDIR"
  File "README.txt"
  SetOutPath "$INSTDIR\var"
  File ".\var\README.txt"
SectionEnd

Section -AdditionalIcons
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Uninstall Armagetron Advanced Server.lnk" "$INSTDIR\uninst_dedicated.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst_dedicated.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\armagetronad_dedicated.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst_dedicated.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\armagetronad_dedicated.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\uninst_dedicated.exe"
  Delete "$INSTDIR\var\README.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\language\languages.txt"
  Delete "$INSTDIR\language\english.txt"
  Delete "$INSTDIR\language\deutsch.txt"
  Delete "$INSTDIR\doc\versions.html"
  Delete "$INSTDIR\doc\todo.html"
  Delete "$INSTDIR\doc\network.html"
  Delete "$INSTDIR\doc\net\upper.html"
  Delete "$INSTDIR\doc\net\middle.html"
  Delete "$INSTDIR\doc\net\lower.html"
  Delete "$INSTDIR\doc\net\index.html"
  Delete "$INSTDIR\doc\readme_windows.html"
  Delete "$INSTDIR\doc\install_windows.html"
  Delete "$INSTDIR\doc\index.html"
  Delete "$INSTDIR\doc\faq.html"
  Delete "$INSTDIR\doc\config.html"
  Delete "$INSTDIR\doc\compile.html"
  Delete "$INSTDIR\doc\commands.html"
  Delete "$INSTDIR\doc\changelog.html"
  Delete "$INSTDIR\doc\bugs.html"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\config\settings_dedicated.cfg"
  Delete "$INSTDIR\config\settings.cfg"
  Delete "$INSTDIR\config\master.srv"
  Delete "$INSTDIR\config\default.cfg"
  Delete "$INSTDIR\config\aiplayers.cfg"
  Delete "$INSTDIR\armagetronad_dedicated.exe"
  Delete "$INSTDIR\Armagetron Forums.url"

  Delete "$SMPROGRAMS\Armagetron Advanced\Uninstall Armagetron Advanced Server.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Documentation.lnk"
  Delete "$DESKTOP\Armagetron Advanced Server.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Armagetron Advanced Server.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Armagetron Forums.lnk"

  RMDir "$SMPROGRAMS\Armagetron Advanced"
  RMDir "$INSTDIR\var"
  RMDir "$INSTDIR\language"
  RMDir "$INSTDIR\doc\net"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\config"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
