; Armagetron Advanced Client Setup Script
!define PRODUCT_NAME "Armagetron Advanced"
!define PRODUCT_VERSION "0.2.7.1"
!define PRODUCT_PUBLISHER "Armagetron Advanced Team"
!define PRODUCT_WEB_SITE "http://armagetronad.sf.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\armagetronad.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "banner.bmp"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"
!define MUI_WELCOMEPAGE_TITLE_3LINES
!define MUI_FINISHPAGE_TITLE_3LINES

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\armagetronad.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Spanish"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "armagetronad-windows-0.2.7.1.exe"
InstallDir "$PROGRAMFILES\Armagetron Advanced"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "Armagetron Forums.url"
  CreateDirectory "$SMPROGRAMS\Armagetron Advanced"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Armagetron Forums.lnk" "$INSTDIR\Armagetron Forums.url"
  File "armagetronad.exe"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Armagetron Advanced.lnk" "$INSTDIR\armagetronad.exe"
  CreateShortCut "$DESKTOP\Armagetron Advanced.lnk" "$INSTDIR\armagetronad.exe"
  SetOutPath "$INSTDIR\config"
  File ".\config\aiplayers.cfg"
  File ".\config\default.cfg"
  File ".\config\master.srv"
  File ".\config\settings.cfg"
  File ".\config\settings_dedicated.cfg"
  SetOutPath "$INSTDIR"
  File "COPYING.txt"
  SetOutPath "$INSTDIR\doc"
  File ".\doc\bugs.html"
  File ".\doc\changelog.html"
  File ".\doc\commands.html"
  File ".\doc\compile.html"
  File ".\doc\config.html"
  File ".\doc\faq.html"
  File ".\doc\index.html"
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Documentation.lnk" "$INSTDIR\doc\index.html"
  File ".\doc\install_windows.html"
  File ".\doc\readme_windows.html"
  SetOutPath "$INSTDIR\doc\net"
  File ".\doc\net\index.html"
  File ".\doc\net\lower.html"
  File ".\doc\net\middle.html"
  File ".\doc\net\upper.html"
  SetOutPath "$INSTDIR\doc"
  File ".\doc\network.html"
  File ".\doc\todo.html"
  File ".\doc\versions.html"
  SetOutPath "$INSTDIR"
  File "jpeg.dll"
  SetOutPath "$INSTDIR\language"
  File ".\language\deutsch.txt"
  File ".\language\english.txt"
  File ".\language\languages.txt"
  SetOutPath "$INSTDIR"
  File "libpng1.dll"
  SetOutPath "$INSTDIR\models"
  File ".\models\cycle_body.mod"
  File ".\models\cycle_front.mod"
  File ".\models\cycle_rear.mod"
  SetOutPath "$INSTDIR"
  File "README-SDL.txt"
  File "README.txt"
  File "SDL.dll"
  File "SDL_image.dll"
  File "SDL_mixer.dll"
  SetOutPath "$INSTDIR\sound"
  File ".\sound\cyclrun.wav"
  File ".\sound\expl.wav"
  SetOutPath "$INSTDIR\textures"
  File ".\textures\cycle_body.png"
  File ".\textures\cycle_wheel.png"
  File ".\textures\dir_wall.png"
  File ".\textures\floor.png"
  File ".\textures\floor_a.png"
  File ".\textures\floor_b.png"
  File ".\textures\font.png"
  File ".\textures\font_extra.png"
  File ".\textures\font_s.png"
  File ".\textures\icon.png"
  File ".\textures\rim_wall.png"
  File ".\textures\shadow.png"
  File ".\textures\sky.png"
  File ".\textures\title.jpg"
  SetOutPath "$INSTDIR\var"
  File ".\var\README.txt"
  SetOutPath "$INSTDIR"
  File "zlib.dll"
SectionEnd

Section -AdditionalIcons
  CreateShortCut "$SMPROGRAMS\Armagetron Advanced\Uninstall Armagetron Advanced.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\armagetronad.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\armagetronad.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\zlib.dll"
  Delete "$INSTDIR\textures\title.jpg"
  Delete "$INSTDIR\textures\sky.png"
  Delete "$INSTDIR\textures\shadow.png"
  Delete "$INSTDIR\textures\rim_wall.png"
  Delete "$INSTDIR\textures\icon.png"
  Delete "$INSTDIR\textures\font_s.png"
  Delete "$INSTDIR\textures\font_extra.png"
  Delete "$INSTDIR\textures\font.png"
  Delete "$INSTDIR\textures\floor_b.png"
  Delete "$INSTDIR\textures\floor_a.png"
  Delete "$INSTDIR\textures\floor.png"
  Delete "$INSTDIR\textures\dir_wall.png"
  Delete "$INSTDIR\textures\cycle_wheel.png"
  Delete "$INSTDIR\textures\cycle_body.png"
  Delete "$INSTDIR\stdout.txt"
  Delete "$INSTDIR\sound\expl.wav"
  Delete "$INSTDIR\sound\cyclrun.wav"
  Delete "$INSTDIR\SDL_mixer.dll"
  Delete "$INSTDIR\SDL_image.dll"
  Delete "$INSTDIR\SDL.dll"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\README-SDL.txt"
  Delete "$INSTDIR\models\cycle_rear.mod"
  Delete "$INSTDIR\models\cycle_front.mod"
  Delete "$INSTDIR\models\cycle_body.mod"
  Delete "$INSTDIR\libpng1.dll"
  Delete "$INSTDIR\language\languages.txt"
  Delete "$INSTDIR\language\english.txt"
  Delete "$INSTDIR\language\deutsch.txt"
  Delete "$INSTDIR\jpeg.dll"
  Delete "$INSTDIR\doc\versions.html"
  Delete "$INSTDIR\doc\todo.html"
  Delete "$INSTDIR\doc\network.html"
  Delete "$INSTDIR\doc\net\upper.html"
  Delete "$INSTDIR\doc\net\middle.html"
  Delete "$INSTDIR\doc\net\lower.html"
  Delete "$INSTDIR\doc\net\index.html"
  Delete "$INSTDIR\doc\readme_windows.html"
  Delete "$INSTDIR\doc\install_windows.html"
  Delete "$INSTDIR\doc\index.html"
  Delete "$INSTDIR\doc\faq.html"
  Delete "$INSTDIR\doc\config.html"
  Delete "$INSTDIR\doc\compile.html"
  Delete "$INSTDIR\doc\commands.html"
  Delete "$INSTDIR\doc\changelog.html"
  Delete "$INSTDIR\doc\bugs.html"
  Delete "$INSTDIR\config\settings_dedicated.cfg"
  Delete "$INSTDIR\config\settings.cfg"
  Delete "$INSTDIR\config\master.srv"
  Delete "$INSTDIR\config\default.cfg"
  Delete "$INSTDIR\config\aiplayers.cfg"
  Delete "$INSTDIR\armagetronad.exe"
  Delete "$INSTDIR\Armagetron Forums.url"

  Delete "$SMPROGRAMS\Armagetron Advanced\Uninstall Armagetron Advanced.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Documentation.lnk"
  Delete "$DESKTOP\Armagetron Advanced.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Armagetron Advanced.lnk"
  Delete "$SMPROGRAMS\Armagetron Advanced\Armagetron Forums.lnk"

  RMDir "$SMPROGRAMS\Armagetron Advanced"
  RMDir "$INSTDIR\var"
  RMDir "$INSTDIR\textures"
  RMDir "$INSTDIR\sound"
  RMDir "$INSTDIR\models"
  RMDir "$INSTDIR\language"
  RMDir "$INSTDIR\doc\net"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\config"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
