/* This file is part of the KDE project
   Copyright (C) 2003 Ian Reinhart Geiser  (geiseri@kde.org)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "javascript.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kjsembed/kjsembedpart.h>
#include <kjsembed/jsconsolewidget.h>
#include <kjsembed/jsbinding.h>

#include <kgenericfactory.h>
#include <scriptclientinterface.h>
//using namespace KScriptInterface;
typedef KGenericFactory<JavaScript, KScriptClientInterface> JavaScriptFactory;
K_EXPORT_COMPONENT_FACTORY( libjavascript, JavaScriptFactory( "JavaScript" ) )

JavaScript::JavaScript(KScriptClientInterface *parent, const char *name, const QStringList &args )
{
	ScriptClientInterface = parent;
	m_jsembed = new KJSEmbed::KJSEmbedPart(this, "kjsembed_part");
	m_scriptLoc = ""; // arg1?
	m_method = ""; // arg2?
	m_jsembed->addObject( this, "KScriptInterface");
	m_jsembed->addObject( m_jsembed->view(), "console" );
}

JavaScript::~JavaScript()
{
}

QString JavaScript::script() const
{
	return m_scriptLoc;
}

void JavaScript::setScript( const QString &scriptFile  )
{
	m_scriptLoc = scriptFile;
}

void JavaScript::setScript( const QString &scriptFile, const QString &method )
{
	m_scriptLoc = scriptFile;
	m_method = method;
}

void JavaScript::run(QObject *context, const QVariant &arg)
{
	QVariant retVal;
	if( context ) m_jsembed->addObject(context);

	m_jsembed->runFile(m_scriptLoc, m_jsembed->globalObject() );

	if( !m_method.isEmpty() )
	{
		KJS::List args;
		args.append( KJSEmbed::convertToValue(m_jsembed->globalExec(), arg) );
		KJS::Value val = m_jsembed->callMethod(m_method, args);
		retVal = KJSEmbed::convertToVariant(m_jsembed->globalExec(),val);
	}
	ScriptClientInterface->done(KScriptClientInterface::ResultSuccess, retVal);
}

void JavaScript::writeLine( const QString &msg )
{
	ScriptClientInterface->output(msg);
}

void JavaScript::writeWarning( const QString &msg )
{
	ScriptClientInterface->warning(msg);
}

void JavaScript::writeError( const QString &msg )
{
	ScriptClientInterface->error(msg);
}

void JavaScript::setProgress( int percent )
{
	ScriptClientInterface->progress(percent);
}

QString JavaScript::appID() const
{
	return kapp->dcopClient()->appId();
}

void JavaScript::kill()
{
  // not sure what to do here....
}

#include "javascript.moc"
