/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Ethereal dissector compiler    */
/* ./packet-h245.c                                                            */
/* ../../tools/asn2eth.py -X -e -p h245 -c h245.cnf -s packet-h245-template h245.asn */

/* Input file: packet-h245-template.c */

/* packet-h245_asn1.c
 * Routines for h245 packet dissection
 * Copyright 2004, Anders Broman <anders.broman@ericsson.com>
 *
 * $Id: packet-h245.c 14072 2005-04-14 04:26:00Z gerald $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * To quote the author of the previous H245 dissector:
 *   "This is a complete replacement of the previous limitied dissector
 * that Ronnie was crazy enough to write by hand. It was a lot of time
 * to hack it by hand, but it is incomplete and buggy and it is good when
 * it will go away."
 * Ronnie did a great job and all the VoIP users had made good use of it!
 * Credit to Tomas Kukosa for developing the Asn2eth compiler.
 *
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/conversation.h>

#include <stdio.h>
#include <string.h>

#include <epan/prefs.h>
#include "tap.h"
#include "packet-h245.h"
#include "packet-tpkt.h"
#include "packet-per.h"
#include <epan/t35.h>
#include "packet-rtp.h"
#include "packet-rtcp.h"
#include "packet-ber.h"

#define PNAME  "h245"
#define PSNAME "h245"
#define PFNAME "h245"

static dissector_handle_t rtp_handle=NULL;
static dissector_handle_t rtcp_handle=NULL;
static dissector_table_t nsp_object_dissector_table;
static dissector_table_t nsp_h221_dissector_table;
static dissector_handle_t nsp_handle;
static dissector_handle_t h245_handle;
static dissector_handle_t MultimediaSystemControlMessage_handle;

static void reset_h245_packet_info(h245_packet_info *pi);
static int hf_h245_pdu_type = -1;
static int hf_h245Manufacturer = -1;
static int h245_tap = -1;
static int ett_h245 = -1;
static int h245dg_tap = -1;
static h245_packet_info pi_arr[5]; /* We assuming a maximum of 5 H245 messaages per packet */
static int pi_current=0;
h245_packet_info *h245_pi=NULL;

static gboolean h245_reassembly = TRUE;
static gboolean h245_shorttypes = FALSE;
static const value_string h245_RequestMessage_short_vals[] = {
	{  0,	"NSM" },
	{  1,	"MSD" },
	{  2,	"TCS" },
	{  3,	"OLC" },
	{  4,	"CLC" },
	{  5,	"RCC" },
	{  6,	"MES" },
	{  7,	"RME" },
	{  8,	"RM" },
	{  9,	"RTDR" },
	{ 10,	"MLR" },
	{ 11,	"CMR" },
	{ 12,	"CR" },
	{ 13,	"MR" },
	{ 14,	"LCRR" },
	{ 15,	"GR" },
	{  0, NULL }
};
static const value_string h245_ResponseMessage_short_vals[] = {
	{  0,	"NSM" },
	{  1,	"MSDAck" },
	{  2,	"MSDReject" },
	{  3,	"TCSAck" },
	{  4,	"TCSReject" },
	{  5,	"OLCAck" },
	{  6,	"OLCReject" },
	{  7,	"CLCAck" },
	{  8,	"RCCAck" },
	{  9,	"RCCReject" },
	{ 10,	"MESAck" },
	{ 11,	"MESReject" },
	{ 12,	"RMEAck" },
	{ 13,	"RMEReject" },
	{ 14,	"RMAck" },
	{ 15,	"RMReject" },
	{ 16,	"RTDResponse" },
	{ 17,	"MLAck" },
	{ 18,	"MLReject" },
	{ 19,	"CMResponse" },
	{ 20,	"CResponse" },
	{ 21,	"MResponse" },
	{ 22,	"LCRAck" },
	{ 23,	"LCRReject" },
	{ 24,	"GR" },
	{  0, NULL }
};
static const value_string h245_IndicationMessage_short_vals[] = {
	{  0,	"NSM" },
	{  1,	"FNU" },
	{  2,	"MSDRelease" },
	{  3,	"TCSRelease" },
	{  4,	"OLCConfirm" },
	{  5,	"RCCRelease" },
	{  6,	"MESRelease" },
	{  7,	"RMERelease" },
	{  8,	"RMRelease" },
	{  9,	"MI" },
	{ 10,	"JI" },
	{ 11,	"H223SI" },
	{ 12,	"NATMVCI" },
	{ 13,	"UII" },
	{ 14,	"H2250MSI" },
	{ 15,	"MCLI" },
	{ 16,	"CI" },
	{ 17,	"VI" },
	{ 18,	"FNS" },
	{ 19,	"MultilinkIndication" },
	{ 20,	"LCRRelease" },
	{ 21,	"FCIndication" },
	{ 22,	"MMRI" },
	{ 22,	"GI" },
	{  0, NULL }
};
static const value_string h245_CommandMessage_short_vals[] = {
	{  0,	"NSM" },
	{  1,	"MLOC" },
	{  2,	"STCS" },
	{  3,	"EC" },
	{  4,	"FCC" },
	{  5,	"ESC" },
	{  6,	"MC" },
	{  7,	"CMC" },
	{  8,	"CC" },
	{  9,	"H223MR" },
	{ 10,	"NATMVCC" },
	{ 11,	"MMRC" },
	{ 12,	"GC" },
	{  0, NULL }
};
static const value_string h245_AudioCapability_short_vals[] = {
        {  0, "nonStd" },
        {  1, "g711A" },
        {  2, "g711A56k" },
        {  3, "g711U" },
        {  4, "g711U56k" },
        {  5, "g722-64k" },
        {  6, "g722-56k" },
        {  7, "g722-48k" },
        {  8, "g7231" },
        {  9, "g728" },
        { 10, "g729" },
        { 11, "g729A" },
        { 12, "is11172" },
        { 13, "is13818" },
        { 14, "g729B" },
        { 15, "g729AB" },
        { 16, "g7231C" },
        { 17, "gsmFR" },
        { 18, "gsmHR" },
        { 19, "gsmEFR" },
        { 20, "generic" },
        { 21, "g729Ext" },
        { 22, "vbd" },
        { 23, "audioTelEvent" },
        { 24, "audioTone" },
        {  0, NULL }
};

/* To put the codec type only in COL_INFO when
   an OLC is read */

char* codec_type = NULL;
static char standard_oid_str[256];
static guint32 ipv4_address;
static guint32 ipv4_port;
static guint32 rtcp_ipv4_address;
static guint32 rtcp_ipv4_port;
static gboolean media_channel;
static gboolean media_control_channel;
static guint32 t35CountryCode;
static guint32 t35Extension;
static guint32 manufacturerCode;
static guint32 h221NonStandard;

static const value_string h245_RFC_number_vals[] = {
	{  2190,	"RFC 2190 - H.263 Video Streams" },
	{  2429,	"RFC 2429 - 1998 Version of ITU-T Rec. H.263 Video (H.263+)" },
	{  3267,	"RFC 3267 - Adaptive Multi-Rate (AMR) and Adaptive Multi-Rate Wideband (AMR-WB)" },
	{  0, NULL }
};
/* Initialize the protocol and registered fields */
int proto_h245 = -1;

/*--- Included file: packet-h245-hf.c ---*/

static int hf_h245_request = -1;                  /* RequestMessage */
static int hf_h245_response = -1;                 /* ResponseMessage */
static int hf_h245_command = -1;                  /* CommandMessage */
static int hf_h245_indication = -1;               /* IndicationMessage */
static int hf_h245_nonStandardMsg = -1;           /* NonStandardMessage */
static int hf_h245_masterSlaveDetermination = -1;  /* MasterSlaveDetermination */
static int hf_h245_terminalCapabilitySet = -1;    /* TerminalCapabilitySet */
static int hf_h245_openLogicalChannel = -1;       /* OpenLogicalChannel */
static int hf_h245_closeLogicalChannel = -1;      /* CloseLogicalChannel */
static int hf_h245_requestChannelClose = -1;      /* RequestChannelClose */
static int hf_h245_multiplexEntrySend = -1;       /* MultiplexEntrySend */
static int hf_h245_requestMultiplexEntry = -1;    /* RequestMultiplexEntry */
static int hf_h245_requestMode = -1;              /* RequestMode */
static int hf_h245_roundTripDelayRequest = -1;    /* RoundTripDelayRequest */
static int hf_h245_maintenanceLoopRequest = -1;   /* MaintenanceLoopRequest */
static int hf_h245_communicationModeRequest = -1;  /* CommunicationModeRequest */
static int hf_h245_conferenceRequest = -1;        /* ConferenceRequest */
static int hf_h245_multilinkRequest = -1;         /* MultilinkRequest */
static int hf_h245_logicalChannelRateRequest = -1;  /* LogicalChannelRateRequest */
static int hf_h245_genericRequest = -1;           /* GenericMessage */
static int hf_h245_masterSlaveDeterminationAck = -1;  /* MasterSlaveDeterminationAck */
static int hf_h245_masterSlaveDeterminationReject = -1;  /* MasterSlaveDeterminationReject */
static int hf_h245_terminalCapabilitySetAck = -1;  /* TerminalCapabilitySetAck */
static int hf_h245_terminalCapabilitySetReject = -1;  /* TerminalCapabilitySetReject */
static int hf_h245_openLogicalChannelAck = -1;    /* OpenLogicalChannelAck */
static int hf_h245_openLogicalChannelReject = -1;  /* OpenLogicalChannelReject */
static int hf_h245_closeLogicalChannelAck = -1;   /* CloseLogicalChannelAck */
static int hf_h245_requestChannelCloseAck = -1;   /* RequestChannelCloseAck */
static int hf_h245_requestChannelCloseReject = -1;  /* RequestChannelCloseReject */
static int hf_h245_multiplexEntrySendAck = -1;    /* MultiplexEntrySendAck */
static int hf_h245_multiplexEntrySendReject = -1;  /* MultiplexEntrySendReject */
static int hf_h245_requestMultiplexEntryAck = -1;  /* RequestMultiplexEntryAck */
static int hf_h245_requestMultiplexEntryReject = -1;  /* RequestMultiplexEntryReject */
static int hf_h245_requestModeAck = -1;           /* RequestModeAck */
static int hf_h245_requestModeReject = -1;        /* RequestModeReject */
static int hf_h245_roundTripDelayResponse = -1;   /* RoundTripDelayResponse */
static int hf_h245_maintenanceLoopAck = -1;       /* MaintenanceLoopAck */
static int hf_h245_maintenanceLoopReject = -1;    /* MaintenanceLoopReject */
static int hf_h245_communicationModeResponse = -1;  /* CommunicationModeResponse */
static int hf_h245_conferenceResponse = -1;       /* ConferenceResponse */
static int hf_h245_multilinkResponse = -1;        /* MultilinkResponse */
static int hf_h245_logicalChannelRateAcknowledge = -1;  /* LogicalChannelRateAcknowledge */
static int hf_h245_logicalChannelRateReject = -1;  /* LogicalChannelRateReject */
static int hf_h245_genericResponse = -1;          /* GenericMessage */
static int hf_h245_maintenanceLoopOffCommand = -1;  /* MaintenanceLoopOffCommand */
static int hf_h245_sendTerminalCapabilitySet = -1;  /* SendTerminalCapabilitySet */
static int hf_h245_encryptionCommand = -1;        /* EncryptionCommand */
static int hf_h245_flowControlCommand = -1;       /* FlowControlCommand */
static int hf_h245_endSessionCommand = -1;        /* EndSessionCommand */
static int hf_h245_miscellaneousCommand = -1;     /* MiscellaneousCommand */
static int hf_h245_communicationModeCommand = -1;  /* CommunicationModeCommand */
static int hf_h245_conferenceCommand = -1;        /* ConferenceCommand */
static int hf_h245_h223MultiplexReconfiguration = -1;  /* H223MultiplexReconfiguration */
static int hf_h245_newATMVCCommand = -1;          /* NewATMVCCommand */
static int hf_h245_mobileMultilinkReconfigurationCommand = -1;  /* MobileMultilinkReconfigurationCommand */
static int hf_h245_genericCommand = -1;           /* GenericMessage */
static int hf_h245_functionNotUnderstood = -1;    /* FunctionNotUnderstood */
static int hf_h245_masterSlaveDeterminationRelease = -1;  /* MasterSlaveDeterminationRelease */
static int hf_h245_terminalCapabilitySetRelease = -1;  /* TerminalCapabilitySetRelease */
static int hf_h245_openLogicalChannelConfirm = -1;  /* OpenLogicalChannelConfirm */
static int hf_h245_requestChannelCloseRelease = -1;  /* RequestChannelCloseRelease */
static int hf_h245_multiplexEntrySendRelease = -1;  /* MultiplexEntrySendRelease */
static int hf_h245_requestMultiplexEntryRelease = -1;  /* RequestMultiplexEntryRelease */
static int hf_h245_requestModeRelease = -1;       /* RequestModeRelease */
static int hf_h245_miscellaneousIndication = -1;  /* MiscellaneousIndication */
static int hf_h245_jitterIndication = -1;         /* JitterIndication */
static int hf_h245_h223SkewIndication = -1;       /* H223SkewIndication */
static int hf_h245_newATMVCIndication = -1;       /* NewATMVCIndication */
static int hf_h245_userInput = -1;                /* UserInputIndication */
static int hf_h245_h2250MaximumSkewIndication = -1;  /* H2250MaximumSkewIndication */
static int hf_h245_mcLocationIndication = -1;     /* MCLocationIndication */
static int hf_h245_conferenceIndication = -1;     /* ConferenceIndication */
static int hf_h245_vendorIdentification = -1;     /* VendorIdentification */
static int hf_h245_functionNotSupported = -1;     /* FunctionNotSupported */
static int hf_h245_multilinkIndication = -1;      /* MultilinkIndication */
static int hf_h245_logicalChannelRateRelease = -1;  /* LogicalChannelRateRelease */
static int hf_h245_flowControlIndication = -1;    /* FlowControlIndication */
static int hf_h245_mobileMultilinkReconfigurationIndication = -1;  /* MobileMultilinkReconfigurationIndication */
static int hf_h245_genericIndication = -1;        /* GenericMessage */
static int hf_h245_messageIdentifier = -1;        /* CapabilityIdentifier */
static int hf_h245_subMessageIdentifer = -1;      /* T_subMessageIdentifer */
static int hf_h245_messageContent = -1;           /* SEQUENCE_OF_GenericParameter */
static int hf_h245_messageContent_item = -1;      /* GenericParameter */
static int hf_h245_nonStandardData = -1;          /* NonStandardParameter */
static int hf_h245_nonStandardIdentifier = -1;    /* NonStandardIdentifier */
static int hf_h245_nsd_data = -1;                 /* OCTET_STRING */
static int hf_h245_object = -1;                   /* OBJECT_IDENTIFIER */
static int hf_h245_h221NonStandardID = -1;        /* H221NonStandardID */
static int hf_h245_t35CountryCode = -1;           /* T_t35CountryCode */
static int hf_h245_t35Extension = -1;             /* T_t35Extension */
static int hf_h245_manufacturerCode = -1;         /* T_manufacturerCode */
static int hf_h245_terminalType = -1;             /* INTEGER_0_255 */
static int hf_h245_statusDeterminationNumber = -1;  /* INTEGER_0_16777215 */
static int hf_h245_decision = -1;                 /* T_decision */
static int hf_h245_master = -1;                   /* NULL */
static int hf_h245_slave = -1;                    /* NULL */
static int hf_h245_msd_rej_cause = -1;            /* MasterSlaveDeterminationRejectCause */
static int hf_h245_identicalNumbers = -1;         /* NULL */
static int hf_h245_sequenceNumber = -1;           /* SequenceNumber */
static int hf_h245_protocolIdentifier = -1;       /* OBJECT_IDENTIFIER */
static int hf_h245_multiplexCapability = -1;      /* MultiplexCapability */
static int hf_h245_capabilityTable = -1;          /* SET_SIZE_1_256_OF_CapabilityTableEntry */
static int hf_h245_capabilityTable_item = -1;     /* CapabilityTableEntry */
static int hf_h245_capabilityDescriptors = -1;    /* SET_SIZE_1_256_OF_CapabilityDescriptor */
static int hf_h245_capabilityDescriptors_item = -1;  /* CapabilityDescriptor */
static int hf_h245_capabilityTableEntryNumber = -1;  /* CapabilityTableEntryNumber */
static int hf_h245_capability = -1;               /* Capability */
static int hf_h245_capabilityDescriptorNumber = -1;  /* CapabilityDescriptorNumber */
static int hf_h245_simultaneousCapabilities = -1;  /* SET_SIZE_1_256_OF_AlternativeCapabilitySet */
static int hf_h245_simultaneousCapabilities_item = -1;  /* AlternativeCapabilitySet */
static int hf_h245_AlternativeCapabilitySet_item = -1;  /* CapabilityTableEntryNumber */
static int hf_h245_tcs_rej_cause = -1;            /* TerminalCapabilitySetRejectCause */
static int hf_h245_unspecified = -1;              /* NULL */
static int hf_h245_undefinedTableEntryUsed = -1;  /* NULL */
static int hf_h245_descriptorCapacityExceeded = -1;  /* NULL */
static int hf_h245_tableEntryCapacityExceeded = -1;  /* T_tableEntryCapacityExceeded */
static int hf_h245_highestEntryNumberProcessed = -1;  /* CapabilityTableEntryNumber */
static int hf_h245_noneProcessed = -1;            /* NULL */
static int hf_h245_nonStandard = -1;              /* NonStandardParameter */
static int hf_h245_receiveVideoCapability = -1;   /* VideoCapability */
static int hf_h245_transmitVideoCapability = -1;  /* VideoCapability */
static int hf_h245_receiveAndTransmitVideoCapability = -1;  /* VideoCapability */
static int hf_h245_receiveAudioCapability = -1;   /* AudioCapability */
static int hf_h245_transmitAudioCapability = -1;  /* AudioCapability */
static int hf_h245_receiveAndTransmitAudioCapability = -1;  /* AudioCapability */
static int hf_h245_receiveDataApplicationCapability = -1;  /* DataApplicationCapability */
static int hf_h245_transmitDataApplicationCapability = -1;  /* DataApplicationCapability */
static int hf_h245_receiveAndTransmitDataApplicationCapability = -1;  /* DataApplicationCapability */
static int hf_h245_h233EncryptionTransmitCapability = -1;  /* BOOLEAN */
static int hf_h245_h233EncryptionReceiveCapability = -1;  /* T_h233EncryptionReceiveCapability */
static int hf_h245_h233IVResponseTime = -1;       /* INTEGER_0_255 */
static int hf_h245_conferenceCapability = -1;     /* ConferenceCapability */
static int hf_h245_h235SecurityCapability = -1;   /* H235SecurityCapability */
static int hf_h245_maxPendingReplacementFor = -1;  /* INTEGER_0_255 */
static int hf_h245_receiveUserInputCapability = -1;  /* UserInputCapability */
static int hf_h245_transmitUserInputCapability = -1;  /* UserInputCapability */
static int hf_h245_receiveAndTransmitUserInputCapability = -1;  /* UserInputCapability */
static int hf_h245_genericControlCapability = -1;  /* GenericCapability */
static int hf_h245_receiveMultiplexedStreamCapability = -1;  /* MultiplexedStreamCapability */
static int hf_h245_transmitMultiplexedStreamCapability = -1;  /* MultiplexedStreamCapability */
static int hf_h245_receiveAndTransmitMultiplexedStreamCapability = -1;  /* MultiplexedStreamCapability */
static int hf_h245_receiveRTPAudioTelephonyEventCapability = -1;  /* AudioTelephonyEventCapability */
static int hf_h245_receiveRTPAudioToneCapability = -1;  /* AudioToneCapability */
static int hf_h245_fecCapability = -1;            /* FECCapability */
static int hf_h245_multiplePayloadStreamCapability = -1;  /* MultiplePayloadStreamCapability */
static int hf_h245_encryptionAuthenticationAndIntegrity = -1;  /* EncryptionAuthenticationAndIntegrity */
static int hf_h245_mediaCapability = -1;          /* CapabilityTableEntryNumber */
static int hf_h245_h222Capability = -1;           /* H222Capability */
static int hf_h245_h223Capability = -1;           /* H223Capability */
static int hf_h245_v76Capability = -1;            /* V76Capability */
static int hf_h245_h2250Capability = -1;          /* H2250Capability */
static int hf_h245_genericMultiplexCapability = -1;  /* GenericCapability */
static int hf_h245_numberOfVCs = -1;              /* INTEGER_1_256 */
static int hf_h245_vcCapability = -1;             /* SET_OF_VCCapability */
static int hf_h245_vcCapability_item = -1;        /* VCCapability */
static int hf_h245_aal1 = -1;                     /* T_aal1 */
static int hf_h245_nullClockRecovery = -1;        /* BOOLEAN */
static int hf_h245_srtsClockRecovery_bool = -1;   /* BOOLEAN */
static int hf_h245_adaptiveClockRecovery = -1;    /* BOOLEAN */
static int hf_h245_nullErrorCorrection = -1;      /* BOOLEAN */
static int hf_h245_longInterleaver = -1;          /* BOOLEAN */
static int hf_h245_shortInterleaver = -1;         /* BOOLEAN */
static int hf_h245_errorCorrectionOnly = -1;      /* BOOLEAN */
static int hf_h245_structuredDataTransfer = -1;   /* BOOLEAN */
static int hf_h245_partiallyFilledCells = -1;     /* BOOLEAN */
static int hf_h245_aal5 = -1;                     /* T_aal5 */
static int hf_h245_forwardMaximumSDUSize = -1;    /* INTEGER_0_65535 */
static int hf_h245_backwardMaximumSDUSize = -1;   /* INTEGER_0_65535 */
static int hf_h245_transportStream_bool = -1;     /* BOOLEAN */
static int hf_h245_programStream = -1;            /* BOOLEAN */
static int hf_h245_availableBitRates = -1;        /* T_availableBitRates */
static int hf_h245_Avb_type = -1;                 /* Avb_type */
static int hf_h245_singleBitRate = -1;            /* INTEGER_1_65535 */
static int hf_h245_rangeOfBitRates = -1;          /* T_rangeOfBitRates */
static int hf_h245_lowerBitRate = -1;             /* INTEGER_1_65535 */
static int hf_h245_higherBitRate = -1;            /* INTEGER_1_65535 */
static int hf_h245_aal1ViaGateway = -1;           /* T_aal1ViaGateway */
static int hf_h245_gatewayAddress = -1;           /* SET_SIZE_1_256_OF_Q2931Address */
static int hf_h245_gatewayAddress_item = -1;      /* Q2931Address */
static int hf_h245_srtsClockRecoveryflag = -1;    /* BOOLEAN */
static int hf_h245_transportWithI_frames = -1;    /* BOOLEAN */
static int hf_h245_videoWithAL1 = -1;             /* BOOLEAN */
static int hf_h245_videoWithAL2 = -1;             /* BOOLEAN */
static int hf_h245_videoWithAL3 = -1;             /* BOOLEAN */
static int hf_h245_audioWithAL1 = -1;             /* BOOLEAN */
static int hf_h245_audioWithAL2 = -1;             /* BOOLEAN */
static int hf_h245_audioWithAL3 = -1;             /* BOOLEAN */
static int hf_h245_dataWithAL1 = -1;              /* BOOLEAN */
static int hf_h245_dataWithAL2 = -1;              /* BOOLEAN */
static int hf_h245_dataWithAL3 = -1;              /* BOOLEAN */
static int hf_h245_maximumAl2SDUSize = -1;        /* INTEGER_0_65535 */
static int hf_h245_maximumAl3SDUSize = -1;        /* INTEGER_0_65535 */
static int hf_h245_maximumDelayJitter = -1;       /* INTEGER_0_1023 */
static int hf_h245_h223MultiplexTableCapability = -1;  /* T_h223MultiplexTableCapability */
static int hf_h245_basic = -1;                    /* NULL */
static int hf_h245_enhanced = -1;                 /* T_enhanced */
static int hf_h245_maximumNestingDepth = -1;      /* INTEGER_1_15 */
static int hf_h245_maximumElementListSize = -1;   /* INTEGER_2_255 */
static int hf_h245_maximumSubElementListSize = -1;  /* INTEGER_2_255 */
static int hf_h245_maxMUXPDUSizeCapability = -1;  /* BOOLEAN */
static int hf_h245_nsrpSupport = -1;              /* BOOLEAN */
static int hf_h245_mobileOperationTransmitCapability = -1;  /* T_mobileOperationTransmitCapability */
static int hf_h245_modeChangeCapability = -1;     /* BOOLEAN */
static int hf_h245_h223AnnexA = -1;               /* BOOLEAN */
static int hf_h245_h223AnnexADoubleFlagFlag = -1;  /* BOOLEAN */
static int hf_h245_h223AnnexB = -1;               /* BOOLEAN */
static int hf_h245_h223AnnexBwithHeader = -1;     /* BOOLEAN */
static int hf_h245_h223AnnexCCapability = -1;     /* H223AnnexCCapability */
static int hf_h245_bitRate_1_19200 = -1;          /* INTEGER_1_19200 */
static int hf_h245_mobileMultilinkFrameCapability = -1;  /* T_mobileMultilinkFrameCapability */
static int hf_h245_maximumSampleSize = -1;        /* INTEGER_1_255 */
static int hf_h245_maximumPayloadLength = -1;     /* INTEGER_1_65025 */
static int hf_h245_videoWithAL1M = -1;            /* BOOLEAN */
static int hf_h245_videoWithAL2M = -1;            /* BOOLEAN */
static int hf_h245_videoWithAL3M = -1;            /* BOOLEAN */
static int hf_h245_audioWithAL1M = -1;            /* BOOLEAN */
static int hf_h245_audioWithAL2M = -1;            /* BOOLEAN */
static int hf_h245_audioWithAL3M = -1;            /* BOOLEAN */
static int hf_h245_dataWithAL1M = -1;             /* BOOLEAN */
static int hf_h245_dataWithAL2M = -1;             /* BOOLEAN */
static int hf_h245_dataWithAL3M = -1;             /* BOOLEAN */
static int hf_h245_alpduInterleaving = -1;        /* BOOLEAN */
static int hf_h245_maximumAL1MPDUSize = -1;       /* INTEGER_0_65535 */
static int hf_h245_maximumAL2MSDUSize = -1;       /* INTEGER_0_65535 */
static int hf_h245_maximumAL3MSDUSize = -1;       /* INTEGER_0_65535 */
static int hf_h245_rsCodeCapability = -1;         /* BOOLEAN */
static int hf_h245_suspendResumeCapabilitywAddress = -1;  /* BOOLEAN */
static int hf_h245_suspendResumeCapabilitywoAddress = -1;  /* BOOLEAN */
static int hf_h245_rejCapability = -1;            /* BOOLEAN */
static int hf_h245_sREJCapability = -1;           /* BOOLEAN */
static int hf_h245_mREJCapability = -1;           /* BOOLEAN */
static int hf_h245_crc8bitCapability = -1;        /* BOOLEAN */
static int hf_h245_crc16bitCapability = -1;       /* BOOLEAN */
static int hf_h245_crc32bitCapability = -1;       /* BOOLEAN */
static int hf_h245_uihCapability = -1;            /* BOOLEAN */
static int hf_h245_numOfDLCS = -1;                /* INTEGER_2_8191 */
static int hf_h245_twoOctetAddressFieldCapability = -1;  /* BOOLEAN */
static int hf_h245_loopBackTestCapability = -1;   /* BOOLEAN */
static int hf_h245_n401Capability = -1;           /* INTEGER_1_4095 */
static int hf_h245_maxWindowSizeCapability = -1;  /* INTEGER_1_127 */
static int hf_h245_v75Capability = -1;            /* V75Capability */
static int hf_h245_audioHeader = -1;              /* BOOLEAN */
static int hf_h245_maximumAudioDelayJitter = -1;  /* INTEGER_0_1023 */
static int hf_h245_receiveMultipointCapability = -1;  /* MultipointCapability */
static int hf_h245_transmitMultipointCapability = -1;  /* MultipointCapability */
static int hf_h245_receiveAndTransmitMultipointCapability = -1;  /* MultipointCapability */
static int hf_h245_mcCapability = -1;             /* T_mcCapability */
static int hf_h245_centralizedConferenceMC = -1;  /* BOOLEAN */
static int hf_h245_decentralizedConferenceMC = -1;  /* BOOLEAN */
static int hf_h245_rtcpVideoControlCapability = -1;  /* BOOLEAN */
static int hf_h245_mediaPacketizationCapability = -1;  /* MediaPacketizationCapability */
static int hf_h245_transportCapability = -1;      /* TransportCapability */
static int hf_h245_redundancyEncodingCapability = -1;  /* SEQUENCE_SIZE_1_256_OF_RedundancyEncodingCapability */
static int hf_h245_redundancyEncodingCapability_item = -1;  /* RedundancyEncodingCapability */
static int hf_h245_logicalChannelSwitchingCapability = -1;  /* BOOLEAN */
static int hf_h245_t120DynamicPortCapability = -1;  /* BOOLEAN */
static int hf_h245_h261aVideoPacketization = -1;  /* BOOLEAN */
static int hf_h245_rtpPayloadType2 = -1;          /* SEQUENCE_SIZE_1_256_OF_RTPPayloadType */
static int hf_h245_rtpPayloadType2_item = -1;     /* RTPPayloadType */
static int hf_h245_qosMode = -1;                  /* QOSMode */
static int hf_h245_tokenRate = -1;                /* INTEGER_1_4294967295 */
static int hf_h245_bucketSize = -1;               /* INTEGER_1_4294967295 */
static int hf_h245_peakRate = -1;                 /* INTEGER_1_4294967295 */
static int hf_h245_minPoliced = -1;               /* INTEGER_1_4294967295 */
static int hf_h245_maxPktSize = -1;               /* INTEGER_1_4294967295 */
static int hf_h245_guaranteedQOS = -1;            /* NULL */
static int hf_h245_controlledLoad = -1;           /* NULL */
static int hf_h245_maxNTUSize = -1;               /* INTEGER_0_65535 */
static int hf_h245_atmUBR = -1;                   /* BOOLEAN */
static int hf_h245_atmrtVBR = -1;                 /* BOOLEAN */
static int hf_h245_atmnrtVBR = -1;                /* BOOLEAN */
static int hf_h245_atmABR = -1;                   /* BOOLEAN */
static int hf_h245_atmCBR = -1;                   /* BOOLEAN */
static int hf_h245_rsvpParameters = -1;           /* RSVPParameters */
static int hf_h245_atmParameters = -1;            /* ATMParameters */
static int hf_h245_ip_UDP = -1;                   /* NULL */
static int hf_h245_ip_TCP = -1;                   /* NULL */
static int hf_h245_atm_AAL5_UNIDIR = -1;          /* NULL */
static int hf_h245_atm_AAL5_BIDIR = -1;           /* NULL */
static int hf_h245_atm_AAL5_compressed = -1;      /* T_atm_AAL5_compressed */
static int hf_h245_variable_delta = -1;           /* BOOLEAN */
static int hf_h245_mediaTransport = -1;           /* MediaTransportType */
static int hf_h245_qOSCapabilities = -1;          /* SEQUENCE_SIZE_1_256_OF_QOSCapability */
static int hf_h245_qOSCapabilities_item = -1;     /* QOSCapability */
static int hf_h245_mediaChannelCapabilities = -1;  /* SEQUENCE_SIZE_1_256_OF_MediaChannelCapability */
static int hf_h245_mediaChannelCapabilities_item = -1;  /* MediaChannelCapability */
static int hf_h245_redundancyEncodingMethod = -1;  /* RedundancyEncodingMethod */
static int hf_h245_primaryEncoding = -1;          /* CapabilityTableEntryNumber */
static int hf_h245_secondaryEncoding2 = -1;       /* SEQUENCE_SIZE_1_256_OF_CapabilityTableEntryNumber */
static int hf_h245_secondaryEncoding2_item = -1;  /* CapabilityTableEntryNumber */
static int hf_h245_rtpAudioRedundancyEncoding = -1;  /* NULL */
static int hf_h245_rtpH263VideoRedundancyEncoding = -1;  /* RTPH263VideoRedundancyEncoding */
static int hf_h245_numberOfThreads = -1;          /* INTEGER_1_16 */
static int hf_h245_framesBetweenSyncPoints = -1;  /* INTEGER_1_256 */
static int hf_h245_frameToThreadMapping = -1;     /* T_frameToThreadMapping */
static int hf_h245_roundrobin = -1;               /* NULL */
static int hf_h245_custom = -1;                   /* SEQUENCE_SIZE_1_256_OF_RTPH263VideoRedundancyFrameMapping */
static int hf_h245_custom_item = -1;              /* RTPH263VideoRedundancyFrameMapping */
static int hf_h245_containedThreads = -1;         /* T_containedThreads */
static int hf_h245_containedThreads_item = -1;    /* INTEGER_0_15 */
static int hf_h245_threadNumber = -1;             /* INTEGER_0_15 */
static int hf_h245_frameSequence = -1;            /* T_frameSequence */
static int hf_h245_frameSequence_item = -1;       /* INTEGER_0_255 */
static int hf_h245_multicastCapability = -1;      /* BOOLEAN */
static int hf_h245_multiUniCastConference = -1;   /* BOOLEAN */
static int hf_h245_mediaDistributionCapability = -1;  /* SEQUENCE_OF_MediaDistributionCapability */
static int hf_h245_mediaDistributionCapability_item = -1;  /* MediaDistributionCapability */
static int hf_h245_centralizedControl = -1;       /* BOOLEAN */
static int hf_h245_distributedControl = -1;       /* BOOLEAN */
static int hf_h245_centralizedAudio = -1;         /* BOOLEAN */
static int hf_h245_distributedAudio = -1;         /* BOOLEAN */
static int hf_h245_centralizedVideo = -1;         /* BOOLEAN */
static int hf_h245_distributedVideo = -1;         /* BOOLEAN */
static int hf_h245_centralizedData = -1;          /* SEQUENCE_OF_DataApplicationCapability */
static int hf_h245_centralizedData_item = -1;     /* DataApplicationCapability */
static int hf_h245_distributedData = -1;          /* SEQUENCE_OF_DataApplicationCapability */
static int hf_h245_distributedData_item = -1;     /* DataApplicationCapability */
static int hf_h245_h261VideoCapability = -1;      /* H261VideoCapability */
static int hf_h245_h262VideoCapability = -1;      /* H262VideoCapability */
static int hf_h245_h263VideoCapability = -1;      /* H263VideoCapability */
static int hf_h245_is11172VideoCapability = -1;   /* IS11172VideoCapability */
static int hf_h245_genericVideoCapability = -1;   /* GenericCapability */
static int hf_h245_extendedVideoCapability = -1;  /* ExtendedVideoCapability */
static int hf_h245_videoCapability = -1;          /* SEQUENCE_OF_VideoCapability */
static int hf_h245_videoCapability_item = -1;     /* VideoCapability */
static int hf_h245_videoCapabilityExtension = -1;  /* SEQUENCE_OF_GenericCapability */
static int hf_h245_videoCapabilityExtension_item = -1;  /* GenericCapability */
static int hf_h245_qcifMPI_1_4 = -1;              /* INTEGER_1_4 */
static int hf_h245_cifMPI_1_4 = -1;               /* INTEGER_1_4 */
static int hf_h245_temporalSpatialTradeOffCapability = -1;  /* BOOLEAN */
static int hf_h245_maxBitRate_1_19200 = -1;       /* INTEGER_1_19200 */
static int hf_h245_stillImageTransmission = -1;   /* BOOLEAN */
static int hf_h245_videoBadMBsCap = -1;           /* BOOLEAN */
static int hf_h245_profileAndLevel_SPatML = -1;   /* BOOLEAN */
static int hf_h245_profileAndLevel_MPatLL = -1;   /* BOOLEAN */
static int hf_h245_profileAndLevel_MPatML = -1;   /* BOOLEAN */
static int hf_h245_profileAndLevel_MPatH_14 = -1;  /* BOOLEAN */
static int hf_h245_profileAndLevel_MPatHL = -1;   /* BOOLEAN */
static int hf_h245_profileAndLevel_SNRatLL = -1;  /* BOOLEAN */
static int hf_h245_profileAndLevel_SNRatML = -1;  /* BOOLEAN */
static int hf_h245_profileAndLevel_SpatialatH_14 = -1;  /* BOOLEAN */
static int hf_h245_profileAndLevel_HPatML = -1;   /* BOOLEAN */
static int hf_h245_profileAndLevel_HPatH_14 = -1;  /* BOOLEAN */
static int hf_h245_profileAndLevel_HPatHL = -1;   /* BOOLEAN */
static int hf_h245_videoBitRate = -1;             /* INTEGER_0_1073741823 */
static int hf_h245_vbvBufferSize = -1;            /* INTEGER_0_262143 */
static int hf_h245_samplesPerLine = -1;           /* INTEGER_0_16383 */
static int hf_h245_linesPerFrame = -1;            /* INTEGER_0_16383 */
static int hf_h245_framesPerSecond = -1;          /* INTEGER_0_15 */
static int hf_h245_luminanceSampleRate = -1;      /* INTEGER_0_4294967295 */
static int hf_h245_sqcifMPI_1_32 = -1;            /* INTEGER_1_32 */
static int hf_h245_qcifMPI = -1;                  /* INTEGER_1_32 */
static int hf_h245_cifMPI = -1;                   /* INTEGER_1_32 */
static int hf_h245_cif4MPI_1_32 = -1;             /* INTEGER_1_32 */
static int hf_h245_cif16MPI_1_32 = -1;            /* INTEGER_1_32 */
static int hf_h245_maxBitRate = -1;               /* INTEGER_1_192400 */
static int hf_h245_unrestrictedVector = -1;       /* BOOLEAN */
static int hf_h245_arithmeticCoding = -1;         /* BOOLEAN */
static int hf_h245_advancedPrediction = -1;       /* BOOLEAN */
static int hf_h245_pbFrames = -1;                 /* BOOLEAN */
static int hf_h245_hrd_B = -1;                    /* INTEGER_0_524287 */
static int hf_h245_bppMaxKb = -1;                 /* INTEGER_0_65535 */
static int hf_h245_slowSqcifMPI = -1;             /* INTEGER_1_3600 */
static int hf_h245_slowQcifMPI = -1;              /* INTEGER_1_3600 */
static int hf_h245_slowCifMPI = -1;               /* INTEGER_1_3600 */
static int hf_h245_slowCif4MPI = -1;              /* INTEGER_1_3600 */
static int hf_h245_slowCif16MPI = -1;             /* INTEGER_1_3600 */
static int hf_h245_errorCompensation = -1;        /* BOOLEAN */
static int hf_h245_enhancementLayerInfo = -1;     /* EnhancementLayerInfo */
static int hf_h245_h263Options = -1;              /* H263Options */
static int hf_h245_baseBitRateConstrained = -1;   /* BOOLEAN */
static int hf_h245_snrEnhancement = -1;           /* SET_SIZE_1_14_OF_EnhancementOptions */
static int hf_h245_snrEnhancement_item = -1;      /* EnhancementOptions */
static int hf_h245_spatialEnhancement = -1;       /* SET_SIZE_1_14_OF_EnhancementOptions */
static int hf_h245_spatialEnhancement_item = -1;  /* EnhancementOptions */
static int hf_h245_bPictureEnhancement = -1;      /* SET_SIZE_1_14_OF_BEnhancementParameters */
static int hf_h245_bPictureEnhancement_item = -1;  /* BEnhancementParameters */
static int hf_h245_enhancementOptions = -1;       /* EnhancementOptions */
static int hf_h245_numberOfBPictures = -1;        /* INTEGER_1_64 */
static int hf_h245_advancedIntraCodingMode = -1;  /* BOOLEAN */
static int hf_h245_deblockingFilterMode = -1;     /* BOOLEAN */
static int hf_h245_improvedPBFramesMode = -1;     /* BOOLEAN */
static int hf_h245_unlimitedMotionVectors = -1;   /* BOOLEAN */
static int hf_h245_fullPictureFreeze = -1;        /* BOOLEAN */
static int hf_h245_partialPictureFreezeAndRelease = -1;  /* BOOLEAN */
static int hf_h245_resizingPartPicFreezeAndRelease = -1;  /* BOOLEAN */
static int hf_h245_fullPictureSnapshot = -1;      /* BOOLEAN */
static int hf_h245_partialPictureSnapshot = -1;   /* BOOLEAN */
static int hf_h245_videoSegmentTagging = -1;      /* BOOLEAN */
static int hf_h245_progressiveRefinement = -1;    /* BOOLEAN */
static int hf_h245_dynamicPictureResizingByFour = -1;  /* BOOLEAN */
static int hf_h245_dynamicPictureResizingSixteenthPel = -1;  /* BOOLEAN */
static int hf_h245_dynamicWarpingHalfPel = -1;    /* BOOLEAN */
static int hf_h245_dynamicWarpingSixteenthPel = -1;  /* BOOLEAN */
static int hf_h245_independentSegmentDecoding = -1;  /* BOOLEAN */
static int hf_h245_slicesInOrder_NonRect = -1;    /* BOOLEAN */
static int hf_h245_slicesInOrder_Rect = -1;       /* BOOLEAN */
static int hf_h245_slicesNoOrder_NonRect = -1;    /* BOOLEAN */
static int hf_h245_slicesNoOrder_Rect = -1;       /* BOOLEAN */
static int hf_h245_alternateInterVLCMode = -1;    /* BOOLEAN */
static int hf_h245_modifiedQuantizationMode = -1;  /* BOOLEAN */
static int hf_h245_reducedResolutionUpdate = -1;  /* BOOLEAN */
static int hf_h245_transparencyParameters = -1;   /* TransparencyParameters */
static int hf_h245_separateVideoBackChannel = -1;  /* BOOLEAN */
static int hf_h245_refPictureSelection = -1;      /* RefPictureSelection */
static int hf_h245_customPictureClockFrequency = -1;  /* SET_SIZE_1_16_OF_CustomPictureClockFrequency */
static int hf_h245_customPictureClockFrequency_item = -1;  /* CustomPictureClockFrequency */
static int hf_h245_customPictureFormat = -1;      /* SET_SIZE_1_16_OF_CustomPictureFormat */
static int hf_h245_customPictureFormat_item = -1;  /* CustomPictureFormat */
static int hf_h245_modeCombos = -1;               /* SET_SIZE_1_16_OF_H263VideoModeCombos */
static int hf_h245_modeCombos_item = -1;          /* H263VideoModeCombos */
static int hf_h245_h263Version3Options = -1;      /* H263Version3Options */
static int hf_h245_presentationOrder = -1;        /* INTEGER_1_256 */
static int hf_h245_offset_x = -1;                 /* INTEGER_M262144_262143 */
static int hf_h245_offset_y = -1;                 /* INTEGER_M262144_262143 */
static int hf_h245_scale_x = -1;                  /* INTEGER_1_255 */
static int hf_h245_scale_y = -1;                  /* INTEGER_1_255 */
static int hf_h245_additionalPictureMemory = -1;  /* T_additionalPictureMemory */
static int hf_h245_sqcifAdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_qcifAdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_cifAdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_cif4AdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_cif16AdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_bigCpfAdditionalPictureMemory = -1;  /* INTEGER_1_256 */
static int hf_h245_videoMux = -1;                 /* BOOLEAN */
static int hf_h245_videoBackChannelSend = -1;     /* T_videoBackChannelSend */
static int hf_h245_none = -1;                     /* NULL */
static int hf_h245_ackMessageOnly = -1;           /* NULL */
static int hf_h245_nackMessageOnly = -1;          /* NULL */
static int hf_h245_ackOrNackMessageOnly = -1;     /* NULL */
static int hf_h245_ackAndNackMessage = -1;        /* NULL */
static int hf_h245_enhancedReferencePicSelect = -1;  /* T_enhancedReferencePicSelect */
static int hf_h245_subPictureRemovalParameters = -1;  /* T_subPictureRemovalParameters */
static int hf_h245_mpuHorizMBs = -1;              /* INTEGER_1_128 */
static int hf_h245_mpuVertMBs = -1;               /* INTEGER_1_72 */
static int hf_h245_mpuTotalNumber = -1;           /* INTEGER_1_65536 */
static int hf_h245_clockConversionCode = -1;      /* INTEGER_1000_1001 */
static int hf_h245_clockDivisor = -1;             /* INTEGER_1_127 */
static int hf_h245_sqcifMPI = -1;                 /* INTEGER_1_2048 */
static int hf_h245_qcifMPI_1_2048 = -1;           /* INTEGER_1_2048 */
static int hf_h245_cifMPI2_1_2048 = -1;           /* INTEGER_1_2048 */
static int hf_h245_cif4MPI = -1;                  /* INTEGER_1_2048 */
static int hf_h245_cif16MPI = -1;                 /* INTEGER_1_2048 */
static int hf_h245_maxCustomPictureWidth = -1;    /* INTEGER_1_2048 */
static int hf_h245_maxCustomPictureHeight = -1;   /* INTEGER_1_2048 */
static int hf_h245_minCustomPictureWidth = -1;    /* INTEGER_1_2048 */
static int hf_h245_minCustomPictureHeight = -1;   /* INTEGER_1_2048 */
static int hf_h245_mPI = -1;                      /* T_mPI */
static int hf_h245_standardMPI = -1;              /* INTEGER_1_31 */
static int hf_h245_customPCF = -1;                /* T_customPCF */
static int hf_h245_customPCF_item = -1;           /* T_customPCF_item */
static int hf_h245_customMPI = -1;                /* INTEGER_1_2048 */
static int hf_h245_pixelAspectInformation = -1;   /* T_pixelAspectInformation */
static int hf_h245_anyPixelAspectRatio = -1;      /* BOOLEAN */
static int hf_h245_pixelAspectCode = -1;          /* T_pixelAspectCode */
static int hf_h245_pixelAspectCode_item = -1;     /* INTEGER_1_14 */
static int hf_h245_extendedPAR = -1;              /* T_extendedPAR */
static int hf_h245_extendedPAR_item = -1;         /* T_extendedPAR_item */
static int hf_h245_width = -1;                    /* INTEGER_1_255 */
static int hf_h245_height = -1;                   /* INTEGER_1_255 */
static int hf_h245_h263VideoUncoupledModes = -1;  /* H263ModeComboFlags */
static int hf_h245_h263VideoCoupledModes = -1;    /* SET_SIZE_1_16_OF_H263ModeComboFlags */
static int hf_h245_h263VideoCoupledModes_item = -1;  /* H263ModeComboFlags */
static int hf_h245_referencePicSelect = -1;       /* BOOLEAN */
static int hf_h245_enhancedReferencePicSelectBool = -1;  /* BOOLEAN */
static int hf_h245_dataPartitionedSlices = -1;    /* BOOLEAN */
static int hf_h245_fixedPointIDCT0 = -1;          /* BOOLEAN */
static int hf_h245_interlacedFields = -1;         /* BOOLEAN */
static int hf_h245_currentPictureHeaderRepetition = -1;  /* BOOLEAN */
static int hf_h245_previousPictureHeaderRepetition = -1;  /* BOOLEAN */
static int hf_h245_nextPictureHeaderRepetition = -1;  /* BOOLEAN */
static int hf_h245_pictureNumberBoolean = -1;     /* BOOLEAN */
static int hf_h245_spareReferencePictures = -1;   /* BOOLEAN */
static int hf_h245_constrainedBitstream = -1;     /* BOOLEAN */
static int hf_h245_pictureRate = -1;              /* INTEGER_0_15 */
static int hf_h245_g711Alaw64k = -1;              /* INTEGER_1_256 */
static int hf_h245_g711Alaw56k = -1;              /* INTEGER_1_256 */
static int hf_h245_g711Ulaw64k = -1;              /* INTEGER_1_256 */
static int hf_h245_g711Ulaw56k = -1;              /* INTEGER_1_256 */
static int hf_h245_g722_64k = -1;                 /* INTEGER_1_256 */
static int hf_h245_g722_56k = -1;                 /* INTEGER_1_256 */
static int hf_h245_g722_48k = -1;                 /* INTEGER_1_256 */
static int hf_h245_g7231 = -1;                    /* T_g7231 */
static int hf_h245_maxAl_sduAudioFrames = -1;     /* INTEGER_1_256 */
static int hf_h245_silenceSuppression = -1;       /* BOOLEAN */
static int hf_h245_g728 = -1;                     /* INTEGER_1_256 */
static int hf_h245_g729 = -1;                     /* INTEGER_1_256 */
static int hf_h245_g729AnnexA = -1;               /* INTEGER_1_256 */
static int hf_h245_is11172AudioCapability = -1;   /* IS11172AudioCapability */
static int hf_h245_is13818AudioCapability = -1;   /* IS13818AudioCapability */
static int hf_h245_g729wAnnexB = -1;              /* INTEGER_1_256 */
static int hf_h245_g729AnnexAwAnnexB = -1;        /* INTEGER_1_256 */
static int hf_h245_g7231AnnexCCapability = -1;    /* G7231AnnexCCapability */
static int hf_h245_gsmFullRate = -1;              /* GSMAudioCapability */
static int hf_h245_gsmHalfRate = -1;              /* GSMAudioCapability */
static int hf_h245_gsmEnhancedFullRate = -1;      /* GSMAudioCapability */
static int hf_h245_genericAudioCapability = -1;   /* GenericCapability */
static int hf_h245_g729Extensions = -1;           /* G729Extensions */
static int hf_h245_vbd = -1;                      /* VBDCapability */
static int hf_h245_audioTelephonyEvent = -1;      /* NoPTAudioTelephonyEventCapability */
static int hf_h245_audioTone = -1;                /* NoPTAudioToneCapability */
static int hf_h245_audioUnit = -1;                /* INTEGER_1_256 */
static int hf_h245_annexA = -1;                   /* BOOLEAN */
static int hf_h245_annexB = -1;                   /* BOOLEAN */
static int hf_h245_annexD = -1;                   /* BOOLEAN */
static int hf_h245_annexE = -1;                   /* BOOLEAN */
static int hf_h245_annexF = -1;                   /* BOOLEAN */
static int hf_h245_annexG = -1;                   /* BOOLEAN */
static int hf_h245_annexH = -1;                   /* BOOLEAN */
static int hf_h245_g723AnnexCAudioMode = -1;      /* G723AnnexCAudioMode */
static int hf_h245_highRateMode0 = -1;            /* INTEGER_27_78 */
static int hf_h245_highRateMode1 = -1;            /* INTEGER_27_78 */
static int hf_h245_lowRateMode0 = -1;             /* INTEGER_23_66 */
static int hf_h245_lowRateMode1 = -1;             /* INTEGER_23_66 */
static int hf_h245_sidMode0 = -1;                 /* INTEGER_6_17 */
static int hf_h245_sidMode1 = -1;                 /* INTEGER_6_17 */
static int hf_h245_audioLayer1 = -1;              /* BOOLEAN */
static int hf_h245_audioLayer2 = -1;              /* BOOLEAN */
static int hf_h245_audioLayer3 = -1;              /* BOOLEAN */
static int hf_h245_audioSampling32k = -1;         /* BOOLEAN */
static int hf_h245_audioSampling44k1 = -1;        /* BOOLEAN */
static int hf_h245_audioSampling48k = -1;         /* BOOLEAN */
static int hf_h245_singleChannel = -1;            /* BOOLEAN */
static int hf_h245_twoChannels = -1;              /* BOOLEAN */
static int hf_h245_bitRate_1_448 = -1;            /* INTEGER_1_448 */
static int hf_h245_audioSampling16k = -1;         /* BOOLEAN */
static int hf_h245_audioSampling22k05 = -1;       /* BOOLEAN */
static int hf_h245_audioSampling24k = -1;         /* BOOLEAN */
static int hf_h245_threeChannels2_1 = -1;         /* BOOLEAN */
static int hf_h245_threeChannels3_0 = -1;         /* BOOLEAN */
static int hf_h245_fourChannels2_0_2_0 = -1;      /* BOOLEAN */
static int hf_h245_fourChannels2_2 = -1;          /* BOOLEAN */
static int hf_h245_fourChannels3_1 = -1;          /* BOOLEAN */
static int hf_h245_fiveChannels3_0_2_0 = -1;      /* BOOLEAN */
static int hf_h245_fiveChannels3_2 = -1;          /* BOOLEAN */
static int hf_h245_lowFrequencyEnhancement = -1;  /* BOOLEAN */
static int hf_h245_multilingual = -1;             /* BOOLEAN */
static int hf_h245_bitRate2_1_1130 = -1;          /* INTEGER_1_1130 */
static int hf_h245_audioUnitSize = -1;            /* INTEGER_1_256 */
static int hf_h245_comfortNoise = -1;             /* BOOLEAN */
static int hf_h245_scrambled = -1;                /* BOOLEAN */
static int hf_h245_vbd_cap_type = -1;             /* AudioCapability */
static int hf_h245_application = -1;              /* Application */
static int hf_h245_maxBitRate2_0_4294967295 = -1;  /* INTEGER_0_4294967295 */
static int hf_h245_t120 = -1;                     /* DataProtocolCapability */
static int hf_h245_dsm_cc = -1;                   /* DataProtocolCapability */
static int hf_h245_userData = -1;                 /* DataProtocolCapability */
static int hf_h245_t84 = -1;                      /* T_t84 */
static int hf_h245_t84Protocol = -1;              /* DataProtocolCapability */
static int hf_h245_t84Profile = -1;               /* T84Profile */
static int hf_h245_t434 = -1;                     /* DataProtocolCapability */
static int hf_h245_h224 = -1;                     /* DataProtocolCapability */
static int hf_h245_nlpid = -1;                    /* Nlpid */
static int hf_h245_dsvdControl = -1;              /* NULL */
static int hf_h245_h222DataPartitioning = -1;     /* DataProtocolCapability */
static int hf_h245_t30fax = -1;                   /* DataProtocolCapability */
static int hf_h245_t140 = -1;                     /* DataProtocolCapability */
static int hf_h245_t38fax = -1;                   /* T_t38fax */
static int hf_h245_t38FaxProtocol = -1;           /* DataProtocolCapability */
static int hf_h245_t38FaxProfile = -1;            /* T38FaxProfile */
static int hf_h245_genericDataCapability = -1;    /* GenericCapability */
static int hf_h245_v14buffered = -1;              /* NULL */
static int hf_h245_v42lapm = -1;                  /* NULL */
static int hf_h245_hdlcFrameTunnelling = -1;      /* NULL */
static int hf_h245_h310SeparateVCStack = -1;      /* NULL */
static int hf_h245_h310SingleVCStack = -1;        /* NULL */
static int hf_h245_transparent = -1;              /* NULL */
static int hf_h245_segmentationAndReassembly = -1;  /* NULL */
static int hf_h245_hdlcFrameTunnelingwSAR = -1;   /* NULL */
static int hf_h245_v120 = -1;                     /* NULL */
static int hf_h245_separateLANStack = -1;         /* NULL */
static int hf_h245_v76wCompression = -1;          /* T_v76wCompression */
static int hf_h245_transmitCompression = -1;      /* CompressionType */
static int hf_h245_receiveCompression = -1;       /* CompressionType */
static int hf_h245_transmitAndReceiveCompression = -1;  /* CompressionType */
static int hf_h245_tcp = -1;                      /* NULL */
static int hf_h245_udp = -1;                      /* NULL */
static int hf_h245_v42bis = -1;                   /* V42bis */
static int hf_h245_numberOfCodewords = -1;        /* INTEGER_1_65536 */
static int hf_h245_maximumStringLength = -1;      /* INTEGER_1_256 */
static int hf_h245_t84Unrestricted = -1;          /* NULL */
static int hf_h245_t84Restricted = -1;            /* T_t84Restricted */
static int hf_h245_qcif_bool = -1;                /* BOOLEAN */
static int hf_h245_cif_bool = -1;                 /* BOOLEAN */
static int hf_h245_ccir601Seq = -1;               /* BOOLEAN */
static int hf_h245_ccir601Prog = -1;              /* BOOLEAN */
static int hf_h245_hdtvSeq = -1;                  /* BOOLEAN */
static int hf_h245_hdtvProg = -1;                 /* BOOLEAN */
static int hf_h245_g3FacsMH200x100 = -1;          /* BOOLEAN */
static int hf_h245_g3FacsMH200x200 = -1;          /* BOOLEAN */
static int hf_h245_g4FacsMMR200x100 = -1;         /* BOOLEAN */
static int hf_h245_g4FacsMMR200x200 = -1;         /* BOOLEAN */
static int hf_h245_jbig200x200Seq = -1;           /* BOOLEAN */
static int hf_h245_jbig200x200Prog = -1;          /* BOOLEAN */
static int hf_h245_jbig300x300Seq = -1;           /* BOOLEAN */
static int hf_h245_jbig300x300Prog = -1;          /* BOOLEAN */
static int hf_h245_digPhotoLow = -1;              /* BOOLEAN */
static int hf_h245_digPhotoMedSeq = -1;           /* BOOLEAN */
static int hf_h245_digPhotoMedProg = -1;          /* BOOLEAN */
static int hf_h245_digPhotoHighSeq = -1;          /* BOOLEAN */
static int hf_h245_digPhotoHighProg = -1;         /* BOOLEAN */
static int hf_h245_fillBitRemoval = -1;           /* BOOLEAN */
static int hf_h245_transcodingJBIG = -1;          /* BOOLEAN */
static int hf_h245_transcodingMMR = -1;           /* BOOLEAN */
static int hf_h245_version = -1;                  /* INTEGER_0_255 */
static int hf_h245_t38FaxRateManagement = -1;     /* T38FaxRateManagement */
static int hf_h245_t38FaxUdpOptions = -1;         /* T38FaxUdpOptions */
static int hf_h245_t38FaxTcpOptions = -1;         /* T38FaxTcpOptions */
static int hf_h245_localTCF = -1;                 /* NULL */
static int hf_h245_transferredTCF = -1;           /* NULL */
static int hf_h245_t38FaxMaxBuffer = -1;          /* INTEGER */
static int hf_h245_t38FaxMaxDatagram = -1;        /* INTEGER */
static int hf_h245_t38FaxUdpEC = -1;              /* T_t38FaxUdpEC */
static int hf_h245_t38UDPFEC = -1;                /* NULL */
static int hf_h245_t38UDPRedundancy = -1;         /* NULL */
static int hf_h245_t38TCPBidirectionalMode = -1;  /* BOOLEAN */
static int hf_h245_nlpidProtocol = -1;            /* DataProtocolCapability */
static int hf_h245_nlpidData = -1;                /* OCTET_STRING */
static int hf_h245_encryptionCapability = -1;     /* EncryptionCapability */
static int hf_h245_authenticationCapability = -1;  /* AuthenticationCapability */
static int hf_h245_integrityCapability = -1;      /* IntegrityCapability */
static int hf_h245_EncryptionCapability_item = -1;  /* MediaEncryptionAlgorithm */
static int hf_h245_algorithm = -1;                /* OBJECT_IDENTIFIER */
static int hf_h245_antiSpamAlgorithm = -1;        /* OBJECT_IDENTIFIER */
static int hf_h245_ui_nonStandard = -1;           /* SEQUENCE_SIZE_1_16_OF_NonStandardParameter */
static int hf_h245_nonStandard_item = -1;         /* NonStandardParameter */
static int hf_h245_basicString = -1;              /* NULL */
static int hf_h245_iA5String = -1;                /* NULL */
static int hf_h245_generalString = -1;            /* NULL */
static int hf_h245_dtmf = -1;                     /* NULL */
static int hf_h245_hookflash = -1;                /* NULL */
static int hf_h245_extendedAlphanumericFlag = -1;  /* NULL */
static int hf_h245_encryptedBasicString = -1;     /* NULL */
static int hf_h245_encryptedIA5String = -1;       /* NULL */
static int hf_h245_encryptedGeneralString = -1;   /* NULL */
static int hf_h245_secureDTMF = -1;               /* NULL */
static int hf_h245_nonStandardParams = -1;        /* SEQUENCE_OF_NonStandardParameter */
static int hf_h245_nonStandardData_item = -1;     /* NonStandardParameter */
static int hf_h245_chairControlCapability = -1;   /* BOOLEAN */
static int hf_h245_videoIndicateMixingCapability = -1;  /* BOOLEAN */
static int hf_h245_multipointVisualizationCapability = -1;  /* BOOLEAN */
static int hf_h245_capabilityIdentifier = -1;     /* CapabilityIdentifier */
static int hf_h245_collapsing = -1;               /* SEQUENCE_OF_GenericParameter */
static int hf_h245_collapsing_item = -1;          /* GenericParameter */
static int hf_h245_nonCollapsing = -1;            /* SEQUENCE_OF_GenericParameter */
static int hf_h245_nonCollapsing_item = -1;       /* GenericParameter */
static int hf_h245_nonCollapsingRaw = -1;         /* OCTET_STRING */
static int hf_h245_transport = -1;                /* DataProtocolCapability */
static int hf_h245_standardOid = -1;              /* T_standard */
static int hf_h245_h221NonStandard = -1;          /* NonStandardParameter */
static int hf_h245_uuid = -1;                     /* OCTET_STRING_SIZE_16 */
static int hf_h245_domainBased = -1;              /* IA5String_SIZE_1_64 */
static int hf_h245_parameterIdentifier = -1;      /* ParameterIdentifier */
static int hf_h245_parameterValue = -1;           /* ParameterValue */
static int hf_h245_supersedes = -1;               /* SEQUENCE_OF_ParameterIdentifier */
static int hf_h245_supersedes_item = -1;          /* ParameterIdentifier */
static int hf_h245_standard = -1;                 /* INTEGER_0_127 */
static int hf_h245_logical = -1;                  /* NULL */
static int hf_h245_booleanArray = -1;             /* INTEGER_0_255 */
static int hf_h245_unsignedMin = -1;              /* INTEGER_0_65535 */
static int hf_h245_unsignedMax = -1;              /* INTEGER_0_65535 */
static int hf_h245_unsigned32Min = -1;            /* INTEGER_0_4294967295 */
static int hf_h245_unsigned32Max = -1;            /* INTEGER_0_4294967295 */
static int hf_h245_octetString = -1;              /* OCTET_STRING */
static int hf_h245_genericParameter = -1;         /* SEQUENCE_OF_GenericParameter */
static int hf_h245_genericParameter_item = -1;    /* GenericParameter */
static int hf_h245_multiplexFormat = -1;          /* MultiplexFormat */
static int hf_h245_controlOnMuxStream = -1;       /* BOOLEAN */
static int hf_h245_capabilityOnMuxStream = -1;    /* SET_SIZE_1_256_OF_AlternativeCapabilitySet */
static int hf_h245_capabilityOnMuxStream_item = -1;  /* AlternativeCapabilitySet */
static int hf_h245_dynamicRTPPayloadType = -1;    /* INTEGER_96_127 */
static int hf_h245_audioTelephoneEvent = -1;      /* GeneralString */
static int hf_h245_capabilities = -1;             /* SET_SIZE_1_256_OF_AlternativeCapabilitySet */
static int hf_h245_capabilities_item = -1;        /* AlternativeCapabilitySet */
static int hf_h245_fecc_rfc2733 = -1;             /* FECC_rfc2733 */
static int hf_h245_redundancyEncodingBool = -1;   /* BOOLEAN */
static int hf_h245_separateStreamBool = -1;       /* T_separateStream */
static int hf_h245_separatePort = -1;             /* BOOLEAN */
static int hf_h245_samePortBool = -1;             /* BOOLEAN */
static int hf_h245_forwardLogicalChannelNumber = -1;  /* LogicalChannelNumber */
static int hf_h245_forwardLogicalChannelParameters = -1;  /* T_forwardLogicalChannelParameters */
static int hf_h245_portNumber = -1;               /* INTEGER_0_65535 */
static int hf_h245_dataType = -1;                 /* DataType */
static int hf_h245_olc_forw_multiplexParameters = -1;  /* OLC_forw_multiplexParameters */
static int hf_h245_h222LogicalChannelParameters = -1;  /* H222LogicalChannelParameters */
static int hf_h245_h223LogicalChannelParameters = -1;  /* H223LogicalChannelParameters */
static int hf_h245_v76LogicalChannelParameters = -1;  /* V76LogicalChannelParameters */
static int hf_h245_h2250LogicalChannelParameters = -1;  /* H2250LogicalChannelParameters */
static int hf_h245_forwardLogicalChannelDependency = -1;  /* LogicalChannelNumber */
static int hf_h245_replacementFor = -1;           /* LogicalChannelNumber */
static int hf_h245_reverseLogicalChannelParameters = -1;  /* OLC_reverseLogicalChannelParameters */
static int hf_h245_olc_rev_multiplexParameter = -1;  /* OLC_rev_multiplexParameters */
static int hf_h245_reverseLogicalChannelDependency = -1;  /* LogicalChannelNumber */
static int hf_h245_separateStack = -1;            /* NetworkAccessParameters */
static int hf_h245_encryptionSync = -1;           /* EncryptionSync */
static int hf_h245_distribution = -1;             /* T_distribution */
static int hf_h245_unicast = -1;                  /* NULL */
static int hf_h245_multicast = -1;                /* NULL */
static int hf_h245_networkAddress = -1;           /* T_networkAddress */
static int hf_h245_q2931Address = -1;             /* Q2931Address */
static int hf_h245_e164Address = -1;              /* T_e164Address */
static int hf_h245_localAreaAddress = -1;         /* TransportAddress */
static int hf_h245_associateConference = -1;      /* BOOLEAN */
static int hf_h245_externalReference = -1;        /* OCTET_STRING_SIZE_1_255 */
static int hf_h245_t120SetupProcedure = -1;       /* T_t120SetupProcedure */
static int hf_h245_originateCall = -1;            /* NULL */
static int hf_h245_waitForCall = -1;              /* NULL */
static int hf_h245_issueQuery = -1;               /* NULL */
static int hf_h245_address = -1;                  /* T_address */
static int hf_h245_internationalNumber = -1;      /* NumericString_SIZE_1_16 */
static int hf_h245_nsapAddress = -1;              /* OCTET_STRING_SIZE_1_20 */
static int hf_h245_subaddress = -1;               /* OCTET_STRING_SIZE_1_20 */
static int hf_h245_audioHeaderPresent = -1;       /* BOOLEAN */
static int hf_h245_nullData = -1;                 /* NULL */
static int hf_h245_videoData = -1;                /* VideoCapability */
static int hf_h245_audioData = -1;                /* AudioCapability */
static int hf_h245_data = -1;                     /* DataApplicationCapability */
static int hf_h245_encryptionData = -1;           /* EncryptionMode */
static int hf_h245_h235Control = -1;              /* NonStandardParameter */
static int hf_h245_h235Media = -1;                /* H235Media */
static int hf_h245_multiplexedStream = -1;        /* MultiplexedStreamParameter */
static int hf_h245_redundancyEncoding = -1;       /* RedundancyEncoding */
static int hf_h245_multiplePayloadStream = -1;    /* MultiplePayloadStream */
static int hf_h245_fec = -1;                      /* FECData */
static int hf_h245_mediaType = -1;                /* T_mediaType */
static int hf_h245_resourceID = -1;               /* INTEGER_0_65535 */
static int hf_h245_subChannelID = -1;             /* INTEGER_0_8191 */
static int hf_h245_pcr_pid = -1;                  /* INTEGER_0_8191 */
static int hf_h245_programDescriptors = -1;       /* OCTET_STRING */
static int hf_h245_streamDescriptors = -1;        /* OCTET_STRING */
static int hf_h245_adaptationLayerType = -1;      /* T_adaptationLayerType */
static int hf_h245_al1Framed = -1;                /* NULL */
static int hf_h245_al1NotFramed = -1;             /* NULL */
static int hf_h245_al2WithoutSequenceNumbers = -1;  /* NULL */
static int hf_h245_al2WithSequenceNumbers = -1;   /* NULL */
static int hf_h245_al3 = -1;                      /* Al3 */
static int hf_h245_al1M = -1;                     /* H223AL1MParameters */
static int hf_h245_al2M = -1;                     /* H223AL2MParameters */
static int hf_h245_al3M = -1;                     /* H223AL3MParameters */
static int hf_h245_segmentableFlag = -1;          /* BOOLEAN */
static int hf_h245_controlFieldOctets = -1;       /* INTEGER_0_2 */
static int hf_h245_sendBufferSize = -1;           /* INTEGER_0_16777215 */
static int hf_h245_transferMode = -1;             /* T_transferMode */
static int hf_h245_framed = -1;                   /* NULL */
static int hf_h245_unframed = -1;                 /* NULL */
static int hf_h245_AL1HeaderFEC = -1;             /* AL1HeaderFEC */
static int hf_h245_sebch16_7 = -1;                /* NULL */
static int hf_h245_golay24_12 = -1;               /* NULL */
static int hf_h245_crcLength2 = -1;               /* AL1CrcLength */
static int hf_h245_crc4bit = -1;                  /* NULL */
static int hf_h245_crc12bit = -1;                 /* NULL */
static int hf_h245_crc20bit = -1;                 /* NULL */
static int hf_h245_crc28bit = -1;                 /* NULL */
static int hf_h245_crc8bit = -1;                  /* NULL */
static int hf_h245_crc16bit = -1;                 /* NULL */
static int hf_h245_crc32bit = -1;                 /* NULL */
static int hf_h245_crcNotUsed = -1;               /* NULL */
static int hf_h245_rcpcCodeRate = -1;             /* INTEGER_8_32 */
static int hf_h245_arqType = -1;                  /* ArqType */
static int hf_h245_alsduSplitting = -1;           /* BOOLEAN */
static int hf_h245_rsCodeCorrection = -1;         /* INTEGER_0_127 */
static int hf_h245_noArq = -1;                    /* NULL */
static int hf_h245_typeIArq = -1;                 /* H223AnnexCArqParameters */
static int hf_h245_typeIIArq = -1;                /* H223AnnexCArqParameters */
static int hf_h245_AL2HeaderFEC = -1;             /* AL2HeaderFEC */
static int hf_h245_sebch16_5 = -1;                /* NULL */
static int hf_h245_headerFormat = -1;             /* T_headerFormat */
static int hf_h245_crlength2 = -1;                /* AL3CrcLength */
static int hf_h245_numberOfRetransmissions = -1;  /* T_numberOfRetransmissions */
static int hf_h245_finite = -1;                   /* INTEGER_0_16 */
static int hf_h245_infinite = -1;                 /* NULL */
static int hf_h245_hdlcParameters = -1;           /* V76HDLCParameters */
static int hf_h245_suspendResume = -1;            /* T_suspendResume */
static int hf_h245_noSuspendResume = -1;          /* NULL */
static int hf_h245_suspendResumewAddress = -1;    /* NULL */
static int hf_h245_suspendResumewoAddress = -1;   /* NULL */
static int hf_h245_uIH = -1;                      /* BOOLEAN */
static int hf_h245_v76_mode = -1;                 /* V76LCP_mode */
static int hf_h245_eRM = -1;                      /* T_eRM */
static int hf_h245_windowSize = -1;               /* INTEGER_1_127 */
static int hf_h245_recovery = -1;                 /* T_recovery */
static int hf_h245_rej = -1;                      /* NULL */
static int hf_h245_sREJ = -1;                     /* NULL */
static int hf_h245_mSREJ = -1;                    /* NULL */
static int hf_h245_uNERM = -1;                    /* NULL */
static int hf_h245_v75Parameters = -1;            /* V75Parameters */
static int hf_h245_crcLength = -1;                /* CRCLength */
static int hf_h245_n401 = -1;                     /* INTEGER_1_4095 */
static int hf_h245_loopbackTestProcedure = -1;    /* BOOLEAN */
static int hf_h245_sessionID_0_255 = -1;          /* INTEGER_0_255 */
static int hf_h245_associatedSessionID = -1;      /* INTEGER_1_255 */
static int hf_h245_mediaChannel = -1;             /* T_mediaChannel */
static int hf_h245_mediaGuaranteedDelivery = -1;  /* BOOLEAN */
static int hf_h245_mediaControlChannel = -1;      /* T_mediaControlChannel */
static int hf_h245_mediaControlGuaranteedDelivery = -1;  /* BOOLEAN */
static int hf_h245_destination = -1;              /* TerminalLabel */
static int hf_h245_mediaPacketization = -1;       /* T_mediaPacketization */
static int hf_h245_h261aVideoPacketizationFlag = -1;  /* NULL */
static int hf_h245_rtpPayloadType = -1;           /* RTPPayloadType */
static int hf_h245_source = -1;                   /* TerminalLabel */
static int hf_h245_payloadDescriptor = -1;        /* T_payloadDescriptor */
static int hf_h245_rfc_number = -1;               /* INTEGER_1_32768_ */
static int hf_h245_oid = -1;                      /* OBJECT_IDENTIFIER */
static int hf_h245_payloadType = -1;              /* INTEGER_0_127 */
static int hf_h245_secondaryEncoding3 = -1;       /* DataType */
static int hf_h245_rtpRedundancyEncoding = -1;    /* T_rtpRedundancyEncoding */
static int hf_h245_primary = -1;                  /* RedundancyEncodingElement */
static int hf_h245_secondary = -1;                /* SEQUENCE_OF_RedundancyEncodingElement */
static int hf_h245_secondary_item = -1;           /* RedundancyEncodingElement */
static int hf_h245_elements = -1;                 /* SEQUENCE_OF_MultiplePayloadStreamElement */
static int hf_h245_elements_item = -1;            /* MultiplePayloadStreamElement */
static int hf_h245_rfc2733 = -1;                  /* RFC2733Data */
static int hf_h245_fec_data_mode = -1;            /* FECdata_mode */
static int hf_h245_redundancyEncodingFlag = -1;   /* NULL */
static int hf_h245_separateStream = -1;           /* SeparateStream */
static int hf_h245_differentPort = -1;            /* T_differentPort */
static int hf_h245_protectedSessionID = -1;       /* INTEGER_1_255 */
static int hf_h245_protectedPayloadType = -1;     /* INTEGER_0_127 */
static int hf_h245_samePort = -1;                 /* T_samePort */
static int hf_h245_unicastAddress = -1;           /* UnicastAddress */
static int hf_h245_multicastAddress = -1;         /* MulticastAddress */
static int hf_h245_iPAddress = -1;                /* T_iPAddress */
static int hf_h245_ip4_network = -1;              /* Ipv4_network */
static int hf_h245_tsapIdentifier = -1;           /* TsapIdentifier */
static int hf_h245_iPXAddress = -1;               /* T_iPXAddress */
static int hf_h245_node = -1;                     /* OCTET_STRING_SIZE_6 */
static int hf_h245_netnum = -1;                   /* OCTET_STRING_SIZE_4 */
static int hf_h245_ipx_tsapIdentifier = -1;       /* OCTET_STRING_SIZE_2 */
static int hf_h245_iP6Address = -1;               /* T_iP6Address */
static int hf_h245_ip6_network = -1;              /* OCTET_STRING_SIZE_16 */
static int hf_h245_ipv6_tsapIdentifier = -1;      /* INTEGER_0_65535 */
static int hf_h245_netBios = -1;                  /* OCTET_STRING_SIZE_16 */
static int hf_h245_iPSourceRouteAddress = -1;     /* T_iPSourceRouteAddress */
static int hf_h245_routing = -1;                  /* T_routing */
static int hf_h245_strict = -1;                   /* NULL */
static int hf_h245_loose = -1;                    /* NULL */
static int hf_h245_network = -1;                  /* OCTET_STRING_SIZE_4 */
static int hf_h245_iPSrcRoute_tsapIdentifier = -1;  /* INTEGER_0_65535 */
static int hf_h245_route = -1;                    /* T_route */
static int hf_h245_route_item = -1;               /* OCTET_STRING_SIZE_4 */
static int hf_h245_nsap = -1;                     /* OCTET_STRING_SIZE_1_20 */
static int hf_h245_nonStandardAddress = -1;       /* NonStandardParameter */
static int hf_h245_mIPAddress = -1;               /* MIPAddress */
static int hf_h245_mip4_network = -1;             /* OCTET_STRING_SIZE_4 */
static int hf_h245_multicast_tsapIdentifier = -1;  /* INTEGER_0_65535 */
static int hf_h245_mIP6Address = -1;              /* MIP6Address */
static int hf_h245_mip6_network = -1;             /* OCTET_STRING_SIZE_16 */
static int hf_h245_multicast_IPv6_tsapIdentifier = -1;  /* INTEGER_0_65535 */
static int hf_h245_synchFlag = -1;                /* INTEGER_0_255 */
static int hf_h245_h235Key = -1;                  /* OCTET_STRING_SIZE_1_65535 */
static int hf_h245_escrowentry = -1;              /* SEQUENCE_SIZE_1_256_OF_EscrowData */
static int hf_h245_escrowentry_item = -1;         /* EscrowData */
static int hf_h245_escrowID = -1;                 /* OBJECT_IDENTIFIER */
static int hf_h245_escrowValue = -1;              /* BIT_STRING_SIZE_1_65535 */
static int hf_h245_olc_ack_reverseLogicalChannelParameters = -1;  /* OLC_ack_reverseLogicalChannelParameters */
static int hf_h245_reverseLogicalChannelNumber = -1;  /* LogicalChannelNumber */
static int hf_h245_olc_ack_multiplexParameters = -1;  /* T_multiplexParameters */
static int hf_h245_forwardMultiplexAckParameters = -1;  /* T_forwardMultiplexAckParameters */
static int hf_h245_h2250LogicalChannelAckParameters = -1;  /* H2250LogicalChannelAckParameters */
static int hf_h245_olc_rej_cause = -1;            /* OpenLogicalChannelRejectCause */
static int hf_h245_unsuitableReverseParameters = -1;  /* NULL */
static int hf_h245_dataTypeNotSupported = -1;     /* NULL */
static int hf_h245_dataTypeNotAvailable = -1;     /* NULL */
static int hf_h245_unknownDataType = -1;          /* NULL */
static int hf_h245_dataTypeALCombinationNotSupported = -1;  /* NULL */
static int hf_h245_multicastChannelNotAllowed = -1;  /* NULL */
static int hf_h245_insufficientBandwidth = -1;    /* NULL */
static int hf_h245_separateStackEstablishmentFailed = -1;  /* NULL */
static int hf_h245_invalidSessionID = -1;         /* NULL */
static int hf_h245_masterSlaveConflict = -1;      /* NULL */
static int hf_h245_waitForCommunicationMode = -1;  /* NULL */
static int hf_h245_invalidDependentChannel = -1;  /* NULL */
static int hf_h245_replacementForRejected = -1;   /* NULL */
static int hf_h245_sessionID = -1;                /* INTEGER_1_255 */
static int hf_h245_ack_mediaChannel = -1;         /* Ack_mediaChannel */
static int hf_h245_ack_mediaControlChannel = -1;  /* Ack_mediaControlChannel */
static int hf_h245_flowControlToZero = -1;        /* BOOLEAN */
static int hf_h245_CloseLogicalChannel_source = -1;  /* T_source */
static int hf_h245_user = -1;                     /* NULL */
static int hf_h245_lcse = -1;                     /* NULL */
static int hf_h245_clc_reason = -1;               /* clc_reason */
static int hf_h245_unknown = -1;                  /* NULL */
static int hf_h245_reopen = -1;                   /* NULL */
static int hf_h245_reservationFailure = -1;       /* NULL */
static int hf_h245_qosCapability = -1;            /* QOSCapability */
static int hf_h245_reason = -1;                   /* T_reason */
static int hf_h245_normal = -1;                   /* NULL */
static int hf_h245_req_chan_clos_rej_cause = -1;  /* RequestChannelCloseRejectCause */
static int hf_h245_multiplexEntryDescriptors = -1;  /* SET_SIZE_1_15_OF_MultiplexEntryDescriptor */
static int hf_h245_multiplexEntryDescriptors_item = -1;  /* MultiplexEntryDescriptor */
static int hf_h245_multiplexTableEntryNumber = -1;  /* MultiplexTableEntryNumber */
static int hf_h245_elementList = -1;              /* SEQUENCE_SIZE_1_256_OF_MultiplexElement */
static int hf_h245_elementList_item = -1;         /* MultiplexElement */
static int hf_h245_Me_type = -1;                  /* Me_type */
static int hf_h245_logicalChannelNum = -1;        /* INTEGER_0_65535 */
static int hf_h245_subElementList = -1;           /* SEQUENCE_SIZE_2_255_OF_MultiplexElement */
static int hf_h245_subElementList_item = -1;      /* MultiplexElement */
static int hf_h245_me_repeatCount = -1;           /* ME_repeatCount */
static int hf_h245_finite_1_65535 = -1;           /* INTEGER_1_65535 */
static int hf_h245_untilClosingFlag = -1;         /* NULL */
static int hf_h245_multiplexTableEntryNumbers = -1;  /* SET_SIZE_1_15_OF_MultiplexTableEntryNumber */
static int hf_h245_multiplexTableEntryNumber_item = -1;  /* MultiplexTableEntryNumber */
static int hf_h245_rejectionDescriptions1 = -1;   /* SET_SIZE_1_15_OF_MultiplexEntryRejectionDescriptions */
static int hf_h245_rejectionDescriptions1_item = -1;  /* MultiplexEntryRejectionDescriptions */
static int hf_h245_mux_rej_cause = -1;            /* MultiplexEntryRejectionDescriptionsCause */
static int hf_h245_unspecifiedCause = -1;         /* NULL */
static int hf_h245_descriptorTooComplex = -1;     /* NULL */
static int hf_h245_entryNumbers = -1;             /* SET_SIZE_1_15_OF_MultiplexTableEntryNumber */
static int hf_h245_entryNumbers_item = -1;        /* MultiplexTableEntryNumber */
static int hf_h245_rejectionDescriptions2 = -1;   /* SET_SIZE_1_15_OF_RequestMultiplexEntryRejectionDescriptions */
static int hf_h245_rejectionDescriptions2_item = -1;  /* RequestMultiplexEntryRejectionDescriptions */
static int hf_h245_req_mux_rej_cause = -1;        /* RequestMultiplexEntryRejectionDescriptionsCause */
static int hf_h245_requestedModes = -1;           /* SEQUENCE_SIZE_1_256_OF_ModeDescription */
static int hf_h245_requestedModes_item = -1;      /* ModeDescription */
static int hf_h245_req_mode_ack_response = -1;    /* Req_mode_ack_response */
static int hf_h245_willTransmitMostPreferredMode = -1;  /* NULL */
static int hf_h245_willTransmitLessPreferredMode = -1;  /* NULL */
static int hf_h245_req_rej_cause = -1;            /* RequestModeRejectCause */
static int hf_h245_modeUnavailable = -1;          /* NULL */
static int hf_h245_multipointConstraint = -1;     /* NULL */
static int hf_h245_requestDenied = -1;            /* NULL */
static int hf_h245_ModeDescription_item = -1;     /* ModeElement */
static int hf_h245_videoMode = -1;                /* VideoMode */
static int hf_h245_audioMode = -1;                /* AudioMode */
static int hf_h245_dataMode = -1;                 /* DataMode */
static int hf_h245_encryptionMode = -1;           /* EncryptionMode */
static int hf_h245_h235Mode = -1;                 /* H235Mode */
static int hf_h245_multiplexedStreamMode = -1;    /* MultiplexedStreamParameter */
static int hf_h245_redundancyEncodingDTMode = -1;  /* RedundancyEncodingDTMode */
static int hf_h245_multiplePayloadStreamMode = -1;  /* MultiplePayloadStreamMode */
static int hf_h245_fecMode = -1;                  /* FECMode */
static int hf_h245_type = -1;                     /* ModeElementType */
static int hf_h245_h223ModeParameters = -1;       /* H223ModeParameters */
static int hf_h245_v76ModeParameters = -1;        /* V76ModeParameters */
static int hf_h245_h2250ModeParameters = -1;      /* H2250ModeParameters */
static int hf_h245_genericModeParameters = -1;    /* GenericCapability */
static int hf_h245_multiplexedStreamModeParameters = -1;  /* MultiplexedStreamModeParameters */
static int hf_h245_logicalChannelNumber = -1;     /* LogicalChannelNumber */
static int hf_h245_mediaMode = -1;                /* T_mediaMode */
static int hf_h245_prmary_dtmode = -1;            /* RedundancyEncodingDTModeElement */
static int hf_h245_secondary2 = -1;               /* SEQUENCE_OF_RedundancyEncodingDTModeElement */
static int hf_h245_secondary2_item = -1;          /* RedundancyEncodingDTModeElement */
static int hf_h245_re_type = -1;                  /* Re_type */
static int hf_h245_mpsmElements = -1;             /* SEQUENCE_OF_MultiplePayloadStreamElementMode */
static int hf_h245_mpsmElements_item = -1;        /* MultiplePayloadStreamElementMode */
static int hf_h245_rfc2733Mode = -1;              /* T_rfc2733Mode */
static int hf_h245_fec_mode = -1;                 /* FEC_mode */
static int hf_h245_adaptationLayer = -1;          /* AdaptationLayerType */
static int hf_h245_redundancyEncodingMode = -1;   /* RedundancyEncodingMode */
static int hf_h245_secondaryEncoding = -1;        /* T_secondaryEncoding */
static int hf_h245_h261VideoMode = -1;            /* H261VideoMode */
static int hf_h245_h262VideoMode = -1;            /* H262VideoMode */
static int hf_h245_h263VideoMode = -1;            /* H263VideoMode */
static int hf_h245_is11172VideoMode = -1;         /* IS11172VideoMode */
static int hf_h245_genericVideoMode = -1;         /* GenericCapability */
static int hf_h245_h261_resolution = -1;          /* H261Resolution */
static int hf_h245_qcif = -1;                     /* NULL */
static int hf_h245_cif = -1;                      /* NULL */
static int hf_h245_profileAndLevel = -1;          /* T_profileAndLevel */
static int hf_h245_profileAndLevel_SPatMLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_MPatLLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_MPatMLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_MPatH_14Mode = -1;  /* NULL */
static int hf_h245_profileAndLevel_MPatHLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_SNRatLLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_SNRatMLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_SpatialatH_14Mode = -1;  /* NULL */
static int hf_h245_profileAndLevel_HPatMLMode = -1;  /* NULL */
static int hf_h245_profileAndLevel_HPatH_14Mode = -1;  /* NULL */
static int hf_h245_profileAndLevel_HPatHLMode = -1;  /* NULL */
static int hf_h245_h263_resolution = -1;          /* H263Resolution */
static int hf_h245_sqcif = -1;                    /* NULL */
static int hf_h245_cif4 = -1;                     /* NULL */
static int hf_h245_cif16 = -1;                    /* NULL */
static int hf_h245_custom_res = -1;               /* NULL */
static int hf_h245_g711Alaw64k_mode = -1;         /* NULL */
static int hf_h245_g711Alaw56k_mode = -1;         /* NULL */
static int hf_h245_g711Ulaw64k_mode = -1;         /* NULL */
static int hf_h245_g711Ulaw56k_mode = -1;         /* NULL */
static int hf_h245_g722_64k_mode = -1;            /* NULL */
static int hf_h245_g722_56k_mode = -1;            /* NULL */
static int hf_h245_g722_48k_mode = -1;            /* NULL */
static int hf_h245_g728_mode = -1;                /* NULL */
static int hf_h245_g729_mode = -1;                /* NULL */
static int hf_h245_g729AnnexA_mode = -1;          /* NULL */
static int hf_h245_g7231_mode = -1;               /* Mode_g7231 */
static int hf_h245_noSilenceSuppressionLowRate = -1;  /* NULL */
static int hf_h245_noSilenceSuppressionHighRate = -1;  /* NULL */
static int hf_h245_silenceSuppressionLowRate = -1;  /* NULL */
static int hf_h245_silenceSuppressionHighRate = -1;  /* NULL */
static int hf_h245_is11172AudioMode = -1;         /* IS11172AudioMode */
static int hf_h245_is13818AudioMode = -1;         /* IS13818AudioMode */
static int hf_h245_g7231AnnexCMode = -1;          /* G7231AnnexCMode */
static int hf_h245_genericAudioMode = -1;         /* GenericCapability */
static int hf_h245_vbd_mode = -1;                 /* VBDMode */
static int hf_h245_audioLayer = -1;               /* T_audioLayer */
static int hf_h245_audioLayer1Mode = -1;          /* NULL */
static int hf_h245_audioLayer2Mode = -1;          /* NULL */
static int hf_h245_audioLayer3Mode = -1;          /* NULL */
static int hf_h245_audioSampling = -1;            /* T_audioSampling */
static int hf_h245_audioSampling32kMode = -1;     /* NULL */
static int hf_h245_audioSampling44k1Mode = -1;    /* NULL */
static int hf_h245_audioSampling48kMode = -1;     /* NULL */
static int hf_h245_is11172multichannelType = -1;  /* IS11172_multichannelType */
static int hf_h245_singleChannelMode = -1;        /* NULL */
static int hf_h245_twoChannelStereo = -1;         /* NULL */
static int hf_h245_twoChannelDual = -1;           /* NULL */
static int hf_h245_audioLayerMode = -1;           /* IS13818AudioLayer */
static int hf_h245_audioSamplingMode = -1;        /* IS13818AudioSampling */
static int hf_h245_audioSampling16kMode = -1;     /* NULL */
static int hf_h245_audioSampling22k05Mode = -1;   /* NULL */
static int hf_h245_audioSampling24kMode = -1;     /* NULL */
static int hf_h245_is13818MultichannelType = -1;  /* IS13818MultichannelType */
static int hf_h245_threeChannels2_1Mode = -1;     /* NULL */
static int hf_h245_threeChannels3_0Mode = -1;     /* NULL */
static int hf_h245_fourChannels2_0_2_0Mode = -1;  /* NULL */
static int hf_h245_fourChannels2_2Mode = -1;      /* NULL */
static int hf_h245_fourChannels3_1Mode = -1;      /* NULL */
static int hf_h245_fiveChannels3_0_2_0Mode = -1;  /* NULL */
static int hf_h245_fiveChannels3_2Mode = -1;      /* NULL */
static int hf_h245_vbd_type = -1;                 /* AudioMode */
static int hf_h245_datamodeapplication = -1;      /* DataModeApplication */
static int hf_h245_t84DataProtocolCapability = -1;  /* DataProtocolCapability */
static int hf_h245_t38faxDataProtocolCapability = -1;  /* T38faxApp */
static int hf_h245_genericDataMode = -1;          /* GenericCapability */
static int hf_h245_bitRate_0_4294967295 = -1;     /* INTEGER_0_4294967295 */
static int hf_h245_h233Encryption = -1;           /* NULL */
static int hf_h245_mlr_type = -1;                 /* Mlr_type */
static int hf_h245_systemLoop = -1;               /* NULL */
static int hf_h245_mediaLoop = -1;                /* LogicalChannelNumber */
static int hf_h245_logicalChannelLoop = -1;       /* LogicalChannelNumber */
static int hf_h245_Mla_type = -1;                 /* Mla_type */
static int hf_h245_mlrej_type = -1;               /* Mlrej_type */
static int hf_h245_maintloop_rej_cause = -1;      /* MaintenanceLoopRejectCause */
static int hf_h245_canNotPerformLoop = -1;        /* NULL */
static int hf_h245_communicationModeTable = -1;   /* SET_SIZE_1_256_OF_CommunicationModeTableEntry */
static int hf_h245_communicationModeTable_item = -1;  /* CommunicationModeTableEntry */
static int hf_h245_terminalLabel = -1;            /* TerminalLabel */
static int hf_h245_sessionDescription = -1;       /* BMPString_SIZE_1_128 */
static int hf_h245_entryDataType = -1;            /* T_dataType */
static int hf_h245_cm_mediaChannel = -1;          /* Cm_mediaChannel */
static int hf_h245_cm_mediaControlChannel = -1;   /* TransportAddress */
static int hf_h245_sessionDependency = -1;        /* INTEGER_1_255 */
static int hf_h245_terminalListRequest = -1;      /* NULL */
static int hf_h245_makeMeChair = -1;              /* NULL */
static int hf_h245_cancelMakeMeChair = -1;        /* NULL */
static int hf_h245_dropTerminal = -1;             /* TerminalLabel */
static int hf_h245_requestTerminalID = -1;        /* TerminalLabel */
static int hf_h245_enterH243Password = -1;        /* NULL */
static int hf_h245_enterH243TerminalID = -1;      /* NULL */
static int hf_h245_enterH243ConferenceID = -1;    /* NULL */
static int hf_h245_enterExtensionAddress = -1;    /* NULL */
static int hf_h245_requestChairTokenOwner = -1;   /* NULL */
static int hf_h245_requestTerminalCertificate = -1;  /* T_requestTerminalCertificate */
static int hf_h245_certSelectionCriteria = -1;    /* CertSelectionCriteria */
static int hf_h245_sRandom = -1;                  /* INTEGER_1_4294967295 */
static int hf_h245_broadcastMyLogicalChannel = -1;  /* LogicalChannelNumber */
static int hf_h245_makeTerminalBroadcaster = -1;  /* TerminalLabel */
static int hf_h245_sendThisSource = -1;           /* TerminalLabel */
static int hf_h245_requestAllTerminalIDs = -1;    /* NULL */
static int hf_h245_remoteMCRequest = -1;          /* RemoteMCRequest */
static int hf_h245_CertSelectionCriteria_item = -1;  /* Criteria */
static int hf_h245_field = -1;                    /* OBJECT_IDENTIFIER */
static int hf_h245_value = -1;                    /* OCTET_STRING_SIZE_1_65535 */
static int hf_h245_mcuNumber = -1;                /* McuNumber */
static int hf_h245_terminalNumber = -1;           /* TerminalNumber */
static int hf_h245_mCTerminalIDResponse = -1;     /* T_mCTerminalIDResponse */
static int hf_h245_terminalID = -1;               /* TerminalID */
static int hf_h245_terminalIDResponse = -1;       /* T_terminalIDResponse */
static int hf_h245_conferenceIDResponse = -1;     /* T_conferenceIDResponse */
static int hf_h245_conferenceID = -1;             /* ConferenceID */
static int hf_h245_passwordResponse = -1;         /* T_passwordResponse */
static int hf_h245_password = -1;                 /* Password */
static int hf_h245_terminalListResponse = -1;     /* SET_SIZE_1_256_OF_TerminalLabel */
static int hf_h245_terminalListResponse_item = -1;  /* TerminalLabel */
static int hf_h245_videoCommandReject = -1;       /* NULL */
static int hf_h245_terminalDropReject = -1;       /* NULL */
static int hf_h245_makeMeChairResponse = -1;      /* T_makeMeChairResponse */
static int hf_h245_grantedChairToken = -1;        /* NULL */
static int hf_h245_deniedChairToken = -1;         /* NULL */
static int hf_h245_extensionAddressResponse = -1;  /* T_extensionAddressResponse */
static int hf_h245_extensionAddress = -1;         /* TerminalID */
static int hf_h245_chairTokenOwnerResponse = -1;  /* T_chairTokenOwnerResponse */
static int hf_h245_terminalCertificateResponse = -1;  /* T_terminalCertificateResponse */
static int hf_h245_certificateResponse = -1;      /* OCTET_STRING_SIZE_1_65535 */
static int hf_h245_broadcastMyLogicalChannelResponse = -1;  /* T_broadcastMyLogicalChannelResponse */
static int hf_h245_grantedBroadcastMyLogicalChannel = -1;  /* NULL */
static int hf_h245_deniedBroadcastMyLogicalChannel = -1;  /* NULL */
static int hf_h245_makeTerminalBroadcasterResponse = -1;  /* T_makeTerminalBroadcasterResponse */
static int hf_h245_grantedMakeTerminalBroadcaster = -1;  /* NULL */
static int hf_h245_deniedMakeTerminalBroadcaster = -1;  /* NULL */
static int hf_h245_sendThisSourceResponse = -1;   /* T_sendThisSourceResponse */
static int hf_h245_grantedSendThisSource = -1;    /* NULL */
static int hf_h245_deniedSendThisSource = -1;     /* NULL */
static int hf_h245_requestAllTerminalIDsResponse = -1;  /* RequestAllTerminalIDsResponse */
static int hf_h245_remoteMCResponse = -1;         /* RemoteMCResponse */
static int hf_h245_terminalInformation = -1;      /* SEQUENCE_OF_TerminalInformation */
static int hf_h245_terminalInformation_item = -1;  /* TerminalInformation */
static int hf_h245_masterActivate = -1;           /* NULL */
static int hf_h245_slaveActivate = -1;            /* NULL */
static int hf_h245_deActivate = -1;               /* NULL */
static int hf_h245_accept = -1;                   /* NULL */
static int hf_h245_reject = -1;                   /* T_reject */
static int hf_h245_functionNotSupportedFlag = -1;  /* NULL */
static int hf_h245_callInformationReq = -1;       /* CallInformationReq */
static int hf_h245_maxNumberOfAdditionalConnections = -1;  /* INTEGER_1_65535 */
static int hf_h245_addConnectionReq = -1;         /* AddConnectionReq */
static int hf_h245_dialingInformation = -1;       /* DialingInformation */
static int hf_h245_removeConnectionReq = -1;      /* RemoveConnectionReq */
static int hf_h245_maximumHeaderIntervalReq = -1;  /* MaximumHeaderIntervalReq */
static int hf_h245_requestType = -1;              /* T_requestType */
static int hf_h245_currentIntervalInformation = -1;  /* NULL */
static int hf_h245_requestedInterval = -1;        /* INTEGER_0_65535 */
static int hf_h245_callInformationResp = -1;      /* CallInformationResp */
static int hf_h245_callAssociationNumber = -1;    /* INTEGER_0_4294967295 */
static int hf_h245_addConnectionResp = -1;        /* AddConnectionResp */
static int hf_h245_responseCode = -1;             /* T_responseCode */
static int hf_h245_accepted = -1;                 /* NULL */
static int hf_h245_rejected = -1;                 /* T_rejected */
static int hf_h245_connectionsNotAvailable = -1;  /* NULL */
static int hf_h245_userRejected = -1;             /* NULL */
static int hf_h245_removeConnectionResp = -1;     /* RemoveConnectionResp */
static int hf_h245_maximumHeaderIntervalResp = -1;  /* MaximumHeaderIntervalResp */
static int hf_h245_currentInterval = -1;          /* INTEGER_0_65535 */
static int hf_h245_connectionIdentifier = -1;     /* ConnectionIdentifier */
static int hf_h245_crcDesired = -1;               /* T_crcDesired */
static int hf_h245_excessiveError = -1;           /* T_excessiveError */
static int hf_h245_differential = -1;             /* SET_SIZE_1_65535_OF_DialingInformationNumber */
static int hf_h245_differential_item = -1;        /* DialingInformationNumber */
static int hf_h245_infoNotAvailable = -1;         /* INTEGER_1_65535 */
static int hf_h245_networkAddressNum = -1;        /* NumericString_SIZE_0_40 */
static int hf_h245_subAddress = -1;               /* IA5String_SIZE_1_40 */
static int hf_h245_networkType = -1;              /* SET_SIZE_1_255_OF_DialingInformationNetworkType */
static int hf_h245_networkType_item = -1;         /* DialingInformationNetworkType */
static int hf_h245_n_isdn = -1;                   /* NULL */
static int hf_h245_gstn = -1;                     /* NULL */
static int hf_h245_mobile = -1;                   /* NULL */
static int hf_h245_channelTag = -1;               /* INTEGER_0_4294967295 */
static int hf_h245_sequenceNum = -1;              /* INTEGER_0_4294967295 */
static int hf_h245_maximumBitRate = -1;           /* MaximumBitRate */
static int hf_h245_rejectReason = -1;             /* LogicalChannelRateRejectReason */
static int hf_h245_currentMaximumBitRate = -1;    /* MaximumBitRate */
static int hf_h245_undefinedReason = -1;          /* NULL */
static int hf_h245_insufficientResources = -1;    /* NULL */
static int hf_h245_specificRequest = -1;          /* T_specificRequest */
static int hf_h245_multiplexCapabilityBool = -1;  /* BOOLEAN */
static int hf_h245_capabilityTableEntryNumbers = -1;  /* SET_SIZE_1_65535_OF_CapabilityTableEntryNumber */
static int hf_h245_capabilityTableEntryNumbers_item = -1;  /* CapabilityTableEntryNumber */
static int hf_h245_capabilityDescriptorNumbers = -1;  /* SET_SIZE_1_256_OF_CapabilityDescriptorNumber */
static int hf_h245_capabilityDescriptorNumbers_item = -1;  /* CapabilityDescriptorNumber */
static int hf_h245_genericRequestFlag = -1;       /* NULL */
static int hf_h245_encryptionSE = -1;             /* OCTET_STRING */
static int hf_h245_encryptionIVRequest = -1;      /* NULL */
static int hf_h245_encryptionAlgorithmID = -1;    /* T_encryptionAlgorithmID */
static int hf_h245_h233AlgorithmIdentifier = -1;  /* SequenceNumber */
static int hf_h245_associatedAlgorithm = -1;      /* NonStandardParameter */
static int hf_h245_scope = -1;                    /* Scope */
static int hf_h245_restriction = -1;              /* Restriction */
static int hf_h245_wholeMultiplex = -1;           /* NULL */
static int hf_h245_Res_maximumBitRate = -1;       /* INTEGER_0_16777215 */
static int hf_h245_noRestriction = -1;            /* NULL */
static int hf_h245_disconnect = -1;               /* NULL */
static int hf_h245_gstnOptions = -1;              /* T_gstnOptions */
static int hf_h245_telephonyMode = -1;            /* NULL */
static int hf_h245_v8bis = -1;                    /* NULL */
static int hf_h245_v34DSVD = -1;                  /* NULL */
static int hf_h245_v34DuplexFAX = -1;             /* NULL */
static int hf_h245_v34H324 = -1;                  /* NULL */
static int hf_h245_isdnOptions = -1;              /* T_isdnOptions */
static int hf_h245_v140 = -1;                     /* NULL */
static int hf_h245_terminalOnHold = -1;           /* NULL */
static int hf_h245_cancelBroadcastMyLogicalChannel = -1;  /* LogicalChannelNumber */
static int hf_h245_cancelMakeTerminalBroadcaster = -1;  /* NULL */
static int hf_h245_cancelSendThisSource = -1;     /* NULL */
static int hf_h245_dropConference = -1;           /* NULL */
static int hf_h245_substituteConferenceIDCommand = -1;  /* SubstituteConferenceIDCommand */
static int hf_h245_conferenceIdentifier = -1;     /* OCTET_STRING_SIZE_16 */
static int hf_h245_masterToSlave = -1;            /* NULL */
static int hf_h245_slaveToMaster = -1;            /* NULL */
static int hf_h245_mc_type = -1;                  /* Mc_type */
static int hf_h245_equaliseDelay = -1;            /* NULL */
static int hf_h245_zeroDelay = -1;                /* NULL */
static int hf_h245_multipointModeCommand = -1;    /* NULL */
static int hf_h245_cancelMultipointModeCommand = -1;  /* NULL */
static int hf_h245_videoFreezePicture = -1;       /* NULL */
static int hf_h245_videoFastUpdatePicture = -1;   /* NULL */
static int hf_h245_videoFastUpdateGOB = -1;       /* T_videoFastUpdateGOB */
static int hf_h245_firstGOB = -1;                 /* INTEGER_0_17 */
static int hf_h245_numberOfGOBs = -1;             /* INTEGER_1_18 */
static int hf_h245_videoTemporalSpatialTradeOff = -1;  /* INTEGER_0_31 */
static int hf_h245_videoSendSyncEveryGOB = -1;    /* NULL */
static int hf_h245_videoSendSyncEveryGOBCancel = -1;  /* NULL */
static int hf_h245_videoFastUpdateMB = -1;        /* T_videoFastUpdateMB */
static int hf_h245_firstGOB_0_255 = -1;           /* INTEGER_0_255 */
static int hf_h245_firstMB_1_8192 = -1;           /* INTEGER_1_8192 */
static int hf_h245_numberOfMBs = -1;              /* INTEGER_1_8192 */
static int hf_h245_maxH223MUXPDUsize = -1;        /* INTEGER_1_65535 */
static int hf_h245_encryptionUpdate = -1;         /* EncryptionSync */
static int hf_h245_encryptionUpdateRequest = -1;  /* EncryptionUpdateRequest */
static int hf_h245_switchReceiveMediaOff = -1;    /* NULL */
static int hf_h245_switchReceiveMediaOn = -1;     /* NULL */
static int hf_h245_progressiveRefinementStart = -1;  /* T_progressiveRefinementStart */
static int hf_h245_repeatCount = -1;              /* RepeatCount */
static int hf_h245_progressiveRefinementAbortOne = -1;  /* NULL */
static int hf_h245_progressiveRefinementAbortContinuous = -1;  /* NULL */
static int hf_h245_videoBadMBs = -1;              /* T_videoBadMBs */
static int hf_h245_firstMB = -1;                  /* INTEGER_1_9216 */
static int hf_h245_numberOfMBs1_1_9216 = -1;      /* INTEGER_1_9216 */
static int hf_h245_temporalReference = -1;        /* INTEGER_0_1023 */
static int hf_h245_lostPicture = -1;              /* SEQUENCE_OF_PictureReference */
static int hf_h245_lostPicture_item = -1;         /* PictureReference */
static int hf_h245_lostPartialPicture = -1;       /* T_lostPartialPicture */
static int hf_h245_pictureReference = -1;         /* PictureReference */
static int hf_h245_recoveryReferencePicture = -1;  /* SEQUENCE_OF_PictureReference */
static int hf_h245_recoveryReferencePicture_item = -1;  /* PictureReference */
static int hf_h245_encryptionUpdateCommand = -1;  /* T_encryptionUpdateCommand */
static int hf_h245_encryptionUpdateAck = -1;      /* T_encryptionUpdateAck */
static int hf_h245_direction = -1;                /* EncryptionUpdateDirection */
static int hf_h245_doOneProgression = -1;         /* NULL */
static int hf_h245_doContinuousProgressions = -1;  /* NULL */
static int hf_h245_doOneIndependentProgression = -1;  /* NULL */
static int hf_h245_doContinuousIndependentProgressions = -1;  /* NULL */
static int hf_h245_secureChannel = -1;            /* BOOLEAN */
static int hf_h245_sharedSecret = -1;             /* BOOLEAN */
static int hf_h245_certProtectedKey = -1;         /* BOOLEAN */
static int hf_h245_keyProtectionMethod = -1;      /* KeyProtectionMethod */
static int hf_h245_pictureNumber = -1;            /* INTEGER_0_1023 */
static int hf_h245_longTermPictureIndex = -1;     /* INTEGER_0_255 */
static int hf_h245_h223ModeChange = -1;           /* T_h223ModeChange */
static int hf_h245_toLevel0 = -1;                 /* NULL */
static int hf_h245_toLevel1 = -1;                 /* NULL */
static int hf_h245_toLevel2 = -1;                 /* NULL */
static int hf_h245_toLevel2withOptionalHeader = -1;  /* NULL */
static int hf_h245_h223AnnexADoubleFlag = -1;     /* T_h223AnnexADoubleFlag */
static int hf_h245_start = -1;                    /* NULL */
static int hf_h245_stop = -1;                     /* NULL */
static int hf_h245_bitRate = -1;                  /* INTEGER_1_65535 */
static int hf_h245_bitRateLockedToPCRClock = -1;  /* BOOLEAN */
static int hf_h245_bitRateLockedToNetworkClock = -1;  /* BOOLEAN */
static int hf_h245_cmd_aal = -1;                  /* Cmd_aal */
static int hf_h245_cmd_aal1 = -1;                 /* Cmd_aal1 */
static int hf_h245_cmd_clockRecovery = -1;        /* Cmd_clockRecovery */
static int hf_h245_nullClockRecoveryflag = -1;    /* NULL */
static int hf_h245_srtsClockRecovery = -1;        /* NULL */
static int hf_h245_adaptiveClockRecoveryFlag = -1;  /* NULL */
static int hf_h245_cmd_errorCorrection = -1;      /* Cmd_errorCorrection */
static int hf_h245_nullErrorCorrectionFlag = -1;  /* NULL */
static int hf_h245_longInterleaverFlag = -1;      /* NULL */
static int hf_h245_shortInterleaverFlag = -1;     /* NULL */
static int hf_h245_errorCorrectionOnlyFlag = -1;  /* NULL */
static int hf_h245_cmd_aal5 = -1;                 /* Cmd_aal5 */
static int hf_h245_cmd_multiplex = -1;            /* Cmd_multiplex */
static int hf_h245_noMultiplex = -1;              /* NULL */
static int hf_h245_transportStream = -1;          /* NULL */
static int hf_h245_programStreamFlag = -1;        /* NULL */
static int hf_h245_cmd_reverseParameters = -1;    /* Cmd_reverseParameters */
static int hf_h245_cmdr_multiplex = -1;           /* CmdR_multiplex */
static int hf_h245_sampleSize = -1;               /* INTEGER_1_255 */
static int hf_h245_samplesPerFrame = -1;          /* INTEGER_1_255 */
static int hf_h245_status = -1;                   /* T_status */
static int hf_h245_synchronized = -1;             /* NULL */
static int hf_h245_reconfiguration = -1;          /* NULL */
static int hf_h245_fns_cause = -1;                /* FunctionNotSupportedCause */
static int hf_h245_syntaxError = -1;              /* NULL */
static int hf_h245_semanticError = -1;            /* NULL */
static int hf_h245_unknownFunction = -1;          /* NULL */
static int hf_h245_returnedFunction = -1;         /* OCTET_STRING */
static int hf_h245_sbeNumber = -1;                /* INTEGER_0_9 */
static int hf_h245_terminalNumberAssign = -1;     /* TerminalLabel */
static int hf_h245_terminalJoinedConference = -1;  /* TerminalLabel */
static int hf_h245_terminalLeftConference = -1;   /* TerminalLabel */
static int hf_h245_seenByAtLeastOneOther = -1;    /* NULL */
static int hf_h245_cancelSeenByAtLeastOneOther = -1;  /* NULL */
static int hf_h245_seenByAll = -1;                /* NULL */
static int hf_h245_cancelSeenByAll = -1;          /* NULL */
static int hf_h245_terminalYouAreSeeing = -1;     /* TerminalLabel */
static int hf_h245_requestForFloor = -1;          /* NULL */
static int hf_h245_withdrawChairToken = -1;       /* NULL */
static int hf_h245_floorRequested = -1;           /* TerminalLabel */
static int hf_h245_terminalYouAreSeeingInSubPictureNumber = -1;  /* TerminalYouAreSeeingInSubPictureNumber */
static int hf_h245_videoIndicateCompose = -1;     /* VideoIndicateCompose */
static int hf_h245_subPictureNumber = -1;         /* INTEGER_0_255 */
static int hf_h245_compositionNumber = -1;        /* INTEGER_0_255 */
static int hf_h245_mi_type = -1;                  /* Mi_type */
static int hf_h245_logicalChannelActive = -1;     /* NULL */
static int hf_h245_logicalChannelInactive = -1;   /* NULL */
static int hf_h245_multipointConference = -1;     /* NULL */
static int hf_h245_cancelMultipointConference = -1;  /* NULL */
static int hf_h245_multipointZeroComm = -1;       /* NULL */
static int hf_h245_cancelMultipointZeroComm = -1;  /* NULL */
static int hf_h245_multipointSecondaryStatus = -1;  /* NULL */
static int hf_h245_cancelMultipointSecondaryStatus = -1;  /* NULL */
static int hf_h245_videoIndicateReadyToActivate = -1;  /* NULL */
static int hf_h245_videoNotDecodedMBs = -1;       /* T_videoNotDecodedMBs */
static int hf_h245_temporalReference_0_255 = -1;  /* INTEGER_0_255 */
static int hf_h245_estimatedReceivedJitterMantissa = -1;  /* INTEGER_0_3 */
static int hf_h245_estimatedReceivedJitterExponent = -1;  /* INTEGER_0_7 */
static int hf_h245_skippedFrameCount = -1;        /* INTEGER_0_15 */
static int hf_h245_additionalDecoderBuffer = -1;  /* INTEGER_0_262143 */
static int hf_h245_logicalChannelNumber1 = -1;    /* LogicalChannelNumber */
static int hf_h245_logicalChannelNumber2 = -1;    /* LogicalChannelNumber */
static int hf_h245_skew = -1;                     /* INTEGER_0_4095 */
static int hf_h245_maximumSkew = -1;              /* INTEGER_0_4095 */
static int hf_h245_signalAddress = -1;            /* TransportAddress */
static int hf_h245_vendor = -1;                   /* NonStandardIdentifier */
static int hf_h245_productNumber = -1;            /* OCTET_STRING_SIZE_1_256 */
static int hf_h245_versionNumber = -1;            /* OCTET_STRING_SIZE_1_256 */
static int hf_h245_ind_aal = -1;                  /* Ind_aal */
static int hf_h245_ind_aal1 = -1;                 /* Ind_aal1 */
static int hf_h245_ind_clockRecovery = -1;        /* Ind_clockRecovery */
static int hf_h245_ind_errorCorrection = -1;      /* Ind_errorCorrection */
static int hf_h245_ind_aal5 = -1;                 /* Ind_aal5 */
static int hf_h245_ind_multiplex = -1;            /* Ind_multiplex */
static int hf_h245_ind_reverseParameters = -1;    /* Ind_reverseParameters */
static int hf_h245_indr_multiplex = -1;           /* IndR_multiplex */
static int hf_h245_iv8 = -1;                      /* IV8 */
static int hf_h245_iv16 = -1;                     /* IV16 */
static int hf_h245_iv = -1;                       /* OCTET_STRING */
static int hf_h245_alphanumeric = -1;             /* GeneralString */
static int hf_h245_userInputSupportIndication = -1;  /* T_userInputSupportIndication */
static int hf_h245_signal = -1;                   /* T_signal */
static int hf_h245_signalType = -1;               /* IA5String_SIZE_1 */
static int hf_h245_duration = -1;                 /* INTEGER_1_65535 */
static int hf_h245_rtp = -1;                      /* Rtp */
static int hf_h245_rtpPayloadIndication = -1;     /* NULL */
static int hf_h245_paramS = -1;                   /* Params */
static int hf_h245_encryptedSignalType = -1;      /* OCTET_STRING_SIZE_1 */
static int hf_h245_signalUpdate = -1;             /* T_signalUpdate */
static int hf_h245_si_rtp = -1;                   /* Si_rtp */
static int hf_h245_extendedAlphanumeric = -1;     /* T_extendedAlphanumeric */
static int hf_h245_encryptedAlphanumeric = -1;    /* EncryptedAlphanumeric */
static int hf_h245_algorithmOID = -1;             /* OBJECT_IDENTIFIER */
static int hf_h245_encrypted = -1;                /* OCTET_STRING */
static int hf_h245_timestamp = -1;                /* INTEGER_0_4294967295 */
static int hf_h245_expirationTime = -1;           /* INTEGER_0_4294967295 */

/*--- End of included file: packet-h245-hf.c ---*/


/* Initialize the subtree pointers */

/*--- Included file: packet-h245-ett.c ---*/

static gint ett_h245_MultimediaSystemControlMessage = -1;
static gint ett_h245_RequestMessage = -1;
static gint ett_h245_ResponseMessage = -1;
static gint ett_h245_CommandMessage = -1;
static gint ett_h245_IndicationMessage = -1;
static gint ett_h245_GenericMessage = -1;
static gint ett_h245_SEQUENCE_OF_GenericParameter = -1;
static gint ett_h245_NonStandardMessage = -1;
static gint ett_h245_NonStandardParameter = -1;
static gint ett_h245_NonStandardIdentifier = -1;
static gint ett_h245_H221NonStandardID = -1;
static gint ett_h245_MasterSlaveDetermination = -1;
static gint ett_h245_MasterSlaveDeterminationAck = -1;
static gint ett_h245_T_decision = -1;
static gint ett_h245_MasterSlaveDeterminationReject = -1;
static gint ett_h245_MasterSlaveDeterminationRejectCause = -1;
static gint ett_h245_MasterSlaveDeterminationRelease = -1;
static gint ett_h245_TerminalCapabilitySet = -1;
static gint ett_h245_SET_SIZE_1_256_OF_CapabilityTableEntry = -1;
static gint ett_h245_SET_SIZE_1_256_OF_CapabilityDescriptor = -1;
static gint ett_h245_CapabilityTableEntry = -1;
static gint ett_h245_CapabilityDescriptor = -1;
static gint ett_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet = -1;
static gint ett_h245_AlternativeCapabilitySet = -1;
static gint ett_h245_TerminalCapabilitySetAck = -1;
static gint ett_h245_TerminalCapabilitySetReject = -1;
static gint ett_h245_TerminalCapabilitySetRejectCause = -1;
static gint ett_h245_T_tableEntryCapacityExceeded = -1;
static gint ett_h245_TerminalCapabilitySetRelease = -1;
static gint ett_h245_Capability = -1;
static gint ett_h245_T_h233EncryptionReceiveCapability = -1;
static gint ett_h245_H235SecurityCapability = -1;
static gint ett_h245_MultiplexCapability = -1;
static gint ett_h245_H222Capability = -1;
static gint ett_h245_SET_OF_VCCapability = -1;
static gint ett_h245_VCCapability = -1;
static gint ett_h245_T_aal1 = -1;
static gint ett_h245_T_aal5 = -1;
static gint ett_h245_T_availableBitRates = -1;
static gint ett_h245_Avb_type = -1;
static gint ett_h245_T_rangeOfBitRates = -1;
static gint ett_h245_T_aal1ViaGateway = -1;
static gint ett_h245_SET_SIZE_1_256_OF_Q2931Address = -1;
static gint ett_h245_H223Capability = -1;
static gint ett_h245_T_h223MultiplexTableCapability = -1;
static gint ett_h245_T_enhanced = -1;
static gint ett_h245_T_mobileOperationTransmitCapability = -1;
static gint ett_h245_T_mobileMultilinkFrameCapability = -1;
static gint ett_h245_H223AnnexCCapability = -1;
static gint ett_h245_V76Capability = -1;
static gint ett_h245_V75Capability = -1;
static gint ett_h245_H2250Capability = -1;
static gint ett_h245_T_mcCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_RedundancyEncodingCapability = -1;
static gint ett_h245_MediaPacketizationCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_RTPPayloadType = -1;
static gint ett_h245_RSVPParameters = -1;
static gint ett_h245_QOSMode = -1;
static gint ett_h245_ATMParameters = -1;
static gint ett_h245_QOSCapability = -1;
static gint ett_h245_MediaTransportType = -1;
static gint ett_h245_T_atm_AAL5_compressed = -1;
static gint ett_h245_MediaChannelCapability = -1;
static gint ett_h245_TransportCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_QOSCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_MediaChannelCapability = -1;
static gint ett_h245_RedundancyEncodingCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_CapabilityTableEntryNumber = -1;
static gint ett_h245_RedundancyEncodingMethod = -1;
static gint ett_h245_RTPH263VideoRedundancyEncoding = -1;
static gint ett_h245_T_frameToThreadMapping = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_RTPH263VideoRedundancyFrameMapping = -1;
static gint ett_h245_T_containedThreads = -1;
static gint ett_h245_RTPH263VideoRedundancyFrameMapping = -1;
static gint ett_h245_T_frameSequence = -1;
static gint ett_h245_MultipointCapability = -1;
static gint ett_h245_SEQUENCE_OF_MediaDistributionCapability = -1;
static gint ett_h245_MediaDistributionCapability = -1;
static gint ett_h245_SEQUENCE_OF_DataApplicationCapability = -1;
static gint ett_h245_VideoCapability = -1;
static gint ett_h245_ExtendedVideoCapability = -1;
static gint ett_h245_SEQUENCE_OF_VideoCapability = -1;
static gint ett_h245_SEQUENCE_OF_GenericCapability = -1;
static gint ett_h245_H261VideoCapability = -1;
static gint ett_h245_H262VideoCapability = -1;
static gint ett_h245_H263VideoCapability = -1;
static gint ett_h245_EnhancementLayerInfo = -1;
static gint ett_h245_SET_SIZE_1_14_OF_EnhancementOptions = -1;
static gint ett_h245_SET_SIZE_1_14_OF_BEnhancementParameters = -1;
static gint ett_h245_BEnhancementParameters = -1;
static gint ett_h245_EnhancementOptions = -1;
static gint ett_h245_H263Options = -1;
static gint ett_h245_SET_SIZE_1_16_OF_CustomPictureClockFrequency = -1;
static gint ett_h245_SET_SIZE_1_16_OF_CustomPictureFormat = -1;
static gint ett_h245_SET_SIZE_1_16_OF_H263VideoModeCombos = -1;
static gint ett_h245_TransparencyParameters = -1;
static gint ett_h245_RefPictureSelection = -1;
static gint ett_h245_T_additionalPictureMemory = -1;
static gint ett_h245_T_videoBackChannelSend = -1;
static gint ett_h245_T_enhancedReferencePicSelect = -1;
static gint ett_h245_T_subPictureRemovalParameters = -1;
static gint ett_h245_CustomPictureClockFrequency = -1;
static gint ett_h245_CustomPictureFormat = -1;
static gint ett_h245_T_mPI = -1;
static gint ett_h245_T_customPCF = -1;
static gint ett_h245_T_customPCF_item = -1;
static gint ett_h245_T_pixelAspectInformation = -1;
static gint ett_h245_T_pixelAspectCode = -1;
static gint ett_h245_T_extendedPAR = -1;
static gint ett_h245_T_extendedPAR_item = -1;
static gint ett_h245_H263VideoModeCombos = -1;
static gint ett_h245_SET_SIZE_1_16_OF_H263ModeComboFlags = -1;
static gint ett_h245_H263ModeComboFlags = -1;
static gint ett_h245_H263Version3Options = -1;
static gint ett_h245_IS11172VideoCapability = -1;
static gint ett_h245_AudioCapability = -1;
static gint ett_h245_T_g7231 = -1;
static gint ett_h245_G729Extensions = -1;
static gint ett_h245_G7231AnnexCCapability = -1;
static gint ett_h245_G723AnnexCAudioMode = -1;
static gint ett_h245_IS11172AudioCapability = -1;
static gint ett_h245_IS13818AudioCapability = -1;
static gint ett_h245_GSMAudioCapability = -1;
static gint ett_h245_VBDCapability = -1;
static gint ett_h245_DataApplicationCapability = -1;
static gint ett_h245_Application = -1;
static gint ett_h245_T_t84 = -1;
static gint ett_h245_T_t38fax = -1;
static gint ett_h245_DataProtocolCapability = -1;
static gint ett_h245_T_v76wCompression = -1;
static gint ett_h245_CompressionType = -1;
static gint ett_h245_V42bis = -1;
static gint ett_h245_T84Profile = -1;
static gint ett_h245_T_t84Restricted = -1;
static gint ett_h245_T38FaxProfile = -1;
static gint ett_h245_T38FaxRateManagement = -1;
static gint ett_h245_T38FaxUdpOptions = -1;
static gint ett_h245_T_t38FaxUdpEC = -1;
static gint ett_h245_T38FaxTcpOptions = -1;
static gint ett_h245_Nlpid = -1;
static gint ett_h245_EncryptionAuthenticationAndIntegrity = -1;
static gint ett_h245_EncryptionCapability = -1;
static gint ett_h245_MediaEncryptionAlgorithm = -1;
static gint ett_h245_AuthenticationCapability = -1;
static gint ett_h245_IntegrityCapability = -1;
static gint ett_h245_UserInputCapability = -1;
static gint ett_h245_SEQUENCE_SIZE_1_16_OF_NonStandardParameter = -1;
static gint ett_h245_ConferenceCapability = -1;
static gint ett_h245_SEQUENCE_OF_NonStandardParameter = -1;
static gint ett_h245_GenericCapability = -1;
static gint ett_h245_CapabilityIdentifier = -1;
static gint ett_h245_GenericParameter = -1;
static gint ett_h245_SEQUENCE_OF_ParameterIdentifier = -1;
static gint ett_h245_ParameterIdentifier = -1;
static gint ett_h245_ParameterValue = -1;
static gint ett_h245_MultiplexedStreamCapability = -1;
static gint ett_h245_MultiplexFormat = -1;
static gint ett_h245_AudioTelephonyEventCapability = -1;
static gint ett_h245_AudioToneCapability = -1;
static gint ett_h245_NoPTAudioTelephonyEventCapability = -1;
static gint ett_h245_NoPTAudioToneCapability = -1;
static gint ett_h245_MultiplePayloadStreamCapability = -1;
static gint ett_h245_FECCapability = -1;
static gint ett_h245_FECC_rfc2733 = -1;
static gint ett_h245_T_separateStream = -1;
static gint ett_h245_OpenLogicalChannel = -1;
static gint ett_h245_T_forwardLogicalChannelParameters = -1;
static gint ett_h245_OLC_forw_multiplexParameters = -1;
static gint ett_h245_OLC_reverseLogicalChannelParameters = -1;
static gint ett_h245_OLC_rev_multiplexParameters = -1;
static gint ett_h245_NetworkAccessParameters = -1;
static gint ett_h245_T_distribution = -1;
static gint ett_h245_T_networkAddress = -1;
static gint ett_h245_T_t120SetupProcedure = -1;
static gint ett_h245_Q2931Address = -1;
static gint ett_h245_T_address = -1;
static gint ett_h245_V75Parameters = -1;
static gint ett_h245_DataType = -1;
static gint ett_h245_H235Media = -1;
static gint ett_h245_T_mediaType = -1;
static gint ett_h245_MultiplexedStreamParameter = -1;
static gint ett_h245_H222LogicalChannelParameters = -1;
static gint ett_h245_H223LogicalChannelParameters = -1;
static gint ett_h245_T_adaptationLayerType = -1;
static gint ett_h245_Al3 = -1;
static gint ett_h245_H223AL1MParameters = -1;
static gint ett_h245_T_transferMode = -1;
static gint ett_h245_AL1HeaderFEC = -1;
static gint ett_h245_AL1CrcLength = -1;
static gint ett_h245_ArqType = -1;
static gint ett_h245_H223AL2MParameters = -1;
static gint ett_h245_AL2HeaderFEC = -1;
static gint ett_h245_H223AL3MParameters = -1;
static gint ett_h245_T_headerFormat = -1;
static gint ett_h245_AL3CrcLength = -1;
static gint ett_h245_H223AnnexCArqParameters = -1;
static gint ett_h245_T_numberOfRetransmissions = -1;
static gint ett_h245_V76LogicalChannelParameters = -1;
static gint ett_h245_T_suspendResume = -1;
static gint ett_h245_V76LCP_mode = -1;
static gint ett_h245_T_eRM = -1;
static gint ett_h245_T_recovery = -1;
static gint ett_h245_V76HDLCParameters = -1;
static gint ett_h245_CRCLength = -1;
static gint ett_h245_H2250LogicalChannelParameters = -1;
static gint ett_h245_T_mediaPacketization = -1;
static gint ett_h245_RTPPayloadType = -1;
static gint ett_h245_T_payloadDescriptor = -1;
static gint ett_h245_RedundancyEncoding = -1;
static gint ett_h245_T_rtpRedundancyEncoding = -1;
static gint ett_h245_SEQUENCE_OF_RedundancyEncodingElement = -1;
static gint ett_h245_RedundancyEncodingElement = -1;
static gint ett_h245_MultiplePayloadStream = -1;
static gint ett_h245_SEQUENCE_OF_MultiplePayloadStreamElement = -1;
static gint ett_h245_MultiplePayloadStreamElement = -1;
static gint ett_h245_FECData = -1;
static gint ett_h245_RFC2733Data = -1;
static gint ett_h245_FECdata_mode = -1;
static gint ett_h245_Moderfc2733 = -1;
static gint ett_h245_SeparateStream = -1;
static gint ett_h245_T_differentPort = -1;
static gint ett_h245_T_samePort = -1;
static gint ett_h245_TransportAddress = -1;
static gint ett_h245_UnicastAddress = -1;
static gint ett_h245_T_iPAddress = -1;
static gint ett_h245_T_iPXAddress = -1;
static gint ett_h245_T_iP6Address = -1;
static gint ett_h245_T_iPSourceRouteAddress = -1;
static gint ett_h245_T_routing = -1;
static gint ett_h245_T_route = -1;
static gint ett_h245_MulticastAddress = -1;
static gint ett_h245_MIPAddress = -1;
static gint ett_h245_MIP6Address = -1;
static gint ett_h245_EncryptionSync = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_EscrowData = -1;
static gint ett_h245_EscrowData = -1;
static gint ett_h245_OpenLogicalChannelAck = -1;
static gint ett_h245_OLC_ack_reverseLogicalChannelParameters = -1;
static gint ett_h245_T_multiplexParameters = -1;
static gint ett_h245_T_forwardMultiplexAckParameters = -1;
static gint ett_h245_OpenLogicalChannelReject = -1;
static gint ett_h245_OpenLogicalChannelRejectCause = -1;
static gint ett_h245_OpenLogicalChannelConfirm = -1;
static gint ett_h245_H2250LogicalChannelAckParameters = -1;
static gint ett_h245_CloseLogicalChannel = -1;
static gint ett_h245_T_source = -1;
static gint ett_h245_clc_reason = -1;
static gint ett_h245_CloseLogicalChannelAck = -1;
static gint ett_h245_RequestChannelClose = -1;
static gint ett_h245_T_reason = -1;
static gint ett_h245_RequestChannelCloseAck = -1;
static gint ett_h245_RequestChannelCloseReject = -1;
static gint ett_h245_RequestChannelCloseRejectCause = -1;
static gint ett_h245_RequestChannelCloseRelease = -1;
static gint ett_h245_MultiplexEntrySend = -1;
static gint ett_h245_SET_SIZE_1_15_OF_MultiplexEntryDescriptor = -1;
static gint ett_h245_MultiplexEntryDescriptor = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_MultiplexElement = -1;
static gint ett_h245_MultiplexElement = -1;
static gint ett_h245_Me_type = -1;
static gint ett_h245_SEQUENCE_SIZE_2_255_OF_MultiplexElement = -1;
static gint ett_h245_ME_repeatCount = -1;
static gint ett_h245_MultiplexEntrySendAck = -1;
static gint ett_h245_SET_SIZE_1_15_OF_MultiplexTableEntryNumber = -1;
static gint ett_h245_MultiplexEntrySendReject = -1;
static gint ett_h245_SET_SIZE_1_15_OF_MultiplexEntryRejectionDescriptions = -1;
static gint ett_h245_MultiplexEntryRejectionDescriptions = -1;
static gint ett_h245_MultiplexEntryRejectionDescriptionsCause = -1;
static gint ett_h245_MultiplexEntrySendRelease = -1;
static gint ett_h245_RequestMultiplexEntry = -1;
static gint ett_h245_RequestMultiplexEntryAck = -1;
static gint ett_h245_RequestMultiplexEntryReject = -1;
static gint ett_h245_SET_SIZE_1_15_OF_RequestMultiplexEntryRejectionDescriptions = -1;
static gint ett_h245_RequestMultiplexEntryRejectionDescriptions = -1;
static gint ett_h245_RequestMultiplexEntryRejectionDescriptionsCause = -1;
static gint ett_h245_RequestMultiplexEntryRelease = -1;
static gint ett_h245_RequestMode = -1;
static gint ett_h245_SEQUENCE_SIZE_1_256_OF_ModeDescription = -1;
static gint ett_h245_RequestModeAck = -1;
static gint ett_h245_Req_mode_ack_response = -1;
static gint ett_h245_RequestModeReject = -1;
static gint ett_h245_RequestModeRejectCause = -1;
static gint ett_h245_RequestModeRelease = -1;
static gint ett_h245_ModeDescription = -1;
static gint ett_h245_ModeElementType = -1;
static gint ett_h245_ModeElement = -1;
static gint ett_h245_H235Mode = -1;
static gint ett_h245_T_mediaMode = -1;
static gint ett_h245_MultiplexedStreamModeParameters = -1;
static gint ett_h245_RedundancyEncodingDTMode = -1;
static gint ett_h245_SEQUENCE_OF_RedundancyEncodingDTModeElement = -1;
static gint ett_h245_RedundancyEncodingDTModeElement = -1;
static gint ett_h245_Re_type = -1;
static gint ett_h245_MultiplePayloadStreamMode = -1;
static gint ett_h245_SEQUENCE_OF_MultiplePayloadStreamElementMode = -1;
static gint ett_h245_MultiplePayloadStreamElementMode = -1;
static gint ett_h245_FECMode = -1;
static gint ett_h245_T_rfc2733Mode = -1;
static gint ett_h245_FEC_mode = -1;
static gint ett_h245_H223ModeParameters = -1;
static gint ett_h245_AdaptationLayerType = -1;
static gint ett_h245_V76ModeParameters = -1;
static gint ett_h245_H2250ModeParameters = -1;
static gint ett_h245_RedundancyEncodingMode = -1;
static gint ett_h245_T_secondaryEncoding = -1;
static gint ett_h245_VideoMode = -1;
static gint ett_h245_H261VideoMode = -1;
static gint ett_h245_H261Resolution = -1;
static gint ett_h245_H262VideoMode = -1;
static gint ett_h245_T_profileAndLevel = -1;
static gint ett_h245_H263VideoMode = -1;
static gint ett_h245_H263Resolution = -1;
static gint ett_h245_IS11172VideoMode = -1;
static gint ett_h245_AudioMode = -1;
static gint ett_h245_Mode_g7231 = -1;
static gint ett_h245_IS11172AudioMode = -1;
static gint ett_h245_T_audioLayer = -1;
static gint ett_h245_T_audioSampling = -1;
static gint ett_h245_IS11172_multichannelType = -1;
static gint ett_h245_IS13818AudioMode = -1;
static gint ett_h245_IS13818AudioLayer = -1;
static gint ett_h245_IS13818AudioSampling = -1;
static gint ett_h245_IS13818MultichannelType = -1;
static gint ett_h245_G7231AnnexCMode = -1;
static gint ett_h245_VBDMode = -1;
static gint ett_h245_DataMode = -1;
static gint ett_h245_DataModeApplication = -1;
static gint ett_h245_T38faxApp = -1;
static gint ett_h245_EncryptionMode = -1;
static gint ett_h245_RoundTripDelayRequest = -1;
static gint ett_h245_RoundTripDelayResponse = -1;
static gint ett_h245_MaintenanceLoopRequest = -1;
static gint ett_h245_Mlr_type = -1;
static gint ett_h245_MaintenanceLoopAck = -1;
static gint ett_h245_Mla_type = -1;
static gint ett_h245_MaintenanceLoopReject = -1;
static gint ett_h245_Mlrej_type = -1;
static gint ett_h245_MaintenanceLoopRejectCause = -1;
static gint ett_h245_MaintenanceLoopOffCommand = -1;
static gint ett_h245_CommunicationModeCommand = -1;
static gint ett_h245_SET_SIZE_1_256_OF_CommunicationModeTableEntry = -1;
static gint ett_h245_CommunicationModeRequest = -1;
static gint ett_h245_CommunicationModeResponse = -1;
static gint ett_h245_CommunicationModeTableEntry = -1;
static gint ett_h245_T_dataType = -1;
static gint ett_h245_ConferenceRequest = -1;
static gint ett_h245_T_requestTerminalCertificate = -1;
static gint ett_h245_CertSelectionCriteria = -1;
static gint ett_h245_Criteria = -1;
static gint ett_h245_TerminalLabel = -1;
static gint ett_h245_ConferenceResponse = -1;
static gint ett_h245_T_mCTerminalIDResponse = -1;
static gint ett_h245_T_terminalIDResponse = -1;
static gint ett_h245_T_conferenceIDResponse = -1;
static gint ett_h245_T_passwordResponse = -1;
static gint ett_h245_SET_SIZE_1_256_OF_TerminalLabel = -1;
static gint ett_h245_T_makeMeChairResponse = -1;
static gint ett_h245_T_extensionAddressResponse = -1;
static gint ett_h245_T_chairTokenOwnerResponse = -1;
static gint ett_h245_T_terminalCertificateResponse = -1;
static gint ett_h245_T_broadcastMyLogicalChannelResponse = -1;
static gint ett_h245_T_makeTerminalBroadcasterResponse = -1;
static gint ett_h245_T_sendThisSourceResponse = -1;
static gint ett_h245_RequestAllTerminalIDsResponse = -1;
static gint ett_h245_SEQUENCE_OF_TerminalInformation = -1;
static gint ett_h245_TerminalInformation = -1;
static gint ett_h245_RemoteMCRequest = -1;
static gint ett_h245_RemoteMCResponse = -1;
static gint ett_h245_T_reject = -1;
static gint ett_h245_MultilinkRequest = -1;
static gint ett_h245_CallInformationReq = -1;
static gint ett_h245_AddConnectionReq = -1;
static gint ett_h245_MaximumHeaderIntervalReq = -1;
static gint ett_h245_T_requestType = -1;
static gint ett_h245_MultilinkResponse = -1;
static gint ett_h245_CallInformationResp = -1;
static gint ett_h245_AddConnectionResp = -1;
static gint ett_h245_T_responseCode = -1;
static gint ett_h245_T_rejected = -1;
static gint ett_h245_MaximumHeaderIntervalResp = -1;
static gint ett_h245_RemoveConnection = -1;
static gint ett_h245_MultilinkIndication = -1;
static gint ett_h245_T_crcDesired = -1;
static gint ett_h245_T_excessiveError = -1;
static gint ett_h245_DialingInformation = -1;
static gint ett_h245_SET_SIZE_1_65535_OF_DialingInformationNumber = -1;
static gint ett_h245_DialingInformationNumber = -1;
static gint ett_h245_SET_SIZE_1_255_OF_DialingInformationNetworkType = -1;
static gint ett_h245_DialingInformationNetworkType = -1;
static gint ett_h245_ConnectionIdentifier = -1;
static gint ett_h245_LogicalChannelRateRequest = -1;
static gint ett_h245_LogicalChannelRateAcknowledge = -1;
static gint ett_h245_LogicalChannelRateReject = -1;
static gint ett_h245_LogicalChannelRateRejectReason = -1;
static gint ett_h245_LogicalChannelRateRelease = -1;
static gint ett_h245_SendTerminalCapabilitySet = -1;
static gint ett_h245_T_specificRequest = -1;
static gint ett_h245_SET_SIZE_1_65535_OF_CapabilityTableEntryNumber = -1;
static gint ett_h245_SET_SIZE_1_256_OF_CapabilityDescriptorNumber = -1;
static gint ett_h245_EncryptionCommand = -1;
static gint ett_h245_T_encryptionAlgorithmID = -1;
static gint ett_h245_FlowControlCommand = -1;
static gint ett_h245_Scope = -1;
static gint ett_h245_Restriction = -1;
static gint ett_h245_EndSessionCommand = -1;
static gint ett_h245_T_gstnOptions = -1;
static gint ett_h245_T_isdnOptions = -1;
static gint ett_h245_ConferenceCommand = -1;
static gint ett_h245_SubstituteConferenceIDCommand = -1;
static gint ett_h245_EncryptionUpdateDirection = -1;
static gint ett_h245_MiscellaneousCommand = -1;
static gint ett_h245_Mc_type = -1;
static gint ett_h245_T_videoFastUpdateGOB = -1;
static gint ett_h245_T_videoFastUpdateMB = -1;
static gint ett_h245_T_progressiveRefinementStart = -1;
static gint ett_h245_T_videoBadMBs = -1;
static gint ett_h245_SEQUENCE_OF_PictureReference = -1;
static gint ett_h245_T_lostPartialPicture = -1;
static gint ett_h245_T_encryptionUpdateCommand = -1;
static gint ett_h245_T_encryptionUpdateAck = -1;
static gint ett_h245_RepeatCount = -1;
static gint ett_h245_KeyProtectionMethod = -1;
static gint ett_h245_EncryptionUpdateRequest = -1;
static gint ett_h245_PictureReference = -1;
static gint ett_h245_H223MultiplexReconfiguration = -1;
static gint ett_h245_T_h223ModeChange = -1;
static gint ett_h245_T_h223AnnexADoubleFlag = -1;
static gint ett_h245_NewATMVCCommand = -1;
static gint ett_h245_Cmd_aal = -1;
static gint ett_h245_Cmd_aal1 = -1;
static gint ett_h245_Cmd_clockRecovery = -1;
static gint ett_h245_Cmd_errorCorrection = -1;
static gint ett_h245_Cmd_aal5 = -1;
static gint ett_h245_Cmd_multiplex = -1;
static gint ett_h245_Cmd_reverseParameters = -1;
static gint ett_h245_CmdR_multiplex = -1;
static gint ett_h245_MobileMultilinkReconfigurationCommand = -1;
static gint ett_h245_T_status = -1;
static gint ett_h245_FunctionNotUnderstood = -1;
static gint ett_h245_FunctionNotSupported = -1;
static gint ett_h245_FunctionNotSupportedCause = -1;
static gint ett_h245_ConferenceIndication = -1;
static gint ett_h245_TerminalYouAreSeeingInSubPictureNumber = -1;
static gint ett_h245_VideoIndicateCompose = -1;
static gint ett_h245_MiscellaneousIndication = -1;
static gint ett_h245_Mi_type = -1;
static gint ett_h245_T_videoNotDecodedMBs = -1;
static gint ett_h245_JitterIndication = -1;
static gint ett_h245_H223SkewIndication = -1;
static gint ett_h245_H2250MaximumSkewIndication = -1;
static gint ett_h245_MCLocationIndication = -1;
static gint ett_h245_VendorIdentification = -1;
static gint ett_h245_NewATMVCIndication = -1;
static gint ett_h245_Ind_aal = -1;
static gint ett_h245_Ind_aal1 = -1;
static gint ett_h245_Ind_clockRecovery = -1;
static gint ett_h245_Ind_errorCorrection = -1;
static gint ett_h245_Ind_aal5 = -1;
static gint ett_h245_Ind_multiplex = -1;
static gint ett_h245_Ind_reverseParameters = -1;
static gint ett_h245_IndR_multiplex = -1;
static gint ett_h245_Params = -1;
static gint ett_h245_UserInputIndication = -1;
static gint ett_h245_T_userInputSupportIndication = -1;
static gint ett_h245_T_signal = -1;
static gint ett_h245_T_signalUpdate = -1;
static gint ett_h245_Si_rtp = -1;
static gint ett_h245_T_extendedAlphanumeric = -1;
static gint ett_h245_EncryptedAlphanumeric = -1;
static gint ett_h245_Rtp = -1;
static gint ett_h245_FlowControlIndication = -1;
static gint ett_h245_MobileMultilinkReconfigurationIndication = -1;

/*--- End of included file: packet-h245-ett.c ---*/



/*--- Included file: packet-h245-fn.c ---*/

/*--- Cyclic dependencies ---*/

/* GenericParameter -> ParameterValue -> ParameterValue/genericParameter -> GenericParameter */
static int dissect_h245_GenericParameter(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_messageContent_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericParameter(tvb, offset, pinfo, tree, hf_h245_messageContent_item);
}
static int dissect_collapsing_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericParameter(tvb, offset, pinfo, tree, hf_h245_collapsing_item);
}
static int dissect_nonCollapsing_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericParameter(tvb, offset, pinfo, tree, hf_h245_nonCollapsing_item);
}
static int dissect_genericParameter_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericParameter(tvb, offset, pinfo, tree, hf_h245_genericParameter_item);
}

/* VideoCapability -> ExtendedVideoCapability -> ExtendedVideoCapability/videoCapability -> VideoCapability */
static int dissect_h245_VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_receiveVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoCapability(tvb, offset, pinfo, tree, hf_h245_receiveVideoCapability);
}
static int dissect_transmitVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoCapability(tvb, offset, pinfo, tree, hf_h245_transmitVideoCapability);
}
static int dissect_receiveAndTransmitVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitVideoCapability);
}
static int dissect_videoCapability_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoCapability(tvb, offset, pinfo, tree, hf_h245_videoCapability_item);
}
static int dissect_videoData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoCapability(tvb, offset, pinfo, tree, hf_h245_videoData);
}

/* AudioCapability -> VBDCapability -> AudioCapability */
static int dissect_h245_AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_receiveAudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioCapability(tvb, offset, pinfo, tree, hf_h245_receiveAudioCapability);
}
static int dissect_transmitAudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioCapability(tvb, offset, pinfo, tree, hf_h245_transmitAudioCapability);
}
static int dissect_receiveAndTransmitAudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitAudioCapability);
}
static int dissect_vbd_cap_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioCapability(tvb, offset, pinfo, tree, hf_h245_vbd_cap_type);
}
static int dissect_audioData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioCapability(tvb, offset, pinfo, tree, hf_h245_audioData);
}

/* DataType -> H235Media -> H235Media/mediaType -> RedundancyEncoding -> DataType */
/* DataType -> H235Media -> H235Media/mediaType -> RedundancyEncoding -> RedundancyEncoding/rtpRedundancyEncoding -> RedundancyEncodingElement -> DataType */
/* DataType -> H235Media -> H235Media/mediaType -> MultiplePayloadStream -> MultiplePayloadStream/elements -> MultiplePayloadStreamElement -> DataType */
static int dissect_h245_DataType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_dataType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataType(tvb, offset, pinfo, tree, hf_h245_dataType);
}
static int dissect_secondaryEncoding3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataType(tvb, offset, pinfo, tree, hf_h245_secondaryEncoding3);
}

/* MultiplexElement -> MultiplexElement/type -> MultiplexElement/type/subElementList -> MultiplexElement */
static int dissect_h245_MultiplexElement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_elementList_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexElement(tvb, offset, pinfo, tree, hf_h245_elementList_item);
}
static int dissect_subElementList_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexElement(tvb, offset, pinfo, tree, hf_h245_subElementList_item);
}

/* AudioMode -> VBDMode -> AudioMode */
static int dissect_h245_AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_audioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioMode(tvb, offset, pinfo, tree, hf_h245_audioMode);
}
static int dissect_vbd_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioMode(tvb, offset, pinfo, tree, hf_h245_vbd_type);
}

/* ModeElementType -> MultiplePayloadStreamMode -> MultiplePayloadStreamMode/mpsmElements -> MultiplePayloadStreamElementMode -> ModeElementType */
static int dissect_h245_ModeElementType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, int hf_index);

static int dissect_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ModeElementType(tvb, offset, pinfo, tree, hf_h245_type);
}


/*--- Fields for imported types ---*/



static int
dissect_h245_OBJECT_IDENTIFIER(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_object_identifier(tvb, offset, pinfo, tree, hf_index,
                                         NULL);

  return offset;
}
static int dissect_object(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_object);
}
static int dissect_protocolIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_protocolIdentifier);
}
static int dissect_algorithm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_algorithm);
}
static int dissect_antiSpamAlgorithm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_antiSpamAlgorithm);
}
static int dissect_oid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_oid);
}
static int dissect_escrowID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_escrowID);
}
static int dissect_field(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_field);
}
static int dissect_algorithmOID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OBJECT_IDENTIFIER(tvb, offset, pinfo, tree, hf_h245_algorithmOID);
}



static int
dissect_h245_T_t35CountryCode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 255U, &t35CountryCode, NULL, FALSE);

  return offset;
}
static int dissect_t35CountryCode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t35CountryCode(tvb, offset, pinfo, tree, hf_h245_t35CountryCode);
}



static int
dissect_h245_T_t35Extension(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 255U, &t35Extension, NULL, FALSE);

  return offset;
}
static int dissect_t35Extension(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t35Extension(tvb, offset, pinfo, tree, hf_h245_t35Extension);
}



static int
dissect_h245_T_manufacturerCode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 65535U, &manufacturerCode, NULL, FALSE);

  return offset;
}
static int dissect_manufacturerCode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_manufacturerCode(tvb, offset, pinfo, tree, hf_h245_manufacturerCode);
}

static const per_sequence_t H221NonStandardID_sequence[] = {
  { "t35CountryCode"              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t35CountryCode },
  { "t35Extension"                , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t35Extension },
  { "manufacturerCode"            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_manufacturerCode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H221NonStandardID(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  t35CountryCode = 0;
  t35Extension = 0;
  manufacturerCode = 0;
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H221NonStandardID, H221NonStandardID_sequence);

  h221NonStandard = ((t35CountryCode * 256) + t35Extension) * 65536 + manufacturerCode;
  proto_tree_add_uint(tree, hf_h245Manufacturer, tvb, (offset>>3)-4, 4, h221NonStandard);

  return offset;
}
static int dissect_h221NonStandardID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H221NonStandardID(tvb, offset, pinfo, tree, hf_h245_h221NonStandardID);
}


static const value_string h245_NonStandardIdentifier_vals[] = {
  {   0, "object" },
  {   1, "h221NonStandard" },
  { 0, NULL }
};

static const per_choice_t NonStandardIdentifier_choice[] = {
  {   0, "object"                      , ASN1_NO_EXTENSIONS     , dissect_object },
  {   1, "h221NonStandard"             , ASN1_NO_EXTENSIONS     , dissect_h221NonStandardID },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_NonStandardIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_NonStandardIdentifier, NonStandardIdentifier_choice, "NonStandardIdentifier",
                              NULL);

  return offset;
}
static int dissect_nonStandardIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardIdentifier(tvb, offset, pinfo, tree, hf_h245_nonStandardIdentifier);
}
static int dissect_vendor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardIdentifier(tvb, offset, pinfo, tree, hf_h245_vendor);
}


static int
dissect_h245_OCTET_STRING(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    -1, -1,
                                    NULL, NULL);

  return offset;
}
static int dissect_nsd_data(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_nsd_data);
}
static int dissect_nlpidData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_nlpidData);
}
static int dissect_nonCollapsingRaw(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_nonCollapsingRaw);
}
static int dissect_octetString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_octetString);
}
static int dissect_programDescriptors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_programDescriptors);
}
static int dissect_streamDescriptors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_streamDescriptors);
}
static int dissect_encryptionSE(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_encryptionSE);
}
static int dissect_returnedFunction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_returnedFunction);
}
static int dissect_iv(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_iv);
}
static int dissect_encrypted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING(tvb, offset, pinfo, tree, hf_h245_encrypted);
}

static const per_sequence_t NonStandardParameter_sequence[] = {
  { "nonStandardIdentifier"       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nonStandardIdentifier },
  { "data"                        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nsd_data },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NonStandardParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NonStandardParameter, NonStandardParameter_sequence);

  return offset;
}
static int dissect_nonStandardData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandardData);
}
static int dissect_nonStandard(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandard);
}
static int dissect_nonStandard_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandard_item);
}
static int dissect_nonStandardData_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandardData_item);
}
static int dissect_h221NonStandard(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_h221NonStandard);
}
static int dissect_h235Control(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_h235Control);
}
static int dissect_nonStandardAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandardAddress);
}
static int dissect_associatedAlgorithm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_associatedAlgorithm);
}

static const per_sequence_t NonStandardMessage_sequence[] = {
  { "nonStandardData"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nonStandardData },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NonStandardMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NonStandardMessage, NonStandardMessage_sequence);

  return offset;
}
static int dissect_nonStandardMsg(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NonStandardMessage(tvb, offset, pinfo, tree, hf_h245_nonStandardMsg);
}



static int
dissect_h245_INTEGER_0_255(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 255U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_terminalType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_terminalType);
}
static int dissect_h233IVResponseTime(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_h233IVResponseTime);
}
static int dissect_maxPendingReplacementFor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_maxPendingReplacementFor);
}
static int dissect_frameSequence_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_frameSequence_item);
}
static int dissect_version(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_version);
}
static int dissect_booleanArray(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_booleanArray);
}
static int dissect_sessionID_0_255(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_sessionID_0_255);
}
static int dissect_synchFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_synchFlag);
}
static int dissect_firstGOB_0_255(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_firstGOB_0_255);
}
static int dissect_longTermPictureIndex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_longTermPictureIndex);
}
static int dissect_subPictureNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_subPictureNumber);
}
static int dissect_compositionNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_compositionNumber);
}
static int dissect_temporalReference_0_255(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_255(tvb, offset, pinfo, tree, hf_h245_temporalReference_0_255);
}



static int
dissect_h245_INTEGER_0_16777215(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 16777215U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_statusDeterminationNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16777215(tvb, offset, pinfo, tree, hf_h245_statusDeterminationNumber);
}
static int dissect_sendBufferSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16777215(tvb, offset, pinfo, tree, hf_h245_sendBufferSize);
}
static int dissect_Res_maximumBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16777215(tvb, offset, pinfo, tree, hf_h245_Res_maximumBitRate);
}

static const per_sequence_t MasterSlaveDetermination_sequence[] = {
  { "terminalType"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalType },
  { "statusDeterminationNumber"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_statusDeterminationNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MasterSlaveDetermination(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MasterSlaveDetermination, MasterSlaveDetermination_sequence);


  h245_pi->msg_type = H245_MastSlvDet;
  return offset;
}
static int dissect_masterSlaveDetermination(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MasterSlaveDetermination(tvb, offset, pinfo, tree, hf_h245_masterSlaveDetermination);
}



static int
dissect_h245_SequenceNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 255U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_sequenceNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SequenceNumber(tvb, offset, pinfo, tree, hf_h245_sequenceNumber);
}
static int dissect_h233AlgorithmIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SequenceNumber(tvb, offset, pinfo, tree, hf_h245_h233AlgorithmIdentifier);
}



static int
dissect_h245_INTEGER_1_256(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 256U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_numberOfVCs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_numberOfVCs);
}
static int dissect_framesBetweenSyncPoints(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_framesBetweenSyncPoints);
}
static int dissect_presentationOrder(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_presentationOrder);
}
static int dissect_sqcifAdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_sqcifAdditionalPictureMemory);
}
static int dissect_qcifAdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_qcifAdditionalPictureMemory);
}
static int dissect_cifAdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_cifAdditionalPictureMemory);
}
static int dissect_cif4AdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_cif4AdditionalPictureMemory);
}
static int dissect_cif16AdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_cif16AdditionalPictureMemory);
}
static int dissect_bigCpfAdditionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_bigCpfAdditionalPictureMemory);
}
static int dissect_g711Alaw64k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g711Alaw64k);
}
static int dissect_g711Alaw56k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g711Alaw56k);
}
static int dissect_g711Ulaw64k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g711Ulaw64k);
}
static int dissect_g711Ulaw56k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g711Ulaw56k);
}
static int dissect_g722_64k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g722_64k);
}
static int dissect_g722_56k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g722_56k);
}
static int dissect_g722_48k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g722_48k);
}
static int dissect_maxAl_sduAudioFrames(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_maxAl_sduAudioFrames);
}
static int dissect_g728(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g728);
}
static int dissect_g729(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g729);
}
static int dissect_g729AnnexA(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g729AnnexA);
}
static int dissect_g729wAnnexB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g729wAnnexB);
}
static int dissect_g729AnnexAwAnnexB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_g729AnnexAwAnnexB);
}
static int dissect_audioUnit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_audioUnit);
}
static int dissect_audioUnitSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_audioUnitSize);
}
static int dissect_maximumStringLength(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_256(tvb, offset, pinfo, tree, hf_h245_maximumStringLength);
}


static int
dissect_h245_BOOLEAN(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_boolean(tvb, offset, pinfo, tree, hf_index,
                               NULL, NULL);

  return offset;
}
static int dissect_h233EncryptionTransmitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h233EncryptionTransmitCapability);
}
static int dissect_nullClockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_nullClockRecovery);
}
static int dissect_srtsClockRecovery_bool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_srtsClockRecovery_bool);
}
static int dissect_adaptiveClockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_adaptiveClockRecovery);
}
static int dissect_nullErrorCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_nullErrorCorrection);
}
static int dissect_longInterleaver(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_longInterleaver);
}
static int dissect_shortInterleaver(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_shortInterleaver);
}
static int dissect_errorCorrectionOnly(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_errorCorrectionOnly);
}
static int dissect_structuredDataTransfer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_structuredDataTransfer);
}
static int dissect_partiallyFilledCells(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_partiallyFilledCells);
}
static int dissect_transportStream_bool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_transportStream_bool);
}
static int dissect_programStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_programStream);
}
static int dissect_srtsClockRecoveryflag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_srtsClockRecoveryflag);
}
static int dissect_transportWithI_frames(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_transportWithI_frames);
}
static int dissect_videoWithAL1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL1);
}
static int dissect_videoWithAL2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL2);
}
static int dissect_videoWithAL3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL3);
}
static int dissect_audioWithAL1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL1);
}
static int dissect_audioWithAL2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL2);
}
static int dissect_audioWithAL3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL3);
}
static int dissect_dataWithAL1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL1);
}
static int dissect_dataWithAL2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL2);
}
static int dissect_dataWithAL3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL3);
}
static int dissect_maxMUXPDUSizeCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_maxMUXPDUSizeCapability);
}
static int dissect_nsrpSupport(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_nsrpSupport);
}
static int dissect_modeChangeCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_modeChangeCapability);
}
static int dissect_h223AnnexA(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h223AnnexA);
}
static int dissect_h223AnnexADoubleFlagFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h223AnnexADoubleFlagFlag);
}
static int dissect_h223AnnexB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h223AnnexB);
}
static int dissect_h223AnnexBwithHeader(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h223AnnexBwithHeader);
}
static int dissect_videoWithAL1M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL1M);
}
static int dissect_videoWithAL2M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL2M);
}
static int dissect_videoWithAL3M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoWithAL3M);
}
static int dissect_audioWithAL1M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL1M);
}
static int dissect_audioWithAL2M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL2M);
}
static int dissect_audioWithAL3M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioWithAL3M);
}
static int dissect_dataWithAL1M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL1M);
}
static int dissect_dataWithAL2M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL2M);
}
static int dissect_dataWithAL3M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataWithAL3M);
}
static int dissect_alpduInterleaving(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_alpduInterleaving);
}
static int dissect_rsCodeCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_rsCodeCapability);
}
static int dissect_suspendResumeCapabilitywAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_suspendResumeCapabilitywAddress);
}
static int dissect_suspendResumeCapabilitywoAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_suspendResumeCapabilitywoAddress);
}
static int dissect_rejCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_rejCapability);
}
static int dissect_sREJCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_sREJCapability);
}
static int dissect_mREJCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_mREJCapability);
}
static int dissect_crc8bitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_crc8bitCapability);
}
static int dissect_crc16bitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_crc16bitCapability);
}
static int dissect_crc32bitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_crc32bitCapability);
}
static int dissect_uihCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_uihCapability);
}
static int dissect_twoOctetAddressFieldCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_twoOctetAddressFieldCapability);
}
static int dissect_loopBackTestCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_loopBackTestCapability);
}
static int dissect_audioHeader(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioHeader);
}
static int dissect_centralizedConferenceMC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_centralizedConferenceMC);
}
static int dissect_decentralizedConferenceMC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_decentralizedConferenceMC);
}
static int dissect_rtcpVideoControlCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_rtcpVideoControlCapability);
}
static int dissect_logicalChannelSwitchingCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_logicalChannelSwitchingCapability);
}
static int dissect_t120DynamicPortCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_t120DynamicPortCapability);
}
static int dissect_h261aVideoPacketization(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_h261aVideoPacketization);
}
static int dissect_atmUBR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_atmUBR);
}
static int dissect_atmrtVBR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_atmrtVBR);
}
static int dissect_atmnrtVBR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_atmnrtVBR);
}
static int dissect_atmABR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_atmABR);
}
static int dissect_atmCBR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_atmCBR);
}
static int dissect_variable_delta(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_variable_delta);
}
static int dissect_multicastCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_multicastCapability);
}
static int dissect_multiUniCastConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_multiUniCastConference);
}
static int dissect_centralizedControl(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_centralizedControl);
}
static int dissect_distributedControl(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_distributedControl);
}
static int dissect_centralizedAudio(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_centralizedAudio);
}
static int dissect_distributedAudio(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_distributedAudio);
}
static int dissect_centralizedVideo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_centralizedVideo);
}
static int dissect_distributedVideo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_distributedVideo);
}
static int dissect_temporalSpatialTradeOffCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_temporalSpatialTradeOffCapability);
}
static int dissect_stillImageTransmission(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_stillImageTransmission);
}
static int dissect_videoBadMBsCap(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoBadMBsCap);
}
static int dissect_profileAndLevel_SPatML(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SPatML);
}
static int dissect_profileAndLevel_MPatLL(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatLL);
}
static int dissect_profileAndLevel_MPatML(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatML);
}
static int dissect_profileAndLevel_MPatH_14(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatH_14);
}
static int dissect_profileAndLevel_MPatHL(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatHL);
}
static int dissect_profileAndLevel_SNRatLL(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SNRatLL);
}
static int dissect_profileAndLevel_SNRatML(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SNRatML);
}
static int dissect_profileAndLevel_SpatialatH_14(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SpatialatH_14);
}
static int dissect_profileAndLevel_HPatML(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatML);
}
static int dissect_profileAndLevel_HPatH_14(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatH_14);
}
static int dissect_profileAndLevel_HPatHL(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatHL);
}
static int dissect_unrestrictedVector(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_unrestrictedVector);
}
static int dissect_arithmeticCoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_arithmeticCoding);
}
static int dissect_advancedPrediction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_advancedPrediction);
}
static int dissect_pbFrames(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_pbFrames);
}
static int dissect_errorCompensation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_errorCompensation);
}
static int dissect_baseBitRateConstrained(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_baseBitRateConstrained);
}
static int dissect_advancedIntraCodingMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_advancedIntraCodingMode);
}
static int dissect_deblockingFilterMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_deblockingFilterMode);
}
static int dissect_improvedPBFramesMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_improvedPBFramesMode);
}
static int dissect_unlimitedMotionVectors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_unlimitedMotionVectors);
}
static int dissect_fullPictureFreeze(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fullPictureFreeze);
}
static int dissect_partialPictureFreezeAndRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_partialPictureFreezeAndRelease);
}
static int dissect_resizingPartPicFreezeAndRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_resizingPartPicFreezeAndRelease);
}
static int dissect_fullPictureSnapshot(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fullPictureSnapshot);
}
static int dissect_partialPictureSnapshot(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_partialPictureSnapshot);
}
static int dissect_videoSegmentTagging(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoSegmentTagging);
}
static int dissect_progressiveRefinement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_progressiveRefinement);
}
static int dissect_dynamicPictureResizingByFour(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dynamicPictureResizingByFour);
}
static int dissect_dynamicPictureResizingSixteenthPel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dynamicPictureResizingSixteenthPel);
}
static int dissect_dynamicWarpingHalfPel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dynamicWarpingHalfPel);
}
static int dissect_dynamicWarpingSixteenthPel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dynamicWarpingSixteenthPel);
}
static int dissect_independentSegmentDecoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_independentSegmentDecoding);
}
static int dissect_slicesInOrder_NonRect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_slicesInOrder_NonRect);
}
static int dissect_slicesInOrder_Rect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_slicesInOrder_Rect);
}
static int dissect_slicesNoOrder_NonRect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_slicesNoOrder_NonRect);
}
static int dissect_slicesNoOrder_Rect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_slicesNoOrder_Rect);
}
static int dissect_alternateInterVLCMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_alternateInterVLCMode);
}
static int dissect_modifiedQuantizationMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_modifiedQuantizationMode);
}
static int dissect_reducedResolutionUpdate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_reducedResolutionUpdate);
}
static int dissect_separateVideoBackChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_separateVideoBackChannel);
}
static int dissect_videoMux(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoMux);
}
static int dissect_anyPixelAspectRatio(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_anyPixelAspectRatio);
}
static int dissect_referencePicSelect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_referencePicSelect);
}
static int dissect_enhancedReferencePicSelectBool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_enhancedReferencePicSelectBool);
}
static int dissect_dataPartitionedSlices(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_dataPartitionedSlices);
}
static int dissect_fixedPointIDCT0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fixedPointIDCT0);
}
static int dissect_interlacedFields(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_interlacedFields);
}
static int dissect_currentPictureHeaderRepetition(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_currentPictureHeaderRepetition);
}
static int dissect_previousPictureHeaderRepetition(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_previousPictureHeaderRepetition);
}
static int dissect_nextPictureHeaderRepetition(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_nextPictureHeaderRepetition);
}
static int dissect_pictureNumberBoolean(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_pictureNumberBoolean);
}
static int dissect_spareReferencePictures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_spareReferencePictures);
}
static int dissect_constrainedBitstream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_constrainedBitstream);
}
static int dissect_silenceSuppression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_silenceSuppression);
}
static int dissect_annexA(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexA);
}
static int dissect_annexB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexB);
}
static int dissect_annexD(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexD);
}
static int dissect_annexE(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexE);
}
static int dissect_annexF(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexF);
}
static int dissect_annexG(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexG);
}
static int dissect_annexH(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_annexH);
}
static int dissect_audioLayer1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioLayer1);
}
static int dissect_audioLayer2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioLayer2);
}
static int dissect_audioLayer3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioLayer3);
}
static int dissect_audioSampling32k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling32k);
}
static int dissect_audioSampling44k1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling44k1);
}
static int dissect_audioSampling48k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling48k);
}
static int dissect_singleChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_singleChannel);
}
static int dissect_twoChannels(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_twoChannels);
}
static int dissect_audioSampling16k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling16k);
}
static int dissect_audioSampling22k05(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling22k05);
}
static int dissect_audioSampling24k(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioSampling24k);
}
static int dissect_threeChannels2_1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_threeChannels2_1);
}
static int dissect_threeChannels3_0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_threeChannels3_0);
}
static int dissect_fourChannels2_0_2_0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fourChannels2_0_2_0);
}
static int dissect_fourChannels2_2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fourChannels2_2);
}
static int dissect_fourChannels3_1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fourChannels3_1);
}
static int dissect_fiveChannels3_0_2_0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fiveChannels3_0_2_0);
}
static int dissect_fiveChannels3_2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fiveChannels3_2);
}
static int dissect_lowFrequencyEnhancement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_lowFrequencyEnhancement);
}
static int dissect_multilingual(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_multilingual);
}
static int dissect_comfortNoise(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_comfortNoise);
}
static int dissect_scrambled(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_scrambled);
}
static int dissect_qcif_bool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_qcif_bool);
}
static int dissect_cif_bool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_cif_bool);
}
static int dissect_ccir601Seq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_ccir601Seq);
}
static int dissect_ccir601Prog(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_ccir601Prog);
}
static int dissect_hdtvSeq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_hdtvSeq);
}
static int dissect_hdtvProg(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_hdtvProg);
}
static int dissect_g3FacsMH200x100(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_g3FacsMH200x100);
}
static int dissect_g3FacsMH200x200(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_g3FacsMH200x200);
}
static int dissect_g4FacsMMR200x100(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_g4FacsMMR200x100);
}
static int dissect_g4FacsMMR200x200(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_g4FacsMMR200x200);
}
static int dissect_jbig200x200Seq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_jbig200x200Seq);
}
static int dissect_jbig200x200Prog(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_jbig200x200Prog);
}
static int dissect_jbig300x300Seq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_jbig300x300Seq);
}
static int dissect_jbig300x300Prog(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_jbig300x300Prog);
}
static int dissect_digPhotoLow(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_digPhotoLow);
}
static int dissect_digPhotoMedSeq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_digPhotoMedSeq);
}
static int dissect_digPhotoMedProg(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_digPhotoMedProg);
}
static int dissect_digPhotoHighSeq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_digPhotoHighSeq);
}
static int dissect_digPhotoHighProg(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_digPhotoHighProg);
}
static int dissect_fillBitRemoval(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_fillBitRemoval);
}
static int dissect_transcodingJBIG(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_transcodingJBIG);
}
static int dissect_transcodingMMR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_transcodingMMR);
}
static int dissect_t38TCPBidirectionalMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_t38TCPBidirectionalMode);
}
static int dissect_chairControlCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_chairControlCapability);
}
static int dissect_videoIndicateMixingCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_videoIndicateMixingCapability);
}
static int dissect_multipointVisualizationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_multipointVisualizationCapability);
}
static int dissect_controlOnMuxStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_controlOnMuxStream);
}
static int dissect_redundancyEncodingBool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingBool);
}
static int dissect_separatePort(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_separatePort);
}
static int dissect_samePortBool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_samePortBool);
}
static int dissect_associateConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_associateConference);
}
static int dissect_audioHeaderPresent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_audioHeaderPresent);
}
static int dissect_segmentableFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_segmentableFlag);
}
static int dissect_alsduSplitting(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_alsduSplitting);
}
static int dissect_uIH(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_uIH);
}
static int dissect_loopbackTestProcedure(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_loopbackTestProcedure);
}
static int dissect_mediaGuaranteedDelivery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_mediaGuaranteedDelivery);
}
static int dissect_mediaControlGuaranteedDelivery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_mediaControlGuaranteedDelivery);
}
static int dissect_flowControlToZero(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_flowControlToZero);
}
static int dissect_multiplexCapabilityBool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_multiplexCapabilityBool);
}
static int dissect_secureChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_secureChannel);
}
static int dissect_sharedSecret(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_sharedSecret);
}
static int dissect_certProtectedKey(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_certProtectedKey);
}
static int dissect_bitRateLockedToPCRClock(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_bitRateLockedToPCRClock);
}
static int dissect_bitRateLockedToNetworkClock(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BOOLEAN(tvb, offset, pinfo, tree, hf_h245_bitRateLockedToNetworkClock);
}

static const per_sequence_t T_aal1_sequence[] = {
  { "nullClockRecovery"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nullClockRecovery },
  { "srtsClockRecovery"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_srtsClockRecovery_bool },
  { "adaptiveClockRecovery"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_adaptiveClockRecovery },
  { "nullErrorCorrection"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nullErrorCorrection },
  { "longInterleaver"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_longInterleaver },
  { "shortInterleaver"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_shortInterleaver },
  { "errorCorrectionOnly"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_errorCorrectionOnly },
  { "structuredDataTransfer"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_structuredDataTransfer },
  { "partiallyFilledCells"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partiallyFilledCells },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_aal1, T_aal1_sequence);

  return offset;
}
static int dissect_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_aal1(tvb, offset, pinfo, tree, hf_h245_aal1);
}



static int
dissect_h245_INTEGER_0_65535(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 65535U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_forwardMaximumSDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_forwardMaximumSDUSize);
}
static int dissect_backwardMaximumSDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_backwardMaximumSDUSize);
}
static int dissect_maximumAl2SDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maximumAl2SDUSize);
}
static int dissect_maximumAl3SDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maximumAl3SDUSize);
}
static int dissect_maximumAL1MPDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maximumAL1MPDUSize);
}
static int dissect_maximumAL2MSDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maximumAL2MSDUSize);
}
static int dissect_maximumAL3MSDUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maximumAL3MSDUSize);
}
static int dissect_maxNTUSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_maxNTUSize);
}
static int dissect_bppMaxKb(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_bppMaxKb);
}
static int dissect_unsignedMin(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_unsignedMin);
}
static int dissect_unsignedMax(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_unsignedMax);
}
static int dissect_portNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_portNumber);
}
static int dissect_resourceID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_resourceID);
}
static int dissect_ipv6_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_ipv6_tsapIdentifier);
}
static int dissect_iPSrcRoute_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_iPSrcRoute_tsapIdentifier);
}
static int dissect_multicast_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_multicast_tsapIdentifier);
}
static int dissect_multicast_IPv6_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_multicast_IPv6_tsapIdentifier);
}
static int dissect_logicalChannelNum(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_logicalChannelNum);
}
static int dissect_requestedInterval(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_requestedInterval);
}
static int dissect_currentInterval(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_65535(tvb, offset, pinfo, tree, hf_h245_currentInterval);
}

static const per_sequence_t T_aal5_sequence[] = {
  { "forwardMaximumSDUSize"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardMaximumSDUSize },
  { "backwardMaximumSDUSize"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_backwardMaximumSDUSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_aal5, T_aal5_sequence);

  return offset;
}
static int dissect_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_aal5(tvb, offset, pinfo, tree, hf_h245_aal5);
}



static int
dissect_h245_INTEGER_1_65535(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 65535U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_singleBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_singleBitRate);
}
static int dissect_lowerBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_lowerBitRate);
}
static int dissect_higherBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_higherBitRate);
}
static int dissect_finite_1_65535(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_finite_1_65535);
}
static int dissect_maxNumberOfAdditionalConnections(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_maxNumberOfAdditionalConnections);
}
static int dissect_infoNotAvailable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_infoNotAvailable);
}
static int dissect_maxH223MUXPDUsize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_maxH223MUXPDUsize);
}
static int dissect_bitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_bitRate);
}
static int dissect_duration(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65535(tvb, offset, pinfo, tree, hf_h245_duration);
}

static const per_sequence_t T_rangeOfBitRates_sequence[] = {
  { "lowerBitRate"                , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lowerBitRate },
  { "higherBitRate"               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_higherBitRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_rangeOfBitRates(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_rangeOfBitRates, T_rangeOfBitRates_sequence);

  return offset;
}
static int dissect_rangeOfBitRates(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_rangeOfBitRates(tvb, offset, pinfo, tree, hf_h245_rangeOfBitRates);
}


static const value_string h245_Avb_type_vals[] = {
  {   0, "singleBitRate" },
  {   1, "rangeOfBitRates" },
  { 0, NULL }
};

static const per_choice_t Avb_type_choice[] = {
  {   0, "singleBitRate"               , ASN1_NO_EXTENSIONS     , dissect_singleBitRate },
  {   1, "rangeOfBitRates"             , ASN1_NO_EXTENSIONS     , dissect_rangeOfBitRates },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Avb_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Avb_type, Avb_type_choice, "Avb_type",
                              NULL);

  return offset;
}
static int dissect_Avb_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Avb_type(tvb, offset, pinfo, tree, hf_h245_Avb_type);
}

static const per_sequence_t T_availableBitRates_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_Avb_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_availableBitRates(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_availableBitRates, T_availableBitRates_sequence);

  return offset;
}
static int dissect_availableBitRates(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_availableBitRates(tvb, offset, pinfo, tree, hf_h245_availableBitRates);
}


static int
dissect_h245_NumericString_SIZE_1_16(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_NumericString(tvb, offset, pinfo, tree, hf_index,
                                     1, 16);

  return offset;
}
static int dissect_internationalNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NumericString_SIZE_1_16(tvb, offset, pinfo, tree, hf_h245_internationalNumber);
}


static int
dissect_h245_OCTET_STRING_SIZE_1_20(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 20,
                                    NULL, NULL);

  return offset;
}
static int dissect_nsapAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_20(tvb, offset, pinfo, tree, hf_h245_nsapAddress);
}
static int dissect_subaddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_20(tvb, offset, pinfo, tree, hf_h245_subaddress);
}
static int dissect_nsap(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_20(tvb, offset, pinfo, tree, hf_h245_nsap);
}


static const value_string h245_T_address_vals[] = {
  {   0, "internationalNumber" },
  {   1, "nsapAddress" },
  { 0, NULL }
};

static const per_choice_t T_address_choice[] = {
  {   0, "internationalNumber"         , ASN1_EXTENSION_ROOT    , dissect_internationalNumber },
  {   1, "nsapAddress"                 , ASN1_EXTENSION_ROOT    , dissect_nsapAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_address, T_address_choice, "T_address",
                              NULL);

  return offset;
}
static int dissect_address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_address(tvb, offset, pinfo, tree, hf_h245_address);
}

static const per_sequence_t Q2931Address_sequence[] = {
  { "address"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_address },
  { "subaddress"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_subaddress },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Q2931Address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Q2931Address, Q2931Address_sequence);

  return offset;
}
static int dissect_gatewayAddress_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Q2931Address(tvb, offset, pinfo, tree, hf_h245_gatewayAddress_item);
}
static int dissect_q2931Address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Q2931Address(tvb, offset, pinfo, tree, hf_h245_q2931Address);
}


static int
dissect_h245_SET_SIZE_1_256_OF_Q2931Address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_Q2931Address, dissect_gatewayAddress_item,
                                          1, 256);

  return offset;
}
static int dissect_gatewayAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_Q2931Address(tvb, offset, pinfo, tree, hf_h245_gatewayAddress);
}

static const per_sequence_t T_aal1ViaGateway_sequence[] = {
  { "gatewayAddress"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_gatewayAddress },
  { "nullClockRecovery"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nullClockRecovery },
  { "srtsClockRecovery"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_srtsClockRecoveryflag },
  { "adaptiveClockRecovery"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_adaptiveClockRecovery },
  { "nullErrorCorrection"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nullErrorCorrection },
  { "longInterleaver"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_longInterleaver },
  { "shortInterleaver"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_shortInterleaver },
  { "errorCorrectionOnly"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_errorCorrectionOnly },
  { "structuredDataTransfer"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_structuredDataTransfer },
  { "partiallyFilledCells"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partiallyFilledCells },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_aal1ViaGateway(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_aal1ViaGateway, T_aal1ViaGateway_sequence);

  return offset;
}
static int dissect_aal1ViaGateway(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_aal1ViaGateway(tvb, offset, pinfo, tree, hf_h245_aal1ViaGateway);
}

static const per_sequence_t VCCapability_sequence[] = {
  { "aal1"                        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_aal1 },
  { "aal5"                        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_aal5 },
  { "transportStream"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transportStream_bool },
  { "programStream"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_programStream },
  { "availableBitRates"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_availableBitRates },
  { "aal1ViaGateway"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_aal1ViaGateway },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_VCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_VCCapability, VCCapability_sequence);

  return offset;
}
static int dissect_vcCapability_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VCCapability(tvb, offset, pinfo, tree, hf_h245_vcCapability_item);
}


static int
dissect_h245_SET_OF_VCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_set_of(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_SET_OF_VCCapability, dissect_vcCapability_item);

  return offset;
}
static int dissect_vcCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_OF_VCCapability(tvb, offset, pinfo, tree, hf_h245_vcCapability);
}

static const per_sequence_t H222Capability_sequence[] = {
  { "numberOfVCs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfVCs },
  { "vcCapability"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_vcCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H222Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H222Capability, H222Capability_sequence);

  return offset;
}
static int dissect_h222Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H222Capability(tvb, offset, pinfo, tree, hf_h245_h222Capability);
}



static int
dissect_h245_INTEGER_0_1023(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 1023U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumDelayJitter(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_1023(tvb, offset, pinfo, tree, hf_h245_maximumDelayJitter);
}
static int dissect_maximumAudioDelayJitter(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_1023(tvb, offset, pinfo, tree, hf_h245_maximumAudioDelayJitter);
}
static int dissect_temporalReference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_1023(tvb, offset, pinfo, tree, hf_h245_temporalReference);
}
static int dissect_pictureNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_1023(tvb, offset, pinfo, tree, hf_h245_pictureNumber);
}


static int
dissect_h245_NULL(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  { proto_item *ti_tmp;
  ti_tmp = proto_tree_add_item(tree, hf_index, tvb, offset>>8, 0, FALSE);
  proto_item_append_text(ti_tmp, ": NULL");
  }

  return offset;
}
static int dissect_master(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_master);
}
static int dissect_slave(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_slave);
}
static int dissect_identicalNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_identicalNumbers);
}
static int dissect_unspecified(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unspecified);
}
static int dissect_undefinedTableEntryUsed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_undefinedTableEntryUsed);
}
static int dissect_descriptorCapacityExceeded(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_descriptorCapacityExceeded);
}
static int dissect_noneProcessed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noneProcessed);
}
static int dissect_basic(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_basic);
}
static int dissect_guaranteedQOS(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_guaranteedQOS);
}
static int dissect_controlledLoad(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_controlledLoad);
}
static int dissect_ip_UDP(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_ip_UDP);
}
static int dissect_ip_TCP(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_ip_TCP);
}
static int dissect_atm_AAL5_UNIDIR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_atm_AAL5_UNIDIR);
}
static int dissect_atm_AAL5_BIDIR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_atm_AAL5_BIDIR);
}
static int dissect_rtpAudioRedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_rtpAudioRedundancyEncoding);
}
static int dissect_roundrobin(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_roundrobin);
}
static int dissect_none(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_none);
}
static int dissect_ackMessageOnly(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_ackMessageOnly);
}
static int dissect_nackMessageOnly(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_nackMessageOnly);
}
static int dissect_ackOrNackMessageOnly(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_ackOrNackMessageOnly);
}
static int dissect_ackAndNackMessage(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_ackAndNackMessage);
}
static int dissect_dsvdControl(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dsvdControl);
}
static int dissect_v14buffered(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v14buffered);
}
static int dissect_v42lapm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v42lapm);
}
static int dissect_hdlcFrameTunnelling(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_hdlcFrameTunnelling);
}
static int dissect_h310SeparateVCStack(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_h310SeparateVCStack);
}
static int dissect_h310SingleVCStack(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_h310SingleVCStack);
}
static int dissect_transparent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_transparent);
}
static int dissect_segmentationAndReassembly(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_segmentationAndReassembly);
}
static int dissect_hdlcFrameTunnelingwSAR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_hdlcFrameTunnelingwSAR);
}
static int dissect_v120(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v120);
}
static int dissect_separateLANStack(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_separateLANStack);
}
static int dissect_tcp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_tcp);
}
static int dissect_udp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_udp);
}
static int dissect_t84Unrestricted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_t84Unrestricted);
}
static int dissect_localTCF(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_localTCF);
}
static int dissect_transferredTCF(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_transferredTCF);
}
static int dissect_t38UDPFEC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_t38UDPFEC);
}
static int dissect_t38UDPRedundancy(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_t38UDPRedundancy);
}
static int dissect_basicString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_basicString);
}
static int dissect_iA5String(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_iA5String);
}
static int dissect_generalString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_generalString);
}
static int dissect_dtmf(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dtmf);
}
static int dissect_hookflash(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_hookflash);
}
static int dissect_extendedAlphanumericFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_extendedAlphanumericFlag);
}
static int dissect_encryptedBasicString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_encryptedBasicString);
}
static int dissect_encryptedIA5String(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_encryptedIA5String);
}
static int dissect_encryptedGeneralString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_encryptedGeneralString);
}
static int dissect_secureDTMF(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_secureDTMF);
}
static int dissect_logical(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_logical);
}
static int dissect_unicast(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unicast);
}
static int dissect_multicast(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multicast);
}
static int dissect_originateCall(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_originateCall);
}
static int dissect_waitForCall(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_waitForCall);
}
static int dissect_issueQuery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_issueQuery);
}
static int dissect_nullData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_nullData);
}
static int dissect_al1Framed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_al1Framed);
}
static int dissect_al1NotFramed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_al1NotFramed);
}
static int dissect_al2WithoutSequenceNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_al2WithoutSequenceNumbers);
}
static int dissect_al2WithSequenceNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_al2WithSequenceNumbers);
}
static int dissect_framed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_framed);
}
static int dissect_unframed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unframed);
}
static int dissect_sebch16_7(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_sebch16_7);
}
static int dissect_golay24_12(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_golay24_12);
}
static int dissect_crc4bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc4bit);
}
static int dissect_crc12bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc12bit);
}
static int dissect_crc20bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc20bit);
}
static int dissect_crc28bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc28bit);
}
static int dissect_crc8bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc8bit);
}
static int dissect_crc16bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc16bit);
}
static int dissect_crc32bit(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crc32bit);
}
static int dissect_crcNotUsed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_crcNotUsed);
}
static int dissect_noArq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noArq);
}
static int dissect_sebch16_5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_sebch16_5);
}
static int dissect_infinite(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_infinite);
}
static int dissect_noSuspendResume(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noSuspendResume);
}
static int dissect_suspendResumewAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_suspendResumewAddress);
}
static int dissect_suspendResumewoAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_suspendResumewoAddress);
}
static int dissect_rej(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_rej);
}
static int dissect_sREJ(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_sREJ);
}
static int dissect_mSREJ(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_mSREJ);
}
static int dissect_uNERM(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_uNERM);
}
static int dissect_h261aVideoPacketizationFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_h261aVideoPacketizationFlag);
}
static int dissect_redundancyEncodingFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingFlag);
}
static int dissect_strict(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_strict);
}
static int dissect_loose(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_loose);
}
static int dissect_unsuitableReverseParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unsuitableReverseParameters);
}
static int dissect_dataTypeNotSupported(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dataTypeNotSupported);
}
static int dissect_dataTypeNotAvailable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dataTypeNotAvailable);
}
static int dissect_unknownDataType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unknownDataType);
}
static int dissect_dataTypeALCombinationNotSupported(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dataTypeALCombinationNotSupported);
}
static int dissect_multicastChannelNotAllowed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multicastChannelNotAllowed);
}
static int dissect_insufficientBandwidth(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_insufficientBandwidth);
}
static int dissect_separateStackEstablishmentFailed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_separateStackEstablishmentFailed);
}
static int dissect_invalidSessionID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_invalidSessionID);
}
static int dissect_masterSlaveConflict(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_masterSlaveConflict);
}
static int dissect_waitForCommunicationMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_waitForCommunicationMode);
}
static int dissect_invalidDependentChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_invalidDependentChannel);
}
static int dissect_replacementForRejected(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_replacementForRejected);
}
static int dissect_user(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_user);
}
static int dissect_lcse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_lcse);
}
static int dissect_unknown(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unknown);
}
static int dissect_reopen(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_reopen);
}
static int dissect_reservationFailure(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_reservationFailure);
}
static int dissect_normal(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_normal);
}
static int dissect_untilClosingFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_untilClosingFlag);
}
static int dissect_unspecifiedCause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unspecifiedCause);
}
static int dissect_descriptorTooComplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_descriptorTooComplex);
}
static int dissect_willTransmitMostPreferredMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_willTransmitMostPreferredMode);
}
static int dissect_willTransmitLessPreferredMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_willTransmitLessPreferredMode);
}
static int dissect_modeUnavailable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_modeUnavailable);
}
static int dissect_multipointConstraint(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multipointConstraint);
}
static int dissect_requestDenied(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_requestDenied);
}
static int dissect_qcif(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_qcif);
}
static int dissect_cif(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cif);
}
static int dissect_profileAndLevel_SPatMLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SPatMLMode);
}
static int dissect_profileAndLevel_MPatLLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatLLMode);
}
static int dissect_profileAndLevel_MPatMLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatMLMode);
}
static int dissect_profileAndLevel_MPatH_14Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatH_14Mode);
}
static int dissect_profileAndLevel_MPatHLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_MPatHLMode);
}
static int dissect_profileAndLevel_SNRatLLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SNRatLLMode);
}
static int dissect_profileAndLevel_SNRatMLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SNRatMLMode);
}
static int dissect_profileAndLevel_SpatialatH_14Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_SpatialatH_14Mode);
}
static int dissect_profileAndLevel_HPatMLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatMLMode);
}
static int dissect_profileAndLevel_HPatH_14Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatH_14Mode);
}
static int dissect_profileAndLevel_HPatHLMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_profileAndLevel_HPatHLMode);
}
static int dissect_sqcif(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_sqcif);
}
static int dissect_cif4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cif4);
}
static int dissect_cif16(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cif16);
}
static int dissect_custom_res(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_custom_res);
}
static int dissect_g711Alaw64k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g711Alaw64k_mode);
}
static int dissect_g711Alaw56k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g711Alaw56k_mode);
}
static int dissect_g711Ulaw64k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g711Ulaw64k_mode);
}
static int dissect_g711Ulaw56k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g711Ulaw56k_mode);
}
static int dissect_g722_64k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g722_64k_mode);
}
static int dissect_g722_56k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g722_56k_mode);
}
static int dissect_g722_48k_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g722_48k_mode);
}
static int dissect_g728_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g728_mode);
}
static int dissect_g729_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g729_mode);
}
static int dissect_g729AnnexA_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_g729AnnexA_mode);
}
static int dissect_noSilenceSuppressionLowRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noSilenceSuppressionLowRate);
}
static int dissect_noSilenceSuppressionHighRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noSilenceSuppressionHighRate);
}
static int dissect_silenceSuppressionLowRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_silenceSuppressionLowRate);
}
static int dissect_silenceSuppressionHighRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_silenceSuppressionHighRate);
}
static int dissect_audioLayer1Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioLayer1Mode);
}
static int dissect_audioLayer2Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioLayer2Mode);
}
static int dissect_audioLayer3Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioLayer3Mode);
}
static int dissect_audioSampling32kMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling32kMode);
}
static int dissect_audioSampling44k1Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling44k1Mode);
}
static int dissect_audioSampling48kMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling48kMode);
}
static int dissect_singleChannelMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_singleChannelMode);
}
static int dissect_twoChannelStereo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_twoChannelStereo);
}
static int dissect_twoChannelDual(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_twoChannelDual);
}
static int dissect_audioSampling16kMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling16kMode);
}
static int dissect_audioSampling22k05Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling22k05Mode);
}
static int dissect_audioSampling24kMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_audioSampling24kMode);
}
static int dissect_threeChannels2_1Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_threeChannels2_1Mode);
}
static int dissect_threeChannels3_0Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_threeChannels3_0Mode);
}
static int dissect_fourChannels2_0_2_0Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_fourChannels2_0_2_0Mode);
}
static int dissect_fourChannels2_2Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_fourChannels2_2Mode);
}
static int dissect_fourChannels3_1Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_fourChannels3_1Mode);
}
static int dissect_fiveChannels3_0_2_0Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_fiveChannels3_0_2_0Mode);
}
static int dissect_fiveChannels3_2Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_fiveChannels3_2Mode);
}
static int dissect_h233Encryption(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_h233Encryption);
}
static int dissect_systemLoop(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_systemLoop);
}
static int dissect_canNotPerformLoop(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_canNotPerformLoop);
}
static int dissect_terminalListRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_terminalListRequest);
}
static int dissect_makeMeChair(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_makeMeChair);
}
static int dissect_cancelMakeMeChair(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMakeMeChair);
}
static int dissect_enterH243Password(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_enterH243Password);
}
static int dissect_enterH243TerminalID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_enterH243TerminalID);
}
static int dissect_enterH243ConferenceID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_enterH243ConferenceID);
}
static int dissect_enterExtensionAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_enterExtensionAddress);
}
static int dissect_requestChairTokenOwner(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_requestChairTokenOwner);
}
static int dissect_requestAllTerminalIDs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_requestAllTerminalIDs);
}
static int dissect_videoCommandReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoCommandReject);
}
static int dissect_terminalDropReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_terminalDropReject);
}
static int dissect_grantedChairToken(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_grantedChairToken);
}
static int dissect_deniedChairToken(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_deniedChairToken);
}
static int dissect_grantedBroadcastMyLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_grantedBroadcastMyLogicalChannel);
}
static int dissect_deniedBroadcastMyLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_deniedBroadcastMyLogicalChannel);
}
static int dissect_grantedMakeTerminalBroadcaster(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_grantedMakeTerminalBroadcaster);
}
static int dissect_deniedMakeTerminalBroadcaster(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_deniedMakeTerminalBroadcaster);
}
static int dissect_grantedSendThisSource(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_grantedSendThisSource);
}
static int dissect_deniedSendThisSource(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_deniedSendThisSource);
}
static int dissect_masterActivate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_masterActivate);
}
static int dissect_slaveActivate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_slaveActivate);
}
static int dissect_deActivate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_deActivate);
}
static int dissect_accept(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_accept);
}
static int dissect_functionNotSupportedFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_functionNotSupportedFlag);
}
static int dissect_currentIntervalInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_currentIntervalInformation);
}
static int dissect_accepted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_accepted);
}
static int dissect_connectionsNotAvailable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_connectionsNotAvailable);
}
static int dissect_userRejected(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_userRejected);
}
static int dissect_n_isdn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_n_isdn);
}
static int dissect_gstn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_gstn);
}
static int dissect_mobile(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_mobile);
}
static int dissect_undefinedReason(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_undefinedReason);
}
static int dissect_insufficientResources(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_insufficientResources);
}
static int dissect_genericRequestFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_genericRequestFlag);
}
static int dissect_encryptionIVRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_encryptionIVRequest);
}
static int dissect_wholeMultiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_wholeMultiplex);
}
static int dissect_noRestriction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noRestriction);
}
static int dissect_disconnect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_disconnect);
}
static int dissect_telephonyMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_telephonyMode);
}
static int dissect_v8bis(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v8bis);
}
static int dissect_v34DSVD(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v34DSVD);
}
static int dissect_v34DuplexFAX(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v34DuplexFAX);
}
static int dissect_v34H324(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v34H324);
}
static int dissect_v140(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_v140);
}
static int dissect_terminalOnHold(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_terminalOnHold);
}
static int dissect_cancelMakeTerminalBroadcaster(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMakeTerminalBroadcaster);
}
static int dissect_cancelSendThisSource(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelSendThisSource);
}
static int dissect_dropConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_dropConference);
}
static int dissect_masterToSlave(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_masterToSlave);
}
static int dissect_slaveToMaster(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_slaveToMaster);
}
static int dissect_equaliseDelay(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_equaliseDelay);
}
static int dissect_zeroDelay(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_zeroDelay);
}
static int dissect_multipointModeCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multipointModeCommand);
}
static int dissect_cancelMultipointModeCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMultipointModeCommand);
}
static int dissect_videoFreezePicture(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoFreezePicture);
}
static int dissect_videoFastUpdatePicture(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoFastUpdatePicture);
}
static int dissect_videoSendSyncEveryGOB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoSendSyncEveryGOB);
}
static int dissect_videoSendSyncEveryGOBCancel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoSendSyncEveryGOBCancel);
}
static int dissect_switchReceiveMediaOff(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_switchReceiveMediaOff);
}
static int dissect_switchReceiveMediaOn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_switchReceiveMediaOn);
}
static int dissect_progressiveRefinementAbortOne(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_progressiveRefinementAbortOne);
}
static int dissect_progressiveRefinementAbortContinuous(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_progressiveRefinementAbortContinuous);
}
static int dissect_doOneProgression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_doOneProgression);
}
static int dissect_doContinuousProgressions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_doContinuousProgressions);
}
static int dissect_doOneIndependentProgression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_doOneIndependentProgression);
}
static int dissect_doContinuousIndependentProgressions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_doContinuousIndependentProgressions);
}
static int dissect_toLevel0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_toLevel0);
}
static int dissect_toLevel1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_toLevel1);
}
static int dissect_toLevel2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_toLevel2);
}
static int dissect_toLevel2withOptionalHeader(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_toLevel2withOptionalHeader);
}
static int dissect_start(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_start);
}
static int dissect_stop(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_stop);
}
static int dissect_nullClockRecoveryflag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_nullClockRecoveryflag);
}
static int dissect_srtsClockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_srtsClockRecovery);
}
static int dissect_adaptiveClockRecoveryFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_adaptiveClockRecoveryFlag);
}
static int dissect_nullErrorCorrectionFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_nullErrorCorrectionFlag);
}
static int dissect_longInterleaverFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_longInterleaverFlag);
}
static int dissect_shortInterleaverFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_shortInterleaverFlag);
}
static int dissect_errorCorrectionOnlyFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_errorCorrectionOnlyFlag);
}
static int dissect_noMultiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_noMultiplex);
}
static int dissect_transportStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_transportStream);
}
static int dissect_programStreamFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_programStreamFlag);
}
static int dissect_synchronized(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_synchronized);
}
static int dissect_reconfiguration(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_reconfiguration);
}
static int dissect_syntaxError(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_syntaxError);
}
static int dissect_semanticError(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_semanticError);
}
static int dissect_unknownFunction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_unknownFunction);
}
static int dissect_seenByAtLeastOneOther(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_seenByAtLeastOneOther);
}
static int dissect_cancelSeenByAtLeastOneOther(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelSeenByAtLeastOneOther);
}
static int dissect_seenByAll(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_seenByAll);
}
static int dissect_cancelSeenByAll(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelSeenByAll);
}
static int dissect_requestForFloor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_requestForFloor);
}
static int dissect_withdrawChairToken(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_withdrawChairToken);
}
static int dissect_logicalChannelActive(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_logicalChannelActive);
}
static int dissect_logicalChannelInactive(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_logicalChannelInactive);
}
static int dissect_multipointConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multipointConference);
}
static int dissect_cancelMultipointConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMultipointConference);
}
static int dissect_multipointZeroComm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multipointZeroComm);
}
static int dissect_cancelMultipointZeroComm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMultipointZeroComm);
}
static int dissect_multipointSecondaryStatus(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_multipointSecondaryStatus);
}
static int dissect_cancelMultipointSecondaryStatus(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_cancelMultipointSecondaryStatus);
}
static int dissect_videoIndicateReadyToActivate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_videoIndicateReadyToActivate);
}
static int dissect_rtpPayloadIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NULL(tvb, offset, pinfo, tree, hf_h245_rtpPayloadIndication);
}



static int
dissect_h245_INTEGER_1_15(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 15U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumNestingDepth(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_15(tvb, offset, pinfo, tree, hf_h245_maximumNestingDepth);
}



static int
dissect_h245_INTEGER_2_255(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           2U, 255U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumElementListSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_2_255(tvb, offset, pinfo, tree, hf_h245_maximumElementListSize);
}
static int dissect_maximumSubElementListSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_2_255(tvb, offset, pinfo, tree, hf_h245_maximumSubElementListSize);
}

static const per_sequence_t T_enhanced_sequence[] = {
  { "maximumNestingDepth"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumNestingDepth },
  { "maximumElementListSize"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumElementListSize },
  { "maximumSubElementListSize"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumSubElementListSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_enhanced(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_enhanced, T_enhanced_sequence);

  return offset;
}
static int dissect_enhanced(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_enhanced(tvb, offset, pinfo, tree, hf_h245_enhanced);
}


static const value_string h245_T_h223MultiplexTableCapability_vals[] = {
  {   0, "basic" },
  {   1, "enhanced" },
  { 0, NULL }
};

static const per_choice_t T_h223MultiplexTableCapability_choice[] = {
  {   0, "basic"                       , ASN1_NO_EXTENSIONS     , dissect_basic },
  {   1, "enhanced"                    , ASN1_NO_EXTENSIONS     , dissect_enhanced },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_h223MultiplexTableCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_h223MultiplexTableCapability, T_h223MultiplexTableCapability_choice, "T_h223MultiplexTableCapability",
                              NULL);

  return offset;
}
static int dissect_h223MultiplexTableCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_h223MultiplexTableCapability(tvb, offset, pinfo, tree, hf_h245_h223MultiplexTableCapability);
}

static const per_sequence_t T_mobileOperationTransmitCapability_sequence[] = {
  { "modeChangeCapability"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_modeChangeCapability },
  { "h223AnnexA"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h223AnnexA },
  { "h223AnnexADoubleFlag"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h223AnnexADoubleFlagFlag },
  { "h223AnnexB"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h223AnnexB },
  { "h223AnnexBwithHeader"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h223AnnexBwithHeader },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_mobileOperationTransmitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_mobileOperationTransmitCapability, T_mobileOperationTransmitCapability_sequence);

  return offset;
}
static int dissect_mobileOperationTransmitCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mobileOperationTransmitCapability(tvb, offset, pinfo, tree, hf_h245_mobileOperationTransmitCapability);
}

static const per_sequence_t H223AnnexCCapability_sequence[] = {
  { "videoWithAL1M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL1M },
  { "videoWithAL2M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL2M },
  { "videoWithAL3M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL3M },
  { "audioWithAL1M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL1M },
  { "audioWithAL2M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL2M },
  { "audioWithAL3M"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL3M },
  { "dataWithAL1M"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL1M },
  { "dataWithAL2M"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL2M },
  { "dataWithAL3M"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL3M },
  { "alpduInterleaving"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alpduInterleaving },
  { "maximumAL1MPDUSize"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAL1MPDUSize },
  { "maximumAL2MSDUSize"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAL2MSDUSize },
  { "maximumAL3MSDUSize"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAL3MSDUSize },
  { "rsCodeCapability"            , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rsCodeCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223AnnexCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223AnnexCCapability, H223AnnexCCapability_sequence);

  return offset;
}
static int dissect_h223AnnexCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AnnexCCapability(tvb, offset, pinfo, tree, hf_h245_h223AnnexCCapability);
}



static int
dissect_h245_INTEGER_1_19200(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 19200U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_bitRate_1_19200(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_19200(tvb, offset, pinfo, tree, hf_h245_bitRate_1_19200);
}
static int dissect_maxBitRate_1_19200(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_19200(tvb, offset, pinfo, tree, hf_h245_maxBitRate_1_19200);
}



static int
dissect_h245_INTEGER_1_255(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 255U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumSampleSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_maximumSampleSize);
}
static int dissect_scale_x(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_scale_x);
}
static int dissect_scale_y(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_scale_y);
}
static int dissect_width(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_width);
}
static int dissect_height(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_height);
}
static int dissect_associatedSessionID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_associatedSessionID);
}
static int dissect_protectedSessionID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_protectedSessionID);
}
static int dissect_sessionID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_sessionID);
}
static int dissect_sessionDependency(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_sessionDependency);
}
static int dissect_sampleSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_sampleSize);
}
static int dissect_samplesPerFrame(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_255(tvb, offset, pinfo, tree, hf_h245_samplesPerFrame);
}



static int
dissect_h245_INTEGER_1_65025(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 65025U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumPayloadLength(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65025(tvb, offset, pinfo, tree, hf_h245_maximumPayloadLength);
}

static const per_sequence_t T_mobileMultilinkFrameCapability_sequence[] = {
  { "maximumSampleSize"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumSampleSize },
  { "maximumPayloadLength"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumPayloadLength },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_mobileMultilinkFrameCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_mobileMultilinkFrameCapability, T_mobileMultilinkFrameCapability_sequence);

  return offset;
}
static int dissect_mobileMultilinkFrameCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mobileMultilinkFrameCapability(tvb, offset, pinfo, tree, hf_h245_mobileMultilinkFrameCapability);
}

static const per_sequence_t H223Capability_sequence[] = {
  { "transportWithI-frames"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transportWithI_frames },
  { "videoWithAL1"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL1 },
  { "videoWithAL2"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL2 },
  { "videoWithAL3"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoWithAL3 },
  { "audioWithAL1"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL1 },
  { "audioWithAL2"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL2 },
  { "audioWithAL3"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioWithAL3 },
  { "dataWithAL1"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL1 },
  { "dataWithAL2"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL2 },
  { "dataWithAL3"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataWithAL3 },
  { "maximumAl2SDUSize"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAl2SDUSize },
  { "maximumAl3SDUSize"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAl3SDUSize },
  { "maximumDelayJitter"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumDelayJitter },
  { "h223MultiplexTableCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h223MultiplexTableCapability },
  { "maxMUXPDUSizeCapability"     , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_maxMUXPDUSizeCapability },
  { "nsrpSupport"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_nsrpSupport },
  { "mobileOperationTransmitCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_mobileOperationTransmitCapability },
  { "h223AnnexCCapability"        , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_h223AnnexCCapability },
  { "bitRate"                     , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_bitRate_1_19200 },
  { "mobileMultilinkFrameCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_mobileMultilinkFrameCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223Capability, H223Capability_sequence);

  return offset;
}
static int dissect_h223Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223Capability(tvb, offset, pinfo, tree, hf_h245_h223Capability);
}



static int
dissect_h245_INTEGER_2_8191(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           2U, 8191U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_numOfDLCS(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_2_8191(tvb, offset, pinfo, tree, hf_h245_numOfDLCS);
}



static int
dissect_h245_INTEGER_1_4095(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 4095U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_n401Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4095(tvb, offset, pinfo, tree, hf_h245_n401Capability);
}
static int dissect_n401(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4095(tvb, offset, pinfo, tree, hf_h245_n401);
}



static int
dissect_h245_INTEGER_1_127(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 127U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maxWindowSizeCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_127(tvb, offset, pinfo, tree, hf_h245_maxWindowSizeCapability);
}
static int dissect_clockDivisor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_127(tvb, offset, pinfo, tree, hf_h245_clockDivisor);
}
static int dissect_windowSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_127(tvb, offset, pinfo, tree, hf_h245_windowSize);
}

static const per_sequence_t V75Capability_sequence[] = {
  { "audioHeader"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioHeader },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V75Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V75Capability, V75Capability_sequence);

  return offset;
}
static int dissect_v75Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V75Capability(tvb, offset, pinfo, tree, hf_h245_v75Capability);
}

static const per_sequence_t V76Capability_sequence[] = {
  { "suspendResumeCapabilitywAddress", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_suspendResumeCapabilitywAddress },
  { "suspendResumeCapabilitywoAddress", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_suspendResumeCapabilitywoAddress },
  { "rejCapability"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rejCapability },
  { "sREJCapability"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sREJCapability },
  { "mREJCapability"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mREJCapability },
  { "crc8bitCapability"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crc8bitCapability },
  { "crc16bitCapability"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crc16bitCapability },
  { "crc32bitCapability"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crc32bitCapability },
  { "uihCapability"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_uihCapability },
  { "numOfDLCS"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numOfDLCS },
  { "twoOctetAddressFieldCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_twoOctetAddressFieldCapability },
  { "loopBackTestCapability"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_loopBackTestCapability },
  { "n401Capability"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_n401Capability },
  { "maxWindowSizeCapability"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxWindowSizeCapability },
  { "v75Capability"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_v75Capability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V76Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V76Capability, V76Capability_sequence);

  return offset;
}
static int dissect_v76Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V76Capability(tvb, offset, pinfo, tree, hf_h245_v76Capability);
}



static int
dissect_h245_INTEGER_1_65536(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 65536U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_mpuTotalNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65536(tvb, offset, pinfo, tree, hf_h245_mpuTotalNumber);
}
static int dissect_numberOfCodewords(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_65536(tvb, offset, pinfo, tree, hf_h245_numberOfCodewords);
}

static const per_sequence_t V42bis_sequence[] = {
  { "numberOfCodewords"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfCodewords },
  { "maximumStringLength"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumStringLength },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V42bis(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V42bis, V42bis_sequence);

  return offset;
}
static int dissect_v42bis(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V42bis(tvb, offset, pinfo, tree, hf_h245_v42bis);
}


static const value_string h245_CompressionType_vals[] = {
  {   0, "v42bis" },
  { 0, NULL }
};

static const per_choice_t CompressionType_choice[] = {
  {   0, "v42bis"                      , ASN1_EXTENSION_ROOT    , dissect_v42bis },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CompressionType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CompressionType, CompressionType_choice, "CompressionType",
                              NULL);

  return offset;
}
static int dissect_transmitCompression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CompressionType(tvb, offset, pinfo, tree, hf_h245_transmitCompression);
}
static int dissect_receiveCompression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CompressionType(tvb, offset, pinfo, tree, hf_h245_receiveCompression);
}
static int dissect_transmitAndReceiveCompression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CompressionType(tvb, offset, pinfo, tree, hf_h245_transmitAndReceiveCompression);
}


static const value_string h245_T_v76wCompression_vals[] = {
  {   0, "transmitCompression" },
  {   1, "receiveCompression" },
  {   2, "transmitAndReceiveCompression" },
  { 0, NULL }
};

static const per_choice_t T_v76wCompression_choice[] = {
  {   0, "transmitCompression"         , ASN1_EXTENSION_ROOT    , dissect_transmitCompression },
  {   1, "receiveCompression"          , ASN1_EXTENSION_ROOT    , dissect_receiveCompression },
  {   2, "transmitAndReceiveCompression", ASN1_EXTENSION_ROOT    , dissect_transmitAndReceiveCompression },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_v76wCompression(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_v76wCompression, T_v76wCompression_choice, "T_v76wCompression",
                              NULL);

  return offset;
}
static int dissect_v76wCompression(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_v76wCompression(tvb, offset, pinfo, tree, hf_h245_v76wCompression);
}


const value_string DataProtocolCapability_vals[] = {
  {   0, "nonStandard" },
  {   1, "v14buffered" },
  {   2, "v42lapm" },
  {   3, "hdlcFrameTunnelling" },
  {   4, "h310SeparateVCStack" },
  {   5, "h310SingleVCStack" },
  {   6, "transparent" },
  {   7, "segmentationAndReassembly" },
  {   8, "hdlcFrameTunnelingwSAR" },
  {   9, "v120" },
  {  10, "separateLANStack" },
  {  11, "v76wCompression" },
  {  12, "tcp" },
  {  13, "udp" },
  { 0, NULL }
};

static const per_choice_t DataProtocolCapability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "v14buffered"                 , ASN1_EXTENSION_ROOT    , dissect_v14buffered },
  {   2, "v42lapm"                     , ASN1_EXTENSION_ROOT    , dissect_v42lapm },
  {   3, "hdlcFrameTunnelling"         , ASN1_EXTENSION_ROOT    , dissect_hdlcFrameTunnelling },
  {   4, "h310SeparateVCStack"         , ASN1_EXTENSION_ROOT    , dissect_h310SeparateVCStack },
  {   5, "h310SingleVCStack"           , ASN1_EXTENSION_ROOT    , dissect_h310SingleVCStack },
  {   6, "transparent"                 , ASN1_EXTENSION_ROOT    , dissect_transparent },
  {   7, "segmentationAndReassembly"   , ASN1_NOT_EXTENSION_ROOT, dissect_segmentationAndReassembly },
  {   8, "hdlcFrameTunnelingwSAR"      , ASN1_NOT_EXTENSION_ROOT, dissect_hdlcFrameTunnelingwSAR },
  {   9, "v120"                        , ASN1_NOT_EXTENSION_ROOT, dissect_v120 },
  {  10, "separateLANStack"            , ASN1_NOT_EXTENSION_ROOT, dissect_separateLANStack },
  {  11, "v76wCompression"             , ASN1_NOT_EXTENSION_ROOT, dissect_v76wCompression },
  {  12, "tcp"                         , ASN1_NOT_EXTENSION_ROOT, dissect_tcp },
  {  13, "udp"                         , ASN1_NOT_EXTENSION_ROOT, dissect_udp },
  { 0, NULL, 0, NULL }
};

int
dissect_h245_DataProtocolCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_DataProtocolCapability, DataProtocolCapability_choice, "DataProtocolCapability",
                              NULL);

  return offset;
}
static int dissect_t120(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t120);
}
static int dissect_dsm_cc(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_dsm_cc);
}
static int dissect_userData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_userData);
}
static int dissect_t84Protocol(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t84Protocol);
}
static int dissect_t434(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t434);
}
static int dissect_h224(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_h224);
}
static int dissect_h222DataPartitioning(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_h222DataPartitioning);
}
static int dissect_t30fax(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t30fax);
}
static int dissect_t140(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t140);
}
static int dissect_t38FaxProtocol(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t38FaxProtocol);
}
static int dissect_nlpidProtocol(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_nlpidProtocol);
}
static int dissect_transport(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_transport);
}
static int dissect_t84DataProtocolCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataProtocolCapability(tvb, offset, pinfo, tree, hf_h245_t84DataProtocolCapability);
}

static const per_sequence_t T_t84Restricted_sequence[] = {
  { "qcif"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_qcif_bool },
  { "cif"                         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cif_bool },
  { "ccir601Seq"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ccir601Seq },
  { "ccir601Prog"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ccir601Prog },
  { "hdtvSeq"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_hdtvSeq },
  { "hdtvProg"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_hdtvProg },
  { "g3FacsMH200x100"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_g3FacsMH200x100 },
  { "g3FacsMH200x200"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_g3FacsMH200x200 },
  { "g4FacsMMR200x100"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_g4FacsMMR200x100 },
  { "g4FacsMMR200x200"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_g4FacsMMR200x200 },
  { "jbig200x200Seq"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_jbig200x200Seq },
  { "jbig200x200Prog"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_jbig200x200Prog },
  { "jbig300x300Seq"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_jbig300x300Seq },
  { "jbig300x300Prog"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_jbig300x300Prog },
  { "digPhotoLow"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_digPhotoLow },
  { "digPhotoMedSeq"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_digPhotoMedSeq },
  { "digPhotoMedProg"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_digPhotoMedProg },
  { "digPhotoHighSeq"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_digPhotoHighSeq },
  { "digPhotoHighProg"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_digPhotoHighProg },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_t84Restricted(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_t84Restricted, T_t84Restricted_sequence);

  return offset;
}
static int dissect_t84Restricted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t84Restricted(tvb, offset, pinfo, tree, hf_h245_t84Restricted);
}


static const value_string h245_T84Profile_vals[] = {
  {   0, "t84Unrestricted" },
  {   1, "t84Restricted" },
  { 0, NULL }
};

static const per_choice_t T84Profile_choice[] = {
  {   0, "t84Unrestricted"             , ASN1_NO_EXTENSIONS     , dissect_t84Unrestricted },
  {   1, "t84Restricted"               , ASN1_NO_EXTENSIONS     , dissect_t84Restricted },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T84Profile(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T84Profile, T84Profile_choice, "T84Profile",
                              NULL);

  return offset;
}
static int dissect_t84Profile(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T84Profile(tvb, offset, pinfo, tree, hf_h245_t84Profile);
}

static const per_sequence_t T_t84_sequence[] = {
  { "t84Protocol"                 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t84Protocol },
  { "t84Profile"                  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t84Profile },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_t84(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_t84, T_t84_sequence);

  return offset;
}
static int dissect_t84(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t84(tvb, offset, pinfo, tree, hf_h245_t84);
}

static const per_sequence_t Nlpid_sequence[] = {
  { "nlpidProtocol"               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nlpidProtocol },
  { "nlpidData"                   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nlpidData },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Nlpid(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Nlpid, Nlpid_sequence);

  return offset;
}
static int dissect_nlpid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Nlpid(tvb, offset, pinfo, tree, hf_h245_nlpid);
}


static const value_string h245_T38FaxRateManagement_vals[] = {
  {   0, "localTCF" },
  {   1, "transferredTCF" },
  { 0, NULL }
};

static const per_choice_t T38FaxRateManagement_choice[] = {
  {   0, "localTCF"                    , ASN1_EXTENSION_ROOT    , dissect_localTCF },
  {   1, "transferredTCF"              , ASN1_EXTENSION_ROOT    , dissect_transferredTCF },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T38FaxRateManagement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T38FaxRateManagement, T38FaxRateManagement_choice, "T38FaxRateManagement",
                              NULL);

  return offset;
}
static int dissect_t38FaxRateManagement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T38FaxRateManagement(tvb, offset, pinfo, tree, hf_h245_t38FaxRateManagement);
}



static int
dissect_h245_INTEGER(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_integer(tvb, offset, pinfo, tree, hf_index,
                               NULL, NULL);

  return offset;
}
static int dissect_t38FaxMaxBuffer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER(tvb, offset, pinfo, tree, hf_h245_t38FaxMaxBuffer);
}
static int dissect_t38FaxMaxDatagram(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER(tvb, offset, pinfo, tree, hf_h245_t38FaxMaxDatagram);
}


static const value_string h245_T_t38FaxUdpEC_vals[] = {
  {   0, "t38UDPFEC" },
  {   1, "t38UDPRedundancy" },
  { 0, NULL }
};

static const per_choice_t T_t38FaxUdpEC_choice[] = {
  {   0, "t38UDPFEC"                   , ASN1_EXTENSION_ROOT    , dissect_t38UDPFEC },
  {   1, "t38UDPRedundancy"            , ASN1_EXTENSION_ROOT    , dissect_t38UDPRedundancy },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_t38FaxUdpEC(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_t38FaxUdpEC, T_t38FaxUdpEC_choice, "T_t38FaxUdpEC",
                              NULL);

  return offset;
}
static int dissect_t38FaxUdpEC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t38FaxUdpEC(tvb, offset, pinfo, tree, hf_h245_t38FaxUdpEC);
}

static const per_sequence_t T38FaxUdpOptions_sequence[] = {
  { "t38FaxMaxBuffer"             , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_t38FaxMaxBuffer },
  { "t38FaxMaxDatagram"           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_t38FaxMaxDatagram },
  { "t38FaxUdpEC"                 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t38FaxUdpEC },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T38FaxUdpOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T38FaxUdpOptions, T38FaxUdpOptions_sequence);

  return offset;
}
static int dissect_t38FaxUdpOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T38FaxUdpOptions(tvb, offset, pinfo, tree, hf_h245_t38FaxUdpOptions);
}

static const per_sequence_t T38FaxTcpOptions_sequence[] = {
  { "t38TCPBidirectionalMode"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_t38TCPBidirectionalMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T38FaxTcpOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T38FaxTcpOptions, T38FaxTcpOptions_sequence);

  return offset;
}
static int dissect_t38FaxTcpOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T38FaxTcpOptions(tvb, offset, pinfo, tree, hf_h245_t38FaxTcpOptions);
}

static const per_sequence_t T38FaxProfile_sequence[] = {
  { "fillBitRemoval"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fillBitRemoval },
  { "transcodingJBIG"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transcodingJBIG },
  { "transcodingMMR"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transcodingMMR },
  { "version"                     , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_version },
  { "t38FaxRateManagement"        , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_t38FaxRateManagement },
  { "t38FaxUdpOptions"            , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_t38FaxUdpOptions },
  { "t38FaxTcpOptions"            , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_t38FaxTcpOptions },
  { NULL, 0, 0, NULL }
};

int
dissect_h245_T38FaxProfile(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T38FaxProfile, T38FaxProfile_sequence);

  return offset;
}
static int dissect_t38FaxProfile(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T38FaxProfile(tvb, offset, pinfo, tree, hf_h245_t38FaxProfile);
}

static const per_sequence_t T_t38fax_sequence[] = {
  { "t38FaxProtocol"              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t38FaxProtocol },
  { "t38FaxProfile"               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t38FaxProfile },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_t38fax(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_t38fax, T_t38fax_sequence);

  return offset;
}
static int dissect_t38fax(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t38fax(tvb, offset, pinfo, tree, hf_h245_t38fax);
}


static int
dissect_h245_T_standard(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_object_identifier(tvb, offset, pinfo, tree, hf_index,
                                         standard_oid_str);


  return offset;
}
static int dissect_standardOid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_standard(tvb, offset, pinfo, tree, hf_h245_standardOid);
}


static int
dissect_h245_OCTET_STRING_SIZE_16(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    16, 16,
                                    NULL, NULL);

  return offset;
}
static int dissect_uuid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_16(tvb, offset, pinfo, tree, hf_h245_uuid);
}
static int dissect_ip6_network(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_16(tvb, offset, pinfo, tree, hf_h245_ip6_network);
}
static int dissect_netBios(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_16(tvb, offset, pinfo, tree, hf_h245_netBios);
}
static int dissect_mip6_network(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_16(tvb, offset, pinfo, tree, hf_h245_mip6_network);
}
static int dissect_conferenceIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_16(tvb, offset, pinfo, tree, hf_h245_conferenceIdentifier);
}


static int
dissect_h245_IA5String_SIZE_1_64(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_IA5String(tvb, offset, pinfo, tree, hf_index,
                                 1, 64);

  return offset;
}
static int dissect_domainBased(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IA5String_SIZE_1_64(tvb, offset, pinfo, tree, hf_h245_domainBased);
}


static const value_string h245_CapabilityIdentifier_vals[] = {
  {   0, "standard" },
  {   1, "h221NonStandard" },
  {   2, "uuid" },
  {   3, "domainBased" },
  { 0, NULL }
};

static const per_choice_t CapabilityIdentifier_choice[] = {
  {   0, "standard"                    , ASN1_EXTENSION_ROOT    , dissect_standardOid },
  {   1, "h221NonStandard"             , ASN1_EXTENSION_ROOT    , dissect_h221NonStandard },
  {   2, "uuid"                        , ASN1_EXTENSION_ROOT    , dissect_uuid },
  {   3, "domainBased"                 , ASN1_EXTENSION_ROOT    , dissect_domainBased },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CapabilityIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CapabilityIdentifier, CapabilityIdentifier_choice, "CapabilityIdentifier",
                              NULL);

  return offset;
}
static int dissect_messageIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityIdentifier(tvb, offset, pinfo, tree, hf_h245_messageIdentifier);
}
static int dissect_capabilityIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityIdentifier(tvb, offset, pinfo, tree, hf_h245_capabilityIdentifier);
}



static int
dissect_h245_INTEGER_0_4294967295(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 4294967295U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_luminanceSampleRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_luminanceSampleRate);
}
static int dissect_maxBitRate2_0_4294967295(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_maxBitRate2_0_4294967295);
}
static int dissect_unsigned32Min(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_unsigned32Min);
}
static int dissect_unsigned32Max(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_unsigned32Max);
}
static int dissect_bitRate_0_4294967295(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_bitRate_0_4294967295);
}
static int dissect_callAssociationNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_callAssociationNumber);
}
static int dissect_channelTag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_channelTag);
}
static int dissect_sequenceNum(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_sequenceNum);
}
static int dissect_timestamp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_timestamp);
}
static int dissect_expirationTime(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4294967295(tvb, offset, pinfo, tree, hf_h245_expirationTime);
}



static int
dissect_h245_INTEGER_0_127(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 127U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_standard(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_127(tvb, offset, pinfo, tree, hf_h245_standard);
}
static int dissect_rsCodeCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_127(tvb, offset, pinfo, tree, hf_h245_rsCodeCorrection);
}
static int dissect_payloadType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_127(tvb, offset, pinfo, tree, hf_h245_payloadType);
}
static int dissect_protectedPayloadType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_127(tvb, offset, pinfo, tree, hf_h245_protectedPayloadType);
}


static const value_string h245_ParameterIdentifier_vals[] = {
  {   0, "standard" },
  {   1, "h221NonStandard" },
  {   2, "uuid" },
  {   3, "domainBased" },
  { 0, NULL }
};

static const per_choice_t ParameterIdentifier_choice[] = {
  {   0, "standard"                    , ASN1_EXTENSION_ROOT    , dissect_standard },
  {   1, "h221NonStandard"             , ASN1_EXTENSION_ROOT    , dissect_h221NonStandard },
  {   2, "uuid"                        , ASN1_EXTENSION_ROOT    , dissect_uuid },
  {   3, "domainBased"                 , ASN1_EXTENSION_ROOT    , dissect_domainBased },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ParameterIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ParameterIdentifier, ParameterIdentifier_choice, "ParameterIdentifier",
                              NULL);

  return offset;
}
static int dissect_parameterIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ParameterIdentifier(tvb, offset, pinfo, tree, hf_h245_parameterIdentifier);
}
static int dissect_supersedes_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ParameterIdentifier(tvb, offset, pinfo, tree, hf_h245_supersedes_item);
}


static int
dissect_h245_SEQUENCE_OF_GenericParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_GenericParameter, dissect_messageContent_item);

  return offset;
}
static int dissect_messageContent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_GenericParameter(tvb, offset, pinfo, tree, hf_h245_messageContent);
}
static int dissect_collapsing(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_GenericParameter(tvb, offset, pinfo, tree, hf_h245_collapsing);
}
static int dissect_nonCollapsing(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_GenericParameter(tvb, offset, pinfo, tree, hf_h245_nonCollapsing);
}
static int dissect_genericParameter(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_GenericParameter(tvb, offset, pinfo, tree, hf_h245_genericParameter);
}


static const value_string h245_ParameterValue_vals[] = {
  {   0, "logical" },
  {   1, "booleanArray" },
  {   2, "unsignedMin" },
  {   3, "unsignedMax" },
  {   4, "unsigned32Min" },
  {   5, "unsigned32Max" },
  {   6, "octetString" },
  {   7, "genericParameter" },
  { 0, NULL }
};

static const per_choice_t ParameterValue_choice[] = {
  {   0, "logical"                     , ASN1_EXTENSION_ROOT    , dissect_logical },
  {   1, "booleanArray"                , ASN1_EXTENSION_ROOT    , dissect_booleanArray },
  {   2, "unsignedMin"                 , ASN1_EXTENSION_ROOT    , dissect_unsignedMin },
  {   3, "unsignedMax"                 , ASN1_EXTENSION_ROOT    , dissect_unsignedMax },
  {   4, "unsigned32Min"               , ASN1_EXTENSION_ROOT    , dissect_unsigned32Min },
  {   5, "unsigned32Max"               , ASN1_EXTENSION_ROOT    , dissect_unsigned32Max },
  {   6, "octetString"                 , ASN1_EXTENSION_ROOT    , dissect_octetString },
  {   7, "genericParameter"            , ASN1_EXTENSION_ROOT    , dissect_genericParameter },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ParameterValue(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ParameterValue, ParameterValue_choice, "ParameterValue",
                              NULL);

  return offset;
}
static int dissect_parameterValue(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ParameterValue(tvb, offset, pinfo, tree, hf_h245_parameterValue);
}


static int
dissect_h245_SEQUENCE_OF_ParameterIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_ParameterIdentifier, dissect_supersedes_item);

  return offset;
}
static int dissect_supersedes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_ParameterIdentifier(tvb, offset, pinfo, tree, hf_h245_supersedes);
}

static const per_sequence_t GenericParameter_sequence[] = {
  { "parameterIdentifier"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_parameterIdentifier },
  { "parameterValue"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_parameterValue },
  { "supersedes"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_supersedes },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_GenericParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_GenericParameter, GenericParameter_sequence);

  return offset;
}

static const per_sequence_t GenericCapability_sequence[] = {
  { "capabilityIdentifier"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_capabilityIdentifier },
  { "maxBitRate"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_maxBitRate2_0_4294967295 },
  { "collapsing"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_collapsing },
  { "nonCollapsing"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonCollapsing },
  { "nonCollapsingRaw"            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonCollapsingRaw },
  { "transport"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_transport },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_GenericCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_GenericCapability, GenericCapability_sequence);

  return offset;
}
static int dissect_genericControlCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericControlCapability);
}
static int dissect_genericMultiplexCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericMultiplexCapability);
}
static int dissect_genericVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericVideoCapability);
}
static int dissect_videoCapabilityExtension_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_videoCapabilityExtension_item);
}
static int dissect_genericAudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericAudioCapability);
}
static int dissect_genericDataCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericDataCapability);
}
static int dissect_genericModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericModeParameters);
}
static int dissect_genericVideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericVideoMode);
}
static int dissect_genericAudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericAudioMode);
}
static int dissect_genericDataMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericCapability(tvb, offset, pinfo, tree, hf_h245_genericDataMode);
}


static const value_string h245_Application_vals[] = {
  {   0, "nonStandard" },
  {   1, "t120" },
  {   2, "dsm-cc" },
  {   3, "userData" },
  {   4, "t84" },
  {   5, "t434" },
  {   6, "h224" },
  {   7, "nlpid" },
  {   8, "dsvdControl" },
  {   9, "h222DataPartitioning" },
  {  10, "t30fax" },
  {  11, "t140" },
  {  12, "t38fax" },
  {  13, "genericDataCapability" },
  { 0, NULL }
};

static const per_choice_t Application_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "t120"                        , ASN1_EXTENSION_ROOT    , dissect_t120 },
  {   2, "dsm-cc"                      , ASN1_EXTENSION_ROOT    , dissect_dsm_cc },
  {   3, "userData"                    , ASN1_EXTENSION_ROOT    , dissect_userData },
  {   4, "t84"                         , ASN1_EXTENSION_ROOT    , dissect_t84 },
  {   5, "t434"                        , ASN1_EXTENSION_ROOT    , dissect_t434 },
  {   6, "h224"                        , ASN1_EXTENSION_ROOT    , dissect_h224 },
  {   7, "nlpid"                       , ASN1_EXTENSION_ROOT    , dissect_nlpid },
  {   8, "dsvdControl"                 , ASN1_EXTENSION_ROOT    , dissect_dsvdControl },
  {   9, "h222DataPartitioning"        , ASN1_EXTENSION_ROOT    , dissect_h222DataPartitioning },
  {  10, "t30fax"                      , ASN1_NOT_EXTENSION_ROOT, dissect_t30fax },
  {  11, "t140"                        , ASN1_NOT_EXTENSION_ROOT, dissect_t140 },
  {  12, "t38fax"                      , ASN1_NOT_EXTENSION_ROOT, dissect_t38fax },
  {  13, "genericDataCapability"       , ASN1_NOT_EXTENSION_ROOT, dissect_genericDataCapability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Application(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Application, Application_choice, "Application",
                              &value);

        codec_type = val_to_str(value, h245_Application_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, codec_type);

  return offset;
}
static int dissect_application(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Application(tvb, offset, pinfo, tree, hf_h245_application);
}

static const per_sequence_t DataApplicationCapability_sequence[] = {
  { "application"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_application },
  { "maxBitRate"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxBitRate2_0_4294967295 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_DataApplicationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_DataApplicationCapability, DataApplicationCapability_sequence);

  return offset;
}
static int dissect_receiveDataApplicationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_receiveDataApplicationCapability);
}
static int dissect_transmitDataApplicationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_transmitDataApplicationCapability);
}
static int dissect_receiveAndTransmitDataApplicationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitDataApplicationCapability);
}
static int dissect_centralizedData_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_centralizedData_item);
}
static int dissect_distributedData_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_distributedData_item);
}
static int dissect_data(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_data);
}


static int
dissect_h245_SEQUENCE_OF_DataApplicationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_DataApplicationCapability, dissect_centralizedData_item);

  return offset;
}
static int dissect_centralizedData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_centralizedData);
}
static int dissect_distributedData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_DataApplicationCapability(tvb, offset, pinfo, tree, hf_h245_distributedData);
}

static const per_sequence_t MediaDistributionCapability_sequence[] = {
  { "centralizedControl"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_centralizedControl },
  { "distributedControl"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_distributedControl },
  { "centralizedAudio"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_centralizedAudio },
  { "distributedAudio"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_distributedAudio },
  { "centralizedVideo"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_centralizedVideo },
  { "distributedVideo"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_distributedVideo },
  { "centralizedData"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_centralizedData },
  { "distributedData"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_distributedData },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MediaDistributionCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MediaDistributionCapability, MediaDistributionCapability_sequence);

  return offset;
}
static int dissect_mediaDistributionCapability_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MediaDistributionCapability(tvb, offset, pinfo, tree, hf_h245_mediaDistributionCapability_item);
}


static int
dissect_h245_SEQUENCE_OF_MediaDistributionCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_MediaDistributionCapability, dissect_mediaDistributionCapability_item);

  return offset;
}
static int dissect_mediaDistributionCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_MediaDistributionCapability(tvb, offset, pinfo, tree, hf_h245_mediaDistributionCapability);
}

static const per_sequence_t MultipointCapability_sequence[] = {
  { "multicastCapability"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multicastCapability },
  { "multiUniCastConference"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiUniCastConference },
  { "mediaDistributionCapability" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mediaDistributionCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultipointCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultipointCapability, MultipointCapability_sequence);

  return offset;
}
static int dissect_receiveMultipointCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultipointCapability(tvb, offset, pinfo, tree, hf_h245_receiveMultipointCapability);
}
static int dissect_transmitMultipointCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultipointCapability(tvb, offset, pinfo, tree, hf_h245_transmitMultipointCapability);
}
static int dissect_receiveAndTransmitMultipointCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultipointCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitMultipointCapability);
}

static const per_sequence_t T_mcCapability_sequence[] = {
  { "centralizedConferenceMC"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_centralizedConferenceMC },
  { "decentralizedConferenceMC"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_decentralizedConferenceMC },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_mcCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_mcCapability, T_mcCapability_sequence);

  return offset;
}
static int dissect_mcCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mcCapability(tvb, offset, pinfo, tree, hf_h245_mcCapability);
}



static int
dissect_h245_INTEGER_1_32768_(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 32768U, NULL, NULL, TRUE);

  return offset;
}
static int dissect_rfc_number(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32768_(tvb, offset, pinfo, tree, hf_h245_rfc_number);
}


static const value_string h245_T_payloadDescriptor_vals[] = {
  {   0, "nonStandardIdentifier" },
  {   1, "rfc-number" },
  {   2, "oid" },
  { 0, NULL }
};

static const per_choice_t T_payloadDescriptor_choice[] = {
  {   0, "nonStandardIdentifier"       , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "rfc-number"                  , ASN1_EXTENSION_ROOT    , dissect_rfc_number },
  {   2, "oid"                         , ASN1_EXTENSION_ROOT    , dissect_oid },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_payloadDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_payloadDescriptor, T_payloadDescriptor_choice, "T_payloadDescriptor",
                              NULL);

  return offset;
}
static int dissect_payloadDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_payloadDescriptor(tvb, offset, pinfo, tree, hf_h245_payloadDescriptor);
}

static const per_sequence_t RTPPayloadType_sequence[] = {
  { "payloadDescriptor"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_payloadDescriptor },
  { "payloadType"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_payloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RTPPayloadType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RTPPayloadType, RTPPayloadType_sequence);

  return offset;
}
static int dissect_rtpPayloadType2_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RTPPayloadType(tvb, offset, pinfo, tree, hf_h245_rtpPayloadType2_item);
}
static int dissect_rtpPayloadType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RTPPayloadType(tvb, offset, pinfo, tree, hf_h245_rtpPayloadType);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_RTPPayloadType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_RTPPayloadType, dissect_rtpPayloadType2_item,
                                               1, 256);

  return offset;
}
static int dissect_rtpPayloadType2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_RTPPayloadType(tvb, offset, pinfo, tree, hf_h245_rtpPayloadType2);
}

static const per_sequence_t MediaPacketizationCapability_sequence[] = {
  { "h261aVideoPacketization"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h261aVideoPacketization },
  { "rtpPayloadType2"             , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rtpPayloadType2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MediaPacketizationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MediaPacketizationCapability, MediaPacketizationCapability_sequence);

  return offset;
}
static int dissect_mediaPacketizationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MediaPacketizationCapability(tvb, offset, pinfo, tree, hf_h245_mediaPacketizationCapability);
}


static const value_string h245_QOSMode_vals[] = {
  {   0, "guaranteedQOS" },
  {   1, "controlledLoad" },
  { 0, NULL }
};

static const per_choice_t QOSMode_choice[] = {
  {   0, "guaranteedQOS"               , ASN1_EXTENSION_ROOT    , dissect_guaranteedQOS },
  {   1, "controlledLoad"              , ASN1_EXTENSION_ROOT    , dissect_controlledLoad },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_QOSMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_QOSMode, QOSMode_choice, "QOSMode",
                              NULL);

  return offset;
}
static int dissect_qosMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_QOSMode(tvb, offset, pinfo, tree, hf_h245_qosMode);
}



static int
dissect_h245_INTEGER_1_4294967295(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 4294967295U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_tokenRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_tokenRate);
}
static int dissect_bucketSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_bucketSize);
}
static int dissect_peakRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_peakRate);
}
static int dissect_minPoliced(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_minPoliced);
}
static int dissect_maxPktSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_maxPktSize);
}
static int dissect_sRandom(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4294967295(tvb, offset, pinfo, tree, hf_h245_sRandom);
}

static const per_sequence_t RSVPParameters_sequence[] = {
  { "qosMode"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qosMode },
  { "tokenRate"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_tokenRate },
  { "bucketSize"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_bucketSize },
  { "peakRate"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_peakRate },
  { "minPoliced"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_minPoliced },
  { "maxPktSize"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_maxPktSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RSVPParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RSVPParameters, RSVPParameters_sequence);

  return offset;
}
static int dissect_rsvpParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RSVPParameters(tvb, offset, pinfo, tree, hf_h245_rsvpParameters);
}

static const per_sequence_t ATMParameters_sequence[] = {
  { "maxNTUSize"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxNTUSize },
  { "atmUBR"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_atmUBR },
  { "atmrtVBR"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_atmrtVBR },
  { "atmnrtVBR"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_atmnrtVBR },
  { "atmABR"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_atmABR },
  { "atmCBR"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_atmCBR },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_ATMParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_ATMParameters, ATMParameters_sequence);

  return offset;
}
static int dissect_atmParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ATMParameters(tvb, offset, pinfo, tree, hf_h245_atmParameters);
}

static const per_sequence_t QOSCapability_sequence[] = {
  { "nonStandardData"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandardData },
  { "rsvpParameters"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rsvpParameters },
  { "atmParameters"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_atmParameters },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_QOSCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_QOSCapability, QOSCapability_sequence);

  return offset;
}
static int dissect_qOSCapabilities_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_QOSCapability(tvb, offset, pinfo, tree, hf_h245_qOSCapabilities_item);
}
static int dissect_qosCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_QOSCapability(tvb, offset, pinfo, tree, hf_h245_qosCapability);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_QOSCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_QOSCapability, dissect_qOSCapabilities_item,
                                               1, 256);

  return offset;
}
static int dissect_qOSCapabilities(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_QOSCapability(tvb, offset, pinfo, tree, hf_h245_qOSCapabilities);
}

static const per_sequence_t T_atm_AAL5_compressed_sequence[] = {
  { "variable-delta"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_variable_delta },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_atm_AAL5_compressed(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_atm_AAL5_compressed, T_atm_AAL5_compressed_sequence);

  return offset;
}
static int dissect_atm_AAL5_compressed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_atm_AAL5_compressed(tvb, offset, pinfo, tree, hf_h245_atm_AAL5_compressed);
}


static const value_string h245_MediaTransportType_vals[] = {
  {   0, "ip-UDP" },
  {   1, "ip-TCP" },
  {   2, "atm-AAL5-UNIDIR" },
  {   3, "atm-AAL5-BIDIR" },
  {   4, "atm-AAL5-compressed" },
  { 0, NULL }
};

static const per_choice_t MediaTransportType_choice[] = {
  {   0, "ip-UDP"                      , ASN1_EXTENSION_ROOT    , dissect_ip_UDP },
  {   1, "ip-TCP"                      , ASN1_EXTENSION_ROOT    , dissect_ip_TCP },
  {   2, "atm-AAL5-UNIDIR"             , ASN1_EXTENSION_ROOT    , dissect_atm_AAL5_UNIDIR },
  {   3, "atm-AAL5-BIDIR"              , ASN1_EXTENSION_ROOT    , dissect_atm_AAL5_BIDIR },
  {   4, "atm-AAL5-compressed"         , ASN1_NOT_EXTENSION_ROOT, dissect_atm_AAL5_compressed },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MediaTransportType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MediaTransportType, MediaTransportType_choice, "MediaTransportType",
                              NULL);

  return offset;
}
static int dissect_mediaTransport(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MediaTransportType(tvb, offset, pinfo, tree, hf_h245_mediaTransport);
}

static const per_sequence_t MediaChannelCapability_sequence[] = {
  { "mediaTransport"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaTransport },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MediaChannelCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MediaChannelCapability, MediaChannelCapability_sequence);

  return offset;
}
static int dissect_mediaChannelCapabilities_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MediaChannelCapability(tvb, offset, pinfo, tree, hf_h245_mediaChannelCapabilities_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_MediaChannelCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_MediaChannelCapability, dissect_mediaChannelCapabilities_item,
                                               1, 256);

  return offset;
}
static int dissect_mediaChannelCapabilities(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_MediaChannelCapability(tvb, offset, pinfo, tree, hf_h245_mediaChannelCapabilities);
}

static const per_sequence_t TransportCapability_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandard },
  { "qOSCapabilities"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qOSCapabilities },
  { "mediaChannelCapabilities"    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaChannelCapabilities },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TransportCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TransportCapability, TransportCapability_sequence);

  return offset;
}
static int dissect_transportCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TransportCapability(tvb, offset, pinfo, tree, hf_h245_transportCapability);
}



static int
dissect_h245_INTEGER_1_16(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 16U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_numberOfThreads(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_16(tvb, offset, pinfo, tree, hf_h245_numberOfThreads);
}



static int
dissect_h245_INTEGER_0_15(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 15U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_containedThreads_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_15(tvb, offset, pinfo, tree, hf_h245_containedThreads_item);
}
static int dissect_threadNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_15(tvb, offset, pinfo, tree, hf_h245_threadNumber);
}
static int dissect_framesPerSecond(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_15(tvb, offset, pinfo, tree, hf_h245_framesPerSecond);
}
static int dissect_pictureRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_15(tvb, offset, pinfo, tree, hf_h245_pictureRate);
}
static int dissect_skippedFrameCount(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_15(tvb, offset, pinfo, tree, hf_h245_skippedFrameCount);
}


static int
dissect_h245_T_frameSequence(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_T_frameSequence, dissect_frameSequence_item,
                                               1, 256);

  return offset;
}
static int dissect_frameSequence(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_frameSequence(tvb, offset, pinfo, tree, hf_h245_frameSequence);
}

static const per_sequence_t RTPH263VideoRedundancyFrameMapping_sequence[] = {
  { "threadNumber"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_threadNumber },
  { "frameSequence"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_frameSequence },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RTPH263VideoRedundancyFrameMapping(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RTPH263VideoRedundancyFrameMapping, RTPH263VideoRedundancyFrameMapping_sequence);

  return offset;
}
static int dissect_custom_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RTPH263VideoRedundancyFrameMapping(tvb, offset, pinfo, tree, hf_h245_custom_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_RTPH263VideoRedundancyFrameMapping(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_RTPH263VideoRedundancyFrameMapping, dissect_custom_item,
                                               1, 256);

  return offset;
}
static int dissect_custom(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_RTPH263VideoRedundancyFrameMapping(tvb, offset, pinfo, tree, hf_h245_custom);
}


static const value_string h245_T_frameToThreadMapping_vals[] = {
  {   0, "roundrobin" },
  {   1, "custom" },
  { 0, NULL }
};

static const per_choice_t T_frameToThreadMapping_choice[] = {
  {   0, "roundrobin"                  , ASN1_EXTENSION_ROOT    , dissect_roundrobin },
  {   1, "custom"                      , ASN1_EXTENSION_ROOT    , dissect_custom },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_frameToThreadMapping(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_frameToThreadMapping, T_frameToThreadMapping_choice, "T_frameToThreadMapping",
                              NULL);

  return offset;
}
static int dissect_frameToThreadMapping(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_frameToThreadMapping(tvb, offset, pinfo, tree, hf_h245_frameToThreadMapping);
}


static int
dissect_h245_T_containedThreads(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_T_containedThreads, dissect_containedThreads_item,
                                               1, 256);

  return offset;
}
static int dissect_containedThreads(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_containedThreads(tvb, offset, pinfo, tree, hf_h245_containedThreads);
}

static const per_sequence_t RTPH263VideoRedundancyEncoding_sequence[] = {
  { "numberOfThreads"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfThreads },
  { "framesBetweenSyncPoints"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_framesBetweenSyncPoints },
  { "frameToThreadMapping"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_frameToThreadMapping },
  { "containedThreads"            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_containedThreads },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RTPH263VideoRedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RTPH263VideoRedundancyEncoding, RTPH263VideoRedundancyEncoding_sequence);

  return offset;
}
static int dissect_rtpH263VideoRedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RTPH263VideoRedundancyEncoding(tvb, offset, pinfo, tree, hf_h245_rtpH263VideoRedundancyEncoding);
}


static const value_string h245_RedundancyEncodingMethod_vals[] = {
  {   0, "nonStandard" },
  {   1, "rtpAudioRedundancyEncoding" },
  {   2, "rtpH263VideoRedundancyEncoding" },
  { 0, NULL }
};

static const per_choice_t RedundancyEncodingMethod_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "rtpAudioRedundancyEncoding"  , ASN1_EXTENSION_ROOT    , dissect_rtpAudioRedundancyEncoding },
  {   2, "rtpH263VideoRedundancyEncoding", ASN1_NOT_EXTENSION_ROOT, dissect_rtpH263VideoRedundancyEncoding },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingMethod(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RedundancyEncodingMethod, RedundancyEncodingMethod_choice, "RedundancyEncodingMethod",
                              NULL);

  return offset;
}
static int dissect_redundancyEncodingMethod(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingMethod(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingMethod);
}



static int
dissect_h245_CapabilityTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 65535U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_capabilityTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_capabilityTableEntryNumber);
}
static int dissect_AlternativeCapabilitySet_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_AlternativeCapabilitySet_item);
}
static int dissect_highestEntryNumberProcessed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_highestEntryNumberProcessed);
}
static int dissect_mediaCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_mediaCapability);
}
static int dissect_primaryEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_primaryEncoding);
}
static int dissect_secondaryEncoding2_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_secondaryEncoding2_item);
}
static int dissect_capabilityTableEntryNumbers_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_capabilityTableEntryNumbers_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_CapabilityTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_CapabilityTableEntryNumber, dissect_secondaryEncoding2_item,
                                               1, 256);

  return offset;
}
static int dissect_secondaryEncoding2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_secondaryEncoding2);
}

static const per_sequence_t RedundancyEncodingCapability_sequence[] = {
  { "redundancyEncodingMethod"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_redundancyEncodingMethod },
  { "primaryEncoding"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_primaryEncoding },
  { "secondaryEncoding2"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_secondaryEncoding2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncodingCapability, RedundancyEncodingCapability_sequence);

  return offset;
}
static int dissect_redundancyEncodingCapability_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingCapability(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingCapability_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_RedundancyEncodingCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_RedundancyEncodingCapability, dissect_redundancyEncodingCapability_item,
                                               1, 256);

  return offset;
}
static int dissect_redundancyEncodingCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_RedundancyEncodingCapability(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingCapability);
}

static const per_sequence_t H2250Capability_sequence[] = {
  { "maximumAudioDelayJitter"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumAudioDelayJitter },
  { "receiveMultipointCapability" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_receiveMultipointCapability },
  { "transmitMultipointCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transmitMultipointCapability },
  { "receiveAndTransmitMultipointCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_receiveAndTransmitMultipointCapability },
  { "mcCapability"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mcCapability },
  { "rtcpVideoControlCapability"  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rtcpVideoControlCapability },
  { "mediaPacketizationCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mediaPacketizationCapability },
  { "transportCapability"         , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_transportCapability },
  { "redundancyEncodingCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_redundancyEncodingCapability },
  { "logicalChannelSwitchingCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_logicalChannelSwitchingCapability },
  { "t120DynamicPortCapability"   , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_t120DynamicPortCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H2250Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H2250Capability, H2250Capability_sequence);

  return offset;
}
static int dissect_h2250Capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H2250Capability(tvb, offset, pinfo, tree, hf_h245_h2250Capability);
}


static const value_string h245_MultiplexCapability_vals[] = {
  {   0, "nonStandard" },
  {   1, "h222Capability" },
  {   2, "h223Capability" },
  {   3, "v76Capability" },
  {   4, "h2250Capability" },
  {   5, "genericMultiplexCapability" },
  { 0, NULL }
};

static const per_choice_t MultiplexCapability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "h222Capability"              , ASN1_EXTENSION_ROOT    , dissect_h222Capability },
  {   2, "h223Capability"              , ASN1_EXTENSION_ROOT    , dissect_h223Capability },
  {   3, "v76Capability"               , ASN1_EXTENSION_ROOT    , dissect_v76Capability },
  {   4, "h2250Capability"             , ASN1_NOT_EXTENSION_ROOT, dissect_h2250Capability },
  {   5, "genericMultiplexCapability"  , ASN1_NOT_EXTENSION_ROOT, dissect_genericMultiplexCapability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultiplexCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultiplexCapability, MultiplexCapability_choice, "MultiplexCapability",
                              NULL);

  return offset;
}
static int dissect_multiplexCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexCapability(tvb, offset, pinfo, tree, hf_h245_multiplexCapability);
}



static int
dissect_h245_INTEGER_1_4(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 4U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_qcifMPI_1_4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4(tvb, offset, pinfo, tree, hf_h245_qcifMPI_1_4);
}
static int dissect_cifMPI_1_4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_4(tvb, offset, pinfo, tree, hf_h245_cifMPI_1_4);
}

static const per_sequence_t H261VideoCapability_sequence[] = {
  { "qcifMPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qcifMPI_1_4 },
  { "cifMPI"                      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cifMPI_1_4 },
  { "temporalSpatialTradeOffCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_temporalSpatialTradeOffCapability },
  { "maxBitRate"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxBitRate_1_19200 },
  { "stillImageTransmission"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_stillImageTransmission },
  { "videoBadMBsCap"              , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_videoBadMBsCap },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H261VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H261VideoCapability, H261VideoCapability_sequence);

  return offset;
}
static int dissect_h261VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H261VideoCapability(tvb, offset, pinfo, tree, hf_h245_h261VideoCapability);
}



static int
dissect_h245_INTEGER_0_1073741823(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 1073741823U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_videoBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_1073741823(tvb, offset, pinfo, tree, hf_h245_videoBitRate);
}



static int
dissect_h245_INTEGER_0_262143(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 262143U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_vbvBufferSize(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_262143(tvb, offset, pinfo, tree, hf_h245_vbvBufferSize);
}
static int dissect_additionalDecoderBuffer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_262143(tvb, offset, pinfo, tree, hf_h245_additionalDecoderBuffer);
}



static int
dissect_h245_INTEGER_0_16383(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 16383U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_samplesPerLine(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16383(tvb, offset, pinfo, tree, hf_h245_samplesPerLine);
}
static int dissect_linesPerFrame(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16383(tvb, offset, pinfo, tree, hf_h245_linesPerFrame);
}

static const per_sequence_t H262VideoCapability_sequence[] = {
  { "profileAndLevel-SPatML"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_SPatML },
  { "profileAndLevel-MPatLL"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_MPatLL },
  { "profileAndLevel-MPatML"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_MPatML },
  { "profileAndLevel-MPatH-14"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_MPatH_14 },
  { "profileAndLevel-MPatHL"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_MPatHL },
  { "profileAndLevel-SNRatLL"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_SNRatLL },
  { "profileAndLevel-SNRatML"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_SNRatML },
  { "profileAndLevel-SpatialatH-14", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_SpatialatH_14 },
  { "profileAndLevel-HPatML"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_HPatML },
  { "profileAndLevel-HPatH-14"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_HPatH_14 },
  { "profileAndLevel-HPatHL"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel_HPatHL },
  { "videoBitRate"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_videoBitRate },
  { "vbvBufferSize"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vbvBufferSize },
  { "samplesPerLine"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_samplesPerLine },
  { "linesPerFrame"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_linesPerFrame },
  { "framesPerSecond"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_framesPerSecond },
  { "luminanceSampleRate"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_luminanceSampleRate },
  { "videoBadMBsCap"              , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_videoBadMBsCap },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H262VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H262VideoCapability, H262VideoCapability_sequence);

  return offset;
}
static int dissect_h262VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H262VideoCapability(tvb, offset, pinfo, tree, hf_h245_h262VideoCapability);
}



static int
dissect_h245_INTEGER_1_32(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 32U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_sqcifMPI_1_32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32(tvb, offset, pinfo, tree, hf_h245_sqcifMPI_1_32);
}
static int dissect_qcifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32(tvb, offset, pinfo, tree, hf_h245_qcifMPI);
}
static int dissect_cifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32(tvb, offset, pinfo, tree, hf_h245_cifMPI);
}
static int dissect_cif4MPI_1_32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32(tvb, offset, pinfo, tree, hf_h245_cif4MPI_1_32);
}
static int dissect_cif16MPI_1_32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_32(tvb, offset, pinfo, tree, hf_h245_cif16MPI_1_32);
}



static int
dissect_h245_INTEGER_1_192400(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 192400U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maxBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_192400(tvb, offset, pinfo, tree, hf_h245_maxBitRate);
}



static int
dissect_h245_INTEGER_0_524287(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 524287U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_hrd_B(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_524287(tvb, offset, pinfo, tree, hf_h245_hrd_B);
}



static int
dissect_h245_INTEGER_1_3600(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 3600U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_slowSqcifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_3600(tvb, offset, pinfo, tree, hf_h245_slowSqcifMPI);
}
static int dissect_slowQcifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_3600(tvb, offset, pinfo, tree, hf_h245_slowQcifMPI);
}
static int dissect_slowCifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_3600(tvb, offset, pinfo, tree, hf_h245_slowCifMPI);
}
static int dissect_slowCif4MPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_3600(tvb, offset, pinfo, tree, hf_h245_slowCif4MPI);
}
static int dissect_slowCif16MPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_3600(tvb, offset, pinfo, tree, hf_h245_slowCif16MPI);
}



static int
dissect_h245_INTEGER_M262144_262143(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           -262144, 262143U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_offset_x(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_M262144_262143(tvb, offset, pinfo, tree, hf_h245_offset_x);
}
static int dissect_offset_y(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_M262144_262143(tvb, offset, pinfo, tree, hf_h245_offset_y);
}

static const per_sequence_t TransparencyParameters_sequence[] = {
  { "presentationOrder"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_presentationOrder },
  { "offset-x"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_offset_x },
  { "offset-y"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_offset_y },
  { "scale-x"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scale_x },
  { "scale-y"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scale_y },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TransparencyParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TransparencyParameters, TransparencyParameters_sequence);

  return offset;
}
static int dissect_transparencyParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TransparencyParameters(tvb, offset, pinfo, tree, hf_h245_transparencyParameters);
}

static const per_sequence_t T_additionalPictureMemory_sequence[] = {
  { "sqcifAdditionalPictureMemory", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sqcifAdditionalPictureMemory },
  { "qcifAdditionalPictureMemory" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qcifAdditionalPictureMemory },
  { "cifAdditionalPictureMemory"  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cifAdditionalPictureMemory },
  { "cif4AdditionalPictureMemory" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif4AdditionalPictureMemory },
  { "cif16AdditionalPictureMemory", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif16AdditionalPictureMemory },
  { "bigCpfAdditionalPictureMemory", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_bigCpfAdditionalPictureMemory },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_additionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_additionalPictureMemory, T_additionalPictureMemory_sequence);

  return offset;
}
static int dissect_additionalPictureMemory(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_additionalPictureMemory(tvb, offset, pinfo, tree, hf_h245_additionalPictureMemory);
}


static const value_string h245_T_videoBackChannelSend_vals[] = {
  {   0, "none" },
  {   1, "ackMessageOnly" },
  {   2, "nackMessageOnly" },
  {   3, "ackOrNackMessageOnly" },
  {   4, "ackAndNackMessage" },
  { 0, NULL }
};

static const per_choice_t T_videoBackChannelSend_choice[] = {
  {   0, "none"                        , ASN1_EXTENSION_ROOT    , dissect_none },
  {   1, "ackMessageOnly"              , ASN1_EXTENSION_ROOT    , dissect_ackMessageOnly },
  {   2, "nackMessageOnly"             , ASN1_EXTENSION_ROOT    , dissect_nackMessageOnly },
  {   3, "ackOrNackMessageOnly"        , ASN1_EXTENSION_ROOT    , dissect_ackOrNackMessageOnly },
  {   4, "ackAndNackMessage"           , ASN1_EXTENSION_ROOT    , dissect_ackAndNackMessage },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_videoBackChannelSend(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_videoBackChannelSend, T_videoBackChannelSend_choice, "T_videoBackChannelSend",
                              NULL);

  return offset;
}
static int dissect_videoBackChannelSend(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_videoBackChannelSend(tvb, offset, pinfo, tree, hf_h245_videoBackChannelSend);
}



static int
dissect_h245_INTEGER_1_128(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 128U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_mpuHorizMBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_128(tvb, offset, pinfo, tree, hf_h245_mpuHorizMBs);
}



static int
dissect_h245_INTEGER_1_72(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 72U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_mpuVertMBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_72(tvb, offset, pinfo, tree, hf_h245_mpuVertMBs);
}

static const per_sequence_t T_subPictureRemovalParameters_sequence[] = {
  { "mpuHorizMBs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mpuHorizMBs },
  { "mpuVertMBs"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mpuVertMBs },
  { "mpuTotalNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mpuTotalNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_subPictureRemovalParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_subPictureRemovalParameters, T_subPictureRemovalParameters_sequence);

  return offset;
}
static int dissect_subPictureRemovalParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_subPictureRemovalParameters(tvb, offset, pinfo, tree, hf_h245_subPictureRemovalParameters);
}

static const per_sequence_t T_enhancedReferencePicSelect_sequence[] = {
  { "subPictureRemovalParameters" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_subPictureRemovalParameters },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_enhancedReferencePicSelect(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_enhancedReferencePicSelect, T_enhancedReferencePicSelect_sequence);

  return offset;
}
static int dissect_enhancedReferencePicSelect(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_enhancedReferencePicSelect(tvb, offset, pinfo, tree, hf_h245_enhancedReferencePicSelect);
}

static const per_sequence_t RefPictureSelection_sequence[] = {
  { "additionalPictureMemory"     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_additionalPictureMemory },
  { "videoMux"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoMux },
  { "videoBackChannelSend"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoBackChannelSend },
  { "enhancedReferencePicSelect"  , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_enhancedReferencePicSelect },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RefPictureSelection(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RefPictureSelection, RefPictureSelection_sequence);

  return offset;
}
static int dissect_refPictureSelection(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RefPictureSelection(tvb, offset, pinfo, tree, hf_h245_refPictureSelection);
}



static int
dissect_h245_INTEGER_1000_1001(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1000U, 1001U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_clockConversionCode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1000_1001(tvb, offset, pinfo, tree, hf_h245_clockConversionCode);
}



static int
dissect_h245_INTEGER_1_2048(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 2048U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_sqcifMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_sqcifMPI);
}
static int dissect_qcifMPI_1_2048(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_qcifMPI_1_2048);
}
static int dissect_cifMPI2_1_2048(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_cifMPI2_1_2048);
}
static int dissect_cif4MPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_cif4MPI);
}
static int dissect_cif16MPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_cif16MPI);
}
static int dissect_maxCustomPictureWidth(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_maxCustomPictureWidth);
}
static int dissect_maxCustomPictureHeight(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_maxCustomPictureHeight);
}
static int dissect_minCustomPictureWidth(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_minCustomPictureWidth);
}
static int dissect_minCustomPictureHeight(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_minCustomPictureHeight);
}
static int dissect_customMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_2048(tvb, offset, pinfo, tree, hf_h245_customMPI);
}

static const per_sequence_t CustomPictureClockFrequency_sequence[] = {
  { "clockConversionCode"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_clockConversionCode },
  { "clockDivisor"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_clockDivisor },
  { "sqcifMPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sqcifMPI },
  { "qcifMPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qcifMPI_1_2048 },
  { "cifMPI"                      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cifMPI2_1_2048 },
  { "cif4MPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif4MPI },
  { "cif16MPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif16MPI },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CustomPictureClockFrequency(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CustomPictureClockFrequency, CustomPictureClockFrequency_sequence);

  return offset;
}
static int dissect_customPictureClockFrequency_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CustomPictureClockFrequency(tvb, offset, pinfo, tree, hf_h245_customPictureClockFrequency_item);
}


static int
dissect_h245_SET_SIZE_1_16_OF_CustomPictureClockFrequency(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_16_OF_CustomPictureClockFrequency, dissect_customPictureClockFrequency_item,
                                          1, 16);

  return offset;
}
static int dissect_customPictureClockFrequency(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_16_OF_CustomPictureClockFrequency(tvb, offset, pinfo, tree, hf_h245_customPictureClockFrequency);
}



static int
dissect_h245_INTEGER_1_31(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 31U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_standardMPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_31(tvb, offset, pinfo, tree, hf_h245_standardMPI);
}

static const per_sequence_t T_customPCF_item_sequence[] = {
  { "clockConversionCode"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_clockConversionCode },
  { "clockDivisor"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_clockDivisor },
  { "customMPI"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_customMPI },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_customPCF_item(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_customPCF_item, T_customPCF_item_sequence);

  return offset;
}
static int dissect_customPCF_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_customPCF_item(tvb, offset, pinfo, tree, hf_h245_customPCF_item);
}


static int
dissect_h245_T_customPCF(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_T_customPCF, dissect_customPCF_item,
                                          1, 16);

  return offset;
}
static int dissect_customPCF(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_customPCF(tvb, offset, pinfo, tree, hf_h245_customPCF);
}

static const per_sequence_t T_mPI_sequence[] = {
  { "standardMPI"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_standardMPI },
  { "customPCF"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_customPCF },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_mPI(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_mPI, T_mPI_sequence);

  return offset;
}
static int dissect_mPI(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mPI(tvb, offset, pinfo, tree, hf_h245_mPI);
}



static int
dissect_h245_INTEGER_1_14(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 14U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_pixelAspectCode_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_14(tvb, offset, pinfo, tree, hf_h245_pixelAspectCode_item);
}


static int
dissect_h245_T_pixelAspectCode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_T_pixelAspectCode, dissect_pixelAspectCode_item,
                                          1, 14);

  return offset;
}
static int dissect_pixelAspectCode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_pixelAspectCode(tvb, offset, pinfo, tree, hf_h245_pixelAspectCode);
}

static const per_sequence_t T_extendedPAR_item_sequence[] = {
  { "width"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_width },
  { "height"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_height },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_extendedPAR_item(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_extendedPAR_item, T_extendedPAR_item_sequence);

  return offset;
}
static int dissect_extendedPAR_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_extendedPAR_item(tvb, offset, pinfo, tree, hf_h245_extendedPAR_item);
}


static int
dissect_h245_T_extendedPAR(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_T_extendedPAR, dissect_extendedPAR_item,
                                          1, 256);

  return offset;
}
static int dissect_extendedPAR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_extendedPAR(tvb, offset, pinfo, tree, hf_h245_extendedPAR);
}


static const value_string h245_T_pixelAspectInformation_vals[] = {
  {   0, "anyPixelAspectRatio" },
  {   1, "pixelAspectCode" },
  {   2, "extendedPAR" },
  { 0, NULL }
};

static const per_choice_t T_pixelAspectInformation_choice[] = {
  {   0, "anyPixelAspectRatio"         , ASN1_EXTENSION_ROOT    , dissect_anyPixelAspectRatio },
  {   1, "pixelAspectCode"             , ASN1_EXTENSION_ROOT    , dissect_pixelAspectCode },
  {   2, "extendedPAR"                 , ASN1_EXTENSION_ROOT    , dissect_extendedPAR },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_pixelAspectInformation(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_pixelAspectInformation, T_pixelAspectInformation_choice, "T_pixelAspectInformation",
                              NULL);

  return offset;
}
static int dissect_pixelAspectInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_pixelAspectInformation(tvb, offset, pinfo, tree, hf_h245_pixelAspectInformation);
}

static const per_sequence_t CustomPictureFormat_sequence[] = {
  { "maxCustomPictureWidth"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxCustomPictureWidth },
  { "maxCustomPictureHeight"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxCustomPictureHeight },
  { "minCustomPictureWidth"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_minCustomPictureWidth },
  { "minCustomPictureHeight"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_minCustomPictureHeight },
  { "mPI"                         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mPI },
  { "pixelAspectInformation"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pixelAspectInformation },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CustomPictureFormat(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CustomPictureFormat, CustomPictureFormat_sequence);

  return offset;
}
static int dissect_customPictureFormat_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CustomPictureFormat(tvb, offset, pinfo, tree, hf_h245_customPictureFormat_item);
}


static int
dissect_h245_SET_SIZE_1_16_OF_CustomPictureFormat(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_16_OF_CustomPictureFormat, dissect_customPictureFormat_item,
                                          1, 16);

  return offset;
}
static int dissect_customPictureFormat(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_16_OF_CustomPictureFormat(tvb, offset, pinfo, tree, hf_h245_customPictureFormat);
}

static const per_sequence_t H263Version3Options_sequence[] = {
  { "dataPartitionedSlices"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataPartitionedSlices },
  { "fixedPointIDCT0"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fixedPointIDCT0 },
  { "interlacedFields"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_interlacedFields },
  { "currentPictureHeaderRepetition", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_currentPictureHeaderRepetition },
  { "previousPictureHeaderRepetition", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_previousPictureHeaderRepetition },
  { "nextPictureHeaderRepetition" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nextPictureHeaderRepetition },
  { "pictureNumber"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pictureNumberBoolean },
  { "spareReferencePictures"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_spareReferencePictures },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263Version3Options(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263Version3Options, H263Version3Options_sequence);

  return offset;
}
static int dissect_h263Version3Options(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263Version3Options(tvb, offset, pinfo, tree, hf_h245_h263Version3Options);
}

static const per_sequence_t H263ModeComboFlags_sequence[] = {
  { "unrestrictedVector"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unrestrictedVector },
  { "arithmeticCoding"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arithmeticCoding },
  { "advancedPrediction"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_advancedPrediction },
  { "pbFrames"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pbFrames },
  { "advancedIntraCodingMode"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_advancedIntraCodingMode },
  { "deblockingFilterMode"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_deblockingFilterMode },
  { "unlimitedMotionVectors"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unlimitedMotionVectors },
  { "slicesInOrder-NonRect"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesInOrder_NonRect },
  { "slicesInOrder-Rect"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesInOrder_Rect },
  { "slicesNoOrder-NonRect"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesNoOrder_NonRect },
  { "slicesNoOrder-Rect"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesNoOrder_Rect },
  { "improvedPBFramesMode"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_improvedPBFramesMode },
  { "referencePicSelect"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_referencePicSelect },
  { "dynamicPictureResizingByFour", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicPictureResizingByFour },
  { "dynamicPictureResizingSixteenthPel", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicPictureResizingSixteenthPel },
  { "dynamicWarpingHalfPel"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicWarpingHalfPel },
  { "dynamicWarpingSixteenthPel"  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicWarpingSixteenthPel },
  { "reducedResolutionUpdate"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_reducedResolutionUpdate },
  { "independentSegmentDecoding"  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_independentSegmentDecoding },
  { "alternateInterVLCMode"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alternateInterVLCMode },
  { "modifiedQuantizationMode"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_modifiedQuantizationMode },
  { "enhancedReferencePicSelect"  , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_enhancedReferencePicSelectBool },
  { "h263Version3Options"         , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_h263Version3Options },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263ModeComboFlags(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263ModeComboFlags, H263ModeComboFlags_sequence);

  return offset;
}
static int dissect_h263VideoUncoupledModes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263ModeComboFlags(tvb, offset, pinfo, tree, hf_h245_h263VideoUncoupledModes);
}
static int dissect_h263VideoCoupledModes_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263ModeComboFlags(tvb, offset, pinfo, tree, hf_h245_h263VideoCoupledModes_item);
}


static int
dissect_h245_SET_SIZE_1_16_OF_H263ModeComboFlags(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_16_OF_H263ModeComboFlags, dissect_h263VideoCoupledModes_item,
                                          1, 16);

  return offset;
}
static int dissect_h263VideoCoupledModes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_16_OF_H263ModeComboFlags(tvb, offset, pinfo, tree, hf_h245_h263VideoCoupledModes);
}

static const per_sequence_t H263VideoModeCombos_sequence[] = {
  { "h263VideoUncoupledModes"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h263VideoUncoupledModes },
  { "h263VideoCoupledModes"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h263VideoCoupledModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263VideoModeCombos(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263VideoModeCombos, H263VideoModeCombos_sequence);

  return offset;
}
static int dissect_modeCombos_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263VideoModeCombos(tvb, offset, pinfo, tree, hf_h245_modeCombos_item);
}


static int
dissect_h245_SET_SIZE_1_16_OF_H263VideoModeCombos(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_16_OF_H263VideoModeCombos, dissect_modeCombos_item,
                                          1, 16);

  return offset;
}
static int dissect_modeCombos(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_16_OF_H263VideoModeCombos(tvb, offset, pinfo, tree, hf_h245_modeCombos);
}

static const per_sequence_t H263Options_sequence[] = {
  { "advancedIntraCodingMode"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_advancedIntraCodingMode },
  { "deblockingFilterMode"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_deblockingFilterMode },
  { "improvedPBFramesMode"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_improvedPBFramesMode },
  { "unlimitedMotionVectors"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unlimitedMotionVectors },
  { "fullPictureFreeze"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fullPictureFreeze },
  { "partialPictureFreezeAndRelease", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partialPictureFreezeAndRelease },
  { "resizingPartPicFreezeAndRelease", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_resizingPartPicFreezeAndRelease },
  { "fullPictureSnapshot"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fullPictureSnapshot },
  { "partialPictureSnapshot"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partialPictureSnapshot },
  { "videoSegmentTagging"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoSegmentTagging },
  { "progressiveRefinement"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_progressiveRefinement },
  { "dynamicPictureResizingByFour", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicPictureResizingByFour },
  { "dynamicPictureResizingSixteenthPel", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicPictureResizingSixteenthPel },
  { "dynamicWarpingHalfPel"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicWarpingHalfPel },
  { "dynamicWarpingSixteenthPel"  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicWarpingSixteenthPel },
  { "independentSegmentDecoding"  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_independentSegmentDecoding },
  { "slicesInOrder-NonRect"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesInOrder_NonRect },
  { "slicesInOrder-Rect"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesInOrder_Rect },
  { "slicesNoOrder-NonRect"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesNoOrder_NonRect },
  { "slicesNoOrder-Rect"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_slicesNoOrder_Rect },
  { "alternateInterVLCMode"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alternateInterVLCMode },
  { "modifiedQuantizationMode"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_modifiedQuantizationMode },
  { "reducedResolutionUpdate"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_reducedResolutionUpdate },
  { "transparencyParameters"      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_transparencyParameters },
  { "separateVideoBackChannel"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_separateVideoBackChannel },
  { "refPictureSelection"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_refPictureSelection },
  { "customPictureClockFrequency" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_customPictureClockFrequency },
  { "customPictureFormat"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_customPictureFormat },
  { "modeCombos"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_modeCombos },
  { "videoBadMBsCap"              , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_videoBadMBsCap },
  { "h263Version3Options"         , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_h263Version3Options },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263Options(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263Options, H263Options_sequence);

  return offset;
}
static int dissect_h263Options(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263Options(tvb, offset, pinfo, tree, hf_h245_h263Options);
}

static const per_sequence_t EnhancementOptions_sequence[] = {
  { "sqcifMPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sqcifMPI_1_32 },
  { "qcifMPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qcifMPI },
  { "cifMPI"                      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cifMPI },
  { "cif4MPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif4MPI_1_32 },
  { "cif16MPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif16MPI_1_32 },
  { "maxBitRate"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxBitRate },
  { "unrestrictedVector"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unrestrictedVector },
  { "arithmeticCoding"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arithmeticCoding },
  { "temporalSpatialTradeOffCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_temporalSpatialTradeOffCapability },
  { "slowSqcifMPI"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_slowSqcifMPI },
  { "slowQcifMPI"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_slowQcifMPI },
  { "slowCifMPI"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_slowCifMPI },
  { "slowCif4MPI"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_slowCif4MPI },
  { "slowCif16MPI"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_slowCif16MPI },
  { "errorCompensation"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_errorCompensation },
  { "h263Options"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_h263Options },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EnhancementOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EnhancementOptions, EnhancementOptions_sequence);

  return offset;
}
static int dissect_snrEnhancement_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EnhancementOptions(tvb, offset, pinfo, tree, hf_h245_snrEnhancement_item);
}
static int dissect_spatialEnhancement_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EnhancementOptions(tvb, offset, pinfo, tree, hf_h245_spatialEnhancement_item);
}
static int dissect_enhancementOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EnhancementOptions(tvb, offset, pinfo, tree, hf_h245_enhancementOptions);
}


static int
dissect_h245_SET_SIZE_1_14_OF_EnhancementOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_14_OF_EnhancementOptions, dissect_snrEnhancement_item,
                                          1, 14);

  return offset;
}
static int dissect_snrEnhancement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_14_OF_EnhancementOptions(tvb, offset, pinfo, tree, hf_h245_snrEnhancement);
}
static int dissect_spatialEnhancement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_14_OF_EnhancementOptions(tvb, offset, pinfo, tree, hf_h245_spatialEnhancement);
}



static int
dissect_h245_INTEGER_1_64(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 64U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_numberOfBPictures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_64(tvb, offset, pinfo, tree, hf_h245_numberOfBPictures);
}

static const per_sequence_t BEnhancementParameters_sequence[] = {
  { "enhancementOptions"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_enhancementOptions },
  { "numberOfBPictures"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfBPictures },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_BEnhancementParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_BEnhancementParameters, BEnhancementParameters_sequence);

  return offset;
}
static int dissect_bPictureEnhancement_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BEnhancementParameters(tvb, offset, pinfo, tree, hf_h245_bPictureEnhancement_item);
}


static int
dissect_h245_SET_SIZE_1_14_OF_BEnhancementParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_14_OF_BEnhancementParameters, dissect_bPictureEnhancement_item,
                                          1, 14);

  return offset;
}
static int dissect_bPictureEnhancement(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_14_OF_BEnhancementParameters(tvb, offset, pinfo, tree, hf_h245_bPictureEnhancement);
}

static const per_sequence_t EnhancementLayerInfo_sequence[] = {
  { "baseBitRateConstrained"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_baseBitRateConstrained },
  { "snrEnhancement"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_snrEnhancement },
  { "spatialEnhancement"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_spatialEnhancement },
  { "bPictureEnhancement"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_bPictureEnhancement },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EnhancementLayerInfo(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EnhancementLayerInfo, EnhancementLayerInfo_sequence);

  return offset;
}
static int dissect_enhancementLayerInfo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EnhancementLayerInfo(tvb, offset, pinfo, tree, hf_h245_enhancementLayerInfo);
}

static const per_sequence_t H263VideoCapability_sequence[] = {
  { "sqcifMPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sqcifMPI_1_32 },
  { "qcifMPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_qcifMPI },
  { "cifMPI"                      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cifMPI },
  { "cif4MPI"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif4MPI_1_32 },
  { "cif16MPI"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cif16MPI_1_32 },
  { "maxBitRate"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxBitRate },
  { "unrestrictedVector"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unrestrictedVector },
  { "arithmeticCoding"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arithmeticCoding },
  { "advancedPrediction"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_advancedPrediction },
  { "pbFrames"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pbFrames },
  { "temporalSpatialTradeOffCapability", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_temporalSpatialTradeOffCapability },
  { "hrd-B"                       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_hrd_B },
  { "bppMaxKb"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_bppMaxKb },
  { "slowSqcifMPI"                , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_slowSqcifMPI },
  { "slowQcifMPI"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_slowQcifMPI },
  { "slowCifMPI"                  , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_slowCifMPI },
  { "slowCif4MPI"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_slowCif4MPI },
  { "slowCif16MPI"                , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_slowCif16MPI },
  { "errorCompensation"           , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_errorCompensation },
  { "enhancementLayerInfo"        , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_enhancementLayerInfo },
  { "h263Options"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_h263Options },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263VideoCapability, H263VideoCapability_sequence);

  return offset;
}
static int dissect_h263VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263VideoCapability(tvb, offset, pinfo, tree, hf_h245_h263VideoCapability);
}

static const per_sequence_t IS11172VideoCapability_sequence[] = {
  { "constrainedBitstream"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_constrainedBitstream },
  { "videoBitRate"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_videoBitRate },
  { "vbvBufferSize"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vbvBufferSize },
  { "samplesPerLine"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_samplesPerLine },
  { "linesPerFrame"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_linesPerFrame },
  { "pictureRate"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_pictureRate },
  { "luminanceSampleRate"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_luminanceSampleRate },
  { "videoBadMBsCap"              , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_videoBadMBsCap },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS11172VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS11172VideoCapability, IS11172VideoCapability_sequence);

  return offset;
}
static int dissect_is11172VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS11172VideoCapability(tvb, offset, pinfo, tree, hf_h245_is11172VideoCapability);
}


static int
dissect_h245_SEQUENCE_OF_VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_VideoCapability, dissect_videoCapability_item);

  return offset;
}
static int dissect_videoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_VideoCapability(tvb, offset, pinfo, tree, hf_h245_videoCapability);
}


static int
dissect_h245_SEQUENCE_OF_GenericCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_GenericCapability, dissect_videoCapabilityExtension_item);

  return offset;
}
static int dissect_videoCapabilityExtension(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_GenericCapability(tvb, offset, pinfo, tree, hf_h245_videoCapabilityExtension);
}

static const per_sequence_t ExtendedVideoCapability_sequence[] = {
  { "videoCapability"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_videoCapability },
  { "videoCapabilityExtension"    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_videoCapabilityExtension },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_ExtendedVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_ExtendedVideoCapability, ExtendedVideoCapability_sequence);

  return offset;
}
static int dissect_extendedVideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ExtendedVideoCapability(tvb, offset, pinfo, tree, hf_h245_extendedVideoCapability);
}


static const value_string h245_VideoCapability_vals[] = {
  {   0, "nonStandard" },
  {   1, "h261VideoCapability" },
  {   2, "h262VideoCapability" },
  {   3, "h263VideoCapability" },
  {   4, "is11172VideoCapability" },
  {   5, "genericVideoCapability" },
  {   6, "extendedVideoCapability" },
  { 0, NULL }
};

static const per_choice_t VideoCapability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "h261VideoCapability"         , ASN1_EXTENSION_ROOT    , dissect_h261VideoCapability },
  {   2, "h262VideoCapability"         , ASN1_EXTENSION_ROOT    , dissect_h262VideoCapability },
  {   3, "h263VideoCapability"         , ASN1_EXTENSION_ROOT    , dissect_h263VideoCapability },
  {   4, "is11172VideoCapability"      , ASN1_EXTENSION_ROOT    , dissect_is11172VideoCapability },
  {   5, "genericVideoCapability"      , ASN1_NOT_EXTENSION_ROOT, dissect_genericVideoCapability },
  {   6, "extendedVideoCapability"     , ASN1_NOT_EXTENSION_ROOT, dissect_extendedVideoCapability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_VideoCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_VideoCapability, VideoCapability_choice, "VideoCapability",
                              &value);

        codec_type = val_to_str(value, h245_VideoCapability_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, codec_type);


  return offset;
}

static const per_sequence_t T_g7231_sequence[] = {
  { "maxAl-sduAudioFrames"        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_maxAl_sduAudioFrames },
  { "silenceSuppression"          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_silenceSuppression },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_g7231(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_g7231, T_g7231_sequence);

  return offset;
}
static int dissect_g7231(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_g7231(tvb, offset, pinfo, tree, hf_h245_g7231);
}



static int
dissect_h245_INTEGER_1_448(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 448U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_bitRate_1_448(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_448(tvb, offset, pinfo, tree, hf_h245_bitRate_1_448);
}

static const per_sequence_t IS11172AudioCapability_sequence[] = {
  { "audioLayer1"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer1 },
  { "audioLayer2"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer2 },
  { "audioLayer3"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer3 },
  { "audioSampling32k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling32k },
  { "audioSampling44k1"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling44k1 },
  { "audioSampling48k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling48k },
  { "singleChannel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_singleChannel },
  { "twoChannels"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_twoChannels },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate_1_448 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS11172AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS11172AudioCapability, IS11172AudioCapability_sequence);

  return offset;
}
static int dissect_is11172AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS11172AudioCapability(tvb, offset, pinfo, tree, hf_h245_is11172AudioCapability);
}



static int
dissect_h245_INTEGER_1_1130(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 1130U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_bitRate2_1_1130(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_1130(tvb, offset, pinfo, tree, hf_h245_bitRate2_1_1130);
}

static const per_sequence_t IS13818AudioCapability_sequence[] = {
  { "audioLayer1"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer1 },
  { "audioLayer2"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer2 },
  { "audioLayer3"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer3 },
  { "audioSampling16k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling16k },
  { "audioSampling22k05"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling22k05 },
  { "audioSampling24k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling24k },
  { "audioSampling32k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling32k },
  { "audioSampling44k1"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling44k1 },
  { "audioSampling48k"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling48k },
  { "singleChannel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_singleChannel },
  { "twoChannels"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_twoChannels },
  { "threeChannels2-1"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_threeChannels2_1 },
  { "threeChannels3-0"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_threeChannels3_0 },
  { "fourChannels2-0-2-0"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fourChannels2_0_2_0 },
  { "fourChannels2-2"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fourChannels2_2 },
  { "fourChannels3-1"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fourChannels3_1 },
  { "fiveChannels3-0-2-0"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fiveChannels3_0_2_0 },
  { "fiveChannels3-2"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fiveChannels3_2 },
  { "lowFrequencyEnhancement"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lowFrequencyEnhancement },
  { "multilingual"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multilingual },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate2_1_1130 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS13818AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS13818AudioCapability, IS13818AudioCapability_sequence);

  return offset;
}
static int dissect_is13818AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS13818AudioCapability(tvb, offset, pinfo, tree, hf_h245_is13818AudioCapability);
}



static int
dissect_h245_INTEGER_27_78(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           27U, 78U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_highRateMode0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_27_78(tvb, offset, pinfo, tree, hf_h245_highRateMode0);
}
static int dissect_highRateMode1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_27_78(tvb, offset, pinfo, tree, hf_h245_highRateMode1);
}



static int
dissect_h245_INTEGER_23_66(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           23U, 66U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_lowRateMode0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_23_66(tvb, offset, pinfo, tree, hf_h245_lowRateMode0);
}
static int dissect_lowRateMode1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_23_66(tvb, offset, pinfo, tree, hf_h245_lowRateMode1);
}



static int
dissect_h245_INTEGER_6_17(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           6U, 17U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_sidMode0(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_6_17(tvb, offset, pinfo, tree, hf_h245_sidMode0);
}
static int dissect_sidMode1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_6_17(tvb, offset, pinfo, tree, hf_h245_sidMode1);
}

static const per_sequence_t G723AnnexCAudioMode_sequence[] = {
  { "highRateMode0"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_highRateMode0 },
  { "highRateMode1"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_highRateMode1 },
  { "lowRateMode0"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lowRateMode0 },
  { "lowRateMode1"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lowRateMode1 },
  { "sidMode0"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sidMode0 },
  { "sidMode1"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sidMode1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_G723AnnexCAudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_G723AnnexCAudioMode, G723AnnexCAudioMode_sequence);

  return offset;
}
static int dissect_g723AnnexCAudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_G723AnnexCAudioMode(tvb, offset, pinfo, tree, hf_h245_g723AnnexCAudioMode);
}

static const per_sequence_t G7231AnnexCCapability_sequence[] = {
  { "maxAl-sduAudioFrames"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxAl_sduAudioFrames },
  { "silenceSuppression"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_silenceSuppression },
  { "g723AnnexCAudioMode"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_g723AnnexCAudioMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_G7231AnnexCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_G7231AnnexCCapability, G7231AnnexCCapability_sequence);

  return offset;
}
static int dissect_g7231AnnexCCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_G7231AnnexCCapability(tvb, offset, pinfo, tree, hf_h245_g7231AnnexCCapability);
}

static const per_sequence_t GSMAudioCapability_sequence[] = {
  { "audioUnitSize"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioUnitSize },
  { "comfortNoise"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_comfortNoise },
  { "scrambled"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scrambled },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_GSMAudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_GSMAudioCapability, GSMAudioCapability_sequence);

  return offset;
}
static int dissect_gsmFullRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GSMAudioCapability(tvb, offset, pinfo, tree, hf_h245_gsmFullRate);
}
static int dissect_gsmHalfRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GSMAudioCapability(tvb, offset, pinfo, tree, hf_h245_gsmHalfRate);
}
static int dissect_gsmEnhancedFullRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GSMAudioCapability(tvb, offset, pinfo, tree, hf_h245_gsmEnhancedFullRate);
}

static const per_sequence_t G729Extensions_sequence[] = {
  { "audioUnit"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_audioUnit },
  { "annexA"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexA },
  { "annexB"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexB },
  { "annexD"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexD },
  { "annexE"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexE },
  { "annexF"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexF },
  { "annexG"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexG },
  { "annexH"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_annexH },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_G729Extensions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_G729Extensions, G729Extensions_sequence);

  return offset;
}
static int dissect_g729Extensions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_G729Extensions(tvb, offset, pinfo, tree, hf_h245_g729Extensions);
}

static const per_sequence_t VBDCapability_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_vbd_cap_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_VBDCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_VBDCapability, VBDCapability_sequence);

  return offset;
}
static int dissect_vbd(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VBDCapability(tvb, offset, pinfo, tree, hf_h245_vbd);
}


static int
dissect_h245_GeneralString(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_GeneralString(tvb, offset, pinfo, tree, hf_index);

  return offset;
}
static int dissect_audioTelephoneEvent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GeneralString(tvb, offset, pinfo, tree, hf_h245_audioTelephoneEvent);
}
static int dissect_alphanumeric(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GeneralString(tvb, offset, pinfo, tree, hf_h245_alphanumeric);
}

static const per_sequence_t NoPTAudioTelephonyEventCapability_sequence[] = {
  { "audioTelephoneEvent"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioTelephoneEvent },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NoPTAudioTelephonyEventCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NoPTAudioTelephonyEventCapability, NoPTAudioTelephonyEventCapability_sequence);

  return offset;
}
static int dissect_audioTelephonyEvent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NoPTAudioTelephonyEventCapability(tvb, offset, pinfo, tree, hf_h245_audioTelephonyEvent);
}

static const per_sequence_t NoPTAudioToneCapability_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NoPTAudioToneCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NoPTAudioToneCapability, NoPTAudioToneCapability_sequence);

  return offset;
}
static int dissect_audioTone(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NoPTAudioToneCapability(tvb, offset, pinfo, tree, hf_h245_audioTone);
}


static const value_string h245_AudioCapability_vals[] = {
  {   0, "nonStandard" },
  {   1, "g711Alaw64k" },
  {   2, "g711Alaw56k" },
  {   3, "g711Ulaw64k" },
  {   4, "g711Ulaw56k" },
  {   5, "g722-64k" },
  {   6, "g722-56k" },
  {   7, "g722-48k" },
  {   8, "g7231" },
  {   9, "g728" },
  {  10, "g729" },
  {  11, "g729AnnexA" },
  {  12, "is11172AudioCapability" },
  {  13, "is13818AudioCapability" },
  {  14, "g729wAnnexB" },
  {  15, "g729AnnexAwAnnexB" },
  {  16, "g7231AnnexCCapability" },
  {  17, "gsmFullRate" },
  {  18, "gsmHalfRate" },
  {  19, "gsmEnhancedFullRate" },
  {  20, "genericAudioCapability" },
  {  21, "g729Extensions" },
  {  22, "vbd" },
  {  23, "audioTelephonyEvent" },
  {  24, "audioTone" },
  { 0, NULL }
};

static const per_choice_t AudioCapability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "g711Alaw64k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Alaw64k },
  {   2, "g711Alaw56k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Alaw56k },
  {   3, "g711Ulaw64k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Ulaw64k },
  {   4, "g711Ulaw56k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Ulaw56k },
  {   5, "g722-64k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_64k },
  {   6, "g722-56k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_56k },
  {   7, "g722-48k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_48k },
  {   8, "g7231"                       , ASN1_EXTENSION_ROOT    , dissect_g7231 },
  {   9, "g728"                        , ASN1_EXTENSION_ROOT    , dissect_g728 },
  {  10, "g729"                        , ASN1_EXTENSION_ROOT    , dissect_g729 },
  {  11, "g729AnnexA"                  , ASN1_EXTENSION_ROOT    , dissect_g729AnnexA },
  {  12, "is11172AudioCapability"      , ASN1_EXTENSION_ROOT    , dissect_is11172AudioCapability },
  {  13, "is13818AudioCapability"      , ASN1_EXTENSION_ROOT    , dissect_is13818AudioCapability },
  {  14, "g729wAnnexB"                 , ASN1_NOT_EXTENSION_ROOT, dissect_g729wAnnexB },
  {  15, "g729AnnexAwAnnexB"           , ASN1_NOT_EXTENSION_ROOT, dissect_g729AnnexAwAnnexB },
  {  16, "g7231AnnexCCapability"       , ASN1_NOT_EXTENSION_ROOT, dissect_g7231AnnexCCapability },
  {  17, "gsmFullRate"                 , ASN1_NOT_EXTENSION_ROOT, dissect_gsmFullRate },
  {  18, "gsmHalfRate"                 , ASN1_NOT_EXTENSION_ROOT, dissect_gsmHalfRate },
  {  19, "gsmEnhancedFullRate"         , ASN1_NOT_EXTENSION_ROOT, dissect_gsmEnhancedFullRate },
  {  20, "genericAudioCapability"      , ASN1_NOT_EXTENSION_ROOT, dissect_genericAudioCapability },
  {  21, "g729Extensions"              , ASN1_NOT_EXTENSION_ROOT, dissect_g729Extensions },
  {  22, "vbd"                         , ASN1_NOT_EXTENSION_ROOT, dissect_vbd },
  {  23, "audioTelephonyEvent"         , ASN1_NOT_EXTENSION_ROOT, dissect_audioTelephonyEvent },
  {  24, "audioTone"                   , ASN1_NOT_EXTENSION_ROOT, dissect_audioTone },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AudioCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AudioCapability, AudioCapability_choice, "AudioCapability",
                              &value);

        codec_type = val_to_str(value, h245_AudioCapability_short_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, val_to_str(value, h245_AudioCapability_short_vals, "ukn"));


  return offset;
}

static const per_sequence_t T_h233EncryptionReceiveCapability_sequence[] = {
  { "h233IVResponseTime"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h233IVResponseTime },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_h233EncryptionReceiveCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_h233EncryptionReceiveCapability, T_h233EncryptionReceiveCapability_sequence);

  return offset;
}
static int dissect_h233EncryptionReceiveCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_h233EncryptionReceiveCapability(tvb, offset, pinfo, tree, hf_h245_h233EncryptionReceiveCapability);
}


static int
dissect_h245_SEQUENCE_OF_NonStandardParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_NonStandardParameter, dissect_nonStandardData_item);

  return offset;
}
static int dissect_nonStandardParams(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_nonStandardParams);
}

static const per_sequence_t ConferenceCapability_sequence[] = {
  { "nonStandardData"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandardParams },
  { "chairControlCapability"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_chairControlCapability },
  { "videoIndicateMixingCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_videoIndicateMixingCapability },
  { "multipointVisualizationCapability", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_multipointVisualizationCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_ConferenceCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_ConferenceCapability, ConferenceCapability_sequence);

  return offset;
}
static int dissect_conferenceCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceCapability(tvb, offset, pinfo, tree, hf_h245_conferenceCapability);
}


static const value_string h245_MediaEncryptionAlgorithm_vals[] = {
  {   0, "nonStandard" },
  {   1, "algorithm" },
  { 0, NULL }
};

static const per_choice_t MediaEncryptionAlgorithm_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "algorithm"                   , ASN1_EXTENSION_ROOT    , dissect_algorithm },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MediaEncryptionAlgorithm(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MediaEncryptionAlgorithm, MediaEncryptionAlgorithm_choice, "MediaEncryptionAlgorithm",
                              NULL);

  return offset;
}
static int dissect_EncryptionCapability_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MediaEncryptionAlgorithm(tvb, offset, pinfo, tree, hf_h245_EncryptionCapability_item);
}


static int
dissect_h245_EncryptionCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_EncryptionCapability, dissect_EncryptionCapability_item,
                                               1, 256);

  return offset;
}
static int dissect_encryptionCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionCapability(tvb, offset, pinfo, tree, hf_h245_encryptionCapability);
}

static const per_sequence_t AuthenticationCapability_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandard },
  { "antiSpamAlgorithm"           , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_antiSpamAlgorithm },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_AuthenticationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_AuthenticationCapability, AuthenticationCapability_sequence);

  return offset;
}
static int dissect_authenticationCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AuthenticationCapability(tvb, offset, pinfo, tree, hf_h245_authenticationCapability);
}

static const per_sequence_t IntegrityCapability_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandard },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IntegrityCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IntegrityCapability, IntegrityCapability_sequence);

  return offset;
}
static int dissect_integrityCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IntegrityCapability(tvb, offset, pinfo, tree, hf_h245_integrityCapability);
}

static const per_sequence_t EncryptionAuthenticationAndIntegrity_sequence[] = {
  { "encryptionCapability"        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_encryptionCapability },
  { "authenticationCapability"    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_authenticationCapability },
  { "integrityCapability"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_integrityCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EncryptionAuthenticationAndIntegrity(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EncryptionAuthenticationAndIntegrity, EncryptionAuthenticationAndIntegrity_sequence);

  return offset;
}
static int dissect_encryptionAuthenticationAndIntegrity(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionAuthenticationAndIntegrity(tvb, offset, pinfo, tree, hf_h245_encryptionAuthenticationAndIntegrity);
}

static const per_sequence_t H235SecurityCapability_sequence[] = {
  { "encryptionAuthenticationAndIntegrity", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_encryptionAuthenticationAndIntegrity },
  { "mediaCapability"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mediaCapability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H235SecurityCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H235SecurityCapability, H235SecurityCapability_sequence);

  return offset;
}
static int dissect_h235SecurityCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H235SecurityCapability(tvb, offset, pinfo, tree, hf_h245_h235SecurityCapability);
}


static int
dissect_h245_SEQUENCE_SIZE_1_16_OF_NonStandardParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_16_OF_NonStandardParameter, dissect_nonStandard_item,
                                               1, 16);

  return offset;
}
static int dissect_ui_nonStandard(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_16_OF_NonStandardParameter(tvb, offset, pinfo, tree, hf_h245_ui_nonStandard);
}


static const value_string h245_UserInputCapability_vals[] = {
  {   0, "nonStandard" },
  {   1, "basicString" },
  {   2, "iA5String" },
  {   3, "generalString" },
  {   4, "dtmf" },
  {   5, "hookflash" },
  {   6, "extendedAlphanumeric" },
  {   7, "encryptedBasicString" },
  {   8, "encryptedIA5String" },
  {   9, "encryptedGeneralString" },
  {  10, "secureDTMF" },
  { 0, NULL }
};

static const per_choice_t UserInputCapability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_ui_nonStandard },
  {   1, "basicString"                 , ASN1_EXTENSION_ROOT    , dissect_basicString },
  {   2, "iA5String"                   , ASN1_EXTENSION_ROOT    , dissect_iA5String },
  {   3, "generalString"               , ASN1_EXTENSION_ROOT    , dissect_generalString },
  {   4, "dtmf"                        , ASN1_EXTENSION_ROOT    , dissect_dtmf },
  {   5, "hookflash"                   , ASN1_EXTENSION_ROOT    , dissect_hookflash },
  {   6, "extendedAlphanumeric"        , ASN1_NOT_EXTENSION_ROOT, dissect_extendedAlphanumericFlag },
  {   7, "encryptedBasicString"        , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedBasicString },
  {   8, "encryptedIA5String"          , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedIA5String },
  {   9, "encryptedGeneralString"      , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedGeneralString },
  {  10, "secureDTMF"                  , ASN1_NOT_EXTENSION_ROOT, dissect_secureDTMF },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_UserInputCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_UserInputCapability, UserInputCapability_choice, "UserInputCapability",
                              NULL);

  return offset;
}
static int dissect_receiveUserInputCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_UserInputCapability(tvb, offset, pinfo, tree, hf_h245_receiveUserInputCapability);
}
static int dissect_transmitUserInputCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_UserInputCapability(tvb, offset, pinfo, tree, hf_h245_transmitUserInputCapability);
}
static int dissect_receiveAndTransmitUserInputCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_UserInputCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitUserInputCapability);
}


static const value_string h245_MultiplexFormat_vals[] = {
  {   0, "nonStandard" },
  {   1, "h222Capability" },
  {   2, "h223Capability" },
  { 0, NULL }
};

static const per_choice_t MultiplexFormat_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "h222Capability"              , ASN1_EXTENSION_ROOT    , dissect_h222Capability },
  {   2, "h223Capability"              , ASN1_EXTENSION_ROOT    , dissect_h223Capability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultiplexFormat(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultiplexFormat, MultiplexFormat_choice, "MultiplexFormat",
                              NULL);

  return offset;
}
static int dissect_multiplexFormat(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexFormat(tvb, offset, pinfo, tree, hf_h245_multiplexFormat);
}


static int
dissect_h245_AlternativeCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_AlternativeCapabilitySet, dissect_AlternativeCapabilitySet_item,
                                               1, 256);

  return offset;
}
static int dissect_simultaneousCapabilities_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_simultaneousCapabilities_item);
}
static int dissect_capabilityOnMuxStream_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_capabilityOnMuxStream_item);
}
static int dissect_capabilities_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_capabilities_item);
}


static int
dissect_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet, dissect_simultaneousCapabilities_item,
                                          1, 256);

  return offset;
}
static int dissect_simultaneousCapabilities(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_simultaneousCapabilities);
}
static int dissect_capabilityOnMuxStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_capabilityOnMuxStream);
}
static int dissect_capabilities(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_AlternativeCapabilitySet(tvb, offset, pinfo, tree, hf_h245_capabilities);
}

static const per_sequence_t MultiplexedStreamCapability_sequence[] = {
  { "multiplexFormat"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexFormat },
  { "controlOnMuxStream"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_controlOnMuxStream },
  { "capabilityOnMuxStream"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_capabilityOnMuxStream },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexedStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexedStreamCapability, MultiplexedStreamCapability_sequence);

  return offset;
}
static int dissect_receiveMultiplexedStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamCapability(tvb, offset, pinfo, tree, hf_h245_receiveMultiplexedStreamCapability);
}
static int dissect_transmitMultiplexedStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamCapability(tvb, offset, pinfo, tree, hf_h245_transmitMultiplexedStreamCapability);
}
static int dissect_receiveAndTransmitMultiplexedStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamCapability(tvb, offset, pinfo, tree, hf_h245_receiveAndTransmitMultiplexedStreamCapability);
}



static int
dissect_h245_INTEGER_96_127(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           96U, 127U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_dynamicRTPPayloadType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_96_127(tvb, offset, pinfo, tree, hf_h245_dynamicRTPPayloadType);
}

static const per_sequence_t AudioTelephonyEventCapability_sequence[] = {
  { "dynamicRTPPayloadType"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicRTPPayloadType },
  { "audioTelephoneEvent"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioTelephoneEvent },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_AudioTelephonyEventCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_AudioTelephonyEventCapability, AudioTelephonyEventCapability_sequence);

  return offset;
}
static int dissect_receiveRTPAudioTelephonyEventCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioTelephonyEventCapability(tvb, offset, pinfo, tree, hf_h245_receiveRTPAudioTelephonyEventCapability);
}

static const per_sequence_t AudioToneCapability_sequence[] = {
  { "dynamicRTPPayloadType"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dynamicRTPPayloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_AudioToneCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_AudioToneCapability, AudioToneCapability_sequence);

  return offset;
}
static int dissect_receiveRTPAudioToneCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AudioToneCapability(tvb, offset, pinfo, tree, hf_h245_receiveRTPAudioToneCapability);
}

static const per_sequence_t T_separateStream_sequence[] = {
  { "separatePort"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_separatePort },
  { "samePort"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_samePortBool },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_separateStream(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_separateStream, T_separateStream_sequence);

  return offset;
}
static int dissect_separateStreamBool(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_separateStream(tvb, offset, pinfo, tree, hf_h245_separateStreamBool);
}

static const per_sequence_t FECC_rfc2733_sequence[] = {
  { "redundancyEncoding"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_redundancyEncodingBool },
  { "separateStream"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_separateStreamBool },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_FECC_rfc2733(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_FECC_rfc2733, FECC_rfc2733_sequence);

  return offset;
}
static int dissect_fecc_rfc2733(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FECC_rfc2733(tvb, offset, pinfo, tree, hf_h245_fecc_rfc2733);
}


static const value_string h245_FECCapability_vals[] = {
  {   0, "rfc2733" },
  { 0, NULL }
};

static const per_choice_t FECCapability_choice[] = {
  {   0, "rfc2733"                     , ASN1_EXTENSION_ROOT    , dissect_fecc_rfc2733 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FECCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FECCapability, FECCapability_choice, "FECCapability",
                              NULL);

  return offset;
}
static int dissect_fecCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FECCapability(tvb, offset, pinfo, tree, hf_h245_fecCapability);
}

static const per_sequence_t MultiplePayloadStreamCapability_sequence[] = {
  { "capabilities"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_capabilities },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplePayloadStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplePayloadStreamCapability, MultiplePayloadStreamCapability_sequence);

  return offset;
}
static int dissect_multiplePayloadStreamCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplePayloadStreamCapability(tvb, offset, pinfo, tree, hf_h245_multiplePayloadStreamCapability);
}


static const value_string h245_Capability_vals[] = {
  {   0, "nonStandard" },
  {   1, "receiveVideoCapability" },
  {   2, "transmitVideoCapability" },
  {   3, "receiveAndTransmitVideoCapability" },
  {   4, "receiveAudioCapability" },
  {   5, "transmitAudioCapability" },
  {   6, "receiveAndTransmitAudioCapability" },
  {   7, "receiveDataApplicationCapability" },
  {   8, "transmitDataApplicationCapability" },
  {   9, "receiveAndTransmitDataApplicationCapability" },
  {  10, "h233EncryptionTransmitCapability" },
  {  11, "h233EncryptionReceiveCapability" },
  {  12, "conferenceCapability" },
  {  13, "h235SecurityCapability" },
  {  14, "maxPendingReplacementFor" },
  {  15, "receiveUserInputCapability" },
  {  16, "transmitUserInputCapability" },
  {  17, "receiveAndTransmitUserInputCapability" },
  {  18, "genericControlCapability" },
  {  19, "receiveMultiplexedStreamCapability" },
  {  20, "transmitMultiplexedStreamCapability" },
  {  21, "receiveAndTransmitMultiplexedStreamCapability" },
  {  22, "receiveRTPAudioTelephonyEventCapability" },
  {  23, "receiveRTPAudioToneCapability" },
  {  24, "fecCapability" },
  {  25, "multiplePayloadStreamCapability" },
  { 0, NULL }
};

static const per_choice_t Capability_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "receiveVideoCapability"      , ASN1_EXTENSION_ROOT    , dissect_receiveVideoCapability },
  {   2, "transmitVideoCapability"     , ASN1_EXTENSION_ROOT    , dissect_transmitVideoCapability },
  {   3, "receiveAndTransmitVideoCapability", ASN1_EXTENSION_ROOT    , dissect_receiveAndTransmitVideoCapability },
  {   4, "receiveAudioCapability"      , ASN1_EXTENSION_ROOT    , dissect_receiveAudioCapability },
  {   5, "transmitAudioCapability"     , ASN1_EXTENSION_ROOT    , dissect_transmitAudioCapability },
  {   6, "receiveAndTransmitAudioCapability", ASN1_EXTENSION_ROOT    , dissect_receiveAndTransmitAudioCapability },
  {   7, "receiveDataApplicationCapability", ASN1_EXTENSION_ROOT    , dissect_receiveDataApplicationCapability },
  {   8, "transmitDataApplicationCapability", ASN1_EXTENSION_ROOT    , dissect_transmitDataApplicationCapability },
  {   9, "receiveAndTransmitDataApplicationCapability", ASN1_EXTENSION_ROOT    , dissect_receiveAndTransmitDataApplicationCapability },
  {  10, "h233EncryptionTransmitCapability", ASN1_EXTENSION_ROOT    , dissect_h233EncryptionTransmitCapability },
  {  11, "h233EncryptionReceiveCapability", ASN1_EXTENSION_ROOT    , dissect_h233EncryptionReceiveCapability },
  {  12, "conferenceCapability"        , ASN1_NOT_EXTENSION_ROOT, dissect_conferenceCapability },
  {  13, "h235SecurityCapability"      , ASN1_NOT_EXTENSION_ROOT, dissect_h235SecurityCapability },
  {  14, "maxPendingReplacementFor"    , ASN1_NOT_EXTENSION_ROOT, dissect_maxPendingReplacementFor },
  {  15, "receiveUserInputCapability"  , ASN1_NOT_EXTENSION_ROOT, dissect_receiveUserInputCapability },
  {  16, "transmitUserInputCapability" , ASN1_NOT_EXTENSION_ROOT, dissect_transmitUserInputCapability },
  {  17, "receiveAndTransmitUserInputCapability", ASN1_NOT_EXTENSION_ROOT, dissect_receiveAndTransmitUserInputCapability },
  {  18, "genericControlCapability"    , ASN1_NOT_EXTENSION_ROOT, dissect_genericControlCapability },
  {  19, "receiveMultiplexedStreamCapability", ASN1_NOT_EXTENSION_ROOT, dissect_receiveMultiplexedStreamCapability },
  {  20, "transmitMultiplexedStreamCapability", ASN1_NOT_EXTENSION_ROOT, dissect_transmitMultiplexedStreamCapability },
  {  21, "receiveAndTransmitMultiplexedStreamCapability", ASN1_NOT_EXTENSION_ROOT, dissect_receiveAndTransmitMultiplexedStreamCapability },
  {  22, "receiveRTPAudioTelephonyEventCapability", ASN1_NOT_EXTENSION_ROOT, dissect_receiveRTPAudioTelephonyEventCapability },
  {  23, "receiveRTPAudioToneCapability", ASN1_NOT_EXTENSION_ROOT, dissect_receiveRTPAudioToneCapability },
  {  24, "fecCapability"               , ASN1_NOT_EXTENSION_ROOT, dissect_fecCapability },
  {  25, "multiplePayloadStreamCapability", ASN1_NOT_EXTENSION_ROOT, dissect_multiplePayloadStreamCapability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Capability(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Capability, Capability_choice, "Capability",
                              NULL);

  return offset;
}
static int dissect_capability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Capability(tvb, offset, pinfo, tree, hf_h245_capability);
}

static const per_sequence_t CapabilityTableEntry_sequence[] = {
  { "capabilityTableEntryNumber"  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_capabilityTableEntryNumber },
  { "capability"                  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_capability },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CapabilityTableEntry(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CapabilityTableEntry, CapabilityTableEntry_sequence);

  return offset;
}
static int dissect_capabilityTable_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityTableEntry(tvb, offset, pinfo, tree, hf_h245_capabilityTable_item);
}


static int
dissect_h245_SET_SIZE_1_256_OF_CapabilityTableEntry(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_CapabilityTableEntry, dissect_capabilityTable_item,
                                          1, 256);

  return offset;
}
static int dissect_capabilityTable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_CapabilityTableEntry(tvb, offset, pinfo, tree, hf_h245_capabilityTable);
}



static int
dissect_h245_CapabilityDescriptorNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 255U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_capabilityDescriptorNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityDescriptorNumber(tvb, offset, pinfo, tree, hf_h245_capabilityDescriptorNumber);
}
static int dissect_capabilityDescriptorNumbers_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityDescriptorNumber(tvb, offset, pinfo, tree, hf_h245_capabilityDescriptorNumbers_item);
}

static const per_sequence_t CapabilityDescriptor_sequence[] = {
  { "capabilityDescriptorNumber"  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_capabilityDescriptorNumber },
  { "simultaneousCapabilities"    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_simultaneousCapabilities },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CapabilityDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CapabilityDescriptor, CapabilityDescriptor_sequence);

  return offset;
}
static int dissect_capabilityDescriptors_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CapabilityDescriptor(tvb, offset, pinfo, tree, hf_h245_capabilityDescriptors_item);
}


static int
dissect_h245_SET_SIZE_1_256_OF_CapabilityDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_CapabilityDescriptor, dissect_capabilityDescriptors_item,
                                          1, 256);

  return offset;
}
static int dissect_capabilityDescriptors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_CapabilityDescriptor(tvb, offset, pinfo, tree, hf_h245_capabilityDescriptors);
}

static const per_sequence_t TerminalCapabilitySet_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "protocolIdentifier"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_protocolIdentifier },
  { "multiplexCapability"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_multiplexCapability },
  { "capabilityTable"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_capabilityTable },
  { "capabilityDescriptors"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_capabilityDescriptors },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalCapabilitySet, TerminalCapabilitySet_sequence);


  h245_pi->msg_type = H245_TermCapSet;
  return offset;
}
static int dissect_terminalCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalCapabilitySet(tvb, offset, pinfo, tree, hf_h245_terminalCapabilitySet);
}



static int
dissect_h245_LogicalChannelNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 65535U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_forwardLogicalChannelNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_forwardLogicalChannelNumber);
}
static int dissect_forwardLogicalChannelDependency(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_forwardLogicalChannelDependency);
}
static int dissect_replacementFor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_replacementFor);
}
static int dissect_reverseLogicalChannelDependency(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_reverseLogicalChannelDependency);
}
static int dissect_reverseLogicalChannelNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_reverseLogicalChannelNumber);
}
static int dissect_logicalChannelNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_logicalChannelNumber);
}
static int dissect_mediaLoop(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_mediaLoop);
}
static int dissect_logicalChannelLoop(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_logicalChannelLoop);
}
static int dissect_broadcastMyLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_broadcastMyLogicalChannel);
}
static int dissect_cancelBroadcastMyLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_cancelBroadcastMyLogicalChannel);
}
static int dissect_logicalChannelNumber1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_logicalChannelNumber1);
}
static int dissect_logicalChannelNumber2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelNumber(tvb, offset, pinfo, tree, hf_h245_logicalChannelNumber2);
}


static const value_string h245_EncryptionMode_vals[] = {
  {   0, "nonStandard" },
  {   1, "h233Encryption" },
  { 0, NULL }
};

static const per_choice_t EncryptionMode_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "h233Encryption"              , ASN1_EXTENSION_ROOT    , dissect_h233Encryption },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_EncryptionMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_EncryptionMode, EncryptionMode_choice, "EncryptionMode",
                              NULL);

  return offset;
}
static int dissect_encryptionData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionMode(tvb, offset, pinfo, tree, hf_h245_encryptionData);
}
static int dissect_encryptionMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionMode(tvb, offset, pinfo, tree, hf_h245_encryptionMode);
}

static const per_sequence_t RedundancyEncodingElement_sequence[] = {
  { "dataType"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataType },
  { "payloadType"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_payloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncodingElement, RedundancyEncodingElement_sequence);

  return offset;
}
static int dissect_primary(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingElement(tvb, offset, pinfo, tree, hf_h245_primary);
}
static int dissect_secondary_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingElement(tvb, offset, pinfo, tree, hf_h245_secondary_item);
}


static int
dissect_h245_SEQUENCE_OF_RedundancyEncodingElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_RedundancyEncodingElement, dissect_secondary_item);

  return offset;
}
static int dissect_secondary(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_RedundancyEncodingElement(tvb, offset, pinfo, tree, hf_h245_secondary);
}

static const per_sequence_t T_rtpRedundancyEncoding_sequence[] = {
  { "primary"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_primary },
  { "secondary"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_secondary },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_rtpRedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_rtpRedundancyEncoding, T_rtpRedundancyEncoding_sequence);

  return offset;
}
static int dissect_rtpRedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_rtpRedundancyEncoding(tvb, offset, pinfo, tree, hf_h245_rtpRedundancyEncoding);
}

static const per_sequence_t RedundancyEncoding_sequence[] = {
  { "redundancyEncodingMethod"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_redundancyEncodingMethod },
  { "secondaryEncoding3"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_secondaryEncoding3 },
  { "rtpRedundancyEncoding"       , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rtpRedundancyEncoding },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncoding, RedundancyEncoding_sequence);

  return offset;
}
static int dissect_redundancyEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncoding(tvb, offset, pinfo, tree, hf_h245_redundancyEncoding);
}

static const per_sequence_t MultiplePayloadStreamElement_sequence[] = {
  { "dataType"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataType },
  { "payloadType"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_payloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplePayloadStreamElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplePayloadStreamElement, MultiplePayloadStreamElement_sequence);

  return offset;
}
static int dissect_elements_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplePayloadStreamElement(tvb, offset, pinfo, tree, hf_h245_elements_item);
}


static int
dissect_h245_SEQUENCE_OF_MultiplePayloadStreamElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_MultiplePayloadStreamElement, dissect_elements_item);

  return offset;
}
static int dissect_elements(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_MultiplePayloadStreamElement(tvb, offset, pinfo, tree, hf_h245_elements);
}

static const per_sequence_t MultiplePayloadStream_sequence[] = {
  { "elements"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_elements },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplePayloadStream(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplePayloadStream, MultiplePayloadStream_sequence);

  return offset;
}
static int dissect_multiplePayloadStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplePayloadStream(tvb, offset, pinfo, tree, hf_h245_multiplePayloadStream);
}

static const per_sequence_t T_differentPort_sequence[] = {
  { "protectedSessionID"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_protectedSessionID },
  { "protectedPayloadType"        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_protectedPayloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_differentPort(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_differentPort, T_differentPort_sequence);

  return offset;
}
static int dissect_differentPort(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_differentPort(tvb, offset, pinfo, tree, hf_h245_differentPort);
}

static const per_sequence_t T_samePort_sequence[] = {
  { "protectedPayloadType"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_protectedPayloadType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_samePort(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_samePort, T_samePort_sequence);

  return offset;
}
static int dissect_samePort(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_samePort(tvb, offset, pinfo, tree, hf_h245_samePort);
}


static const value_string h245_SeparateStream_vals[] = {
  {   0, "differentPort" },
  {   1, "samePort" },
  { 0, NULL }
};

static const per_choice_t SeparateStream_choice[] = {
  {   0, "differentPort"               , ASN1_EXTENSION_ROOT    , dissect_differentPort },
  {   1, "samePort"                    , ASN1_EXTENSION_ROOT    , dissect_samePort },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_SeparateStream(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_SeparateStream, SeparateStream_choice, "SeparateStream",
                              NULL);

  return offset;
}
static int dissect_separateStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SeparateStream(tvb, offset, pinfo, tree, hf_h245_separateStream);
}


static const value_string h245_FECdata_mode_vals[] = {
  {   0, "redundancyEncoding" },
  {   1, "separateStream" },
  { 0, NULL }
};

static const per_choice_t FECdata_mode_choice[] = {
  {   0, "redundancyEncoding"          , ASN1_EXTENSION_ROOT    , dissect_redundancyEncodingFlag },
  {   1, "separateStream"              , ASN1_EXTENSION_ROOT    , dissect_separateStream },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FECdata_mode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FECdata_mode, FECdata_mode_choice, "FECdata_mode",
                              NULL);

  return offset;
}
static int dissect_fec_data_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FECdata_mode(tvb, offset, pinfo, tree, hf_h245_fec_data_mode);
}

static const per_sequence_t RFC2733Data_sequence[] = {
  { "mode"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fec_data_mode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RFC2733Data(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RFC2733Data, RFC2733Data_sequence);

  return offset;
}
static int dissect_rfc2733(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RFC2733Data(tvb, offset, pinfo, tree, hf_h245_rfc2733);
}


static const value_string h245_FECData_vals[] = {
  {   0, "rfc2733" },
  { 0, NULL }
};

static const per_choice_t FECData_choice[] = {
  {   0, "rfc2733"                     , ASN1_NO_EXTENSIONS     , dissect_rfc2733 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FECData(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FECData, FECData_choice, "FECData",
                              NULL);

  return offset;
}
static int dissect_fec(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FECData(tvb, offset, pinfo, tree, hf_h245_fec);
}


static const value_string h245_T_mediaType_vals[] = {
  {   0, "nonStandard" },
  {   1, "videoData" },
  {   2, "audioData" },
  {   3, "data" },
  {   4, "redundancyEncoding" },
  {   5, "multiplePayloadStream" },
  {   6, "fec" },
  { 0, NULL }
};

static const per_choice_t T_mediaType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "videoData"                   , ASN1_EXTENSION_ROOT    , dissect_videoData },
  {   2, "audioData"                   , ASN1_EXTENSION_ROOT    , dissect_audioData },
  {   3, "data"                        , ASN1_EXTENSION_ROOT    , dissect_data },
  {   4, "redundancyEncoding"          , ASN1_NOT_EXTENSION_ROOT, dissect_redundancyEncoding },
  {   5, "multiplePayloadStream"       , ASN1_NOT_EXTENSION_ROOT, dissect_multiplePayloadStream },
  {   6, "fec"                         , ASN1_NOT_EXTENSION_ROOT, dissect_fec },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_mediaType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_mediaType, T_mediaType_choice, "T_mediaType",
                              NULL);

  return offset;
}
static int dissect_mediaType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mediaType(tvb, offset, pinfo, tree, hf_h245_mediaType);
}

static const per_sequence_t H235Media_sequence[] = {
  { "encryptionAuthenticationAndIntegrity", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_encryptionAuthenticationAndIntegrity },
  { "mediaType"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mediaType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H235Media(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H235Media, H235Media_sequence);

  return offset;
}
static int dissect_h235Media(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H235Media(tvb, offset, pinfo, tree, hf_h245_h235Media);
}

static const per_sequence_t MultiplexedStreamParameter_sequence[] = {
  { "multiplexFormat"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexFormat },
  { "controlOnMuxStream"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_controlOnMuxStream },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexedStreamParameter(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexedStreamParameter, MultiplexedStreamParameter_sequence);

  return offset;
}
static int dissect_multiplexedStream(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamParameter(tvb, offset, pinfo, tree, hf_h245_multiplexedStream);
}
static int dissect_multiplexedStreamMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamParameter(tvb, offset, pinfo, tree, hf_h245_multiplexedStreamMode);
}


static const value_string h245_DataType_vals[] = {
  {   0, "nonStandard" },
  {   1, "nullData" },
  {   2, "videoData" },
  {   3, "audioData" },
  {   4, "data" },
  {   5, "encryptionData" },
  {   6, "h235Control" },
  {   7, "h235Media" },
  {   8, "multiplexedStream" },
  {   9, "redundancyEncoding" },
  {  10, "multiplePayloadStream" },
  {  11, "fec" },
  { 0, NULL }
};

static const per_choice_t DataType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "nullData"                    , ASN1_EXTENSION_ROOT    , dissect_nullData },
  {   2, "videoData"                   , ASN1_EXTENSION_ROOT    , dissect_videoData },
  {   3, "audioData"                   , ASN1_EXTENSION_ROOT    , dissect_audioData },
  {   4, "data"                        , ASN1_EXTENSION_ROOT    , dissect_data },
  {   5, "encryptionData"              , ASN1_EXTENSION_ROOT    , dissect_encryptionData },
  {   6, "h235Control"                 , ASN1_NOT_EXTENSION_ROOT, dissect_h235Control },
  {   7, "h235Media"                   , ASN1_NOT_EXTENSION_ROOT, dissect_h235Media },
  {   8, "multiplexedStream"           , ASN1_NOT_EXTENSION_ROOT, dissect_multiplexedStream },
  {   9, "redundancyEncoding"          , ASN1_NOT_EXTENSION_ROOT, dissect_redundancyEncoding },
  {  10, "multiplePayloadStream"       , ASN1_NOT_EXTENSION_ROOT, dissect_multiplePayloadStream },
  {  11, "fec"                         , ASN1_NOT_EXTENSION_ROOT, dissect_fec },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_DataType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_DataType, DataType_choice, "DataType",
                              NULL);

  return offset;
}



static int
dissect_h245_INTEGER_0_8191(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 8191U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_subChannelID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_8191(tvb, offset, pinfo, tree, hf_h245_subChannelID);
}
static int dissect_pcr_pid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_8191(tvb, offset, pinfo, tree, hf_h245_pcr_pid);
}

static const per_sequence_t H222LogicalChannelParameters_sequence[] = {
  { "resourceID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_resourceID },
  { "subChannelID"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_subChannelID },
  { "pcr-pid"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_pcr_pid },
  { "programDescriptors"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_programDescriptors },
  { "streamDescriptors"           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_streamDescriptors },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H222LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H222LogicalChannelParameters, H222LogicalChannelParameters_sequence);

  return offset;
}
static int dissect_h222LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H222LogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_h222LogicalChannelParameters);
}



static int
dissect_h245_INTEGER_0_2(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 2U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_controlFieldOctets(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_2(tvb, offset, pinfo, tree, hf_h245_controlFieldOctets);
}

static const per_sequence_t Al3_sequence[] = {
  { "controlFieldOctets"          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_controlFieldOctets },
  { "sendBufferSize"              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_sendBufferSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Al3(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Al3, Al3_sequence);

  return offset;
}
static int dissect_al3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Al3(tvb, offset, pinfo, tree, hf_h245_al3);
}


static const value_string h245_T_transferMode_vals[] = {
  {   0, "framed" },
  {   1, "unframed" },
  { 0, NULL }
};

static const per_choice_t T_transferMode_choice[] = {
  {   0, "framed"                      , ASN1_EXTENSION_ROOT    , dissect_framed },
  {   1, "unframed"                    , ASN1_EXTENSION_ROOT    , dissect_unframed },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_transferMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_transferMode, T_transferMode_choice, "T_transferMode",
                              NULL);

  return offset;
}
static int dissect_transferMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_transferMode(tvb, offset, pinfo, tree, hf_h245_transferMode);
}


static const value_string h245_AL1HeaderFEC_vals[] = {
  {   0, "sebch16-7" },
  {   1, "golay24-12" },
  { 0, NULL }
};

static const per_choice_t AL1HeaderFEC_choice[] = {
  {   0, "sebch16-7"                   , ASN1_EXTENSION_ROOT    , dissect_sebch16_7 },
  {   1, "golay24-12"                  , ASN1_EXTENSION_ROOT    , dissect_golay24_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AL1HeaderFEC(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AL1HeaderFEC, AL1HeaderFEC_choice, "AL1HeaderFEC",
                              NULL);

  return offset;
}
static int dissect_AL1HeaderFEC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AL1HeaderFEC(tvb, offset, pinfo, tree, hf_h245_AL1HeaderFEC);
}


static const value_string h245_AL1CrcLength_vals[] = {
  {   0, "crc4bit" },
  {   1, "crc12bit" },
  {   2, "crc20bit" },
  {   3, "crc28bit" },
  {   4, "crc8bit" },
  {   5, "crc16bit" },
  {   6, "crc32bit" },
  {   7, "crcNotUsed" },
  { 0, NULL }
};

static const per_choice_t AL1CrcLength_choice[] = {
  {   0, "crc4bit"                     , ASN1_EXTENSION_ROOT    , dissect_crc4bit },
  {   1, "crc12bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc12bit },
  {   2, "crc20bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc20bit },
  {   3, "crc28bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc28bit },
  {   4, "crc8bit"                     , ASN1_NOT_EXTENSION_ROOT, dissect_crc8bit },
  {   5, "crc16bit"                    , ASN1_NOT_EXTENSION_ROOT, dissect_crc16bit },
  {   6, "crc32bit"                    , ASN1_NOT_EXTENSION_ROOT, dissect_crc32bit },
  {   7, "crcNotUsed"                  , ASN1_NOT_EXTENSION_ROOT, dissect_crcNotUsed },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AL1CrcLength(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AL1CrcLength, AL1CrcLength_choice, "AL1CrcLength",
                              NULL);

  return offset;
}
static int dissect_crcLength2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AL1CrcLength(tvb, offset, pinfo, tree, hf_h245_crcLength2);
}



static int
dissect_h245_INTEGER_8_32(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           8U, 32U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_rcpcCodeRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_8_32(tvb, offset, pinfo, tree, hf_h245_rcpcCodeRate);
}



static int
dissect_h245_INTEGER_0_16(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 16U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_finite(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_16(tvb, offset, pinfo, tree, hf_h245_finite);
}


static const value_string h245_T_numberOfRetransmissions_vals[] = {
  {   0, "finite" },
  {   1, "infinite" },
  { 0, NULL }
};

static const per_choice_t T_numberOfRetransmissions_choice[] = {
  {   0, "finite"                      , ASN1_EXTENSION_ROOT    , dissect_finite },
  {   1, "infinite"                    , ASN1_EXTENSION_ROOT    , dissect_infinite },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_numberOfRetransmissions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_numberOfRetransmissions, T_numberOfRetransmissions_choice, "T_numberOfRetransmissions",
                              NULL);

  return offset;
}
static int dissect_numberOfRetransmissions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_numberOfRetransmissions(tvb, offset, pinfo, tree, hf_h245_numberOfRetransmissions);
}

static const per_sequence_t H223AnnexCArqParameters_sequence[] = {
  { "numberOfRetransmissions"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfRetransmissions },
  { "sendBufferSize"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sendBufferSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223AnnexCArqParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223AnnexCArqParameters, H223AnnexCArqParameters_sequence);

  return offset;
}
static int dissect_typeIArq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AnnexCArqParameters(tvb, offset, pinfo, tree, hf_h245_typeIArq);
}
static int dissect_typeIIArq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AnnexCArqParameters(tvb, offset, pinfo, tree, hf_h245_typeIIArq);
}


static const value_string h245_ArqType_vals[] = {
  {   0, "noArq" },
  {   1, "typeIArq" },
  {   2, "typeIIArq" },
  { 0, NULL }
};

static const per_choice_t ArqType_choice[] = {
  {   0, "noArq"                       , ASN1_EXTENSION_ROOT    , dissect_noArq },
  {   1, "typeIArq"                    , ASN1_EXTENSION_ROOT    , dissect_typeIArq },
  {   2, "typeIIArq"                   , ASN1_EXTENSION_ROOT    , dissect_typeIIArq },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ArqType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ArqType, ArqType_choice, "ArqType",
                              NULL);

  return offset;
}
static int dissect_arqType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ArqType(tvb, offset, pinfo, tree, hf_h245_arqType);
}

static const per_sequence_t H223AL1MParameters_sequence[] = {
  { "transferMode"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_transferMode },
  { "headerFEC"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_AL1HeaderFEC },
  { "crcLength"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crcLength2 },
  { "rcpcCodeRate"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rcpcCodeRate },
  { "arqType"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arqType },
  { "alpduInterleaving"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alpduInterleaving },
  { "alsduSplitting"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alsduSplitting },
  { "rsCodeCorrection"            , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rsCodeCorrection },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223AL1MParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223AL1MParameters, H223AL1MParameters_sequence);

  return offset;
}
static int dissect_al1M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AL1MParameters(tvb, offset, pinfo, tree, hf_h245_al1M);
}


static const value_string h245_AL2HeaderFEC_vals[] = {
  {   0, "sebch16-5" },
  {   1, "golay24-12" },
  { 0, NULL }
};

static const per_choice_t AL2HeaderFEC_choice[] = {
  {   0, "sebch16-5"                   , ASN1_EXTENSION_ROOT    , dissect_sebch16_5 },
  {   1, "golay24-12"                  , ASN1_EXTENSION_ROOT    , dissect_golay24_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AL2HeaderFEC(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AL2HeaderFEC, AL2HeaderFEC_choice, "AL2HeaderFEC",
                              NULL);

  return offset;
}
static int dissect_AL2HeaderFEC(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AL2HeaderFEC(tvb, offset, pinfo, tree, hf_h245_AL2HeaderFEC);
}

static const per_sequence_t H223AL2MParameters_sequence[] = {
  { "headerFEC"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_AL2HeaderFEC },
  { "alpduInterleaving"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alpduInterleaving },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223AL2MParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223AL2MParameters, H223AL2MParameters_sequence);

  return offset;
}
static int dissect_al2M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AL2MParameters(tvb, offset, pinfo, tree, hf_h245_al2M);
}


static const value_string h245_T_headerFormat_vals[] = {
  {   0, "sebch16-7" },
  {   1, "golay24-12" },
  { 0, NULL }
};

static const per_choice_t T_headerFormat_choice[] = {
  {   0, "sebch16-7"                   , ASN1_EXTENSION_ROOT    , dissect_sebch16_7 },
  {   1, "golay24-12"                  , ASN1_EXTENSION_ROOT    , dissect_golay24_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_headerFormat(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_headerFormat, T_headerFormat_choice, "T_headerFormat",
                              NULL);

  return offset;
}
static int dissect_headerFormat(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_headerFormat(tvb, offset, pinfo, tree, hf_h245_headerFormat);
}


static const value_string h245_AL3CrcLength_vals[] = {
  {   0, "crc4bit" },
  {   1, "crc12bit" },
  {   2, "crc20bit" },
  {   3, "crc28bit" },
  {   4, "crc8bit" },
  {   5, "crc16bit" },
  {   6, "crc32bit" },
  {   7, "crcNotUsed" },
  { 0, NULL }
};

static const per_choice_t AL3CrcLength_choice[] = {
  {   0, "crc4bit"                     , ASN1_EXTENSION_ROOT    , dissect_crc4bit },
  {   1, "crc12bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc12bit },
  {   2, "crc20bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc20bit },
  {   3, "crc28bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc28bit },
  {   4, "crc8bit"                     , ASN1_NOT_EXTENSION_ROOT, dissect_crc8bit },
  {   5, "crc16bit"                    , ASN1_NOT_EXTENSION_ROOT, dissect_crc16bit },
  {   6, "crc32bit"                    , ASN1_NOT_EXTENSION_ROOT, dissect_crc32bit },
  {   7, "crcNotUsed"                  , ASN1_NOT_EXTENSION_ROOT, dissect_crcNotUsed },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AL3CrcLength(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AL3CrcLength, AL3CrcLength_choice, "AL3CrcLength",
                              NULL);

  return offset;
}
static int dissect_crlength2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AL3CrcLength(tvb, offset, pinfo, tree, hf_h245_crlength2);
}

static const per_sequence_t H223AL3MParameters_sequence[] = {
  { "headerFormat"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_headerFormat },
  { "crcLength"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crlength2 },
  { "rcpcCodeRate"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rcpcCodeRate },
  { "arqType"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arqType },
  { "alpduInterleaving"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alpduInterleaving },
  { "rsCodeCorrection"            , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rsCodeCorrection },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223AL3MParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223AL3MParameters, H223AL3MParameters_sequence);

  return offset;
}
static int dissect_al3M(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223AL3MParameters(tvb, offset, pinfo, tree, hf_h245_al3M);
}


static const value_string h245_T_adaptationLayerType_vals[] = {
  {   0, "nonStandard" },
  {   1, "al1Framed" },
  {   2, "al1NotFramed" },
  {   3, "al2WithoutSequenceNumbers" },
  {   4, "al2WithSequenceNumbers" },
  {   5, "al3" },
  {   6, "al1M" },
  {   7, "al2M" },
  {   8, "al3M" },
  { 0, NULL }
};

static const per_choice_t T_adaptationLayerType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "al1Framed"                   , ASN1_EXTENSION_ROOT    , dissect_al1Framed },
  {   2, "al1NotFramed"                , ASN1_EXTENSION_ROOT    , dissect_al1NotFramed },
  {   3, "al2WithoutSequenceNumbers"   , ASN1_EXTENSION_ROOT    , dissect_al2WithoutSequenceNumbers },
  {   4, "al2WithSequenceNumbers"      , ASN1_EXTENSION_ROOT    , dissect_al2WithSequenceNumbers },
  {   5, "al3"                         , ASN1_EXTENSION_ROOT    , dissect_al3 },
  {   6, "al1M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al1M },
  {   7, "al2M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al2M },
  {   8, "al3M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al3M },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_adaptationLayerType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_adaptationLayerType, T_adaptationLayerType_choice, "T_adaptationLayerType",
                              NULL);

  return offset;
}
static int dissect_adaptationLayerType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_adaptationLayerType(tvb, offset, pinfo, tree, hf_h245_adaptationLayerType);
}

static const per_sequence_t H223LogicalChannelParameters_sequence[] = {
  { "adaptationLayerType"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_adaptationLayerType },
  { "segmentableFlag"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_segmentableFlag },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223LogicalChannelParameters, H223LogicalChannelParameters_sequence);

  return offset;
}
static int dissect_h223LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223LogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_h223LogicalChannelParameters);
}


static const value_string h245_CRCLength_vals[] = {
  {   0, "crc8bit" },
  {   1, "crc16bit" },
  {   2, "crc32bit" },
  { 0, NULL }
};

static const per_choice_t CRCLength_choice[] = {
  {   0, "crc8bit"                     , ASN1_EXTENSION_ROOT    , dissect_crc8bit },
  {   1, "crc16bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc16bit },
  {   2, "crc32bit"                    , ASN1_EXTENSION_ROOT    , dissect_crc32bit },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CRCLength(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CRCLength, CRCLength_choice, "CRCLength",
                              NULL);

  return offset;
}
static int dissect_crcLength(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CRCLength(tvb, offset, pinfo, tree, hf_h245_crcLength);
}

static const per_sequence_t V76HDLCParameters_sequence[] = {
  { "crcLength"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_crcLength },
  { "n401"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_n401 },
  { "loopbackTestProcedure"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_loopbackTestProcedure },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V76HDLCParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V76HDLCParameters, V76HDLCParameters_sequence);

  return offset;
}
static int dissect_hdlcParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V76HDLCParameters(tvb, offset, pinfo, tree, hf_h245_hdlcParameters);
}


static const value_string h245_T_suspendResume_vals[] = {
  {   0, "noSuspendResume" },
  {   1, "suspendResumewAddress" },
  {   2, "suspendResumewoAddress" },
  { 0, NULL }
};

static const per_choice_t T_suspendResume_choice[] = {
  {   0, "noSuspendResume"             , ASN1_EXTENSION_ROOT    , dissect_noSuspendResume },
  {   1, "suspendResumewAddress"       , ASN1_EXTENSION_ROOT    , dissect_suspendResumewAddress },
  {   2, "suspendResumewoAddress"      , ASN1_EXTENSION_ROOT    , dissect_suspendResumewoAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_suspendResume(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_suspendResume, T_suspendResume_choice, "T_suspendResume",
                              NULL);

  return offset;
}
static int dissect_suspendResume(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_suspendResume(tvb, offset, pinfo, tree, hf_h245_suspendResume);
}


static const value_string h245_T_recovery_vals[] = {
  {   0, "rej" },
  {   1, "sREJ" },
  {   2, "mSREJ" },
  { 0, NULL }
};

static const per_choice_t T_recovery_choice[] = {
  {   0, "rej"                         , ASN1_EXTENSION_ROOT    , dissect_rej },
  {   1, "sREJ"                        , ASN1_EXTENSION_ROOT    , dissect_sREJ },
  {   2, "mSREJ"                       , ASN1_EXTENSION_ROOT    , dissect_mSREJ },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_recovery(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_recovery, T_recovery_choice, "T_recovery",
                              NULL);

  return offset;
}
static int dissect_recovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_recovery(tvb, offset, pinfo, tree, hf_h245_recovery);
}

static const per_sequence_t T_eRM_sequence[] = {
  { "windowSize"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_windowSize },
  { "recovery"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_recovery },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_eRM(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_eRM, T_eRM_sequence);

  return offset;
}
static int dissect_eRM(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_eRM(tvb, offset, pinfo, tree, hf_h245_eRM);
}


static const value_string h245_V76LCP_mode_vals[] = {
  {   0, "eRM" },
  {   1, "uNERM" },
  { 0, NULL }
};

static const per_choice_t V76LCP_mode_choice[] = {
  {   0, "eRM"                         , ASN1_EXTENSION_ROOT    , dissect_eRM },
  {   1, "uNERM"                       , ASN1_EXTENSION_ROOT    , dissect_uNERM },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_V76LCP_mode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_V76LCP_mode, V76LCP_mode_choice, "V76LCP_mode",
                              NULL);

  return offset;
}
static int dissect_v76_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V76LCP_mode(tvb, offset, pinfo, tree, hf_h245_v76_mode);
}

static const per_sequence_t V75Parameters_sequence[] = {
  { "audioHeaderPresent"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioHeaderPresent },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V75Parameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V75Parameters, V75Parameters_sequence);

  return offset;
}
static int dissect_v75Parameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V75Parameters(tvb, offset, pinfo, tree, hf_h245_v75Parameters);
}

static const per_sequence_t V76LogicalChannelParameters_sequence[] = {
  { "hdlcParameters"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_hdlcParameters },
  { "suspendResume"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_suspendResume },
  { "uIH"                         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_uIH },
  { "mode"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_v76_mode },
  { "v75Parameters"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_v75Parameters },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_V76LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_V76LogicalChannelParameters, V76LogicalChannelParameters_sequence);

  return offset;
}
static int dissect_v76LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V76LogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_v76LogicalChannelParameters);
}


static int
dissect_h245_Ipv4_network(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {

guint32 value_offset;
guint32 value_len;

  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    4, 4,
                                    &value_offset, &value_len);
  if ( media_channel )
	tvb_memcpy(tvb, (char *)&ipv4_address, value_offset, 4);

  if ( media_control_channel )
	tvb_memcpy(tvb, (char *)&rtcp_ipv4_address, value_offset, 4);


  return offset;
}
static int dissect_ip4_network(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ipv4_network(tvb, offset, pinfo, tree, hf_h245_ip4_network);
}



static int
dissect_h245_TsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
guint32 tsapIdentifier;


	offset=dissect_per_constrained_integer(tvb, offset, pinfo, tree,
		hf_h245_tsapIdentifier,  0,  65535,
		&tsapIdentifier, NULL, FALSE);
  if ( media_channel )
	ipv4_port = tsapIdentifier;

  if ( media_control_channel )
	rtcp_ipv4_port = tsapIdentifier;


  return offset;
}
static int dissect_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TsapIdentifier(tvb, offset, pinfo, tree, hf_h245_tsapIdentifier);
}

static const per_sequence_t T_iPAddress_sequence[] = {
  { "network"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ip4_network },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tsapIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_iPAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_iPAddress, T_iPAddress_sequence);

  return offset;
}
static int dissect_iPAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_iPAddress(tvb, offset, pinfo, tree, hf_h245_iPAddress);
}


static int
dissect_h245_OCTET_STRING_SIZE_6(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    6, 6,
                                    NULL, NULL);

  return offset;
}
static int dissect_node(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_6(tvb, offset, pinfo, tree, hf_h245_node);
}


static int
dissect_h245_OCTET_STRING_SIZE_4(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    4, 4,
                                    NULL, NULL);

  return offset;
}
static int dissect_netnum(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_4(tvb, offset, pinfo, tree, hf_h245_netnum);
}
static int dissect_network(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_4(tvb, offset, pinfo, tree, hf_h245_network);
}
static int dissect_route_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_4(tvb, offset, pinfo, tree, hf_h245_route_item);
}
static int dissect_mip4_network(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_4(tvb, offset, pinfo, tree, hf_h245_mip4_network);
}


static int
dissect_h245_OCTET_STRING_SIZE_2(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    2, 2,
                                    NULL, NULL);

  return offset;
}
static int dissect_ipx_tsapIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_2(tvb, offset, pinfo, tree, hf_h245_ipx_tsapIdentifier);
}

static const per_sequence_t T_iPXAddress_sequence[] = {
  { "node"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_node },
  { "netnum"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_netnum },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ipx_tsapIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_iPXAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_iPXAddress, T_iPXAddress_sequence);

  return offset;
}
static int dissect_iPXAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_iPXAddress(tvb, offset, pinfo, tree, hf_h245_iPXAddress);
}

static const per_sequence_t T_iP6Address_sequence[] = {
  { "network"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ip6_network },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ipv6_tsapIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_iP6Address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_iP6Address, T_iP6Address_sequence);

  return offset;
}
static int dissect_iP6Address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_iP6Address(tvb, offset, pinfo, tree, hf_h245_iP6Address);
}


static const value_string h245_T_routing_vals[] = {
  {   0, "strict" },
  {   1, "loose" },
  { 0, NULL }
};

static const per_choice_t T_routing_choice[] = {
  {   0, "strict"                      , ASN1_NO_EXTENSIONS     , dissect_strict },
  {   1, "loose"                       , ASN1_NO_EXTENSIONS     , dissect_loose },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_routing(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_routing, T_routing_choice, "T_routing",
                              NULL);

  return offset;
}
static int dissect_routing(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_routing(tvb, offset, pinfo, tree, hf_h245_routing);
}


static int
dissect_h245_T_route(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_T_route, dissect_route_item);

  return offset;
}
static int dissect_route(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_route(tvb, offset, pinfo, tree, hf_h245_route);
}

static const per_sequence_t T_iPSourceRouteAddress_sequence[] = {
  { "routing"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_routing },
  { "network"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_network },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_iPSrcRoute_tsapIdentifier },
  { "route"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_route },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_iPSourceRouteAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_iPSourceRouteAddress, T_iPSourceRouteAddress_sequence);

  return offset;
}
static int dissect_iPSourceRouteAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_iPSourceRouteAddress(tvb, offset, pinfo, tree, hf_h245_iPSourceRouteAddress);
}


static const value_string h245_UnicastAddress_vals[] = {
  {   0, "iPAddress" },
  {   1, "iPXAddress" },
  {   2, "iP6Address" },
  {   3, "netBios" },
  {   4, "iPSourceRouteAddress" },
  {   5, "nsap" },
  {   6, "nonStandardAddress" },
  { 0, NULL }
};

static const per_choice_t UnicastAddress_choice[] = {
  {   0, "iPAddress"                   , ASN1_EXTENSION_ROOT    , dissect_iPAddress },
  {   1, "iPXAddress"                  , ASN1_EXTENSION_ROOT    , dissect_iPXAddress },
  {   2, "iP6Address"                  , ASN1_EXTENSION_ROOT    , dissect_iP6Address },
  {   3, "netBios"                     , ASN1_EXTENSION_ROOT    , dissect_netBios },
  {   4, "iPSourceRouteAddress"        , ASN1_EXTENSION_ROOT    , dissect_iPSourceRouteAddress },
  {   5, "nsap"                        , ASN1_NOT_EXTENSION_ROOT, dissect_nsap },
  {   6, "nonStandardAddress"          , ASN1_NOT_EXTENSION_ROOT, dissect_nonStandardAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_UnicastAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_UnicastAddress, UnicastAddress_choice, "UnicastAddress",
                              NULL);

  return offset;
}
static int dissect_unicastAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_UnicastAddress(tvb, offset, pinfo, tree, hf_h245_unicastAddress);
}

static const per_sequence_t MIPAddress_sequence[] = {
  { "network"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mip4_network },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multicast_tsapIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MIPAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MIPAddress, MIPAddress_sequence);

  return offset;
}
static int dissect_mIPAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MIPAddress(tvb, offset, pinfo, tree, hf_h245_mIPAddress);
}

static const per_sequence_t MIP6Address_sequence[] = {
  { "network"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mip6_network },
  { "tsapIdentifier"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multicast_IPv6_tsapIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MIP6Address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MIP6Address, MIP6Address_sequence);

  return offset;
}
static int dissect_mIP6Address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MIP6Address(tvb, offset, pinfo, tree, hf_h245_mIP6Address);
}


static const value_string h245_MulticastAddress_vals[] = {
  {   0, "iPAddress" },
  {   1, "iP6Address" },
  {   2, "nsap" },
  {   3, "nonStandardAddress" },
  { 0, NULL }
};

static const per_choice_t MulticastAddress_choice[] = {
  {   0, "iPAddress"                   , ASN1_EXTENSION_ROOT    , dissect_mIPAddress },
  {   1, "iP6Address"                  , ASN1_EXTENSION_ROOT    , dissect_mIP6Address },
  {   2, "nsap"                        , ASN1_NOT_EXTENSION_ROOT, dissect_nsap },
  {   3, "nonStandardAddress"          , ASN1_NOT_EXTENSION_ROOT, dissect_nonStandardAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MulticastAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MulticastAddress, MulticastAddress_choice, "MulticastAddress",
                              NULL);

  return offset;
}
static int dissect_multicastAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MulticastAddress(tvb, offset, pinfo, tree, hf_h245_multicastAddress);
}


static const value_string h245_TransportAddress_vals[] = {
  {   0, "unicastAddress" },
  {   1, "multicastAddress" },
  { 0, NULL }
};

static const per_choice_t TransportAddress_choice[] = {
  {   0, "unicastAddress"              , ASN1_EXTENSION_ROOT    , dissect_unicastAddress },
  {   1, "multicastAddress"            , ASN1_EXTENSION_ROOT    , dissect_multicastAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_TransportAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_TransportAddress, TransportAddress_choice, "TransportAddress",
                              NULL);

  return offset;
}
static int dissect_localAreaAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_h245_localAreaAddress);
}
static int dissect_cm_mediaControlChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_h245_cm_mediaControlChannel);
}
static int dissect_signalAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_h245_signalAddress);
}


static int
dissect_h245_T_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_channel = TRUE;
  offset = dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_index);



	media_channel = FALSE;
  return offset;
}
static int dissect_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mediaChannel(tvb, offset, pinfo, tree, hf_h245_mediaChannel);
}


static int
dissect_h245_T_mediaControlChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_control_channel = TRUE;
  offset = dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_index);



	media_control_channel = FALSE;
  return offset;
}
static int dissect_mediaControlChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mediaControlChannel(tvb, offset, pinfo, tree, hf_h245_mediaControlChannel);
}



static int
dissect_h245_McuNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 192U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_mcuNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_McuNumber(tvb, offset, pinfo, tree, hf_h245_mcuNumber);
}



static int
dissect_h245_TerminalNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 192U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_terminalNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalNumber(tvb, offset, pinfo, tree, hf_h245_terminalNumber);
}

static const per_sequence_t TerminalLabel_sequence[] = {
  { "mcuNumber"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mcuNumber },
  { "terminalNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalLabel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalLabel, TerminalLabel_sequence);

  return offset;
}
static int dissect_destination(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_destination);
}
static int dissect_source(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_source);
}
static int dissect_terminalLabel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalLabel);
}
static int dissect_dropTerminal(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_dropTerminal);
}
static int dissect_requestTerminalID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_requestTerminalID);
}
static int dissect_makeTerminalBroadcaster(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_makeTerminalBroadcaster);
}
static int dissect_sendThisSource(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_sendThisSource);
}
static int dissect_terminalListResponse_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalListResponse_item);
}
static int dissect_terminalNumberAssign(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalNumberAssign);
}
static int dissect_terminalJoinedConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalJoinedConference);
}
static int dissect_terminalLeftConference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalLeftConference);
}
static int dissect_terminalYouAreSeeing(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalYouAreSeeing);
}
static int dissect_floorRequested(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_floorRequested);
}


static const value_string h245_T_mediaPacketization_vals[] = {
  {   0, "h261aVideoPacketization" },
  {   1, "rtpPayloadType" },
  { 0, NULL }
};

static const per_choice_t T_mediaPacketization_choice[] = {
  {   0, "h261aVideoPacketization"     , ASN1_EXTENSION_ROOT    , dissect_h261aVideoPacketizationFlag },
  {   1, "rtpPayloadType"              , ASN1_NOT_EXTENSION_ROOT, dissect_rtpPayloadType },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_mediaPacketization(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_mediaPacketization, T_mediaPacketization_choice, "T_mediaPacketization",
                              NULL);

  return offset;
}
static int dissect_mediaPacketization(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mediaPacketization(tvb, offset, pinfo, tree, hf_h245_mediaPacketization);
}

static const per_sequence_t H2250LogicalChannelParameters_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandardParams },
  { "sessionID"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sessionID_0_255 },
  { "associatedSessionID"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_associatedSessionID },
  { "mediaChannel"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaChannel },
  { "mediaGuaranteedDelivery"     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaGuaranteedDelivery },
  { "mediaControlChannel"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaControlChannel },
  { "mediaControlGuaranteedDelivery", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaControlGuaranteedDelivery },
  { "silenceSuppression"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_silenceSuppression },
  { "destination"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_destination },
  { "dynamicRTPPayloadType"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dynamicRTPPayloadType },
  { "mediaPacketization"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaPacketization },
  { "transportCapability"         , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_transportCapability },
  { "redundancyEncoding"          , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_redundancyEncoding },
  { "source"                      , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_source },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H2250LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H2250LogicalChannelParameters, H2250LogicalChannelParameters_sequence);

  return offset;
}
static int dissect_h2250LogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H2250LogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_h2250LogicalChannelParameters);
}


static const value_string h245_OLC_forw_multiplexParameters_vals[] = {
  {   0, "h222LogicalChannelParameters" },
  {   1, "h223LogicalChannelParameters" },
  {   2, "v76LogicalChannelParameters" },
  {   3, "h2250LogicalChannelParameters" },
  {   4, "none" },
  { 0, NULL }
};

static const per_choice_t OLC_forw_multiplexParameters_choice[] = {
  {   0, "h222LogicalChannelParameters", ASN1_EXTENSION_ROOT    , dissect_h222LogicalChannelParameters },
  {   1, "h223LogicalChannelParameters", ASN1_EXTENSION_ROOT    , dissect_h223LogicalChannelParameters },
  {   2, "v76LogicalChannelParameters" , ASN1_EXTENSION_ROOT    , dissect_v76LogicalChannelParameters },
  {   3, "h2250LogicalChannelParameters", ASN1_NOT_EXTENSION_ROOT, dissect_h2250LogicalChannelParameters },
  {   4, "none"                        , ASN1_NOT_EXTENSION_ROOT, dissect_none },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_OLC_forw_multiplexParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_OLC_forw_multiplexParameters, OLC_forw_multiplexParameters_choice, "OLC_forw_multiplexParameters",
                              NULL);

  return offset;
}
static int dissect_olc_forw_multiplexParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OLC_forw_multiplexParameters(tvb, offset, pinfo, tree, hf_h245_olc_forw_multiplexParameters);
}

static const per_sequence_t T_forwardLogicalChannelParameters_sequence[] = {
  { "portNumber"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_portNumber },
  { "dataType"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataType },
  { "multiplexParameters"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_olc_forw_multiplexParameters },
  { "forwardLogicalChannelDependency", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_forwardLogicalChannelDependency },
  { "replacementFor"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_replacementFor },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_forwardLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_forwardLogicalChannelParameters, T_forwardLogicalChannelParameters_sequence);

  return offset;
}
static int dissect_forwardLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_forwardLogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_forwardLogicalChannelParameters);
}


static const value_string h245_OLC_rev_multiplexParameters_vals[] = {
  {   0, "h223LogicalChannelParameters" },
  {   1, "v76LogicalChannelParameters" },
  {   2, "h2250LogicalChannelParameters" },
  { 0, NULL }
};

static const per_choice_t OLC_rev_multiplexParameters_choice[] = {
  {   0, "h223LogicalChannelParameters", ASN1_EXTENSION_ROOT    , dissect_h223LogicalChannelParameters },
  {   1, "v76LogicalChannelParameters" , ASN1_EXTENSION_ROOT    , dissect_v76LogicalChannelParameters },
  {   2, "h2250LogicalChannelParameters", ASN1_NOT_EXTENSION_ROOT, dissect_h2250LogicalChannelParameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_OLC_rev_multiplexParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_channel = FALSE;
	media_control_channel = FALSE;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_OLC_rev_multiplexParameters, OLC_rev_multiplexParameters_choice, "OLC_rev_multiplexParameters",
                              NULL);

	if((!pinfo->fd->flags.visited) && ipv4_address!=0 && ipv4_port!=0 && rtp_handle){
		address src_addr;

		src_addr.type=AT_IPv4;
		src_addr.len=4;
		src_addr.data=(char *)&ipv4_address;

		rtp_add_address(pinfo, &src_addr, ipv4_port, 0, "H245", pinfo->fd->num, NULL);
	}
	if((!pinfo->fd->flags.visited) && rtcp_ipv4_address!=0 && rtcp_ipv4_port!=0 && rtcp_handle){
		address src_addr;

		src_addr.type=AT_IPv4;
		src_addr.len=4;
		src_addr.data=(char *)&rtcp_ipv4_address;

		rtcp_add_address(pinfo, &src_addr, rtcp_ipv4_port, 0, "H245", pinfo->fd->num);
	}

  return offset;
}
static int dissect_olc_rev_multiplexParameter(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OLC_rev_multiplexParameters(tvb, offset, pinfo, tree, hf_h245_olc_rev_multiplexParameter);
}

static const per_sequence_t OLC_reverseLogicalChannelParameters_sequence[] = {
  { "dataType"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dataType },
  { "multiplexParameters"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_olc_rev_multiplexParameter },
  { "reverseLogicalChannelDependency", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_reverseLogicalChannelDependency },
  { "replacementFor"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_replacementFor },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_OLC_reverseLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OLC_reverseLogicalChannelParameters, OLC_reverseLogicalChannelParameters_sequence);

  return offset;
}
static int dissect_reverseLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OLC_reverseLogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_reverseLogicalChannelParameters);
}


static const value_string h245_T_distribution_vals[] = {
  {   0, "unicast" },
  {   1, "multicast" },
  { 0, NULL }
};

static const per_choice_t T_distribution_choice[] = {
  {   0, "unicast"                     , ASN1_EXTENSION_ROOT    , dissect_unicast },
  {   1, "multicast"                   , ASN1_EXTENSION_ROOT    , dissect_multicast },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_distribution(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_distribution, T_distribution_choice, "T_distribution",
                              NULL);

  return offset;
}
static int dissect_distribution(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_distribution(tvb, offset, pinfo, tree, hf_h245_distribution);
}


static int
dissect_h245_T_e164Address(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_IA5String(tvb, offset, pinfo, tree, hf_index,
                                 -1, -1);

  return offset;
}
static int dissect_e164Address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_e164Address(tvb, offset, pinfo, tree, hf_h245_e164Address);
}


static const value_string h245_T_networkAddress_vals[] = {
  {   0, "q2931Address" },
  {   1, "e164Address" },
  {   2, "localAreaAddress" },
  { 0, NULL }
};

static const per_choice_t T_networkAddress_choice[] = {
  {   0, "q2931Address"                , ASN1_EXTENSION_ROOT    , dissect_q2931Address },
  {   1, "e164Address"                 , ASN1_EXTENSION_ROOT    , dissect_e164Address },
  {   2, "localAreaAddress"            , ASN1_EXTENSION_ROOT    , dissect_localAreaAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_networkAddress(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_networkAddress, T_networkAddress_choice, "T_networkAddress",
                              NULL);

  return offset;
}
static int dissect_networkAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_networkAddress(tvb, offset, pinfo, tree, hf_h245_networkAddress);
}


static int
dissect_h245_OCTET_STRING_SIZE_1_255(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 255,
                                    NULL, NULL);

  return offset;
}
static int dissect_externalReference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_255(tvb, offset, pinfo, tree, hf_h245_externalReference);
}


static const value_string h245_T_t120SetupProcedure_vals[] = {
  {   0, "originateCall" },
  {   1, "waitForCall" },
  {   2, "issueQuery" },
  { 0, NULL }
};

static const per_choice_t T_t120SetupProcedure_choice[] = {
  {   0, "originateCall"               , ASN1_EXTENSION_ROOT    , dissect_originateCall },
  {   1, "waitForCall"                 , ASN1_EXTENSION_ROOT    , dissect_waitForCall },
  {   2, "issueQuery"                  , ASN1_EXTENSION_ROOT    , dissect_issueQuery },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_t120SetupProcedure(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_t120SetupProcedure, T_t120SetupProcedure_choice, "T_t120SetupProcedure",
                              NULL);

  return offset;
}
static int dissect_t120SetupProcedure(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_t120SetupProcedure(tvb, offset, pinfo, tree, hf_h245_t120SetupProcedure);
}

static const per_sequence_t NetworkAccessParameters_sequence[] = {
  { "distribution"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_distribution },
  { "networkAddress"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_networkAddress },
  { "associateConference"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_associateConference },
  { "externalReference"           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_externalReference },
  { "t120SetupProcedure"          , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_t120SetupProcedure },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NetworkAccessParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NetworkAccessParameters, NetworkAccessParameters_sequence);

  return offset;
}
static int dissect_separateStack(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NetworkAccessParameters(tvb, offset, pinfo, tree, hf_h245_separateStack);
}


static int
dissect_h245_OCTET_STRING_SIZE_1_65535(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 65535,
                                    NULL, NULL);

  return offset;
}
static int dissect_h235Key(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_65535(tvb, offset, pinfo, tree, hf_h245_h235Key);
}
static int dissect_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_65535(tvb, offset, pinfo, tree, hf_h245_value);
}
static int dissect_certificateResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_65535(tvb, offset, pinfo, tree, hf_h245_certificateResponse);
}


static int
dissect_h245_BIT_STRING_SIZE_1_65535(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_bit_string(tvb, offset, pinfo, tree, hf_index,
                                  1, 65535);

  return offset;
}
static int dissect_escrowValue(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BIT_STRING_SIZE_1_65535(tvb, offset, pinfo, tree, hf_h245_escrowValue);
}

static const per_sequence_t EscrowData_sequence[] = {
  { "escrowID"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_escrowID },
  { "escrowValue"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_escrowValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EscrowData(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EscrowData, EscrowData_sequence);

  return offset;
}
static int dissect_escrowentry_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EscrowData(tvb, offset, pinfo, tree, hf_h245_escrowentry_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_EscrowData(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_EscrowData, dissect_escrowentry_item,
                                               1, 256);

  return offset;
}
static int dissect_escrowentry(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_EscrowData(tvb, offset, pinfo, tree, hf_h245_escrowentry);
}

static const per_sequence_t EncryptionSync_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandard },
  { "synchFlag"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_synchFlag },
  { "h235Key"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h235Key },
  { "escrowentry"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_escrowentry },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EncryptionSync(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EncryptionSync, EncryptionSync_sequence);

  return offset;
}
static int dissect_encryptionSync(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionSync(tvb, offset, pinfo, tree, hf_h245_encryptionSync);
}
static int dissect_encryptionUpdate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionSync(tvb, offset, pinfo, tree, hf_h245_encryptionUpdate);
}

static const per_sequence_t OpenLogicalChannel_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "forwardLogicalChannelParameters", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelParameters },
  { "reverseLogicalChannelParameters", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_reverseLogicalChannelParameters },
  { "separateStack"               , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_separateStack },
  { "encryptionSync"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_encryptionSync },
  { NULL, 0, 0, NULL }
};

int
dissect_h245_OpenLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OpenLogicalChannel, OpenLogicalChannel_sequence);


  if (h245_pi != NULL) h245_pi->msg_type = H245_OpenLogChn;
  return offset;
}
static int dissect_openLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OpenLogicalChannel(tvb, offset, pinfo, tree, hf_h245_openLogicalChannel);
}


static const value_string h245_T_source_vals[] = {
  {   0, "user" },
  {   1, "lcse" },
  { 0, NULL }
};

static const per_choice_t T_source_choice[] = {
  {   0, "user"                        , ASN1_NO_EXTENSIONS     , dissect_user },
  {   1, "lcse"                        , ASN1_NO_EXTENSIONS     , dissect_lcse },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_source(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_source, T_source_choice, "T_source",
                              NULL);

  return offset;
}
static int dissect_CloseLogicalChannel_source(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_source(tvb, offset, pinfo, tree, hf_h245_CloseLogicalChannel_source);
}


static const value_string h245_clc_reason_vals[] = {
  {   0, "unknown" },
  {   1, "reopen" },
  {   2, "reservationFailure" },
  { 0, NULL }
};

static const per_choice_t clc_reason_choice[] = {
  {   0, "unknown"                     , ASN1_EXTENSION_ROOT    , dissect_unknown },
  {   1, "reopen"                      , ASN1_EXTENSION_ROOT    , dissect_reopen },
  {   2, "reservationFailure"          , ASN1_EXTENSION_ROOT    , dissect_reservationFailure },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_clc_reason(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_clc_reason, clc_reason_choice, "clc_reason",
                              NULL);

  return offset;
}
static int dissect_clc_reason(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_clc_reason(tvb, offset, pinfo, tree, hf_h245_clc_reason);
}

static const per_sequence_t CloseLogicalChannel_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "source"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_CloseLogicalChannel_source },
  { "reason"                      , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_clc_reason },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CloseLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CloseLogicalChannel, CloseLogicalChannel_sequence);


  h245_pi->msg_type = H245_CloseLogChn;
  return offset;
}
static int dissect_closeLogicalChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CloseLogicalChannel(tvb, offset, pinfo, tree, hf_h245_closeLogicalChannel);
}


static const value_string h245_T_reason_vals[] = {
  {   0, "unknown" },
  {   1, "normal" },
  {   2, "reopen" },
  {   3, "reservationFailure" },
  { 0, NULL }
};

static const per_choice_t T_reason_choice[] = {
  {   0, "unknown"                     , ASN1_EXTENSION_ROOT    , dissect_unknown },
  {   1, "normal"                      , ASN1_EXTENSION_ROOT    , dissect_normal },
  {   2, "reopen"                      , ASN1_EXTENSION_ROOT    , dissect_reopen },
  {   3, "reservationFailure"          , ASN1_EXTENSION_ROOT    , dissect_reservationFailure },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_reason(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_reason, T_reason_choice, "T_reason",
                              NULL);

  return offset;
}
static int dissect_reason(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_reason(tvb, offset, pinfo, tree, hf_h245_reason);
}

static const per_sequence_t RequestChannelClose_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "qosCapability"               , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_qosCapability },
  { "reason"                      , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_reason },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestChannelClose(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestChannelClose, RequestChannelClose_sequence);

  return offset;
}
static int dissect_requestChannelClose(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestChannelClose(tvb, offset, pinfo, tree, hf_h245_requestChannelClose);
}



static int
dissect_h245_MultiplexTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 15U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_multiplexTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_multiplexTableEntryNumber);
}
static int dissect_multiplexTableEntryNumber_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_multiplexTableEntryNumber_item);
}
static int dissect_entryNumbers_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_entryNumbers_item);
}


static int
dissect_h245_SEQUENCE_SIZE_2_255_OF_MultiplexElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_2_255_OF_MultiplexElement, dissect_subElementList_item,
                                               2, 255);

  return offset;
}
static int dissect_subElementList(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_2_255_OF_MultiplexElement(tvb, offset, pinfo, tree, hf_h245_subElementList);
}


static const value_string h245_Me_type_vals[] = {
  {   0, "logicalChannelNumber" },
  {   1, "subElementList" },
  { 0, NULL }
};

static const per_choice_t Me_type_choice[] = {
  {   0, "logicalChannelNumber"        , ASN1_NO_EXTENSIONS     , dissect_logicalChannelNum },
  {   1, "subElementList"              , ASN1_NO_EXTENSIONS     , dissect_subElementList },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Me_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Me_type, Me_type_choice, "Me_type",
                              NULL);

  return offset;
}
static int dissect_Me_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Me_type(tvb, offset, pinfo, tree, hf_h245_Me_type);
}


static const value_string h245_ME_repeatCount_vals[] = {
  {   0, "finite" },
  {   1, "untilClosingFlag" },
  { 0, NULL }
};

static const per_choice_t ME_repeatCount_choice[] = {
  {   0, "finite"                      , ASN1_NO_EXTENSIONS     , dissect_finite_1_65535 },
  {   1, "untilClosingFlag"            , ASN1_NO_EXTENSIONS     , dissect_untilClosingFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ME_repeatCount(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ME_repeatCount, ME_repeatCount_choice, "ME_repeatCount",
                              NULL);

  return offset;
}
static int dissect_me_repeatCount(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ME_repeatCount(tvb, offset, pinfo, tree, hf_h245_me_repeatCount);
}

static const per_sequence_t MultiplexElement_sequence[] = {
  { "type"                        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_Me_type },
  { "repeatCount"                 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_me_repeatCount },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexElement, MultiplexElement_sequence);

  return offset;
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_MultiplexElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_MultiplexElement, dissect_elementList_item,
                                               1, 256);

  return offset;
}
static int dissect_elementList(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_MultiplexElement(tvb, offset, pinfo, tree, hf_h245_elementList);
}

static const per_sequence_t MultiplexEntryDescriptor_sequence[] = {
  { "multiplexTableEntryNumber"   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_multiplexTableEntryNumber },
  { "elementList"                 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_elementList },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntryDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntryDescriptor, MultiplexEntryDescriptor_sequence);

  return offset;
}
static int dissect_multiplexEntryDescriptors_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntryDescriptor(tvb, offset, pinfo, tree, hf_h245_multiplexEntryDescriptors_item);
}


static int
dissect_h245_SET_SIZE_1_15_OF_MultiplexEntryDescriptor(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_15_OF_MultiplexEntryDescriptor, dissect_multiplexEntryDescriptors_item,
                                          1, 15);

  return offset;
}
static int dissect_multiplexEntryDescriptors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_15_OF_MultiplexEntryDescriptor(tvb, offset, pinfo, tree, hf_h245_multiplexEntryDescriptors);
}

static const per_sequence_t MultiplexEntrySend_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "multiplexEntryDescriptors"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexEntryDescriptors },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntrySend(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntrySend, MultiplexEntrySend_sequence);

  return offset;
}
static int dissect_multiplexEntrySend(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntrySend(tvb, offset, pinfo, tree, hf_h245_multiplexEntrySend);
}


static int
dissect_h245_SET_SIZE_1_15_OF_MultiplexTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_15_OF_MultiplexTableEntryNumber, dissect_multiplexTableEntryNumber_item,
                                          1, 15);

  return offset;
}
static int dissect_multiplexTableEntryNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_15_OF_MultiplexTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_multiplexTableEntryNumbers);
}
static int dissect_entryNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_15_OF_MultiplexTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_entryNumbers);
}

static const per_sequence_t RequestMultiplexEntry_sequence[] = {
  { "entryNumbers"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_entryNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntry(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMultiplexEntry, RequestMultiplexEntry_sequence);

  return offset;
}
static int dissect_requestMultiplexEntry(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntry(tvb, offset, pinfo, tree, hf_h245_requestMultiplexEntry);
}


static const value_string h245_H261Resolution_vals[] = {
  {   0, "qcif" },
  {   1, "cif" },
  { 0, NULL }
};

static const per_choice_t H261Resolution_choice[] = {
  {   0, "qcif"                        , ASN1_NO_EXTENSIONS     , dissect_qcif },
  {   1, "cif"                         , ASN1_NO_EXTENSIONS     , dissect_cif },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_H261Resolution(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_H261Resolution, H261Resolution_choice, "H261Resolution",
                              NULL);

  return offset;
}
static int dissect_h261_resolution(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H261Resolution(tvb, offset, pinfo, tree, hf_h245_h261_resolution);
}

static const per_sequence_t H261VideoMode_sequence[] = {
  { "resolution"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h261_resolution },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate_1_19200 },
  { "stillImageTransmission"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_stillImageTransmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H261VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H261VideoMode, H261VideoMode_sequence);

  return offset;
}
static int dissect_h261VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H261VideoMode(tvb, offset, pinfo, tree, hf_h245_h261VideoMode);
}


static const value_string h245_T_profileAndLevel_vals[] = {
  {   0, "profileAndLevel-SPatML" },
  {   1, "profileAndLevel-MPatLL" },
  {   2, "profileAndLevel-MPatML" },
  {   3, "profileAndLevel-MPatH-14" },
  {   4, "profileAndLevel-MPatHL" },
  {   5, "profileAndLevel-SNRatLL" },
  {   6, "profileAndLevel-SNRatML" },
  {   7, "profileAndLevel-SpatialatH-14" },
  {   8, "profileAndLevel-HPatML" },
  {   9, "profileAndLevel-HPatH-14" },
  {  10, "profileAndLevel-HPatHL" },
  { 0, NULL }
};

static const per_choice_t T_profileAndLevel_choice[] = {
  {   0, "profileAndLevel-SPatML"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_SPatMLMode },
  {   1, "profileAndLevel-MPatLL"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_MPatLLMode },
  {   2, "profileAndLevel-MPatML"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_MPatMLMode },
  {   3, "profileAndLevel-MPatH-14"    , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_MPatH_14Mode },
  {   4, "profileAndLevel-MPatHL"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_MPatHLMode },
  {   5, "profileAndLevel-SNRatLL"     , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_SNRatLLMode },
  {   6, "profileAndLevel-SNRatML"     , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_SNRatMLMode },
  {   7, "profileAndLevel-SpatialatH-14", ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_SpatialatH_14Mode },
  {   8, "profileAndLevel-HPatML"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_HPatMLMode },
  {   9, "profileAndLevel-HPatH-14"    , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_HPatH_14Mode },
  {  10, "profileAndLevel-HPatHL"      , ASN1_EXTENSION_ROOT    , dissect_profileAndLevel_HPatHLMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_profileAndLevel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_profileAndLevel, T_profileAndLevel_choice, "T_profileAndLevel",
                              NULL);

  return offset;
}
static int dissect_profileAndLevel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_profileAndLevel(tvb, offset, pinfo, tree, hf_h245_profileAndLevel);
}

static const per_sequence_t H262VideoMode_sequence[] = {
  { "profileAndLevel"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_profileAndLevel },
  { "videoBitRate"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_videoBitRate },
  { "vbvBufferSize"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vbvBufferSize },
  { "samplesPerLine"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_samplesPerLine },
  { "linesPerFrame"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_linesPerFrame },
  { "framesPerSecond"             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_framesPerSecond },
  { "luminanceSampleRate"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_luminanceSampleRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H262VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H262VideoMode, H262VideoMode_sequence);

  return offset;
}
static int dissect_h262VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H262VideoMode(tvb, offset, pinfo, tree, hf_h245_h262VideoMode);
}


static const value_string h245_H263Resolution_vals[] = {
  {   0, "sqcif" },
  {   1, "qcif" },
  {   2, "cif" },
  {   3, "cif4" },
  {   4, "cif16" },
  {   5, "custom" },
  { 0, NULL }
};

static const per_choice_t H263Resolution_choice[] = {
  {   0, "sqcif"                       , ASN1_EXTENSION_ROOT    , dissect_sqcif },
  {   1, "qcif"                        , ASN1_EXTENSION_ROOT    , dissect_qcif },
  {   2, "cif"                         , ASN1_EXTENSION_ROOT    , dissect_cif },
  {   3, "cif4"                        , ASN1_EXTENSION_ROOT    , dissect_cif4 },
  {   4, "cif16"                       , ASN1_EXTENSION_ROOT    , dissect_cif16 },
  {   5, "custom"                      , ASN1_NOT_EXTENSION_ROOT, dissect_custom_res },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_H263Resolution(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_H263Resolution, H263Resolution_choice, "H263Resolution",
                              NULL);

  return offset;
}
static int dissect_h263_resolution(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263Resolution(tvb, offset, pinfo, tree, hf_h245_h263_resolution);
}

static const per_sequence_t H263VideoMode_sequence[] = {
  { "resolution"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_h263_resolution },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate_1_19200 },
  { "unrestrictedVector"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_unrestrictedVector },
  { "arithmeticCoding"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_arithmeticCoding },
  { "advancedPrediction"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_advancedPrediction },
  { "pbFrames"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pbFrames },
  { "errorCompensation"           , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_errorCompensation },
  { "enhancementLayerInfo"        , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_enhancementLayerInfo },
  { "h263Options"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_h263Options },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H263VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H263VideoMode, H263VideoMode_sequence);

  return offset;
}
static int dissect_h263VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H263VideoMode(tvb, offset, pinfo, tree, hf_h245_h263VideoMode);
}

static const per_sequence_t IS11172VideoMode_sequence[] = {
  { "constrainedBitstream"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_constrainedBitstream },
  { "videoBitRate"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_videoBitRate },
  { "vbvBufferSize"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_vbvBufferSize },
  { "samplesPerLine"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_samplesPerLine },
  { "linesPerFrame"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_linesPerFrame },
  { "pictureRate"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_pictureRate },
  { "luminanceSampleRate"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_luminanceSampleRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS11172VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS11172VideoMode, IS11172VideoMode_sequence);

  return offset;
}
static int dissect_is11172VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS11172VideoMode(tvb, offset, pinfo, tree, hf_h245_is11172VideoMode);
}


static const value_string h245_VideoMode_vals[] = {
  {   0, "nonStandard" },
  {   1, "h261VideoMode" },
  {   2, "h262VideoMode" },
  {   3, "h263VideoMode" },
  {   4, "is11172VideoMode" },
  {   5, "genericVideoMode" },
  { 0, NULL }
};

static const per_choice_t VideoMode_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "h261VideoMode"               , ASN1_EXTENSION_ROOT    , dissect_h261VideoMode },
  {   2, "h262VideoMode"               , ASN1_EXTENSION_ROOT    , dissect_h262VideoMode },
  {   3, "h263VideoMode"               , ASN1_EXTENSION_ROOT    , dissect_h263VideoMode },
  {   4, "is11172VideoMode"            , ASN1_EXTENSION_ROOT    , dissect_is11172VideoMode },
  {   5, "genericVideoMode"            , ASN1_NOT_EXTENSION_ROOT, dissect_genericVideoMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_VideoMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_VideoMode, VideoMode_choice, "VideoMode",
                              &value);
  codec_type = val_to_str(value, h245_VideoMode_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, val_to_str(value, h245_VideoMode_vals, "ukn"));

  return offset;
}
static int dissect_videoMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoMode(tvb, offset, pinfo, tree, hf_h245_videoMode);
}


static const value_string h245_Mode_g7231_vals[] = {
  {   0, "noSilenceSuppressionLowRate" },
  {   1, "noSilenceSuppressionHighRate" },
  {   2, "silenceSuppressionLowRate" },
  {   3, "silenceSuppressionHighRate" },
  { 0, NULL }
};

static const per_choice_t Mode_g7231_choice[] = {
  {   0, "noSilenceSuppressionLowRate" , ASN1_NO_EXTENSIONS     , dissect_noSilenceSuppressionLowRate },
  {   1, "noSilenceSuppressionHighRate", ASN1_NO_EXTENSIONS     , dissect_noSilenceSuppressionHighRate },
  {   2, "silenceSuppressionLowRate"   , ASN1_NO_EXTENSIONS     , dissect_silenceSuppressionLowRate },
  {   3, "silenceSuppressionHighRate"  , ASN1_NO_EXTENSIONS     , dissect_silenceSuppressionHighRate },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mode_g7231(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mode_g7231, Mode_g7231_choice, "Mode_g7231",
                              NULL);

  return offset;
}
static int dissect_g7231_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mode_g7231(tvb, offset, pinfo, tree, hf_h245_g7231_mode);
}


static const value_string h245_T_audioLayer_vals[] = {
  {   0, "audioLayer1" },
  {   1, "audioLayer2" },
  {   2, "audioLayer3" },
  { 0, NULL }
};

static const per_choice_t T_audioLayer_choice[] = {
  {   0, "audioLayer1"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer1Mode },
  {   1, "audioLayer2"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer2Mode },
  {   2, "audioLayer3"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer3Mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_audioLayer(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_audioLayer, T_audioLayer_choice, "T_audioLayer",
                              NULL);

  return offset;
}
static int dissect_audioLayer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_audioLayer(tvb, offset, pinfo, tree, hf_h245_audioLayer);
}


static const value_string h245_T_audioSampling_vals[] = {
  {   0, "audioSampling32k" },
  {   1, "audioSampling44k1" },
  {   2, "audioSampling48k" },
  { 0, NULL }
};

static const per_choice_t T_audioSampling_choice[] = {
  {   0, "audioSampling32k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling32kMode },
  {   1, "audioSampling44k1"           , ASN1_NO_EXTENSIONS     , dissect_audioSampling44k1Mode },
  {   2, "audioSampling48k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling48kMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_audioSampling(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_audioSampling, T_audioSampling_choice, "T_audioSampling",
                              NULL);

  return offset;
}
static int dissect_audioSampling(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_audioSampling(tvb, offset, pinfo, tree, hf_h245_audioSampling);
}


static const value_string h245_IS11172_multichannelType_vals[] = {
  {   0, "singleChannel" },
  {   1, "twoChannelStereo" },
  {   2, "twoChannelDual" },
  { 0, NULL }
};

static const per_choice_t IS11172_multichannelType_choice[] = {
  {   0, "singleChannel"               , ASN1_NO_EXTENSIONS     , dissect_singleChannelMode },
  {   1, "twoChannelStereo"            , ASN1_NO_EXTENSIONS     , dissect_twoChannelStereo },
  {   2, "twoChannelDual"              , ASN1_NO_EXTENSIONS     , dissect_twoChannelDual },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IS11172_multichannelType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IS11172_multichannelType, IS11172_multichannelType_choice, "IS11172_multichannelType",
                              NULL);

  return offset;
}
static int dissect_is11172multichannelType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS11172_multichannelType(tvb, offset, pinfo, tree, hf_h245_is11172multichannelType);
}

static const per_sequence_t IS11172AudioMode_sequence[] = {
  { "audioLayer"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayer },
  { "audioSampling"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSampling },
  { "multichannelType"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_is11172multichannelType },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate_1_448 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS11172AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS11172AudioMode, IS11172AudioMode_sequence);

  return offset;
}
static int dissect_is11172AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS11172AudioMode(tvb, offset, pinfo, tree, hf_h245_is11172AudioMode);
}


static const value_string h245_IS13818AudioLayer_vals[] = {
  {   0, "audioLayer1" },
  {   1, "audioLayer2" },
  {   2, "audioLayer3" },
  { 0, NULL }
};

static const per_choice_t IS13818AudioLayer_choice[] = {
  {   0, "audioLayer1"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer1Mode },
  {   1, "audioLayer2"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer2Mode },
  {   2, "audioLayer3"                 , ASN1_NO_EXTENSIONS     , dissect_audioLayer3Mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IS13818AudioLayer(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IS13818AudioLayer, IS13818AudioLayer_choice, "IS13818AudioLayer",
                              NULL);

  return offset;
}
static int dissect_audioLayerMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS13818AudioLayer(tvb, offset, pinfo, tree, hf_h245_audioLayerMode);
}


static const value_string h245_IS13818AudioSampling_vals[] = {
  {   0, "audioSampling16k" },
  {   1, "audioSampling22k05" },
  {   2, "audioSampling24k" },
  {   3, "audioSampling32k" },
  {   4, "audioSampling44k1" },
  {   5, "audioSampling48k" },
  { 0, NULL }
};

static const per_choice_t IS13818AudioSampling_choice[] = {
  {   0, "audioSampling16k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling16kMode },
  {   1, "audioSampling22k05"          , ASN1_NO_EXTENSIONS     , dissect_audioSampling22k05Mode },
  {   2, "audioSampling24k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling24kMode },
  {   3, "audioSampling32k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling32kMode },
  {   4, "audioSampling44k1"           , ASN1_NO_EXTENSIONS     , dissect_audioSampling44k1Mode },
  {   5, "audioSampling48k"            , ASN1_NO_EXTENSIONS     , dissect_audioSampling48kMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IS13818AudioSampling(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IS13818AudioSampling, IS13818AudioSampling_choice, "IS13818AudioSampling",
                              NULL);

  return offset;
}
static int dissect_audioSamplingMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS13818AudioSampling(tvb, offset, pinfo, tree, hf_h245_audioSamplingMode);
}


static const value_string h245_IS13818MultichannelType_vals[] = {
  {   0, "singleChannel" },
  {   1, "twoChannelStereo" },
  {   2, "twoChannelDual" },
  {   3, "threeChannels2-1" },
  {   4, "threeChannels3-0" },
  {   5, "fourChannels2-0-2-0" },
  {   6, "fourChannels2-2" },
  {   7, "fourChannels3-1" },
  {   8, "fiveChannels3-0-2-0" },
  {   9, "fiveChannels3-2" },
  { 0, NULL }
};

static const per_choice_t IS13818MultichannelType_choice[] = {
  {   0, "singleChannel"               , ASN1_NO_EXTENSIONS     , dissect_singleChannelMode },
  {   1, "twoChannelStereo"            , ASN1_NO_EXTENSIONS     , dissect_twoChannelStereo },
  {   2, "twoChannelDual"              , ASN1_NO_EXTENSIONS     , dissect_twoChannelDual },
  {   3, "threeChannels2-1"            , ASN1_NO_EXTENSIONS     , dissect_threeChannels2_1Mode },
  {   4, "threeChannels3-0"            , ASN1_NO_EXTENSIONS     , dissect_threeChannels3_0Mode },
  {   5, "fourChannels2-0-2-0"         , ASN1_NO_EXTENSIONS     , dissect_fourChannels2_0_2_0Mode },
  {   6, "fourChannels2-2"             , ASN1_NO_EXTENSIONS     , dissect_fourChannels2_2Mode },
  {   7, "fourChannels3-1"             , ASN1_NO_EXTENSIONS     , dissect_fourChannels3_1Mode },
  {   8, "fiveChannels3-0-2-0"         , ASN1_NO_EXTENSIONS     , dissect_fiveChannels3_0_2_0Mode },
  {   9, "fiveChannels3-2"             , ASN1_NO_EXTENSIONS     , dissect_fiveChannels3_2Mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IS13818MultichannelType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IS13818MultichannelType, IS13818MultichannelType_choice, "IS13818MultichannelType",
                              NULL);

  return offset;
}
static int dissect_is13818MultichannelType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS13818MultichannelType(tvb, offset, pinfo, tree, hf_h245_is13818MultichannelType);
}

static const per_sequence_t IS13818AudioMode_sequence[] = {
  { "audioLayer"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioLayerMode },
  { "audioSampling"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_audioSamplingMode },
  { "multichannelType"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_is13818MultichannelType },
  { "lowFrequencyEnhancement"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lowFrequencyEnhancement },
  { "multilingual"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multilingual },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate2_1_1130 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_IS13818AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_IS13818AudioMode, IS13818AudioMode_sequence);

  return offset;
}
static int dissect_is13818AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IS13818AudioMode(tvb, offset, pinfo, tree, hf_h245_is13818AudioMode);
}

static const per_sequence_t G7231AnnexCMode_sequence[] = {
  { "maxAl-sduAudioFrames"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxAl_sduAudioFrames },
  { "silenceSuppression"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_silenceSuppression },
  { "g723AnnexCAudioMode"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_g723AnnexCAudioMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_G7231AnnexCMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_G7231AnnexCMode, G7231AnnexCMode_sequence);

  return offset;
}
static int dissect_g7231AnnexCMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_G7231AnnexCMode(tvb, offset, pinfo, tree, hf_h245_g7231AnnexCMode);
}

static const per_sequence_t VBDMode_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_vbd_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_VBDMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_VBDMode, VBDMode_sequence);

  return offset;
}
static int dissect_vbd_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VBDMode(tvb, offset, pinfo, tree, hf_h245_vbd_mode);
}


static const value_string h245_AudioMode_vals[] = {
  {   0, "nonStandard" },
  {   1, "g711Alaw64k" },
  {   2, "g711Alaw56k" },
  {   3, "g711Ulaw64k" },
  {   4, "g711Ulaw56k" },
  {   5, "g722-64k" },
  {   6, "g722-56k" },
  {   7, "g722-48k" },
  {   8, "g728" },
  {   9, "g729" },
  {  10, "g729AnnexA" },
  {  11, "g7231" },
  {  12, "is11172AudioMode" },
  {  13, "is13818AudioMode" },
  {  14, "g729wAnnexB" },
  {  15, "g729AnnexAwAnnexB" },
  {  16, "g7231AnnexCMode" },
  {  17, "gsmFullRate" },
  {  18, "gsmHalfRate" },
  {  19, "gsmEnhancedFullRate" },
  {  20, "genericAudioMode" },
  {  21, "g729Extensions" },
  {  22, "vbd" },
  { 0, NULL }
};

static const per_choice_t AudioMode_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "g711Alaw64k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Alaw64k_mode },
  {   2, "g711Alaw56k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Alaw56k_mode },
  {   3, "g711Ulaw64k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Ulaw64k_mode },
  {   4, "g711Ulaw56k"                 , ASN1_EXTENSION_ROOT    , dissect_g711Ulaw56k_mode },
  {   5, "g722-64k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_64k_mode },
  {   6, "g722-56k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_56k_mode },
  {   7, "g722-48k"                    , ASN1_EXTENSION_ROOT    , dissect_g722_48k_mode },
  {   8, "g728"                        , ASN1_EXTENSION_ROOT    , dissect_g728_mode },
  {   9, "g729"                        , ASN1_EXTENSION_ROOT    , dissect_g729_mode },
  {  10, "g729AnnexA"                  , ASN1_EXTENSION_ROOT    , dissect_g729AnnexA_mode },
  {  11, "g7231"                       , ASN1_EXTENSION_ROOT    , dissect_g7231_mode },
  {  12, "is11172AudioMode"            , ASN1_EXTENSION_ROOT    , dissect_is11172AudioMode },
  {  13, "is13818AudioMode"            , ASN1_EXTENSION_ROOT    , dissect_is13818AudioMode },
  {  14, "g729wAnnexB"                 , ASN1_NOT_EXTENSION_ROOT, dissect_g729wAnnexB },
  {  15, "g729AnnexAwAnnexB"           , ASN1_NOT_EXTENSION_ROOT, dissect_g729AnnexAwAnnexB },
  {  16, "g7231AnnexCMode"             , ASN1_NOT_EXTENSION_ROOT, dissect_g7231AnnexCMode },
  {  17, "gsmFullRate"                 , ASN1_NOT_EXTENSION_ROOT, dissect_gsmFullRate },
  {  18, "gsmHalfRate"                 , ASN1_NOT_EXTENSION_ROOT, dissect_gsmHalfRate },
  {  19, "gsmEnhancedFullRate"         , ASN1_NOT_EXTENSION_ROOT, dissect_gsmEnhancedFullRate },
  {  20, "genericAudioMode"            , ASN1_NOT_EXTENSION_ROOT, dissect_genericAudioMode },
  {  21, "g729Extensions"              , ASN1_NOT_EXTENSION_ROOT, dissect_g729Extensions },
  {  22, "vbd"                         , ASN1_NOT_EXTENSION_ROOT, dissect_vbd_mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AudioMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AudioMode, AudioMode_choice, "AudioMode",
                              &value);
  codec_type = val_to_str(value, h245_AudioMode_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, val_to_str(value, h245_AudioMode_vals, "ukn"));

  return offset;
}

static const per_sequence_t T38faxApp_sequence[] = {
  { "t38FaxProtocol"              , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t38FaxProtocol },
  { "t38FaxProfile"               , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_t38FaxProfile },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T38faxApp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T38faxApp, T38faxApp_sequence);

  return offset;
}
static int dissect_t38faxDataProtocolCapability(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T38faxApp(tvb, offset, pinfo, tree, hf_h245_t38faxDataProtocolCapability);
}


static const value_string h245_DataModeApplication_vals[] = {
  {   0, "nonStandard" },
  {   1, "t120" },
  {   2, "dsm-cc" },
  {   3, "userData" },
  {   4, "t84" },
  {   5, "t434" },
  {   6, "h224" },
  {   7, "nlpid" },
  {   8, "dsvdControl" },
  {   9, "h222DataPartitioning" },
  {  10, "t30fax" },
  {  11, "t140" },
  {  12, "t38fax" },
  {  13, "genericDataMode" },
  { 0, NULL }
};

static const per_choice_t DataModeApplication_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "t120"                        , ASN1_EXTENSION_ROOT    , dissect_t120 },
  {   2, "dsm-cc"                      , ASN1_EXTENSION_ROOT    , dissect_dsm_cc },
  {   3, "userData"                    , ASN1_EXTENSION_ROOT    , dissect_userData },
  {   4, "t84"                         , ASN1_EXTENSION_ROOT    , dissect_t84DataProtocolCapability },
  {   5, "t434"                        , ASN1_EXTENSION_ROOT    , dissect_t434 },
  {   6, "h224"                        , ASN1_EXTENSION_ROOT    , dissect_h224 },
  {   7, "nlpid"                       , ASN1_EXTENSION_ROOT    , dissect_nlpid },
  {   8, "dsvdControl"                 , ASN1_EXTENSION_ROOT    , dissect_dsvdControl },
  {   9, "h222DataPartitioning"        , ASN1_EXTENSION_ROOT    , dissect_h222DataPartitioning },
  {  10, "t30fax"                      , ASN1_NOT_EXTENSION_ROOT, dissect_t30fax },
  {  11, "t140"                        , ASN1_NOT_EXTENSION_ROOT, dissect_t140 },
  {  12, "t38fax"                      , ASN1_NOT_EXTENSION_ROOT, dissect_t38faxDataProtocolCapability },
  {  13, "genericDataMode"             , ASN1_NOT_EXTENSION_ROOT, dissect_genericDataMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_DataModeApplication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_DataModeApplication, DataModeApplication_choice, "DataModeApplication",
                              &value);
  codec_type = val_to_str(value, h245_DataModeApplication_vals, "<unknown>");
		if (h245_pi != NULL) g_snprintf(h245_pi->frame_label, 50, "%s %s", h245_pi->frame_label, val_to_str(value, h245_DataModeApplication_vals, "ukn"));

  return offset;
}
static int dissect_datamodeapplication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataModeApplication(tvb, offset, pinfo, tree, hf_h245_datamodeapplication);
}

static const per_sequence_t DataMode_sequence[] = {
  { "application"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_datamodeapplication },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate_0_4294967295 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_DataMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_DataMode, DataMode_sequence);

  return offset;
}
static int dissect_dataMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DataMode(tvb, offset, pinfo, tree, hf_h245_dataMode);
}


static const value_string h245_T_mediaMode_vals[] = {
  {   0, "nonStandard" },
  {   1, "videoMode" },
  {   2, "audioMode" },
  {   3, "dataMode" },
  { 0, NULL }
};

static const per_choice_t T_mediaMode_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "videoMode"                   , ASN1_EXTENSION_ROOT    , dissect_videoMode },
  {   2, "audioMode"                   , ASN1_EXTENSION_ROOT    , dissect_audioMode },
  {   3, "dataMode"                    , ASN1_EXTENSION_ROOT    , dissect_dataMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_mediaMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_mediaMode, T_mediaMode_choice, "T_mediaMode",
                              NULL);

  return offset;
}
static int dissect_mediaMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mediaMode(tvb, offset, pinfo, tree, hf_h245_mediaMode);
}

static const per_sequence_t H235Mode_sequence[] = {
  { "encryptionAuthenticationAndIntegrity", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_encryptionAuthenticationAndIntegrity },
  { "mediaMode"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mediaMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H235Mode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H235Mode, H235Mode_sequence);

  return offset;
}
static int dissect_h235Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H235Mode(tvb, offset, pinfo, tree, hf_h245_h235Mode);
}


static const value_string h245_Re_type_vals[] = {
  {   0, "nonStandard" },
  {   1, "videoMode" },
  {   2, "audioMode" },
  {   3, "dataMode" },
  {   4, "encryptionMode" },
  {   5, "h235Mode" },
  { 0, NULL }
};

static const per_choice_t Re_type_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "videoMode"                   , ASN1_EXTENSION_ROOT    , dissect_videoMode },
  {   2, "audioMode"                   , ASN1_EXTENSION_ROOT    , dissect_audioMode },
  {   3, "dataMode"                    , ASN1_EXTENSION_ROOT    , dissect_dataMode },
  {   4, "encryptionMode"              , ASN1_EXTENSION_ROOT    , dissect_encryptionMode },
  {   5, "h235Mode"                    , ASN1_EXTENSION_ROOT    , dissect_h235Mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Re_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Re_type, Re_type_choice, "Re_type",
                              NULL);

  return offset;
}
static int dissect_re_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Re_type(tvb, offset, pinfo, tree, hf_h245_re_type);
}

static const per_sequence_t RedundancyEncodingDTModeElement_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_re_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingDTModeElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncodingDTModeElement, RedundancyEncodingDTModeElement_sequence);

  return offset;
}
static int dissect_prmary_dtmode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingDTModeElement(tvb, offset, pinfo, tree, hf_h245_prmary_dtmode);
}
static int dissect_secondary2_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingDTModeElement(tvb, offset, pinfo, tree, hf_h245_secondary2_item);
}


static int
dissect_h245_SEQUENCE_OF_RedundancyEncodingDTModeElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_RedundancyEncodingDTModeElement, dissect_secondary2_item);

  return offset;
}
static int dissect_secondary2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_RedundancyEncodingDTModeElement(tvb, offset, pinfo, tree, hf_h245_secondary2);
}

static const per_sequence_t RedundancyEncodingDTMode_sequence[] = {
  { "redundancyEncodingMethod"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_redundancyEncodingMethod },
  { "primary"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_prmary_dtmode },
  { "secondary2"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_secondary2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingDTMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncodingDTMode, RedundancyEncodingDTMode_sequence);

  return offset;
}
static int dissect_redundancyEncodingDTMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingDTMode(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingDTMode);
}

static const per_sequence_t MultiplePayloadStreamElementMode_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplePayloadStreamElementMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplePayloadStreamElementMode, MultiplePayloadStreamElementMode_sequence);

  return offset;
}
static int dissect_mpsmElements_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplePayloadStreamElementMode(tvb, offset, pinfo, tree, hf_h245_mpsmElements_item);
}


static int
dissect_h245_SEQUENCE_OF_MultiplePayloadStreamElementMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_MultiplePayloadStreamElementMode, dissect_mpsmElements_item);

  return offset;
}
static int dissect_mpsmElements(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_MultiplePayloadStreamElementMode(tvb, offset, pinfo, tree, hf_h245_mpsmElements);
}

static const per_sequence_t MultiplePayloadStreamMode_sequence[] = {
  { "mpsmElements"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mpsmElements },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplePayloadStreamMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplePayloadStreamMode, MultiplePayloadStreamMode_sequence);

  return offset;
}
static int dissect_multiplePayloadStreamMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplePayloadStreamMode(tvb, offset, pinfo, tree, hf_h245_multiplePayloadStreamMode);
}


static const value_string h245_FEC_mode_vals[] = {
  {   0, "redundancyEncoding" },
  {   1, "separateStream" },
  { 0, NULL }
};

static const per_choice_t FEC_mode_choice[] = {
  {   0, "redundancyEncoding"          , ASN1_EXTENSION_ROOT    , dissect_redundancyEncodingFlag },
  {   1, "separateStream"              , ASN1_EXTENSION_ROOT    , dissect_separateStream },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FEC_mode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FEC_mode, FEC_mode_choice, "FEC_mode",
                              NULL);

  return offset;
}
static int dissect_fec_mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FEC_mode(tvb, offset, pinfo, tree, hf_h245_fec_mode);
}

static const per_sequence_t T_rfc2733Mode_sequence[] = {
  { "mode"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fec_mode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_rfc2733Mode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_rfc2733Mode, T_rfc2733Mode_sequence);

  return offset;
}
static int dissect_rfc2733Mode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_rfc2733Mode(tvb, offset, pinfo, tree, hf_h245_rfc2733Mode);
}


static const value_string h245_FECMode_vals[] = {
  {   0, "rfc2733Mode" },
  { 0, NULL }
};

static const per_choice_t FECMode_choice[] = {
  {   0, "rfc2733Mode"                 , ASN1_EXTENSION_ROOT    , dissect_rfc2733Mode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FECMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FECMode, FECMode_choice, "FECMode",
                              NULL);

  return offset;
}
static int dissect_fecMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FECMode(tvb, offset, pinfo, tree, hf_h245_fecMode);
}


static const value_string h245_ModeElementType_vals[] = {
  {   0, "nonStandard" },
  {   1, "videoMode" },
  {   2, "audioMode" },
  {   3, "dataMode" },
  {   4, "encryptionMode" },
  {   5, "h235Mode" },
  {   6, "multiplexedStreamMode" },
  {   7, "redundancyEncodingDTMode" },
  {   8, "multiplePayloadStreamMode" },
  {   9, "fecMode" },
  { 0, NULL }
};

static const per_choice_t ModeElementType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "videoMode"                   , ASN1_EXTENSION_ROOT    , dissect_videoMode },
  {   2, "audioMode"                   , ASN1_EXTENSION_ROOT    , dissect_audioMode },
  {   3, "dataMode"                    , ASN1_EXTENSION_ROOT    , dissect_dataMode },
  {   4, "encryptionMode"              , ASN1_EXTENSION_ROOT    , dissect_encryptionMode },
  {   5, "h235Mode"                    , ASN1_NOT_EXTENSION_ROOT, dissect_h235Mode },
  {   6, "multiplexedStreamMode"       , ASN1_NOT_EXTENSION_ROOT, dissect_multiplexedStreamMode },
  {   7, "redundancyEncodingDTMode"    , ASN1_NOT_EXTENSION_ROOT, dissect_redundancyEncodingDTMode },
  {   8, "multiplePayloadStreamMode"   , ASN1_NOT_EXTENSION_ROOT, dissect_multiplePayloadStreamMode },
  {   9, "fecMode"                     , ASN1_NOT_EXTENSION_ROOT, dissect_fecMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ModeElementType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ModeElementType, ModeElementType_choice, "ModeElementType",
                              NULL);

  return offset;
}


static const value_string h245_AdaptationLayerType_vals[] = {
  {   0, "nonStandard" },
  {   1, "al1Framed" },
  {   2, "al1NotFramed" },
  {   3, "al2WithoutSequenceNumbers" },
  {   4, "al2WithSequenceNumbers" },
  {   5, "al3" },
  {   6, "al1M" },
  {   7, "al2M" },
  {   8, "al3M" },
  { 0, NULL }
};

static const per_choice_t AdaptationLayerType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "al1Framed"                   , ASN1_EXTENSION_ROOT    , dissect_al1Framed },
  {   2, "al1NotFramed"                , ASN1_EXTENSION_ROOT    , dissect_al1NotFramed },
  {   3, "al2WithoutSequenceNumbers"   , ASN1_EXTENSION_ROOT    , dissect_al2WithoutSequenceNumbers },
  {   4, "al2WithSequenceNumbers"      , ASN1_EXTENSION_ROOT    , dissect_al2WithSequenceNumbers },
  {   5, "al3"                         , ASN1_EXTENSION_ROOT    , dissect_al3 },
  {   6, "al1M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al1M },
  {   7, "al2M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al2M },
  {   8, "al3M"                        , ASN1_NOT_EXTENSION_ROOT, dissect_al3M },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_AdaptationLayerType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_AdaptationLayerType, AdaptationLayerType_choice, "AdaptationLayerType",
                              NULL);

  return offset;
}
static int dissect_adaptationLayer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AdaptationLayerType(tvb, offset, pinfo, tree, hf_h245_adaptationLayer);
}

static const per_sequence_t H223ModeParameters_sequence[] = {
  { "adaptationLayerType"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_adaptationLayer },
  { "segmentableFlag"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_segmentableFlag },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223ModeParameters, H223ModeParameters_sequence);

  return offset;
}
static int dissect_h223ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223ModeParameters(tvb, offset, pinfo, tree, hf_h245_h223ModeParameters);
}


static const value_string h245_V76ModeParameters_vals[] = {
  {   0, "suspendResumewAddress" },
  {   1, "suspendResumewoAddress" },
  { 0, NULL }
};

static const per_choice_t V76ModeParameters_choice[] = {
  {   0, "suspendResumewAddress"       , ASN1_EXTENSION_ROOT    , dissect_suspendResumewAddress },
  {   1, "suspendResumewoAddress"      , ASN1_EXTENSION_ROOT    , dissect_suspendResumewoAddress },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_V76ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_V76ModeParameters, V76ModeParameters_choice, "V76ModeParameters",
                              NULL);

  return offset;
}
static int dissect_v76ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_V76ModeParameters(tvb, offset, pinfo, tree, hf_h245_v76ModeParameters);
}


static const value_string h245_T_secondaryEncoding_vals[] = {
  {   0, "nonStandard" },
  {   1, "audioData" },
  { 0, NULL }
};

static const per_choice_t T_secondaryEncoding_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "audioData"                   , ASN1_EXTENSION_ROOT    , dissect_audioMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_secondaryEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_secondaryEncoding, T_secondaryEncoding_choice, "T_secondaryEncoding",
                              NULL);

  return offset;
}
static int dissect_secondaryEncoding(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_secondaryEncoding(tvb, offset, pinfo, tree, hf_h245_secondaryEncoding);
}

static const per_sequence_t RedundancyEncodingMode_sequence[] = {
  { "redundancyEncodingMethod"    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_redundancyEncodingMethod },
  { "secondaryEncoding"           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_secondaryEncoding },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RedundancyEncodingMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RedundancyEncodingMode, RedundancyEncodingMode_sequence);

  return offset;
}
static int dissect_redundancyEncodingMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RedundancyEncodingMode(tvb, offset, pinfo, tree, hf_h245_redundancyEncodingMode);
}

static const per_sequence_t H2250ModeParameters_sequence[] = {
  { "redundancyEncodingMode"      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_redundancyEncodingMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H2250ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H2250ModeParameters, H2250ModeParameters_sequence);

  return offset;
}
static int dissect_h2250ModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H2250ModeParameters(tvb, offset, pinfo, tree, hf_h245_h2250ModeParameters);
}

static const per_sequence_t MultiplexedStreamModeParameters_sequence[] = {
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexedStreamModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexedStreamModeParameters, MultiplexedStreamModeParameters_sequence);

  return offset;
}
static int dissect_multiplexedStreamModeParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexedStreamModeParameters(tvb, offset, pinfo, tree, hf_h245_multiplexedStreamModeParameters);
}

static const per_sequence_t ModeElement_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_type },
  { "h223ModeParameters"          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_h223ModeParameters },
  { "v76ModeParameters"           , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_v76ModeParameters },
  { "h2250ModeParameters"         , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_h2250ModeParameters },
  { "genericModeParameters"       , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_genericModeParameters },
  { "multiplexedStreamModeParameters", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_multiplexedStreamModeParameters },
  { "logicalChannelNumber"        , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_logicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_ModeElement(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_ModeElement, ModeElement_sequence);

  return offset;
}
static int dissect_ModeDescription_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ModeElement(tvb, offset, pinfo, tree, hf_h245_ModeDescription_item);
}


static int
dissect_h245_ModeDescription(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_ModeDescription, dissect_ModeDescription_item,
                                          1, 256);

  return offset;
}
static int dissect_requestedModes_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ModeDescription(tvb, offset, pinfo, tree, hf_h245_requestedModes_item);
}


static int
dissect_h245_SEQUENCE_SIZE_1_256_OF_ModeDescription(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_SEQUENCE_SIZE_1_256_OF_ModeDescription, dissect_requestedModes_item,
                                               1, 256);

  return offset;
}
static int dissect_requestedModes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_SIZE_1_256_OF_ModeDescription(tvb, offset, pinfo, tree, hf_h245_requestedModes);
}

static const per_sequence_t RequestMode_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "requestedModes"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_requestedModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMode, RequestMode_sequence);

  return offset;
}
static int dissect_requestMode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMode(tvb, offset, pinfo, tree, hf_h245_requestMode);
}

static const per_sequence_t RoundTripDelayRequest_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RoundTripDelayRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RoundTripDelayRequest, RoundTripDelayRequest_sequence);

  return offset;
}
static int dissect_roundTripDelayRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RoundTripDelayRequest(tvb, offset, pinfo, tree, hf_h245_roundTripDelayRequest);
}


static const value_string h245_Mlr_type_vals[] = {
  {   0, "systemLoop" },
  {   1, "mediaLoop" },
  {   2, "logicalChannelLoop" },
  { 0, NULL }
};

static const per_choice_t Mlr_type_choice[] = {
  {   0, "systemLoop"                  , ASN1_EXTENSION_ROOT    , dissect_systemLoop },
  {   1, "mediaLoop"                   , ASN1_EXTENSION_ROOT    , dissect_mediaLoop },
  {   2, "logicalChannelLoop"          , ASN1_EXTENSION_ROOT    , dissect_logicalChannelLoop },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mlr_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mlr_type, Mlr_type_choice, "Mlr_type",
                              NULL);

  return offset;
}
static int dissect_mlr_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mlr_type(tvb, offset, pinfo, tree, hf_h245_mlr_type);
}

static const per_sequence_t MaintenanceLoopRequest_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mlr_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaintenanceLoopRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaintenanceLoopRequest, MaintenanceLoopRequest_sequence);

  return offset;
}
static int dissect_maintenanceLoopRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaintenanceLoopRequest(tvb, offset, pinfo, tree, hf_h245_maintenanceLoopRequest);
}

static const per_sequence_t CommunicationModeRequest_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CommunicationModeRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CommunicationModeRequest, CommunicationModeRequest_sequence);

  return offset;
}
static int dissect_communicationModeRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CommunicationModeRequest(tvb, offset, pinfo, tree, hf_h245_communicationModeRequest);
}

static const per_sequence_t Criteria_sequence[] = {
  { "field"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_field },
  { "value"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Criteria(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Criteria, Criteria_sequence);

  return offset;
}
static int dissect_CertSelectionCriteria_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Criteria(tvb, offset, pinfo, tree, hf_h245_CertSelectionCriteria_item);
}


static int
dissect_h245_CertSelectionCriteria(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                               ett_h245_CertSelectionCriteria, dissect_CertSelectionCriteria_item,
                                               1, 16);

  return offset;
}
static int dissect_certSelectionCriteria(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CertSelectionCriteria(tvb, offset, pinfo, tree, hf_h245_certSelectionCriteria);
}

static const per_sequence_t T_requestTerminalCertificate_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_terminalLabel },
  { "certSelectionCriteria"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_certSelectionCriteria },
  { "sRandom"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sRandom },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_requestTerminalCertificate(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_requestTerminalCertificate, T_requestTerminalCertificate_sequence);

  return offset;
}
static int dissect_requestTerminalCertificate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_requestTerminalCertificate(tvb, offset, pinfo, tree, hf_h245_requestTerminalCertificate);
}


static const value_string h245_RemoteMCRequest_vals[] = {
  {   0, "masterActivate" },
  {   1, "slaveActivate" },
  {   2, "deActivate" },
  { 0, NULL }
};

static const per_choice_t RemoteMCRequest_choice[] = {
  {   0, "masterActivate"              , ASN1_EXTENSION_ROOT    , dissect_masterActivate },
  {   1, "slaveActivate"               , ASN1_EXTENSION_ROOT    , dissect_slaveActivate },
  {   2, "deActivate"                  , ASN1_EXTENSION_ROOT    , dissect_deActivate },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RemoteMCRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RemoteMCRequest, RemoteMCRequest_choice, "RemoteMCRequest",
                              NULL);

  return offset;
}
static int dissect_remoteMCRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RemoteMCRequest(tvb, offset, pinfo, tree, hf_h245_remoteMCRequest);
}


static const value_string h245_ConferenceRequest_vals[] = {
  {   0, "terminalListRequest" },
  {   1, "makeMeChair" },
  {   2, "cancelMakeMeChair" },
  {   3, "dropTerminal" },
  {   4, "requestTerminalID" },
  {   5, "enterH243Password" },
  {   6, "enterH243TerminalID" },
  {   7, "enterH243ConferenceID" },
  {   8, "enterExtensionAddress" },
  {   9, "requestChairTokenOwner" },
  {  10, "requestTerminalCertificate" },
  {  11, "broadcastMyLogicalChannel" },
  {  12, "makeTerminalBroadcaster" },
  {  13, "sendThisSource" },
  {  14, "requestAllTerminalIDs" },
  {  15, "remoteMCRequest" },
  { 0, NULL }
};

static const per_choice_t ConferenceRequest_choice[] = {
  {   0, "terminalListRequest"         , ASN1_EXTENSION_ROOT    , dissect_terminalListRequest },
  {   1, "makeMeChair"                 , ASN1_EXTENSION_ROOT    , dissect_makeMeChair },
  {   2, "cancelMakeMeChair"           , ASN1_EXTENSION_ROOT    , dissect_cancelMakeMeChair },
  {   3, "dropTerminal"                , ASN1_EXTENSION_ROOT    , dissect_dropTerminal },
  {   4, "requestTerminalID"           , ASN1_EXTENSION_ROOT    , dissect_requestTerminalID },
  {   5, "enterH243Password"           , ASN1_EXTENSION_ROOT    , dissect_enterH243Password },
  {   6, "enterH243TerminalID"         , ASN1_EXTENSION_ROOT    , dissect_enterH243TerminalID },
  {   7, "enterH243ConferenceID"       , ASN1_EXTENSION_ROOT    , dissect_enterH243ConferenceID },
  {   8, "enterExtensionAddress"       , ASN1_NOT_EXTENSION_ROOT, dissect_enterExtensionAddress },
  {   9, "requestChairTokenOwner"      , ASN1_NOT_EXTENSION_ROOT, dissect_requestChairTokenOwner },
  {  10, "requestTerminalCertificate"  , ASN1_NOT_EXTENSION_ROOT, dissect_requestTerminalCertificate },
  {  11, "broadcastMyLogicalChannel"   , ASN1_NOT_EXTENSION_ROOT, dissect_broadcastMyLogicalChannel },
  {  12, "makeTerminalBroadcaster"     , ASN1_NOT_EXTENSION_ROOT, dissect_makeTerminalBroadcaster },
  {  13, "sendThisSource"              , ASN1_NOT_EXTENSION_ROOT, dissect_sendThisSource },
  {  14, "requestAllTerminalIDs"       , ASN1_NOT_EXTENSION_ROOT, dissect_requestAllTerminalIDs },
  {  15, "remoteMCRequest"             , ASN1_NOT_EXTENSION_ROOT, dissect_remoteMCRequest },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ConferenceRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ConferenceRequest, ConferenceRequest_choice, "ConferenceRequest",
                              NULL);

  return offset;
}
static int dissect_conferenceRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceRequest(tvb, offset, pinfo, tree, hf_h245_conferenceRequest);
}

static const per_sequence_t CallInformationReq_sequence[] = {
  { "maxNumberOfAdditionalConnections", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maxNumberOfAdditionalConnections },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CallInformationReq(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CallInformationReq, CallInformationReq_sequence);

  return offset;
}
static int dissect_callInformationReq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CallInformationReq(tvb, offset, pinfo, tree, hf_h245_callInformationReq);
}


static int
dissect_h245_NumericString_SIZE_0_40(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_NumericString(tvb, offset, pinfo, tree, hf_index,
                                     0, 40);

  return offset;
}
static int dissect_networkAddressNum(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NumericString_SIZE_0_40(tvb, offset, pinfo, tree, hf_h245_networkAddressNum);
}


static int
dissect_h245_IA5String_SIZE_1_40(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_IA5String(tvb, offset, pinfo, tree, hf_index,
                                 1, 40);

  return offset;
}
static int dissect_subAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IA5String_SIZE_1_40(tvb, offset, pinfo, tree, hf_h245_subAddress);
}


static const value_string h245_DialingInformationNetworkType_vals[] = {
  {   0, "nonStandard" },
  {   1, "n-isdn" },
  {   2, "gstn" },
  {   3, "mobile" },
  { 0, NULL }
};

static const per_choice_t DialingInformationNetworkType_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "n-isdn"                      , ASN1_EXTENSION_ROOT    , dissect_n_isdn },
  {   2, "gstn"                        , ASN1_EXTENSION_ROOT    , dissect_gstn },
  {   3, "mobile"                      , ASN1_NOT_EXTENSION_ROOT, dissect_mobile },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_DialingInformationNetworkType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_DialingInformationNetworkType, DialingInformationNetworkType_choice, "DialingInformationNetworkType",
                              NULL);

  return offset;
}
static int dissect_networkType_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DialingInformationNetworkType(tvb, offset, pinfo, tree, hf_h245_networkType_item);
}


static int
dissect_h245_SET_SIZE_1_255_OF_DialingInformationNetworkType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_255_OF_DialingInformationNetworkType, dissect_networkType_item,
                                          1, 255);

  return offset;
}
static int dissect_networkType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_255_OF_DialingInformationNetworkType(tvb, offset, pinfo, tree, hf_h245_networkType);
}

static const per_sequence_t DialingInformationNumber_sequence[] = {
  { "networkAddress"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_networkAddressNum },
  { "subAddress"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_subAddress },
  { "networkType"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_networkType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_DialingInformationNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_DialingInformationNumber, DialingInformationNumber_sequence);

  return offset;
}
static int dissect_differential_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DialingInformationNumber(tvb, offset, pinfo, tree, hf_h245_differential_item);
}


static int
dissect_h245_SET_SIZE_1_65535_OF_DialingInformationNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_65535_OF_DialingInformationNumber, dissect_differential_item,
                                          1, 65535);

  return offset;
}
static int dissect_differential(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_65535_OF_DialingInformationNumber(tvb, offset, pinfo, tree, hf_h245_differential);
}


static const value_string h245_DialingInformation_vals[] = {
  {   0, "nonStandard" },
  {   1, "differential" },
  {   2, "infoNotAvailable" },
  { 0, NULL }
};

static const per_choice_t DialingInformation_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "differential"                , ASN1_EXTENSION_ROOT    , dissect_differential },
  {   2, "infoNotAvailable"            , ASN1_EXTENSION_ROOT    , dissect_infoNotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_DialingInformation(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_DialingInformation, DialingInformation_choice, "DialingInformation",
                              NULL);

  return offset;
}
static int dissect_dialingInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_DialingInformation(tvb, offset, pinfo, tree, hf_h245_dialingInformation);
}

static const per_sequence_t AddConnectionReq_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "dialingInformation"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dialingInformation },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_AddConnectionReq(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_AddConnectionReq, AddConnectionReq_sequence);

  return offset;
}
static int dissect_addConnectionReq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AddConnectionReq(tvb, offset, pinfo, tree, hf_h245_addConnectionReq);
}

static const per_sequence_t ConnectionIdentifier_sequence[] = {
  { "channelTag"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_channelTag },
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNum },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_ConnectionIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_ConnectionIdentifier, ConnectionIdentifier_sequence);

  return offset;
}
static int dissect_connectionIdentifier(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConnectionIdentifier(tvb, offset, pinfo, tree, hf_h245_connectionIdentifier);
}

static const per_sequence_t RemoveConnection_sequence[] = {
  { "connectionIdentifier"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_connectionIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RemoveConnection(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RemoveConnection, RemoveConnection_sequence);

  return offset;
}


static int
dissect_h245_RemoveConnectionReq(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_h245_RemoveConnection(tvb, offset, pinfo, tree, hf_index);

  return offset;
}
static int dissect_removeConnectionReq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RemoveConnectionReq(tvb, offset, pinfo, tree, hf_h245_removeConnectionReq);
}


static const value_string h245_T_requestType_vals[] = {
  {   0, "currentIntervalInformation" },
  {   1, "requestedInterval" },
  { 0, NULL }
};

static const per_choice_t T_requestType_choice[] = {
  {   0, "currentIntervalInformation"  , ASN1_EXTENSION_ROOT    , dissect_currentIntervalInformation },
  {   1, "requestedInterval"           , ASN1_EXTENSION_ROOT    , dissect_requestedInterval },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_requestType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_requestType, T_requestType_choice, "T_requestType",
                              NULL);

  return offset;
}
static int dissect_requestType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_requestType(tvb, offset, pinfo, tree, hf_h245_requestType);
}

static const per_sequence_t MaximumHeaderIntervalReq_sequence[] = {
  { "requestType"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_requestType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaximumHeaderIntervalReq(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaximumHeaderIntervalReq, MaximumHeaderIntervalReq_sequence);

  return offset;
}
static int dissect_maximumHeaderIntervalReq(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaximumHeaderIntervalReq(tvb, offset, pinfo, tree, hf_h245_maximumHeaderIntervalReq);
}


static const value_string h245_MultilinkRequest_vals[] = {
  {   0, "nonStandard" },
  {   1, "callInformation" },
  {   2, "addConnection" },
  {   3, "removeConnection" },
  {   4, "maximumHeaderInterval" },
  { 0, NULL }
};

static const per_choice_t MultilinkRequest_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "callInformation"             , ASN1_EXTENSION_ROOT    , dissect_callInformationReq },
  {   2, "addConnection"               , ASN1_EXTENSION_ROOT    , dissect_addConnectionReq },
  {   3, "removeConnection"            , ASN1_EXTENSION_ROOT    , dissect_removeConnectionReq },
  {   4, "maximumHeaderInterval"       , ASN1_EXTENSION_ROOT    , dissect_maximumHeaderIntervalReq },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultilinkRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultilinkRequest, MultilinkRequest_choice, "MultilinkRequest",
                              NULL);

  return offset;
}
static int dissect_multilinkRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultilinkRequest(tvb, offset, pinfo, tree, hf_h245_multilinkRequest);
}



static int
dissect_h245_MaximumBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 4294967295U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_maximumBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaximumBitRate(tvb, offset, pinfo, tree, hf_h245_maximumBitRate);
}
static int dissect_currentMaximumBitRate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaximumBitRate(tvb, offset, pinfo, tree, hf_h245_currentMaximumBitRate);
}

static const per_sequence_t LogicalChannelRateRequest_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { "maximumBitRate"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumBitRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_LogicalChannelRateRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_LogicalChannelRateRequest, LogicalChannelRateRequest_sequence);

  return offset;
}
static int dissect_logicalChannelRateRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelRateRequest(tvb, offset, pinfo, tree, hf_h245_logicalChannelRateRequest);
}



static int
dissect_h245_T_subMessageIdentifer(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {

guint32 subMessageIdentifer;

  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 127U, &subMessageIdentifer, NULL, FALSE);


  return offset;
}
static int dissect_subMessageIdentifer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_subMessageIdentifer(tvb, offset, pinfo, tree, hf_h245_subMessageIdentifer);
}

static const per_sequence_t GenericMessage_sequence[] = {
  { "messageIdentifier"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_messageIdentifier },
  { "subMessageIdentifer"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_subMessageIdentifer },
  { "messageContent"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_messageContent },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_GenericMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_GenericMessage, GenericMessage_sequence);

  return offset;
}
static int dissect_genericRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericMessage(tvb, offset, pinfo, tree, hf_h245_genericRequest);
}
static int dissect_genericResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericMessage(tvb, offset, pinfo, tree, hf_h245_genericResponse);
}
static int dissect_genericCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericMessage(tvb, offset, pinfo, tree, hf_h245_genericCommand);
}
static int dissect_genericIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_GenericMessage(tvb, offset, pinfo, tree, hf_h245_genericIndication);
}


static const value_string h245_RequestMessage_vals[] = {
  {   0, "nonStandard" },
  {   1, "masterSlaveDetermination" },
  {   2, "terminalCapabilitySet" },
  {   3, "openLogicalChannel" },
  {   4, "closeLogicalChannel" },
  {   5, "requestChannelClose" },
  {   6, "multiplexEntrySend" },
  {   7, "requestMultiplexEntry" },
  {   8, "requestMode" },
  {   9, "roundTripDelayRequest" },
  {  10, "maintenanceLoopRequest" },
  {  11, "communicationModeRequest" },
  {  12, "conferenceRequest" },
  {  13, "multilinkRequest" },
  {  14, "logicalChannelRateRequest" },
  {  15, "genericRequest" },
  { 0, NULL }
};

static const per_choice_t RequestMessage_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "masterSlaveDetermination"    , ASN1_EXTENSION_ROOT    , dissect_masterSlaveDetermination },
  {   2, "terminalCapabilitySet"       , ASN1_EXTENSION_ROOT    , dissect_terminalCapabilitySet },
  {   3, "openLogicalChannel"          , ASN1_EXTENSION_ROOT    , dissect_openLogicalChannel },
  {   4, "closeLogicalChannel"         , ASN1_EXTENSION_ROOT    , dissect_closeLogicalChannel },
  {   5, "requestChannelClose"         , ASN1_EXTENSION_ROOT    , dissect_requestChannelClose },
  {   6, "multiplexEntrySend"          , ASN1_EXTENSION_ROOT    , dissect_multiplexEntrySend },
  {   7, "requestMultiplexEntry"       , ASN1_EXTENSION_ROOT    , dissect_requestMultiplexEntry },
  {   8, "requestMode"                 , ASN1_EXTENSION_ROOT    , dissect_requestMode },
  {   9, "roundTripDelayRequest"       , ASN1_EXTENSION_ROOT    , dissect_roundTripDelayRequest },
  {  10, "maintenanceLoopRequest"      , ASN1_EXTENSION_ROOT    , dissect_maintenanceLoopRequest },
  {  11, "communicationModeRequest"    , ASN1_NOT_EXTENSION_ROOT, dissect_communicationModeRequest },
  {  12, "conferenceRequest"           , ASN1_NOT_EXTENSION_ROOT, dissect_conferenceRequest },
  {  13, "multilinkRequest"            , ASN1_NOT_EXTENSION_ROOT, dissect_multilinkRequest },
  {  14, "logicalChannelRateRequest"   , ASN1_NOT_EXTENSION_ROOT, dissect_logicalChannelRateRequest },
  {  15, "genericRequest"              , ASN1_NOT_EXTENSION_ROOT, dissect_genericRequest },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RequestMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RequestMessage, RequestMessage_choice, "RequestMessage",
                              &value);

	if (check_col(pinfo->cinfo, COL_INFO)){
	        if ( h245_shorttypes == TRUE )
	        {
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_RequestMessage_short_vals, "<unknown>"));
		}
		else
		{
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_RequestMessage_vals, "<unknown>"));
		}
	}

	if (( check_col(pinfo->cinfo, COL_INFO)) && ( codec_type != NULL ) && ( value == 3) ){
		col_append_fstr(pinfo->cinfo, COL_INFO, "(%s) ", codec_type );
	}

        col_set_fence(pinfo->cinfo,COL_INFO);

    /* Add to packet info */

    /* if it is TCS*/
    if ((codec_type != NULL) && ( value == 2))
                g_snprintf(h245_pi->frame_label, 50, "%s (%s) ",val_to_str(value, h245_RequestMessage_short_vals, "UKN"), h245_pi->frame_label);
    else
                g_snprintf(h245_pi->frame_label, 50, "%s ", val_to_str(value, h245_RequestMessage_short_vals, "UKN"));

    g_snprintf(h245_pi->comment, 50, "%s %s ", h245_pi->comment, val_to_str(value, h245_RequestMessage_vals, "<unknown>"));

    /* if it is OLC or RM*/
    if ((codec_type != NULL) && (( value == 3) || ( value == 8)))
                g_snprintf(h245_pi->frame_label, 50, "%s (%s) ", h245_pi->frame_label, codec_type);

  return offset;
}
static int dissect_request(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMessage(tvb, offset, pinfo, tree, hf_h245_request);
}


static const value_string h245_T_decision_vals[] = {
  {   0, "master" },
  {   1, "slave" },
  { 0, NULL }
};

static const per_choice_t T_decision_choice[] = {
  {   0, "master"                      , ASN1_NO_EXTENSIONS     , dissect_master },
  {   1, "slave"                       , ASN1_NO_EXTENSIONS     , dissect_slave },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_decision(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_decision, T_decision_choice, "T_decision",
                              NULL);

  return offset;
}
static int dissect_decision(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_decision(tvb, offset, pinfo, tree, hf_h245_decision);
}

static const per_sequence_t MasterSlaveDeterminationAck_sequence[] = {
  { "decision"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_decision },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MasterSlaveDeterminationAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MasterSlaveDeterminationAck, MasterSlaveDeterminationAck_sequence);


  h245_pi->msg_type = H245_MastSlvDetAck;
  return offset;
}
static int dissect_masterSlaveDeterminationAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MasterSlaveDeterminationAck(tvb, offset, pinfo, tree, hf_h245_masterSlaveDeterminationAck);
}


static const value_string h245_MasterSlaveDeterminationRejectCause_vals[] = {
  {   0, "identicalNumbers" },
  { 0, NULL }
};

static const per_choice_t MasterSlaveDeterminationRejectCause_choice[] = {
  {   0, "identicalNumbers"            , ASN1_EXTENSION_ROOT    , dissect_identicalNumbers },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MasterSlaveDeterminationRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MasterSlaveDeterminationRejectCause, MasterSlaveDeterminationRejectCause_choice, "MasterSlaveDeterminationRejectCause",
                              NULL);

  return offset;
}
static int dissect_msd_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MasterSlaveDeterminationRejectCause(tvb, offset, pinfo, tree, hf_h245_msd_rej_cause);
}

static const per_sequence_t MasterSlaveDeterminationReject_sequence[] = {
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_msd_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MasterSlaveDeterminationReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MasterSlaveDeterminationReject, MasterSlaveDeterminationReject_sequence);


  h245_pi->msg_type = H245_MastSlvDetRjc;
  return offset;
}
static int dissect_masterSlaveDeterminationReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MasterSlaveDeterminationReject(tvb, offset, pinfo, tree, hf_h245_masterSlaveDeterminationReject);
}

static const per_sequence_t TerminalCapabilitySetAck_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalCapabilitySetAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalCapabilitySetAck, TerminalCapabilitySetAck_sequence);


  h245_pi->msg_type = H245_TermCapSetAck;
  return offset;
}
static int dissect_terminalCapabilitySetAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalCapabilitySetAck(tvb, offset, pinfo, tree, hf_h245_terminalCapabilitySetAck);
}


static const value_string h245_T_tableEntryCapacityExceeded_vals[] = {
  {   0, "highestEntryNumberProcessed" },
  {   1, "noneProcessed" },
  { 0, NULL }
};

static const per_choice_t T_tableEntryCapacityExceeded_choice[] = {
  {   0, "highestEntryNumberProcessed" , ASN1_NO_EXTENSIONS     , dissect_highestEntryNumberProcessed },
  {   1, "noneProcessed"               , ASN1_NO_EXTENSIONS     , dissect_noneProcessed },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_tableEntryCapacityExceeded(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_tableEntryCapacityExceeded, T_tableEntryCapacityExceeded_choice, "T_tableEntryCapacityExceeded",
                              NULL);

  return offset;
}
static int dissect_tableEntryCapacityExceeded(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_tableEntryCapacityExceeded(tvb, offset, pinfo, tree, hf_h245_tableEntryCapacityExceeded);
}


static const value_string h245_TerminalCapabilitySetRejectCause_vals[] = {
  {   0, "unspecified" },
  {   1, "undefinedTableEntryUsed" },
  {   2, "descriptorCapacityExceeded" },
  {   3, "tableEntryCapacityExceeded" },
  { 0, NULL }
};

static const per_choice_t TerminalCapabilitySetRejectCause_choice[] = {
  {   0, "unspecified"                 , ASN1_EXTENSION_ROOT    , dissect_unspecified },
  {   1, "undefinedTableEntryUsed"     , ASN1_EXTENSION_ROOT    , dissect_undefinedTableEntryUsed },
  {   2, "descriptorCapacityExceeded"  , ASN1_EXTENSION_ROOT    , dissect_descriptorCapacityExceeded },
  {   3, "tableEntryCapacityExceeded"  , ASN1_EXTENSION_ROOT    , dissect_tableEntryCapacityExceeded },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_TerminalCapabilitySetRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_TerminalCapabilitySetRejectCause, TerminalCapabilitySetRejectCause_choice, "TerminalCapabilitySetRejectCause",
                              NULL);

  return offset;
}
static int dissect_tcs_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalCapabilitySetRejectCause(tvb, offset, pinfo, tree, hf_h245_tcs_rej_cause);
}

static const per_sequence_t TerminalCapabilitySetReject_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_tcs_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalCapabilitySetReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalCapabilitySetReject, TerminalCapabilitySetReject_sequence);


  h245_pi->msg_type = H245_TermCapSetRjc;
  return offset;
}
static int dissect_terminalCapabilitySetReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalCapabilitySetReject(tvb, offset, pinfo, tree, hf_h245_terminalCapabilitySetReject);
}


static const value_string h245_T_multiplexParameters_vals[] = {
  {   0, "h222LogicalChannelParameters" },
  {   1, "h2250LogicalChannelParameters" },
  { 0, NULL }
};

static const per_choice_t T_multiplexParameters_choice[] = {
  {   0, "h222LogicalChannelParameters", ASN1_EXTENSION_ROOT    , dissect_h222LogicalChannelParameters },
  {   1, "h2250LogicalChannelParameters", ASN1_NOT_EXTENSION_ROOT, dissect_h2250LogicalChannelParameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_multiplexParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_multiplexParameters, T_multiplexParameters_choice, "T_multiplexParameters",
                              NULL);

  return offset;
}
static int dissect_olc_ack_multiplexParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_multiplexParameters(tvb, offset, pinfo, tree, hf_h245_olc_ack_multiplexParameters);
}

static const per_sequence_t OLC_ack_reverseLogicalChannelParameters_sequence[] = {
  { "reverseLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_reverseLogicalChannelNumber },
  { "portNumber"                  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_portNumber },
  { "multiplexParameters"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_olc_ack_multiplexParameters },
  { "replacementFor"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_replacementFor },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_OLC_ack_reverseLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OLC_ack_reverseLogicalChannelParameters, OLC_ack_reverseLogicalChannelParameters_sequence);

  return offset;
}
static int dissect_olc_ack_reverseLogicalChannelParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OLC_ack_reverseLogicalChannelParameters(tvb, offset, pinfo, tree, hf_h245_olc_ack_reverseLogicalChannelParameters);
}


static int
dissect_h245_Ack_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_channel = TRUE;
  offset = dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_index);



	media_channel = FALSE;
  return offset;
}
static int dissect_ack_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ack_mediaChannel(tvb, offset, pinfo, tree, hf_h245_ack_mediaChannel);
}


static int
dissect_h245_Ack_mediaControlChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_control_channel = TRUE;
  offset = dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_index);



	media_control_channel = FALSE;
  return offset;
}
static int dissect_ack_mediaControlChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ack_mediaControlChannel(tvb, offset, pinfo, tree, hf_h245_ack_mediaControlChannel);
}

static const per_sequence_t H2250LogicalChannelAckParameters_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandardParams },
  { "sessionID"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_sessionID },
  { "mediaChannel"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ack_mediaChannel },
  { "mediaControlChannel"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_ack_mediaControlChannel },
  { "dynamicRTPPayloadType"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_dynamicRTPPayloadType },
  { "flowControlToZero"           , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_flowControlToZero },
  { "portNumber"                  , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_portNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H2250LogicalChannelAckParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H2250LogicalChannelAckParameters, H2250LogicalChannelAckParameters_sequence);

  return offset;
}
static int dissect_h2250LogicalChannelAckParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H2250LogicalChannelAckParameters(tvb, offset, pinfo, tree, hf_h245_h2250LogicalChannelAckParameters);
}


static const value_string h245_T_forwardMultiplexAckParameters_vals[] = {
  {   0, "h2250LogicalChannelAckParameters" },
  { 0, NULL }
};

static const per_choice_t T_forwardMultiplexAckParameters_choice[] = {
  {   0, "h2250LogicalChannelAckParameters", ASN1_EXTENSION_ROOT    , dissect_h2250LogicalChannelAckParameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_forwardMultiplexAckParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {


	media_channel = FALSE;
	media_control_channel = FALSE;

  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_forwardMultiplexAckParameters, T_forwardMultiplexAckParameters_choice, "T_forwardMultiplexAckParameters",
                              NULL);

	
	if((!pinfo->fd->flags.visited) && ipv4_address!=0 && ipv4_port!=0 && rtp_handle){
		address src_addr;

		src_addr.type=AT_IPv4;
		src_addr.len=4;
		src_addr.data=(char *)&ipv4_address;

		rtp_add_address(pinfo, &src_addr, ipv4_port, 0, "H245", pinfo->fd->num, NULL);
	}
	if((!pinfo->fd->flags.visited) && rtcp_ipv4_address!=0 && rtcp_ipv4_port!=0 && rtcp_handle){
		address src_addr;

		src_addr.type=AT_IPv4;
		src_addr.len=4;
		src_addr.data=(char *)&rtcp_ipv4_address;

		rtcp_add_address(pinfo, &src_addr, rtcp_ipv4_port, 0, "H245", pinfo->fd->num);
	}

  return offset;
}
static int dissect_forwardMultiplexAckParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_forwardMultiplexAckParameters(tvb, offset, pinfo, tree, hf_h245_forwardMultiplexAckParameters);
}

static const per_sequence_t OpenLogicalChannelAck_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "reverseLogicalChannelParameters", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_olc_ack_reverseLogicalChannelParameters },
  { "separateStack"               , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_separateStack },
  { "forwardMultiplexAckParameters", ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_forwardMultiplexAckParameters },
  { "encryptionSync"              , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_encryptionSync },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_OpenLogicalChannelAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OpenLogicalChannelAck, OpenLogicalChannelAck_sequence);


  h245_pi->msg_type = H245_OpenLogChnAck;
  return offset;
}
static int dissect_openLogicalChannelAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OpenLogicalChannelAck(tvb, offset, pinfo, tree, hf_h245_openLogicalChannelAck);
}


static const value_string h245_OpenLogicalChannelRejectCause_vals[] = {
  {   0, "unspecified" },
  {   1, "unsuitableReverseParameters" },
  {   2, "dataTypeNotSupported" },
  {   3, "dataTypeNotAvailable" },
  {   4, "unknownDataType" },
  {   5, "dataTypeALCombinationNotSupported" },
  {   6, "multicastChannelNotAllowed" },
  {   7, "insufficientBandwidth" },
  {   8, "separateStackEstablishmentFailed" },
  {   9, "invalidSessionID" },
  {  10, "masterSlaveConflict" },
  {  11, "waitForCommunicationMode" },
  {  12, "invalidDependentChannel" },
  {  13, "replacementForRejected" },
  { 0, NULL }
};

static const per_choice_t OpenLogicalChannelRejectCause_choice[] = {
  {   0, "unspecified"                 , ASN1_EXTENSION_ROOT    , dissect_unspecified },
  {   1, "unsuitableReverseParameters" , ASN1_EXTENSION_ROOT    , dissect_unsuitableReverseParameters },
  {   2, "dataTypeNotSupported"        , ASN1_EXTENSION_ROOT    , dissect_dataTypeNotSupported },
  {   3, "dataTypeNotAvailable"        , ASN1_EXTENSION_ROOT    , dissect_dataTypeNotAvailable },
  {   4, "unknownDataType"             , ASN1_EXTENSION_ROOT    , dissect_unknownDataType },
  {   5, "dataTypeALCombinationNotSupported", ASN1_EXTENSION_ROOT    , dissect_dataTypeALCombinationNotSupported },
  {   6, "multicastChannelNotAllowed"  , ASN1_NOT_EXTENSION_ROOT, dissect_multicastChannelNotAllowed },
  {   7, "insufficientBandwidth"       , ASN1_NOT_EXTENSION_ROOT, dissect_insufficientBandwidth },
  {   8, "separateStackEstablishmentFailed", ASN1_NOT_EXTENSION_ROOT, dissect_separateStackEstablishmentFailed },
  {   9, "invalidSessionID"            , ASN1_NOT_EXTENSION_ROOT, dissect_invalidSessionID },
  {  10, "masterSlaveConflict"         , ASN1_NOT_EXTENSION_ROOT, dissect_masterSlaveConflict },
  {  11, "waitForCommunicationMode"    , ASN1_NOT_EXTENSION_ROOT, dissect_waitForCommunicationMode },
  {  12, "invalidDependentChannel"     , ASN1_NOT_EXTENSION_ROOT, dissect_invalidDependentChannel },
  {  13, "replacementForRejected"      , ASN1_NOT_EXTENSION_ROOT, dissect_replacementForRejected },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_OpenLogicalChannelRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_OpenLogicalChannelRejectCause, OpenLogicalChannelRejectCause_choice, "OpenLogicalChannelRejectCause",
                              NULL);

  return offset;
}
static int dissect_olc_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OpenLogicalChannelRejectCause(tvb, offset, pinfo, tree, hf_h245_olc_rej_cause);
}

static const per_sequence_t OpenLogicalChannelReject_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_olc_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_OpenLogicalChannelReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OpenLogicalChannelReject, OpenLogicalChannelReject_sequence);


  h245_pi->msg_type = H245_OpenLogChnRjc;
  return offset;
}
static int dissect_openLogicalChannelReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OpenLogicalChannelReject(tvb, offset, pinfo, tree, hf_h245_openLogicalChannelReject);
}

static const per_sequence_t CloseLogicalChannelAck_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CloseLogicalChannelAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CloseLogicalChannelAck, CloseLogicalChannelAck_sequence);


  h245_pi->msg_type = H245_CloseLogChnAck;
  return offset;
}
static int dissect_closeLogicalChannelAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CloseLogicalChannelAck(tvb, offset, pinfo, tree, hf_h245_closeLogicalChannelAck);
}

static const per_sequence_t RequestChannelCloseAck_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestChannelCloseAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestChannelCloseAck, RequestChannelCloseAck_sequence);

  return offset;
}
static int dissect_requestChannelCloseAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestChannelCloseAck(tvb, offset, pinfo, tree, hf_h245_requestChannelCloseAck);
}


static const value_string h245_RequestChannelCloseRejectCause_vals[] = {
  {   0, "unspecified" },
  { 0, NULL }
};

static const per_choice_t RequestChannelCloseRejectCause_choice[] = {
  {   0, "unspecified"                 , ASN1_EXTENSION_ROOT    , dissect_unspecified },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RequestChannelCloseRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RequestChannelCloseRejectCause, RequestChannelCloseRejectCause_choice, "RequestChannelCloseRejectCause",
                              NULL);

  return offset;
}
static int dissect_req_chan_clos_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestChannelCloseRejectCause(tvb, offset, pinfo, tree, hf_h245_req_chan_clos_rej_cause);
}

static const per_sequence_t RequestChannelCloseReject_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_req_chan_clos_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestChannelCloseReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestChannelCloseReject, RequestChannelCloseReject_sequence);

  return offset;
}
static int dissect_requestChannelCloseReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestChannelCloseReject(tvb, offset, pinfo, tree, hf_h245_requestChannelCloseReject);
}

static const per_sequence_t MultiplexEntrySendAck_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "multiplexTableEntryNumber"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexTableEntryNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntrySendAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntrySendAck, MultiplexEntrySendAck_sequence);

  return offset;
}
static int dissect_multiplexEntrySendAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntrySendAck(tvb, offset, pinfo, tree, hf_h245_multiplexEntrySendAck);
}


static const value_string h245_MultiplexEntryRejectionDescriptionsCause_vals[] = {
  {   0, "unspecifiedCause" },
  {   1, "descriptorTooComplex" },
  { 0, NULL }
};

static const per_choice_t MultiplexEntryRejectionDescriptionsCause_choice[] = {
  {   0, "unspecifiedCause"            , ASN1_EXTENSION_ROOT    , dissect_unspecifiedCause },
  {   1, "descriptorTooComplex"        , ASN1_EXTENSION_ROOT    , dissect_descriptorTooComplex },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultiplexEntryRejectionDescriptionsCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultiplexEntryRejectionDescriptionsCause, MultiplexEntryRejectionDescriptionsCause_choice, "MultiplexEntryRejectionDescriptionsCause",
                              NULL);

  return offset;
}
static int dissect_mux_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntryRejectionDescriptionsCause(tvb, offset, pinfo, tree, hf_h245_mux_rej_cause);
}

static const per_sequence_t MultiplexEntryRejectionDescriptions_sequence[] = {
  { "multiplexTableEntryNumber"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexTableEntryNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mux_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntryRejectionDescriptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntryRejectionDescriptions, MultiplexEntryRejectionDescriptions_sequence);

  return offset;
}
static int dissect_rejectionDescriptions1_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntryRejectionDescriptions(tvb, offset, pinfo, tree, hf_h245_rejectionDescriptions1_item);
}


static int
dissect_h245_SET_SIZE_1_15_OF_MultiplexEntryRejectionDescriptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_15_OF_MultiplexEntryRejectionDescriptions, dissect_rejectionDescriptions1_item,
                                          1, 15);

  return offset;
}
static int dissect_rejectionDescriptions1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_15_OF_MultiplexEntryRejectionDescriptions(tvb, offset, pinfo, tree, hf_h245_rejectionDescriptions1);
}

static const per_sequence_t MultiplexEntrySendReject_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "rejectionDescriptions1"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rejectionDescriptions1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntrySendReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntrySendReject, MultiplexEntrySendReject_sequence);

  return offset;
}
static int dissect_multiplexEntrySendReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntrySendReject(tvb, offset, pinfo, tree, hf_h245_multiplexEntrySendReject);
}

static const per_sequence_t RequestMultiplexEntryAck_sequence[] = {
  { "entryNumbers"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_entryNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntryAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMultiplexEntryAck, RequestMultiplexEntryAck_sequence);

  return offset;
}
static int dissect_requestMultiplexEntryAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntryAck(tvb, offset, pinfo, tree, hf_h245_requestMultiplexEntryAck);
}


static const value_string h245_RequestMultiplexEntryRejectionDescriptionsCause_vals[] = {
  {   0, "unspecifiedCause" },
  { 0, NULL }
};

static const per_choice_t RequestMultiplexEntryRejectionDescriptionsCause_choice[] = {
  {   0, "unspecifiedCause"            , ASN1_EXTENSION_ROOT    , dissect_unspecifiedCause },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntryRejectionDescriptionsCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RequestMultiplexEntryRejectionDescriptionsCause, RequestMultiplexEntryRejectionDescriptionsCause_choice, "RequestMultiplexEntryRejectionDescriptionsCause",
                              NULL);

  return offset;
}
static int dissect_req_mux_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntryRejectionDescriptionsCause(tvb, offset, pinfo, tree, hf_h245_req_mux_rej_cause);
}

static const per_sequence_t RequestMultiplexEntryRejectionDescriptions_sequence[] = {
  { "multiplexTableEntryNumber"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexTableEntryNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_req_mux_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntryRejectionDescriptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMultiplexEntryRejectionDescriptions, RequestMultiplexEntryRejectionDescriptions_sequence);

  return offset;
}
static int dissect_rejectionDescriptions2_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntryRejectionDescriptions(tvb, offset, pinfo, tree, hf_h245_rejectionDescriptions2_item);
}


static int
dissect_h245_SET_SIZE_1_15_OF_RequestMultiplexEntryRejectionDescriptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_15_OF_RequestMultiplexEntryRejectionDescriptions, dissect_rejectionDescriptions2_item,
                                          1, 15);

  return offset;
}
static int dissect_rejectionDescriptions2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_15_OF_RequestMultiplexEntryRejectionDescriptions(tvb, offset, pinfo, tree, hf_h245_rejectionDescriptions2);
}

static const per_sequence_t RequestMultiplexEntryReject_sequence[] = {
  { "entryNumbers"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_entryNumbers },
  { "rejectionDescriptions2"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rejectionDescriptions2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntryReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMultiplexEntryReject, RequestMultiplexEntryReject_sequence);

  return offset;
}
static int dissect_requestMultiplexEntryReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntryReject(tvb, offset, pinfo, tree, hf_h245_requestMultiplexEntryReject);
}


static const value_string h245_Req_mode_ack_response_vals[] = {
  {   0, "willTransmitMostPreferredMode" },
  {   1, "willTransmitLessPreferredMode" },
  { 0, NULL }
};

static const per_choice_t Req_mode_ack_response_choice[] = {
  {   0, "willTransmitMostPreferredMode", ASN1_EXTENSION_ROOT    , dissect_willTransmitMostPreferredMode },
  {   1, "willTransmitLessPreferredMode", ASN1_EXTENSION_ROOT    , dissect_willTransmitLessPreferredMode },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Req_mode_ack_response(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Req_mode_ack_response, Req_mode_ack_response_choice, "Req_mode_ack_response",
                              NULL);

  return offset;
}
static int dissect_req_mode_ack_response(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Req_mode_ack_response(tvb, offset, pinfo, tree, hf_h245_req_mode_ack_response);
}

static const per_sequence_t RequestModeAck_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "response"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_req_mode_ack_response },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestModeAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestModeAck, RequestModeAck_sequence);

  return offset;
}
static int dissect_requestModeAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestModeAck(tvb, offset, pinfo, tree, hf_h245_requestModeAck);
}


static const value_string h245_RequestModeRejectCause_vals[] = {
  {   0, "modeUnavailable" },
  {   1, "multipointConstraint" },
  {   2, "requestDenied" },
  { 0, NULL }
};

static const per_choice_t RequestModeRejectCause_choice[] = {
  {   0, "modeUnavailable"             , ASN1_EXTENSION_ROOT    , dissect_modeUnavailable },
  {   1, "multipointConstraint"        , ASN1_EXTENSION_ROOT    , dissect_multipointConstraint },
  {   2, "requestDenied"               , ASN1_EXTENSION_ROOT    , dissect_requestDenied },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RequestModeRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RequestModeRejectCause, RequestModeRejectCause_choice, "RequestModeRejectCause",
                              NULL);

  return offset;
}
static int dissect_req_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestModeRejectCause(tvb, offset, pinfo, tree, hf_h245_req_rej_cause);
}

static const per_sequence_t RequestModeReject_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_req_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestModeReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestModeReject, RequestModeReject_sequence);

  return offset;
}
static int dissect_requestModeReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestModeReject(tvb, offset, pinfo, tree, hf_h245_requestModeReject);
}

static const per_sequence_t RoundTripDelayResponse_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RoundTripDelayResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RoundTripDelayResponse, RoundTripDelayResponse_sequence);

  return offset;
}
static int dissect_roundTripDelayResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RoundTripDelayResponse(tvb, offset, pinfo, tree, hf_h245_roundTripDelayResponse);
}


static const value_string h245_Mla_type_vals[] = {
  {   0, "systemLoop" },
  {   1, "mediaLoop" },
  {   2, "logicalChannelLoop" },
  { 0, NULL }
};

static const per_choice_t Mla_type_choice[] = {
  {   0, "systemLoop"                  , ASN1_EXTENSION_ROOT    , dissect_systemLoop },
  {   1, "mediaLoop"                   , ASN1_EXTENSION_ROOT    , dissect_mediaLoop },
  {   2, "logicalChannelLoop"          , ASN1_EXTENSION_ROOT    , dissect_logicalChannelLoop },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mla_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mla_type, Mla_type_choice, "Mla_type",
                              NULL);

  return offset;
}
static int dissect_Mla_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mla_type(tvb, offset, pinfo, tree, hf_h245_Mla_type);
}

static const per_sequence_t MaintenanceLoopAck_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_Mla_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaintenanceLoopAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaintenanceLoopAck, MaintenanceLoopAck_sequence);

  return offset;
}
static int dissect_maintenanceLoopAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaintenanceLoopAck(tvb, offset, pinfo, tree, hf_h245_maintenanceLoopAck);
}


static const value_string h245_Mlrej_type_vals[] = {
  {   0, "systemLoop" },
  {   1, "mediaLoop" },
  {   2, "logicalChannelLoop" },
  { 0, NULL }
};

static const per_choice_t Mlrej_type_choice[] = {
  {   0, "systemLoop"                  , ASN1_EXTENSION_ROOT    , dissect_systemLoop },
  {   1, "mediaLoop"                   , ASN1_EXTENSION_ROOT    , dissect_mediaLoop },
  {   2, "logicalChannelLoop"          , ASN1_EXTENSION_ROOT    , dissect_logicalChannelLoop },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mlrej_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mlrej_type, Mlrej_type_choice, "Mlrej_type",
                              NULL);

  return offset;
}
static int dissect_mlrej_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mlrej_type(tvb, offset, pinfo, tree, hf_h245_mlrej_type);
}


static const value_string h245_MaintenanceLoopRejectCause_vals[] = {
  {   0, "canNotPerformLoop" },
  { 0, NULL }
};

static const per_choice_t MaintenanceLoopRejectCause_choice[] = {
  {   0, "canNotPerformLoop"           , ASN1_EXTENSION_ROOT    , dissect_canNotPerformLoop },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MaintenanceLoopRejectCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MaintenanceLoopRejectCause, MaintenanceLoopRejectCause_choice, "MaintenanceLoopRejectCause",
                              NULL);

  return offset;
}
static int dissect_maintloop_rej_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaintenanceLoopRejectCause(tvb, offset, pinfo, tree, hf_h245_maintloop_rej_cause);
}

static const per_sequence_t MaintenanceLoopReject_sequence[] = {
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mlrej_type },
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maintloop_rej_cause },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaintenanceLoopReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaintenanceLoopReject, MaintenanceLoopReject_sequence);

  return offset;
}
static int dissect_maintenanceLoopReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaintenanceLoopReject(tvb, offset, pinfo, tree, hf_h245_maintenanceLoopReject);
}


static int
dissect_h245_BMPString_SIZE_1_128(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_BMPString(tvb, offset, pinfo, tree, hf_index,
                                 1, 128);

  return offset;
}
static int dissect_sessionDescription(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_BMPString_SIZE_1_128(tvb, offset, pinfo, tree, hf_h245_sessionDescription);
}


static const value_string h245_T_dataType_vals[] = {
  {   0, "videoData" },
  {   1, "audioData" },
  {   2, "data" },
  { 0, NULL }
};

static const per_choice_t T_dataType_choice[] = {
  {   0, "videoData"                   , ASN1_EXTENSION_ROOT    , dissect_videoData },
  {   1, "audioData"                   , ASN1_EXTENSION_ROOT    , dissect_audioData },
  {   2, "data"                        , ASN1_EXTENSION_ROOT    , dissect_data },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_dataType(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_dataType, T_dataType_choice, "T_dataType",
                              NULL);

  return offset;
}
static int dissect_entryDataType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_dataType(tvb, offset, pinfo, tree, hf_h245_entryDataType);
}


static int
dissect_h245_Cm_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_h245_TransportAddress(tvb, offset, pinfo, tree, hf_index);

  return offset;
}
static int dissect_cm_mediaChannel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cm_mediaChannel(tvb, offset, pinfo, tree, hf_h245_cm_mediaChannel);
}

static const per_sequence_t CommunicationModeTableEntry_sequence[] = {
  { "nonStandard"                 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nonStandardParams },
  { "sessionID"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sessionID },
  { "associatedSessionID"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_associatedSessionID },
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_terminalLabel },
  { "sessionDescription"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sessionDescription },
  { "dataType"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_entryDataType },
  { "mediaChannel"                , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cm_mediaChannel },
  { "mediaGuaranteedDelivery"     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaGuaranteedDelivery },
  { "mediaControlChannel"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_cm_mediaControlChannel },
  { "mediaControlGuaranteedDelivery", ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_mediaControlGuaranteedDelivery },
  { "redundancyEncoding"          , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_redundancyEncoding },
  { "sessionDependency"           , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_sessionDependency },
  { "destination"                 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_destination },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CommunicationModeTableEntry(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CommunicationModeTableEntry, CommunicationModeTableEntry_sequence);

  return offset;
}
static int dissect_communicationModeTable_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CommunicationModeTableEntry(tvb, offset, pinfo, tree, hf_h245_communicationModeTable_item);
}


static int
dissect_h245_SET_SIZE_1_256_OF_CommunicationModeTableEntry(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_CommunicationModeTableEntry, dissect_communicationModeTable_item,
                                          1, 256);

  return offset;
}
static int dissect_communicationModeTable(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_CommunicationModeTableEntry(tvb, offset, pinfo, tree, hf_h245_communicationModeTable);
}


static const value_string h245_CommunicationModeResponse_vals[] = {
  {   0, "communicationModeTable" },
  { 0, NULL }
};

static const per_choice_t CommunicationModeResponse_choice[] = {
  {   0, "communicationModeTable"      , ASN1_EXTENSION_ROOT    , dissect_communicationModeTable },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CommunicationModeResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CommunicationModeResponse, CommunicationModeResponse_choice, "CommunicationModeResponse",
                              NULL);

  return offset;
}
static int dissect_communicationModeResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CommunicationModeResponse(tvb, offset, pinfo, tree, hf_h245_communicationModeResponse);
}


static int
dissect_h245_TerminalID(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 128,
                                    NULL, NULL);

  return offset;
}
static int dissect_terminalID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalID(tvb, offset, pinfo, tree, hf_h245_terminalID);
}
static int dissect_extensionAddress(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalID(tvb, offset, pinfo, tree, hf_h245_extensionAddress);
}

static const per_sequence_t T_mCTerminalIDResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "terminalID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_mCTerminalIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_mCTerminalIDResponse, T_mCTerminalIDResponse_sequence);

  return offset;
}
static int dissect_mCTerminalIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_mCTerminalIDResponse(tvb, offset, pinfo, tree, hf_h245_mCTerminalIDResponse);
}

static const per_sequence_t T_terminalIDResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "terminalID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_terminalIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_terminalIDResponse, T_terminalIDResponse_sequence);

  return offset;
}
static int dissect_terminalIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_terminalIDResponse(tvb, offset, pinfo, tree, hf_h245_terminalIDResponse);
}


static int
dissect_h245_ConferenceID(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 32,
                                    NULL, NULL);

  return offset;
}
static int dissect_conferenceID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceID(tvb, offset, pinfo, tree, hf_h245_conferenceID);
}

static const per_sequence_t T_conferenceIDResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "conferenceID"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_conferenceID },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_conferenceIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_conferenceIDResponse, T_conferenceIDResponse_sequence);

  return offset;
}
static int dissect_conferenceIDResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_conferenceIDResponse(tvb, offset, pinfo, tree, hf_h245_conferenceIDResponse);
}


static int
dissect_h245_Password(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 32,
                                    NULL, NULL);

  return offset;
}
static int dissect_password(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Password(tvb, offset, pinfo, tree, hf_h245_password);
}

static const per_sequence_t T_passwordResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "password"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_password },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_passwordResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_passwordResponse, T_passwordResponse_sequence);

  return offset;
}
static int dissect_passwordResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_passwordResponse(tvb, offset, pinfo, tree, hf_h245_passwordResponse);
}


static int
dissect_h245_SET_SIZE_1_256_OF_TerminalLabel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_TerminalLabel, dissect_terminalListResponse_item,
                                          1, 256);

  return offset;
}
static int dissect_terminalListResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_TerminalLabel(tvb, offset, pinfo, tree, hf_h245_terminalListResponse);
}


static const value_string h245_T_makeMeChairResponse_vals[] = {
  {   0, "grantedChairToken" },
  {   1, "deniedChairToken" },
  { 0, NULL }
};

static const per_choice_t T_makeMeChairResponse_choice[] = {
  {   0, "grantedChairToken"           , ASN1_EXTENSION_ROOT    , dissect_grantedChairToken },
  {   1, "deniedChairToken"            , ASN1_EXTENSION_ROOT    , dissect_deniedChairToken },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_makeMeChairResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_makeMeChairResponse, T_makeMeChairResponse_choice, "T_makeMeChairResponse",
                              NULL);

  return offset;
}
static int dissect_makeMeChairResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_makeMeChairResponse(tvb, offset, pinfo, tree, hf_h245_makeMeChairResponse);
}

static const per_sequence_t T_extensionAddressResponse_sequence[] = {
  { "extensionAddress"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_extensionAddress },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_extensionAddressResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_extensionAddressResponse, T_extensionAddressResponse_sequence);

  return offset;
}
static int dissect_extensionAddressResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_extensionAddressResponse(tvb, offset, pinfo, tree, hf_h245_extensionAddressResponse);
}

static const per_sequence_t T_chairTokenOwnerResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "terminalID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_chairTokenOwnerResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_chairTokenOwnerResponse, T_chairTokenOwnerResponse_sequence);

  return offset;
}
static int dissect_chairTokenOwnerResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_chairTokenOwnerResponse(tvb, offset, pinfo, tree, hf_h245_chairTokenOwnerResponse);
}

static const per_sequence_t T_terminalCertificateResponse_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_terminalLabel },
  { "certificateResponse"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_certificateResponse },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_terminalCertificateResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_terminalCertificateResponse, T_terminalCertificateResponse_sequence);

  return offset;
}
static int dissect_terminalCertificateResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_terminalCertificateResponse(tvb, offset, pinfo, tree, hf_h245_terminalCertificateResponse);
}


static const value_string h245_T_broadcastMyLogicalChannelResponse_vals[] = {
  {   0, "grantedBroadcastMyLogicalChannel" },
  {   1, "deniedBroadcastMyLogicalChannel" },
  { 0, NULL }
};

static const per_choice_t T_broadcastMyLogicalChannelResponse_choice[] = {
  {   0, "grantedBroadcastMyLogicalChannel", ASN1_EXTENSION_ROOT    , dissect_grantedBroadcastMyLogicalChannel },
  {   1, "deniedBroadcastMyLogicalChannel", ASN1_EXTENSION_ROOT    , dissect_deniedBroadcastMyLogicalChannel },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_broadcastMyLogicalChannelResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_broadcastMyLogicalChannelResponse, T_broadcastMyLogicalChannelResponse_choice, "T_broadcastMyLogicalChannelResponse",
                              NULL);

  return offset;
}
static int dissect_broadcastMyLogicalChannelResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_broadcastMyLogicalChannelResponse(tvb, offset, pinfo, tree, hf_h245_broadcastMyLogicalChannelResponse);
}


static const value_string h245_T_makeTerminalBroadcasterResponse_vals[] = {
  {   0, "grantedMakeTerminalBroadcaster" },
  {   1, "deniedMakeTerminalBroadcaster" },
  { 0, NULL }
};

static const per_choice_t T_makeTerminalBroadcasterResponse_choice[] = {
  {   0, "grantedMakeTerminalBroadcaster", ASN1_EXTENSION_ROOT    , dissect_grantedMakeTerminalBroadcaster },
  {   1, "deniedMakeTerminalBroadcaster", ASN1_EXTENSION_ROOT    , dissect_deniedMakeTerminalBroadcaster },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_makeTerminalBroadcasterResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_makeTerminalBroadcasterResponse, T_makeTerminalBroadcasterResponse_choice, "T_makeTerminalBroadcasterResponse",
                              NULL);

  return offset;
}
static int dissect_makeTerminalBroadcasterResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_makeTerminalBroadcasterResponse(tvb, offset, pinfo, tree, hf_h245_makeTerminalBroadcasterResponse);
}


static const value_string h245_T_sendThisSourceResponse_vals[] = {
  {   0, "grantedSendThisSource" },
  {   1, "deniedSendThisSource" },
  { 0, NULL }
};

static const per_choice_t T_sendThisSourceResponse_choice[] = {
  {   0, "grantedSendThisSource"       , ASN1_EXTENSION_ROOT    , dissect_grantedSendThisSource },
  {   1, "deniedSendThisSource"        , ASN1_EXTENSION_ROOT    , dissect_deniedSendThisSource },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_sendThisSourceResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_sendThisSourceResponse, T_sendThisSourceResponse_choice, "T_sendThisSourceResponse",
                              NULL);

  return offset;
}
static int dissect_sendThisSourceResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_sendThisSourceResponse(tvb, offset, pinfo, tree, hf_h245_sendThisSourceResponse);
}

static const per_sequence_t TerminalInformation_sequence[] = {
  { "terminalLabel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalLabel },
  { "terminalID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalInformation(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalInformation, TerminalInformation_sequence);

  return offset;
}
static int dissect_terminalInformation_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalInformation(tvb, offset, pinfo, tree, hf_h245_terminalInformation_item);
}


static int
dissect_h245_SEQUENCE_OF_TerminalInformation(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_TerminalInformation, dissect_terminalInformation_item);

  return offset;
}
static int dissect_terminalInformation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_TerminalInformation(tvb, offset, pinfo, tree, hf_h245_terminalInformation);
}

static const per_sequence_t RequestAllTerminalIDsResponse_sequence[] = {
  { "terminalInformation"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalInformation },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestAllTerminalIDsResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestAllTerminalIDsResponse, RequestAllTerminalIDsResponse_sequence);

  return offset;
}
static int dissect_requestAllTerminalIDsResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestAllTerminalIDsResponse(tvb, offset, pinfo, tree, hf_h245_requestAllTerminalIDsResponse);
}


static const value_string h245_T_reject_vals[] = {
  {   0, "unspecified" },
  {   1, "functionNotSupported" },
  { 0, NULL }
};

static const per_choice_t T_reject_choice[] = {
  {   0, "unspecified"                 , ASN1_EXTENSION_ROOT    , dissect_unspecified },
  {   1, "functionNotSupported"        , ASN1_EXTENSION_ROOT    , dissect_functionNotSupportedFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_reject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_reject, T_reject_choice, "T_reject",
                              NULL);

  return offset;
}
static int dissect_reject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_reject(tvb, offset, pinfo, tree, hf_h245_reject);
}


static const value_string h245_RemoteMCResponse_vals[] = {
  {   0, "accept" },
  {   1, "reject" },
  { 0, NULL }
};

static const per_choice_t RemoteMCResponse_choice[] = {
  {   0, "accept"                      , ASN1_EXTENSION_ROOT    , dissect_accept },
  {   1, "reject"                      , ASN1_EXTENSION_ROOT    , dissect_reject },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RemoteMCResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RemoteMCResponse, RemoteMCResponse_choice, "RemoteMCResponse",
                              NULL);

  return offset;
}
static int dissect_remoteMCResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RemoteMCResponse(tvb, offset, pinfo, tree, hf_h245_remoteMCResponse);
}


static const value_string h245_ConferenceResponse_vals[] = {
  {   0, "mCTerminalIDResponse" },
  {   1, "terminalIDResponse" },
  {   2, "conferenceIDResponse" },
  {   3, "passwordResponse" },
  {   4, "terminalListResponse" },
  {   5, "videoCommandReject" },
  {   6, "terminalDropReject" },
  {   7, "makeMeChairResponse" },
  {   8, "extensionAddressResponse" },
  {   9, "chairTokenOwnerResponse" },
  {  10, "terminalCertificateResponse" },
  {  11, "broadcastMyLogicalChannelResponse" },
  {  12, "makeTerminalBroadcasterResponse" },
  {  13, "sendThisSourceResponse" },
  {  14, "requestAllTerminalIDsResponse" },
  {  15, "remoteMCResponse" },
  { 0, NULL }
};

static const per_choice_t ConferenceResponse_choice[] = {
  {   0, "mCTerminalIDResponse"        , ASN1_EXTENSION_ROOT    , dissect_mCTerminalIDResponse },
  {   1, "terminalIDResponse"          , ASN1_EXTENSION_ROOT    , dissect_terminalIDResponse },
  {   2, "conferenceIDResponse"        , ASN1_EXTENSION_ROOT    , dissect_conferenceIDResponse },
  {   3, "passwordResponse"            , ASN1_EXTENSION_ROOT    , dissect_passwordResponse },
  {   4, "terminalListResponse"        , ASN1_EXTENSION_ROOT    , dissect_terminalListResponse },
  {   5, "videoCommandReject"          , ASN1_EXTENSION_ROOT    , dissect_videoCommandReject },
  {   6, "terminalDropReject"          , ASN1_EXTENSION_ROOT    , dissect_terminalDropReject },
  {   7, "makeMeChairResponse"         , ASN1_EXTENSION_ROOT    , dissect_makeMeChairResponse },
  {   8, "extensionAddressResponse"    , ASN1_NOT_EXTENSION_ROOT, dissect_extensionAddressResponse },
  {   9, "chairTokenOwnerResponse"     , ASN1_NOT_EXTENSION_ROOT, dissect_chairTokenOwnerResponse },
  {  10, "terminalCertificateResponse" , ASN1_NOT_EXTENSION_ROOT, dissect_terminalCertificateResponse },
  {  11, "broadcastMyLogicalChannelResponse", ASN1_NOT_EXTENSION_ROOT, dissect_broadcastMyLogicalChannelResponse },
  {  12, "makeTerminalBroadcasterResponse", ASN1_NOT_EXTENSION_ROOT, dissect_makeTerminalBroadcasterResponse },
  {  13, "sendThisSourceResponse"      , ASN1_NOT_EXTENSION_ROOT, dissect_sendThisSourceResponse },
  {  14, "requestAllTerminalIDsResponse", ASN1_NOT_EXTENSION_ROOT, dissect_requestAllTerminalIDsResponse },
  {  15, "remoteMCResponse"            , ASN1_NOT_EXTENSION_ROOT, dissect_remoteMCResponse },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ConferenceResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ConferenceResponse, ConferenceResponse_choice, "ConferenceResponse",
                              NULL);

  return offset;
}
static int dissect_conferenceResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceResponse(tvb, offset, pinfo, tree, hf_h245_conferenceResponse);
}

static const per_sequence_t CallInformationResp_sequence[] = {
  { "dialingInformation"          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_dialingInformation },
  { "callAssociationNumber"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_callAssociationNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CallInformationResp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CallInformationResp, CallInformationResp_sequence);

  return offset;
}
static int dissect_callInformationResp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CallInformationResp(tvb, offset, pinfo, tree, hf_h245_callInformationResp);
}


static const value_string h245_T_rejected_vals[] = {
  {   0, "connectionsNotAvailable" },
  {   1, "userRejected" },
  { 0, NULL }
};

static const per_choice_t T_rejected_choice[] = {
  {   0, "connectionsNotAvailable"     , ASN1_EXTENSION_ROOT    , dissect_connectionsNotAvailable },
  {   1, "userRejected"                , ASN1_EXTENSION_ROOT    , dissect_userRejected },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_rejected(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_rejected, T_rejected_choice, "T_rejected",
                              NULL);

  return offset;
}
static int dissect_rejected(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_rejected(tvb, offset, pinfo, tree, hf_h245_rejected);
}


static const value_string h245_T_responseCode_vals[] = {
  {   0, "accepted" },
  {   1, "rejected" },
  { 0, NULL }
};

static const per_choice_t T_responseCode_choice[] = {
  {   0, "accepted"                    , ASN1_EXTENSION_ROOT    , dissect_accepted },
  {   1, "rejected"                    , ASN1_EXTENSION_ROOT    , dissect_rejected },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_responseCode(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_responseCode, T_responseCode_choice, "T_responseCode",
                              NULL);

  return offset;
}
static int dissect_responseCode(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_responseCode(tvb, offset, pinfo, tree, hf_h245_responseCode);
}

static const per_sequence_t AddConnectionResp_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "responseCode"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_responseCode },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_AddConnectionResp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_AddConnectionResp, AddConnectionResp_sequence);

  return offset;
}
static int dissect_addConnectionResp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_AddConnectionResp(tvb, offset, pinfo, tree, hf_h245_addConnectionResp);
}


static int
dissect_h245_RemoveConnectionResp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_h245_RemoveConnection(tvb, offset, pinfo, tree, hf_index);

  return offset;
}
static int dissect_removeConnectionResp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RemoveConnectionResp(tvb, offset, pinfo, tree, hf_h245_removeConnectionResp);
}

static const per_sequence_t MaximumHeaderIntervalResp_sequence[] = {
  { "currentInterval"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_currentInterval },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaximumHeaderIntervalResp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaximumHeaderIntervalResp, MaximumHeaderIntervalResp_sequence);

  return offset;
}
static int dissect_maximumHeaderIntervalResp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaximumHeaderIntervalResp(tvb, offset, pinfo, tree, hf_h245_maximumHeaderIntervalResp);
}


static const value_string h245_MultilinkResponse_vals[] = {
  {   0, "nonStandard" },
  {   1, "callInformation" },
  {   2, "addConnection" },
  {   3, "removeConnection" },
  {   4, "maximumHeaderInterval" },
  { 0, NULL }
};

static const per_choice_t MultilinkResponse_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "callInformation"             , ASN1_EXTENSION_ROOT    , dissect_callInformationResp },
  {   2, "addConnection"               , ASN1_EXTENSION_ROOT    , dissect_addConnectionResp },
  {   3, "removeConnection"            , ASN1_EXTENSION_ROOT    , dissect_removeConnectionResp },
  {   4, "maximumHeaderInterval"       , ASN1_EXTENSION_ROOT    , dissect_maximumHeaderIntervalResp },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultilinkResponse(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultilinkResponse, MultilinkResponse_choice, "MultilinkResponse",
                              NULL);

  return offset;
}
static int dissect_multilinkResponse(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultilinkResponse(tvb, offset, pinfo, tree, hf_h245_multilinkResponse);
}

static const per_sequence_t LogicalChannelRateAcknowledge_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { "maximumBitRate"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumBitRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_LogicalChannelRateAcknowledge(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_LogicalChannelRateAcknowledge, LogicalChannelRateAcknowledge_sequence);

  return offset;
}
static int dissect_logicalChannelRateAcknowledge(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelRateAcknowledge(tvb, offset, pinfo, tree, hf_h245_logicalChannelRateAcknowledge);
}


static const value_string h245_LogicalChannelRateRejectReason_vals[] = {
  {   0, "undefinedReason" },
  {   1, "insufficientResources" },
  { 0, NULL }
};

static const per_choice_t LogicalChannelRateRejectReason_choice[] = {
  {   0, "undefinedReason"             , ASN1_EXTENSION_ROOT    , dissect_undefinedReason },
  {   1, "insufficientResources"       , ASN1_EXTENSION_ROOT    , dissect_insufficientResources },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_LogicalChannelRateRejectReason(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_LogicalChannelRateRejectReason, LogicalChannelRateRejectReason_choice, "LogicalChannelRateRejectReason",
                              NULL);

  return offset;
}
static int dissect_rejectReason(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelRateRejectReason(tvb, offset, pinfo, tree, hf_h245_rejectReason);
}

static const per_sequence_t LogicalChannelRateReject_sequence[] = {
  { "sequenceNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sequenceNumber },
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { "rejectReason"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_rejectReason },
  { "currentMaximumBitRate"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_currentMaximumBitRate },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_LogicalChannelRateReject(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_LogicalChannelRateReject, LogicalChannelRateReject_sequence);

  return offset;
}
static int dissect_logicalChannelRateReject(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelRateReject(tvb, offset, pinfo, tree, hf_h245_logicalChannelRateReject);
}


static const value_string h245_ResponseMessage_vals[] = {
  {   0, "nonStandard" },
  {   1, "masterSlaveDeterminationAck" },
  {   2, "masterSlaveDeterminationReject" },
  {   3, "terminalCapabilitySetAck" },
  {   4, "terminalCapabilitySetReject" },
  {   5, "openLogicalChannelAck" },
  {   6, "openLogicalChannelReject" },
  {   7, "closeLogicalChannelAck" },
  {   8, "requestChannelCloseAck" },
  {   9, "requestChannelCloseReject" },
  {  10, "multiplexEntrySendAck" },
  {  11, "multiplexEntrySendReject" },
  {  12, "requestMultiplexEntryAck" },
  {  13, "requestMultiplexEntryReject" },
  {  14, "requestModeAck" },
  {  15, "requestModeReject" },
  {  16, "roundTripDelayResponse" },
  {  17, "maintenanceLoopAck" },
  {  18, "maintenanceLoopReject" },
  {  19, "communicationModeResponse" },
  {  20, "conferenceResponse" },
  {  21, "multilinkResponse" },
  {  22, "logicalChannelRateAcknowledge" },
  {  23, "logicalChannelRateReject" },
  {  24, "genericResponse" },
  { 0, NULL }
};

static const per_choice_t ResponseMessage_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "masterSlaveDeterminationAck" , ASN1_EXTENSION_ROOT    , dissect_masterSlaveDeterminationAck },
  {   2, "masterSlaveDeterminationReject", ASN1_EXTENSION_ROOT    , dissect_masterSlaveDeterminationReject },
  {   3, "terminalCapabilitySetAck"    , ASN1_EXTENSION_ROOT    , dissect_terminalCapabilitySetAck },
  {   4, "terminalCapabilitySetReject" , ASN1_EXTENSION_ROOT    , dissect_terminalCapabilitySetReject },
  {   5, "openLogicalChannelAck"       , ASN1_EXTENSION_ROOT    , dissect_openLogicalChannelAck },
  {   6, "openLogicalChannelReject"    , ASN1_EXTENSION_ROOT    , dissect_openLogicalChannelReject },
  {   7, "closeLogicalChannelAck"      , ASN1_EXTENSION_ROOT    , dissect_closeLogicalChannelAck },
  {   8, "requestChannelCloseAck"      , ASN1_EXTENSION_ROOT    , dissect_requestChannelCloseAck },
  {   9, "requestChannelCloseReject"   , ASN1_EXTENSION_ROOT    , dissect_requestChannelCloseReject },
  {  10, "multiplexEntrySendAck"       , ASN1_EXTENSION_ROOT    , dissect_multiplexEntrySendAck },
  {  11, "multiplexEntrySendReject"    , ASN1_EXTENSION_ROOT    , dissect_multiplexEntrySendReject },
  {  12, "requestMultiplexEntryAck"    , ASN1_EXTENSION_ROOT    , dissect_requestMultiplexEntryAck },
  {  13, "requestMultiplexEntryReject" , ASN1_EXTENSION_ROOT    , dissect_requestMultiplexEntryReject },
  {  14, "requestModeAck"              , ASN1_EXTENSION_ROOT    , dissect_requestModeAck },
  {  15, "requestModeReject"           , ASN1_EXTENSION_ROOT    , dissect_requestModeReject },
  {  16, "roundTripDelayResponse"      , ASN1_EXTENSION_ROOT    , dissect_roundTripDelayResponse },
  {  17, "maintenanceLoopAck"          , ASN1_EXTENSION_ROOT    , dissect_maintenanceLoopAck },
  {  18, "maintenanceLoopReject"       , ASN1_EXTENSION_ROOT    , dissect_maintenanceLoopReject },
  {  19, "communicationModeResponse"   , ASN1_NOT_EXTENSION_ROOT, dissect_communicationModeResponse },
  {  20, "conferenceResponse"          , ASN1_NOT_EXTENSION_ROOT, dissect_conferenceResponse },
  {  21, "multilinkResponse"           , ASN1_NOT_EXTENSION_ROOT, dissect_multilinkResponse },
  {  22, "logicalChannelRateAcknowledge", ASN1_NOT_EXTENSION_ROOT, dissect_logicalChannelRateAcknowledge },
  {  23, "logicalChannelRateReject"    , ASN1_NOT_EXTENSION_ROOT, dissect_logicalChannelRateReject },
  {  24, "genericResponse"             , ASN1_NOT_EXTENSION_ROOT, dissect_genericResponse },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ResponseMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ResponseMessage, ResponseMessage_choice, "ResponseMessage",
                              &value);


	if (check_col(pinfo->cinfo, COL_INFO)){
	        if ( h245_shorttypes == TRUE )
	        {
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_ResponseMessage_short_vals, "<unknown>"));
		}
		else
		{
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_ResponseMessage_vals, "<unknown>"));
		}
	}

	col_set_fence(pinfo->cinfo,COL_INFO);

    /* Add to packet info */
    g_snprintf(h245_pi->frame_label, 50, "%s %s ", h245_pi->frame_label, val_to_str(value, h245_ResponseMessage_short_vals, "UKN"));
    g_snprintf(h245_pi->comment, 50, "%s %s ", h245_pi->comment, val_to_str(value, h245_ResponseMessage_vals, "<unknown>"));

  return offset;
}
static int dissect_response(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ResponseMessage(tvb, offset, pinfo, tree, hf_h245_response);
}

static const per_sequence_t MaintenanceLoopOffCommand_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MaintenanceLoopOffCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MaintenanceLoopOffCommand, MaintenanceLoopOffCommand_sequence);

  return offset;
}
static int dissect_maintenanceLoopOffCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MaintenanceLoopOffCommand(tvb, offset, pinfo, tree, hf_h245_maintenanceLoopOffCommand);
}


static int
dissect_h245_SET_SIZE_1_65535_OF_CapabilityTableEntryNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_65535_OF_CapabilityTableEntryNumber, dissect_capabilityTableEntryNumbers_item,
                                          1, 65535);

  return offset;
}
static int dissect_capabilityTableEntryNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_65535_OF_CapabilityTableEntryNumber(tvb, offset, pinfo, tree, hf_h245_capabilityTableEntryNumbers);
}


static int
dissect_h245_SET_SIZE_1_256_OF_CapabilityDescriptorNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_set_of(tvb, offset, pinfo, tree, hf_index,
                                          ett_h245_SET_SIZE_1_256_OF_CapabilityDescriptorNumber, dissect_capabilityDescriptorNumbers_item,
                                          1, 256);

  return offset;
}
static int dissect_capabilityDescriptorNumbers(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SET_SIZE_1_256_OF_CapabilityDescriptorNumber(tvb, offset, pinfo, tree, hf_h245_capabilityDescriptorNumbers);
}

static const per_sequence_t T_specificRequest_sequence[] = {
  { "multiplexCapability"         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexCapabilityBool },
  { "capabilityTableEntryNumbers" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_capabilityTableEntryNumbers },
  { "capabilityDescriptorNumbers" , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_capabilityDescriptorNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_specificRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_specificRequest, T_specificRequest_sequence);

  return offset;
}
static int dissect_specificRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_specificRequest(tvb, offset, pinfo, tree, hf_h245_specificRequest);
}


static const value_string h245_SendTerminalCapabilitySet_vals[] = {
  {   0, "specificRequest" },
  {   1, "genericRequest" },
  { 0, NULL }
};

static const per_choice_t SendTerminalCapabilitySet_choice[] = {
  {   0, "specificRequest"             , ASN1_EXTENSION_ROOT    , dissect_specificRequest },
  {   1, "genericRequest"              , ASN1_EXTENSION_ROOT    , dissect_genericRequestFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_SendTerminalCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_SendTerminalCapabilitySet, SendTerminalCapabilitySet_choice, "SendTerminalCapabilitySet",
                              NULL);

  return offset;
}
static int dissect_sendTerminalCapabilitySet(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SendTerminalCapabilitySet(tvb, offset, pinfo, tree, hf_h245_sendTerminalCapabilitySet);
}

static const per_sequence_t T_encryptionAlgorithmID_sequence[] = {
  { "h233AlgorithmIdentifier"     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_h233AlgorithmIdentifier },
  { "associatedAlgorithm"         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_associatedAlgorithm },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_encryptionAlgorithmID(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_encryptionAlgorithmID, T_encryptionAlgorithmID_sequence);

  return offset;
}
static int dissect_encryptionAlgorithmID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_encryptionAlgorithmID(tvb, offset, pinfo, tree, hf_h245_encryptionAlgorithmID);
}


static const value_string h245_EncryptionCommand_vals[] = {
  {   0, "encryptionSE" },
  {   1, "encryptionIVRequest" },
  {   2, "encryptionAlgorithmID" },
  { 0, NULL }
};

static const per_choice_t EncryptionCommand_choice[] = {
  {   0, "encryptionSE"                , ASN1_EXTENSION_ROOT    , dissect_encryptionSE },
  {   1, "encryptionIVRequest"         , ASN1_EXTENSION_ROOT    , dissect_encryptionIVRequest },
  {   2, "encryptionAlgorithmID"       , ASN1_EXTENSION_ROOT    , dissect_encryptionAlgorithmID },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_EncryptionCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_EncryptionCommand, EncryptionCommand_choice, "EncryptionCommand",
                              NULL);

  return offset;
}
static int dissect_encryptionCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionCommand(tvb, offset, pinfo, tree, hf_h245_encryptionCommand);
}


static const value_string h245_Scope_vals[] = {
  {   0, "logicalChannelNumber" },
  {   1, "resourceID" },
  {   2, "wholeMultiplex" },
  { 0, NULL }
};

static const per_choice_t Scope_choice[] = {
  {   0, "logicalChannelNumber"        , ASN1_NO_EXTENSIONS     , dissect_logicalChannelNumber },
  {   1, "resourceID"                  , ASN1_NO_EXTENSIONS     , dissect_resourceID },
  {   2, "wholeMultiplex"              , ASN1_NO_EXTENSIONS     , dissect_wholeMultiplex },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Scope(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Scope, Scope_choice, "Scope",
                              NULL);

  return offset;
}
static int dissect_scope(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Scope(tvb, offset, pinfo, tree, hf_h245_scope);
}


static const value_string h245_Restriction_vals[] = {
  {   0, "maximumBitRate" },
  {   1, "noRestriction" },
  { 0, NULL }
};

static const per_choice_t Restriction_choice[] = {
  {   0, "maximumBitRate"              , ASN1_NO_EXTENSIONS     , dissect_Res_maximumBitRate },
  {   1, "noRestriction"               , ASN1_NO_EXTENSIONS     , dissect_noRestriction },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Restriction(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Restriction, Restriction_choice, "Restriction",
                              NULL);

  return offset;
}
static int dissect_restriction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Restriction(tvb, offset, pinfo, tree, hf_h245_restriction);
}

static const per_sequence_t FlowControlCommand_sequence[] = {
  { "scope"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scope },
  { "restriction"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_restriction },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_FlowControlCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_FlowControlCommand, FlowControlCommand_sequence);

  return offset;
}
static int dissect_flowControlCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FlowControlCommand(tvb, offset, pinfo, tree, hf_h245_flowControlCommand);
}


static const value_string h245_T_gstnOptions_vals[] = {
  {   0, "telephonyMode" },
  {   1, "v8bis" },
  {   2, "v34DSVD" },
  {   3, "v34DuplexFAX" },
  {   4, "v34H324" },
  { 0, NULL }
};

static const per_choice_t T_gstnOptions_choice[] = {
  {   0, "telephonyMode"               , ASN1_EXTENSION_ROOT    , dissect_telephonyMode },
  {   1, "v8bis"                       , ASN1_EXTENSION_ROOT    , dissect_v8bis },
  {   2, "v34DSVD"                     , ASN1_EXTENSION_ROOT    , dissect_v34DSVD },
  {   3, "v34DuplexFAX"                , ASN1_EXTENSION_ROOT    , dissect_v34DuplexFAX },
  {   4, "v34H324"                     , ASN1_EXTENSION_ROOT    , dissect_v34H324 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_gstnOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_gstnOptions, T_gstnOptions_choice, "T_gstnOptions",
                              NULL);

  return offset;
}
static int dissect_gstnOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_gstnOptions(tvb, offset, pinfo, tree, hf_h245_gstnOptions);
}


static const value_string h245_T_isdnOptions_vals[] = {
  {   0, "telephonyMode" },
  {   1, "v140" },
  {   2, "terminalOnHold" },
  { 0, NULL }
};

static const per_choice_t T_isdnOptions_choice[] = {
  {   0, "telephonyMode"               , ASN1_EXTENSION_ROOT    , dissect_telephonyMode },
  {   1, "v140"                        , ASN1_EXTENSION_ROOT    , dissect_v140 },
  {   2, "terminalOnHold"              , ASN1_EXTENSION_ROOT    , dissect_terminalOnHold },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_isdnOptions(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_isdnOptions, T_isdnOptions_choice, "T_isdnOptions",
                              NULL);

  return offset;
}
static int dissect_isdnOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_isdnOptions(tvb, offset, pinfo, tree, hf_h245_isdnOptions);
}


static const value_string h245_EndSessionCommand_vals[] = {
  {   0, "nonStandard" },
  {   1, "disconnect" },
  {   2, "gstnOptions" },
  {   3, "isdnOptions" },
  { 0, NULL }
};

static const per_choice_t EndSessionCommand_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "disconnect"                  , ASN1_EXTENSION_ROOT    , dissect_disconnect },
  {   2, "gstnOptions"                 , ASN1_EXTENSION_ROOT    , dissect_gstnOptions },
  {   3, "isdnOptions"                 , ASN1_NOT_EXTENSION_ROOT, dissect_isdnOptions },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_EndSessionCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_EndSessionCommand, EndSessionCommand_choice, "EndSessionCommand",
                              NULL);

  return offset;
}
static int dissect_endSessionCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EndSessionCommand(tvb, offset, pinfo, tree, hf_h245_endSessionCommand);
}



static int
dissect_h245_INTEGER_0_17(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 17U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_firstGOB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_17(tvb, offset, pinfo, tree, hf_h245_firstGOB);
}



static int
dissect_h245_INTEGER_1_18(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 18U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_numberOfGOBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_18(tvb, offset, pinfo, tree, hf_h245_numberOfGOBs);
}

static const per_sequence_t T_videoFastUpdateGOB_sequence[] = {
  { "firstGOB"                    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_firstGOB },
  { "numberOfGOBs"                , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_numberOfGOBs },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_videoFastUpdateGOB(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_videoFastUpdateGOB, T_videoFastUpdateGOB_sequence);

  return offset;
}
static int dissect_videoFastUpdateGOB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_videoFastUpdateGOB(tvb, offset, pinfo, tree, hf_h245_videoFastUpdateGOB);
}



static int
dissect_h245_INTEGER_0_31(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 31U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_videoTemporalSpatialTradeOff(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_31(tvb, offset, pinfo, tree, hf_h245_videoTemporalSpatialTradeOff);
}



static int
dissect_h245_INTEGER_1_8192(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 8192U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_firstMB_1_8192(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_8192(tvb, offset, pinfo, tree, hf_h245_firstMB_1_8192);
}
static int dissect_numberOfMBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_8192(tvb, offset, pinfo, tree, hf_h245_numberOfMBs);
}

static const per_sequence_t T_videoFastUpdateMB_sequence[] = {
  { "firstGOB"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_firstGOB_0_255 },
  { "firstMB"                     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_firstMB_1_8192 },
  { "numberOfMBs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfMBs },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_videoFastUpdateMB(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_videoFastUpdateMB, T_videoFastUpdateMB_sequence);

  return offset;
}
static int dissect_videoFastUpdateMB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_videoFastUpdateMB(tvb, offset, pinfo, tree, hf_h245_videoFastUpdateMB);
}

static const per_sequence_t KeyProtectionMethod_sequence[] = {
  { "secureChannel"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_secureChannel },
  { "sharedSecret"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sharedSecret },
  { "certProtectedKey"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_certProtectedKey },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_KeyProtectionMethod(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_KeyProtectionMethod, KeyProtectionMethod_sequence);

  return offset;
}
static int dissect_keyProtectionMethod(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_KeyProtectionMethod(tvb, offset, pinfo, tree, hf_h245_keyProtectionMethod);
}

static const per_sequence_t EncryptionUpdateRequest_sequence[] = {
  { "keyProtectionMethod"         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_keyProtectionMethod },
  { "synchFlag"                   , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_synchFlag },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EncryptionUpdateRequest(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EncryptionUpdateRequest, EncryptionUpdateRequest_sequence);

  return offset;
}
static int dissect_encryptionUpdateRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionUpdateRequest(tvb, offset, pinfo, tree, hf_h245_encryptionUpdateRequest);
}


static const value_string h245_RepeatCount_vals[] = {
  {   0, "doOneProgression" },
  {   1, "doContinuousProgressions" },
  {   2, "doOneIndependentProgression" },
  {   3, "doContinuousIndependentProgressions" },
  { 0, NULL }
};

static const per_choice_t RepeatCount_choice[] = {
  {   0, "doOneProgression"            , ASN1_EXTENSION_ROOT    , dissect_doOneProgression },
  {   1, "doContinuousProgressions"    , ASN1_EXTENSION_ROOT    , dissect_doContinuousProgressions },
  {   2, "doOneIndependentProgression" , ASN1_EXTENSION_ROOT    , dissect_doOneIndependentProgression },
  {   3, "doContinuousIndependentProgressions", ASN1_EXTENSION_ROOT    , dissect_doContinuousIndependentProgressions },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_RepeatCount(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_RepeatCount, RepeatCount_choice, "RepeatCount",
                              NULL);

  return offset;
}
static int dissect_repeatCount(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RepeatCount(tvb, offset, pinfo, tree, hf_h245_repeatCount);
}

static const per_sequence_t T_progressiveRefinementStart_sequence[] = {
  { "repeatCount"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_repeatCount },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_progressiveRefinementStart(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_progressiveRefinementStart, T_progressiveRefinementStart_sequence);

  return offset;
}
static int dissect_progressiveRefinementStart(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_progressiveRefinementStart(tvb, offset, pinfo, tree, hf_h245_progressiveRefinementStart);
}



static int
dissect_h245_INTEGER_1_9216(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           1U, 9216U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_firstMB(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_9216(tvb, offset, pinfo, tree, hf_h245_firstMB);
}
static int dissect_numberOfMBs1_1_9216(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_1_9216(tvb, offset, pinfo, tree, hf_h245_numberOfMBs1_1_9216);
}

static const per_sequence_t T_videoBadMBs_sequence[] = {
  { "firstMB"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_firstMB },
  { "numberOfMBs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfMBs1_1_9216 },
  { "temporalReference"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_temporalReference },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_videoBadMBs(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_videoBadMBs, T_videoBadMBs_sequence);

  return offset;
}
static int dissect_videoBadMBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_videoBadMBs(tvb, offset, pinfo, tree, hf_h245_videoBadMBs);
}


static const value_string h245_PictureReference_vals[] = {
  {   0, "pictureNumber" },
  {   1, "longTermPictureIndex" },
  { 0, NULL }
};

static const per_choice_t PictureReference_choice[] = {
  {   0, "pictureNumber"               , ASN1_EXTENSION_ROOT    , dissect_pictureNumber },
  {   1, "longTermPictureIndex"        , ASN1_EXTENSION_ROOT    , dissect_longTermPictureIndex },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_PictureReference(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_PictureReference, PictureReference_choice, "PictureReference",
                              NULL);

  return offset;
}
static int dissect_lostPicture_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_PictureReference(tvb, offset, pinfo, tree, hf_h245_lostPicture_item);
}
static int dissect_pictureReference(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_PictureReference(tvb, offset, pinfo, tree, hf_h245_pictureReference);
}
static int dissect_recoveryReferencePicture_item(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_PictureReference(tvb, offset, pinfo, tree, hf_h245_recoveryReferencePicture_item);
}


static int
dissect_h245_SEQUENCE_OF_PictureReference(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence_of(tvb, offset, pinfo, tree, hf_index,
                                   ett_h245_SEQUENCE_OF_PictureReference, dissect_lostPicture_item);

  return offset;
}
static int dissect_lostPicture(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_PictureReference(tvb, offset, pinfo, tree, hf_h245_lostPicture);
}
static int dissect_recoveryReferencePicture(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SEQUENCE_OF_PictureReference(tvb, offset, pinfo, tree, hf_h245_recoveryReferencePicture);
}

static const per_sequence_t T_lostPartialPicture_sequence[] = {
  { "pictureReference"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_pictureReference },
  { "firstMB"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_firstMB },
  { "numberOfMBs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfMBs1_1_9216 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_lostPartialPicture(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_lostPartialPicture, T_lostPartialPicture_sequence);

  return offset;
}
static int dissect_lostPartialPicture(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_lostPartialPicture(tvb, offset, pinfo, tree, hf_h245_lostPartialPicture);
}

static const per_sequence_t T_encryptionUpdateCommand_sequence[] = {
  { "encryptionSync"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_encryptionSync },
  { "multiplePayloadStream"       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_multiplePayloadStream },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_encryptionUpdateCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_encryptionUpdateCommand, T_encryptionUpdateCommand_sequence);

  return offset;
}
static int dissect_encryptionUpdateCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_encryptionUpdateCommand(tvb, offset, pinfo, tree, hf_h245_encryptionUpdateCommand);
}

static const per_sequence_t T_encryptionUpdateAck_sequence[] = {
  { "synchFlag"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_synchFlag },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_encryptionUpdateAck(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_encryptionUpdateAck, T_encryptionUpdateAck_sequence);

  return offset;
}
static int dissect_encryptionUpdateAck(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_encryptionUpdateAck(tvb, offset, pinfo, tree, hf_h245_encryptionUpdateAck);
}


static const value_string h245_Mc_type_vals[] = {
  {   0, "equaliseDelay" },
  {   1, "zeroDelay" },
  {   2, "multipointModeCommand" },
  {   3, "cancelMultipointModeCommand" },
  {   4, "videoFreezePicture" },
  {   5, "videoFastUpdatePicture" },
  {   6, "videoFastUpdateGOB" },
  {   7, "videoTemporalSpatialTradeOff" },
  {   8, "videoSendSyncEveryGOB" },
  {   9, "videoSendSyncEveryGOBCancel" },
  {  10, "videoFastUpdateMB" },
  {  11, "maxH223MUXPDUsize" },
  {  12, "encryptionUpdate" },
  {  13, "encryptionUpdateRequest" },
  {  14, "switchReceiveMediaOff" },
  {  15, "switchReceiveMediaOn" },
  {  16, "progressiveRefinementStart" },
  {  17, "progressiveRefinementAbortOne" },
  {  18, "progressiveRefinementAbortContinuous" },
  {  19, "videoBadMBs" },
  {  20, "lostPicture" },
  {  21, "lostPartialPicture" },
  {  22, "recoveryReferencePicture" },
  {  23, "encryptionUpdateCommand" },
  {  24, "encryptionUpdateAck" },
  { 0, NULL }
};

static const per_choice_t Mc_type_choice[] = {
  {   0, "equaliseDelay"               , ASN1_EXTENSION_ROOT    , dissect_equaliseDelay },
  {   1, "zeroDelay"                   , ASN1_EXTENSION_ROOT    , dissect_zeroDelay },
  {   2, "multipointModeCommand"       , ASN1_EXTENSION_ROOT    , dissect_multipointModeCommand },
  {   3, "cancelMultipointModeCommand" , ASN1_EXTENSION_ROOT    , dissect_cancelMultipointModeCommand },
  {   4, "videoFreezePicture"          , ASN1_EXTENSION_ROOT    , dissect_videoFreezePicture },
  {   5, "videoFastUpdatePicture"      , ASN1_EXTENSION_ROOT    , dissect_videoFastUpdatePicture },
  {   6, "videoFastUpdateGOB"          , ASN1_EXTENSION_ROOT    , dissect_videoFastUpdateGOB },
  {   7, "videoTemporalSpatialTradeOff", ASN1_EXTENSION_ROOT    , dissect_videoTemporalSpatialTradeOff },
  {   8, "videoSendSyncEveryGOB"       , ASN1_EXTENSION_ROOT    , dissect_videoSendSyncEveryGOB },
  {   9, "videoSendSyncEveryGOBCancel" , ASN1_EXTENSION_ROOT    , dissect_videoSendSyncEveryGOBCancel },
  {  10, "videoFastUpdateMB"           , ASN1_NOT_EXTENSION_ROOT, dissect_videoFastUpdateMB },
  {  11, "maxH223MUXPDUsize"           , ASN1_NOT_EXTENSION_ROOT, dissect_maxH223MUXPDUsize },
  {  12, "encryptionUpdate"            , ASN1_NOT_EXTENSION_ROOT, dissect_encryptionUpdate },
  {  13, "encryptionUpdateRequest"     , ASN1_NOT_EXTENSION_ROOT, dissect_encryptionUpdateRequest },
  {  14, "switchReceiveMediaOff"       , ASN1_NOT_EXTENSION_ROOT, dissect_switchReceiveMediaOff },
  {  15, "switchReceiveMediaOn"        , ASN1_NOT_EXTENSION_ROOT, dissect_switchReceiveMediaOn },
  {  16, "progressiveRefinementStart"  , ASN1_NOT_EXTENSION_ROOT, dissect_progressiveRefinementStart },
  {  17, "progressiveRefinementAbortOne", ASN1_NOT_EXTENSION_ROOT, dissect_progressiveRefinementAbortOne },
  {  18, "progressiveRefinementAbortContinuous", ASN1_NOT_EXTENSION_ROOT, dissect_progressiveRefinementAbortContinuous },
  {  19, "videoBadMBs"                 , ASN1_NOT_EXTENSION_ROOT, dissect_videoBadMBs },
  {  20, "lostPicture"                 , ASN1_NOT_EXTENSION_ROOT, dissect_lostPicture },
  {  21, "lostPartialPicture"          , ASN1_NOT_EXTENSION_ROOT, dissect_lostPartialPicture },
  {  22, "recoveryReferencePicture"    , ASN1_NOT_EXTENSION_ROOT, dissect_recoveryReferencePicture },
  {  23, "encryptionUpdateCommand"     , ASN1_NOT_EXTENSION_ROOT, dissect_encryptionUpdateCommand },
  {  24, "encryptionUpdateAck"         , ASN1_NOT_EXTENSION_ROOT, dissect_encryptionUpdateAck },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mc_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mc_type, Mc_type_choice, "Mc_type",
                              NULL);

  return offset;
}
static int dissect_mc_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mc_type(tvb, offset, pinfo, tree, hf_h245_mc_type);
}


static const value_string h245_EncryptionUpdateDirection_vals[] = {
  {   0, "masterToSlave" },
  {   1, "slaveToMaster" },
  { 0, NULL }
};

static const per_choice_t EncryptionUpdateDirection_choice[] = {
  {   0, "masterToSlave"               , ASN1_EXTENSION_ROOT    , dissect_masterToSlave },
  {   1, "slaveToMaster"               , ASN1_EXTENSION_ROOT    , dissect_slaveToMaster },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_EncryptionUpdateDirection(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_EncryptionUpdateDirection, EncryptionUpdateDirection_choice, "EncryptionUpdateDirection",
                              NULL);

  return offset;
}
static int dissect_direction(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptionUpdateDirection(tvb, offset, pinfo, tree, hf_h245_direction);
}

static const per_sequence_t MiscellaneousCommand_sequence[] = {
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mc_type },
  { "direction"                   , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_direction },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MiscellaneousCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MiscellaneousCommand, MiscellaneousCommand_sequence);

  return offset;
}
static int dissect_miscellaneousCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MiscellaneousCommand(tvb, offset, pinfo, tree, hf_h245_miscellaneousCommand);
}

static const per_sequence_t CommunicationModeCommand_sequence[] = {
  { "communicationModeTable"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_communicationModeTable },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_CommunicationModeCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_CommunicationModeCommand, CommunicationModeCommand_sequence);

  return offset;
}
static int dissect_communicationModeCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CommunicationModeCommand(tvb, offset, pinfo, tree, hf_h245_communicationModeCommand);
}

static const per_sequence_t SubstituteConferenceIDCommand_sequence[] = {
  { "conferenceIdentifier"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_conferenceIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_SubstituteConferenceIDCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_SubstituteConferenceIDCommand, SubstituteConferenceIDCommand_sequence);

  return offset;
}
static int dissect_substituteConferenceIDCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_SubstituteConferenceIDCommand(tvb, offset, pinfo, tree, hf_h245_substituteConferenceIDCommand);
}


static const value_string h245_ConferenceCommand_vals[] = {
  {   0, "broadcastMyLogicalChannel" },
  {   1, "cancelBroadcastMyLogicalChannel" },
  {   2, "makeTerminalBroadcaster" },
  {   3, "cancelMakeTerminalBroadcaster" },
  {   4, "sendThisSource" },
  {   5, "cancelSendThisSource" },
  {   6, "dropConference" },
  {   7, "substituteConferenceIDCommand" },
  { 0, NULL }
};

static const per_choice_t ConferenceCommand_choice[] = {
  {   0, "broadcastMyLogicalChannel"   , ASN1_EXTENSION_ROOT    , dissect_broadcastMyLogicalChannel },
  {   1, "cancelBroadcastMyLogicalChannel", ASN1_EXTENSION_ROOT    , dissect_cancelBroadcastMyLogicalChannel },
  {   2, "makeTerminalBroadcaster"     , ASN1_EXTENSION_ROOT    , dissect_makeTerminalBroadcaster },
  {   3, "cancelMakeTerminalBroadcaster", ASN1_EXTENSION_ROOT    , dissect_cancelMakeTerminalBroadcaster },
  {   4, "sendThisSource"              , ASN1_EXTENSION_ROOT    , dissect_sendThisSource },
  {   5, "cancelSendThisSource"        , ASN1_EXTENSION_ROOT    , dissect_cancelSendThisSource },
  {   6, "dropConference"              , ASN1_EXTENSION_ROOT    , dissect_dropConference },
  {   7, "substituteConferenceIDCommand", ASN1_NOT_EXTENSION_ROOT, dissect_substituteConferenceIDCommand },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ConferenceCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ConferenceCommand, ConferenceCommand_choice, "ConferenceCommand",
                              NULL);

  return offset;
}
static int dissect_conferenceCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceCommand(tvb, offset, pinfo, tree, hf_h245_conferenceCommand);
}


static const value_string h245_T_h223ModeChange_vals[] = {
  {   0, "toLevel0" },
  {   1, "toLevel1" },
  {   2, "toLevel2" },
  {   3, "toLevel2withOptionalHeader" },
  { 0, NULL }
};

static const per_choice_t T_h223ModeChange_choice[] = {
  {   0, "toLevel0"                    , ASN1_EXTENSION_ROOT    , dissect_toLevel0 },
  {   1, "toLevel1"                    , ASN1_EXTENSION_ROOT    , dissect_toLevel1 },
  {   2, "toLevel2"                    , ASN1_EXTENSION_ROOT    , dissect_toLevel2 },
  {   3, "toLevel2withOptionalHeader"  , ASN1_EXTENSION_ROOT    , dissect_toLevel2withOptionalHeader },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_h223ModeChange(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_h223ModeChange, T_h223ModeChange_choice, "T_h223ModeChange",
                              NULL);

  return offset;
}
static int dissect_h223ModeChange(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_h223ModeChange(tvb, offset, pinfo, tree, hf_h245_h223ModeChange);
}


static const value_string h245_T_h223AnnexADoubleFlag_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  { 0, NULL }
};

static const per_choice_t T_h223AnnexADoubleFlag_choice[] = {
  {   0, "start"                       , ASN1_EXTENSION_ROOT    , dissect_start },
  {   1, "stop"                        , ASN1_EXTENSION_ROOT    , dissect_stop },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_h223AnnexADoubleFlag(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_h223AnnexADoubleFlag, T_h223AnnexADoubleFlag_choice, "T_h223AnnexADoubleFlag",
                              NULL);

  return offset;
}
static int dissect_h223AnnexADoubleFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_h223AnnexADoubleFlag(tvb, offset, pinfo, tree, hf_h245_h223AnnexADoubleFlag);
}


static const value_string h245_H223MultiplexReconfiguration_vals[] = {
  {   0, "h223ModeChange" },
  {   1, "h223AnnexADoubleFlag" },
  { 0, NULL }
};

static const per_choice_t H223MultiplexReconfiguration_choice[] = {
  {   0, "h223ModeChange"              , ASN1_EXTENSION_ROOT    , dissect_h223ModeChange },
  {   1, "h223AnnexADoubleFlag"        , ASN1_EXTENSION_ROOT    , dissect_h223AnnexADoubleFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_H223MultiplexReconfiguration(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_H223MultiplexReconfiguration, H223MultiplexReconfiguration_choice, "H223MultiplexReconfiguration",
                              NULL);

  return offset;
}
static int dissect_h223MultiplexReconfiguration(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223MultiplexReconfiguration(tvb, offset, pinfo, tree, hf_h245_h223MultiplexReconfiguration);
}


static const value_string h245_Cmd_clockRecovery_vals[] = {
  {   0, "nullClockRecovery" },
  {   1, "srtsClockRecovery" },
  {   2, "adaptiveClockRecovery" },
  { 0, NULL }
};

static const per_choice_t Cmd_clockRecovery_choice[] = {
  {   0, "nullClockRecovery"           , ASN1_EXTENSION_ROOT    , dissect_nullClockRecoveryflag },
  {   1, "srtsClockRecovery"           , ASN1_EXTENSION_ROOT    , dissect_srtsClockRecovery },
  {   2, "adaptiveClockRecovery"       , ASN1_EXTENSION_ROOT    , dissect_adaptiveClockRecoveryFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Cmd_clockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Cmd_clockRecovery, Cmd_clockRecovery_choice, "Cmd_clockRecovery",
                              NULL);

  return offset;
}
static int dissect_cmd_clockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_clockRecovery(tvb, offset, pinfo, tree, hf_h245_cmd_clockRecovery);
}


static const value_string h245_Cmd_errorCorrection_vals[] = {
  {   0, "nullErrorCorrection" },
  {   1, "longInterleaver" },
  {   2, "shortInterleaver" },
  {   3, "errorCorrectionOnly" },
  { 0, NULL }
};

static const per_choice_t Cmd_errorCorrection_choice[] = {
  {   0, "nullErrorCorrection"         , ASN1_EXTENSION_ROOT    , dissect_nullErrorCorrectionFlag },
  {   1, "longInterleaver"             , ASN1_EXTENSION_ROOT    , dissect_longInterleaverFlag },
  {   2, "shortInterleaver"            , ASN1_EXTENSION_ROOT    , dissect_shortInterleaverFlag },
  {   3, "errorCorrectionOnly"         , ASN1_EXTENSION_ROOT    , dissect_errorCorrectionOnlyFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Cmd_errorCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Cmd_errorCorrection, Cmd_errorCorrection_choice, "Cmd_errorCorrection",
                              NULL);

  return offset;
}
static int dissect_cmd_errorCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_errorCorrection(tvb, offset, pinfo, tree, hf_h245_cmd_errorCorrection);
}

static const per_sequence_t Cmd_aal1_sequence[] = {
  { "clockRecovery"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmd_clockRecovery },
  { "errorCorrection"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmd_errorCorrection },
  { "structuredDataTransfer"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_structuredDataTransfer },
  { "partiallyFilledCells"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partiallyFilledCells },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Cmd_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Cmd_aal1, Cmd_aal1_sequence);

  return offset;
}
static int dissect_cmd_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_aal1(tvb, offset, pinfo, tree, hf_h245_cmd_aal1);
}

static const per_sequence_t Cmd_aal5_sequence[] = {
  { "forwardMaximumSDUSize"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardMaximumSDUSize },
  { "backwardMaximumSDUSize"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_backwardMaximumSDUSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Cmd_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Cmd_aal5, Cmd_aal5_sequence);

  return offset;
}
static int dissect_cmd_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_aal5(tvb, offset, pinfo, tree, hf_h245_cmd_aal5);
}


static const value_string h245_Cmd_aal_vals[] = {
  {   0, "aal1" },
  {   1, "aal5" },
  { 0, NULL }
};

static const per_choice_t Cmd_aal_choice[] = {
  {   0, "aal1"                        , ASN1_EXTENSION_ROOT    , dissect_cmd_aal1 },
  {   1, "aal5"                        , ASN1_EXTENSION_ROOT    , dissect_cmd_aal5 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Cmd_aal(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Cmd_aal, Cmd_aal_choice, "Cmd_aal",
                              NULL);

  return offset;
}
static int dissect_cmd_aal(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_aal(tvb, offset, pinfo, tree, hf_h245_cmd_aal);
}


static const value_string h245_Cmd_multiplex_vals[] = {
  {   0, "noMultiplex" },
  {   1, "transportStream" },
  {   2, "programStream" },
  { 0, NULL }
};

static const per_choice_t Cmd_multiplex_choice[] = {
  {   0, "noMultiplex"                 , ASN1_EXTENSION_ROOT    , dissect_noMultiplex },
  {   1, "transportStream"             , ASN1_EXTENSION_ROOT    , dissect_transportStream },
  {   2, "programStream"               , ASN1_EXTENSION_ROOT    , dissect_programStreamFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Cmd_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Cmd_multiplex, Cmd_multiplex_choice, "Cmd_multiplex",
                              NULL);

  return offset;
}
static int dissect_cmd_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_multiplex(tvb, offset, pinfo, tree, hf_h245_cmd_multiplex);
}


static const value_string h245_CmdR_multiplex_vals[] = {
  {   0, "noMultiplex" },
  {   1, "transportStream" },
  {   2, "programStream" },
  { 0, NULL }
};

static const per_choice_t CmdR_multiplex_choice[] = {
  {   0, "noMultiplex"                 , ASN1_EXTENSION_ROOT    , dissect_noMultiplex },
  {   1, "transportStream"             , ASN1_EXTENSION_ROOT    , dissect_transportStream },
  {   2, "programStream"               , ASN1_EXTENSION_ROOT    , dissect_programStreamFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CmdR_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CmdR_multiplex, CmdR_multiplex_choice, "CmdR_multiplex",
                              NULL);

  return offset;
}
static int dissect_cmdr_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CmdR_multiplex(tvb, offset, pinfo, tree, hf_h245_cmdr_multiplex);
}

static const per_sequence_t Cmd_reverseParameters_sequence[] = {
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate },
  { "bitRateLockedToPCRClock"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToPCRClock },
  { "bitRateLockedToNetworkClock" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToNetworkClock },
  { "multiplex"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmdr_multiplex },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Cmd_reverseParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Cmd_reverseParameters, Cmd_reverseParameters_sequence);

  return offset;
}
static int dissect_cmd_reverseParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Cmd_reverseParameters(tvb, offset, pinfo, tree, hf_h245_cmd_reverseParameters);
}

static const per_sequence_t NewATMVCCommand_sequence[] = {
  { "resourceID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_resourceID },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate },
  { "bitRateLockedToPCRClock"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToPCRClock },
  { "bitRateLockedToNetworkClock" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToNetworkClock },
  { "aal"                         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmd_aal },
  { "multiplex"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmd_multiplex },
  { "reverseParameters"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_cmd_reverseParameters },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NewATMVCCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NewATMVCCommand, NewATMVCCommand_sequence);

  return offset;
}
static int dissect_newATMVCCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NewATMVCCommand(tvb, offset, pinfo, tree, hf_h245_newATMVCCommand);
}


static const value_string h245_T_status_vals[] = {
  {   0, "synchronized" },
  {   1, "reconfiguration" },
  { 0, NULL }
};

static const per_choice_t T_status_choice[] = {
  {   0, "synchronized"                , ASN1_EXTENSION_ROOT    , dissect_synchronized },
  {   1, "reconfiguration"             , ASN1_EXTENSION_ROOT    , dissect_reconfiguration },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_status(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_status, T_status_choice, "T_status",
                              NULL);

  return offset;
}
static int dissect_status(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_status(tvb, offset, pinfo, tree, hf_h245_status);
}

static const per_sequence_t MobileMultilinkReconfigurationCommand_sequence[] = {
  { "sampleSize"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sampleSize },
  { "samplesPerFrame"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_samplesPerFrame },
  { "status"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_status },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MobileMultilinkReconfigurationCommand(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MobileMultilinkReconfigurationCommand, MobileMultilinkReconfigurationCommand_sequence);

  return offset;
}
static int dissect_mobileMultilinkReconfigurationCommand(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MobileMultilinkReconfigurationCommand(tvb, offset, pinfo, tree, hf_h245_mobileMultilinkReconfigurationCommand);
}


static const value_string h245_CommandMessage_vals[] = {
  {   0, "nonStandard" },
  {   1, "maintenanceLoopOffCommand" },
  {   2, "sendTerminalCapabilitySet" },
  {   3, "encryptionCommand" },
  {   4, "flowControlCommand" },
  {   5, "endSessionCommand" },
  {   6, "miscellaneousCommand" },
  {   7, "communicationModeCommand" },
  {   8, "conferenceCommand" },
  {   9, "h223MultiplexReconfiguration" },
  {  10, "newATMVCCommand" },
  {  11, "mobileMultilinkReconfigurationCommand" },
  {  12, "genericCommand" },
  { 0, NULL }
};

static const per_choice_t CommandMessage_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "maintenanceLoopOffCommand"   , ASN1_EXTENSION_ROOT    , dissect_maintenanceLoopOffCommand },
  {   2, "sendTerminalCapabilitySet"   , ASN1_EXTENSION_ROOT    , dissect_sendTerminalCapabilitySet },
  {   3, "encryptionCommand"           , ASN1_EXTENSION_ROOT    , dissect_encryptionCommand },
  {   4, "flowControlCommand"          , ASN1_EXTENSION_ROOT    , dissect_flowControlCommand },
  {   5, "endSessionCommand"           , ASN1_EXTENSION_ROOT    , dissect_endSessionCommand },
  {   6, "miscellaneousCommand"        , ASN1_EXTENSION_ROOT    , dissect_miscellaneousCommand },
  {   7, "communicationModeCommand"    , ASN1_NOT_EXTENSION_ROOT, dissect_communicationModeCommand },
  {   8, "conferenceCommand"           , ASN1_NOT_EXTENSION_ROOT, dissect_conferenceCommand },
  {   9, "h223MultiplexReconfiguration", ASN1_NOT_EXTENSION_ROOT, dissect_h223MultiplexReconfiguration },
  {  10, "newATMVCCommand"             , ASN1_NOT_EXTENSION_ROOT, dissect_newATMVCCommand },
  {  11, "mobileMultilinkReconfigurationCommand", ASN1_NOT_EXTENSION_ROOT, dissect_mobileMultilinkReconfigurationCommand },
  {  12, "genericCommand"              , ASN1_NOT_EXTENSION_ROOT, dissect_genericCommand },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_CommandMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_CommandMessage, CommandMessage_choice, "CommandMessage",
                              &value);


	if (check_col(pinfo->cinfo, COL_INFO)){
	        if ( h245_shorttypes == TRUE )
	        {
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_CommandMessage_short_vals, "<unknown>"));
		}
		else
		{
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_CommandMessage_vals, "<unknown>"));
		}
	}

	col_set_fence(pinfo->cinfo,COL_INFO);
    /* Add to packet info */
    g_snprintf(h245_pi->frame_label, 50, "%s %s ", h245_pi->frame_label, val_to_str(value, h245_CommandMessage_short_vals, "UKN"));
    g_snprintf(h245_pi->comment, 50, "%s %s ", h245_pi->comment, val_to_str(value, h245_CommandMessage_vals, "<unknown>"));


  return offset;
}
static int dissect_command(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_CommandMessage(tvb, offset, pinfo, tree, hf_h245_command);
}


static const value_string h245_FunctionNotUnderstood_vals[] = {
  {   0, "request" },
  {   1, "response" },
  {   2, "command" },
  { 0, NULL }
};

static const per_choice_t FunctionNotUnderstood_choice[] = {
  {   0, "request"                     , ASN1_NO_EXTENSIONS     , dissect_request },
  {   1, "response"                    , ASN1_NO_EXTENSIONS     , dissect_response },
  {   2, "command"                     , ASN1_NO_EXTENSIONS     , dissect_command },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FunctionNotUnderstood(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FunctionNotUnderstood, FunctionNotUnderstood_choice, "FunctionNotUnderstood",
                              NULL);

  return offset;
}
static int dissect_functionNotUnderstood(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FunctionNotUnderstood(tvb, offset, pinfo, tree, hf_h245_functionNotUnderstood);
}

static const per_sequence_t MasterSlaveDeterminationRelease_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MasterSlaveDeterminationRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MasterSlaveDeterminationRelease, MasterSlaveDeterminationRelease_sequence);


  h245_pi->msg_type = H245_MastSlvDetRls;
  return offset;
}
static int dissect_masterSlaveDeterminationRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MasterSlaveDeterminationRelease(tvb, offset, pinfo, tree, hf_h245_masterSlaveDeterminationRelease);
}

static const per_sequence_t TerminalCapabilitySetRelease_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalCapabilitySetRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalCapabilitySetRelease, TerminalCapabilitySetRelease_sequence);


  h245_pi->msg_type = H245_TermCapSetRls;
  return offset;
}
static int dissect_terminalCapabilitySetRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalCapabilitySetRelease(tvb, offset, pinfo, tree, hf_h245_terminalCapabilitySetRelease);
}

static const per_sequence_t OpenLogicalChannelConfirm_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_OpenLogicalChannelConfirm(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OpenLogicalChannelConfirm, OpenLogicalChannelConfirm_sequence);


  h245_pi->msg_type = H245_OpenLogChnCnf;
  return offset;
}
static int dissect_openLogicalChannelConfirm(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OpenLogicalChannelConfirm(tvb, offset, pinfo, tree, hf_h245_openLogicalChannelConfirm);
}

static const per_sequence_t RequestChannelCloseRelease_sequence[] = {
  { "forwardLogicalChannelNumber" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardLogicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestChannelCloseRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestChannelCloseRelease, RequestChannelCloseRelease_sequence);

  return offset;
}
static int dissect_requestChannelCloseRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestChannelCloseRelease(tvb, offset, pinfo, tree, hf_h245_requestChannelCloseRelease);
}

static const per_sequence_t MultiplexEntrySendRelease_sequence[] = {
  { "multiplexTableEntryNumber"   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_multiplexTableEntryNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MultiplexEntrySendRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MultiplexEntrySendRelease, MultiplexEntrySendRelease_sequence);

  return offset;
}
static int dissect_multiplexEntrySendRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultiplexEntrySendRelease(tvb, offset, pinfo, tree, hf_h245_multiplexEntrySendRelease);
}

static const per_sequence_t RequestMultiplexEntryRelease_sequence[] = {
  { "entryNumbers"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_entryNumbers },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestMultiplexEntryRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestMultiplexEntryRelease, RequestMultiplexEntryRelease_sequence);

  return offset;
}
static int dissect_requestMultiplexEntryRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestMultiplexEntryRelease(tvb, offset, pinfo, tree, hf_h245_requestMultiplexEntryRelease);
}

static const per_sequence_t RequestModeRelease_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_RequestModeRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_RequestModeRelease, RequestModeRelease_sequence);

  return offset;
}
static int dissect_requestModeRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_RequestModeRelease(tvb, offset, pinfo, tree, hf_h245_requestModeRelease);
}

static const per_sequence_t T_videoNotDecodedMBs_sequence[] = {
  { "firstMB"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_firstMB_1_8192 },
  { "numberOfMBs"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_numberOfMBs },
  { "temporalReference"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_temporalReference_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_videoNotDecodedMBs(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_videoNotDecodedMBs, T_videoNotDecodedMBs_sequence);

  return offset;
}
static int dissect_videoNotDecodedMBs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_videoNotDecodedMBs(tvb, offset, pinfo, tree, hf_h245_videoNotDecodedMBs);
}


static const value_string h245_Mi_type_vals[] = {
  {   0, "logicalChannelActive" },
  {   1, "logicalChannelInactive" },
  {   2, "multipointConference" },
  {   3, "cancelMultipointConference" },
  {   4, "multipointZeroComm" },
  {   5, "cancelMultipointZeroComm" },
  {   6, "multipointSecondaryStatus" },
  {   7, "cancelMultipointSecondaryStatus" },
  {   8, "videoIndicateReadyToActivate" },
  {   9, "videoTemporalSpatialTradeOff" },
  {  10, "videoNotDecodedMBs" },
  {  11, "transportCapability" },
  { 0, NULL }
};

static const per_choice_t Mi_type_choice[] = {
  {   0, "logicalChannelActive"        , ASN1_EXTENSION_ROOT    , dissect_logicalChannelActive },
  {   1, "logicalChannelInactive"      , ASN1_EXTENSION_ROOT    , dissect_logicalChannelInactive },
  {   2, "multipointConference"        , ASN1_EXTENSION_ROOT    , dissect_multipointConference },
  {   3, "cancelMultipointConference"  , ASN1_EXTENSION_ROOT    , dissect_cancelMultipointConference },
  {   4, "multipointZeroComm"          , ASN1_EXTENSION_ROOT    , dissect_multipointZeroComm },
  {   5, "cancelMultipointZeroComm"    , ASN1_EXTENSION_ROOT    , dissect_cancelMultipointZeroComm },
  {   6, "multipointSecondaryStatus"   , ASN1_EXTENSION_ROOT    , dissect_multipointSecondaryStatus },
  {   7, "cancelMultipointSecondaryStatus", ASN1_EXTENSION_ROOT    , dissect_cancelMultipointSecondaryStatus },
  {   8, "videoIndicateReadyToActivate", ASN1_EXTENSION_ROOT    , dissect_videoIndicateReadyToActivate },
  {   9, "videoTemporalSpatialTradeOff", ASN1_EXTENSION_ROOT    , dissect_videoTemporalSpatialTradeOff },
  {  10, "videoNotDecodedMBs"          , ASN1_NOT_EXTENSION_ROOT, dissect_videoNotDecodedMBs },
  {  11, "transportCapability"         , ASN1_NOT_EXTENSION_ROOT, dissect_transportCapability },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Mi_type(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Mi_type, Mi_type_choice, "Mi_type",
                              NULL);

  return offset;
}
static int dissect_mi_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Mi_type(tvb, offset, pinfo, tree, hf_h245_mi_type);
}

static const per_sequence_t MiscellaneousIndication_sequence[] = {
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { "type"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_mi_type },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MiscellaneousIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MiscellaneousIndication, MiscellaneousIndication_sequence);

  return offset;
}
static int dissect_miscellaneousIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MiscellaneousIndication(tvb, offset, pinfo, tree, hf_h245_miscellaneousIndication);
}



static int
dissect_h245_INTEGER_0_3(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 3U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_estimatedReceivedJitterMantissa(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_3(tvb, offset, pinfo, tree, hf_h245_estimatedReceivedJitterMantissa);
}



static int
dissect_h245_INTEGER_0_7(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 7U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_estimatedReceivedJitterExponent(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_7(tvb, offset, pinfo, tree, hf_h245_estimatedReceivedJitterExponent);
}

static const per_sequence_t JitterIndication_sequence[] = {
  { "scope"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scope },
  { "estimatedReceivedJitterMantissa", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_estimatedReceivedJitterMantissa },
  { "estimatedReceivedJitterExponent", ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_estimatedReceivedJitterExponent },
  { "skippedFrameCount"           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_skippedFrameCount },
  { "additionalDecoderBuffer"     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_additionalDecoderBuffer },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_JitterIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_JitterIndication, JitterIndication_sequence);

  return offset;
}
static int dissect_jitterIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_JitterIndication(tvb, offset, pinfo, tree, hf_h245_jitterIndication);
}



static int
dissect_h245_INTEGER_0_4095(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 4095U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_skew(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4095(tvb, offset, pinfo, tree, hf_h245_skew);
}
static int dissect_maximumSkew(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_4095(tvb, offset, pinfo, tree, hf_h245_maximumSkew);
}

static const per_sequence_t H223SkewIndication_sequence[] = {
  { "logicalChannelNumber1"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber1 },
  { "logicalChannelNumber2"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber2 },
  { "skew"                        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_skew },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H223SkewIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H223SkewIndication, H223SkewIndication_sequence);

  return offset;
}
static int dissect_h223SkewIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H223SkewIndication(tvb, offset, pinfo, tree, hf_h245_h223SkewIndication);
}


static const value_string h245_Ind_clockRecovery_vals[] = {
  {   0, "nullClockRecovery" },
  {   1, "srtsClockRecovery" },
  {   2, "adaptiveClockRecovery" },
  { 0, NULL }
};

static const per_choice_t Ind_clockRecovery_choice[] = {
  {   0, "nullClockRecovery"           , ASN1_EXTENSION_ROOT    , dissect_nullClockRecoveryflag },
  {   1, "srtsClockRecovery"           , ASN1_EXTENSION_ROOT    , dissect_srtsClockRecovery },
  {   2, "adaptiveClockRecovery"       , ASN1_EXTENSION_ROOT    , dissect_adaptiveClockRecoveryFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Ind_clockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Ind_clockRecovery, Ind_clockRecovery_choice, "Ind_clockRecovery",
                              NULL);

  return offset;
}
static int dissect_ind_clockRecovery(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_clockRecovery(tvb, offset, pinfo, tree, hf_h245_ind_clockRecovery);
}


static const value_string h245_Ind_errorCorrection_vals[] = {
  {   0, "nullErrorCorrection" },
  {   1, "longInterleaver" },
  {   2, "shortInterleaver" },
  {   3, "errorCorrectionOnly" },
  { 0, NULL }
};

static const per_choice_t Ind_errorCorrection_choice[] = {
  {   0, "nullErrorCorrection"         , ASN1_EXTENSION_ROOT    , dissect_nullErrorCorrectionFlag },
  {   1, "longInterleaver"             , ASN1_EXTENSION_ROOT    , dissect_longInterleaverFlag },
  {   2, "shortInterleaver"            , ASN1_EXTENSION_ROOT    , dissect_shortInterleaverFlag },
  {   3, "errorCorrectionOnly"         , ASN1_EXTENSION_ROOT    , dissect_errorCorrectionOnlyFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Ind_errorCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Ind_errorCorrection, Ind_errorCorrection_choice, "Ind_errorCorrection",
                              NULL);

  return offset;
}
static int dissect_ind_errorCorrection(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_errorCorrection(tvb, offset, pinfo, tree, hf_h245_ind_errorCorrection);
}

static const per_sequence_t Ind_aal1_sequence[] = {
  { "clockRecovery"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ind_clockRecovery },
  { "errorCorrection"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ind_errorCorrection },
  { "structuredDataTransfer"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_structuredDataTransfer },
  { "partiallyFilledCells"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_partiallyFilledCells },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Ind_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Ind_aal1, Ind_aal1_sequence);

  return offset;
}
static int dissect_ind_aal1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_aal1(tvb, offset, pinfo, tree, hf_h245_ind_aal1);
}

static const per_sequence_t Ind_aal5_sequence[] = {
  { "forwardMaximumSDUSize"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_forwardMaximumSDUSize },
  { "backwardMaximumSDUSize"      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_backwardMaximumSDUSize },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Ind_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Ind_aal5, Ind_aal5_sequence);

  return offset;
}
static int dissect_ind_aal5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_aal5(tvb, offset, pinfo, tree, hf_h245_ind_aal5);
}


static const value_string h245_Ind_aal_vals[] = {
  {   0, "aal1" },
  {   1, "aal5" },
  { 0, NULL }
};

static const per_choice_t Ind_aal_choice[] = {
  {   0, "aal1"                        , ASN1_EXTENSION_ROOT    , dissect_ind_aal1 },
  {   1, "aal5"                        , ASN1_EXTENSION_ROOT    , dissect_ind_aal5 },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Ind_aal(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Ind_aal, Ind_aal_choice, "Ind_aal",
                              NULL);

  return offset;
}
static int dissect_ind_aal(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_aal(tvb, offset, pinfo, tree, hf_h245_ind_aal);
}


static const value_string h245_Ind_multiplex_vals[] = {
  {   0, "noMultiplex" },
  {   1, "transportStream" },
  {   2, "programStream" },
  { 0, NULL }
};

static const per_choice_t Ind_multiplex_choice[] = {
  {   0, "noMultiplex"                 , ASN1_EXTENSION_ROOT    , dissect_noMultiplex },
  {   1, "transportStream"             , ASN1_EXTENSION_ROOT    , dissect_transportStream },
  {   2, "programStream"               , ASN1_EXTENSION_ROOT    , dissect_programStreamFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Ind_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Ind_multiplex, Ind_multiplex_choice, "Ind_multiplex",
                              NULL);

  return offset;
}
static int dissect_ind_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_multiplex(tvb, offset, pinfo, tree, hf_h245_ind_multiplex);
}


static const value_string h245_IndR_multiplex_vals[] = {
  {   0, "noMultiplex" },
  {   1, "transportStream" },
  {   2, "programStream" },
  { 0, NULL }
};

static const per_choice_t IndR_multiplex_choice[] = {
  {   0, "noMultiplex"                 , ASN1_EXTENSION_ROOT    , dissect_noMultiplex },
  {   1, "transportStream"             , ASN1_EXTENSION_ROOT    , dissect_transportStream },
  {   2, "programStream"               , ASN1_EXTENSION_ROOT    , dissect_programStreamFlag },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IndR_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IndR_multiplex, IndR_multiplex_choice, "IndR_multiplex",
                              NULL);

  return offset;
}
static int dissect_indr_multiplex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IndR_multiplex(tvb, offset, pinfo, tree, hf_h245_indr_multiplex);
}

static const per_sequence_t Ind_reverseParameters_sequence[] = {
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate },
  { "bitRateLockedToPCRClock"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToPCRClock },
  { "bitRateLockedToNetworkClock" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToNetworkClock },
  { "multiplex"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_indr_multiplex },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Ind_reverseParameters(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Ind_reverseParameters, Ind_reverseParameters_sequence);

  return offset;
}
static int dissect_ind_reverseParameters(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Ind_reverseParameters(tvb, offset, pinfo, tree, hf_h245_ind_reverseParameters);
}

static const per_sequence_t NewATMVCIndication_sequence[] = {
  { "resourceID"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_resourceID },
  { "bitRate"                     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRate },
  { "bitRateLockedToPCRClock"     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToPCRClock },
  { "bitRateLockedToNetworkClock" , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_bitRateLockedToNetworkClock },
  { "aal"                         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ind_aal },
  { "multiplex"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_ind_multiplex },
  { "reverseParameters"           , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_ind_reverseParameters },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_NewATMVCIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_NewATMVCIndication, NewATMVCIndication_sequence);

  return offset;
}
static int dissect_newATMVCIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_NewATMVCIndication(tvb, offset, pinfo, tree, hf_h245_newATMVCIndication);
}


static const value_string h245_T_userInputSupportIndication_vals[] = {
  {   0, "nonStandard" },
  {   1, "basicString" },
  {   2, "iA5String" },
  {   3, "generalString" },
  {   4, "encryptedBasicString" },
  {   5, "encryptedIA5String" },
  {   6, "encryptedGeneralString" },
  { 0, NULL }
};

static const per_choice_t T_userInputSupportIndication_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "basicString"                 , ASN1_EXTENSION_ROOT    , dissect_basicString },
  {   2, "iA5String"                   , ASN1_EXTENSION_ROOT    , dissect_iA5String },
  {   3, "generalString"               , ASN1_EXTENSION_ROOT    , dissect_generalString },
  {   4, "encryptedBasicString"        , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedBasicString },
  {   5, "encryptedIA5String"          , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedIA5String },
  {   6, "encryptedGeneralString"      , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedGeneralString },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_T_userInputSupportIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_T_userInputSupportIndication, T_userInputSupportIndication_choice, "T_userInputSupportIndication",
                              NULL);

  return offset;
}
static int dissect_userInputSupportIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_userInputSupportIndication(tvb, offset, pinfo, tree, hf_h245_userInputSupportIndication);
}


static int
dissect_h245_IA5String_SIZE_1(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_IA5String(tvb, offset, pinfo, tree, hf_index,
                                 1, 1);

  return offset;
}
static int dissect_signalType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IA5String_SIZE_1(tvb, offset, pinfo, tree, hf_h245_signalType);
}

static const per_sequence_t Rtp_sequence[] = {
  { "timestamp"                   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_timestamp },
  { "expirationTime"              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_expirationTime },
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Rtp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Rtp, Rtp_sequence);

  return offset;
}
static int dissect_rtp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Rtp(tvb, offset, pinfo, tree, hf_h245_rtp);
}


static int
dissect_h245_IV8(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    8, 8,
                                    NULL, NULL);

  return offset;
}
static int dissect_iv8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IV8(tvb, offset, pinfo, tree, hf_h245_iv8);
}


static int
dissect_h245_IV16(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    16, 16,
                                    NULL, NULL);

  return offset;
}
static int dissect_iv16(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IV16(tvb, offset, pinfo, tree, hf_h245_iv16);
}

static const per_sequence_t Params_sequence[] = {
  { "iv8"                         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_iv8 },
  { "iv16"                        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_iv16 },
  { "iv"                          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_iv },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Params(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Params, Params_sequence);

  return offset;
}
static int dissect_paramS(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Params(tvb, offset, pinfo, tree, hf_h245_paramS);
}


static int
dissect_h245_OCTET_STRING_SIZE_1(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 1,
                                    NULL, NULL);

  return offset;
}
static int dissect_encryptedSignalType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1(tvb, offset, pinfo, tree, hf_h245_encryptedSignalType);
}

static const per_sequence_t T_signal_sequence[] = {
  { "signalType"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_signalType },
  { "duration"                    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_duration },
  { "rtp"                         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rtp },
  { "rtpPayloadIndication"        , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_rtpPayloadIndication },
  { "paramS"                      , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_paramS },
  { "encryptedSignalType"         , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_encryptedSignalType },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_signal(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_signal, T_signal_sequence);

  return offset;
}
static int dissect_signal(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_signal(tvb, offset, pinfo, tree, hf_h245_signal);
}

static const per_sequence_t Si_rtp_sequence[] = {
  { "logicalChannelNumber"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_Si_rtp(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_Si_rtp, Si_rtp_sequence);

  return offset;
}
static int dissect_si_rtp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_Si_rtp(tvb, offset, pinfo, tree, hf_h245_si_rtp);
}

static const per_sequence_t T_signalUpdate_sequence[] = {
  { "duration"                    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_duration },
  { "rtp"                         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_si_rtp },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_signalUpdate(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_signalUpdate, T_signalUpdate_sequence);

  return offset;
}
static int dissect_signalUpdate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_signalUpdate(tvb, offset, pinfo, tree, hf_h245_signalUpdate);
}

static const per_sequence_t EncryptedAlphanumeric_sequence[] = {
  { "algorithmOID"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_algorithmOID },
  { "paramS"                      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_paramS },
  { "encrypted"                   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_encrypted },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_EncryptedAlphanumeric(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_EncryptedAlphanumeric, EncryptedAlphanumeric_sequence);

  return offset;
}
static int dissect_encryptedAlphanumeric(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_EncryptedAlphanumeric(tvb, offset, pinfo, tree, hf_h245_encryptedAlphanumeric);
}

static const per_sequence_t T_extendedAlphanumeric_sequence[] = {
  { "alphanumeric"                , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_alphanumeric },
  { "rtpPayloadIndication"        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_rtpPayloadIndication },
  { "encryptedAlphanumeric"       , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_encryptedAlphanumeric },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_extendedAlphanumeric(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_extendedAlphanumeric, T_extendedAlphanumeric_sequence);

  return offset;
}
static int dissect_extendedAlphanumeric(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_extendedAlphanumeric(tvb, offset, pinfo, tree, hf_h245_extendedAlphanumeric);
}


static const value_string h245_UserInputIndication_vals[] = {
  {   0, "nonStandard" },
  {   1, "alphanumeric" },
  {   2, "userInputSupportIndication" },
  {   3, "signal" },
  {   4, "signalUpdate" },
  {   5, "extendedAlphanumeric" },
  {   6, "encryptedAlphanumeric" },
  { 0, NULL }
};

static const per_choice_t UserInputIndication_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandard },
  {   1, "alphanumeric"                , ASN1_EXTENSION_ROOT    , dissect_alphanumeric },
  {   2, "userInputSupportIndication"  , ASN1_NOT_EXTENSION_ROOT, dissect_userInputSupportIndication },
  {   3, "signal"                      , ASN1_NOT_EXTENSION_ROOT, dissect_signal },
  {   4, "signalUpdate"                , ASN1_NOT_EXTENSION_ROOT, dissect_signalUpdate },
  {   5, "extendedAlphanumeric"        , ASN1_NOT_EXTENSION_ROOT, dissect_extendedAlphanumeric },
  {   6, "encryptedAlphanumeric"       , ASN1_NOT_EXTENSION_ROOT, dissect_encryptedAlphanumeric },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_UserInputIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_UserInputIndication, UserInputIndication_choice, "UserInputIndication",
                              NULL);

  return offset;
}
static int dissect_userInput(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_UserInputIndication(tvb, offset, pinfo, tree, hf_h245_userInput);
}

static const per_sequence_t H2250MaximumSkewIndication_sequence[] = {
  { "logicalChannelNumber1"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber1 },
  { "logicalChannelNumber2"       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_logicalChannelNumber2 },
  { "maximumSkew"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_maximumSkew },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_H2250MaximumSkewIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_H2250MaximumSkewIndication, H2250MaximumSkewIndication_sequence);

  return offset;
}
static int dissect_h2250MaximumSkewIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_H2250MaximumSkewIndication(tvb, offset, pinfo, tree, hf_h245_h2250MaximumSkewIndication);
}

static const per_sequence_t MCLocationIndication_sequence[] = {
  { "signalAddress"               , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_signalAddress },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MCLocationIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MCLocationIndication, MCLocationIndication_sequence);

  return offset;
}
static int dissect_mcLocationIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MCLocationIndication(tvb, offset, pinfo, tree, hf_h245_mcLocationIndication);
}



static int
dissect_h245_INTEGER_0_9(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_constrained_integer(tvb, offset, pinfo, tree, hf_index,
                                           0U, 9U, NULL, NULL, FALSE);

  return offset;
}
static int dissect_sbeNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_INTEGER_0_9(tvb, offset, pinfo, tree, hf_h245_sbeNumber);
}

static const per_sequence_t TerminalYouAreSeeingInSubPictureNumber_sequence[] = {
  { "terminalNumber"              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_terminalNumber },
  { "subPictureNumber"            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_subPictureNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_TerminalYouAreSeeingInSubPictureNumber(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_TerminalYouAreSeeingInSubPictureNumber, TerminalYouAreSeeingInSubPictureNumber_sequence);

  return offset;
}
static int dissect_terminalYouAreSeeingInSubPictureNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_TerminalYouAreSeeingInSubPictureNumber(tvb, offset, pinfo, tree, hf_h245_terminalYouAreSeeingInSubPictureNumber);
}

static const per_sequence_t VideoIndicateCompose_sequence[] = {
  { "compositionNumber"           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_compositionNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_VideoIndicateCompose(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_VideoIndicateCompose, VideoIndicateCompose_sequence);

  return offset;
}
static int dissect_videoIndicateCompose(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VideoIndicateCompose(tvb, offset, pinfo, tree, hf_h245_videoIndicateCompose);
}


static const value_string h245_ConferenceIndication_vals[] = {
  {   0, "sbeNumber" },
  {   1, "terminalNumberAssign" },
  {   2, "terminalJoinedConference" },
  {   3, "terminalLeftConference" },
  {   4, "seenByAtLeastOneOther" },
  {   5, "cancelSeenByAtLeastOneOther" },
  {   6, "seenByAll" },
  {   7, "cancelSeenByAll" },
  {   8, "terminalYouAreSeeing" },
  {   9, "requestForFloor" },
  {  10, "withdrawChairToken" },
  {  11, "floorRequested" },
  {  12, "terminalYouAreSeeingInSubPictureNumber" },
  {  13, "videoIndicateCompose" },
  { 0, NULL }
};

static const per_choice_t ConferenceIndication_choice[] = {
  {   0, "sbeNumber"                   , ASN1_EXTENSION_ROOT    , dissect_sbeNumber },
  {   1, "terminalNumberAssign"        , ASN1_EXTENSION_ROOT    , dissect_terminalNumberAssign },
  {   2, "terminalJoinedConference"    , ASN1_EXTENSION_ROOT    , dissect_terminalJoinedConference },
  {   3, "terminalLeftConference"      , ASN1_EXTENSION_ROOT    , dissect_terminalLeftConference },
  {   4, "seenByAtLeastOneOther"       , ASN1_EXTENSION_ROOT    , dissect_seenByAtLeastOneOther },
  {   5, "cancelSeenByAtLeastOneOther" , ASN1_EXTENSION_ROOT    , dissect_cancelSeenByAtLeastOneOther },
  {   6, "seenByAll"                   , ASN1_EXTENSION_ROOT    , dissect_seenByAll },
  {   7, "cancelSeenByAll"             , ASN1_EXTENSION_ROOT    , dissect_cancelSeenByAll },
  {   8, "terminalYouAreSeeing"        , ASN1_EXTENSION_ROOT    , dissect_terminalYouAreSeeing },
  {   9, "requestForFloor"             , ASN1_EXTENSION_ROOT    , dissect_requestForFloor },
  {  10, "withdrawChairToken"          , ASN1_NOT_EXTENSION_ROOT, dissect_withdrawChairToken },
  {  11, "floorRequested"              , ASN1_NOT_EXTENSION_ROOT, dissect_floorRequested },
  {  12, "terminalYouAreSeeingInSubPictureNumber", ASN1_NOT_EXTENSION_ROOT, dissect_terminalYouAreSeeingInSubPictureNumber },
  {  13, "videoIndicateCompose"        , ASN1_NOT_EXTENSION_ROOT, dissect_videoIndicateCompose },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_ConferenceIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_ConferenceIndication, ConferenceIndication_choice, "ConferenceIndication",
                              NULL);

  return offset;
}
static int dissect_conferenceIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_ConferenceIndication(tvb, offset, pinfo, tree, hf_h245_conferenceIndication);
}


static int
dissect_h245_OCTET_STRING_SIZE_1_256(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_octet_string(tvb, offset, pinfo, tree, hf_index,
                                    1, 256,
                                    NULL, NULL);

  return offset;
}
static int dissect_productNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_256(tvb, offset, pinfo, tree, hf_h245_productNumber);
}
static int dissect_versionNumber(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_OCTET_STRING_SIZE_1_256(tvb, offset, pinfo, tree, hf_h245_versionNumber);
}

static const per_sequence_t VendorIdentification_sequence[] = {
  { "vendor"                      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_vendor },
  { "productNumber"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_productNumber },
  { "versionNumber"               , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_versionNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_VendorIdentification(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_VendorIdentification, VendorIdentification_sequence);

  return offset;
}
static int dissect_vendorIdentification(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_VendorIdentification(tvb, offset, pinfo, tree, hf_h245_vendorIdentification);
}


static const value_string h245_FunctionNotSupportedCause_vals[] = {
  {   0, "syntaxError" },
  {   1, "semanticError" },
  {   2, "unknownFunction" },
  { 0, NULL }
};

static const per_choice_t FunctionNotSupportedCause_choice[] = {
  {   0, "syntaxError"                 , ASN1_EXTENSION_ROOT    , dissect_syntaxError },
  {   1, "semanticError"               , ASN1_EXTENSION_ROOT    , dissect_semanticError },
  {   2, "unknownFunction"             , ASN1_EXTENSION_ROOT    , dissect_unknownFunction },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_FunctionNotSupportedCause(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_FunctionNotSupportedCause, FunctionNotSupportedCause_choice, "FunctionNotSupportedCause",
                              NULL);

  return offset;
}
static int dissect_fns_cause(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FunctionNotSupportedCause(tvb, offset, pinfo, tree, hf_h245_fns_cause);
}

static const per_sequence_t FunctionNotSupported_sequence[] = {
  { "cause"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_fns_cause },
  { "returnedFunction"            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_returnedFunction },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_FunctionNotSupported(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_FunctionNotSupported, FunctionNotSupported_sequence);

  return offset;
}
static int dissect_functionNotSupported(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FunctionNotSupported(tvb, offset, pinfo, tree, hf_h245_functionNotSupported);
}

static const per_sequence_t T_crcDesired_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_crcDesired(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_crcDesired, T_crcDesired_sequence);

  return offset;
}
static int dissect_crcDesired(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_crcDesired(tvb, offset, pinfo, tree, hf_h245_crcDesired);
}

static const per_sequence_t T_excessiveError_sequence[] = {
  { "connectionIdentifier"        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_connectionIdentifier },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_T_excessiveError(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_T_excessiveError, T_excessiveError_sequence);

  return offset;
}
static int dissect_excessiveError(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_T_excessiveError(tvb, offset, pinfo, tree, hf_h245_excessiveError);
}


static const value_string h245_MultilinkIndication_vals[] = {
  {   0, "nonStandard" },
  {   1, "crcDesired" },
  {   2, "excessiveError" },
  { 0, NULL }
};

static const per_choice_t MultilinkIndication_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "crcDesired"                  , ASN1_EXTENSION_ROOT    , dissect_crcDesired },
  {   2, "excessiveError"              , ASN1_EXTENSION_ROOT    , dissect_excessiveError },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultilinkIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultilinkIndication, MultilinkIndication_choice, "MultilinkIndication",
                              NULL);

  return offset;
}
static int dissect_multilinkIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MultilinkIndication(tvb, offset, pinfo, tree, hf_h245_multilinkIndication);
}

static const per_sequence_t LogicalChannelRateRelease_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_LogicalChannelRateRelease(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_LogicalChannelRateRelease, LogicalChannelRateRelease_sequence);

  return offset;
}
static int dissect_logicalChannelRateRelease(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_LogicalChannelRateRelease(tvb, offset, pinfo, tree, hf_h245_logicalChannelRateRelease);
}

static const per_sequence_t FlowControlIndication_sequence[] = {
  { "scope"                       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_scope },
  { "restriction"                 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_restriction },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_FlowControlIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_FlowControlIndication, FlowControlIndication_sequence);

  return offset;
}
static int dissect_flowControlIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_FlowControlIndication(tvb, offset, pinfo, tree, hf_h245_flowControlIndication);
}

static const per_sequence_t MobileMultilinkReconfigurationIndication_sequence[] = {
  { "sampleSize"                  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_sampleSize },
  { "samplesPerFrame"             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_samplesPerFrame },
  { NULL, 0, 0, NULL }
};

static int
dissect_h245_MobileMultilinkReconfigurationIndication(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_MobileMultilinkReconfigurationIndication, MobileMultilinkReconfigurationIndication_sequence);

  return offset;
}
static int dissect_mobileMultilinkReconfigurationIndication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_MobileMultilinkReconfigurationIndication(tvb, offset, pinfo, tree, hf_h245_mobileMultilinkReconfigurationIndication);
}


static const value_string h245_IndicationMessage_vals[] = {
  {   0, "nonStandard" },
  {   1, "functionNotUnderstood" },
  {   2, "masterSlaveDeterminationRelease" },
  {   3, "terminalCapabilitySetRelease" },
  {   4, "openLogicalChannelConfirm" },
  {   5, "requestChannelCloseRelease" },
  {   6, "multiplexEntrySendRelease" },
  {   7, "requestMultiplexEntryRelease" },
  {   8, "requestModeRelease" },
  {   9, "miscellaneousIndication" },
  {  10, "jitterIndication" },
  {  11, "h223SkewIndication" },
  {  12, "newATMVCIndication" },
  {  13, "userInput" },
  {  14, "h2250MaximumSkewIndication" },
  {  15, "mcLocationIndication" },
  {  16, "conferenceIndication" },
  {  17, "vendorIdentification" },
  {  18, "functionNotSupported" },
  {  19, "multilinkIndication" },
  {  20, "logicalChannelRateRelease" },
  {  21, "flowControlIndication" },
  {  22, "mobileMultilinkReconfigurationIndication" },
  {  23, "genericIndication" },
  { 0, NULL }
};

static const per_choice_t IndicationMessage_choice[] = {
  {   0, "nonStandard"                 , ASN1_EXTENSION_ROOT    , dissect_nonStandardMsg },
  {   1, "functionNotUnderstood"       , ASN1_EXTENSION_ROOT    , dissect_functionNotUnderstood },
  {   2, "masterSlaveDeterminationRelease", ASN1_EXTENSION_ROOT    , dissect_masterSlaveDeterminationRelease },
  {   3, "terminalCapabilitySetRelease", ASN1_EXTENSION_ROOT    , dissect_terminalCapabilitySetRelease },
  {   4, "openLogicalChannelConfirm"   , ASN1_EXTENSION_ROOT    , dissect_openLogicalChannelConfirm },
  {   5, "requestChannelCloseRelease"  , ASN1_EXTENSION_ROOT    , dissect_requestChannelCloseRelease },
  {   6, "multiplexEntrySendRelease"   , ASN1_EXTENSION_ROOT    , dissect_multiplexEntrySendRelease },
  {   7, "requestMultiplexEntryRelease", ASN1_EXTENSION_ROOT    , dissect_requestMultiplexEntryRelease },
  {   8, "requestModeRelease"          , ASN1_EXTENSION_ROOT    , dissect_requestModeRelease },
  {   9, "miscellaneousIndication"     , ASN1_EXTENSION_ROOT    , dissect_miscellaneousIndication },
  {  10, "jitterIndication"            , ASN1_EXTENSION_ROOT    , dissect_jitterIndication },
  {  11, "h223SkewIndication"          , ASN1_EXTENSION_ROOT    , dissect_h223SkewIndication },
  {  12, "newATMVCIndication"          , ASN1_EXTENSION_ROOT    , dissect_newATMVCIndication },
  {  13, "userInput"                   , ASN1_EXTENSION_ROOT    , dissect_userInput },
  {  14, "h2250MaximumSkewIndication"  , ASN1_NOT_EXTENSION_ROOT, dissect_h2250MaximumSkewIndication },
  {  15, "mcLocationIndication"        , ASN1_NOT_EXTENSION_ROOT, dissect_mcLocationIndication },
  {  16, "conferenceIndication"        , ASN1_NOT_EXTENSION_ROOT, dissect_conferenceIndication },
  {  17, "vendorIdentification"        , ASN1_NOT_EXTENSION_ROOT, dissect_vendorIdentification },
  {  18, "functionNotSupported"        , ASN1_NOT_EXTENSION_ROOT, dissect_functionNotSupported },
  {  19, "multilinkIndication"         , ASN1_NOT_EXTENSION_ROOT, dissect_multilinkIndication },
  {  20, "logicalChannelRateRelease"   , ASN1_NOT_EXTENSION_ROOT, dissect_logicalChannelRateRelease },
  {  21, "flowControlIndication"       , ASN1_NOT_EXTENSION_ROOT, dissect_flowControlIndication },
  {  22, "mobileMultilinkReconfigurationIndication", ASN1_NOT_EXTENSION_ROOT, dissect_mobileMultilinkReconfigurationIndication },
  {  23, "genericIndication"           , ASN1_NOT_EXTENSION_ROOT, dissect_genericIndication },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_IndicationMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  guint32 value;
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_IndicationMessage, IndicationMessage_choice, "IndicationMessage",
                              &value);


	if (check_col(pinfo->cinfo, COL_INFO)){
	        if ( h245_shorttypes == TRUE )
	        {
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_IndicationMessage_short_vals, "<unknown>"));
		}
		else
		{
	        	col_append_fstr(pinfo->cinfo, COL_INFO, "%s ",
				val_to_str(value, h245_IndicationMessage_vals, "<unknown>"));
		}
	}

	col_set_fence(pinfo->cinfo,COL_INFO);
    /* Add to packet info */
    g_snprintf(h245_pi->frame_label, 50, "%s %s ", h245_pi->frame_label, val_to_str(value, h245_IndicationMessage_short_vals, "UKN"));
    g_snprintf(h245_pi->comment, 50, "%s %s ", h245_pi->comment, val_to_str(value, h245_IndicationMessage_vals, "<unknown>"));

  return offset;
}
static int dissect_indication(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree) {
  return dissect_h245_IndicationMessage(tvb, offset, pinfo, tree, hf_h245_indication);
}


static const value_string h245_MultimediaSystemControlMessage_vals[] = {
  {   0, "request" },
  {   1, "response" },
  {   2, "command" },
  {   3, "indication" },
  { 0, NULL }
};

static const per_choice_t MultimediaSystemControlMessage_choice[] = {
  {   0, "request"                     , ASN1_EXTENSION_ROOT    , dissect_request },
  {   1, "response"                    , ASN1_EXTENSION_ROOT    , dissect_response },
  {   2, "command"                     , ASN1_EXTENSION_ROOT    , dissect_command },
  {   3, "indication"                  , ASN1_EXTENSION_ROOT    , dissect_indication },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_MultimediaSystemControlMessage(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_MultimediaSystemControlMessage, MultimediaSystemControlMessage_choice, "MultimediaSystemControlMessage",
                              NULL);

  return offset;
}


static const value_string h245_Moderfc2733_vals[] = {
  {   0, "redundancyEncoding" },
  {   1, "separateStream" },
  { 0, NULL }
};

static const per_choice_t Moderfc2733_choice[] = {
  {   0, "redundancyEncoding"          , ASN1_EXTENSION_ROOT    , dissect_redundancyEncodingFlag },
  {   1, "separateStream"              , ASN1_EXTENSION_ROOT    , dissect_separateStream },
  { 0, NULL, 0, NULL }
};

static int
dissect_h245_Moderfc2733(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index) {
  offset = dissect_per_choice(tvb, offset, pinfo, tree, hf_index,
                              ett_h245_Moderfc2733, Moderfc2733_choice, "Moderfc2733",
                              NULL);

  return offset;
}


/*--- End of included file: packet-h245-fn.c ---*/


void
dissect_h245(tvbuff_t *tvb, packet_info *pinfo, proto_tree *parent_tree)
{
    pi_current++;
    if(pi_current==5){
        pi_current=0;
    }
    h245_pi=&pi_arr[pi_current];

    reset_h245_packet_info(h245_pi);
       h245_pi->msg_type = H245_OTHER;

	dissect_tpkt_encap(tvb, pinfo, parent_tree, h245_reassembly, MultimediaSystemControlMessage_handle);

	tap_queue_packet(h245_tap, pinfo, h245_pi);
}

void
dissect_h245_h245(tvbuff_t *tvb, packet_info *pinfo, proto_tree *parent_tree)
{
	proto_item *it;
	proto_tree *tr;
	guint32 offset=0;

    pi_current++;
    if(pi_current==5){
      pi_current=0;
    }
    h245_pi=&pi_arr[pi_current];

    reset_h245_packet_info(h245_pi);
    h245_pi->msg_type = H245_OTHER;

	if (check_col(pinfo->cinfo, COL_PROTOCOL)){
		col_set_str(pinfo->cinfo, COL_PROTOCOL, "H.245");
	}

	it=proto_tree_add_protocol_format(parent_tree, proto_h245, tvb, 0, tvb_length(tvb), "H.245");
	tr=proto_item_add_subtree(it, ett_h245);
	dissect_h245_MultimediaSystemControlMessage(tvb, offset, pinfo ,tr, hf_h245_pdu_type);
	tap_queue_packet(h245dg_tap, pinfo, h245_pi);
}

int
dissect_h245_OpenLogicalChannelCodec(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *tree, int hf_index, char *codec_str) {
  offset = dissect_per_sequence(tvb, offset, pinfo, tree, hf_index,
                                ett_h245_OpenLogicalChannel, OpenLogicalChannel_sequence);


  if (h245_pi != NULL) h245_pi->msg_type = H245_OpenLogChn;

  if (codec_str && codec_type){
        strncpy(codec_str, codec_type, 50);
  }

  return offset;
}

/*--- proto_register_h245 -------------------------------------------*/
void proto_register_h245(void) {

  /* List of fields */
  static hf_register_info hf[] = {
    { &hf_h245_pdu_type,
 { "PDU Type", "h245.pdu_type", FT_UINT32, BASE_DEC,
		VALS(h245_MultimediaSystemControlMessage_vals), 0, "Type of H.245 PDU", HFILL }},
	{ &hf_h245Manufacturer,
		{ "H.245 Manufacturer", "h245.Manufacturer", FT_UINT32, BASE_HEX,
		VALS(H221ManufacturerCode_vals), 0, "h245.H.221 Manufacturer", HFILL }},

/*--- Included file: packet-h245-hfarr.c ---*/

    { &hf_h245_request,
      { "request", "h245.request",
        FT_UINT32, BASE_DEC, VALS(h245_RequestMessage_vals), 0,
        "", HFILL }},
    { &hf_h245_response,
      { "response", "h245.response",
        FT_UINT32, BASE_DEC, VALS(h245_ResponseMessage_vals), 0,
        "", HFILL }},
    { &hf_h245_command,
      { "command", "h245.command",
        FT_UINT32, BASE_DEC, VALS(h245_CommandMessage_vals), 0,
        "", HFILL }},
    { &hf_h245_indication,
      { "indication", "h245.indication",
        FT_UINT32, BASE_DEC, VALS(h245_IndicationMessage_vals), 0,
        "MultimediaSystemControlMessage/indication", HFILL }},
    { &hf_h245_nonStandardMsg,
      { "nonStandard", "h245.nonStandard",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_masterSlaveDetermination,
      { "masterSlaveDetermination", "h245.masterSlaveDetermination",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/masterSlaveDetermination", HFILL }},
    { &hf_h245_terminalCapabilitySet,
      { "terminalCapabilitySet", "h245.terminalCapabilitySet",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/terminalCapabilitySet", HFILL }},
    { &hf_h245_openLogicalChannel,
      { "openLogicalChannel", "h245.openLogicalChannel",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/openLogicalChannel", HFILL }},
    { &hf_h245_closeLogicalChannel,
      { "closeLogicalChannel", "h245.closeLogicalChannel",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/closeLogicalChannel", HFILL }},
    { &hf_h245_requestChannelClose,
      { "requestChannelClose", "h245.requestChannelClose",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/requestChannelClose", HFILL }},
    { &hf_h245_multiplexEntrySend,
      { "multiplexEntrySend", "h245.multiplexEntrySend",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/multiplexEntrySend", HFILL }},
    { &hf_h245_requestMultiplexEntry,
      { "requestMultiplexEntry", "h245.requestMultiplexEntry",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/requestMultiplexEntry", HFILL }},
    { &hf_h245_requestMode,
      { "requestMode", "h245.requestMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/requestMode", HFILL }},
    { &hf_h245_roundTripDelayRequest,
      { "roundTripDelayRequest", "h245.roundTripDelayRequest",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/roundTripDelayRequest", HFILL }},
    { &hf_h245_maintenanceLoopRequest,
      { "maintenanceLoopRequest", "h245.maintenanceLoopRequest",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/maintenanceLoopRequest", HFILL }},
    { &hf_h245_communicationModeRequest,
      { "communicationModeRequest", "h245.communicationModeRequest",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/communicationModeRequest", HFILL }},
    { &hf_h245_conferenceRequest,
      { "conferenceRequest", "h245.conferenceRequest",
        FT_UINT32, BASE_DEC, VALS(h245_ConferenceRequest_vals), 0,
        "RequestMessage/conferenceRequest", HFILL }},
    { &hf_h245_multilinkRequest,
      { "multilinkRequest", "h245.multilinkRequest",
        FT_UINT32, BASE_DEC, VALS(h245_MultilinkRequest_vals), 0,
        "RequestMessage/multilinkRequest", HFILL }},
    { &hf_h245_logicalChannelRateRequest,
      { "logicalChannelRateRequest", "h245.logicalChannelRateRequest",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/logicalChannelRateRequest", HFILL }},
    { &hf_h245_genericRequest,
      { "genericRequest", "h245.genericRequest",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMessage/genericRequest", HFILL }},
    { &hf_h245_masterSlaveDeterminationAck,
      { "masterSlaveDeterminationAck", "h245.masterSlaveDeterminationAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/masterSlaveDeterminationAck", HFILL }},
    { &hf_h245_masterSlaveDeterminationReject,
      { "masterSlaveDeterminationReject", "h245.masterSlaveDeterminationReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/masterSlaveDeterminationReject", HFILL }},
    { &hf_h245_terminalCapabilitySetAck,
      { "terminalCapabilitySetAck", "h245.terminalCapabilitySetAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/terminalCapabilitySetAck", HFILL }},
    { &hf_h245_terminalCapabilitySetReject,
      { "terminalCapabilitySetReject", "h245.terminalCapabilitySetReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/terminalCapabilitySetReject", HFILL }},
    { &hf_h245_openLogicalChannelAck,
      { "openLogicalChannelAck", "h245.openLogicalChannelAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/openLogicalChannelAck", HFILL }},
    { &hf_h245_openLogicalChannelReject,
      { "openLogicalChannelReject", "h245.openLogicalChannelReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/openLogicalChannelReject", HFILL }},
    { &hf_h245_closeLogicalChannelAck,
      { "closeLogicalChannelAck", "h245.closeLogicalChannelAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/closeLogicalChannelAck", HFILL }},
    { &hf_h245_requestChannelCloseAck,
      { "requestChannelCloseAck", "h245.requestChannelCloseAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestChannelCloseAck", HFILL }},
    { &hf_h245_requestChannelCloseReject,
      { "requestChannelCloseReject", "h245.requestChannelCloseReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestChannelCloseReject", HFILL }},
    { &hf_h245_multiplexEntrySendAck,
      { "multiplexEntrySendAck", "h245.multiplexEntrySendAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/multiplexEntrySendAck", HFILL }},
    { &hf_h245_multiplexEntrySendReject,
      { "multiplexEntrySendReject", "h245.multiplexEntrySendReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/multiplexEntrySendReject", HFILL }},
    { &hf_h245_requestMultiplexEntryAck,
      { "requestMultiplexEntryAck", "h245.requestMultiplexEntryAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestMultiplexEntryAck", HFILL }},
    { &hf_h245_requestMultiplexEntryReject,
      { "requestMultiplexEntryReject", "h245.requestMultiplexEntryReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestMultiplexEntryReject", HFILL }},
    { &hf_h245_requestModeAck,
      { "requestModeAck", "h245.requestModeAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestModeAck", HFILL }},
    { &hf_h245_requestModeReject,
      { "requestModeReject", "h245.requestModeReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/requestModeReject", HFILL }},
    { &hf_h245_roundTripDelayResponse,
      { "roundTripDelayResponse", "h245.roundTripDelayResponse",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/roundTripDelayResponse", HFILL }},
    { &hf_h245_maintenanceLoopAck,
      { "maintenanceLoopAck", "h245.maintenanceLoopAck",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/maintenanceLoopAck", HFILL }},
    { &hf_h245_maintenanceLoopReject,
      { "maintenanceLoopReject", "h245.maintenanceLoopReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/maintenanceLoopReject", HFILL }},
    { &hf_h245_communicationModeResponse,
      { "communicationModeResponse", "h245.communicationModeResponse",
        FT_UINT32, BASE_DEC, VALS(h245_CommunicationModeResponse_vals), 0,
        "ResponseMessage/communicationModeResponse", HFILL }},
    { &hf_h245_conferenceResponse,
      { "conferenceResponse", "h245.conferenceResponse",
        FT_UINT32, BASE_DEC, VALS(h245_ConferenceResponse_vals), 0,
        "ResponseMessage/conferenceResponse", HFILL }},
    { &hf_h245_multilinkResponse,
      { "multilinkResponse", "h245.multilinkResponse",
        FT_UINT32, BASE_DEC, VALS(h245_MultilinkResponse_vals), 0,
        "ResponseMessage/multilinkResponse", HFILL }},
    { &hf_h245_logicalChannelRateAcknowledge,
      { "logicalChannelRateAcknowledge", "h245.logicalChannelRateAcknowledge",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/logicalChannelRateAcknowledge", HFILL }},
    { &hf_h245_logicalChannelRateReject,
      { "logicalChannelRateReject", "h245.logicalChannelRateReject",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/logicalChannelRateReject", HFILL }},
    { &hf_h245_genericResponse,
      { "genericResponse", "h245.genericResponse",
        FT_NONE, BASE_NONE, NULL, 0,
        "ResponseMessage/genericResponse", HFILL }},
    { &hf_h245_maintenanceLoopOffCommand,
      { "maintenanceLoopOffCommand", "h245.maintenanceLoopOffCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/maintenanceLoopOffCommand", HFILL }},
    { &hf_h245_sendTerminalCapabilitySet,
      { "sendTerminalCapabilitySet", "h245.sendTerminalCapabilitySet",
        FT_UINT32, BASE_DEC, VALS(h245_SendTerminalCapabilitySet_vals), 0,
        "CommandMessage/sendTerminalCapabilitySet", HFILL }},
    { &hf_h245_encryptionCommand,
      { "encryptionCommand", "h245.encryptionCommand",
        FT_UINT32, BASE_DEC, VALS(h245_EncryptionCommand_vals), 0,
        "CommandMessage/encryptionCommand", HFILL }},
    { &hf_h245_flowControlCommand,
      { "flowControlCommand", "h245.flowControlCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/flowControlCommand", HFILL }},
    { &hf_h245_endSessionCommand,
      { "endSessionCommand", "h245.endSessionCommand",
        FT_UINT32, BASE_DEC, VALS(h245_EndSessionCommand_vals), 0,
        "CommandMessage/endSessionCommand", HFILL }},
    { &hf_h245_miscellaneousCommand,
      { "miscellaneousCommand", "h245.miscellaneousCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/miscellaneousCommand", HFILL }},
    { &hf_h245_communicationModeCommand,
      { "communicationModeCommand", "h245.communicationModeCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/communicationModeCommand", HFILL }},
    { &hf_h245_conferenceCommand,
      { "conferenceCommand", "h245.conferenceCommand",
        FT_UINT32, BASE_DEC, VALS(h245_ConferenceCommand_vals), 0,
        "CommandMessage/conferenceCommand", HFILL }},
    { &hf_h245_h223MultiplexReconfiguration,
      { "h223MultiplexReconfiguration", "h245.h223MultiplexReconfiguration",
        FT_UINT32, BASE_DEC, VALS(h245_H223MultiplexReconfiguration_vals), 0,
        "CommandMessage/h223MultiplexReconfiguration", HFILL }},
    { &hf_h245_newATMVCCommand,
      { "newATMVCCommand", "h245.newATMVCCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/newATMVCCommand", HFILL }},
    { &hf_h245_mobileMultilinkReconfigurationCommand,
      { "mobileMultilinkReconfigurationCommand", "h245.mobileMultilinkReconfigurationCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/mobileMultilinkReconfigurationCommand", HFILL }},
    { &hf_h245_genericCommand,
      { "genericCommand", "h245.genericCommand",
        FT_NONE, BASE_NONE, NULL, 0,
        "CommandMessage/genericCommand", HFILL }},
    { &hf_h245_functionNotUnderstood,
      { "functionNotUnderstood", "h245.functionNotUnderstood",
        FT_UINT32, BASE_DEC, VALS(h245_FunctionNotUnderstood_vals), 0,
        "IndicationMessage/functionNotUnderstood", HFILL }},
    { &hf_h245_masterSlaveDeterminationRelease,
      { "masterSlaveDeterminationRelease", "h245.masterSlaveDeterminationRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/masterSlaveDeterminationRelease", HFILL }},
    { &hf_h245_terminalCapabilitySetRelease,
      { "terminalCapabilitySetRelease", "h245.terminalCapabilitySetRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/terminalCapabilitySetRelease", HFILL }},
    { &hf_h245_openLogicalChannelConfirm,
      { "openLogicalChannelConfirm", "h245.openLogicalChannelConfirm",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/openLogicalChannelConfirm", HFILL }},
    { &hf_h245_requestChannelCloseRelease,
      { "requestChannelCloseRelease", "h245.requestChannelCloseRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/requestChannelCloseRelease", HFILL }},
    { &hf_h245_multiplexEntrySendRelease,
      { "multiplexEntrySendRelease", "h245.multiplexEntrySendRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/multiplexEntrySendRelease", HFILL }},
    { &hf_h245_requestMultiplexEntryRelease,
      { "requestMultiplexEntryRelease", "h245.requestMultiplexEntryRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/requestMultiplexEntryRelease", HFILL }},
    { &hf_h245_requestModeRelease,
      { "requestModeRelease", "h245.requestModeRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/requestModeRelease", HFILL }},
    { &hf_h245_miscellaneousIndication,
      { "miscellaneousIndication", "h245.miscellaneousIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/miscellaneousIndication", HFILL }},
    { &hf_h245_jitterIndication,
      { "jitterIndication", "h245.jitterIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/jitterIndication", HFILL }},
    { &hf_h245_h223SkewIndication,
      { "h223SkewIndication", "h245.h223SkewIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/h223SkewIndication", HFILL }},
    { &hf_h245_newATMVCIndication,
      { "newATMVCIndication", "h245.newATMVCIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/newATMVCIndication", HFILL }},
    { &hf_h245_userInput,
      { "userInput", "h245.userInput",
        FT_UINT32, BASE_DEC, VALS(h245_UserInputIndication_vals), 0,
        "IndicationMessage/userInput", HFILL }},
    { &hf_h245_h2250MaximumSkewIndication,
      { "h2250MaximumSkewIndication", "h245.h2250MaximumSkewIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/h2250MaximumSkewIndication", HFILL }},
    { &hf_h245_mcLocationIndication,
      { "mcLocationIndication", "h245.mcLocationIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/mcLocationIndication", HFILL }},
    { &hf_h245_conferenceIndication,
      { "conferenceIndication", "h245.conferenceIndication",
        FT_UINT32, BASE_DEC, VALS(h245_ConferenceIndication_vals), 0,
        "IndicationMessage/conferenceIndication", HFILL }},
    { &hf_h245_vendorIdentification,
      { "vendorIdentification", "h245.vendorIdentification",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/vendorIdentification", HFILL }},
    { &hf_h245_functionNotSupported,
      { "functionNotSupported", "h245.functionNotSupported",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/functionNotSupported", HFILL }},
    { &hf_h245_multilinkIndication,
      { "multilinkIndication", "h245.multilinkIndication",
        FT_UINT32, BASE_DEC, VALS(h245_MultilinkIndication_vals), 0,
        "IndicationMessage/multilinkIndication", HFILL }},
    { &hf_h245_logicalChannelRateRelease,
      { "logicalChannelRateRelease", "h245.logicalChannelRateRelease",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/logicalChannelRateRelease", HFILL }},
    { &hf_h245_flowControlIndication,
      { "flowControlIndication", "h245.flowControlIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/flowControlIndication", HFILL }},
    { &hf_h245_mobileMultilinkReconfigurationIndication,
      { "mobileMultilinkReconfigurationIndication", "h245.mobileMultilinkReconfigurationIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/mobileMultilinkReconfigurationIndication", HFILL }},
    { &hf_h245_genericIndication,
      { "genericIndication", "h245.genericIndication",
        FT_NONE, BASE_NONE, NULL, 0,
        "IndicationMessage/genericIndication", HFILL }},
    { &hf_h245_messageIdentifier,
      { "messageIdentifier", "h245.messageIdentifier",
        FT_UINT32, BASE_DEC, VALS(h245_CapabilityIdentifier_vals), 0,
        "GenericMessage/messageIdentifier", HFILL }},
    { &hf_h245_subMessageIdentifer,
      { "subMessageIdentifer", "h245.subMessageIdentifer",
        FT_UINT32, BASE_DEC, NULL, 0,
        "GenericMessage/subMessageIdentifer", HFILL }},
    { &hf_h245_messageContent,
      { "messageContent", "h245.messageContent",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericMessage/messageContent", HFILL }},
    { &hf_h245_messageContent_item,
      { "Item", "h245.messageContent_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericMessage/messageContent/_item", HFILL }},
    { &hf_h245_nonStandardData,
      { "nonStandardData", "h245.nonStandardData",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_nonStandardIdentifier,
      { "nonStandardIdentifier", "h245.nonStandardIdentifier",
        FT_UINT32, BASE_DEC, VALS(h245_NonStandardIdentifier_vals), 0,
        "NonStandardParameter/nonStandardIdentifier", HFILL }},
    { &hf_h245_nsd_data,
      { "data", "h245.data",
        FT_BYTES, BASE_HEX, NULL, 0,
        "NonStandardParameter/data", HFILL }},
    { &hf_h245_object,
      { "object", "h245.object",
        FT_STRING, BASE_NONE, NULL, 0,
        "NonStandardIdentifier/object", HFILL }},
    { &hf_h245_h221NonStandardID,
      { "h221NonStandard", "h245.h221NonStandard",
        FT_NONE, BASE_NONE, NULL, 0,
        "NonStandardIdentifier/h221NonStandard", HFILL }},
    { &hf_h245_t35CountryCode,
      { "t35CountryCode", "h245.t35CountryCode",
        FT_UINT32, BASE_DEC, VALS(T35CountryCode_vals), 0,
        "NonStandardIdentifier/h221NonStandard/t35CountryCode", HFILL }},
    { &hf_h245_t35Extension,
      { "t35Extension", "h245.t35Extension",
        FT_UINT32, BASE_DEC, NULL, 0,
        "NonStandardIdentifier/h221NonStandard/t35Extension", HFILL }},
    { &hf_h245_manufacturerCode,
      { "manufacturerCode", "h245.manufacturerCode",
        FT_UINT32, BASE_DEC, NULL, 0,
        "NonStandardIdentifier/h221NonStandard/manufacturerCode", HFILL }},
    { &hf_h245_terminalType,
      { "terminalType", "h245.terminalType",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MasterSlaveDetermination/terminalType", HFILL }},
    { &hf_h245_statusDeterminationNumber,
      { "statusDeterminationNumber", "h245.statusDeterminationNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MasterSlaveDetermination/statusDeterminationNumber", HFILL }},
    { &hf_h245_decision,
      { "decision", "h245.decision",
        FT_UINT32, BASE_DEC, VALS(h245_T_decision_vals), 0,
        "MasterSlaveDeterminationAck/decision", HFILL }},
    { &hf_h245_master,
      { "master", "h245.master",
        FT_NONE, BASE_NONE, NULL, 0,
        "MasterSlaveDeterminationAck/decision/master", HFILL }},
    { &hf_h245_slave,
      { "slave", "h245.slave",
        FT_NONE, BASE_NONE, NULL, 0,
        "MasterSlaveDeterminationAck/decision/slave", HFILL }},
    { &hf_h245_msd_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_MasterSlaveDeterminationRejectCause_vals), 0,
        "MasterSlaveDeterminationReject/cause", HFILL }},
    { &hf_h245_identicalNumbers,
      { "identicalNumbers", "h245.identicalNumbers",
        FT_NONE, BASE_NONE, NULL, 0,
        "MasterSlaveDeterminationReject/cause/identicalNumbers", HFILL }},
    { &hf_h245_sequenceNumber,
      { "sequenceNumber", "h245.sequenceNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_protocolIdentifier,
      { "protocolIdentifier", "h245.protocolIdentifier",
        FT_STRING, BASE_NONE, NULL, 0,
        "TerminalCapabilitySet/protocolIdentifier", HFILL }},
    { &hf_h245_multiplexCapability,
      { "multiplexCapability", "h245.multiplexCapability",
        FT_UINT32, BASE_DEC, VALS(h245_MultiplexCapability_vals), 0,
        "TerminalCapabilitySet/multiplexCapability", HFILL }},
    { &hf_h245_capabilityTable,
      { "capabilityTable", "h245.capabilityTable",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySet/capabilityTable", HFILL }},
    { &hf_h245_capabilityTable_item,
      { "Item", "h245.capabilityTable_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySet/capabilityTable/_item", HFILL }},
    { &hf_h245_capabilityDescriptors,
      { "capabilityDescriptors", "h245.capabilityDescriptors",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySet/capabilityDescriptors", HFILL }},
    { &hf_h245_capabilityDescriptors_item,
      { "Item", "h245.capabilityDescriptors_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySet/capabilityDescriptors/_item", HFILL }},
    { &hf_h245_capabilityTableEntryNumber,
      { "capabilityTableEntryNumber", "h245.capabilityTableEntryNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CapabilityTableEntry/capabilityTableEntryNumber", HFILL }},
    { &hf_h245_capability,
      { "capability", "h245.capability",
        FT_UINT32, BASE_DEC, VALS(h245_Capability_vals), 0,
        "CapabilityTableEntry/capability", HFILL }},
    { &hf_h245_capabilityDescriptorNumber,
      { "capabilityDescriptorNumber", "h245.capabilityDescriptorNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CapabilityDescriptor/capabilityDescriptorNumber", HFILL }},
    { &hf_h245_simultaneousCapabilities,
      { "simultaneousCapabilities", "h245.simultaneousCapabilities",
        FT_NONE, BASE_NONE, NULL, 0,
        "CapabilityDescriptor/simultaneousCapabilities", HFILL }},
    { &hf_h245_simultaneousCapabilities_item,
      { "Item", "h245.simultaneousCapabilities_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "CapabilityDescriptor/simultaneousCapabilities/_item", HFILL }},
    { &hf_h245_AlternativeCapabilitySet_item,
      { "Item", "h245.AlternativeCapabilitySet_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AlternativeCapabilitySet/_item", HFILL }},
    { &hf_h245_tcs_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_TerminalCapabilitySetRejectCause_vals), 0,
        "TerminalCapabilitySetReject/cause", HFILL }},
    { &hf_h245_unspecified,
      { "unspecified", "h245.unspecified",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_undefinedTableEntryUsed,
      { "undefinedTableEntryUsed", "h245.undefinedTableEntryUsed",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySetReject/cause/undefinedTableEntryUsed", HFILL }},
    { &hf_h245_descriptorCapacityExceeded,
      { "descriptorCapacityExceeded", "h245.descriptorCapacityExceeded",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySetReject/cause/descriptorCapacityExceeded", HFILL }},
    { &hf_h245_tableEntryCapacityExceeded,
      { "tableEntryCapacityExceeded", "h245.tableEntryCapacityExceeded",
        FT_UINT32, BASE_DEC, VALS(h245_T_tableEntryCapacityExceeded_vals), 0,
        "TerminalCapabilitySetReject/cause/tableEntryCapacityExceeded", HFILL }},
    { &hf_h245_highestEntryNumberProcessed,
      { "highestEntryNumberProcessed", "h245.highestEntryNumberProcessed",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TerminalCapabilitySetReject/cause/tableEntryCapacityExceeded/highestEntryNumberProcessed", HFILL }},
    { &hf_h245_noneProcessed,
      { "noneProcessed", "h245.noneProcessed",
        FT_NONE, BASE_NONE, NULL, 0,
        "TerminalCapabilitySetReject/cause/tableEntryCapacityExceeded/noneProcessed", HFILL }},
    { &hf_h245_nonStandard,
      { "nonStandard", "h245.nonStandard",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_receiveVideoCapability,
      { "receiveVideoCapability", "h245.receiveVideoCapability",
        FT_UINT32, BASE_DEC, VALS(h245_VideoCapability_vals), 0,
        "Capability/receiveVideoCapability", HFILL }},
    { &hf_h245_transmitVideoCapability,
      { "transmitVideoCapability", "h245.transmitVideoCapability",
        FT_UINT32, BASE_DEC, VALS(h245_VideoCapability_vals), 0,
        "Capability/transmitVideoCapability", HFILL }},
    { &hf_h245_receiveAndTransmitVideoCapability,
      { "receiveAndTransmitVideoCapability", "h245.receiveAndTransmitVideoCapability",
        FT_UINT32, BASE_DEC, VALS(h245_VideoCapability_vals), 0,
        "Capability/receiveAndTransmitVideoCapability", HFILL }},
    { &hf_h245_receiveAudioCapability,
      { "receiveAudioCapability", "h245.receiveAudioCapability",
        FT_UINT32, BASE_DEC, VALS(h245_AudioCapability_vals), 0,
        "Capability/receiveAudioCapability", HFILL }},
    { &hf_h245_transmitAudioCapability,
      { "transmitAudioCapability", "h245.transmitAudioCapability",
        FT_UINT32, BASE_DEC, VALS(h245_AudioCapability_vals), 0,
        "Capability/transmitAudioCapability", HFILL }},
    { &hf_h245_receiveAndTransmitAudioCapability,
      { "receiveAndTransmitAudioCapability", "h245.receiveAndTransmitAudioCapability",
        FT_UINT32, BASE_DEC, VALS(h245_AudioCapability_vals), 0,
        "Capability/receiveAndTransmitAudioCapability", HFILL }},
    { &hf_h245_receiveDataApplicationCapability,
      { "receiveDataApplicationCapability", "h245.receiveDataApplicationCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveDataApplicationCapability", HFILL }},
    { &hf_h245_transmitDataApplicationCapability,
      { "transmitDataApplicationCapability", "h245.transmitDataApplicationCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/transmitDataApplicationCapability", HFILL }},
    { &hf_h245_receiveAndTransmitDataApplicationCapability,
      { "receiveAndTransmitDataApplicationCapability", "h245.receiveAndTransmitDataApplicationCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveAndTransmitDataApplicationCapability", HFILL }},
    { &hf_h245_h233EncryptionTransmitCapability,
      { "h233EncryptionTransmitCapability", "h245.h233EncryptionTransmitCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "Capability/h233EncryptionTransmitCapability", HFILL }},
    { &hf_h245_h233EncryptionReceiveCapability,
      { "h233EncryptionReceiveCapability", "h245.h233EncryptionReceiveCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/h233EncryptionReceiveCapability", HFILL }},
    { &hf_h245_h233IVResponseTime,
      { "h233IVResponseTime", "h245.h233IVResponseTime",
        FT_UINT32, BASE_DEC, NULL, 0,
        "Capability/h233EncryptionReceiveCapability/h233IVResponseTime", HFILL }},
    { &hf_h245_conferenceCapability,
      { "conferenceCapability", "h245.conferenceCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/conferenceCapability", HFILL }},
    { &hf_h245_h235SecurityCapability,
      { "h235SecurityCapability", "h245.h235SecurityCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/h235SecurityCapability", HFILL }},
    { &hf_h245_maxPendingReplacementFor,
      { "maxPendingReplacementFor", "h245.maxPendingReplacementFor",
        FT_UINT32, BASE_DEC, NULL, 0,
        "Capability/maxPendingReplacementFor", HFILL }},
    { &hf_h245_receiveUserInputCapability,
      { "receiveUserInputCapability", "h245.receiveUserInputCapability",
        FT_UINT32, BASE_DEC, VALS(h245_UserInputCapability_vals), 0,
        "Capability/receiveUserInputCapability", HFILL }},
    { &hf_h245_transmitUserInputCapability,
      { "transmitUserInputCapability", "h245.transmitUserInputCapability",
        FT_UINT32, BASE_DEC, VALS(h245_UserInputCapability_vals), 0,
        "Capability/transmitUserInputCapability", HFILL }},
    { &hf_h245_receiveAndTransmitUserInputCapability,
      { "receiveAndTransmitUserInputCapability", "h245.receiveAndTransmitUserInputCapability",
        FT_UINT32, BASE_DEC, VALS(h245_UserInputCapability_vals), 0,
        "Capability/receiveAndTransmitUserInputCapability", HFILL }},
    { &hf_h245_genericControlCapability,
      { "genericControlCapability", "h245.genericControlCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/genericControlCapability", HFILL }},
    { &hf_h245_receiveMultiplexedStreamCapability,
      { "receiveMultiplexedStreamCapability", "h245.receiveMultiplexedStreamCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveMultiplexedStreamCapability", HFILL }},
    { &hf_h245_transmitMultiplexedStreamCapability,
      { "transmitMultiplexedStreamCapability", "h245.transmitMultiplexedStreamCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/transmitMultiplexedStreamCapability", HFILL }},
    { &hf_h245_receiveAndTransmitMultiplexedStreamCapability,
      { "receiveAndTransmitMultiplexedStreamCapability", "h245.receiveAndTransmitMultiplexedStreamCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveAndTransmitMultiplexedStreamCapability", HFILL }},
    { &hf_h245_receiveRTPAudioTelephonyEventCapability,
      { "receiveRTPAudioTelephonyEventCapability", "h245.receiveRTPAudioTelephonyEventCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveRTPAudioTelephonyEventCapability", HFILL }},
    { &hf_h245_receiveRTPAudioToneCapability,
      { "receiveRTPAudioToneCapability", "h245.receiveRTPAudioToneCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/receiveRTPAudioToneCapability", HFILL }},
    { &hf_h245_fecCapability,
      { "fecCapability", "h245.fecCapability",
        FT_UINT32, BASE_DEC, VALS(h245_FECCapability_vals), 0,
        "Capability/fecCapability", HFILL }},
    { &hf_h245_multiplePayloadStreamCapability,
      { "multiplePayloadStreamCapability", "h245.multiplePayloadStreamCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Capability/multiplePayloadStreamCapability", HFILL }},
    { &hf_h245_encryptionAuthenticationAndIntegrity,
      { "encryptionAuthenticationAndIntegrity", "h245.encryptionAuthenticationAndIntegrity",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_mediaCapability,
      { "mediaCapability", "h245.mediaCapability",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H235SecurityCapability/mediaCapability", HFILL }},
    { &hf_h245_h222Capability,
      { "h222Capability", "h245.h222Capability",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_h223Capability,
      { "h223Capability", "h245.h223Capability",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_v76Capability,
      { "v76Capability", "h245.v76Capability",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexCapability/v76Capability", HFILL }},
    { &hf_h245_h2250Capability,
      { "h2250Capability", "h245.h2250Capability",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexCapability/h2250Capability", HFILL }},
    { &hf_h245_genericMultiplexCapability,
      { "genericMultiplexCapability", "h245.genericMultiplexCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexCapability/genericMultiplexCapability", HFILL }},
    { &hf_h245_numberOfVCs,
      { "numberOfVCs", "h245.numberOfVCs",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H222Capability/numberOfVCs", HFILL }},
    { &hf_h245_vcCapability,
      { "vcCapability", "h245.vcCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H222Capability/vcCapability", HFILL }},
    { &hf_h245_vcCapability_item,
      { "Item", "h245.vcCapability_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H222Capability/vcCapability/_item", HFILL }},
    { &hf_h245_aal1,
      { "aal1", "h245.aal1",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/aal1", HFILL }},
    { &hf_h245_nullClockRecovery,
      { "nullClockRecovery", "h245.nullClockRecovery",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_srtsClockRecovery_bool,
      { "srtsClockRecovery", "h245.srtsClockRecovery",
        FT_BOOLEAN, 8, NULL, 0,
        "VCCapability/aal1/srtsClockRecovery", HFILL }},
    { &hf_h245_adaptiveClockRecovery,
      { "adaptiveClockRecovery", "h245.adaptiveClockRecovery",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_nullErrorCorrection,
      { "nullErrorCorrection", "h245.nullErrorCorrection",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_longInterleaver,
      { "longInterleaver", "h245.longInterleaver",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_shortInterleaver,
      { "shortInterleaver", "h245.shortInterleaver",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_errorCorrectionOnly,
      { "errorCorrectionOnly", "h245.errorCorrectionOnly",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_structuredDataTransfer,
      { "structuredDataTransfer", "h245.structuredDataTransfer",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_partiallyFilledCells,
      { "partiallyFilledCells", "h245.partiallyFilledCells",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_aal5,
      { "aal5", "h245.aal5",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/aal5", HFILL }},
    { &hf_h245_forwardMaximumSDUSize,
      { "forwardMaximumSDUSize", "h245.forwardMaximumSDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_backwardMaximumSDUSize,
      { "backwardMaximumSDUSize", "h245.backwardMaximumSDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_transportStream_bool,
      { "transportStream", "h245.transportStream",
        FT_BOOLEAN, 8, NULL, 0,
        "VCCapability/transportStream", HFILL }},
    { &hf_h245_programStream,
      { "programStream", "h245.programStream",
        FT_BOOLEAN, 8, NULL, 0,
        "VCCapability/programStream", HFILL }},
    { &hf_h245_availableBitRates,
      { "availableBitRates", "h245.availableBitRates",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/availableBitRates", HFILL }},
    { &hf_h245_Avb_type,
      { "type", "h245.type",
        FT_UINT32, BASE_DEC, VALS(h245_Avb_type_vals), 0,
        "VCCapability/availableBitRates/type", HFILL }},
    { &hf_h245_singleBitRate,
      { "singleBitRate", "h245.singleBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "VCCapability/availableBitRates/type/singleBitRate", HFILL }},
    { &hf_h245_rangeOfBitRates,
      { "rangeOfBitRates", "h245.rangeOfBitRates",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/availableBitRates/type/rangeOfBitRates", HFILL }},
    { &hf_h245_lowerBitRate,
      { "lowerBitRate", "h245.lowerBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "VCCapability/availableBitRates/type/rangeOfBitRates/lowerBitRate", HFILL }},
    { &hf_h245_higherBitRate,
      { "higherBitRate", "h245.higherBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "VCCapability/availableBitRates/type/rangeOfBitRates/higherBitRate", HFILL }},
    { &hf_h245_aal1ViaGateway,
      { "aal1ViaGateway", "h245.aal1ViaGateway",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/aal1ViaGateway", HFILL }},
    { &hf_h245_gatewayAddress,
      { "gatewayAddress", "h245.gatewayAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/aal1ViaGateway/gatewayAddress", HFILL }},
    { &hf_h245_gatewayAddress_item,
      { "Item", "h245.gatewayAddress_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "VCCapability/aal1ViaGateway/gatewayAddress/_item", HFILL }},
    { &hf_h245_srtsClockRecoveryflag,
      { "srtsClockRecovery", "h245.srtsClockRecovery",
        FT_BOOLEAN, 8, NULL, 0,
        "VCCapability/aal1ViaGateway/srtsClockRecovery", HFILL }},
    { &hf_h245_transportWithI_frames,
      { "transportWithI-frames", "h245.transportWithI_frames",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/transportWithI-frames", HFILL }},
    { &hf_h245_videoWithAL1,
      { "videoWithAL1", "h245.videoWithAL1",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/videoWithAL1", HFILL }},
    { &hf_h245_videoWithAL2,
      { "videoWithAL2", "h245.videoWithAL2",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/videoWithAL2", HFILL }},
    { &hf_h245_videoWithAL3,
      { "videoWithAL3", "h245.videoWithAL3",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/videoWithAL3", HFILL }},
    { &hf_h245_audioWithAL1,
      { "audioWithAL1", "h245.audioWithAL1",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/audioWithAL1", HFILL }},
    { &hf_h245_audioWithAL2,
      { "audioWithAL2", "h245.audioWithAL2",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/audioWithAL2", HFILL }},
    { &hf_h245_audioWithAL3,
      { "audioWithAL3", "h245.audioWithAL3",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/audioWithAL3", HFILL }},
    { &hf_h245_dataWithAL1,
      { "dataWithAL1", "h245.dataWithAL1",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/dataWithAL1", HFILL }},
    { &hf_h245_dataWithAL2,
      { "dataWithAL2", "h245.dataWithAL2",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/dataWithAL2", HFILL }},
    { &hf_h245_dataWithAL3,
      { "dataWithAL3", "h245.dataWithAL3",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/dataWithAL3", HFILL }},
    { &hf_h245_maximumAl2SDUSize,
      { "maximumAl2SDUSize", "h245.maximumAl2SDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/maximumAl2SDUSize", HFILL }},
    { &hf_h245_maximumAl3SDUSize,
      { "maximumAl3SDUSize", "h245.maximumAl3SDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/maximumAl3SDUSize", HFILL }},
    { &hf_h245_maximumDelayJitter,
      { "maximumDelayJitter", "h245.maximumDelayJitter",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/maximumDelayJitter", HFILL }},
    { &hf_h245_h223MultiplexTableCapability,
      { "h223MultiplexTableCapability", "h245.h223MultiplexTableCapability",
        FT_UINT32, BASE_DEC, VALS(h245_T_h223MultiplexTableCapability_vals), 0,
        "H223Capability/h223MultiplexTableCapability", HFILL }},
    { &hf_h245_basic,
      { "basic", "h245.basic",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223Capability/h223MultiplexTableCapability/basic", HFILL }},
    { &hf_h245_enhanced,
      { "enhanced", "h245.enhanced",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223Capability/h223MultiplexTableCapability/enhanced", HFILL }},
    { &hf_h245_maximumNestingDepth,
      { "maximumNestingDepth", "h245.maximumNestingDepth",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/h223MultiplexTableCapability/enhanced/maximumNestingDepth", HFILL }},
    { &hf_h245_maximumElementListSize,
      { "maximumElementListSize", "h245.maximumElementListSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/h223MultiplexTableCapability/enhanced/maximumElementListSize", HFILL }},
    { &hf_h245_maximumSubElementListSize,
      { "maximumSubElementListSize", "h245.maximumSubElementListSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/h223MultiplexTableCapability/enhanced/maximumSubElementListSize", HFILL }},
    { &hf_h245_maxMUXPDUSizeCapability,
      { "maxMUXPDUSizeCapability", "h245.maxMUXPDUSizeCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/maxMUXPDUSizeCapability", HFILL }},
    { &hf_h245_nsrpSupport,
      { "nsrpSupport", "h245.nsrpSupport",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/nsrpSupport", HFILL }},
    { &hf_h245_mobileOperationTransmitCapability,
      { "mobileOperationTransmitCapability", "h245.mobileOperationTransmitCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability", HFILL }},
    { &hf_h245_modeChangeCapability,
      { "modeChangeCapability", "h245.modeChangeCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability/modeChangeCapability", HFILL }},
    { &hf_h245_h223AnnexA,
      { "h223AnnexA", "h245.h223AnnexA",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability/h223AnnexA", HFILL }},
    { &hf_h245_h223AnnexADoubleFlagFlag,
      { "h223AnnexADoubleFlag", "h245.h223AnnexADoubleFlag",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability/h223AnnexADoubleFlag", HFILL }},
    { &hf_h245_h223AnnexB,
      { "h223AnnexB", "h245.h223AnnexB",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability/h223AnnexB", HFILL }},
    { &hf_h245_h223AnnexBwithHeader,
      { "h223AnnexBwithHeader", "h245.h223AnnexBwithHeader",
        FT_BOOLEAN, 8, NULL, 0,
        "H223Capability/mobileOperationTransmitCapability/h223AnnexBwithHeader", HFILL }},
    { &hf_h245_h223AnnexCCapability,
      { "h223AnnexCCapability", "h245.h223AnnexCCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223Capability/h223AnnexCCapability", HFILL }},
    { &hf_h245_bitRate_1_19200,
      { "bitRate", "h245.bitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_mobileMultilinkFrameCapability,
      { "mobileMultilinkFrameCapability", "h245.mobileMultilinkFrameCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223Capability/mobileMultilinkFrameCapability", HFILL }},
    { &hf_h245_maximumSampleSize,
      { "maximumSampleSize", "h245.maximumSampleSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/mobileMultilinkFrameCapability/maximumSampleSize", HFILL }},
    { &hf_h245_maximumPayloadLength,
      { "maximumPayloadLength", "h245.maximumPayloadLength",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223Capability/mobileMultilinkFrameCapability/maximumPayloadLength", HFILL }},
    { &hf_h245_videoWithAL1M,
      { "videoWithAL1M", "h245.videoWithAL1M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/videoWithAL1M", HFILL }},
    { &hf_h245_videoWithAL2M,
      { "videoWithAL2M", "h245.videoWithAL2M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/videoWithAL2M", HFILL }},
    { &hf_h245_videoWithAL3M,
      { "videoWithAL3M", "h245.videoWithAL3M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/videoWithAL3M", HFILL }},
    { &hf_h245_audioWithAL1M,
      { "audioWithAL1M", "h245.audioWithAL1M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/audioWithAL1M", HFILL }},
    { &hf_h245_audioWithAL2M,
      { "audioWithAL2M", "h245.audioWithAL2M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/audioWithAL2M", HFILL }},
    { &hf_h245_audioWithAL3M,
      { "audioWithAL3M", "h245.audioWithAL3M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/audioWithAL3M", HFILL }},
    { &hf_h245_dataWithAL1M,
      { "dataWithAL1M", "h245.dataWithAL1M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/dataWithAL1M", HFILL }},
    { &hf_h245_dataWithAL2M,
      { "dataWithAL2M", "h245.dataWithAL2M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/dataWithAL2M", HFILL }},
    { &hf_h245_dataWithAL3M,
      { "dataWithAL3M", "h245.dataWithAL3M",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/dataWithAL3M", HFILL }},
    { &hf_h245_alpduInterleaving,
      { "alpduInterleaving", "h245.alpduInterleaving",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_maximumAL1MPDUSize,
      { "maximumAL1MPDUSize", "h245.maximumAL1MPDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223AnnexCCapability/maximumAL1MPDUSize", HFILL }},
    { &hf_h245_maximumAL2MSDUSize,
      { "maximumAL2MSDUSize", "h245.maximumAL2MSDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223AnnexCCapability/maximumAL2MSDUSize", HFILL }},
    { &hf_h245_maximumAL3MSDUSize,
      { "maximumAL3MSDUSize", "h245.maximumAL3MSDUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223AnnexCCapability/maximumAL3MSDUSize", HFILL }},
    { &hf_h245_rsCodeCapability,
      { "rsCodeCapability", "h245.rsCodeCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AnnexCCapability/rsCodeCapability", HFILL }},
    { &hf_h245_suspendResumeCapabilitywAddress,
      { "suspendResumeCapabilitywAddress", "h245.suspendResumeCapabilitywAddress",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/suspendResumeCapabilitywAddress", HFILL }},
    { &hf_h245_suspendResumeCapabilitywoAddress,
      { "suspendResumeCapabilitywoAddress", "h245.suspendResumeCapabilitywoAddress",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/suspendResumeCapabilitywoAddress", HFILL }},
    { &hf_h245_rejCapability,
      { "rejCapability", "h245.rejCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/rejCapability", HFILL }},
    { &hf_h245_sREJCapability,
      { "sREJCapability", "h245.sREJCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/sREJCapability", HFILL }},
    { &hf_h245_mREJCapability,
      { "mREJCapability", "h245.mREJCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/mREJCapability", HFILL }},
    { &hf_h245_crc8bitCapability,
      { "crc8bitCapability", "h245.crc8bitCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/crc8bitCapability", HFILL }},
    { &hf_h245_crc16bitCapability,
      { "crc16bitCapability", "h245.crc16bitCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/crc16bitCapability", HFILL }},
    { &hf_h245_crc32bitCapability,
      { "crc32bitCapability", "h245.crc32bitCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/crc32bitCapability", HFILL }},
    { &hf_h245_uihCapability,
      { "uihCapability", "h245.uihCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/uihCapability", HFILL }},
    { &hf_h245_numOfDLCS,
      { "numOfDLCS", "h245.numOfDLCS",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V76Capability/numOfDLCS", HFILL }},
    { &hf_h245_twoOctetAddressFieldCapability,
      { "twoOctetAddressFieldCapability", "h245.twoOctetAddressFieldCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/twoOctetAddressFieldCapability", HFILL }},
    { &hf_h245_loopBackTestCapability,
      { "loopBackTestCapability", "h245.loopBackTestCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "V76Capability/loopBackTestCapability", HFILL }},
    { &hf_h245_n401Capability,
      { "n401Capability", "h245.n401Capability",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V76Capability/n401Capability", HFILL }},
    { &hf_h245_maxWindowSizeCapability,
      { "maxWindowSizeCapability", "h245.maxWindowSizeCapability",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V76Capability/maxWindowSizeCapability", HFILL }},
    { &hf_h245_v75Capability,
      { "v75Capability", "h245.v75Capability",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76Capability/v75Capability", HFILL }},
    { &hf_h245_audioHeader,
      { "audioHeader", "h245.audioHeader",
        FT_BOOLEAN, 8, NULL, 0,
        "V75Capability/audioHeader", HFILL }},
    { &hf_h245_maximumAudioDelayJitter,
      { "maximumAudioDelayJitter", "h245.maximumAudioDelayJitter",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H2250Capability/maximumAudioDelayJitter", HFILL }},
    { &hf_h245_receiveMultipointCapability,
      { "receiveMultipointCapability", "h245.receiveMultipointCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/receiveMultipointCapability", HFILL }},
    { &hf_h245_transmitMultipointCapability,
      { "transmitMultipointCapability", "h245.transmitMultipointCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/transmitMultipointCapability", HFILL }},
    { &hf_h245_receiveAndTransmitMultipointCapability,
      { "receiveAndTransmitMultipointCapability", "h245.receiveAndTransmitMultipointCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/receiveAndTransmitMultipointCapability", HFILL }},
    { &hf_h245_mcCapability,
      { "mcCapability", "h245.mcCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/mcCapability", HFILL }},
    { &hf_h245_centralizedConferenceMC,
      { "centralizedConferenceMC", "h245.centralizedConferenceMC",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250Capability/mcCapability/centralizedConferenceMC", HFILL }},
    { &hf_h245_decentralizedConferenceMC,
      { "decentralizedConferenceMC", "h245.decentralizedConferenceMC",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250Capability/mcCapability/decentralizedConferenceMC", HFILL }},
    { &hf_h245_rtcpVideoControlCapability,
      { "rtcpVideoControlCapability", "h245.rtcpVideoControlCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250Capability/rtcpVideoControlCapability", HFILL }},
    { &hf_h245_mediaPacketizationCapability,
      { "mediaPacketizationCapability", "h245.mediaPacketizationCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/mediaPacketizationCapability", HFILL }},
    { &hf_h245_transportCapability,
      { "transportCapability", "h245.transportCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_redundancyEncodingCapability,
      { "redundancyEncodingCapability", "h245.redundancyEncodingCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/redundancyEncodingCapability", HFILL }},
    { &hf_h245_redundancyEncodingCapability_item,
      { "Item", "h245.redundancyEncodingCapability_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250Capability/redundancyEncodingCapability/_item", HFILL }},
    { &hf_h245_logicalChannelSwitchingCapability,
      { "logicalChannelSwitchingCapability", "h245.logicalChannelSwitchingCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250Capability/logicalChannelSwitchingCapability", HFILL }},
    { &hf_h245_t120DynamicPortCapability,
      { "t120DynamicPortCapability", "h245.t120DynamicPortCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250Capability/t120DynamicPortCapability", HFILL }},
    { &hf_h245_h261aVideoPacketization,
      { "h261aVideoPacketization", "h245.h261aVideoPacketization",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaPacketizationCapability/h261aVideoPacketization", HFILL }},
    { &hf_h245_rtpPayloadType2,
      { "rtpPayloadType2", "h245.rtpPayloadType2",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaPacketizationCapability/rtpPayloadType2", HFILL }},
    { &hf_h245_rtpPayloadType2_item,
      { "Item", "h245.rtpPayloadType2_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaPacketizationCapability/rtpPayloadType2/_item", HFILL }},
    { &hf_h245_qosMode,
      { "qosMode", "h245.qosMode",
        FT_UINT32, BASE_DEC, VALS(h245_QOSMode_vals), 0,
        "RSVPParameters/qosMode", HFILL }},
    { &hf_h245_tokenRate,
      { "tokenRate", "h245.tokenRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RSVPParameters/tokenRate", HFILL }},
    { &hf_h245_bucketSize,
      { "bucketSize", "h245.bucketSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RSVPParameters/bucketSize", HFILL }},
    { &hf_h245_peakRate,
      { "peakRate", "h245.peakRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RSVPParameters/peakRate", HFILL }},
    { &hf_h245_minPoliced,
      { "minPoliced", "h245.minPoliced",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RSVPParameters/minPoliced", HFILL }},
    { &hf_h245_maxPktSize,
      { "maxPktSize", "h245.maxPktSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RSVPParameters/maxPktSize", HFILL }},
    { &hf_h245_guaranteedQOS,
      { "guaranteedQOS", "h245.guaranteedQOS",
        FT_NONE, BASE_NONE, NULL, 0,
        "QOSMode/guaranteedQOS", HFILL }},
    { &hf_h245_controlledLoad,
      { "controlledLoad", "h245.controlledLoad",
        FT_NONE, BASE_NONE, NULL, 0,
        "QOSMode/controlledLoad", HFILL }},
    { &hf_h245_maxNTUSize,
      { "maxNTUSize", "h245.maxNTUSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ATMParameters/maxNTUSize", HFILL }},
    { &hf_h245_atmUBR,
      { "atmUBR", "h245.atmUBR",
        FT_BOOLEAN, 8, NULL, 0,
        "ATMParameters/atmUBR", HFILL }},
    { &hf_h245_atmrtVBR,
      { "atmrtVBR", "h245.atmrtVBR",
        FT_BOOLEAN, 8, NULL, 0,
        "ATMParameters/atmrtVBR", HFILL }},
    { &hf_h245_atmnrtVBR,
      { "atmnrtVBR", "h245.atmnrtVBR",
        FT_BOOLEAN, 8, NULL, 0,
        "ATMParameters/atmnrtVBR", HFILL }},
    { &hf_h245_atmABR,
      { "atmABR", "h245.atmABR",
        FT_BOOLEAN, 8, NULL, 0,
        "ATMParameters/atmABR", HFILL }},
    { &hf_h245_atmCBR,
      { "atmCBR", "h245.atmCBR",
        FT_BOOLEAN, 8, NULL, 0,
        "ATMParameters/atmCBR", HFILL }},
    { &hf_h245_rsvpParameters,
      { "rsvpParameters", "h245.rsvpParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "QOSCapability/rsvpParameters", HFILL }},
    { &hf_h245_atmParameters,
      { "atmParameters", "h245.atmParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "QOSCapability/atmParameters", HFILL }},
    { &hf_h245_ip_UDP,
      { "ip-UDP", "h245.ip_UDP",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaTransportType/ip-UDP", HFILL }},
    { &hf_h245_ip_TCP,
      { "ip-TCP", "h245.ip_TCP",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaTransportType/ip-TCP", HFILL }},
    { &hf_h245_atm_AAL5_UNIDIR,
      { "atm-AAL5-UNIDIR", "h245.atm_AAL5_UNIDIR",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaTransportType/atm-AAL5-UNIDIR", HFILL }},
    { &hf_h245_atm_AAL5_BIDIR,
      { "atm-AAL5-BIDIR", "h245.atm_AAL5_BIDIR",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaTransportType/atm-AAL5-BIDIR", HFILL }},
    { &hf_h245_atm_AAL5_compressed,
      { "atm-AAL5-compressed", "h245.atm_AAL5_compressed",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaTransportType/atm-AAL5-compressed", HFILL }},
    { &hf_h245_variable_delta,
      { "variable-delta", "h245.variable_delta",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaTransportType/atm-AAL5-compressed/variable-delta", HFILL }},
    { &hf_h245_mediaTransport,
      { "mediaTransport", "h245.mediaTransport",
        FT_UINT32, BASE_DEC, VALS(h245_MediaTransportType_vals), 0,
        "MediaChannelCapability/mediaTransport", HFILL }},
    { &hf_h245_qOSCapabilities,
      { "qOSCapabilities", "h245.qOSCapabilities",
        FT_NONE, BASE_NONE, NULL, 0,
        "TransportCapability/qOSCapabilities", HFILL }},
    { &hf_h245_qOSCapabilities_item,
      { "Item", "h245.qOSCapabilities_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "TransportCapability/qOSCapabilities/_item", HFILL }},
    { &hf_h245_mediaChannelCapabilities,
      { "mediaChannelCapabilities", "h245.mediaChannelCapabilities",
        FT_NONE, BASE_NONE, NULL, 0,
        "TransportCapability/mediaChannelCapabilities", HFILL }},
    { &hf_h245_mediaChannelCapabilities_item,
      { "Item", "h245.mediaChannelCapabilities_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "TransportCapability/mediaChannelCapabilities/_item", HFILL }},
    { &hf_h245_redundancyEncodingMethod,
      { "redundancyEncodingMethod", "h245.redundancyEncodingMethod",
        FT_UINT32, BASE_DEC, VALS(h245_RedundancyEncodingMethod_vals), 0,
        "", HFILL }},
    { &hf_h245_primaryEncoding,
      { "primaryEncoding", "h245.primaryEncoding",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RedundancyEncodingCapability/primaryEncoding", HFILL }},
    { &hf_h245_secondaryEncoding2,
      { "secondaryEncoding2", "h245.secondaryEncoding2",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncodingCapability/secondaryEncoding2", HFILL }},
    { &hf_h245_secondaryEncoding2_item,
      { "Item", "h245.secondaryEncoding2_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RedundancyEncodingCapability/secondaryEncoding2/_item", HFILL }},
    { &hf_h245_rtpAudioRedundancyEncoding,
      { "rtpAudioRedundancyEncoding", "h245.rtpAudioRedundancyEncoding",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncodingMethod/rtpAudioRedundancyEncoding", HFILL }},
    { &hf_h245_rtpH263VideoRedundancyEncoding,
      { "rtpH263VideoRedundancyEncoding", "h245.rtpH263VideoRedundancyEncoding",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncodingMethod/rtpH263VideoRedundancyEncoding", HFILL }},
    { &hf_h245_numberOfThreads,
      { "numberOfThreads", "h245.numberOfThreads",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RTPH263VideoRedundancyEncoding/numberOfThreads", HFILL }},
    { &hf_h245_framesBetweenSyncPoints,
      { "framesBetweenSyncPoints", "h245.framesBetweenSyncPoints",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RTPH263VideoRedundancyEncoding/framesBetweenSyncPoints", HFILL }},
    { &hf_h245_frameToThreadMapping,
      { "frameToThreadMapping", "h245.frameToThreadMapping",
        FT_UINT32, BASE_DEC, VALS(h245_T_frameToThreadMapping_vals), 0,
        "RTPH263VideoRedundancyEncoding/frameToThreadMapping", HFILL }},
    { &hf_h245_roundrobin,
      { "roundrobin", "h245.roundrobin",
        FT_NONE, BASE_NONE, NULL, 0,
        "RTPH263VideoRedundancyEncoding/frameToThreadMapping/roundrobin", HFILL }},
    { &hf_h245_custom,
      { "custom", "h245.custom",
        FT_NONE, BASE_NONE, NULL, 0,
        "RTPH263VideoRedundancyEncoding/frameToThreadMapping/custom", HFILL }},
    { &hf_h245_custom_item,
      { "Item", "h245.custom_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "RTPH263VideoRedundancyEncoding/frameToThreadMapping/custom/_item", HFILL }},
    { &hf_h245_containedThreads,
      { "containedThreads", "h245.containedThreads",
        FT_NONE, BASE_NONE, NULL, 0,
        "RTPH263VideoRedundancyEncoding/containedThreads", HFILL }},
    { &hf_h245_containedThreads_item,
      { "Item", "h245.containedThreads_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RTPH263VideoRedundancyEncoding/containedThreads/_item", HFILL }},
    { &hf_h245_threadNumber,
      { "threadNumber", "h245.threadNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RTPH263VideoRedundancyFrameMapping/threadNumber", HFILL }},
    { &hf_h245_frameSequence,
      { "frameSequence", "h245.frameSequence",
        FT_NONE, BASE_NONE, NULL, 0,
        "RTPH263VideoRedundancyFrameMapping/frameSequence", HFILL }},
    { &hf_h245_frameSequence_item,
      { "Item", "h245.frameSequence_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RTPH263VideoRedundancyFrameMapping/frameSequence/_item", HFILL }},
    { &hf_h245_multicastCapability,
      { "multicastCapability", "h245.multicastCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "MultipointCapability/multicastCapability", HFILL }},
    { &hf_h245_multiUniCastConference,
      { "multiUniCastConference", "h245.multiUniCastConference",
        FT_BOOLEAN, 8, NULL, 0,
        "MultipointCapability/multiUniCastConference", HFILL }},
    { &hf_h245_mediaDistributionCapability,
      { "mediaDistributionCapability", "h245.mediaDistributionCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultipointCapability/mediaDistributionCapability", HFILL }},
    { &hf_h245_mediaDistributionCapability_item,
      { "Item", "h245.mediaDistributionCapability_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultipointCapability/mediaDistributionCapability/_item", HFILL }},
    { &hf_h245_centralizedControl,
      { "centralizedControl", "h245.centralizedControl",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/centralizedControl", HFILL }},
    { &hf_h245_distributedControl,
      { "distributedControl", "h245.distributedControl",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/distributedControl", HFILL }},
    { &hf_h245_centralizedAudio,
      { "centralizedAudio", "h245.centralizedAudio",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/centralizedAudio", HFILL }},
    { &hf_h245_distributedAudio,
      { "distributedAudio", "h245.distributedAudio",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/distributedAudio", HFILL }},
    { &hf_h245_centralizedVideo,
      { "centralizedVideo", "h245.centralizedVideo",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/centralizedVideo", HFILL }},
    { &hf_h245_distributedVideo,
      { "distributedVideo", "h245.distributedVideo",
        FT_BOOLEAN, 8, NULL, 0,
        "MediaDistributionCapability/distributedVideo", HFILL }},
    { &hf_h245_centralizedData,
      { "centralizedData", "h245.centralizedData",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaDistributionCapability/centralizedData", HFILL }},
    { &hf_h245_centralizedData_item,
      { "Item", "h245.centralizedData_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaDistributionCapability/centralizedData/_item", HFILL }},
    { &hf_h245_distributedData,
      { "distributedData", "h245.distributedData",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaDistributionCapability/distributedData", HFILL }},
    { &hf_h245_distributedData_item,
      { "Item", "h245.distributedData_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MediaDistributionCapability/distributedData/_item", HFILL }},
    { &hf_h245_h261VideoCapability,
      { "h261VideoCapability", "h245.h261VideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/h261VideoCapability", HFILL }},
    { &hf_h245_h262VideoCapability,
      { "h262VideoCapability", "h245.h262VideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/h262VideoCapability", HFILL }},
    { &hf_h245_h263VideoCapability,
      { "h263VideoCapability", "h245.h263VideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/h263VideoCapability", HFILL }},
    { &hf_h245_is11172VideoCapability,
      { "is11172VideoCapability", "h245.is11172VideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/is11172VideoCapability", HFILL }},
    { &hf_h245_genericVideoCapability,
      { "genericVideoCapability", "h245.genericVideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/genericVideoCapability", HFILL }},
    { &hf_h245_extendedVideoCapability,
      { "extendedVideoCapability", "h245.extendedVideoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "VideoCapability/extendedVideoCapability", HFILL }},
    { &hf_h245_videoCapability,
      { "videoCapability", "h245.videoCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "ExtendedVideoCapability/videoCapability", HFILL }},
    { &hf_h245_videoCapability_item,
      { "Item", "h245.videoCapability_item",
        FT_UINT32, BASE_DEC, VALS(h245_VideoCapability_vals), 0,
        "ExtendedVideoCapability/videoCapability/_item", HFILL }},
    { &hf_h245_videoCapabilityExtension,
      { "videoCapabilityExtension", "h245.videoCapabilityExtension",
        FT_NONE, BASE_NONE, NULL, 0,
        "ExtendedVideoCapability/videoCapabilityExtension", HFILL }},
    { &hf_h245_videoCapabilityExtension_item,
      { "Item", "h245.videoCapabilityExtension_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ExtendedVideoCapability/videoCapabilityExtension/_item", HFILL }},
    { &hf_h245_qcifMPI_1_4,
      { "qcifMPI", "h245.qcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H261VideoCapability/qcifMPI", HFILL }},
    { &hf_h245_cifMPI_1_4,
      { "cifMPI", "h245.cifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H261VideoCapability/cifMPI", HFILL }},
    { &hf_h245_temporalSpatialTradeOffCapability,
      { "temporalSpatialTradeOffCapability", "h245.temporalSpatialTradeOffCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_maxBitRate_1_19200,
      { "maxBitRate", "h245.maxBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H261VideoCapability/maxBitRate", HFILL }},
    { &hf_h245_stillImageTransmission,
      { "stillImageTransmission", "h245.stillImageTransmission",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_videoBadMBsCap,
      { "videoBadMBsCap", "h245.videoBadMBsCap",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_profileAndLevel_SPatML,
      { "profileAndLevel-SPatML", "h245.profileAndLevel_SPatML",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-SPatML", HFILL }},
    { &hf_h245_profileAndLevel_MPatLL,
      { "profileAndLevel-MPatLL", "h245.profileAndLevel_MPatLL",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-MPatLL", HFILL }},
    { &hf_h245_profileAndLevel_MPatML,
      { "profileAndLevel-MPatML", "h245.profileAndLevel_MPatML",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-MPatML", HFILL }},
    { &hf_h245_profileAndLevel_MPatH_14,
      { "profileAndLevel-MPatH-14", "h245.profileAndLevel_MPatH_14",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-MPatH-14", HFILL }},
    { &hf_h245_profileAndLevel_MPatHL,
      { "profileAndLevel-MPatHL", "h245.profileAndLevel_MPatHL",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-MPatHL", HFILL }},
    { &hf_h245_profileAndLevel_SNRatLL,
      { "profileAndLevel-SNRatLL", "h245.profileAndLevel_SNRatLL",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-SNRatLL", HFILL }},
    { &hf_h245_profileAndLevel_SNRatML,
      { "profileAndLevel-SNRatML", "h245.profileAndLevel_SNRatML",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-SNRatML", HFILL }},
    { &hf_h245_profileAndLevel_SpatialatH_14,
      { "profileAndLevel-SpatialatH-14", "h245.profileAndLevel_SpatialatH_14",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-SpatialatH-14", HFILL }},
    { &hf_h245_profileAndLevel_HPatML,
      { "profileAndLevel-HPatML", "h245.profileAndLevel_HPatML",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-HPatML", HFILL }},
    { &hf_h245_profileAndLevel_HPatH_14,
      { "profileAndLevel-HPatH-14", "h245.profileAndLevel_HPatH_14",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-HPatH-14", HFILL }},
    { &hf_h245_profileAndLevel_HPatHL,
      { "profileAndLevel-HPatHL", "h245.profileAndLevel_HPatHL",
        FT_BOOLEAN, 8, NULL, 0,
        "H262VideoCapability/profileAndLevel-HPatHL", HFILL }},
    { &hf_h245_videoBitRate,
      { "videoBitRate", "h245.videoBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_vbvBufferSize,
      { "vbvBufferSize", "h245.vbvBufferSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_samplesPerLine,
      { "samplesPerLine", "h245.samplesPerLine",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_linesPerFrame,
      { "linesPerFrame", "h245.linesPerFrame",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_framesPerSecond,
      { "framesPerSecond", "h245.framesPerSecond",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_luminanceSampleRate,
      { "luminanceSampleRate", "h245.luminanceSampleRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_sqcifMPI_1_32,
      { "sqcifMPI", "h245.sqcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_qcifMPI,
      { "qcifMPI", "h245.qcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_cifMPI,
      { "cifMPI", "h245.cifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_cif4MPI_1_32,
      { "cif4MPI", "h245.cif4MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_cif16MPI_1_32,
      { "cif16MPI", "h245.cif16MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_maxBitRate,
      { "maxBitRate", "h245.maxBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_unrestrictedVector,
      { "unrestrictedVector", "h245.unrestrictedVector",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_arithmeticCoding,
      { "arithmeticCoding", "h245.arithmeticCoding",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_advancedPrediction,
      { "advancedPrediction", "h245.advancedPrediction",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_pbFrames,
      { "pbFrames", "h245.pbFrames",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_hrd_B,
      { "hrd-B", "h245.hrd_B",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H263VideoCapability/hrd-B", HFILL }},
    { &hf_h245_bppMaxKb,
      { "bppMaxKb", "h245.bppMaxKb",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H263VideoCapability/bppMaxKb", HFILL }},
    { &hf_h245_slowSqcifMPI,
      { "slowSqcifMPI", "h245.slowSqcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_slowQcifMPI,
      { "slowQcifMPI", "h245.slowQcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_slowCifMPI,
      { "slowCifMPI", "h245.slowCifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_slowCif4MPI,
      { "slowCif4MPI", "h245.slowCif4MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_slowCif16MPI,
      { "slowCif16MPI", "h245.slowCif16MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_errorCompensation,
      { "errorCompensation", "h245.errorCompensation",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_enhancementLayerInfo,
      { "enhancementLayerInfo", "h245.enhancementLayerInfo",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_h263Options,
      { "h263Options", "h245.h263Options",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_baseBitRateConstrained,
      { "baseBitRateConstrained", "h245.baseBitRateConstrained",
        FT_BOOLEAN, 8, NULL, 0,
        "EnhancementLayerInfo/baseBitRateConstrained", HFILL }},
    { &hf_h245_snrEnhancement,
      { "snrEnhancement", "h245.snrEnhancement",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/snrEnhancement", HFILL }},
    { &hf_h245_snrEnhancement_item,
      { "Item", "h245.snrEnhancement_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/snrEnhancement/_item", HFILL }},
    { &hf_h245_spatialEnhancement,
      { "spatialEnhancement", "h245.spatialEnhancement",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/spatialEnhancement", HFILL }},
    { &hf_h245_spatialEnhancement_item,
      { "Item", "h245.spatialEnhancement_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/spatialEnhancement/_item", HFILL }},
    { &hf_h245_bPictureEnhancement,
      { "bPictureEnhancement", "h245.bPictureEnhancement",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/bPictureEnhancement", HFILL }},
    { &hf_h245_bPictureEnhancement_item,
      { "Item", "h245.bPictureEnhancement_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "EnhancementLayerInfo/bPictureEnhancement/_item", HFILL }},
    { &hf_h245_enhancementOptions,
      { "enhancementOptions", "h245.enhancementOptions",
        FT_NONE, BASE_NONE, NULL, 0,
        "BEnhancementParameters/enhancementOptions", HFILL }},
    { &hf_h245_numberOfBPictures,
      { "numberOfBPictures", "h245.numberOfBPictures",
        FT_UINT32, BASE_DEC, NULL, 0,
        "BEnhancementParameters/numberOfBPictures", HFILL }},
    { &hf_h245_advancedIntraCodingMode,
      { "advancedIntraCodingMode", "h245.advancedIntraCodingMode",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_deblockingFilterMode,
      { "deblockingFilterMode", "h245.deblockingFilterMode",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_improvedPBFramesMode,
      { "improvedPBFramesMode", "h245.improvedPBFramesMode",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_unlimitedMotionVectors,
      { "unlimitedMotionVectors", "h245.unlimitedMotionVectors",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_fullPictureFreeze,
      { "fullPictureFreeze", "h245.fullPictureFreeze",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/fullPictureFreeze", HFILL }},
    { &hf_h245_partialPictureFreezeAndRelease,
      { "partialPictureFreezeAndRelease", "h245.partialPictureFreezeAndRelease",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/partialPictureFreezeAndRelease", HFILL }},
    { &hf_h245_resizingPartPicFreezeAndRelease,
      { "resizingPartPicFreezeAndRelease", "h245.resizingPartPicFreezeAndRelease",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/resizingPartPicFreezeAndRelease", HFILL }},
    { &hf_h245_fullPictureSnapshot,
      { "fullPictureSnapshot", "h245.fullPictureSnapshot",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/fullPictureSnapshot", HFILL }},
    { &hf_h245_partialPictureSnapshot,
      { "partialPictureSnapshot", "h245.partialPictureSnapshot",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/partialPictureSnapshot", HFILL }},
    { &hf_h245_videoSegmentTagging,
      { "videoSegmentTagging", "h245.videoSegmentTagging",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/videoSegmentTagging", HFILL }},
    { &hf_h245_progressiveRefinement,
      { "progressiveRefinement", "h245.progressiveRefinement",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/progressiveRefinement", HFILL }},
    { &hf_h245_dynamicPictureResizingByFour,
      { "dynamicPictureResizingByFour", "h245.dynamicPictureResizingByFour",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_dynamicPictureResizingSixteenthPel,
      { "dynamicPictureResizingSixteenthPel", "h245.dynamicPictureResizingSixteenthPel",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_dynamicWarpingHalfPel,
      { "dynamicWarpingHalfPel", "h245.dynamicWarpingHalfPel",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_dynamicWarpingSixteenthPel,
      { "dynamicWarpingSixteenthPel", "h245.dynamicWarpingSixteenthPel",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_independentSegmentDecoding,
      { "independentSegmentDecoding", "h245.independentSegmentDecoding",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_slicesInOrder_NonRect,
      { "slicesInOrder-NonRect", "h245.slicesInOrder_NonRect",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_slicesInOrder_Rect,
      { "slicesInOrder-Rect", "h245.slicesInOrder_Rect",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_slicesNoOrder_NonRect,
      { "slicesNoOrder-NonRect", "h245.slicesNoOrder_NonRect",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_slicesNoOrder_Rect,
      { "slicesNoOrder-Rect", "h245.slicesNoOrder_Rect",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_alternateInterVLCMode,
      { "alternateInterVLCMode", "h245.alternateInterVLCMode",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_modifiedQuantizationMode,
      { "modifiedQuantizationMode", "h245.modifiedQuantizationMode",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_reducedResolutionUpdate,
      { "reducedResolutionUpdate", "h245.reducedResolutionUpdate",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_transparencyParameters,
      { "transparencyParameters", "h245.transparencyParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/transparencyParameters", HFILL }},
    { &hf_h245_separateVideoBackChannel,
      { "separateVideoBackChannel", "h245.separateVideoBackChannel",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Options/separateVideoBackChannel", HFILL }},
    { &hf_h245_refPictureSelection,
      { "refPictureSelection", "h245.refPictureSelection",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/refPictureSelection", HFILL }},
    { &hf_h245_customPictureClockFrequency,
      { "customPictureClockFrequency", "h245.customPictureClockFrequency",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/customPictureClockFrequency", HFILL }},
    { &hf_h245_customPictureClockFrequency_item,
      { "Item", "h245.customPictureClockFrequency_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/customPictureClockFrequency/_item", HFILL }},
    { &hf_h245_customPictureFormat,
      { "customPictureFormat", "h245.customPictureFormat",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/customPictureFormat", HFILL }},
    { &hf_h245_customPictureFormat_item,
      { "Item", "h245.customPictureFormat_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/customPictureFormat/_item", HFILL }},
    { &hf_h245_modeCombos,
      { "modeCombos", "h245.modeCombos",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/modeCombos", HFILL }},
    { &hf_h245_modeCombos_item,
      { "Item", "h245.modeCombos_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263Options/modeCombos/_item", HFILL }},
    { &hf_h245_h263Version3Options,
      { "h263Version3Options", "h245.h263Version3Options",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_presentationOrder,
      { "presentationOrder", "h245.presentationOrder",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TransparencyParameters/presentationOrder", HFILL }},
    { &hf_h245_offset_x,
      { "offset-x", "h245.offset_x",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TransparencyParameters/offset-x", HFILL }},
    { &hf_h245_offset_y,
      { "offset-y", "h245.offset_y",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TransparencyParameters/offset-y", HFILL }},
    { &hf_h245_scale_x,
      { "scale-x", "h245.scale_x",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TransparencyParameters/scale-x", HFILL }},
    { &hf_h245_scale_y,
      { "scale-y", "h245.scale_y",
        FT_UINT32, BASE_DEC, NULL, 0,
        "TransparencyParameters/scale-y", HFILL }},
    { &hf_h245_additionalPictureMemory,
      { "additionalPictureMemory", "h245.additionalPictureMemory",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/additionalPictureMemory", HFILL }},
    { &hf_h245_sqcifAdditionalPictureMemory,
      { "sqcifAdditionalPictureMemory", "h245.sqcifAdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/sqcifAdditionalPictureMemory", HFILL }},
    { &hf_h245_qcifAdditionalPictureMemory,
      { "qcifAdditionalPictureMemory", "h245.qcifAdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/qcifAdditionalPictureMemory", HFILL }},
    { &hf_h245_cifAdditionalPictureMemory,
      { "cifAdditionalPictureMemory", "h245.cifAdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/cifAdditionalPictureMemory", HFILL }},
    { &hf_h245_cif4AdditionalPictureMemory,
      { "cif4AdditionalPictureMemory", "h245.cif4AdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/cif4AdditionalPictureMemory", HFILL }},
    { &hf_h245_cif16AdditionalPictureMemory,
      { "cif16AdditionalPictureMemory", "h245.cif16AdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/cif16AdditionalPictureMemory", HFILL }},
    { &hf_h245_bigCpfAdditionalPictureMemory,
      { "bigCpfAdditionalPictureMemory", "h245.bigCpfAdditionalPictureMemory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/additionalPictureMemory/bigCpfAdditionalPictureMemory", HFILL }},
    { &hf_h245_videoMux,
      { "videoMux", "h245.videoMux",
        FT_BOOLEAN, 8, NULL, 0,
        "RefPictureSelection/videoMux", HFILL }},
    { &hf_h245_videoBackChannelSend,
      { "videoBackChannelSend", "h245.videoBackChannelSend",
        FT_UINT32, BASE_DEC, VALS(h245_T_videoBackChannelSend_vals), 0,
        "RefPictureSelection/videoBackChannelSend", HFILL }},
    { &hf_h245_none,
      { "none", "h245.none",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_ackMessageOnly,
      { "ackMessageOnly", "h245.ackMessageOnly",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/videoBackChannelSend/ackMessageOnly", HFILL }},
    { &hf_h245_nackMessageOnly,
      { "nackMessageOnly", "h245.nackMessageOnly",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/videoBackChannelSend/nackMessageOnly", HFILL }},
    { &hf_h245_ackOrNackMessageOnly,
      { "ackOrNackMessageOnly", "h245.ackOrNackMessageOnly",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/videoBackChannelSend/ackOrNackMessageOnly", HFILL }},
    { &hf_h245_ackAndNackMessage,
      { "ackAndNackMessage", "h245.ackAndNackMessage",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/videoBackChannelSend/ackAndNackMessage", HFILL }},
    { &hf_h245_enhancedReferencePicSelect,
      { "enhancedReferencePicSelect", "h245.enhancedReferencePicSelect",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/enhancedReferencePicSelect", HFILL }},
    { &hf_h245_subPictureRemovalParameters,
      { "subPictureRemovalParameters", "h245.subPictureRemovalParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "RefPictureSelection/enhancedReferencePicSelect/subPictureRemovalParameters", HFILL }},
    { &hf_h245_mpuHorizMBs,
      { "mpuHorizMBs", "h245.mpuHorizMBs",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/enhancedReferencePicSelect/subPictureRemovalParameters/mpuHorizMBs", HFILL }},
    { &hf_h245_mpuVertMBs,
      { "mpuVertMBs", "h245.mpuVertMBs",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/enhancedReferencePicSelect/subPictureRemovalParameters/mpuVertMBs", HFILL }},
    { &hf_h245_mpuTotalNumber,
      { "mpuTotalNumber", "h245.mpuTotalNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RefPictureSelection/enhancedReferencePicSelect/subPictureRemovalParameters/mpuTotalNumber", HFILL }},
    { &hf_h245_clockConversionCode,
      { "clockConversionCode", "h245.clockConversionCode",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_clockDivisor,
      { "clockDivisor", "h245.clockDivisor",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_sqcifMPI,
      { "sqcifMPI", "h245.sqcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureClockFrequency/sqcifMPI", HFILL }},
    { &hf_h245_qcifMPI_1_2048,
      { "qcifMPI", "h245.qcifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureClockFrequency/qcifMPI", HFILL }},
    { &hf_h245_cifMPI2_1_2048,
      { "cifMPI", "h245.cifMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureClockFrequency/cifMPI", HFILL }},
    { &hf_h245_cif4MPI,
      { "cif4MPI", "h245.cif4MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureClockFrequency/cif4MPI", HFILL }},
    { &hf_h245_cif16MPI,
      { "cif16MPI", "h245.cif16MPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureClockFrequency/cif16MPI", HFILL }},
    { &hf_h245_maxCustomPictureWidth,
      { "maxCustomPictureWidth", "h245.maxCustomPictureWidth",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/maxCustomPictureWidth", HFILL }},
    { &hf_h245_maxCustomPictureHeight,
      { "maxCustomPictureHeight", "h245.maxCustomPictureHeight",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/maxCustomPictureHeight", HFILL }},
    { &hf_h245_minCustomPictureWidth,
      { "minCustomPictureWidth", "h245.minCustomPictureWidth",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/minCustomPictureWidth", HFILL }},
    { &hf_h245_minCustomPictureHeight,
      { "minCustomPictureHeight", "h245.minCustomPictureHeight",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/minCustomPictureHeight", HFILL }},
    { &hf_h245_mPI,
      { "mPI", "h245.mPI",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/mPI", HFILL }},
    { &hf_h245_standardMPI,
      { "standardMPI", "h245.standardMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/mPI/standardMPI", HFILL }},
    { &hf_h245_customPCF,
      { "customPCF", "h245.customPCF",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/mPI/customPCF", HFILL }},
    { &hf_h245_customPCF_item,
      { "Item", "h245.customPCF_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/mPI/customPCF/_item", HFILL }},
    { &hf_h245_customMPI,
      { "customMPI", "h245.customMPI",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/mPI/customPCF/_item/customMPI", HFILL }},
    { &hf_h245_pixelAspectInformation,
      { "pixelAspectInformation", "h245.pixelAspectInformation",
        FT_UINT32, BASE_DEC, VALS(h245_T_pixelAspectInformation_vals), 0,
        "CustomPictureFormat/pixelAspectInformation", HFILL }},
    { &hf_h245_anyPixelAspectRatio,
      { "anyPixelAspectRatio", "h245.anyPixelAspectRatio",
        FT_BOOLEAN, 8, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/anyPixelAspectRatio", HFILL }},
    { &hf_h245_pixelAspectCode,
      { "pixelAspectCode", "h245.pixelAspectCode",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/pixelAspectCode", HFILL }},
    { &hf_h245_pixelAspectCode_item,
      { "Item", "h245.pixelAspectCode_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/pixelAspectCode/_item", HFILL }},
    { &hf_h245_extendedPAR,
      { "extendedPAR", "h245.extendedPAR",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/extendedPAR", HFILL }},
    { &hf_h245_extendedPAR_item,
      { "Item", "h245.extendedPAR_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/extendedPAR/_item", HFILL }},
    { &hf_h245_width,
      { "width", "h245.width",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/extendedPAR/_item/width", HFILL }},
    { &hf_h245_height,
      { "height", "h245.height",
        FT_UINT32, BASE_DEC, NULL, 0,
        "CustomPictureFormat/pixelAspectInformation/extendedPAR/_item/height", HFILL }},
    { &hf_h245_h263VideoUncoupledModes,
      { "h263VideoUncoupledModes", "h245.h263VideoUncoupledModes",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263VideoModeCombos/h263VideoUncoupledModes", HFILL }},
    { &hf_h245_h263VideoCoupledModes,
      { "h263VideoCoupledModes", "h245.h263VideoCoupledModes",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263VideoModeCombos/h263VideoCoupledModes", HFILL }},
    { &hf_h245_h263VideoCoupledModes_item,
      { "Item", "h245.h263VideoCoupledModes_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "H263VideoModeCombos/h263VideoCoupledModes/_item", HFILL }},
    { &hf_h245_referencePicSelect,
      { "referencePicSelect", "h245.referencePicSelect",
        FT_BOOLEAN, 8, NULL, 0,
        "H263ModeComboFlags/referencePicSelect", HFILL }},
    { &hf_h245_enhancedReferencePicSelectBool,
      { "enhancedReferencePicSelect", "h245.enhancedReferencePicSelect",
        FT_BOOLEAN, 8, NULL, 0,
        "H263ModeComboFlags/enhancedReferencePicSelect", HFILL }},
    { &hf_h245_dataPartitionedSlices,
      { "dataPartitionedSlices", "h245.dataPartitionedSlices",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/dataPartitionedSlices", HFILL }},
    { &hf_h245_fixedPointIDCT0,
      { "fixedPointIDCT0", "h245.fixedPointIDCT0",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/fixedPointIDCT0", HFILL }},
    { &hf_h245_interlacedFields,
      { "interlacedFields", "h245.interlacedFields",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/interlacedFields", HFILL }},
    { &hf_h245_currentPictureHeaderRepetition,
      { "currentPictureHeaderRepetition", "h245.currentPictureHeaderRepetition",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/currentPictureHeaderRepetition", HFILL }},
    { &hf_h245_previousPictureHeaderRepetition,
      { "previousPictureHeaderRepetition", "h245.previousPictureHeaderRepetition",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/previousPictureHeaderRepetition", HFILL }},
    { &hf_h245_nextPictureHeaderRepetition,
      { "nextPictureHeaderRepetition", "h245.nextPictureHeaderRepetition",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/nextPictureHeaderRepetition", HFILL }},
    { &hf_h245_pictureNumberBoolean,
      { "pictureNumber", "h245.pictureNumber",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/pictureNumber", HFILL }},
    { &hf_h245_spareReferencePictures,
      { "spareReferencePictures", "h245.spareReferencePictures",
        FT_BOOLEAN, 8, NULL, 0,
        "H263Version3Options/spareReferencePictures", HFILL }},
    { &hf_h245_constrainedBitstream,
      { "constrainedBitstream", "h245.constrainedBitstream",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_pictureRate,
      { "pictureRate", "h245.pictureRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_g711Alaw64k,
      { "g711Alaw64k", "h245.g711Alaw64k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g711Alaw64k", HFILL }},
    { &hf_h245_g711Alaw56k,
      { "g711Alaw56k", "h245.g711Alaw56k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g711Alaw56k", HFILL }},
    { &hf_h245_g711Ulaw64k,
      { "g711Ulaw64k", "h245.g711Ulaw64k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g711Ulaw64k", HFILL }},
    { &hf_h245_g711Ulaw56k,
      { "g711Ulaw56k", "h245.g711Ulaw56k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g711Ulaw56k", HFILL }},
    { &hf_h245_g722_64k,
      { "g722-64k", "h245.g722_64k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g722-64k", HFILL }},
    { &hf_h245_g722_56k,
      { "g722-56k", "h245.g722_56k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g722-56k", HFILL }},
    { &hf_h245_g722_48k,
      { "g722-48k", "h245.g722_48k",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g722-48k", HFILL }},
    { &hf_h245_g7231,
      { "g7231", "h245.g7231",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/g7231", HFILL }},
    { &hf_h245_maxAl_sduAudioFrames,
      { "maxAl-sduAudioFrames", "h245.maxAl_sduAudioFrames",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_silenceSuppression,
      { "silenceSuppression", "h245.silenceSuppression",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_g728,
      { "g728", "h245.g728",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g728", HFILL }},
    { &hf_h245_g729,
      { "g729", "h245.g729",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g729", HFILL }},
    { &hf_h245_g729AnnexA,
      { "g729AnnexA", "h245.g729AnnexA",
        FT_UINT32, BASE_DEC, NULL, 0,
        "AudioCapability/g729AnnexA", HFILL }},
    { &hf_h245_is11172AudioCapability,
      { "is11172AudioCapability", "h245.is11172AudioCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/is11172AudioCapability", HFILL }},
    { &hf_h245_is13818AudioCapability,
      { "is13818AudioCapability", "h245.is13818AudioCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/is13818AudioCapability", HFILL }},
    { &hf_h245_g729wAnnexB,
      { "g729wAnnexB", "h245.g729wAnnexB",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_g729AnnexAwAnnexB,
      { "g729AnnexAwAnnexB", "h245.g729AnnexAwAnnexB",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_g7231AnnexCCapability,
      { "g7231AnnexCCapability", "h245.g7231AnnexCCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/g7231AnnexCCapability", HFILL }},
    { &hf_h245_gsmFullRate,
      { "gsmFullRate", "h245.gsmFullRate",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_gsmHalfRate,
      { "gsmHalfRate", "h245.gsmHalfRate",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_gsmEnhancedFullRate,
      { "gsmEnhancedFullRate", "h245.gsmEnhancedFullRate",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_genericAudioCapability,
      { "genericAudioCapability", "h245.genericAudioCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/genericAudioCapability", HFILL }},
    { &hf_h245_g729Extensions,
      { "g729Extensions", "h245.g729Extensions",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_vbd,
      { "vbd", "h245.vbd",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/vbd", HFILL }},
    { &hf_h245_audioTelephonyEvent,
      { "audioTelephonyEvent", "h245.audioTelephonyEvent",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/audioTelephonyEvent", HFILL }},
    { &hf_h245_audioTone,
      { "audioTone", "h245.audioTone",
        FT_NONE, BASE_NONE, NULL, 0,
        "AudioCapability/audioTone", HFILL }},
    { &hf_h245_audioUnit,
      { "audioUnit", "h245.audioUnit",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G729Extensions/audioUnit", HFILL }},
    { &hf_h245_annexA,
      { "annexA", "h245.annexA",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexA", HFILL }},
    { &hf_h245_annexB,
      { "annexB", "h245.annexB",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexB", HFILL }},
    { &hf_h245_annexD,
      { "annexD", "h245.annexD",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexD", HFILL }},
    { &hf_h245_annexE,
      { "annexE", "h245.annexE",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexE", HFILL }},
    { &hf_h245_annexF,
      { "annexF", "h245.annexF",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexF", HFILL }},
    { &hf_h245_annexG,
      { "annexG", "h245.annexG",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexG", HFILL }},
    { &hf_h245_annexH,
      { "annexH", "h245.annexH",
        FT_BOOLEAN, 8, NULL, 0,
        "G729Extensions/annexH", HFILL }},
    { &hf_h245_g723AnnexCAudioMode,
      { "g723AnnexCAudioMode", "h245.g723AnnexCAudioMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_highRateMode0,
      { "highRateMode0", "h245.highRateMode0",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/highRateMode0", HFILL }},
    { &hf_h245_highRateMode1,
      { "highRateMode1", "h245.highRateMode1",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/highRateMode1", HFILL }},
    { &hf_h245_lowRateMode0,
      { "lowRateMode0", "h245.lowRateMode0",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/lowRateMode0", HFILL }},
    { &hf_h245_lowRateMode1,
      { "lowRateMode1", "h245.lowRateMode1",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/lowRateMode1", HFILL }},
    { &hf_h245_sidMode0,
      { "sidMode0", "h245.sidMode0",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/sidMode0", HFILL }},
    { &hf_h245_sidMode1,
      { "sidMode1", "h245.sidMode1",
        FT_UINT32, BASE_DEC, NULL, 0,
        "G723AnnexCAudioMode/sidMode1", HFILL }},
    { &hf_h245_audioLayer1,
      { "audioLayer1", "h245.audioLayer1",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioLayer2,
      { "audioLayer2", "h245.audioLayer2",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioLayer3,
      { "audioLayer3", "h245.audioLayer3",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioSampling32k,
      { "audioSampling32k", "h245.audioSampling32k",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioSampling44k1,
      { "audioSampling44k1", "h245.audioSampling44k1",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioSampling48k,
      { "audioSampling48k", "h245.audioSampling48k",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_singleChannel,
      { "singleChannel", "h245.singleChannel",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_twoChannels,
      { "twoChannels", "h245.twoChannels",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_bitRate_1_448,
      { "bitRate", "h245.bitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioSampling16k,
      { "audioSampling16k", "h245.audioSampling16k",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/audioSampling16k", HFILL }},
    { &hf_h245_audioSampling22k05,
      { "audioSampling22k05", "h245.audioSampling22k05",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/audioSampling22k05", HFILL }},
    { &hf_h245_audioSampling24k,
      { "audioSampling24k", "h245.audioSampling24k",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/audioSampling24k", HFILL }},
    { &hf_h245_threeChannels2_1,
      { "threeChannels2-1", "h245.threeChannels2_1",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/threeChannels2-1", HFILL }},
    { &hf_h245_threeChannels3_0,
      { "threeChannels3-0", "h245.threeChannels3_0",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/threeChannels3-0", HFILL }},
    { &hf_h245_fourChannels2_0_2_0,
      { "fourChannels2-0-2-0", "h245.fourChannels2_0_2_0",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/fourChannels2-0-2-0", HFILL }},
    { &hf_h245_fourChannels2_2,
      { "fourChannels2-2", "h245.fourChannels2_2",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/fourChannels2-2", HFILL }},
    { &hf_h245_fourChannels3_1,
      { "fourChannels3-1", "h245.fourChannels3_1",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/fourChannels3-1", HFILL }},
    { &hf_h245_fiveChannels3_0_2_0,
      { "fiveChannels3-0-2-0", "h245.fiveChannels3_0_2_0",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/fiveChannels3-0-2-0", HFILL }},
    { &hf_h245_fiveChannels3_2,
      { "fiveChannels3-2", "h245.fiveChannels3_2",
        FT_BOOLEAN, 8, NULL, 0,
        "IS13818AudioCapability/fiveChannels3-2", HFILL }},
    { &hf_h245_lowFrequencyEnhancement,
      { "lowFrequencyEnhancement", "h245.lowFrequencyEnhancement",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_multilingual,
      { "multilingual", "h245.multilingual",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_bitRate2_1_1130,
      { "bitRate", "h245.bitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioUnitSize,
      { "audioUnitSize", "h245.audioUnitSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "GSMAudioCapability/audioUnitSize", HFILL }},
    { &hf_h245_comfortNoise,
      { "comfortNoise", "h245.comfortNoise",
        FT_BOOLEAN, 8, NULL, 0,
        "GSMAudioCapability/comfortNoise", HFILL }},
    { &hf_h245_scrambled,
      { "scrambled", "h245.scrambled",
        FT_BOOLEAN, 8, NULL, 0,
        "GSMAudioCapability/scrambled", HFILL }},
    { &hf_h245_vbd_cap_type,
      { "type", "h245.type",
        FT_UINT32, BASE_DEC, VALS(h245_AudioCapability_vals), 0,
        "VBDCapability/type", HFILL }},
    { &hf_h245_application,
      { "application", "h245.application",
        FT_UINT32, BASE_DEC, VALS(h245_Application_vals), 0,
        "DataApplicationCapability/application", HFILL }},
    { &hf_h245_maxBitRate2_0_4294967295,
      { "maxBitRate", "h245.maxBitRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_t120,
      { "t120", "h245.t120",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_dsm_cc,
      { "dsm-cc", "h245.dsm_cc",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_userData,
      { "userData", "h245.userData",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_t84,
      { "t84", "h245.t84",
        FT_NONE, BASE_NONE, NULL, 0,
        "Application/t84", HFILL }},
    { &hf_h245_t84Protocol,
      { "t84Protocol", "h245.t84Protocol",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "Application/t84/t84Protocol", HFILL }},
    { &hf_h245_t84Profile,
      { "t84Profile", "h245.t84Profile",
        FT_UINT32, BASE_DEC, VALS(h245_T84Profile_vals), 0,
        "Application/t84/t84Profile", HFILL }},
    { &hf_h245_t434,
      { "t434", "h245.t434",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_h224,
      { "h224", "h245.h224",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_nlpid,
      { "nlpid", "h245.nlpid",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_dsvdControl,
      { "dsvdControl", "h245.dsvdControl",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_h222DataPartitioning,
      { "h222DataPartitioning", "h245.h222DataPartitioning",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_t30fax,
      { "t30fax", "h245.t30fax",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_t140,
      { "t140", "h245.t140",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_t38fax,
      { "t38fax", "h245.t38fax",
        FT_NONE, BASE_NONE, NULL, 0,
        "Application/t38fax", HFILL }},
    { &hf_h245_t38FaxProtocol,
      { "t38FaxProtocol", "h245.t38FaxProtocol",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_t38FaxProfile,
      { "t38FaxProfile", "h245.t38FaxProfile",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_genericDataCapability,
      { "genericDataCapability", "h245.genericDataCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "Application/genericDataCapability", HFILL }},
    { &hf_h245_v14buffered,
      { "v14buffered", "h245.v14buffered",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/v14buffered", HFILL }},
    { &hf_h245_v42lapm,
      { "v42lapm", "h245.v42lapm",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/v42lapm", HFILL }},
    { &hf_h245_hdlcFrameTunnelling,
      { "hdlcFrameTunnelling", "h245.hdlcFrameTunnelling",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/hdlcFrameTunnelling", HFILL }},
    { &hf_h245_h310SeparateVCStack,
      { "h310SeparateVCStack", "h245.h310SeparateVCStack",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/h310SeparateVCStack", HFILL }},
    { &hf_h245_h310SingleVCStack,
      { "h310SingleVCStack", "h245.h310SingleVCStack",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/h310SingleVCStack", HFILL }},
    { &hf_h245_transparent,
      { "transparent", "h245.transparent",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/transparent", HFILL }},
    { &hf_h245_segmentationAndReassembly,
      { "segmentationAndReassembly", "h245.segmentationAndReassembly",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/segmentationAndReassembly", HFILL }},
    { &hf_h245_hdlcFrameTunnelingwSAR,
      { "hdlcFrameTunnelingwSAR", "h245.hdlcFrameTunnelingwSAR",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/hdlcFrameTunnelingwSAR", HFILL }},
    { &hf_h245_v120,
      { "v120", "h245.v120",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/v120", HFILL }},
    { &hf_h245_separateLANStack,
      { "separateLANStack", "h245.separateLANStack",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/separateLANStack", HFILL }},
    { &hf_h245_v76wCompression,
      { "v76wCompression", "h245.v76wCompression",
        FT_UINT32, BASE_DEC, VALS(h245_T_v76wCompression_vals), 0,
        "DataProtocolCapability/v76wCompression", HFILL }},
    { &hf_h245_transmitCompression,
      { "transmitCompression", "h245.transmitCompression",
        FT_UINT32, BASE_DEC, VALS(h245_CompressionType_vals), 0,
        "DataProtocolCapability/v76wCompression/transmitCompression", HFILL }},
    { &hf_h245_receiveCompression,
      { "receiveCompression", "h245.receiveCompression",
        FT_UINT32, BASE_DEC, VALS(h245_CompressionType_vals), 0,
        "DataProtocolCapability/v76wCompression/receiveCompression", HFILL }},
    { &hf_h245_transmitAndReceiveCompression,
      { "transmitAndReceiveCompression", "h245.transmitAndReceiveCompression",
        FT_UINT32, BASE_DEC, VALS(h245_CompressionType_vals), 0,
        "DataProtocolCapability/v76wCompression/transmitAndReceiveCompression", HFILL }},
    { &hf_h245_tcp,
      { "tcp", "h245.tcp",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/tcp", HFILL }},
    { &hf_h245_udp,
      { "udp", "h245.udp",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataProtocolCapability/udp", HFILL }},
    { &hf_h245_v42bis,
      { "v42bis", "h245.v42bis",
        FT_NONE, BASE_NONE, NULL, 0,
        "CompressionType/v42bis", HFILL }},
    { &hf_h245_numberOfCodewords,
      { "numberOfCodewords", "h245.numberOfCodewords",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V42bis/numberOfCodewords", HFILL }},
    { &hf_h245_maximumStringLength,
      { "maximumStringLength", "h245.maximumStringLength",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V42bis/maximumStringLength", HFILL }},
    { &hf_h245_t84Unrestricted,
      { "t84Unrestricted", "h245.t84Unrestricted",
        FT_NONE, BASE_NONE, NULL, 0,
        "T84Profile/t84Unrestricted", HFILL }},
    { &hf_h245_t84Restricted,
      { "t84Restricted", "h245.t84Restricted",
        FT_NONE, BASE_NONE, NULL, 0,
        "T84Profile/t84Restricted", HFILL }},
    { &hf_h245_qcif_bool,
      { "qcif", "h245.qcif",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/qcif", HFILL }},
    { &hf_h245_cif_bool,
      { "cif", "h245.cif",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/cif", HFILL }},
    { &hf_h245_ccir601Seq,
      { "ccir601Seq", "h245.ccir601Seq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/ccir601Seq", HFILL }},
    { &hf_h245_ccir601Prog,
      { "ccir601Prog", "h245.ccir601Prog",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/ccir601Prog", HFILL }},
    { &hf_h245_hdtvSeq,
      { "hdtvSeq", "h245.hdtvSeq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/hdtvSeq", HFILL }},
    { &hf_h245_hdtvProg,
      { "hdtvProg", "h245.hdtvProg",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/hdtvProg", HFILL }},
    { &hf_h245_g3FacsMH200x100,
      { "g3FacsMH200x100", "h245.g3FacsMH200x100",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/g3FacsMH200x100", HFILL }},
    { &hf_h245_g3FacsMH200x200,
      { "g3FacsMH200x200", "h245.g3FacsMH200x200",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/g3FacsMH200x200", HFILL }},
    { &hf_h245_g4FacsMMR200x100,
      { "g4FacsMMR200x100", "h245.g4FacsMMR200x100",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/g4FacsMMR200x100", HFILL }},
    { &hf_h245_g4FacsMMR200x200,
      { "g4FacsMMR200x200", "h245.g4FacsMMR200x200",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/g4FacsMMR200x200", HFILL }},
    { &hf_h245_jbig200x200Seq,
      { "jbig200x200Seq", "h245.jbig200x200Seq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/jbig200x200Seq", HFILL }},
    { &hf_h245_jbig200x200Prog,
      { "jbig200x200Prog", "h245.jbig200x200Prog",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/jbig200x200Prog", HFILL }},
    { &hf_h245_jbig300x300Seq,
      { "jbig300x300Seq", "h245.jbig300x300Seq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/jbig300x300Seq", HFILL }},
    { &hf_h245_jbig300x300Prog,
      { "jbig300x300Prog", "h245.jbig300x300Prog",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/jbig300x300Prog", HFILL }},
    { &hf_h245_digPhotoLow,
      { "digPhotoLow", "h245.digPhotoLow",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/digPhotoLow", HFILL }},
    { &hf_h245_digPhotoMedSeq,
      { "digPhotoMedSeq", "h245.digPhotoMedSeq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/digPhotoMedSeq", HFILL }},
    { &hf_h245_digPhotoMedProg,
      { "digPhotoMedProg", "h245.digPhotoMedProg",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/digPhotoMedProg", HFILL }},
    { &hf_h245_digPhotoHighSeq,
      { "digPhotoHighSeq", "h245.digPhotoHighSeq",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/digPhotoHighSeq", HFILL }},
    { &hf_h245_digPhotoHighProg,
      { "digPhotoHighProg", "h245.digPhotoHighProg",
        FT_BOOLEAN, 8, NULL, 0,
        "T84Profile/t84Restricted/digPhotoHighProg", HFILL }},
    { &hf_h245_fillBitRemoval,
      { "fillBitRemoval", "h245.fillBitRemoval",
        FT_BOOLEAN, 8, NULL, 0,
        "T38FaxProfile/fillBitRemoval", HFILL }},
    { &hf_h245_transcodingJBIG,
      { "transcodingJBIG", "h245.transcodingJBIG",
        FT_BOOLEAN, 8, NULL, 0,
        "T38FaxProfile/transcodingJBIG", HFILL }},
    { &hf_h245_transcodingMMR,
      { "transcodingMMR", "h245.transcodingMMR",
        FT_BOOLEAN, 8, NULL, 0,
        "T38FaxProfile/transcodingMMR", HFILL }},
    { &hf_h245_version,
      { "version", "h245.version",
        FT_UINT32, BASE_DEC, NULL, 0,
        "T38FaxProfile/version", HFILL }},
    { &hf_h245_t38FaxRateManagement,
      { "t38FaxRateManagement", "h245.t38FaxRateManagement",
        FT_UINT32, BASE_DEC, VALS(h245_T38FaxRateManagement_vals), 0,
        "T38FaxProfile/t38FaxRateManagement", HFILL }},
    { &hf_h245_t38FaxUdpOptions,
      { "t38FaxUdpOptions", "h245.t38FaxUdpOptions",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxProfile/t38FaxUdpOptions", HFILL }},
    { &hf_h245_t38FaxTcpOptions,
      { "t38FaxTcpOptions", "h245.t38FaxTcpOptions",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxProfile/t38FaxTcpOptions", HFILL }},
    { &hf_h245_localTCF,
      { "localTCF", "h245.localTCF",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxRateManagement/localTCF", HFILL }},
    { &hf_h245_transferredTCF,
      { "transferredTCF", "h245.transferredTCF",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxRateManagement/transferredTCF", HFILL }},
    { &hf_h245_t38FaxMaxBuffer,
      { "t38FaxMaxBuffer", "h245.t38FaxMaxBuffer",
        FT_INT32, BASE_DEC, NULL, 0,
        "T38FaxUdpOptions/t38FaxMaxBuffer", HFILL }},
    { &hf_h245_t38FaxMaxDatagram,
      { "t38FaxMaxDatagram", "h245.t38FaxMaxDatagram",
        FT_INT32, BASE_DEC, NULL, 0,
        "T38FaxUdpOptions/t38FaxMaxDatagram", HFILL }},
    { &hf_h245_t38FaxUdpEC,
      { "t38FaxUdpEC", "h245.t38FaxUdpEC",
        FT_UINT32, BASE_DEC, VALS(h245_T_t38FaxUdpEC_vals), 0,
        "T38FaxUdpOptions/t38FaxUdpEC", HFILL }},
    { &hf_h245_t38UDPFEC,
      { "t38UDPFEC", "h245.t38UDPFEC",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxUdpOptions/t38FaxUdpEC/t38UDPFEC", HFILL }},
    { &hf_h245_t38UDPRedundancy,
      { "t38UDPRedundancy", "h245.t38UDPRedundancy",
        FT_NONE, BASE_NONE, NULL, 0,
        "T38FaxUdpOptions/t38FaxUdpEC/t38UDPRedundancy", HFILL }},
    { &hf_h245_t38TCPBidirectionalMode,
      { "t38TCPBidirectionalMode", "h245.t38TCPBidirectionalMode",
        FT_BOOLEAN, 8, NULL, 0,
        "T38FaxTcpOptions/t38TCPBidirectionalMode", HFILL }},
    { &hf_h245_nlpidProtocol,
      { "nlpidProtocol", "h245.nlpidProtocol",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "Nlpid/nlpidProtocol", HFILL }},
    { &hf_h245_nlpidData,
      { "nlpidData", "h245.nlpidData",
        FT_BYTES, BASE_HEX, NULL, 0,
        "Nlpid/nlpidData", HFILL }},
    { &hf_h245_encryptionCapability,
      { "encryptionCapability", "h245.encryptionCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "EncryptionAuthenticationAndIntegrity/encryptionCapability", HFILL }},
    { &hf_h245_authenticationCapability,
      { "authenticationCapability", "h245.authenticationCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "EncryptionAuthenticationAndIntegrity/authenticationCapability", HFILL }},
    { &hf_h245_integrityCapability,
      { "integrityCapability", "h245.integrityCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "EncryptionAuthenticationAndIntegrity/integrityCapability", HFILL }},
    { &hf_h245_EncryptionCapability_item,
      { "Item", "h245.EncryptionCapability_item",
        FT_UINT32, BASE_DEC, VALS(h245_MediaEncryptionAlgorithm_vals), 0,
        "EncryptionCapability/_item", HFILL }},
    { &hf_h245_algorithm,
      { "algorithm", "h245.algorithm",
        FT_STRING, BASE_NONE, NULL, 0,
        "MediaEncryptionAlgorithm/algorithm", HFILL }},
    { &hf_h245_antiSpamAlgorithm,
      { "antiSpamAlgorithm", "h245.antiSpamAlgorithm",
        FT_STRING, BASE_NONE, NULL, 0,
        "AuthenticationCapability/antiSpamAlgorithm", HFILL }},
    { &hf_h245_ui_nonStandard,
      { "nonStandard", "h245.nonStandard",
        FT_NONE, BASE_NONE, NULL, 0,
        "UserInputCapability/nonStandard", HFILL }},
    { &hf_h245_nonStandard_item,
      { "Item", "h245.nonStandard_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_basicString,
      { "basicString", "h245.basicString",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_iA5String,
      { "iA5String", "h245.iA5String",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_generalString,
      { "generalString", "h245.generalString",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_dtmf,
      { "dtmf", "h245.dtmf",
        FT_NONE, BASE_NONE, NULL, 0,
        "UserInputCapability/dtmf", HFILL }},
    { &hf_h245_hookflash,
      { "hookflash", "h245.hookflash",
        FT_NONE, BASE_NONE, NULL, 0,
        "UserInputCapability/hookflash", HFILL }},
    { &hf_h245_extendedAlphanumericFlag,
      { "extendedAlphanumeric", "h245.extendedAlphanumeric",
        FT_NONE, BASE_NONE, NULL, 0,
        "UserInputCapability/extendedAlphanumeric", HFILL }},
    { &hf_h245_encryptedBasicString,
      { "encryptedBasicString", "h245.encryptedBasicString",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_encryptedIA5String,
      { "encryptedIA5String", "h245.encryptedIA5String",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_encryptedGeneralString,
      { "encryptedGeneralString", "h245.encryptedGeneralString",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_secureDTMF,
      { "secureDTMF", "h245.secureDTMF",
        FT_NONE, BASE_NONE, NULL, 0,
        "UserInputCapability/secureDTMF", HFILL }},
    { &hf_h245_nonStandardParams,
      { "nonStandardData", "h245.nonStandardData",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_nonStandardData_item,
      { "Item", "h245.nonStandardData_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ConferenceCapability/nonStandardData/_item", HFILL }},
    { &hf_h245_chairControlCapability,
      { "chairControlCapability", "h245.chairControlCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "ConferenceCapability/chairControlCapability", HFILL }},
    { &hf_h245_videoIndicateMixingCapability,
      { "videoIndicateMixingCapability", "h245.videoIndicateMixingCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "ConferenceCapability/videoIndicateMixingCapability", HFILL }},
    { &hf_h245_multipointVisualizationCapability,
      { "multipointVisualizationCapability", "h245.multipointVisualizationCapability",
        FT_BOOLEAN, 8, NULL, 0,
        "ConferenceCapability/multipointVisualizationCapability", HFILL }},
    { &hf_h245_capabilityIdentifier,
      { "capabilityIdentifier", "h245.capabilityIdentifier",
        FT_UINT32, BASE_DEC, VALS(h245_CapabilityIdentifier_vals), 0,
        "GenericCapability/capabilityIdentifier", HFILL }},
    { &hf_h245_collapsing,
      { "collapsing", "h245.collapsing",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericCapability/collapsing", HFILL }},
    { &hf_h245_collapsing_item,
      { "Item", "h245.collapsing_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericCapability/collapsing/_item", HFILL }},
    { &hf_h245_nonCollapsing,
      { "nonCollapsing", "h245.nonCollapsing",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericCapability/nonCollapsing", HFILL }},
    { &hf_h245_nonCollapsing_item,
      { "Item", "h245.nonCollapsing_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericCapability/nonCollapsing/_item", HFILL }},
    { &hf_h245_nonCollapsingRaw,
      { "nonCollapsingRaw", "h245.nonCollapsingRaw",
        FT_BYTES, BASE_HEX, NULL, 0,
        "GenericCapability/nonCollapsingRaw", HFILL }},
    { &hf_h245_transport,
      { "transport", "h245.transport",
        FT_UINT32, BASE_DEC, VALS(DataProtocolCapability_vals), 0,
        "GenericCapability/transport", HFILL }},
    { &hf_h245_standardOid,
      { "standard", "h245.standard",
        FT_STRING, BASE_NONE, NULL, 0,
        "CapabilityIdentifier/standard", HFILL }},
    { &hf_h245_h221NonStandard,
      { "h221NonStandard", "h245.h221NonStandard",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_uuid,
      { "uuid", "h245.uuid",
        FT_BYTES, BASE_HEX, NULL, 0,
        "", HFILL }},
    { &hf_h245_domainBased,
      { "domainBased", "h245.domainBased",
        FT_STRING, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_parameterIdentifier,
      { "parameterIdentifier", "h245.parameterIdentifier",
        FT_UINT32, BASE_DEC, VALS(h245_ParameterIdentifier_vals), 0,
        "GenericParameter/parameterIdentifier", HFILL }},
    { &hf_h245_parameterValue,
      { "parameterValue", "h245.parameterValue",
        FT_UINT32, BASE_DEC, VALS(h245_ParameterValue_vals), 0,
        "GenericParameter/parameterValue", HFILL }},
    { &hf_h245_supersedes,
      { "supersedes", "h245.supersedes",
        FT_NONE, BASE_NONE, NULL, 0,
        "GenericParameter/supersedes", HFILL }},
    { &hf_h245_supersedes_item,
      { "Item", "h245.supersedes_item",
        FT_UINT32, BASE_DEC, VALS(h245_ParameterIdentifier_vals), 0,
        "GenericParameter/supersedes/_item", HFILL }},
    { &hf_h245_standard,
      { "standard", "h245.standard",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterIdentifier/standard", HFILL }},
    { &hf_h245_logical,
      { "logical", "h245.logical",
        FT_NONE, BASE_NONE, NULL, 0,
        "ParameterValue/logical", HFILL }},
    { &hf_h245_booleanArray,
      { "booleanArray", "h245.booleanArray",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterValue/booleanArray", HFILL }},
    { &hf_h245_unsignedMin,
      { "unsignedMin", "h245.unsignedMin",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterValue/unsignedMin", HFILL }},
    { &hf_h245_unsignedMax,
      { "unsignedMax", "h245.unsignedMax",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterValue/unsignedMax", HFILL }},
    { &hf_h245_unsigned32Min,
      { "unsigned32Min", "h245.unsigned32Min",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterValue/unsigned32Min", HFILL }},
    { &hf_h245_unsigned32Max,
      { "unsigned32Max", "h245.unsigned32Max",
        FT_UINT32, BASE_DEC, NULL, 0,
        "ParameterValue/unsigned32Max", HFILL }},
    { &hf_h245_octetString,
      { "octetString", "h245.octetString",
        FT_BYTES, BASE_HEX, NULL, 0,
        "ParameterValue/octetString", HFILL }},
    { &hf_h245_genericParameter,
      { "genericParameter", "h245.genericParameter",
        FT_NONE, BASE_NONE, NULL, 0,
        "ParameterValue/genericParameter", HFILL }},
    { &hf_h245_genericParameter_item,
      { "Item", "h245.genericParameter_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ParameterValue/genericParameter/_item", HFILL }},
    { &hf_h245_multiplexFormat,
      { "multiplexFormat", "h245.multiplexFormat",
        FT_UINT32, BASE_DEC, VALS(h245_MultiplexFormat_vals), 0,
        "", HFILL }},
    { &hf_h245_controlOnMuxStream,
      { "controlOnMuxStream", "h245.controlOnMuxStream",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_capabilityOnMuxStream,
      { "capabilityOnMuxStream", "h245.capabilityOnMuxStream",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexedStreamCapability/capabilityOnMuxStream", HFILL }},
    { &hf_h245_capabilityOnMuxStream_item,
      { "Item", "h245.capabilityOnMuxStream_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexedStreamCapability/capabilityOnMuxStream/_item", HFILL }},
    { &hf_h245_dynamicRTPPayloadType,
      { "dynamicRTPPayloadType", "h245.dynamicRTPPayloadType",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_audioTelephoneEvent,
      { "audioTelephoneEvent", "h245.audioTelephoneEvent",
        FT_STRING, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_capabilities,
      { "capabilities", "h245.capabilities",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplePayloadStreamCapability/capabilities", HFILL }},
    { &hf_h245_capabilities_item,
      { "Item", "h245.capabilities_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplePayloadStreamCapability/capabilities/_item", HFILL }},
    { &hf_h245_fecc_rfc2733,
      { "rfc2733", "h245.rfc2733",
        FT_NONE, BASE_NONE, NULL, 0,
        "FECCapability/rfc2733", HFILL }},
    { &hf_h245_redundancyEncodingBool,
      { "redundancyEncoding", "h245.redundancyEncoding",
        FT_BOOLEAN, 8, NULL, 0,
        "FECCapability/rfc2733/redundancyEncoding", HFILL }},
    { &hf_h245_separateStreamBool,
      { "separateStream", "h245.separateStream",
        FT_NONE, BASE_NONE, NULL, 0,
        "FECCapability/rfc2733/separateStream", HFILL }},
    { &hf_h245_separatePort,
      { "separatePort", "h245.separatePort",
        FT_BOOLEAN, 8, NULL, 0,
        "FECCapability/rfc2733/separateStream/separatePort", HFILL }},
    { &hf_h245_samePortBool,
      { "samePort", "h245.samePort",
        FT_BOOLEAN, 8, NULL, 0,
        "FECCapability/rfc2733/separateStream/samePort", HFILL }},
    { &hf_h245_forwardLogicalChannelNumber,
      { "forwardLogicalChannelNumber", "h245.forwardLogicalChannelNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_forwardLogicalChannelParameters,
      { "forwardLogicalChannelParameters", "h245.forwardLogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannel/forwardLogicalChannelParameters", HFILL }},
    { &hf_h245_portNumber,
      { "portNumber", "h245.portNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_dataType,
      { "dataType", "h245.dataType",
        FT_UINT32, BASE_DEC, VALS(h245_DataType_vals), 0,
        "", HFILL }},
    { &hf_h245_olc_forw_multiplexParameters,
      { "multiplexParameters", "h245.multiplexParameters",
        FT_UINT32, BASE_DEC, VALS(h245_OLC_forw_multiplexParameters_vals), 0,
        "OpenLogicalChannel/forwardLogicalChannelParameters/multiplexParameters", HFILL }},
    { &hf_h245_h222LogicalChannelParameters,
      { "h222LogicalChannelParameters", "h245.h222LogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_h223LogicalChannelParameters,
      { "h223LogicalChannelParameters", "h245.h223LogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_v76LogicalChannelParameters,
      { "v76LogicalChannelParameters", "h245.v76LogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_h2250LogicalChannelParameters,
      { "h2250LogicalChannelParameters", "h245.h2250LogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_forwardLogicalChannelDependency,
      { "forwardLogicalChannelDependency", "h245.forwardLogicalChannelDependency",
        FT_UINT32, BASE_DEC, NULL, 0,
        "OpenLogicalChannel/forwardLogicalChannelParameters/forwardLogicalChannelDependency", HFILL }},
    { &hf_h245_replacementFor,
      { "replacementFor", "h245.replacementFor",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_reverseLogicalChannelParameters,
      { "reverseLogicalChannelParameters", "h245.reverseLogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannel/reverseLogicalChannelParameters", HFILL }},
    { &hf_h245_olc_rev_multiplexParameter,
      { "multiplexParameters", "h245.multiplexParameters",
        FT_UINT32, BASE_DEC, VALS(h245_OLC_rev_multiplexParameters_vals), 0,
        "OpenLogicalChannel/reverseLogicalChannelParameters/multiplexParameters", HFILL }},
    { &hf_h245_reverseLogicalChannelDependency,
      { "reverseLogicalChannelDependency", "h245.reverseLogicalChannelDependency",
        FT_UINT32, BASE_DEC, NULL, 0,
        "OpenLogicalChannel/reverseLogicalChannelParameters/reverseLogicalChannelDependency", HFILL }},
    { &hf_h245_separateStack,
      { "separateStack", "h245.separateStack",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_encryptionSync,
      { "encryptionSync", "h245.encryptionSync",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_distribution,
      { "distribution", "h245.distribution",
        FT_UINT32, BASE_DEC, VALS(h245_T_distribution_vals), 0,
        "NetworkAccessParameters/distribution", HFILL }},
    { &hf_h245_unicast,
      { "unicast", "h245.unicast",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/distribution/unicast", HFILL }},
    { &hf_h245_multicast,
      { "multicast", "h245.multicast",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/distribution/multicast", HFILL }},
    { &hf_h245_networkAddress,
      { "networkAddress", "h245.networkAddress",
        FT_UINT32, BASE_DEC, VALS(h245_T_networkAddress_vals), 0,
        "NetworkAccessParameters/networkAddress", HFILL }},
    { &hf_h245_q2931Address,
      { "q2931Address", "h245.q2931Address",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/networkAddress/q2931Address", HFILL }},
    { &hf_h245_e164Address,
      { "e164Address", "h245.e164Address",
        FT_STRING, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/networkAddress/e164Address", HFILL }},
    { &hf_h245_localAreaAddress,
      { "localAreaAddress", "h245.localAreaAddress",
        FT_UINT32, BASE_DEC, VALS(h245_TransportAddress_vals), 0,
        "NetworkAccessParameters/networkAddress/localAreaAddress", HFILL }},
    { &hf_h245_associateConference,
      { "associateConference", "h245.associateConference",
        FT_BOOLEAN, 8, NULL, 0,
        "NetworkAccessParameters/associateConference", HFILL }},
    { &hf_h245_externalReference,
      { "externalReference", "h245.externalReference",
        FT_BYTES, BASE_HEX, NULL, 0,
        "NetworkAccessParameters/externalReference", HFILL }},
    { &hf_h245_t120SetupProcedure,
      { "t120SetupProcedure", "h245.t120SetupProcedure",
        FT_UINT32, BASE_DEC, VALS(h245_T_t120SetupProcedure_vals), 0,
        "NetworkAccessParameters/t120SetupProcedure", HFILL }},
    { &hf_h245_originateCall,
      { "originateCall", "h245.originateCall",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/t120SetupProcedure/originateCall", HFILL }},
    { &hf_h245_waitForCall,
      { "waitForCall", "h245.waitForCall",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/t120SetupProcedure/waitForCall", HFILL }},
    { &hf_h245_issueQuery,
      { "issueQuery", "h245.issueQuery",
        FT_NONE, BASE_NONE, NULL, 0,
        "NetworkAccessParameters/t120SetupProcedure/issueQuery", HFILL }},
    { &hf_h245_address,
      { "address", "h245.address",
        FT_UINT32, BASE_DEC, VALS(h245_T_address_vals), 0,
        "Q2931Address/address", HFILL }},
    { &hf_h245_internationalNumber,
      { "internationalNumber", "h245.internationalNumber",
        FT_STRING, BASE_NONE, NULL, 0,
        "Q2931Address/address/internationalNumber", HFILL }},
    { &hf_h245_nsapAddress,
      { "nsapAddress", "h245.nsapAddress",
        FT_BYTES, BASE_HEX, NULL, 0,
        "Q2931Address/address/nsapAddress", HFILL }},
    { &hf_h245_subaddress,
      { "subaddress", "h245.subaddress",
        FT_BYTES, BASE_HEX, NULL, 0,
        "Q2931Address/subaddress", HFILL }},
    { &hf_h245_audioHeaderPresent,
      { "audioHeaderPresent", "h245.audioHeaderPresent",
        FT_BOOLEAN, 8, NULL, 0,
        "V75Parameters/audioHeaderPresent", HFILL }},
    { &hf_h245_nullData,
      { "nullData", "h245.nullData",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataType/nullData", HFILL }},
    { &hf_h245_videoData,
      { "videoData", "h245.videoData",
        FT_UINT32, BASE_DEC, VALS(h245_VideoCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_audioData,
      { "audioData", "h245.audioData",
        FT_UINT32, BASE_DEC, VALS(h245_AudioCapability_vals), 0,
        "", HFILL }},
    { &hf_h245_data,
      { "data", "h245.data",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_encryptionData,
      { "encryptionData", "h245.encryptionData",
        FT_UINT32, BASE_DEC, VALS(h245_EncryptionMode_vals), 0,
        "DataType/encryptionData", HFILL }},
    { &hf_h245_h235Control,
      { "h235Control", "h245.h235Control",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataType/h235Control", HFILL }},
    { &hf_h245_h235Media,
      { "h235Media", "h245.h235Media",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataType/h235Media", HFILL }},
    { &hf_h245_multiplexedStream,
      { "multiplexedStream", "h245.multiplexedStream",
        FT_NONE, BASE_NONE, NULL, 0,
        "DataType/multiplexedStream", HFILL }},
    { &hf_h245_redundancyEncoding,
      { "redundancyEncoding", "h245.redundancyEncoding",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_multiplePayloadStream,
      { "multiplePayloadStream", "h245.multiplePayloadStream",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_fec,
      { "fec", "h245.fec",
        FT_UINT32, BASE_DEC, VALS(h245_FECData_vals), 0,
        "", HFILL }},
    { &hf_h245_mediaType,
      { "mediaType", "h245.mediaType",
        FT_UINT32, BASE_DEC, VALS(h245_T_mediaType_vals), 0,
        "H235Media/mediaType", HFILL }},
    { &hf_h245_resourceID,
      { "resourceID", "h245.resourceID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_subChannelID,
      { "subChannelID", "h245.subChannelID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H222LogicalChannelParameters/subChannelID", HFILL }},
    { &hf_h245_pcr_pid,
      { "pcr-pid", "h245.pcr_pid",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H222LogicalChannelParameters/pcr-pid", HFILL }},
    { &hf_h245_programDescriptors,
      { "programDescriptors", "h245.programDescriptors",
        FT_BYTES, BASE_HEX, NULL, 0,
        "H222LogicalChannelParameters/programDescriptors", HFILL }},
    { &hf_h245_streamDescriptors,
      { "streamDescriptors", "h245.streamDescriptors",
        FT_BYTES, BASE_HEX, NULL, 0,
        "H222LogicalChannelParameters/streamDescriptors", HFILL }},
    { &hf_h245_adaptationLayerType,
      { "adaptationLayerType", "h245.adaptationLayerType",
        FT_UINT32, BASE_DEC, VALS(h245_T_adaptationLayerType_vals), 0,
        "H223LogicalChannelParameters/adaptationLayerType", HFILL }},
    { &hf_h245_al1Framed,
      { "al1Framed", "h245.al1Framed",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al1NotFramed,
      { "al1NotFramed", "h245.al1NotFramed",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al2WithoutSequenceNumbers,
      { "al2WithoutSequenceNumbers", "h245.al2WithoutSequenceNumbers",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al2WithSequenceNumbers,
      { "al2WithSequenceNumbers", "h245.al2WithSequenceNumbers",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al3,
      { "al3", "h245.al3",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al1M,
      { "al1M", "h245.al1M",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al2M,
      { "al2M", "h245.al2M",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_al3M,
      { "al3M", "h245.al3M",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_segmentableFlag,
      { "segmentableFlag", "h245.segmentableFlag",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_controlFieldOctets,
      { "controlFieldOctets", "h245.controlFieldOctets",
        FT_UINT32, BASE_DEC, NULL, 0,
        "Al3/controlFieldOctets", HFILL }},
    { &hf_h245_sendBufferSize,
      { "sendBufferSize", "h245.sendBufferSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_transferMode,
      { "transferMode", "h245.transferMode",
        FT_UINT32, BASE_DEC, VALS(h245_T_transferMode_vals), 0,
        "H223AL1MParameters/transferMode", HFILL }},
    { &hf_h245_framed,
      { "framed", "h245.framed",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223AL1MParameters/transferMode/framed", HFILL }},
    { &hf_h245_unframed,
      { "unframed", "h245.unframed",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223AL1MParameters/transferMode/unframed", HFILL }},
    { &hf_h245_AL1HeaderFEC,
      { "headerFEC", "h245.headerFEC",
        FT_UINT32, BASE_DEC, VALS(h245_AL1HeaderFEC_vals), 0,
        "H223AL1MParameters/headerFEC", HFILL }},
    { &hf_h245_sebch16_7,
      { "sebch16-7", "h245.sebch16_7",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_golay24_12,
      { "golay24-12", "h245.golay24_12",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crcLength2,
      { "crcLength", "h245.crcLength",
        FT_UINT32, BASE_DEC, VALS(h245_AL1CrcLength_vals), 0,
        "H223AL1MParameters/crcLength", HFILL }},
    { &hf_h245_crc4bit,
      { "crc4bit", "h245.crc4bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc12bit,
      { "crc12bit", "h245.crc12bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc20bit,
      { "crc20bit", "h245.crc20bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc28bit,
      { "crc28bit", "h245.crc28bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc8bit,
      { "crc8bit", "h245.crc8bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc16bit,
      { "crc16bit", "h245.crc16bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crc32bit,
      { "crc32bit", "h245.crc32bit",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_crcNotUsed,
      { "crcNotUsed", "h245.crcNotUsed",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_rcpcCodeRate,
      { "rcpcCodeRate", "h245.rcpcCodeRate",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_arqType,
      { "arqType", "h245.arqType",
        FT_UINT32, BASE_DEC, VALS(h245_ArqType_vals), 0,
        "", HFILL }},
    { &hf_h245_alsduSplitting,
      { "alsduSplitting", "h245.alsduSplitting",
        FT_BOOLEAN, 8, NULL, 0,
        "H223AL1MParameters/alsduSplitting", HFILL }},
    { &hf_h245_rsCodeCorrection,
      { "rsCodeCorrection", "h245.rsCodeCorrection",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_noArq,
      { "noArq", "h245.noArq",
        FT_NONE, BASE_NONE, NULL, 0,
        "ArqType/noArq", HFILL }},
    { &hf_h245_typeIArq,
      { "typeIArq", "h245.typeIArq",
        FT_NONE, BASE_NONE, NULL, 0,
        "ArqType/typeIArq", HFILL }},
    { &hf_h245_typeIIArq,
      { "typeIIArq", "h245.typeIIArq",
        FT_NONE, BASE_NONE, NULL, 0,
        "ArqType/typeIIArq", HFILL }},
    { &hf_h245_AL2HeaderFEC,
      { "headerFEC", "h245.headerFEC",
        FT_UINT32, BASE_DEC, VALS(h245_AL2HeaderFEC_vals), 0,
        "H223AL2MParameters/headerFEC", HFILL }},
    { &hf_h245_sebch16_5,
      { "sebch16-5", "h245.sebch16_5",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223AL2MParameters/headerFEC/sebch16-5", HFILL }},
    { &hf_h245_headerFormat,
      { "headerFormat", "h245.headerFormat",
        FT_UINT32, BASE_DEC, VALS(h245_T_headerFormat_vals), 0,
        "H223AL3MParameters/headerFormat", HFILL }},
    { &hf_h245_crlength2,
      { "crcLength", "h245.crcLength",
        FT_UINT32, BASE_DEC, VALS(h245_AL3CrcLength_vals), 0,
        "H223AL3MParameters/crcLength", HFILL }},
    { &hf_h245_numberOfRetransmissions,
      { "numberOfRetransmissions", "h245.numberOfRetransmissions",
        FT_UINT32, BASE_DEC, VALS(h245_T_numberOfRetransmissions_vals), 0,
        "H223AnnexCArqParameters/numberOfRetransmissions", HFILL }},
    { &hf_h245_finite,
      { "finite", "h245.finite",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H223AnnexCArqParameters/numberOfRetransmissions/finite", HFILL }},
    { &hf_h245_infinite,
      { "infinite", "h245.infinite",
        FT_NONE, BASE_NONE, NULL, 0,
        "H223AnnexCArqParameters/numberOfRetransmissions/infinite", HFILL }},
    { &hf_h245_hdlcParameters,
      { "hdlcParameters", "h245.hdlcParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/hdlcParameters", HFILL }},
    { &hf_h245_suspendResume,
      { "suspendResume", "h245.suspendResume",
        FT_UINT32, BASE_DEC, VALS(h245_T_suspendResume_vals), 0,
        "V76LogicalChannelParameters/suspendResume", HFILL }},
    { &hf_h245_noSuspendResume,
      { "noSuspendResume", "h245.noSuspendResume",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/suspendResume/noSuspendResume", HFILL }},
    { &hf_h245_suspendResumewAddress,
      { "suspendResumewAddress", "h245.suspendResumewAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_suspendResumewoAddress,
      { "suspendResumewoAddress", "h245.suspendResumewoAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_uIH,
      { "uIH", "h245.uIH",
        FT_BOOLEAN, 8, NULL, 0,
        "V76LogicalChannelParameters/uIH", HFILL }},
    { &hf_h245_v76_mode,
      { "mode", "h245.mode",
        FT_UINT32, BASE_DEC, VALS(h245_V76LCP_mode_vals), 0,
        "V76LogicalChannelParameters/mode", HFILL }},
    { &hf_h245_eRM,
      { "eRM", "h245.eRM",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/mode/eRM", HFILL }},
    { &hf_h245_windowSize,
      { "windowSize", "h245.windowSize",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V76LogicalChannelParameters/mode/eRM/windowSize", HFILL }},
    { &hf_h245_recovery,
      { "recovery", "h245.recovery",
        FT_UINT32, BASE_DEC, VALS(h245_T_recovery_vals), 0,
        "V76LogicalChannelParameters/mode/eRM/recovery", HFILL }},
    { &hf_h245_rej,
      { "rej", "h245.rej",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/mode/eRM/recovery/rej", HFILL }},
    { &hf_h245_sREJ,
      { "sREJ", "h245.sREJ",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/mode/eRM/recovery/sREJ", HFILL }},
    { &hf_h245_mSREJ,
      { "mSREJ", "h245.mSREJ",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/mode/eRM/recovery/mSREJ", HFILL }},
    { &hf_h245_uNERM,
      { "uNERM", "h245.uNERM",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/mode/uNERM", HFILL }},
    { &hf_h245_v75Parameters,
      { "v75Parameters", "h245.v75Parameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "V76LogicalChannelParameters/v75Parameters", HFILL }},
    { &hf_h245_crcLength,
      { "crcLength", "h245.crcLength",
        FT_UINT32, BASE_DEC, VALS(h245_CRCLength_vals), 0,
        "V76HDLCParameters/crcLength", HFILL }},
    { &hf_h245_n401,
      { "n401", "h245.n401",
        FT_UINT32, BASE_DEC, NULL, 0,
        "V76HDLCParameters/n401", HFILL }},
    { &hf_h245_loopbackTestProcedure,
      { "loopbackTestProcedure", "h245.loopbackTestProcedure",
        FT_BOOLEAN, 8, NULL, 0,
        "V76HDLCParameters/loopbackTestProcedure", HFILL }},
    { &hf_h245_sessionID_0_255,
      { "sessionID", "h245.sessionID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "H2250LogicalChannelParameters/sessionID", HFILL }},
    { &hf_h245_associatedSessionID,
      { "associatedSessionID", "h245.associatedSessionID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_mediaChannel,
      { "mediaChannel", "h245.mediaChannel",
        FT_UINT32, BASE_DEC, VALS(h245_TransportAddress_vals), 0,
        "H2250LogicalChannelParameters/mediaChannel", HFILL }},
    { &hf_h245_mediaGuaranteedDelivery,
      { "mediaGuaranteedDelivery", "h245.mediaGuaranteedDelivery",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_mediaControlChannel,
      { "mediaControlChannel", "h245.mediaControlChannel",
        FT_UINT32, BASE_DEC, VALS(h245_TransportAddress_vals), 0,
        "H2250LogicalChannelParameters/mediaControlChannel", HFILL }},
    { &hf_h245_mediaControlGuaranteedDelivery,
      { "mediaControlGuaranteedDelivery", "h245.mediaControlGuaranteedDelivery",
        FT_BOOLEAN, 8, NULL, 0,
        "", HFILL }},
    { &hf_h245_destination,
      { "destination", "h245.destination",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_mediaPacketization,
      { "mediaPacketization", "h245.mediaPacketization",
        FT_UINT32, BASE_DEC, VALS(h245_T_mediaPacketization_vals), 0,
        "H2250LogicalChannelParameters/mediaPacketization", HFILL }},
    { &hf_h245_h261aVideoPacketizationFlag,
      { "h261aVideoPacketization", "h245.h261aVideoPacketization",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250LogicalChannelParameters/mediaPacketization/h261aVideoPacketization", HFILL }},
    { &hf_h245_rtpPayloadType,
      { "rtpPayloadType", "h245.rtpPayloadType",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250LogicalChannelParameters/mediaPacketization/rtpPayloadType", HFILL }},
    { &hf_h245_source,
      { "source", "h245.source",
        FT_NONE, BASE_NONE, NULL, 0,
        "H2250LogicalChannelParameters/source", HFILL }},
    { &hf_h245_payloadDescriptor,
      { "payloadDescriptor", "h245.payloadDescriptor",
        FT_UINT32, BASE_DEC, VALS(h245_T_payloadDescriptor_vals), 0,
        "RTPPayloadType/payloadDescriptor", HFILL }},
    { &hf_h245_rfc_number,
      { "rfc-number", "h245.rfc_number",
        FT_UINT32, BASE_DEC, VALS(h245_RFC_number_vals), 0,
        "RTPPayloadType/payloadDescriptor/rfc-number", HFILL }},
    { &hf_h245_oid,
      { "oid", "h245.oid",
        FT_STRING, BASE_NONE, NULL, 0,
        "RTPPayloadType/payloadDescriptor/oid", HFILL }},
    { &hf_h245_payloadType,
      { "payloadType", "h245.payloadType",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_secondaryEncoding3,
      { "secondaryEncoding3", "h245.secondaryEncoding3",
        FT_UINT32, BASE_DEC, VALS(h245_DataType_vals), 0,
        "RedundancyEncoding/secondaryEncoding3", HFILL }},
    { &hf_h245_rtpRedundancyEncoding,
      { "rtpRedundancyEncoding", "h245.rtpRedundancyEncoding",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncoding/rtpRedundancyEncoding", HFILL }},
    { &hf_h245_primary,
      { "primary", "h245.primary",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncoding/rtpRedundancyEncoding/primary", HFILL }},
    { &hf_h245_secondary,
      { "secondary", "h245.secondary",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncoding/rtpRedundancyEncoding/secondary", HFILL }},
    { &hf_h245_secondary_item,
      { "Item", "h245.secondary_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "RedundancyEncoding/rtpRedundancyEncoding/secondary/_item", HFILL }},
    { &hf_h245_elements,
      { "elements", "h245.elements",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplePayloadStream/elements", HFILL }},
    { &hf_h245_elements_item,
      { "Item", "h245.elements_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplePayloadStream/elements/_item", HFILL }},
    { &hf_h245_rfc2733,
      { "rfc2733", "h245.rfc2733",
        FT_NONE, BASE_NONE, NULL, 0,
        "FECData/rfc2733", HFILL }},
    { &hf_h245_fec_data_mode,
      { "mode", "h245.mode",
        FT_UINT32, BASE_DEC, VALS(h245_FECdata_mode_vals), 0,
        "FECData/rfc2733/mode", HFILL }},
    { &hf_h245_redundancyEncodingFlag,
      { "redundancyEncoding", "h245.redundancyEncoding",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_separateStream,
      { "separateStream", "h245.separateStream",
        FT_UINT32, BASE_DEC, VALS(h245_SeparateStream_vals), 0,
        "", HFILL }},
    { &hf_h245_differentPort,
      { "differentPort", "h245.differentPort",
        FT_NONE, BASE_NONE, NULL, 0,
        "SeparateStream/differentPort", HFILL }},
    { &hf_h245_protectedSessionID,
      { "protectedSessionID", "h245.protectedSessionID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SeparateStream/differentPort/protectedSessionID", HFILL }},
    { &hf_h245_protectedPayloadType,
      { "protectedPayloadType", "h245.protectedPayloadType",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_samePort,
      { "samePort", "h245.samePort",
        FT_NONE, BASE_NONE, NULL, 0,
        "SeparateStream/samePort", HFILL }},
    { &hf_h245_unicastAddress,
      { "unicastAddress", "h245.unicastAddress",
        FT_UINT32, BASE_DEC, VALS(h245_UnicastAddress_vals), 0,
        "TransportAddress/unicastAddress", HFILL }},
    { &hf_h245_multicastAddress,
      { "multicastAddress", "h245.multicastAddress",
        FT_UINT32, BASE_DEC, VALS(h245_MulticastAddress_vals), 0,
        "TransportAddress/multicastAddress", HFILL }},
    { &hf_h245_iPAddress,
      { "iPAddress", "h245.iPAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPAddress", HFILL }},
    { &hf_h245_ip4_network,
      { "network", "h245.network",
        FT_IPv4, BASE_NONE, NULL, 0,
        "UnicastAddress/iPAddress/network", HFILL }},
    { &hf_h245_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "UnicastAddress/iPAddress/tsapIdentifier", HFILL }},
    { &hf_h245_iPXAddress,
      { "iPXAddress", "h245.iPXAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPXAddress", HFILL }},
    { &hf_h245_node,
      { "node", "h245.node",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/iPXAddress/node", HFILL }},
    { &hf_h245_netnum,
      { "netnum", "h245.netnum",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/iPXAddress/netnum", HFILL }},
    { &hf_h245_ipx_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/iPXAddress/tsapIdentifier", HFILL }},
    { &hf_h245_iP6Address,
      { "iP6Address", "h245.iP6Address",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iP6Address", HFILL }},
    { &hf_h245_ip6_network,
      { "network", "h245.network",
        FT_IPv6, BASE_NONE, NULL, 0,
        "UnicastAddress/iP6Address/network", HFILL }},
    { &hf_h245_ipv6_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "UnicastAddress/iP6Address/tsapIdentifier", HFILL }},
    { &hf_h245_netBios,
      { "netBios", "h245.netBios",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/netBios", HFILL }},
    { &hf_h245_iPSourceRouteAddress,
      { "iPSourceRouteAddress", "h245.iPSourceRouteAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress", HFILL }},
    { &hf_h245_routing,
      { "routing", "h245.routing",
        FT_UINT32, BASE_DEC, VALS(h245_T_routing_vals), 0,
        "UnicastAddress/iPSourceRouteAddress/routing", HFILL }},
    { &hf_h245_strict,
      { "strict", "h245.strict",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/routing/strict", HFILL }},
    { &hf_h245_loose,
      { "loose", "h245.loose",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/routing/loose", HFILL }},
    { &hf_h245_network,
      { "network", "h245.network",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/network", HFILL }},
    { &hf_h245_iPSrcRoute_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/tsapIdentifier", HFILL }},
    { &hf_h245_route,
      { "route", "h245.route",
        FT_NONE, BASE_NONE, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/route", HFILL }},
    { &hf_h245_route_item,
      { "Item", "h245.route_item",
        FT_BYTES, BASE_HEX, NULL, 0,
        "UnicastAddress/iPSourceRouteAddress/route/_item", HFILL }},
    { &hf_h245_nsap,
      { "nsap", "h245.nsap",
        FT_BYTES, BASE_HEX, NULL, 0,
        "", HFILL }},
    { &hf_h245_nonStandardAddress,
      { "nonStandardAddress", "h245.nonStandardAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_mIPAddress,
      { "iPAddress", "h245.iPAddress",
        FT_NONE, BASE_NONE, NULL, 0,
        "MulticastAddress/iPAddress", HFILL }},
    { &hf_h245_mip4_network,
      { "network", "h245.network",
        FT_IPv4, BASE_NONE, NULL, 0,
        "MulticastAddress/iPAddress/network", HFILL }},
    { &hf_h245_multicast_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MulticastAddress/iPAddress/tsapIdentifier", HFILL }},
    { &hf_h245_mIP6Address,
      { "iP6Address", "h245.iP6Address",
        FT_NONE, BASE_NONE, NULL, 0,
        "MulticastAddress/iP6Address", HFILL }},
    { &hf_h245_mip6_network,
      { "network", "h245.network",
        FT_IPv6, BASE_NONE, NULL, 0,
        "MulticastAddress/iP6Address/network", HFILL }},
    { &hf_h245_multicast_IPv6_tsapIdentifier,
      { "tsapIdentifier", "h245.tsapIdentifier",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MulticastAddress/iP6Address/tsapIdentifier", HFILL }},
    { &hf_h245_synchFlag,
      { "synchFlag", "h245.synchFlag",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_h235Key,
      { "h235Key", "h245.h235Key",
        FT_BYTES, BASE_HEX, NULL, 0,
        "EncryptionSync/h235Key", HFILL }},
    { &hf_h245_escrowentry,
      { "escrowentry", "h245.escrowentry",
        FT_NONE, BASE_NONE, NULL, 0,
        "EncryptionSync/escrowentry", HFILL }},
    { &hf_h245_escrowentry_item,
      { "Item", "h245.escrowentry_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "EncryptionSync/escrowentry/_item", HFILL }},
    { &hf_h245_escrowID,
      { "escrowID", "h245.escrowID",
        FT_STRING, BASE_NONE, NULL, 0,
        "EscrowData/escrowID", HFILL }},
    { &hf_h245_escrowValue,
      { "escrowValue", "h245.escrowValue",
        FT_BYTES, BASE_HEX, NULL, 0,
        "EscrowData/escrowValue", HFILL }},
    { &hf_h245_olc_ack_reverseLogicalChannelParameters,
      { "reverseLogicalChannelParameters", "h245.reverseLogicalChannelParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelAck/reverseLogicalChannelParameters", HFILL }},
    { &hf_h245_reverseLogicalChannelNumber,
      { "reverseLogicalChannelNumber", "h245.reverseLogicalChannelNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "OpenLogicalChannelAck/reverseLogicalChannelParameters/reverseLogicalChannelNumber", HFILL }},
    { &hf_h245_olc_ack_multiplexParameters,
      { "multiplexParameters", "h245.multiplexParameters",
        FT_UINT32, BASE_DEC, VALS(h245_T_multiplexParameters_vals), 0,
        "OpenLogicalChannelAck/reverseLogicalChannelParameters/multiplexParameters", HFILL }},
    { &hf_h245_forwardMultiplexAckParameters,
      { "forwardMultiplexAckParameters", "h245.forwardMultiplexAckParameters",
        FT_UINT32, BASE_DEC, VALS(h245_T_forwardMultiplexAckParameters_vals), 0,
        "OpenLogicalChannelAck/forwardMultiplexAckParameters", HFILL }},
    { &hf_h245_h2250LogicalChannelAckParameters,
      { "h2250LogicalChannelAckParameters", "h245.h2250LogicalChannelAckParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelAck/forwardMultiplexAckParameters/h2250LogicalChannelAckParameters", HFILL }},
    { &hf_h245_olc_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_OpenLogicalChannelRejectCause_vals), 0,
        "OpenLogicalChannelReject/cause", HFILL }},
    { &hf_h245_unsuitableReverseParameters,
      { "unsuitableReverseParameters", "h245.unsuitableReverseParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/unsuitableReverseParameters", HFILL }},
    { &hf_h245_dataTypeNotSupported,
      { "dataTypeNotSupported", "h245.dataTypeNotSupported",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/dataTypeNotSupported", HFILL }},
    { &hf_h245_dataTypeNotAvailable,
      { "dataTypeNotAvailable", "h245.dataTypeNotAvailable",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/dataTypeNotAvailable", HFILL }},
    { &hf_h245_unknownDataType,
      { "unknownDataType", "h245.unknownDataType",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/unknownDataType", HFILL }},
    { &hf_h245_dataTypeALCombinationNotSupported,
      { "dataTypeALCombinationNotSupported", "h245.dataTypeALCombinationNotSupported",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/dataTypeALCombinationNotSupported", HFILL }},
    { &hf_h245_multicastChannelNotAllowed,
      { "multicastChannelNotAllowed", "h245.multicastChannelNotAllowed",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/multicastChannelNotAllowed", HFILL }},
    { &hf_h245_insufficientBandwidth,
      { "insufficientBandwidth", "h245.insufficientBandwidth",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/insufficientBandwidth", HFILL }},
    { &hf_h245_separateStackEstablishmentFailed,
      { "separateStackEstablishmentFailed", "h245.separateStackEstablishmentFailed",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/separateStackEstablishmentFailed", HFILL }},
    { &hf_h245_invalidSessionID,
      { "invalidSessionID", "h245.invalidSessionID",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/invalidSessionID", HFILL }},
    { &hf_h245_masterSlaveConflict,
      { "masterSlaveConflict", "h245.masterSlaveConflict",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/masterSlaveConflict", HFILL }},
    { &hf_h245_waitForCommunicationMode,
      { "waitForCommunicationMode", "h245.waitForCommunicationMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/waitForCommunicationMode", HFILL }},
    { &hf_h245_invalidDependentChannel,
      { "invalidDependentChannel", "h245.invalidDependentChannel",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/invalidDependentChannel", HFILL }},
    { &hf_h245_replacementForRejected,
      { "replacementForRejected", "h245.replacementForRejected",
        FT_NONE, BASE_NONE, NULL, 0,
        "OpenLogicalChannelReject/cause/replacementForRejected", HFILL }},
    { &hf_h245_sessionID,
      { "sessionID", "h245.sessionID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_ack_mediaChannel,
      { "mediaChannel", "h245.mediaChannel",
        FT_UINT32, BASE_DEC, VALS(h245_TransportAddress_vals), 0,
        "H2250LogicalChannelAckParameters/mediaChannel", HFILL }},
    { &hf_h245_ack_mediaControlChannel,
      { "mediaControlChannel", "h245.mediaControlChannel",
        FT_UINT32, BASE_DEC, VALS(h245_TransportAddress_vals), 0,
        "H2250LogicalChannelAckParameters/mediaControlChannel", HFILL }},
    { &hf_h245_flowControlToZero,
      { "flowControlToZero", "h245.flowControlToZero",
        FT_BOOLEAN, 8, NULL, 0,
        "H2250LogicalChannelAckParameters/flowControlToZero", HFILL }},
    { &hf_h245_CloseLogicalChannel_source,
      { "source", "h245.source",
        FT_UINT32, BASE_DEC, VALS(h245_T_source_vals), 0,
        "CloseLogicalChannel/source", HFILL }},
    { &hf_h245_user,
      { "user", "h245.user",
        FT_NONE, BASE_NONE, NULL, 0,
        "CloseLogicalChannel/source/user", HFILL }},
    { &hf_h245_lcse,
      { "lcse", "h245.lcse",
        FT_NONE, BASE_NONE, NULL, 0,
        "CloseLogicalChannel/source/lcse", HFILL }},
    { &hf_h245_clc_reason,
      { "reason", "h245.reason",
        FT_UINT32, BASE_DEC, VALS(h245_clc_reason_vals), 0,
        "CloseLogicalChannel/reason", HFILL }},
    { &hf_h245_unknown,
      { "unknown", "h245.unknown",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_reopen,
      { "reopen", "h245.reopen",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_reservationFailure,
      { "reservationFailure", "h245.reservationFailure",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_qosCapability,
      { "qosCapability", "h245.qosCapability",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestChannelClose/qosCapability", HFILL }},
    { &hf_h245_reason,
      { "reason", "h245.reason",
        FT_UINT32, BASE_DEC, VALS(h245_T_reason_vals), 0,
        "RequestChannelClose/reason", HFILL }},
    { &hf_h245_normal,
      { "normal", "h245.normal",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestChannelClose/reason/normal", HFILL }},
    { &hf_h245_req_chan_clos_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_RequestChannelCloseRejectCause_vals), 0,
        "RequestChannelCloseReject/cause", HFILL }},
    { &hf_h245_multiplexEntryDescriptors,
      { "multiplexEntryDescriptors", "h245.multiplexEntryDescriptors",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntrySend/multiplexEntryDescriptors", HFILL }},
    { &hf_h245_multiplexEntryDescriptors_item,
      { "Item", "h245.multiplexEntryDescriptors_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntrySend/multiplexEntryDescriptors/_item", HFILL }},
    { &hf_h245_multiplexTableEntryNumber,
      { "multiplexTableEntryNumber", "h245.multiplexTableEntryNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_elementList,
      { "elementList", "h245.elementList",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntryDescriptor/elementList", HFILL }},
    { &hf_h245_elementList_item,
      { "Item", "h245.elementList_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntryDescriptor/elementList/_item", HFILL }},
    { &hf_h245_Me_type,
      { "type", "h245.type",
        FT_UINT32, BASE_DEC, VALS(h245_Me_type_vals), 0,
        "MultiplexElement/type", HFILL }},
    { &hf_h245_logicalChannelNum,
      { "logicalChannelNumber", "h245.logicalChannelNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MultiplexElement/type/logicalChannelNumber", HFILL }},
    { &hf_h245_subElementList,
      { "subElementList", "h245.subElementList",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexElement/type/subElementList", HFILL }},
    { &hf_h245_subElementList_item,
      { "Item", "h245.subElementList_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexElement/type/subElementList/_item", HFILL }},
    { &hf_h245_me_repeatCount,
      { "repeatCount", "h245.repeatCount",
        FT_UINT32, BASE_DEC, VALS(h245_ME_repeatCount_vals), 0,
        "MultiplexElement/repeatCount", HFILL }},
    { &hf_h245_finite_1_65535,
      { "finite", "h245.finite",
        FT_UINT32, BASE_DEC, NULL, 0,
        "MultiplexElement/repeatCount/finite", HFILL }},
    { &hf_h245_untilClosingFlag,
      { "untilClosingFlag", "h245.untilClosingFlag",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexElement/repeatCount/untilClosingFlag", HFILL }},
    { &hf_h245_multiplexTableEntryNumbers,
      { "multiplexTableEntryNumber", "h245.multiplexTableEntryNumber",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_multiplexTableEntryNumber_item,
      { "Item", "h245.multiplexTableEntryNumber_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_rejectionDescriptions1,
      { "rejectionDescriptions1", "h245.rejectionDescriptions1",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntrySendReject/rejectionDescriptions1", HFILL }},
    { &hf_h245_rejectionDescriptions1_item,
      { "Item", "h245.rejectionDescriptions1_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntrySendReject/rejectionDescriptions1/_item", HFILL }},
    { &hf_h245_mux_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_MultiplexEntryRejectionDescriptionsCause_vals), 0,
        "MultiplexEntryRejectionDescriptions/cause", HFILL }},
    { &hf_h245_unspecifiedCause,
      { "unspecifiedCause", "h245.unspecifiedCause",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_descriptorTooComplex,
      { "descriptorTooComplex", "h245.descriptorTooComplex",
        FT_NONE, BASE_NONE, NULL, 0,
        "MultiplexEntryRejectionDescriptions/cause/descriptorTooComplex", HFILL }},
    { &hf_h245_entryNumbers,
      { "entryNumbers", "h245.entryNumbers",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_entryNumbers_item,
      { "Item", "h245.entryNumbers_item",
        FT_UINT32, BASE_DEC, NULL, 0,
        "", HFILL }},
    { &hf_h245_rejectionDescriptions2,
      { "rejectionDescriptions2", "h245.rejectionDescriptions2",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMultiplexEntryReject/rejectionDescriptions2", HFILL }},
    { &hf_h245_rejectionDescriptions2_item,
      { "Item", "h245.rejectionDescriptions2_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMultiplexEntryReject/rejectionDescriptions2/_item", HFILL }},
    { &hf_h245_req_mux_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_RequestMultiplexEntryRejectionDescriptionsCause_vals), 0,
        "RequestMultiplexEntryRejectionDescriptions/cause", HFILL }},
    { &hf_h245_requestedModes,
      { "requestedModes", "h245.requestedModes",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMode/requestedModes", HFILL }},
    { &hf_h245_requestedModes_item,
      { "Item", "h245.requestedModes_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestMode/requestedModes/_item", HFILL }},
    { &hf_h245_req_mode_ack_response,
      { "response", "h245.response",
        FT_UINT32, BASE_DEC, VALS(h245_Req_mode_ack_response_vals), 0,
        "RequestModeAck/response", HFILL }},
    { &hf_h245_willTransmitMostPreferredMode,
      { "willTransmitMostPreferredMode", "h245.willTransmitMostPreferredMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestModeAck/response/willTransmitMostPreferredMode", HFILL }},
    { &hf_h245_willTransmitLessPreferredMode,
      { "willTransmitLessPreferredMode", "h245.willTransmitLessPreferredMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestModeAck/response/willTransmitLessPreferredMode", HFILL }},
    { &hf_h245_req_rej_cause,
      { "cause", "h245.cause",
        FT_UINT32, BASE_DEC, VALS(h245_RequestModeRejectCause_vals), 0,
        "RequestModeReject/cause", HFILL }},
    { &hf_h245_modeUnavailable,
      { "modeUnavailable", "h245.modeUnavailable",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestModeReject/cause/modeUnavailable", HFILL }},
    { &hf_h245_multipointConstraint,
      { "multipointConstraint", "h245.multipointConstraint",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestModeReject/cause/multipointConstraint", HFILL }},
    { &hf_h245_requestDenied,
      { "requestDenied", "h245.requestDenied",
        FT_NONE, BASE_NONE, NULL, 0,
        "RequestModeReject/cause/requestDenied", HFILL }},
    { &hf_h245_ModeDescription_item,
      { "Item", "h245.ModeDescription_item",
        FT_NONE, BASE_NONE, NULL, 0,
        "ModeDescription/_item", HFILL }},
    { &hf_h245_videoMode,
      { "videoMode", "h245.videoMode",
        FT_UINT32, BASE_DEC, VALS(h245_VideoMode_vals), 0,
        "", HFILL }},
    { &hf_h245_audioMode,
      { "audioMode", "h245.audioMode",
        FT_UINT32, BASE_DEC, VALS(h245_AudioMode_vals), 0,
        "", HFILL }},
    { &hf_h245_dataMode,
      { "dataMode", "h245.dataMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_encryptionMode,
      { "encryptionMode", "h245.encryptionMode",
        FT_UINT32, BASE_DEC, VALS(h245_EncryptionMode_vals), 0,
        "", HFILL }},
    { &hf_h245_h235Mode,
      { "h235Mode", "h245.h235Mode",
        FT_NONE, BASE_NONE, NULL, 0,
        "", HFILL }},
    { &hf_h245_multiplexedStreamMode,
      { "multiplexedStreamMode", "h245.multiplexedStreamMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "ModeElementType/multiplexedStreamMode", HFILL }},
    { &hf_h245_redundancyEncodingDTMode,
      { "redundancyEncodingDTMode", "h245.redundancyEncodingDTMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "ModeElementType/redundancyEncodingDTMode", HFILL }},
    { &hf_h245_multiplePayloadStreamMode,
      { "multiplePayloadStreamMode", "h245.multiplePayloadStreamMode",
        FT_NONE, BASE_NONE, NULL, 0,
        "ModeElementType/multiplePayloadStreamMode", HFILL }},
    { &hf_h245_fecMode,
      { "fecMode", "h245.fecMode",
        FT_UINT32, BASE_DEC, VALS(h245_FECMode_vals), 0,
        "ModeElementType/fecMode", HFILL }},
    { &hf_h245_type,
      { "type", "h245.type",
        FT_UINT32, BASE_DEC, VALS(h245_ModeElementType_vals), 0,
        "", HFILL }},
    { &hf_h245_h223ModeParameters,
      { "h223ModeParameters", "h245.h223ModeParameters",
        FT_NONE, BASE_NONE, NULL, 0,
        "ModeElement/h223ModeParameters", HFILL }},
    { &hf_h245_v76Mo