/* DO NOT EDIT
 * This dissector is autogenerated
 */

/* packet-dcerpc-atsvc.c
 * Routines for ATSVC packet disassembly
 * based on the original dissector that was
 *      * Copyright 2003 Jean-Baptiste Marchand <jbm@hsc.fr>
 * and IDL file from samba 4
 *
 * $Id: packet-dcerpc-atsvc.c 13808 2005-03-19 14:30:05Z sahlberg $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <string.h>

#include <epan/packet.h>
#include "packet-dcerpc.h"
#include "packet-dcerpc-nt.h"
#include "packet-windows-common.h"
#include "packet-dcerpc-atsvc.h"

static int proto_atsvc = -1;


/* INCLUDED FILE : ETH_HF */
static int hf_atsvc_job_time = -1;
static int hf_atsvc_job_id = -1;
static int hf_atsvc_opnum = -1;
static int hf_atsvc_rc = -1;
static int hf_atsvc_DaysOfMonth_First = -1;
static int hf_atsvc_DaysOfMonth_Second = -1;
static int hf_atsvc_DaysOfMonth_Third = -1;
static int hf_atsvc_DaysOfMonth_Fourth = -1;
static int hf_atsvc_DaysOfMonth_Fifth = -1;
static int hf_atsvc_DaysOfMonth_Sixth = -1;
static int hf_atsvc_DaysOfMonth_Seventh = -1;
static int hf_atsvc_DaysOfMonth_Eight = -1;
static int hf_atsvc_DaysOfMonth_Ninth = -1;
static int hf_atsvc_DaysOfMonth_Tenth = -1;
static int hf_atsvc_DaysOfMonth_Eleventh = -1;
static int hf_atsvc_DaysOfMonth_Twelfth = -1;
static int hf_atsvc_DaysOfMonth_Thitteenth = -1;
static int hf_atsvc_DaysOfMonth_Fourteenth = -1;
static int hf_atsvc_DaysOfMonth_Fifteenth = -1;
static int hf_atsvc_DaysOfMonth_Sixteenth = -1;
static int hf_atsvc_DaysOfMonth_Seventeenth = -1;
static int hf_atsvc_DaysOfMonth_Eighteenth = -1;
static int hf_atsvc_DaysOfMonth_Ninteenth = -1;
static int hf_atsvc_DaysOfMonth_Twentyth = -1;
static int hf_atsvc_DaysOfMonth_Twentyfirst = -1;
static int hf_atsvc_DaysOfMonth_Twentysecond = -1;
static int hf_atsvc_DaysOfMonth_Twentythird = -1;
static int hf_atsvc_DaysOfMonth_Twentyfourth = -1;
static int hf_atsvc_DaysOfMonth_Twentyfifth = -1;
static int hf_atsvc_DaysOfMonth_Twentysixth = -1;
static int hf_atsvc_DaysOfMonth_Twentyseventh = -1;
static int hf_atsvc_DaysOfMonth_Twentyeighth = -1;
static int hf_atsvc_DaysOfMonth_Twentyninth = -1;
static int hf_atsvc_DaysOfMonth_Thirtieth = -1;
static int hf_atsvc_DaysOfMonth_Thirtyfirst = -1;
static int hf_atsvc_DaysOfWeek_Monday = -1;
static int hf_atsvc_DaysOfWeek_Tuesday = -1;
static int hf_atsvc_DaysOfWeek_Wednesday = -1;
static int hf_atsvc_DaysOfWeek_Thursday = -1;
static int hf_atsvc_DaysOfWeek_Friday = -1;
static int hf_atsvc_DaysOfWeek_Saturday = -1;
static int hf_atsvc_DaysOfWeek_Sunday = -1;
static int hf_atsvc_Flags_JOB_RUN_PERIODICALLY = -1;
static int hf_atsvc_Flags_JOB_EXEC_ERROR = -1;
static int hf_atsvc_Flags_JOB_RUNS_TODAY = -1;
static int hf_atsvc_Flags_JOB_ADD_CURRENT_DATE = -1;
static int hf_atsvc_Flags_JOB_NONINTERACTIVE = -1;
static int hf_atsvc_JobInfo_days_of_month = -1;
static int hf_atsvc_JobInfo_days_of_week = -1;
static int hf_atsvc_JobInfo_flags = -1;
static int hf_atsvc_JobInfo_command = -1;
static int hf_atsvc_JobAdd_servername = -1;
static int hf_atsvc_JobAdd_job_info = -1;
static int hf_atsvc_JobDel_servername = -1;
static int hf_atsvc_JobDel_min_job_id = -1;
static int hf_atsvc_JobDel_max_job_id = -1;
static int hf_atsvc_JobEnumInfo_days_of_month = -1;
static int hf_atsvc_JobEnumInfo_days_of_week = -1;
static int hf_atsvc_JobEnumInfo_flags = -1;
static int hf_atsvc_JobEnumInfo_command = -1;
static int hf_atsvc_enum_ctr_entries_read = -1;
static int hf_atsvc_enum_ctr_first_entry = -1;
static int hf_atsvc_JobEnum_servername = -1;
static int hf_atsvc_JobEnum_ctr = -1;
static int hf_atsvc_JobEnum_preferred_max_len = -1;
static int hf_atsvc_JobEnum_total_entries = -1;
static int hf_atsvc_JobEnum_resume_handle = -1;
static int hf_atsvc_JobGetInfo_servername = -1;
static int hf_atsvc_JobGetInfo_job_info = -1;
/* END OF INCLUDED FILE : ETH_HF */





/* INCLUDED FILE : ETH_ETT */
static gint ett_atsvc = -1;
static gint ett_atsvc_DaysOfMonth = -1;
static gint ett_atsvc_DaysOfWeek = -1;
static gint ett_atsvc_Flags = -1;
static gint ett_atsvc_JobInfo = -1;
static gint ett_atsvc_JobEnumInfo = -1;
static gint ett_atsvc_enum_ctr = -1;
/* END OF INCLUDED FILE : ETH_ETT */



int
atsvc_dissect_JobTime(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
	guint32 job_time;
	guint8 job_hour, job_min, job_sec;
	guint16 job_msec;

	offset = dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep,
			-1, &job_time);

	job_hour = job_time / 3600000;
	job_min = (job_time - job_hour * 3600000) / 60000;
	job_sec = (job_time - (job_hour * 3600000) - (job_min * 60000)) / 1000;
	job_msec = (job_time - (job_hour * 3600000) - (job_min * 60000) - (job_sec * 1000));

	proto_tree_add_uint_format(tree, hf_index, tvb, offset - 4,
			4, job_time, "Time: %02d:%02d:%02d:%03d", job_hour, job_min, job_sec, job_msec);

	return offset;
}



/* INCLUDED FILE : ETH_CODE */
static e_uuid_t uuid_dcerpc_atsvc = {
    0x1ff70682, 0x0a51, 0x30e8,
    { 0x07, 0x6d, 0x74, 0x0b, 0xe8, 0xce, 0xe9, 0x8b}
};

static guint16 ver_atsvc = 1;

static const true_false_string First_tfs = {
    "First is SET",
    "First is NOT set"
};

static const true_false_string Second_tfs = {
    "Second is SET",
    "Second is NOT set"
};

static const true_false_string Third_tfs = {
    "Third is SET",
    "Third is NOT set"
};

static const true_false_string Fourth_tfs = {
    "Fourth is SET",
    "Fourth is NOT set"
};

static const true_false_string Fifth_tfs = {
    "Fifth is SET",
    "Fifth is NOT set"
};

static const true_false_string Sixth_tfs = {
    "Sixth is SET",
    "Sixth is NOT set"
};

static const true_false_string Seventh_tfs = {
    "Seventh is SET",
    "Seventh is NOT set"
};

static const true_false_string Eight_tfs = {
    "Eight is SET",
    "Eight is NOT set"
};

static const true_false_string Ninth_tfs = {
    "Ninth is SET",
    "Ninth is NOT set"
};

static const true_false_string Tenth_tfs = {
    "Tenth is SET",
    "Tenth is NOT set"
};

static const true_false_string Eleventh_tfs = {
    "Eleventh is SET",
    "Eleventh is NOT set"
};

static const true_false_string Twelfth_tfs = {
    "Twelfth is SET",
    "Twelfth is NOT set"
};

static const true_false_string Thitteenth_tfs = {
    "Thitteenth is SET",
    "Thitteenth is NOT set"
};

static const true_false_string Fourteenth_tfs = {
    "Fourteenth is SET",
    "Fourteenth is NOT set"
};

static const true_false_string Fifteenth_tfs = {
    "Fifteenth is SET",
    "Fifteenth is NOT set"
};

static const true_false_string Sixteenth_tfs = {
    "Sixteenth is SET",
    "Sixteenth is NOT set"
};

static const true_false_string Seventeenth_tfs = {
    "Seventeenth is SET",
    "Seventeenth is NOT set"
};

static const true_false_string Eighteenth_tfs = {
    "Eighteenth is SET",
    "Eighteenth is NOT set"
};

static const true_false_string Ninteenth_tfs = {
    "Ninteenth is SET",
    "Ninteenth is NOT set"
};

static const true_false_string Twentyth_tfs = {
    "Twentyth is SET",
    "Twentyth is NOT set"
};

static const true_false_string Twentyfirst_tfs = {
    "Twentyfirst is SET",
    "Twentyfirst is NOT set"
};

static const true_false_string Twentysecond_tfs = {
    "Twentysecond is SET",
    "Twentysecond is NOT set"
};

static const true_false_string Twentythird_tfs = {
    "Twentythird is SET",
    "Twentythird is NOT set"
};

static const true_false_string Twentyfourth_tfs = {
    "Twentyfourth is SET",
    "Twentyfourth is NOT set"
};

static const true_false_string Twentyfifth_tfs = {
    "Twentyfifth is SET",
    "Twentyfifth is NOT set"
};

static const true_false_string Twentysixth_tfs = {
    "Twentysixth is SET",
    "Twentysixth is NOT set"
};

static const true_false_string Twentyseventh_tfs = {
    "Twentyseventh is SET",
    "Twentyseventh is NOT set"
};

static const true_false_string Twentyeighth_tfs = {
    "Twentyeighth is SET",
    "Twentyeighth is NOT set"
};

static const true_false_string Twentyninth_tfs = {
    "Twentyninth is SET",
    "Twentyninth is NOT set"
};

static const true_false_string Thirtieth_tfs = {
    "Thirtieth is SET",
    "Thirtieth is NOT set"
};

static const true_false_string Thirtyfirst_tfs = {
    "Thirtyfirst is SET",
    "Thirtyfirst is NOT set"
};


int
atsvc_dissect_DaysOfMonth(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_DaysOfMonth);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_First, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " First");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Second, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " Second");
    }
    flags&=(~0x00000002);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Third, tvb, offset-4, 4, flags);
    if(flags&0x00000004){
        proto_item_append_text(item, " Third");
    }
    flags&=(~0x00000004);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Fourth, tvb, offset-4, 4, flags);
    if(flags&0x00000008){
        proto_item_append_text(item, " Fourth");
    }
    flags&=(~0x00000008);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Fifth, tvb, offset-4, 4, flags);
    if(flags&0x00000010){
        proto_item_append_text(item, " Fifth");
    }
    flags&=(~0x00000010);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Sixth, tvb, offset-4, 4, flags);
    if(flags&0x00000020){
        proto_item_append_text(item, " Sixth");
    }
    flags&=(~0x00000020);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Seventh, tvb, offset-4, 4, flags);
    if(flags&0x00000040){
        proto_item_append_text(item, " Seventh");
    }
    flags&=(~0x00000040);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Eight, tvb, offset-4, 4, flags);
    if(flags&0x00000080){
        proto_item_append_text(item, " Eight");
    }
    flags&=(~0x00000080);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Ninth, tvb, offset-4, 4, flags);
    if(flags&0x00000100){
        proto_item_append_text(item, " Ninth");
    }
    flags&=(~0x00000100);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Tenth, tvb, offset-4, 4, flags);
    if(flags&0x00000200){
        proto_item_append_text(item, " Tenth");
    }
    flags&=(~0x00000200);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Eleventh, tvb, offset-4, 4, flags);
    if(flags&0x00000400){
        proto_item_append_text(item, " Eleventh");
    }
    flags&=(~0x00000400);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twelfth, tvb, offset-4, 4, flags);
    if(flags&0x00000800){
        proto_item_append_text(item, " Twelfth");
    }
    flags&=(~0x00000800);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Thitteenth, tvb, offset-4, 4, flags);
    if(flags&0x00001000){
        proto_item_append_text(item, " Thitteenth");
    }
    flags&=(~0x00001000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Fourteenth, tvb, offset-4, 4, flags);
    if(flags&0x00002000){
        proto_item_append_text(item, " Fourteenth");
    }
    flags&=(~0x00002000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Fifteenth, tvb, offset-4, 4, flags);
    if(flags&0x00004000){
        proto_item_append_text(item, " Fifteenth");
    }
    flags&=(~0x00004000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Sixteenth, tvb, offset-4, 4, flags);
    if(flags&0x00008000){
        proto_item_append_text(item, " Sixteenth");
    }
    flags&=(~0x00008000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Seventeenth, tvb, offset-4, 4, flags);
    if(flags&0x00010000){
        proto_item_append_text(item, " Seventeenth");
    }
    flags&=(~0x00010000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Eighteenth, tvb, offset-4, 4, flags);
    if(flags&0x00020000){
        proto_item_append_text(item, " Eighteenth");
    }
    flags&=(~0x00020000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Ninteenth, tvb, offset-4, 4, flags);
    if(flags&0x00040000){
        proto_item_append_text(item, " Ninteenth");
    }
    flags&=(~0x00040000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyth, tvb, offset-4, 4, flags);
    if(flags&0x00080000){
        proto_item_append_text(item, " Twentyth");
    }
    flags&=(~0x00080000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyfirst, tvb, offset-4, 4, flags);
    if(flags&0x00100000){
        proto_item_append_text(item, " Twentyfirst");
    }
    flags&=(~0x00100000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentysecond, tvb, offset-4, 4, flags);
    if(flags&0x00200000){
        proto_item_append_text(item, " Twentysecond");
    }
    flags&=(~0x00200000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentythird, tvb, offset-4, 4, flags);
    if(flags&0x00400000){
        proto_item_append_text(item, " Twentythird");
    }
    flags&=(~0x00400000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyfourth, tvb, offset-4, 4, flags);
    if(flags&0x00800000){
        proto_item_append_text(item, " Twentyfourth");
    }
    flags&=(~0x00800000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyfifth, tvb, offset-4, 4, flags);
    if(flags&0x01000000){
        proto_item_append_text(item, " Twentyfifth");
    }
    flags&=(~0x01000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentysixth, tvb, offset-4, 4, flags);
    if(flags&0x02000000){
        proto_item_append_text(item, " Twentysixth");
    }
    flags&=(~0x02000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyseventh, tvb, offset-4, 4, flags);
    if(flags&0x04000000){
        proto_item_append_text(item, " Twentyseventh");
    }
    flags&=(~0x04000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyeighth, tvb, offset-4, 4, flags);
    if(flags&0x08000000){
        proto_item_append_text(item, " Twentyeighth");
    }
    flags&=(~0x08000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Twentyninth, tvb, offset-4, 4, flags);
    if(flags&0x10000000){
        proto_item_append_text(item, " Twentyninth");
    }
    flags&=(~0x10000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Thirtieth, tvb, offset-4, 4, flags);
    if(flags&0x20000000){
        proto_item_append_text(item, " Thirtieth");
    }
    flags&=(~0x20000000);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfMonth_Thirtyfirst, tvb, offset-4, 4, flags);
    if(flags&0x40000000){
        proto_item_append_text(item, " Thirtyfirst");
    }
    flags&=(~0x40000000);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static const true_false_string Monday_tfs = {
    "Monday is SET",
    "Monday is NOT set"
};

static const true_false_string Tuesday_tfs = {
    "Tuesday is SET",
    "Tuesday is NOT set"
};

static const true_false_string Wednesday_tfs = {
    "Wednesday is SET",
    "Wednesday is NOT set"
};

static const true_false_string Thursday_tfs = {
    "Thursday is SET",
    "Thursday is NOT set"
};

static const true_false_string Friday_tfs = {
    "Friday is SET",
    "Friday is NOT set"
};

static const true_false_string Saturday_tfs = {
    "Saturday is SET",
    "Saturday is NOT set"
};

static const true_false_string Sunday_tfs = {
    "Sunday is SET",
    "Sunday is NOT set"
};


int
atsvc_dissect_DaysOfWeek(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint8 flags;


    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 1, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_DaysOfWeek);
    }

    offset=dissect_ndr_uint8(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Monday, tvb, offset-1, 1, flags);
    if(flags&0x01){
        proto_item_append_text(item, " Monday");
    }
    flags&=(~0x01);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Tuesday, tvb, offset-1, 1, flags);
    if(flags&0x02){
        proto_item_append_text(item, " Tuesday");
    }
    flags&=(~0x02);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Wednesday, tvb, offset-1, 1, flags);
    if(flags&0x04){
        proto_item_append_text(item, " Wednesday");
    }
    flags&=(~0x04);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Thursday, tvb, offset-1, 1, flags);
    if(flags&0x08){
        proto_item_append_text(item, " Thursday");
    }
    flags&=(~0x08);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Friday, tvb, offset-1, 1, flags);
    if(flags&0x10){
        proto_item_append_text(item, " Friday");
    }
    flags&=(~0x10);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Saturday, tvb, offset-1, 1, flags);
    if(flags&0x20){
        proto_item_append_text(item, " Saturday");
    }
    flags&=(~0x20);

    proto_tree_add_boolean(tree, hf_atsvc_DaysOfWeek_Sunday, tvb, offset-1, 1, flags);
    if(flags&0x40){
        proto_item_append_text(item, " Sunday");
    }
    flags&=(~0x40);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static const true_false_string JOB_RUN_PERIODICALLY_tfs = {
    "JOB_RUN_PERIODICALLY is SET",
    "JOB_RUN_PERIODICALLY is NOT set"
};

static const true_false_string JOB_EXEC_ERROR_tfs = {
    "JOB_EXEC_ERROR is SET",
    "JOB_EXEC_ERROR is NOT set"
};

static const true_false_string JOB_RUNS_TODAY_tfs = {
    "JOB_RUNS_TODAY is SET",
    "JOB_RUNS_TODAY is NOT set"
};

static const true_false_string JOB_ADD_CURRENT_DATE_tfs = {
    "JOB_ADD_CURRENT_DATE is SET",
    "JOB_ADD_CURRENT_DATE is NOT set"
};

static const true_false_string JOB_NONINTERACTIVE_tfs = {
    "JOB_NONINTERACTIVE is SET",
    "JOB_NONINTERACTIVE is NOT set"
};


int
atsvc_dissect_Flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint8 flags;


    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 1, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_Flags);
    }

    offset=dissect_ndr_uint8(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_atsvc_Flags_JOB_RUN_PERIODICALLY, tvb, offset-1, 1, flags);
    if(flags&0x01){
        proto_item_append_text(item, " JOB_RUN_PERIODICALLY");
    }
    flags&=(~0x01);

    proto_tree_add_boolean(tree, hf_atsvc_Flags_JOB_EXEC_ERROR, tvb, offset-1, 1, flags);
    if(flags&0x02){
        proto_item_append_text(item, " JOB_EXEC_ERROR");
    }
    flags&=(~0x02);

    proto_tree_add_boolean(tree, hf_atsvc_Flags_JOB_RUNS_TODAY, tvb, offset-1, 1, flags);
    if(flags&0x04){
        proto_item_append_text(item, " JOB_RUNS_TODAY");
    }
    flags&=(~0x04);

    proto_tree_add_boolean(tree, hf_atsvc_Flags_JOB_ADD_CURRENT_DATE, tvb, offset-1, 1, flags);
    if(flags&0x08){
        proto_item_append_text(item, " JOB_ADD_CURRENT_DATE");
    }
    flags&=(~0x08);

    proto_tree_add_boolean(tree, hf_atsvc_Flags_JOB_NONINTERACTIVE, tvb, offset-1, 1, flags);
    if(flags&0x10){
        proto_item_append_text(item, " JOB_NONINTERACTIVE");
    }
    flags&=(~0x10);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static int
atsvc_dissect_JobInfo_job_time(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_JobTime(tvb, offset, pinfo, tree, drep, hf_atsvc_job_time, param);
    return offset;
}

static int
atsvc_dissect_JobInfo_days_of_month(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_DaysOfMonth(tvb, offset, pinfo, tree, drep, hf_atsvc_JobInfo_days_of_month, param);
    return offset;
}

static int
atsvc_dissect_JobInfo_days_of_week(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_DaysOfWeek(tvb, offset, pinfo, tree, drep, hf_atsvc_JobInfo_days_of_week, param);
    return offset;
}

static int
atsvc_dissect_JobInfo_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_Flags(tvb, offset, pinfo, tree, drep, hf_atsvc_JobInfo_flags, param);
    return offset;
}


static int
atsvc_dissect_unistr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_cvstring(tvb, offset, pinfo, tree, drep, 2, hf_index, FALSE, NULL);
    return offset;
}

static int
atsvc_dissect_JobInfo_command(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobInfo_command, param);
    return offset;
}

static int
unique_atsvc_dissect_JobInfo_command(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobInfo_command, NDR_POINTER_UNIQUE, "command", -1);
    return offset;
}


int
atsvc_dissect_JobInfo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_JobInfo);
    }

    offset=atsvc_dissect_JobInfo_job_time(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobInfo_days_of_month(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobInfo_days_of_week(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobInfo_flags(tvb, offset, pinfo, tree, drep);

    offset=unique_atsvc_dissect_JobInfo_command(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
atsvc_dissect_JobAdd_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobAdd_servername, param);
    return offset;
}

static int
unique_atsvc_dissect_JobAdd_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobAdd_servername, NDR_POINTER_UNIQUE, "servername", -1);
    return offset;
}

static int
atsvc_dissect_JobAdd_job_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_JobInfo(tvb, offset, pinfo, tree, drep, hf_atsvc_JobAdd_job_info, param);
    return offset;
}

static int
ref_atsvc_dissect_JobAdd_job_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobAdd_job_info, NDR_POINTER_REF, "job_info", -1);
    return offset;
}


static int
atsvc_dissect_uint32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
atsvc_dissect_JobAdd_job_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_job_id, param);
    return offset;
}


static int
atsvc_dissect_JobAdd_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_atsvc_dissect_JobAdd_servername(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=ref_atsvc_dissect_JobAdd_job_info(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
atsvc_dissect_JobAdd_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=atsvc_dissect_JobAdd_job_id(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_atsvc_rc, NULL);


   return offset;
}
static int
atsvc_dissect_JobDel_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobDel_servername, param);
    return offset;
}

static int
unique_atsvc_dissect_JobDel_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobDel_servername, NDR_POINTER_UNIQUE, "servername", -1);
    return offset;
}

static int
atsvc_dissect_JobDel_min_job_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_JobDel_min_job_id, param);
    return offset;
}

static int
atsvc_dissect_JobDel_max_job_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_JobDel_max_job_id, param);
    return offset;
}


static int
atsvc_dissect_JobDel_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_atsvc_dissect_JobDel_servername(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=atsvc_dissect_JobDel_min_job_id(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=atsvc_dissect_JobDel_max_job_id(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
atsvc_dissect_JobDel_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_atsvc_rc, NULL);


   return offset;
}
static int
atsvc_dissect_JobEnumInfo_job_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_job_id, param);
    return offset;
}

static int
atsvc_dissect_JobEnumInfo_job_time(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_JobTime(tvb, offset, pinfo, tree, drep, hf_atsvc_job_time, param);
    return offset;
}

static int
atsvc_dissect_JobEnumInfo_days_of_month(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_DaysOfMonth(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnumInfo_days_of_month, param);
    return offset;
}

static int
atsvc_dissect_JobEnumInfo_days_of_week(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_DaysOfWeek(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnumInfo_days_of_week, param);
    return offset;
}

static int
atsvc_dissect_JobEnumInfo_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_Flags(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnumInfo_flags, param);
    return offset;
}

static int
atsvc_dissect_JobEnumInfo_command(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnumInfo_command, param);
    return offset;
}

static int
unique_atsvc_dissect_JobEnumInfo_command(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobEnumInfo_command, NDR_POINTER_UNIQUE, "command", -1);
    return offset;
}


int
atsvc_dissect_JobEnumInfo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_JobEnumInfo);
    }

    offset=atsvc_dissect_JobEnumInfo_job_id(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobEnumInfo_job_time(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobEnumInfo_days_of_month(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobEnumInfo_days_of_week(tvb, offset, pinfo, tree, drep);

    offset=atsvc_dissect_JobEnumInfo_flags(tvb, offset, pinfo, tree, drep);

    offset=unique_atsvc_dissect_JobEnumInfo_command(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
atsvc_dissect_enum_ctr_entries_read(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_enum_ctr_entries_read, param);
    return offset;
}

static int
atsvc_dissect_enum_ctr_first_entry(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_JobEnumInfo(tvb, offset, pinfo, tree, drep, hf_atsvc_enum_ctr_first_entry, param);
    return offset;
}

static int
ucarray_atsvc_dissect_enum_ctr_first_entry(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, atsvc_dissect_enum_ctr_first_entry);
    return offset;
}

static int
unique_ucarray_atsvc_dissect_enum_ctr_first_entry(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_atsvc_dissect_enum_ctr_first_entry, NDR_POINTER_UNIQUE, "first_entry", -1);
    return offset;
}


int
atsvc_dissect_enum_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_atsvc_enum_ctr);
    }

    offset=atsvc_dissect_enum_ctr_entries_read(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_atsvc_dissect_enum_ctr_first_entry(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
atsvc_dissect_JobEnum_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnum_servername, param);
    return offset;
}

static int
unique_atsvc_dissect_JobEnum_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobEnum_servername, NDR_POINTER_UNIQUE, "servername", -1);
    return offset;
}

static int
atsvc_dissect_JobEnum_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_enum_ctr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnum_ctr, param);
    return offset;
}

static int
ref_atsvc_dissect_JobEnum_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobEnum_ctr, NDR_POINTER_REF, "ctr", -1);
    return offset;
}

static int
atsvc_dissect_JobEnum_preferred_max_len(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnum_preferred_max_len, param);
    return offset;
}

static int
atsvc_dissect_JobEnum_total_entries(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnum_total_entries, param);
    return offset;
}

static int
atsvc_dissect_JobEnum_resume_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_JobEnum_resume_handle, param);
    return offset;
}

static int
unique_atsvc_dissect_JobEnum_resume_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobEnum_resume_handle, NDR_POINTER_UNIQUE, "resume_handle", -1);
    return offset;
}


static int
atsvc_dissect_JobEnum_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_atsvc_dissect_JobEnum_servername(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=ref_atsvc_dissect_JobEnum_ctr(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=atsvc_dissect_JobEnum_preferred_max_len(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=unique_atsvc_dissect_JobEnum_resume_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
atsvc_dissect_JobEnum_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_atsvc_dissect_JobEnum_ctr(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=atsvc_dissect_JobEnum_total_entries(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=unique_atsvc_dissect_JobEnum_resume_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_atsvc_rc, NULL);


   return offset;
}
static int
atsvc_dissect_JobGetInfo_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_atsvc_JobGetInfo_servername, param);
    return offset;
}

static int
unique_atsvc_dissect_JobGetInfo_servername(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobGetInfo_servername, NDR_POINTER_UNIQUE, "servername", -1);
    return offset;
}

static int
atsvc_dissect_JobGetInfo_job_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_atsvc_job_id, param);
    return offset;
}

static int
atsvc_dissect_JobGetInfo_job_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=atsvc_dissect_JobInfo(tvb, offset, pinfo, tree, drep, hf_atsvc_JobGetInfo_job_info, param);
    return offset;
}

static int
unique_atsvc_dissect_JobGetInfo_job_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, atsvc_dissect_JobGetInfo_job_info, NDR_POINTER_UNIQUE, "job_info", -1);
    return offset;
}


static int
atsvc_dissect_JobGetInfo_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_atsvc_dissect_JobGetInfo_servername(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=atsvc_dissect_JobGetInfo_job_id(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
atsvc_dissect_JobGetInfo_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_atsvc_dissect_JobGetInfo_job_info(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_atsvc_rc, NULL);


   return offset;
}
/* END OF INCLUDED FILE : ETH_CODE */



void
proto_register_atsvc(void)
{
        static hf_register_info hf[] = {


/* INCLUDED FILE : ETH_HFARR */
        { &hf_atsvc_job_time,
          { "JobTime", "atsvc.JobTime", FT_UINT32, BASE_HEX,
          NULL, 0,
         "Job Time", HFILL }},

        { &hf_atsvc_job_id,
          { "Job ID", "atsvc.JobId", FT_UINT32, BASE_HEX,
          NULL, 0,
         "Job Id", HFILL }},

        { &hf_atsvc_opnum,
          { "Operation", "atsvc.opnum", FT_UINT16, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_rc,
          { "Return code", "atsvc.rc", FT_UINT32, BASE_HEX,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_First,
          { "First", "atsvc.DaysOfMonth.First", FT_BOOLEAN, 32,
          TFS(&First_tfs), 0x00000001,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Second,
          { "Second", "atsvc.DaysOfMonth.Second", FT_BOOLEAN, 32,
          TFS(&Second_tfs), 0x00000002,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Third,
          { "Third", "atsvc.DaysOfMonth.Third", FT_BOOLEAN, 32,
          TFS(&Third_tfs), 0x00000004,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Fourth,
          { "Fourth", "atsvc.DaysOfMonth.Fourth", FT_BOOLEAN, 32,
          TFS(&Fourth_tfs), 0x00000008,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Fifth,
          { "Fifth", "atsvc.DaysOfMonth.Fifth", FT_BOOLEAN, 32,
          TFS(&Fifth_tfs), 0x00000010,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Sixth,
          { "Sixth", "atsvc.DaysOfMonth.Sixth", FT_BOOLEAN, 32,
          TFS(&Sixth_tfs), 0x00000020,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Seventh,
          { "Seventh", "atsvc.DaysOfMonth.Seventh", FT_BOOLEAN, 32,
          TFS(&Seventh_tfs), 0x00000040,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Eight,
          { "Eight", "atsvc.DaysOfMonth.Eight", FT_BOOLEAN, 32,
          TFS(&Eight_tfs), 0x00000080,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Ninth,
          { "Ninth", "atsvc.DaysOfMonth.Ninth", FT_BOOLEAN, 32,
          TFS(&Ninth_tfs), 0x00000100,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Tenth,
          { "Tenth", "atsvc.DaysOfMonth.Tenth", FT_BOOLEAN, 32,
          TFS(&Tenth_tfs), 0x00000200,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Eleventh,
          { "Eleventh", "atsvc.DaysOfMonth.Eleventh", FT_BOOLEAN, 32,
          TFS(&Eleventh_tfs), 0x00000400,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twelfth,
          { "Twelfth", "atsvc.DaysOfMonth.Twelfth", FT_BOOLEAN, 32,
          TFS(&Twelfth_tfs), 0x00000800,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Thitteenth,
          { "Thitteenth", "atsvc.DaysOfMonth.Thitteenth", FT_BOOLEAN, 32,
          TFS(&Thitteenth_tfs), 0x00001000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Fourteenth,
          { "Fourteenth", "atsvc.DaysOfMonth.Fourteenth", FT_BOOLEAN, 32,
          TFS(&Fourteenth_tfs), 0x00002000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Fifteenth,
          { "Fifteenth", "atsvc.DaysOfMonth.Fifteenth", FT_BOOLEAN, 32,
          TFS(&Fifteenth_tfs), 0x00004000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Sixteenth,
          { "Sixteenth", "atsvc.DaysOfMonth.Sixteenth", FT_BOOLEAN, 32,
          TFS(&Sixteenth_tfs), 0x00008000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Seventeenth,
          { "Seventeenth", "atsvc.DaysOfMonth.Seventeenth", FT_BOOLEAN, 32,
          TFS(&Seventeenth_tfs), 0x00010000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Eighteenth,
          { "Eighteenth", "atsvc.DaysOfMonth.Eighteenth", FT_BOOLEAN, 32,
          TFS(&Eighteenth_tfs), 0x00020000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Ninteenth,
          { "Ninteenth", "atsvc.DaysOfMonth.Ninteenth", FT_BOOLEAN, 32,
          TFS(&Ninteenth_tfs), 0x00040000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyth,
          { "Twentyth", "atsvc.DaysOfMonth.Twentyth", FT_BOOLEAN, 32,
          TFS(&Twentyth_tfs), 0x00080000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyfirst,
          { "Twentyfirst", "atsvc.DaysOfMonth.Twentyfirst", FT_BOOLEAN, 32,
          TFS(&Twentyfirst_tfs), 0x00100000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentysecond,
          { "Twentysecond", "atsvc.DaysOfMonth.Twentysecond", FT_BOOLEAN, 32,
          TFS(&Twentysecond_tfs), 0x00200000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentythird,
          { "Twentythird", "atsvc.DaysOfMonth.Twentythird", FT_BOOLEAN, 32,
          TFS(&Twentythird_tfs), 0x00400000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyfourth,
          { "Twentyfourth", "atsvc.DaysOfMonth.Twentyfourth", FT_BOOLEAN, 32,
          TFS(&Twentyfourth_tfs), 0x00800000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyfifth,
          { "Twentyfifth", "atsvc.DaysOfMonth.Twentyfifth", FT_BOOLEAN, 32,
          TFS(&Twentyfifth_tfs), 0x01000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentysixth,
          { "Twentysixth", "atsvc.DaysOfMonth.Twentysixth", FT_BOOLEAN, 32,
          TFS(&Twentysixth_tfs), 0x02000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyseventh,
          { "Twentyseventh", "atsvc.DaysOfMonth.Twentyseventh", FT_BOOLEAN, 32,
          TFS(&Twentyseventh_tfs), 0x04000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyeighth,
          { "Twentyeighth", "atsvc.DaysOfMonth.Twentyeighth", FT_BOOLEAN, 32,
          TFS(&Twentyeighth_tfs), 0x08000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Twentyninth,
          { "Twentyninth", "atsvc.DaysOfMonth.Twentyninth", FT_BOOLEAN, 32,
          TFS(&Twentyninth_tfs), 0x10000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Thirtieth,
          { "Thirtieth", "atsvc.DaysOfMonth.Thirtieth", FT_BOOLEAN, 32,
          TFS(&Thirtieth_tfs), 0x20000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfMonth_Thirtyfirst,
          { "Thirtyfirst", "atsvc.DaysOfMonth.Thirtyfirst", FT_BOOLEAN, 32,
          TFS(&Thirtyfirst_tfs), 0x40000000,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Monday,
          { "Monday", "atsvc.DaysOfWeek.Monday", FT_BOOLEAN, 8,
          TFS(&Monday_tfs), 0x01,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Tuesday,
          { "Tuesday", "atsvc.DaysOfWeek.Tuesday", FT_BOOLEAN, 8,
          TFS(&Tuesday_tfs), 0x02,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Wednesday,
          { "Wednesday", "atsvc.DaysOfWeek.Wednesday", FT_BOOLEAN, 8,
          TFS(&Wednesday_tfs), 0x04,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Thursday,
          { "Thursday", "atsvc.DaysOfWeek.Thursday", FT_BOOLEAN, 8,
          TFS(&Thursday_tfs), 0x08,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Friday,
          { "Friday", "atsvc.DaysOfWeek.Friday", FT_BOOLEAN, 8,
          TFS(&Friday_tfs), 0x10,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Saturday,
          { "Saturday", "atsvc.DaysOfWeek.Saturday", FT_BOOLEAN, 8,
          TFS(&Saturday_tfs), 0x20,
         "", HFILL }},

        { &hf_atsvc_DaysOfWeek_Sunday,
          { "Sunday", "atsvc.DaysOfWeek.Sunday", FT_BOOLEAN, 8,
          TFS(&Sunday_tfs), 0x40,
         "", HFILL }},

        { &hf_atsvc_Flags_JOB_RUN_PERIODICALLY,
          { "JOB_RUN_PERIODICALLY", "atsvc.Flags.JOB_RUN_PERIODICALLY", FT_BOOLEAN, 8,
          TFS(&JOB_RUN_PERIODICALLY_tfs), 0x01,
         "", HFILL }},

        { &hf_atsvc_Flags_JOB_EXEC_ERROR,
          { "JOB_EXEC_ERROR", "atsvc.Flags.JOB_EXEC_ERROR", FT_BOOLEAN, 8,
          TFS(&JOB_EXEC_ERROR_tfs), 0x02,
         "", HFILL }},

        { &hf_atsvc_Flags_JOB_RUNS_TODAY,
          { "JOB_RUNS_TODAY", "atsvc.Flags.JOB_RUNS_TODAY", FT_BOOLEAN, 8,
          TFS(&JOB_RUNS_TODAY_tfs), 0x04,
         "", HFILL }},

        { &hf_atsvc_Flags_JOB_ADD_CURRENT_DATE,
          { "JOB_ADD_CURRENT_DATE", "atsvc.Flags.JOB_ADD_CURRENT_DATE", FT_BOOLEAN, 8,
          TFS(&JOB_ADD_CURRENT_DATE_tfs), 0x08,
         "", HFILL }},

        { &hf_atsvc_Flags_JOB_NONINTERACTIVE,
          { "JOB_NONINTERACTIVE", "atsvc.Flags.JOB_NONINTERACTIVE", FT_BOOLEAN, 8,
          TFS(&JOB_NONINTERACTIVE_tfs), 0x10,
         "", HFILL }},

        { &hf_atsvc_JobInfo_days_of_month,
          { "days_of_month", "atsvc.JobInfo.days_of_month", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobInfo_days_of_week,
          { "days_of_week", "atsvc.JobInfo.days_of_week", FT_UINT8, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobInfo_flags,
          { "flags", "atsvc.JobInfo.flags", FT_UINT8, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobInfo_command,
          { "command", "atsvc.JobInfo.command", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobAdd_servername,
          { "servername", "atsvc.JobAdd.servername", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobAdd_job_info,
          { "job_info", "atsvc.JobAdd.job_info", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobDel_servername,
          { "servername", "atsvc.JobDel.servername", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobDel_min_job_id,
          { "min_job_id", "atsvc.JobDel.min_job_id", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobDel_max_job_id,
          { "max_job_id", "atsvc.JobDel.max_job_id", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnumInfo_days_of_month,
          { "days_of_month", "atsvc.JobEnumInfo.days_of_month", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnumInfo_days_of_week,
          { "days_of_week", "atsvc.JobEnumInfo.days_of_week", FT_UINT8, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnumInfo_flags,
          { "flags", "atsvc.JobEnumInfo.flags", FT_UINT8, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnumInfo_command,
          { "command", "atsvc.JobEnumInfo.command", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_enum_ctr_entries_read,
          { "entries_read", "atsvc.enum_ctr.entries_read", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_enum_ctr_first_entry,
          { "first_entry", "atsvc.enum_ctr.first_entry", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnum_servername,
          { "servername", "atsvc.JobEnum.servername", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnum_ctr,
          { "ctr", "atsvc.JobEnum.ctr", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnum_preferred_max_len,
          { "preferred_max_len", "atsvc.JobEnum.preferred_max_len", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnum_total_entries,
          { "total_entries", "atsvc.JobEnum.total_entries", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobEnum_resume_handle,
          { "resume_handle", "atsvc.JobEnum.resume_handle", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobGetInfo_servername,
          { "servername", "atsvc.JobGetInfo.servername", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_atsvc_JobGetInfo_job_info,
          { "job_info", "atsvc.JobGetInfo.job_info", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

/* END OF INCLUDED FILE : ETH_HFARR */


	};

        static gint *ett[] = {


/* INCLUDED FILE : ETH_ETTARR */
        &ett_atsvc,
        &ett_atsvc_DaysOfMonth,
        &ett_atsvc_DaysOfWeek,
        &ett_atsvc_Flags,
        &ett_atsvc_JobInfo,
        &ett_atsvc_JobEnumInfo,
        &ett_atsvc_enum_ctr,
/* END OF INCLUDED FILE : ETH_ETTARR */


        };

        proto_atsvc = proto_register_protocol(
                "Microsoft Task Scheduler Service", 
		"ATSVC", "atsvc");
	proto_register_field_array(proto_atsvc, hf, array_length(hf));
        proto_register_subtree_array(ett, array_length(ett));
}

static dcerpc_sub_dissector function_dissectors[] = {


/* INCLUDED FILE : ETH_FT */
    { 0, "JobAdd",
        atsvc_dissect_JobAdd_request,
        atsvc_dissect_JobAdd_response },
    { 1, "JobDel",
        atsvc_dissect_JobDel_request,
        atsvc_dissect_JobDel_response },
    { 2, "JobEnum",
        atsvc_dissect_JobEnum_request,
        atsvc_dissect_JobEnum_response },
    { 3, "JobGetInfo",
        atsvc_dissect_JobGetInfo_request,
        atsvc_dissect_JobGetInfo_response },
/* END OF INCLUDED FILE : ETH_FT */


	{ 0, NULL, NULL, NULL },
};

void
proto_reg_handoff_atsvc(void)
{


/* INCLUDED FILE : ETH_HANDOFF */
    dcerpc_init_uuid(proto_atsvc, ett_atsvc,
        &uuid_dcerpc_atsvc, ver_atsvc,
        function_dissectors, hf_atsvc_opnum);
/* END OF INCLUDED FILE : ETH_HANDOFF */


}

