/* $USAGI: mn.c,v 1.26 2003/12/05 06:10:13 yoshfuji Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *      Noriaki TAKAMIYA @USAGI
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


#include <sys/types.h>
#include <asm/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <ifaddrs.h>
#include <arpa/inet.h>
#include <linux/netlink.h>
#include <linux/autoconf.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <linux/capability.h>
#include <linux/xfrm.h>
#include <bits/sockaddr.h>
#include <netinet/in.h>
#include <netinet/icmp6.h>

#include <mip6.h>
#include "mip6d.h"
#include "util.h"
#include "bul.h"


#define	MN_CONFIG	"/usr/local/v6/etc/mnd.conf"

#define	MIP6_BUL_HASH_SIZE	32
#define	NLMSG_BUF		512

#include <netinet/in.h>
#include "glue.h"

/*
 * mnd staff
 */
struct default_router {
	struct in6_addr dst;
	unsigned int ifindex;
	unsigned int reachable;
	unsigned int retransmit;
};

struct hoa_req {
	struct nlmsghdr	hdr;
	struct ifaddrmsg addrmsg;
};

struct mip6d_handle *mn_handle;
struct mip6d_conf *mn_conf;

extern void mip6_mn_set_policy(int dir, struct in6_addr *dst, struct in6_addr *src, __u8 proto, __u8 action, struct mip6d_handle *mp);


/*
 * set_current_coa
 */
void set_current_coa(struct nd_opt_prefix_info *pinfo)
{
	struct ifaddrs *ifap, *x;
	char addrbuf[INET6_ADDRSTRLEN];
	struct in6_addr *candidate;

	ifap = NULL;

	if (getifaddrs(&ifap) < 0)
		return;	/*XXX*/

	for(x = ifap; x; x = x->ifa_next) {
		if (x->ifa_addr->sa_family == PF_INET6) {
			candidate = &((struct sockaddr_in6 *)x->ifa_addr)->sin6_addr;
			if (!memcmp(candidate, &pinfo->nd_opt_pi_prefix, pinfo->nd_opt_pi_prefix_len / 8)) {
				memcpy(&mn_conf->coa, candidate, sizeof(struct in6_addr));
				printf("Setting current coa to %s\n",
					inet_ntop(PF_INET6, candidate, addrbuf, sizeof(addrbuf)));
			}
		}
	}

	freeifaddrs(ifap);
}

/*
 * when MN connects to the foreign link, route to homelink must be
 * deleted
 */
int mip6_mn_del_route(struct in6_addr *prefix, struct in6_addr *nexthop, int prefixlen)
{
	int sock;
	struct nlmsghdr *msghdr;
	struct rtmsg *rtmsg;
	struct rtattr *rta;
	char buf[2048];
	struct cmsghdr *cmsg;
	struct sockaddr_nl nladdr;
	int ret;
	int fromlen;
	char cbuf[100];

	sock = socket(PF_NETLINK, SOCK_RAW, NETLINK_ROUTE);

	if (sock < 0) {
		return 0;
	}

	memset(buf, 0, sizeof(buf));

	msghdr = (struct nlmsghdr *)buf;

	msghdr->nlmsg_type = RTM_DELROUTE;
	msghdr->nlmsg_flags = NLM_F_REQUEST|NLM_F_ACK;


	rtmsg = (struct rtmsg *)(NLMSG_DATA(msghdr));
	rtmsg->rtm_family = PF_INET6;
	rtmsg->rtm_type = RTN_LOCAL || RTN_BROADCAST;
	rtmsg->rtm_dst_len = prefixlen;
	rtmsg->rtm_scope = RT_SCOPE_UNIVERSE;

	rta = (struct rtattr *)(buf + NLMSG_LENGTH(sizeof(struct rtmsg)));
	rta->rta_type = RTA_DST;
	rta->rta_len = RTA_LENGTH(sizeof(struct in6_addr));
	memcpy(RTA_DATA(rta), prefix, prefixlen / 8);
printf("delete: %s\n", inet_ntop(PF_INET6, RTA_DATA(rta), cbuf, 100));
	printf("length = %d\n", sizeof(struct nlmsghdr) + sizeof(struct rtmsg) +  sizeof(struct rtattr) + sizeof(struct in6_addr));

	msghdr->nlmsg_len = NLMSG_LENGTH(sizeof(struct rtmsg) + sizeof(struct rtattr) + sizeof(struct in6_addr));

	if (nexthop) {
		rta = (struct rtattr *)(rta + RTA_LENGTH(sizeof(struct in6_addr)));
		rta->rta_type = RTA_GATEWAY;
		rta->rta_len = RTA_LENGTH(sizeof(struct in6_addr));
		memcpy(RTA_DATA(rta), nexthop, sizeof(struct in6_addr));
		msghdr->nlmsg_len += rta->rta_len;
	}

	memset(&nladdr, 0, sizeof(struct sockaddr_nl));
	nladdr.nl_family = PF_NETLINK;

	ret = sendto(sock, buf, msghdr->nlmsg_len, 0, (struct sockaddr *)&nladdr, sizeof(struct sockaddr_nl));
	printf("%s: ret = %d\n", __FUNCTION__, ret);

	fromlen = sizeof(struct sockaddr_nl);
	ret = recvfrom(sock, buf, sizeof(buf), 0, (struct sockaddr *)&nladdr, &fromlen);
	printf("%s: ret = %d, msghdr->nlmsg_type  = %d\n", __FUNCTION__, ret, msghdr->nlmsg_type);
	close(sock);
}

/*
 * flush all xfrm_bundles
 */
int mip6_mn_dst_flush()
{
	int s;
	int ret;
	struct nlmsghdr nlmsg;
	struct sockaddr_nl nladdr;

	memset(&nladdr, 0, sizeof(struct sockaddr_nl));
	nladdr.nl_family = PF_NETLINK;

	memset(&nlmsg, 0, sizeof(struct nlmsghdr));
#if 0
	nlmsg.nlmsg_type = XFRM_MSG_MIP6FLUSHDST;
#endif
	nlmsg.nlmsg_flags  = NLM_F_REQUEST;
	nlmsg.nlmsg_len  = NLMSG_LENGTH(0);

	ret = sendto(mn_handle->nlxfrm_sock, &nlmsg, nlmsg.nlmsg_len, 0, (struct sockaddr_nl *)&nladdr, sizeof(struct sockaddr_nl));

}

/*
 * flush all existing neighbour cache
 */
int mip6_mn_neigh_flush()
{
	int s;

}


void mip6_mn_get_coa(struct in6_addr *coa)
{
	memcpy(coa, &mn_conf->coa, sizeof(struct in6_addr));
}


/*
 * get home address of this node
 */
int get_home_addr(struct in6_addr *hoa, int *ifindex, struct mip6d_handle *mp)
{
	int			s;
	unsigned char		buf[NLMSG_BUF];
	struct msghdr		msg;
	struct iovec		iov; 
	struct hoa_req		*req;
	struct sockaddr_nl	nladdr;
	struct nlmsghdr		*nlmsghdr;
	int			nlmsghdr_len;
	struct ifaddrmsg	*addrmsg;
	struct rtattr		*rta;
	int			rta_len;

	memset(&nladdr, 0, sizeof(struct sockaddr_nl));
	nladdr.nl_family = PF_NETLINK;

	memset(buf, 0, NLMSG_BUF);

	req = (struct hoa_req *)buf;
	req->hdr.nlmsg_len = NLMSG_LENGTH(sizeof(struct ifaddrmsg));
	req->hdr.nlmsg_flags = NLM_F_MATCH|NLM_F_REQUEST;
	req->hdr.nlmsg_type = RTM_GETADDR;
	req->addrmsg.ifa_family = PF_INET6;
	req->addrmsg.ifa_flags = IFA_F_HOMEADDRESS;

	msg.msg_name = &nladdr;
	msg.msg_namelen = sizeof(struct sockaddr_nl);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;
	iov.iov_base = buf;
	iov.iov_len = NLMSG_BUF;

	if (!sendmsg(mp->nlroute_sock, &msg, 0)) {
#ifdef DEBUG
		perror("sendmsg");
#endif
		return 0;
	}

	if (!recvmsg(mp->nlroute_sock, &msg, 0)) {
#ifdef DEBUG
		perror("recvmsg");
#endif
		return 0;
	}

	if (req->hdr.nlmsg_type == NLMSG_ERROR) {
		return 0;
	}

	nlmsghdr = &req->hdr;
	nlmsghdr_len = nlmsghdr->nlmsg_len;

	while(NLMSG_OK(nlmsghdr, nlmsghdr_len)) {
		addrmsg = NLMSG_DATA(nlmsghdr);
		if (addrmsg->ifa_flags | IFA_F_HOMEADDRESS) {
			rta = IFA_RTA(addrmsg);
			rta_len = NLMSG_PAYLOAD(nlmsghdr, sizeof(struct ifaddrmsg));
			while(RTA_OK(rta, rta_len)) {
				if (rta->rta_type == IFA_ADDRESS) {
					memcpy(hoa, RTA_DATA(rta), sizeof(struct in6_addr));
					*ifindex = addrmsg->ifa_index;
					close(s);
					return 1;
				}
				rta = RTA_NEXT(rta, rta_len);
			}
		}
		nlmsghdr = NLMSG_NEXT(nlmsghdr, nlmsghdr_len);
	}
	return 0;
}



/*
 * set home address of this node
 */
int set_home_addr(struct in6_addr *hoa, int ifindex)
{
	int s;
	unsigned char		buf[NLMSG_BUF];
	struct msghdr		msg;
	struct iovec		iov; 
	struct hoa_req		*req;
	struct sockaddr_nl	nladdr;
	struct nlmsghdr		*nlmsghdr;
	int			nlmsghdr_len;
	struct ifaddrmsg	*addrmsg;
	struct rtattr		*rta;
	int			rta_len;
	
	memset(&nladdr, 0, sizeof(struct sockaddr_nl));
	nladdr.nl_family = PF_NETLINK;

	memset(buf, 0, NLMSG_BUF);

	req = (struct hoa_req *)buf;
	req->hdr.nlmsg_len = NLMSG_LENGTH(sizeof(struct ifaddrmsg));
	req->hdr.nlmsg_flags = NLM_F_REQUEST;
	req->hdr.nlmsg_type = RTM_NEWADDR;
	req->addrmsg.ifa_family = PF_INET6;
	req->addrmsg.ifa_flags = IFA_F_HOMEADDRESS;
	req->addrmsg.ifa_index = ifindex;
	rta = (struct rtattr *)(buf + NLMSG_LENGTH(sizeof(struct ifaddrmsg)));
	rta->rta_type = IFA_ADDRESS;
	rta->rta_len = sizeof(struct in6_addr);
	memcpy(RTA_DATA(rta), hoa, sizeof(struct in6_addr));

	msg.msg_name = &nladdr;
	msg.msg_namelen = sizeof(struct sockaddr_nl);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;
	iov.iov_base = buf;
	iov.iov_len = NLMSG_BUF;

	if (!sendmsg(mn_handle->nlroute_sock, &msg, 0)) {
#ifdef DEBUG
		perror("sendmsg");
#endif
		return 0;
	}
#if 0
	if (!recvmsg(mp->nlroute_sock, &msg, 0)) {
#ifdef DEBUG
		perror("recvmsg");
#endif
		return 0;
	}

	if (req->hdr.nlmsg_type == NLMSG_ERROR) {
		return 0;
	}

	nlmsghdr = &req->hdr;
	nlmsghdr_len = nlmsghdr->nlmsg_len;

	while(NLMSG_OK(nlmsghdr, nlmsghdr_len)) {
		addrmsg = NLMSG_DATA(nlmsghdr);
		if (addrmsg->ifa_flags | IFA_F_HOMEADDRESS) {
			rta = IFA_RTA(addrmsg);
			rta_len = NLMSG_PAYLOAD(nlmsghdr, sizeof(struct ifaddrmsg));
			while(RTA_OK(rta, rta_len)) {
				if (rta->rta_type == IFA_ADDRESS) {
					memcpy(hoa, RTA_DATA(rta), sizeof(struct in6_addr));
					*ifindex = addrmsg->ifa_index;
					close(s);
					return 1;
				}
				rta = RTA_NEXT(rta, rta_len);
			}
		}
		nlmsghdr = NLMSG_NEXT(nlmsghdr, nlmsghdr_len);
	}
#endif
	return 0;
}


/*
 * home agent list in Mobile Node
 *
 * the first entry is the current Home Agent, and the rest is the candidates.
 */
struct halist_entry {
	struct list_head	list;
	struct in6_addr		ha_addr;
	unsigned char		prefixlen;
};

#define	BUFLEN	8192

struct info_req {
	struct nlmsghdr		hdr;
	struct ifinfomsg	ifa;
	char			buf[BUFLEN];
};

struct addr_req {
	struct nlmsghdr		hdr;
	struct ifaddrmsg	ifa;
	char			buf[BUFLEN];
};

int dhaad_identifier = 0;
LIST_HEAD(halist);
struct default_router	*current_router = NULL;
struct mip6_bul		*bul;

void make_dhaad_anycast(struct in6_addr *hoa, struct in6_addr *anycast)
{
	memcpy(anycast, hoa, 16);
	anycast->s6_addr32[2] = htonl(0xfdffffff);
	anycast->s6_addr32[3] = htonl(0xfffffffe);
}

int send_dhaad_request()
{
	struct sockaddr_in6 dst;
	struct sockaddr_in6 src;
	struct sockaddr *to;
	struct in6_addr *anycast;
	unsigned char	req_msg[DHAAD_REQ_SIZE];
	struct dhaad_req *req = (struct dhaad_req *)req_msg;
	char cbuf[100];
	int ret;

	/* delete reoute to home */
	ret = mip6_mn_del_route(&mn_conf->hoa, NULL, 64);
#if 0
	ret = mip6_mn_dst_flush(mn_conf);
#endif

	printf("delete route %d\n", ret);
	memset(&dst, 0, sizeof(dst));
	memset(&src, 0, sizeof(src));
	memset(req_msg, 0, DHAAD_REQ_SIZE);

	req->type = ICMPV6_DHAAD_REQUEST;
	req->identifier = htons(dhaad_identifier++);

	make_dhaad_anycast(&mn_conf->hoa, &(dst.sin6_addr));

#ifdef DEBUG
	{
		char buf[100];
		printf("sending dhaad to %s\n",
			inet_ntop(AF_INET6, &dst.sin6_addr, buf, sizeof(buf)));
	}
#endif
	
	dst.sin6_family = AF_INET6;
	dst.sin6_port = htons(IPPROTO_ICMPV6);
	dst.sin6_flowinfo = 0;
	dst.sin6_scope_id = 0;

	src.sin6_family = AF_INET6;
	src.sin6_port = htons(IPPROTO_ICMPV6);
	src.sin6_flowinfo = 0;
	src.sin6_scope_id = 0;
	memcpy(&src.sin6_addr, &mn_conf->coa, sizeof(struct in6_addr));
	bind(mn_handle->icmp_sock, &src, sizeof(struct sockaddr_in6));
printf("src = %s\n", inet_ntop(PF_INET6, &src.sin6_addr, cbuf, sizeof(cbuf)));

	to = (struct sockaddr *)&dst;
	ret = sendto(mn_handle->icmp_sock, req_msg, DHAAD_REQ_SIZE, 0, to, sizeof(struct sockaddr_in6));
printf("ret = %d\n", ret);
	return 0;
}

int movement_detection(struct mip6_msg_info *msg_info, unsigned char *msg_data, int datalen)
{

	struct nd_router_advert *ra_msg;
	struct nd_opt_hdr *opt;
	struct nd_opt_prefix_info *pinfo;
	struct in6_addr *prefix;
	unsigned char *p;
	int optlen;
	struct in6_addr default_entry;

	unsigned int		reachable;
	unsigned int		retrans;


	/*
	 * check whether the default router is changed or not
	 */
	p = msg_data;
	ra_msg = (struct nd_router_advert *)p;
#ifdef DEBUG
	{
		char ifname[IF_NAMESIZE];
		if_indextoname(msg_info->pktinfo->ipi6_ifindex, ifname);
		printf("RA is received from interface %s\n", ifname);
	}
#endif
	if (current_router == NULL) {
		/*
		 * initialization
		 */
		current_router = (struct default_router *)malloc(sizeof(struct default_router));
		if (current_router == NULL) {
			return -1;
		}

		memset(current_router, 0, sizeof(struct default_router));
		memcpy(&current_router->dst, &msg_info->from_addr.sin6_addr,
			sizeof(struct in6_addr));
		current_router->reachable = ntohl(ra_msg->nd_ra_reachable);
		current_router->retransmit = ntohl(ra_msg->nd_ra_retransmit);
		current_router->ifindex = msg_info->pktinfo->ipi6_ifindex;
	} else {
		/*
		 * check the sender IP address
		 */
		if (memcmp(&(current_router->dst), &(msg_info->from_addr.sin6_addr), sizeof(struct in6_addr))) {
			/*
			 * default router is changed
			 */
#ifdef DEBUG
			printf("default router is changed\n");
			printf("old default router is removed\n");
#endif
#if 0
			memset(&default_entry, 0, sizeof(struct in6_addr));
			mip6_mn_del_route(&default_entry, &current_router->dst, 0);
#endif

			memcpy(&current_router->dst, &msg_info->from_addr.sin6_addr, sizeof(struct in6_addr));
			current_router->reachable = ntohl(ra_msg->nd_ra_reachable);
			current_router->retransmit = ntohl(ra_msg->nd_ra_retransmit);
			current_router->ifindex = msg_info->pktinfo->ipi6_ifindex;
		} else {
			/*
			 * update with new value
			 */
			current_router->reachable = ntohl(ra_msg->nd_ra_reachable);
			current_router->retransmit = ntohl(ra_msg->nd_ra_retransmit);
#ifdef DEBUG
			printf("default router is not changed\n");
#endif
		}
	}
#ifdef DEBUG
	printf("default router is %04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x\n",
		NIP6(current_router->dst));
	printf("inteface index is %d\n", current_router->ifindex);
	printf("type = %d\n", ra_msg->nd_ra_type);
#endif
	/*
	 * check prefix information of RA
	 */
	optlen = datalen - sizeof(struct nd_router_advert);
	p += sizeof(struct nd_router_advert);

	while(optlen > 0) {
		switch(*p) {
		case ND_OPT_PREFIX_INFORMATION:
			pinfo = (struct nd_opt_prefix_info *)p;
			prefix = &(pinfo->nd_opt_pi_prefix);

#ifdef DEBUG
			{
				char buf[100];
				printf("prefix = %s\n", inet_ntop(AF_INET6, prefix, buf, sizeof(buf)));
			}
#endif

			/* set care-of address */
			set_current_coa(pinfo);

			break;
		default:
			printf("nd option = %d\n", *p);
			break;
		}
		optlen -= (*(p+1) << 3);
		p += (*(p+1) << 3);
	}

	if (memcmp(prefix, &mn_conf->hoa, 8) == 0) {
		/*
		 * in the Home Link
		 */
#ifdef DEBUG
		printf("return to home or, existing home\n");
#endif
		deregistration();
	} else {
		/*
		 * in the foreign link
		 */
#ifdef DEBUG
		printf("moved to another link\n");
#endif
		move(pinfo);
	}
}

int home_registration()
{
	struct mip6_bul_entry *entry;
	struct in6_addr hoa;
	struct in6_addr coa;
	int len;
	int padlen;
	unsigned char *buf = NULL;
	struct mip6_mh_hdr *mh_hdr;
	struct mip6_mh_bu *bumsg;
	int offset;
	struct in6_addr *ha;
	struct sockaddr_in6 dst;
	int ret;

	/* delete reoute to home */
	ret = mip6_mn_del_route(&mn_conf->hoa, NULL, 64);
#if 0
	ret = mip6_mn_dst_flush(mn_conf);
#endif
	printf("delete route %d\n", ret);

	entry = mip6_get_bul_entry(&mn_handle->conf->ha_addr, MIP6_BUL_CREATE);
	if (!entry)
		return 0;

#ifdef DEBUG
	printf("this is the home registration\n");
#endif

	/*
	 * set the state for BUL
	 */
	entry->state |= MIP6_DONT_RR;

	mip6_send_bu(entry);
}

int mip6_mn_same_iid()
{
	return ((mn_conf->coa.s6_addr32[2]
			== mn_conf->hoa.s6_addr32[2]) &&
		(mn_conf->coa.s6_addr32[3]
			== mn_conf->hoa.s6_addr32[3]));
}

int update_bul()
{
}

/*
 * return the current HA address
 */
struct in6_addr *get_current_ha()
{
	if (halist.next == &halist)
		return NULL;

	return &(((struct halist_entry *)(halist.next))->ha_addr);
}
/*
 * start to move
 * start Home Registration to HA.
 */
int move(struct nd_opt_prefix_info *pinfo)
{

	int ret;
	struct in6_addr	*current_ha;

	current_ha = get_current_ha();


	if (current_ha == NULL) {
		/*
		 * Need to start DHAAD
		 */
#ifdef DEBUG
		printf("I don't have my home agent.\n");
#endif
		return send_dhaad_request();
	}

	ret = home_registration();

	if (ret) {
		/*
		 * Update current Binding Update List
		 */
		update_bul();
	}
	
}


/*
 * deregistration
 *
 * 1) delete current routing policy in the kernel.
 * 2) send BU to delete BCE in the HA/CN.
 * 3) delete BUL entry in the daemon.
 */
int deregistration()
{
#if 0
	int i;
	struct list_head *current;
	struct list_head *list_end;
	struct mip6_bul_entry *entry;

	/*
	 * delete the existing entries
	 */
	if (bul) {
		for(i = 0; i < MIP6_BUL_HASH_SIZE; i++) {
			list_end = bul->entry_table[i].prev;

			for(current = bul->entry_table[i].next;
			    current != list_end;
			    current = current->next) {
				/*
				 * send BU to deregistration
				mip6_send_bu(current);
				 */
				list_del(current);
			}
		}
	}
#endif
}


void mip6_mn_dump_halist()
{
	struct halist_entry *entry;
	char buf[100];
	int i = 0;

	printf("===================\n");
	list_for_each(((struct list_head *)entry), ((struct list_head *)&halist)) {
		printf("home agent[%d] = %s\n", i, inet_ntop(PF_INET6, &entry->ha_addr, buf, sizeof(buf))); 
		i++;
	}
	if (!i) {
		printf("halist is NULL\n");
	}
	printf("===================\n");
}

int mip6_mn_add_halist(struct in6_addr *candidate)
{
	struct halist_entry *entry;
	struct halist_entry *x;
	struct list_head *end;
	struct halist_entry *current;
	int found = 0;

	entry = (struct halist_entry *)malloc(sizeof(struct halist_entry));
	if (entry == NULL) {
		printf("Failed to create new entry\n");
		return -1;
	}
	memset(entry, 0, sizeof(struct halist_entry));
	memcpy(&(entry->ha_addr), candidate, 16);
{
	char buf[100];
printf("%s(%d): %s\n", __FUNCTION__, __LINE__, inet_ntop(PF_INET6, candidate, buf, sizeof(buf)));
printf("%s(%d): %s\n", __FUNCTION__, __LINE__, inet_ntop(PF_INET6, &entry->ha_addr, buf, sizeof(buf)));
}
	entry->prefixlen = 64;

	list_for_each(((struct list_head *)x), ((struct list_head *)&halist)) {
		if (!memcmp(candidate, &x->ha_addr, 16)) {
			found = 1;
			break;
		}
	}

	if (!found)
		list_add_tail(((struct list_head *)entry), ((struct list_head *)&halist));

#ifdef DEBUG
	mip6_mn_dump_halist();
#endif

	return 0;
}


int process_mh(int s)
{
}
int process_netlink(int s)
{
	struct msghdr	msg;
	struct iovec	iov;
	struct info_req	*addr;
	unsigned char	buf[BUFLEN];
	int ret;
	struct nlmsghdr *p;
	struct ifinfomsg	*get_addr;
	struct rtattr	*rta;
	int		len;

	addr = (struct info_req *)buf;

	memset(addr, 0, BUFLEN);
	memset(&msg, 0, sizeof(msg));

/*
	msg.msg_name = &nladdr;
	msg.msg_namelen = sizeof(nladdr);
*/
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;
	iov.iov_base = addr;
	iov.iov_len = sizeof(*addr);

	addr->hdr.nlmsg_len = NLMSG_LENGTH(sizeof(struct ifaddrmsg));
	addr->hdr.nlmsg_flags =  NLM_F_ROOT|NLM_F_REQUEST;
	addr->hdr.nlmsg_type = RTM_GETLINK;
	addr->ifa.ifi_family = PF_INET6;

	ret = recvmsg(s, &msg, BUFLEN);
	printf("recvmsg:ret = %d\n", ret);

	if (ret > 0) {
		p = &addr->hdr;
		while(NLMSG_OK(p, ret)) {
			printf("p = %x\n", p);
			printf("nlmsg_type = %x\n", p->nlmsg_type);
			printf("nlmsg_len = %x\n", p->nlmsg_len);
			get_addr = NLMSG_DATA(p);
			printf("ifi_family = %d\n", get_addr->ifi_family);
			printf("ifi_flags = %x\n", get_addr->ifi_flags);

			rta = IFLA_RTA(get_addr);
			len = p->nlmsg_len - NLMSG_LENGTH(sizeof(*get_addr));
			printf("len = %d\n", len);
			while(RTA_OK(rta, len)) {
				unsigned int mtu;
				printf("rta_len = %d\n", rta->rta_len);
				printf("rta_type = %d\n", rta->rta_type);
				switch(rta->rta_type) {
				case IFLA_MTU:
					mtu = *(unsigned int *)RTA_DATA(rta);
					printf("MTU = %u\n", mtu);
					break;
				case IFLA_IFNAME:
					printf("interface = %s\n", RTA_DATA(rta));
				}
				rta = RTA_NEXT(rta, len);
			}
			printf("------------------------------\n");
			p = NLMSG_NEXT(p, ret);
		}

	}
}

/* XXX: glue code... */

static int mn_init(struct mip6d_handle *mp)
{
	mip6_mn_bul_init();
	return 0;
}

static void mn_fini(struct mip6d_handle *mp)
{
}

static int mn_observe(struct mip6d_handle *mp)
{
	/*
	 * check bul entry
	 */
	mip6_bu_observe(mp);
	return 0;
}

#if 0
static int mn_nlroute_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	return 0;
}

static int mn_nlxfrm_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	printf("hoge\n");
	return 0;
}

static int mn_mh_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
		       struct mip6_mh_hdr *mh, size_t len)
{
        int err_code = 0;

	switch(mh->type) {
        case MIP6_MH_BRR:
		break;
        case MIP6_MH_HOTI:
		break;
        case MIP6_MH_COTI:
		break;
        case MIP6_MH_HOT:
		break;
        case MIP6_MH_COT:
		break;
        case MIP6_MH_BU:
		break;
        case MIP6_MH_BA:
                err_code = mip6d_ba_input(mp, msg_info, mh, len);
		break;
        case MIP6_MH_BE:
		break;
        default:
		err_code = -EINVAL;
        }

 fin:
	return err_code;
}
#endif

/*
 * ICMPv6 handler for Mobile Node
 */
int mn_icmp_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
		struct icmp6_hdr *data, int len)
{
	int ret;
	unsigned char	*p;
	struct in6_addr *candidate;
	struct sockaddr_in6 from;
	socklen_t from_len;
	struct dhaad_rep *reply;
	struct in6_addr anycast;
	struct sockaddr_in6 dst;
	char rep_msg[BUFLEN];
	struct icmp6_hdr *hdr;
	struct nd_router_advert *ra_msg;
	struct in6_pktinfo *pktinfo;
	struct msghdr	msg;
	struct cmsghdr	*cmsg;
	struct iovec	iov;
	struct info_req	*addr;
	unsigned char	buf[BUFLEN];
	unsigned char	cbuf[BUFLEN];

	hdr = data;
	printf("hdr->icmp6_type = %d\n", hdr->icmp6_type);

	switch(hdr->icmp6_type) {
	case ND_ROUTER_ADVERT:
		/*
		 * check the sender of RA
		 */
		movement_detection(msg_info, (unsigned char *)data, len);

		break;

	case ICMPV6_DHAAD_REPLY:

		/*
		 * set Home Agent
		 */
		reply = (struct dhaad_rep *)data;
#if 0
		if (ntohs(reply->identifier) != (dhaad_identifier - 1)) {
			printf("Invalid DHAAD Reply Identifier\n");
			return -1;
		}
#endif

		/*
		 * check the length of the message
		 * ret is ICMPv6 packet size
		 * ret - 8 is Home Agent list size
		 */
		len -= 8;
		if (len % 16) {
			printf("Invalid Home Agent Addresses entries\n");
			/*
			 * XXX: Our USAGI HA returns with garbage.
			 */
			return -1;
		}

		p = (unsigned char *)++data;
		if (len == 0) {
			/*
			 * don't exist any home agents.
			 */
#ifdef DEBUG
			printf("%s(%d): no contents in DHAAD reply.\n", __FUNCTION__, __LINE__);
#endif
			mip6_mn_add_halist(&(from.sin6_addr));
		} else {
#ifdef DEBUG
			printf("%s(%d): parse the contents.\n", __FUNCTION__, __LINE__);
#endif
			while(len > 0) {
				candidate = (struct in6_addr *)p;
				mip6_mn_add_halist(candidate);
				p += 16;
				len -= 16;
			}
			/*
			 * Home Registration
			 */
			home_registration();
		}
		break;
	default:
		break;
	}
	return 0;
}

int mn_register(struct mip6d_handle *mp)
{
	mp->init = mn_init;
	mp->fini = mn_fini;
	mp->observe = mn_observe;
#if 0
	mp->nlroute_input = mn_nlroute_input;
	mp->nlxfrm_input = mn_nlxfrm_input;
	mp->mh_input = mn_mh_input;
#endif
	mp->icmp_input = mn_icmp_input;

	mn_handle = mp;
	mn_conf = mp->conf;

	if (!ipv6_addr_any(&mp->conf->ha_addr))
		mip6_mn_add_halist(&mp->conf->ha_addr);

	return 0;
}
/*
 * sending binding update
 */
int mip6_send_bu(struct mip6_bul_entry *entry)
{
	int len;
	int base_len;
	unsigned char *buf;
	int padlen;
	struct mip6_mh_hdr *mh_hdr;
	struct mip6_mh_bu * bumsg;
	int offset;
	struct in6_addr *ha;
	struct sockaddr_in6 dst;
	struct mip6_mh_opt_alt_coa *altcoa;
	int ret;

	base_len = sizeof(struct mip6_mh_hdr) + sizeof(struct mip6_mh_bu);
	len = base_len;

	/* XXX: If Home Registration is protected by ESP,
	 * we need alt-coa option
	 */
	len += sizeof(struct mip6_mh_opt_alt_coa);

	/* Padding */
	padlen = mip6_align_padlen(len);
	len += padlen;

	/* make BU packets */
	buf = (unsigned char *)malloc(len);
	if (!buf) {
		return 0;
	}

        memset(buf, 0, len);
        mh_hdr = (struct mip6_mh_hdr *)buf;
        mh_hdr->nexthdr = IPPROTO_NONE;
        mh_hdr->hdrlen = len/8 - 1;
        mh_hdr->type = MIP6_MH_BU;

        bumsg = (struct mip6_mh_bu *)(buf + sizeof(struct mip6_mh_hdr));
        bumsg->seq = ntohs(entry->seq++);
        entry->bu_flags |= (MIP6_BU_F_ACK|MIP6_BU_F_HR);
        if (mip6_mn_same_iid())
                entry->bu_flags |= MIP6_BU_F_LL;

        bumsg->flags = entry->bu_flags;

        /* set initial timer */
        entry->retrans_timer = DEFAULT_INITIALBINDACKTIMEOUTFIRSTREG;

        /*
         * If the IID of link-local address is the same as that of HoA,
         * then L bit is on.
        bumsg->flags |= MIP6_BU_F_LL;
         */

        /*
         * Lifetime for home registration
         */
        bumsg->lifetime = htons(DEFAULT_HOME_REGISTRATION / 4);
        entry->init_lifetime = DEFAULT_HOME_REGISTRATION;
        time(&entry->sent_bu_time);
        /*
         * XXX:
         * If IKE is used to protect Home Registration, then K bit is on.
         * bumsg->flags |= MIP6_BU_F_KM;
         */

        /* align check sum field */
        offset = 4;
        setsockopt(mn_handle->mh_sock, IPPROTO_IPV6, IPV6_CHECKSUM, &offset, sizeof(offset));

	altcoa = (struct mip6_mh_opt_alt_coa *)(buf + base_len + mip6_fill_pad(buf+base_len, base_len, sizeof(struct mip6_mh_opt_alt_coa)));
	altcoa->type = MIP6_OPT_ALT_COA;
	altcoa->len = 16;
	memcpy(&altcoa->alt_coa, &mn_conf->coa, sizeof(struct in6_addr));

        /* get current home agent */
        ha = get_current_ha();

        /*
         * set the policy/state for home registration
         * 1) transmit BU/MPS using home address option.
         * 2) receive BA/MPA via routing header type 2.
         * 3) transmit/receive packet to/from CN via bi-directional tunnel.
         */
        mip6_mn_set_policy(XFRM_POLICY_OUT, ha, &mn_conf->hoa, IPPROTO_MOBILITY, IPPROTO_DSTOPTS, mn_handle);
        mip6_mn_set_policy(XFRM_POLICY_IN, ha, &mn_conf->hoa, IPPROTO_MOBILITY, IPPROTO_ROUTING, mn_handle);

        memset(&dst, 0, sizeof(struct sockaddr_in6));
        dst.sin6_family = PF_INET6;
        memcpy(&dst.sin6_addr, ha, sizeof(struct in6_addr));

        ret = sendto(mn_handle->mh_sock, buf, len, 0, (struct sockaddr *)&dst, sizeof(struct sockaddr_in6));
        printf("%s: ret = %d\n", __FUNCTION__, ret);
        if (ret < 0) perror("sendto");
	entry->state |= MIP6_BU_SENT;

}

/*
 * tunnel set up for MN-HA
 */
int mn_tunnel_update(struct mip6d_handle *mp, int add)
{
#ifdef DEBUG
	{
		char buf[100];
		printf("innser source = %s\n", inet_ntop(PF_INET6, &in6addr_any, buf, sizeof(buf)));
		printf("innser dest = %s\n", inet_ntop(PF_INET6, &mp->conf->hoa, buf, sizeof(buf)));
		printf("outer source = %s\n", inet_ntop(PF_INET6, &mp->conf->ha_addr, buf, sizeof(buf)));
		printf("outer dest = %s\n", inet_ntop(PF_INET6, &mp->conf->coa, buf, sizeof(buf)));
		}
#endif
	return mip6_tunnel_update(mp, &mp->conf->hoa, &in6addr_any, &mp->conf->coa, &mp->conf->ha_addr, add);
}

/*
 * tunnel set up for MN-HA
 */
int mn_tunnel_add(struct mip6d_handle *mp)
{
	return mn_tunnel_update(mp, 1);
}

/*
 * tunnel deletion 
 */
int mn_tunnel_del(struct mip6d_handle *mp)
{
	return mn_tunnel_update(mp, 0);
}


