/* $USAGI: mip6_xfrm.c,v 1.17 2003/11/20 03:06:58 takamiya Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <strings.h>
#include <unistd.h> /* getuid */
#include <sys/types.h> /* getuid */
#include <linux/autoconf.h>
#include <linux/xfrm.h>
#include <net/if.h>

#include <mip6.h>
#include <mip6nl.h>
#include "util.h"
#include "mip6d.h"

#define	BUFLEN 8192

#if 0
extern int mip_probe_handler_policy(const struct mip6nl_parms *mp, const struct xfrm_userpolicy_info *pol, struct mip6d_parms *parms);
extern int mip_probe_handler_state(const struct mip6nl_parms *mp, const struct xfrm_usersa_info *sa);
extern int mip_error_handler(const struct mip6nl_parms *mp, const struct nlmsghdr *hdr, int err);
#endif

/* set HA input policy */
extern struct mip6_hal ha_halist;
void mip6_ha_set_policy(int dir, __u8 proto, __u8 id_proto, struct mip6d_handle *handle)
{
	struct mip6d_conf	*conf = handle->conf;
	struct mip6nl_parms	nlparms;
	struct in6_addr		dst;
	int			datalen;
	char cbuf[100];
	char sendbuf[BUFLEN];
	int err;
	int data_len;
	struct mip6_hal_entry *entry = NULL, *x;
	struct in6_addr mylladdr;
	struct home_link_prefix *ha_addr;
	struct mip6nl_parms_id *id;

	entry = &ha_halist.entry_table[if_nametoindex(conf->home_link_dev)];
	if (!entry)
		return;

	memset(&nlparms, 0, sizeof(struct mip6nl_parms));
	mip6nl_init(&nlparms, handle->nlxfrm_sock);

#if 0
	inet_pton(PF_INET6, "fe80::290:ccff:fea3:71bd", &mylladdr);
#else
	__dprintf("trying to get lladdr...\n");
	if (in6_lladdr_get(&mylladdr, conf->home_link_dev) != 0) {
		__dprintf("trying to get lladdr... failed\n");
		return;
	}
	__dprintf("trying to get lladdr... done, lladdr = %s\n", in6_straddr(&mylladdr));
#endif


	list_for_each(((struct list_head *)x), ((struct list_head *)entry)) {
		if (!memcmp(&mylladdr, &x->laddr, sizeof(struct in6_addr))) {

			list_for_each(((struct list_head *)ha_addr), ((struct list_head *)&x->gaddr_list)) {

				if (dir == XFRM_POLICY_OUT) {
					memcpy(&nlparms.sel.saddr, &ha_addr->prefix, sizeof(struct in6_addr));
					if (!ipv6_addr_any(&conf->hoa)) {
						memcpy(&nlparms.sel.daddr, &conf->hoa, sizeof(struct in6_addr));
					} else {
						inet_pton(PF_INET6, "::", &nlparms.sel.daddr);
					}
				} else if (dir == XFRM_POLICY_IN) {
					memcpy(&nlparms.sel.daddr, &ha_addr->prefix, sizeof(struct in6_addr));
					if (!ipv6_addr_any(&conf->hoa)) {
						memcpy(&nlparms.sel.saddr, &conf->hoa, sizeof(struct in6_addr));
					} else {
						inet_pton(PF_INET6, "::", &nlparms.sel.saddr);
					}
				}

				/*
				 * XXX: tunnel is not supported
				if (proto == IPPROTO_IPV6) {
				memcpy(&nlparms.ip6_daddr, &nlparms.daddr, sizeof(struct in6_addr));
				memcpy(&nlparms.ip6_saddr, &nlparms.saddr, sizeof(struct in6_addr));
				 */
				nlparms.type = XFRM_MSG_NEWPOLICY;
				nlparms.flag |= NLM_F_ACK;
				nlparms.sel.proto = proto;		/* flow protocol */

				nlparms.error_handler = NULL;
				nlparms.probe_handler_policy = NULL;
				nlparms.probe_handler_state = NULL;
		
				nlparms.pol.dir = dir;

				err = mip6nl_verify(&nlparms);

				memset(sendbuf, 0, sizeof(sendbuf));

				id = &nlparms.id.tmpls[0];

				id->proto = id_proto;	/* action protocol */

				if (id_proto == IPPROTO_DSTOPTS) {
					inet_pton(PF_INET6, "::", &nlparms.id.ext.saddr);
					memcpy(&nlparms.id.ext.daddr, &ha_addr->prefix, sizeof(struct in6_addr));
				} else if (id_proto == IPPROTO_ROUTING) {
char buf[100];
printf("%s: coa = %s\n", __FUNCTION__, inet_ntop(PF_INET6, &conf->coa, buf, 100));
printf("%s: hoa = %s\n", __FUNCTION__, inet_ntop(PF_INET6, &conf->hoa, buf, 100));
					memcpy(&nlparms.id.ext.daddr, &conf->coa, sizeof(struct in6_addr));
					memcpy(&nlparms.id.ext.saddr, &ha_addr->prefix, sizeof(struct in6_addr));
				}

				mip6nl_talk(&nlparms);
	
				nlparms.type = XFRM_MSG_NEWSA;

				mip6nl_talk(&nlparms);
			}
		}
	}
}

/* set MN output policy */
void mip6_mn_set_policy(int dir, struct in6_addr *dst, struct in6_addr *src, __u8 proto, __u8 id_proto, struct mip6d_handle *handle)
{
	struct mip6d_conf	*conf = handle->conf;
	struct mip6nl_parms	parms;
	struct in6_addr		coa;
	int			datelen;
	struct mip6nl_parms_id *id;
	char cbuf[100];

	memset(&parms, 0, sizeof(struct mip6nl_parms));
	mip6nl_init(&parms, handle->nlxfrm_sock);

	if (dir == XFRM_POLICY_OUT) {
		memcpy(&parms.sel.daddr, dst, sizeof(struct in6_addr));
		memcpy(&parms.sel.saddr, src, sizeof(struct in6_addr));
	} else if (dir == XFRM_POLICY_IN) {
		memcpy(&parms.sel.daddr, src, sizeof(struct in6_addr));
		memcpy(&parms.sel.saddr, dst, sizeof(struct in6_addr));
	}

	parms.sel.proto = proto;		/* flow protocol */

#if 0
	if (proto == IPPROTO_IPV6) {
		memcpy(&parms.id.daddr, &parms.daddr, sizeof(struct in6_addr));
		memcpy(&parms.id.saddr, &parms.saddr, sizeof(struct in6_addr));
	}
#endif

	if (id_proto == IPPROTO_DSTOPTS) {
		memcpy(&parms.id.ext.saddr, &conf->coa, sizeof(struct in6_addr));
	}

	parms.type = XFRM_MSG_NEWPOLICY;

	parms.pol.dir = dir;
	parms.error_handler = NULL;
	parms.probe_handler_policy = NULL;
	parms.probe_handler_state = NULL;


	__dprintf("dst = %s\n", inet_ntop(PF_INET6, &parms.sel.daddr, cbuf, sizeof(cbuf)));
	__dprintf("src = %s\n", inet_ntop(PF_INET6, &parms.sel.saddr, cbuf, sizeof(cbuf)));
#if 0
	__dprintf("coa = %s\n", inet_ntop(PF_INET6, &parms.mip6_state.addr, cbuf, sizeof(cbuf)));
#else
	__dprintf("%s:coa = %s\n", __FUNCTION__, inet_ntop(PF_INET6, &parms.id.ext.saddr, cbuf, sizeof(cbuf)));
#endif

	/* template */
	id = &parms.id.tmpls[0];
	id->proto = id_proto;
	if (id->proto == IPPROTO_DSTOPTS)
		memcpy(&id->saddr, &parms.id.ext.saddr, sizeof(struct in6_addr));
	else if (id->proto == IPPROTO_ROUTING)
		memcpy(&id->daddr, &parms.id.ext.daddr, sizeof(struct in6_addr));

	mip6nl_talk(&parms);

	parms.type = XFRM_MSG_NEWSA;
#if 0
	/* struct xfrm_mip6_state is coa */
	mip6_mn_get_coa(&parms.mip6_state.addr);
#else
	if (id_proto == IPPROTO_DSTOPTS)
		mip6_mn_get_coa(&parms.id.ext.saddr);
	else if (id_proto == IPPROTO_ROUTING)
		mip6_mn_get_coa(&parms.id.ext.daddr);

#endif
	mip6nl_talk(&parms);

}

/* tunnel handling(for HA and MN)
 *
 * Inbound:
 * [IP]dst=id_addr1,src=id_addr2
 *     [IP]dst=sel_addr1,src=sel_addr2
 *
 * Outbound:
 * [IP]dst=id_addr2,src=id_addr1
 *     [IP]dst=sel_addr2,src=sel_addr1
 *
 * add: 1=add,0=remove
 * XXX: error handling is needed.
 */
int mip6_tunnel_update(struct mip6d_handle *handle,
		       struct in6_addr *sel_addr1, struct in6_addr *sel_addr2,
		       struct in6_addr *id_addr1, struct in6_addr *id_addr2,
		       int add)
{
	struct mip6nl_parms nl_in;
	struct mip6nl_parms nl_out;
	int ret = 0;
	int err = 0;

	/* Inbound:
	 * selector = (sel_addr1, sel_addr2)
	 *       id = (id_addr1, id_addr2), proto=IPv6
	 */
	memset(&nl_in, 0, sizeof(nl_in));

	mip6nl_init(&nl_in, handle->nlxfrm_sock);
	nl_in.type = (add) ? XFRM_MSG_NEWPOLICY : XFRM_MSG_DELPOLICY;

	memcpy(&nl_in.sel.daddr, sel_addr1, sizeof(nl_in.sel.daddr));
	memcpy(&nl_in.sel.saddr, sel_addr2, sizeof(nl_in.sel.saddr));
	nl_in.sel.proto = IPPROTO_ANY;

	nl_in.id.tmpls[0].proto = IPPROTO_IPV6;
	memcpy(&nl_in.id.tmpls[0].daddr, id_addr1, sizeof(nl_in.sel.daddr));
	memcpy(&nl_in.id.tmpls[0].saddr, id_addr2, sizeof(nl_in.sel.saddr));

	nl_in.pol.dir = XFRM_POLICY_IN;

	ret = mip6nl_talk(&nl_in); /* apply inbound policy */
	if (ret != 0 && add) {
		err = ret;
		goto error_in;
	}

	nl_in.type = (add) ? XFRM_MSG_NEWSA : XFRM_MSG_DELSA;
	ret = mip6nl_talk(&nl_in); /* apply inbound state */
	if (ret != 0 && add) {
		err = ret;
		goto error_in;
	}

	/* Outbound:
	 * selector = (sel_addr2, sel_addr1)
	 *       id = (id_addr2, id_addr1), proto=IPv6
	 */
	memset(&nl_out, 0, sizeof(nl_out));
	mip6nl_init(&nl_out, handle->nlxfrm_sock);
	nl_out.type = (add) ? XFRM_MSG_NEWPOLICY : XFRM_MSG_DELPOLICY;

	memcpy(&nl_out.sel.daddr, sel_addr2, sizeof(nl_out.sel.daddr));
	memcpy(&nl_out.sel.saddr, sel_addr1, sizeof(nl_out.sel.saddr));
	nl_out.sel.proto = IPPROTO_ANY;

	nl_out.id.tmpls[0].proto = IPPROTO_IPV6;
	memcpy(&nl_out.id.tmpls[0].daddr, id_addr2, sizeof(nl_out.sel.daddr));
	memcpy(&nl_out.id.tmpls[0].saddr, id_addr1, sizeof(nl_out.sel.saddr));

	nl_out.pol.dir = XFRM_POLICY_OUT;

	ret = mip6nl_talk(&nl_out); /* apply outbound policy */
	if (ret != 0 && add) {
		err = ret;
		goto error_out;
	}

	nl_out.type = (add) ? XFRM_MSG_NEWSA : XFRM_MSG_DELSA;
	ret = mip6nl_talk(&nl_out); /* apply outbound state */
	if (ret != 0 && add) {
		err = ret;
		goto error_out;
	}

	return 0;

 error_out:
	if (add) {
		nl_out.type = XFRM_MSG_DELSA;
		mip6nl_talk(&nl_out); 
		nl_out.type = XFRM_MSG_DELPOLICY;
		mip6nl_talk(&nl_out); 
	}

 error_in:
	if (add) {
		nl_in.type = XFRM_MSG_DELSA;
		mip6nl_talk(&nl_in); 
		nl_in.type = XFRM_MSG_DELPOLICY;
		mip6nl_talk(&nl_in); 
	}

	return err;
}


int mip6_xfrm_set(struct mip6d_handle *handle, int dir,
		  const struct in6_addr *sel_daddr, 
		  const struct in6_addr *sel_saddr,
		  const struct in6_addr *id_daddr,
		  const struct in6_addr *id_saddr,
		  __u8 proto, __u8 id_proto,
		  int add)
{
	struct mip6nl_parms nl;
	int err = 0;
	int ret;


	memset(&nl, 0, sizeof(nl));

	mip6nl_init(&nl, handle->nlxfrm_sock);
	/* XXX: quick hacking for adding priority*/
	switch (proto) {
	case IPPROTO_MOBILITY:
		nl.pol.priority = 8;
		break;
	default:
		nl.pol.priority = 0;
		break;
	}

	nl.type = (add) ? XFRM_MSG_NEWPOLICY : XFRM_MSG_DELPOLICY;

	memcpy(&nl.sel.daddr, sel_daddr, sizeof(nl.sel.daddr));
	memcpy(&nl.sel.saddr, sel_saddr, sizeof(nl.sel.saddr));
	nl.sel.proto = proto;

	nl.id.tmpls[0].proto = id_proto;
	memcpy(&nl.id.tmpls[0].daddr, id_daddr, sizeof(nl.sel.daddr));
	memcpy(&nl.id.tmpls[0].saddr, id_saddr, sizeof(nl.sel.saddr));

	nl.pol.dir = dir;

	ret = mip6nl_talk(&nl); /* apply a policy */
	if (ret != 0 && add) {
		struct mip6nl_parms nl_err = nl;
		nl_err.type = XFRM_MSG_DELPOLICY;
		err = ret;
		mip6nl_talk(&nl_err);
		goto fin;
	}

	nl.type = (add) ? XFRM_MSG_NEWSA : XFRM_MSG_DELSA;
	ret = mip6nl_talk(&nl); /* apply a state */
	if (ret != 0 && add) {
		struct mip6nl_parms nl_err = nl;
		nl_err.type = XFRM_MSG_DELSA;
		err = ret;
		mip6nl_talk(&nl_err);
		goto fin;
	}

 fin:
	return err;
}

int mip6_rthdr_set(struct mip6d_handle *handle, int dir,
		   struct in6_addr *daddr, struct in6_addr *saddr,
		   struct in6_addr *rtaddr,
		   __u8 proto, int add)
{
	return mip6_xfrm_set(handle, dir, daddr, saddr, rtaddr, &in6addr_any,
			     proto, IPPROTO_ROUTING, add);
}
