/* $USAGI: strutil.h,v 1.1 2004/04/23 14:19:41 nakam Exp $ */

/*
 * Copyright (C)2004 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */

#ifndef __STRUTIL_H
#define __STRUTIL_H

#include <linux/socket.h>
#include <sys/types.h>
#include <linux/xfrm.h>

const struct sockaddr *getaddr(const char *str, int hints_family,
			       size_t *addrlen, int *family);
const xfrm_address_t *getxfaddr(const char *str, int hints_family);

const char *straddr(const struct sockaddr *sa, int salen);
const char *strxfaddr(const xfrm_address_t *xa, int family);

const char *strproto(__u8 proto);
const char *mip6_strproto(__u8 proto);

int getproto(const char *str);
int mip6_getproto(const char *str);

const char *strmh(__u8 type);
const char *stricmp6(__u8 type);

const char *strxfpolicy_dir(__u8 dir);
const char *strxfpolicy_action(__u8 action);
const char *strxfpolicy_flags(__u8 flags);
const char *strxfshare(__u8 share);
const char *strxflimit(__u64 limit);
const char *strxftime(__u64 time);

#endif
