/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#include <ctype.h>
#include <fcntl.h>
#include <locale.h>
#include <libintl.h>
#include <malloc.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <shadow.h>
#include <pwd.h>
#include <rpcsvc/nis.h>
#include <rpc/key_prot.h>
#include <unistd.h>

#include "key_common.h"

#define _(String) gettext (String)

#define	ROOTKEY_FILE	"/etc/.rootkey"

#ifndef MAXHOSTNAMELEN
#define	MAXHOSTNAMELEN 256
#endif

#define	PK_FILES	1
#define	PK_YP		2
#define	PK_NISPLUS	3

extern char program_name[];

#define PATH_NSWCONF "/etc/nsswitch.conf"

struct nsw
  {
    char name[33];
    int orderc;			/* Isn't really necessary */
    char **orders;
  };

static FILE *__nssfile = NULL;

static int
_setnswent (void)
{
  if (__nssfile)
    fclose (__nssfile);

  __nssfile = fopen (PATH_NSWCONF, "r");

  return (__nssfile == NULL ? -1 : 0);
}

static void
_endnswent (void)
{
  if (__nssfile)
    {
      fclose (__nssfile);
      __nssfile = NULL;
    }
}


static struct nsw *
_getnswent (void)
{
  static struct nsw nswb;
  static char buf[1024];
  char *cp, *tmp;
  int count;


  if (!__nssfile)
    _setnswent ();


  if (__nssfile == NULL)
    return NULL;

  do
    {
      cp = fgets (buf, sizeof (buf), __nssfile);
      if (cp == NULL)
	return NULL;

      tmp = strchr (cp, '#');
      if (tmp)
	*tmp = '\0';

      while (isspace (*cp))
	cp++;
    }
  while (*cp == '\0');

  tmp = cp;

  cp = strchr (cp, ':');
  if (!cp)
    return NULL;

  *cp++ = '\0';
  strncpy (nswb.name, tmp, sizeof (nswb.name) - 1);

  while (isspace (*cp))
    cp++;

  count = 3;
  nswb.orders = malloc ((count + 1) * sizeof (char *));
  for (nswb.orderc = 0; *cp; nswb.orderc++)
    {
      tmp = cp;

      do
	{
	  cp++;
	}
      while (!isspace (*cp) && *cp != '\0');

      if (*cp)
	*cp++ = '\0';

      if (nswb.orderc >= count)
	{
	  count += 3;
	  nswb.orders = realloc (nswb.orders, (count + 1) * sizeof (char *));
	}

      nswb.orders[nswb.orderc] = tmp;

      while (isspace (*cp))
	cp++;
    }

  nswb.orders[nswb.orderc] = NULL;

  return &nswb;
}

static struct nsw *
_getnswbyname (char *name)
{
  static struct nsw *result;

  if (_setnswent () != 0)
    return NULL;

  while ((result = _getnswent ()) != NULL)
    if (strcmp (name, result->name) == 0)
      {
	_endnswent ();
	return result;
      }

  _endnswent ();

  return NULL;
}

static char *
publickey_police (void)
{
  struct nsw *result;

  result = _getnswbyname ((char *) "publickey");

  if (result == NULL || result->orderc == 0)
    {
      fprintf (stderr, _("ERROR: There is no publickey entry in %s.\n"),
	       PATH_NSWCONF);
      return NULL;
    }
  if (result->orderc > 1)
    {
      fputs (_("I cannot figure out which publickey database you want to update.\n"), stderr);
      return NULL;
    }

  if (result && result->orders[0] != NULL)
    return strdup (result->orders[0]);
  else
    return NULL;
}

int
get_pk_source (char *pk_service)
{
  int db = 0, got_from_switch = 0;

  /* No service specified, try to figure out from switch */
  if (pk_service == NULL)
    {
      pk_service = publickey_police ();
      if (pk_service == 0)
	return 0;
      fprintf (stdout, _("Updating %s publickey database.\n"), pk_service);
      got_from_switch = 1;
    }

  if (strcmp (pk_service, "nisplus") == 0)
    db = PK_NISPLUS;
  else if (strcmp (pk_service, "nis") == 0)
    db = PK_YP;
  else if (strcmp (pk_service, "files") == 0)
    db = PK_FILES;
  else
    return 0;

  return db;			/* all passed */
}
