/* $USAGI: doalloc.c,v 1.3 2001/01/28 01:31:14 yoshfuji Exp $ */

/*
 * Copyright (c) 1983, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <netdb.h>
#include <syslog.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "mysleep.h"
#include "inetd.h"

/********* exit-resistant malloc ************************/

/*
 * On many systems, including presently Linux, this is bloat because
 * malloc never returns null - if the system runs out of swap, it 
 * panics or randomly starts killing processes or does other weird 
 * stuff. However, it doesn't hurt to be prepared. This is the only
 * place inetd can actually exit due to failure, now.
 */

void *
domalloc(size_t len)
{
	static int retries[] = { 2, 10, 60, 600, -1 };
	void *p;
	int try = 0;

	while (retries[try]>0) {
		p = malloc(len);
		if (p != NULL) {
		    	return p;
		}
	
		syslog(LOG_ERR, "Out of memory - retrying in %d seconds.",
		       retries[try]);
		mysleep(retries[try]);
		try++;
	}
	/* Should this be LOG_EMERG? */
	syslog(LOG_ALERT, "Out of memory - GIVING UP!");
	exit(100);
	return NULL;  /* unreachable */
}

char *
dostrdup(const char *cp)
{
	char *x = domalloc(strlen(cp)+1);
	strcpy(x, cp);
	return x;
}
