/*
 * supplementary code for Dynamic Host Configuration Protocol IPv6
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright (c) International Business Machines Corp., 2002
 *
 * Author: Suresh Kodati <skodati@in.ibm.com>
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <sys/socket.h>
#include <ifaddrs.h>
#include <netinet/in.h>

void dPrint(int level, const char *mesg, ... ){
	va_list vlist;
	char buf[LINE_MAX];

	va_start(vlist, mesg);
	vsnprintf(buf, sizeof(buf), mesg, vlist);

	if (level){
	
		FILE *fp;
		fp = fopen("dbug", "a+");
		if( fp == NULL){
			fprintf(stderr, "%s\n", "Error opening dbug file");
			exit(0);
		}

		fprintf(fp, "%s\n", buf);
		fclose(fp);
		return;
	}
	else{
		fprintf(stderr,"%s\n", buf);
		return;
	} 
}


int getifaddr(struct in6_addr *addr, char *ifnam, struct in6_addr *prefix, int plen)
{
	struct ifaddrs *ifap, *ifa;
	struct sockaddr_in6 *sin6;
	int error = -1;
	if (getifaddrs(&ifap) != 0) {
		printf("here is error!!\n");
		dPrint(0, "getifaddr");
	}
 
	for (ifa = ifap; ifa; ifa = ifa->ifa_next) {

		if (ifa->ifa_addr->sa_family != AF_INET6){
			continue;
		}

		sin6 = (struct sockaddr_in6 *)ifa->ifa_addr;
		
		if (plen % 8 == 0) {
			if (memcmp(&sin6->sin6_addr, prefix, plen / 8) != 0)
				continue;
		} else {
			struct in6_addr a, m;
			int i;
		
			memcpy(&a, &sin6->sin6_addr, sizeof(a));
			memset(&m, 0, sizeof(m));
			memset(&m, 0xff, plen / 8);
			m.s6_addr[plen / 8] = (0xff00 >> (plen % 8)) & 0xff;
		
			for (i = 0; i < sizeof(a); i++)
				a.s6_addr[i] &= m.s6_addr[i];
			if (memcmp(&a, prefix, plen / 8) != 0 || a.s6_addr[plen / 8] != (prefix->s6_addr[plen / 8] & m.s6_addr[plen / 8]))
					continue;
		}//else
		memcpy(addr, &sin6->sin6_addr, sizeof(*addr));
		error = 0;
		break;	
	}
 
	freeifaddrs(ifap);
	return(error);
}

/*      Create a random number for a range x and y */
long  random_max_min(long x, long y)
{
	float d;
	/* it generates a random number between 0 and RAND_MAX, and recomputes the random number
	   for x and y */
	d=( (float) random() / (float)RAND_MAX );
	d = d*(float)(y-x);
	d = d+x;
	return( (long)d);
}

float random_min(void){
	return((((float)random()*20.0)/(float)RAND_MAX)/10.0 - 1.0);
}

void fix_time_val(struct timeval *t)
{
	long s;

	s = t->tv_usec / (1000 * 1000);
	t->tv_usec %= (1000 * 1000);
	t->tv_sec += s;
}
int get_number(struct in6_addr from_addr,struct in6_addr to_addr)
{
	int i;
	int number=0;
	for( i = 0; i <=7; i++){
		number = (number*256) + htons(to_addr.s6_addr16[i]-from_addr.s6_addr16[i]);
	}
	number ++;
	return ( number );
}


/* returns -1 incase of error */
int get_config_value(char *fileName, char *value,char  *retVal)
{
	char  buffer[75], w[75], v[75];
	FILE *f1;
	if((f1=fopen(fileName, "r")) == NULL){
		dPrint(0,"Error Opening the configuration parameter");
		return -1;
	}

	while((fgets(buffer, 75 - 1, f1)) != NULL) {
	if((sscanf(buffer, "%s %s", w, v) >= 1) && (strcmp(w, value) == 0)) {
		if(value == NULL) {
			return 1;
		}
		else {
			strcpy(retVal,v);
			fclose(f1);
			return 1;
		}
	}
	}
	fclose(f1);
	return -1;
}
