#!/usr/bin/env gosh

(use test.unit)

(require "test/uim-test-utils")

(define-uim-test-case "testcase macro"
  ("test normal-let"
   (assert-equal '(-1 "b" (c) d)
                 (uim '(let ((a -1)
                             (b "b")
                             (c '(c))
                             (d 'd))
                         (list a b c d))))
   (assert-equal '() (uim '(let (a) a))))
  ("test named-let"
   (assert-equal -1 (uim '(let - ((x -)) (x 1))))
   (assert-equal '(4 3 2 1 0)
                 (uim '(let count-down ((lst '())
                                        (i 0))
                         (if (< i 5)
                           (count-down (cons i lst) (+ i 1))
                           lst))))
   (assert-equal '((6 1 3) (-5 -2))
                 (uim '(let loop ((numbers '(3 -2 1 6 -5))
                                  (nonneg '())
                                  (neg '()))
                         (cond ((null? numbers) (list nonneg neg))
                               ((> 0 (car numbers))
                                (loop (cdr numbers)
                                      nonneg
                                      (cons (car numbers) neg)))
                               (else
                                (loop (cdr numbers)
                                      (cons (car numbers) nonneg)
                                      neg))))))))

;; The following tests will fail due to bug #617 (uim treats false as nil)
(define-uim-test-case "testcase slib extensions"
  ("test case"
   (assert-false (uim-bool '(case 'symbol
			      ((0 #t #f () (symbol) "symbol") 0)
			      ((different-symbol symbol) #f)
			      (else 1))))
   (assert-false (uim-bool '(case (+ 5 5)
			      ((#t #f () (symbol) "10") 0)
			      (((+ 5 5) else) 1)
			      ((10) (case "string"
				      (("string") 7)
				      (else #f))))))
   (assert-false (uim-bool '(case 2
			      ((2) #f))))))
