#!/usr/bin/env gosh

(use test.unit)
(use file.util)

(require "test/uim-test-utils")

(let* ((current-lang #f)
       (lang "en_US")
       (locale-dir (build-path "test" "locale"))
       (LC_MESSAGES-dir (build-path locale-dir "en_US" "LC_MESSAGES"))
       (domain "uim")
       (msgid "hello")
       (msgstr "Hello"))
  (define-uim-test-case "test intl"
    (setup
     (lambda ()
       (set! current-lang (or (sys-getenv "LANG")
			      (sys-getenv "LC_ALL")
			      "C"))
       (sys-putenv "LANG" lang)
       (sys-putenv "LC_ALL" lang)
       (make-directory* LC_MESSAGES-dir)
       (with-output-to-file (build-path LC_MESSAGES-dir #`",|domain|.po")
         (lambda ()
           (display
            (string-join
             `("msgid \"\""
               "msgstr \"\""
               "\"MIME-Version: 1.0\\n\""
               "\"Content-Type: text/plain; charset=UTF-8\\n\""
               "\"Content-Transfer-Encoding: 8bit\\n\""
               ""
               ,#`"msgid \",|msgid|\""
               ,#`"msgstr \",|msgstr|\"")
             "\n"))))
       (run-process "msgfmt" "-o"
                    (build-path LC_MESSAGES-dir #`",|domain|.mo")
                    (build-path LC_MESSAGES-dir #`",|domain|.po")
                    :wait #t)
       (*uim-sh-setup-proc*)))
    (teardown
     (lambda ()
       (sys-putenv "LANG" current-lang)
       (sys-putenv "LC_ALL" current-lang)
       (remove-directory* locale-dir)))
    ("test gettext"
     (assert-equal msgid (uim `(gettext ,msgid)))
     (uim `(bindtextdomain ,domain ,locale-dir))
     (assert-equal msgstr (uim `(dgettext ,domain ,msgid)))
     (uim `(textdomain ,domain))
     (assert-equal msgstr (uim `(gettext ,msgid))))))
