
/*

  Copyright (c) 2004 uim Project http://uim.freedesktop.org/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

*/

#include <gtk/gtk.h>

#include <locale.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

#include <uim/uim.h>
#include <uim/uim-helper.h>
#include "uim/config.h"
#include "uim/gettext.h"


static int read_tag;
static int uim_fd; /* file descriptor to connect helper message bus */
static int ae_mode; /* add mode or edit mode */
static int input_method;

static enum{
  MODE_EDIT,
  MODE_ADD
}MODE;

static enum {
  IM_ANTHY,
  IM_SKK,
  IM_PRIME
}IM;

static void
helper_disconnect_cb(void)
{
  uim_fd = -1;
  gdk_input_remove(read_tag);
}

static void
fd_read_cb(gpointer p, gint fd, GdkInputCondition c)
{
  char *tmp;
  
  uim_helper_read_proc(fd);
  while ((tmp = uim_helper_get_message())) {
    /*    parse_helper_str(tmp); */
    g_free(tmp); tmp = NULL;
  }
}

static void
check_helper_connection(void)
{
  if(uim_fd < 0) {
    uim_fd = uim_helper_init_client_fd(helper_disconnect_cb);
    if(uim_fd > 0)
      read_tag = gdk_input_add(uim_fd, (GdkInputCondition)GDK_INPUT_READ,
			       fd_read_cb, NULL);
  }
}

static char *
get_error_msg(void)
{
  /* dummy */
}

static void
parse_arg(int argc, char *argv[])
{
  int ch;

  ae_mode = MODE_ADD;
  return;
  /*

  while((ch = getopt(argc, argv, "aei:")) != -1)
  {
      switch(ch) {
      case 'a':
          ae_mode = MODE_ADD;
	  break;
      case 'e':
	  ae_mode = MODE_EDIT;
	  break;
      case 'i':
	  if(strcmp(optarg, "anthy"))
    	      im = IM_ANTHY;
	  else if(strcmp(optarg, "prime"))
	      im = IM_PRIME;
	  else if (strcmp(optarg, "skk"))
	      im = IM_SKK;
	  else
	      im = IM_ANTHY;
	  break;
      default:
	  ae_mode = MODE_ADD;
	  im = get_current_im();
      }
  }

  argv += optind;
  argc -= optind;

if(mode == edit) {
ae_mode = EDIT;
} else {
ae_mode = ADD;
}

if(im == anthy) {

input_method = anthy

} else {
input_method = get_current_im();
}

*/
}

static
create_window_anthy(void)
{
  GtkWidget *window;
  GtkWidget *w;
  /*  if(ae_mode == MODE_EDIT) {
    w = anthy_edit_window_create();
    } else {*/
    w = anthy_add_window_create();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_add(GTK_CONTAINER(window),w);
  gtk_widget_show_all(window);
}

static int
create_window(void)
{
  switch(input_method) {
  case IM_ANTHY:
    create_window_anthy();
    break;
  case IM_SKK:
    /*    create_window_skk();*/
    break;
  default:
    return -1;
  }
  return 0;
}

int
main(int argc, char *argv[])
{  
  gint result;
  setlocale(LC_ALL, "");
  gtk_set_locale();
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
  bind_textdomain_codeset(PACKAGE, "UTF-8"); 
  parse_arg(argc, argv);

  gtk_init(&argc, &argv);

  result = create_window();


  if(result == -1) {
    fprintf(stderr, "Error:%s\n", get_error_msg());
    exit(-1);
  }

  /* connect to uim helper message bus */
  uim_fd = -1;
  check_helper_connection();  

  gtk_main ();
  return 0;
}
