# $Id: extconf.rb,v 1.3 2002/09/05 09:21:12 c-heart Exp $

require 'mkmf'

GDCHART_DIR = "./gdchart0.11.2dev"

unless find_library('gd', 'main')
  puts "Can't find libgd"
  exit 1
end

unless have_header('gdchart.h')
  $defs.push("-I#{GDCHART_DIR}")
  puts "'-I#{GDCHART_DIR}' is defined."
end

$defs.push("-DHAVE_LIBFREETYPE") if have_library('freetype')
$defs.push("-DHAVE_JPEG") if have_library('jpeg')

have_library('png')
have_library('z')

if not have_library('gdc', 'main')
  puts "Entering #{GDCHART_DIR}"
  if not find_library('gdc', 'main', GDCHART_DIR)
    puts "Building GDCHART library in #{GDCHART_DIR}..."
    if system("cd #{GDCHART_DIR}; make libgdc.a")
      puts "done"
      find_library('gdc', 'main', GDCHART_DIR)
    else
      puts 'compile error.'
      exit 1
    end
  end
end

create_makefile('GDChart')
