#
# $Date: 2003/08/17 03:04:32 $
# $Author: yoshi $
#

require "mkmf"

gl_libname = ""
glu_libname = ""
glut_libname = ""

modules = ""
ogl_flg = false
glut_flg = false

File.unlink("Makefile") if (FileTest.exist? "Makefile")
File.unlink("Makefile.ogl") if (FileTest.exist? "Makefile.ogl")
File.unlink("Makefile.glut") if (FileTest.exist? "Makefile.glut")

header = nil

case RUBY_PLATFORM
when /cygwin/
  $CFLAGS="-DWIN32"
  gl_libname = "opengl32"
  glu_libname = "glu32"
  glut_libname = "glut32"
  header=["GL/gl.h", "GL/glu.h", "GL/glut.h"]
when /mswin32/
  $CFLAGS="-DWIN32"
  gl_libname = "opengl32"
  glu_libname = "glu32"
  glut_libname = "glut32"
else
  $CPPFLAGS += " -I."

  idir, ldir = dir_config("x11", "/usr/X11R6")

  have_library("Xi", "XAllowDeviceEvents")
  have_library("Xext", "XMITMiscGetBugMode")
  have_library("Xmu", "XmuAddCloseDisplayHook")
  have_library("X11", "XOpenDisplay")
  gl_libname = "GL"
  glu_libname = "GLU"
  glut_libname = "glut"
end
dir_config("opengl", idir, ldir)
dir_config("glut", idir, ldir)

def have_ogl_library(lib, func = 'main')
  have_library(lib, func) || have_library("Mesa"+lib, func)
end

$objs = ["glu.o", "ogl.o", "rbogl.o"]
#have_library("pthread", "pthread_create")
if have_ogl_library(gl_libname) && have_ogl_library(glu_libname)
    create_makefile("opengl")
    File.rename("Makefile", "Makefile.ogl")
    modules = modules + "opengl.#{CONFIG['DLEXT']}" 
    ogl_flg = true
else
    puts "can't create OpenGL module!"
    exit 1
end

$objs = ["glut.o"]
if have_library(glut_libname)
    create_makefile("glut")
    File.rename("Makefile", "Makefile.glut")
    modules = "glut.#{CONFIG['DLEXT']} " + modules
    glut_flg = true
end

open("Makefile", "w") {|f|
  v = $nmake ? '{$(srcdir)}' : ''
  f.write <<"MAKEFILE"
SHELL = /bin/sh
srcdir = #{$srcdir}
VPATH = $(srcdir)

all: #{modules}

opengl.#{CONFIG['DLEXT']}: #{v}rbogl.c #{v}ogl.c #{v}glu.c #{v}rbogl.h
	@echo Now Making opengl extend module
	@$(MAKE) -f Makefile.ogl

glut.#{CONFIG['DLEXT']}: #{v}glut.c
	@echo Now Making glut extend module
	@$(MAKE) -f Makefile.glut

clean:
#{"\t@$(MAKE) -f Makefile.ogl clean" if (ogl_flg)}
#{"\t@$(MAKE) -f Makefile.glut clean" if (glut_flg)}

distclean:
#{"\t@$(MAKE) -f Makefile.ogl distclean" if (ogl_flg)}
#{"\t@$(MAKE) -f Makefile.glut distclean" if (glut_flg)}

install: #{modules}
#{"\t@$(MAKE) -f Makefile.ogl install" if (ogl_flg)}
#{"\t@$(MAKE) -f Makefile.glut install" if (glut_flg)}

site-install: #{modules}
#{"\t@$(MAKE) -f Makefile.ogl site-install" if (ogl_flg)}
#{"\t@$(MAKE) -f Makefile.glut site-install" if (glut_flg)}
MAKEFILE
}

