# prime/engine/engine-userdict2-static.rb
# $Id: engine-userdict2-static.rb,v 1.2 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2005 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine-userdict2'

USERDICT2STATIC = 'userdict2-static'
$engine_class_name = 'PrimeEngineUserdict2Static'

class PrimeEngineUserdict2Static < PrimeEngineUserdict2
  def initialize
    super

    @name = "Userdict2Static engine"
    @id   = "userdict2-static"
    @description = "Userdict2 Static engine"

    @dictname = File::join2(PRIME_USER_DIR, USERDICT2STATIC)
    @dict = PrimeDynamicDict.new(@dictname)
    @postable = PrimeDictPOS.new(@dictname)

    initialize_priority()
    initialize_log()
  end

  def initialize_priority
    @longest_time = 3600 * 24 * 7
    @base_score = 1000
    @step_number = @base_score / get_priority_func(@longest_time)
  end

  def learn_word (pron, literal, pos, context, suffix, rest)
    ## Do not learn words
    return true
  end
end

