/***************************************************************************
*   Copyright (C) 2003 by Mark Kretschmann                                *
*   markey@web.de                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include <artsmodules.h>
#include <debug.h>
#include <connect.h>
#include <artsgui.h>

#include <klocale.h>

#include <vector>
#include <string>

#include "modplug.h"
#include "ModplugGuiFactory_impl.h"


using namespace Arts;
using namespace std;


Widget ModplugGuiFactory_impl::createGui( Object object )
{
    arts_return_val_if_fail( !object.isNull(), Arts::Widget::null() );


    ModplugPlayObject modplug = DynamicCast( object );
    arts_return_val_if_fail( !modplug.isNull(), Arts::Widget::null() );

    HBox hbox;
    hbox.show();

// XBASS ------
    Poti poti_xbass_depth;
    poti_xbass_depth.caption( i18n( "xbass_depth" ).utf8().data() );
    poti_xbass_depth.color( "red" );
    poti_xbass_depth.min( 0.0 );
    poti_xbass_depth.max( 100.0 );
    poti_xbass_depth.range( 100 );
    poti_xbass_depth.value( modplug.xbass_depth() );
    poti_xbass_depth.parent( hbox );
    poti_xbass_depth.show();
    connect( poti_xbass_depth, "value_changed", modplug, "xbass_depth" );
    hbox._addChild( poti_xbass_depth, "xbass_depthWidget" );

    Poti poti_xbass_range;
    poti_xbass_range.caption( i18n( "xbass_range" ).utf8().data() );
    poti_xbass_range.color( "red" );
    poti_xbass_range.min( 10.0 );
    poti_xbass_range.max( 100.0 );
    poti_xbass_range.range( 90 );
    poti_xbass_range.value( modplug.xbass_range() );
    poti_xbass_range.parent( hbox );
    poti_xbass_range.show();
    connect( poti_xbass_range, "value_changed", modplug, "xbass_range" );
    hbox._addChild( poti_xbass_range, "xbass_rangeWidget" );


// REVERB ------
    Poti poti_reverb_depth;
    poti_reverb_depth.caption( i18n( "reverb_depth" ).utf8().data() );
    poti_reverb_depth.color( "red" );
    poti_reverb_depth.min( 0.0 );
    poti_reverb_depth.max( 100.0 );
    poti_reverb_depth.range( 100 );
    poti_reverb_depth.value( modplug.reverb_depth() );
    poti_reverb_depth.parent( hbox );
    poti_reverb_depth.show();
    connect( poti_reverb_depth, "value_changed", modplug, "reverb_depth" );
    hbox._addChild( poti_reverb_depth, "reverb_depthWidget" );

    Poti poti_reverb_delay;
    poti_reverb_delay.caption( i18n( "reverb_delay" ).utf8().data() );
    poti_reverb_delay.color( "red" );
    poti_reverb_delay.min( 40.0 );
    poti_reverb_delay.max( 200.0 );
    poti_reverb_delay.range( 160 );
    poti_reverb_delay.value( modplug.reverb_delay() );
    poti_reverb_delay.parent( hbox );
    poti_reverb_delay.show();
    connect( poti_reverb_delay, "value_changed", modplug, "reverb_delay" );
    hbox._addChild( poti_reverb_delay, "reverb_delayWidget" );


// SURROUND ------
    Poti poti_surround_depth;
    poti_surround_depth.caption( i18n( "surround_depth" ).utf8().data() );
    poti_surround_depth.color( "red" );
    poti_surround_depth.min( 0.0 );
    poti_surround_depth.max( 100.0 );
    poti_surround_depth.range( 100 );
    poti_surround_depth.value( modplug.surround_depth() );
    poti_surround_depth.parent( hbox );
    poti_surround_depth.show();
    connect( poti_surround_depth, "value_changed", modplug, "surround_depth" );
    hbox._addChild( poti_surround_depth, "surround_depthWidget" );

    Poti poti_surround_delay;
    poti_surround_delay.caption( i18n( "surround_delay" ).utf8().data() );
    poti_surround_delay.color( "red" );
    poti_surround_delay.min( 5.0 );
    poti_surround_delay.max( 40.0 );
    poti_surround_delay.range( 35 );
    poti_surround_delay.value( modplug.surround_delay() );
    poti_surround_delay.parent( hbox );
    poti_surround_delay.show();
    connect( poti_surround_delay, "value_changed", modplug, "surround_delay" );
    hbox._addChild( poti_surround_delay, "surround_delayWidget" );


// RESAMPLING ------
    ComboBox combo_resampling;
    combo_resampling.caption( i18n( "resampling" ).utf8().data() );
    vector<string> choicesVec( 4 );
    choicesVec[ 0 ] = "nearest";
    choicesVec[ 1 ] = "linear";
    choicesVec[ 2 ] = "spline";
    choicesVec[ 3 ] = "polyphase";
    combo_resampling.choices( choicesVec );
    combo_resampling.value( modplug.resampling_mode() );
    combo_resampling.parent( hbox );
    combo_resampling.visible( true );
    combo_resampling.show();
    connect( combo_resampling, "value_changed", modplug, "resampling_mode" );
    hbox._addChild( combo_resampling, "resampling_modeWidget" );

    return hbox;
}


REGISTER_IMPLEMENTATION( ModplugGuiFactory_impl );

