/* Copyright 2001-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MODPERL_ENV_H
#define MODPERL_ENV_H

#ifndef ENVHV
#   define ENVHV GvHV(PL_envgv)
#endif

#define modperl_env_untie(mg_flags) \
    MP_magical_untie(ENVHV, mg_flags)

#define modperl_env_tie(mg_flags) \
    MP_magical_tie(ENVHV, mg_flags)

#define modperl_envelem_tie(sv, key, klen) \
    sv_magic(sv, Nullsv, 'e', key, klen)

void modperl_env_hash_keys(pTHX);

void modperl_env_clear(pTHX);

void modperl_env_configure_server(pTHX_ apr_pool_t *p, server_rec *s);

void modperl_env_configure_request_srv(pTHX_ request_rec *r);

void modperl_env_configure_request_dir(pTHX_ request_rec *r);

void modperl_env_default_populate(pTHX);

void modperl_env_request_populate(pTHX_ request_rec *r);

void modperl_env_request_unpopulate(pTHX_ request_rec *r);

void modperl_env_request_tie(pTHX_ request_rec *r);

void modperl_env_request_untie(pTHX_ request_rec *r);

void modperl_env_init(void);

void modperl_env_unload(void);

#endif /* MODPERL_ENV_H */
