#!/usr/bin/env ruby
#
# mousetrack.rb -- IKEGAMI Daisuke
# original is http://ming.sourceforge.net/examples/example.php?name=mousetrack
# $Log$

require 'ming/ming'
include Ming

use_SWFVersion(4)
m = SWFMovie.new
m.set_dimension(320, 240)
m.set_background(0, 0, 0)

i = m.add(SWFSprite.new)
i.set_name('mouse')

m.add(SWFAction.new("startDrag('/mouse', 1);"))

m.add(SWFAction.new('this.quality = 0;'))

r = SWFMorph.new
s = r.get_shape1

s.set_left_fill(s.add_fill(0xff, 0xff, 0xff))
s.move_pen_to(-40, -40)
s.draw_line(80, 0)
s.draw_line(0, 80)
s.draw_line(-80, 0)
s.draw_line(0, -80)

s = r.get_shape2

s.set_left_fill(s.add_fill(0x00, 0x00, 0x00))
s.move_pen_to(-1, -1)
s.draw_line(2, 0)
s.draw_line(0, 2)
s.draw_line(-2, 0)
s.draw_line(0, -2)

box = SWFSprite.new
box.add(SWFAction.new('stop();'))
i = box.add(r)

21.times do |n|
  i.set_ratio(n / 20)
  box.next_frame
end

cell = SWFSprite.new
i = cell.add(box)
i.set_name('box')

action = "
  setTarget('box');
  dx = (/mouse.x + random(120)-60 - ...x)/20;
  dy = (/mouse.y + random(120)-60 - ...y)/20;
  gotoFrame(int(dx*dx + dy*dy));
"
cell.add(SWFAction.new(action))
cell.next_frame
cell.add(SWFAction.new("gotoFrame(0); play();"))
cell.next_frame

x = 20
y = 20
while(x < 320)
  while(y < 240)
    i = m.add(cell)
    i.move_to(x, y)
    y += 40
  end
  x += 40
end

m.next_frame

m.add(SWFAction.new("gotoFrame(1); play();"))

m.save('mousetrack.swf')
