/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: mecab.h,v 1.32 2005/03/20 13:18:57 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#ifndef _MECAB_MECAB_H
#define _MECAB_MECAB_H

/* C/C++ common data structures */

struct _mecab_token_t /* 16byte */
{
  unsigned short rcAttr2;
  unsigned short rcAttr1;
  unsigned short lcAttr;
  unsigned short posid;
  unsigned short length;
  unsigned short cost;
  unsigned int   feature;
};

struct _mecab_path_t
{
  struct _mecab_node_t* node;
  unsigned int  cost;
  struct _mecab_path_t* next;
}; 
   
struct _mecab_node_t
{
  struct _mecab_token_t *token;
  struct _mecab_node_t  *prev;
  struct _mecab_node_t  *next;
  struct _mecab_node_t  *lnext;
  struct _mecab_node_t  *rnext;
  struct _mecab_path_t  *path;
  char  *surface;
  char  *feature;
  unsigned char stat; // status 
  unsigned int  length;
  unsigned int  end;
  unsigned int  cost;
  unsigned int  id;
}; 

/* C interface  */
#ifdef __cplusplus
#include <cstdio>
#else
#include <stdio.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#include <windows.h>
#  ifdef DLL_EXPORT
#    define MECAB_DLL_EXTERN  __declspec(dllexport)
#  else
#    define MECAB_DLL_EXTERN  __declspec(dllimport)
#  endif
#endif
   
#ifndef MECAB_DLL_EXTERN
#  define MECAB_DLL_EXTERN extern
#endif 

  typedef struct _mecab_t       mecab_t;
  typedef struct _mecab_node_t  mecab_node_t;
  typedef struct _mecab_path_t  mecab_path_t;
  typedef struct _mecab_token_t mecab_token_t;
   
  /* C interface */
  MECAB_DLL_EXTERN int           mecab_do                  (int, char**);
  MECAB_DLL_EXTERN int           mecab_make_dictionary     (char*, char*);
  MECAB_DLL_EXTERN mecab_t*      mecab_new                 (int, char**);
  MECAB_DLL_EXTERN mecab_t*      mecab_new2                (char*);
  MECAB_DLL_EXTERN char*         mecab_strerror            (mecab_t*);
  MECAB_DLL_EXTERN void          mecab_destroy             (mecab_t*);
  MECAB_DLL_EXTERN int           mecab_lock                (mecab_t*);
  MECAB_DLL_EXTERN int           mecab_unlock              (mecab_t*);
  MECAB_DLL_EXTERN char*         mecab_sparse_tostr        (mecab_t*, char*);
  MECAB_DLL_EXTERN char*         mecab_sparse_tostr2       (mecab_t*, char*, unsigned int);
  MECAB_DLL_EXTERN char*         mecab_sparse_tostr3       (mecab_t*, char*, unsigned int, char*, unsigned int);
  MECAB_DLL_EXTERN mecab_node_t* mecab_sparse_tonode       (mecab_t*, char*);
  MECAB_DLL_EXTERN mecab_node_t* mecab_sparse_tonode2      (mecab_t*, char*, unsigned int);
  MECAB_DLL_EXTERN char*         mecab_nbest_sparse_tostr  (mecab_t*, unsigned int, char*);
  MECAB_DLL_EXTERN char*         mecab_nbest_sparse_tostr2 (mecab_t*, unsigned int, char*, unsigned int);
  MECAB_DLL_EXTERN char*         mecab_nbest_sparse_tostr3 (mecab_t*, unsigned int, char*, unsigned int, char*, unsigned int);
  MECAB_DLL_EXTERN int           mecab_nbest_init          (mecab_t*, char*);
  MECAB_DLL_EXTERN int           mecab_nbest_init2         (mecab_t*, char*, unsigned int);
  MECAB_DLL_EXTERN char*         mecab_nbest_next_tostr    (mecab_t*);
  MECAB_DLL_EXTERN char*         mecab_nbest_next_tostr2   (mecab_t*, char*, unsigned int);
  MECAB_DLL_EXTERN mecab_node_t* mecab_nbest_next_tonode   (mecab_t*);
   
#ifdef __cplusplus
}
#endif

/* C++ interface */
#ifdef __cplusplus

namespace MeCab
{
  typedef struct _mecab_token_t Token;
  typedef struct _mecab_path_t  Path;
  typedef struct _mecab_node_t  Node;

  class Tagger 
  {
  private:
    class Impl;
    Impl *_impl;

  public:
    bool        open           (int, char**);
    bool        open           (const char*);
    bool        close          ();
    int         parse          (int, char**); // mecab_do
    const char* parse          (const char*, unsigned int = 0);
    const char* parse          (const char*, unsigned int, char*, unsigned int);
    Node*       parseToNode    (const char*, unsigned int = 0);
    const char* parseNBest     (unsigned int, const char*, unsigned int = 0);
    const char* parseNBest     (unsigned int, const char*, unsigned int, char *, unsigned int);

    bool        parseNBestInit (const char*, unsigned int = 0);
    Node*       nextNode  ();
    const char* next();
    const char* next(char*, unsigned int);

    const char* what        ();
    bool        lock        ();
    bool        unlock      (); 

    Tagger ();
    Tagger  (int, char**);
    Tagger  (const char*);
    ~Tagger();     
  };
}

#endif
#endif
