/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: dictionary_maker.h,v 1.5 2004/03/08 07:40:52 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#ifndef _MECAB_DICTIONARYMAKER_H
#define _MECAB_DICTIONARYMAKER_H

#include <set>
#include <map>
#include <vector>
#include <string>
#include "csv.h"

namespace MeCab {

  class DictionaryMaker
  {
  private:
    std::set    <std::string>                 ruleSet;
    std::vector <Csv>                         ruleList;
    std::vector <std::vector <unsigned int> > idList;
    std::map    <std::string, unsigned int>   dic2IdHash;
    std::map    <std::string, unsigned int>   rule2IdHash;
    std::map    <std::string, int>            isLexcalized;

    unsigned int getDicIdNoCache (Csv &);
    unsigned int getIdList (Csv &, std::vector <unsigned int> &, int parent = 1);

  public:
    void clear ();
    void add (const std::string &);
    unsigned int size () { return ruleList.size(); }
    void build ();
    unsigned int getDicId  (const std::string &);
    unsigned int getRuleId (const std::string &);
    std::vector <unsigned int> &getRuleIdList (const std::string &);
  };
}
#endif
