/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 
  $Id: csv.h,v 1.7 2004/03/08 07:40:51 taku-ku Exp $;

  Copyright (C) 2001-2004 Taku Kudo <taku-ku@is.aist-nara.ac.jp>
  This is free software with ABSOLUTELY NO WARRANTY.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/  
#ifndef _MECAB_CSV_H
#define _MECAB_CSV_H

#include <vector>
#include <string>
#include <strstream>

namespace MeCab {

  /* 
   * This code is imported from "The Practice of Programming" pp. 99-
   * with some modification.
   */ 

  class Csv: public std::vector <std::string>
  {
  private:
    std::string   fieldsep;
    unsigned int advplain  (const std::string &line, std::string &fld, unsigned int);
    unsigned int advquoted (const std::string &line, std::string &fld, unsigned int);
    std::vector < std::pair <unsigned int, unsigned int> > fieldPos;

  public:
    unsigned int split (const std::string&);
    unsigned int split (const std::string& s, const std::string& fsp)
    {
      fieldsep = fsp;
      return split (s);
    }

    void setFieldSeparator (const std::string& fsp) { fieldsep = fsp; }

    std::pair <unsigned int, unsigned int> 
      getFieldPos (unsigned int i) { return fieldPos[i]; }
     
    std::string toCsv    () 
    { 
       std::ostrstream s; toCsv(s); std::string r = s.str();
       s.freeze(false); return r;
    } 

    std::string toString () { return toCsv(); } // Java like 

    std::ostream &toCsv (std::ostream& os);
    friend std::ostream& operator<< (std::ostream& os, Csv& c) { return c.toCsv (os); };
     
    Csv (const std::string& sep = ","): fieldsep (sep) {};
    ~Csv () {};
  };
}

#endif
