/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_STOP_RELOAD_ACTION_H
#define KZ_STOP_RELOAD_ACTION_H

#include <gtk/gtk.h>

#include "kz-window.h"

#define KZ_TYPE_STOP_RELOAD_ACTION            (kz_stop_reload_action_get_type())
#define KZ_STOP_RELOAD_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_STOP_RELOAD_ACTION, KzStopReloadAction))
#define KZ_STOP_RELOAD_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_STOP_RELOAD_ACTION, KzStopReloadActionClass))
#define KZ_IS_STOP_RELOAD_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_STOP_RELOAD_ACTION))
#define KZ_IS_STOP_RELOAD_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_STOP_RELOAD_ACTION))
#define KZ_STOP_RELOAD_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_STOP_RELOAD_ACTION, KzStopReloadActionClass))

typedef struct _KzStopReloadAction        KzStopReloadAction;
typedef struct _KzStopReloadActionPrivate KzStopReloadActionPrivate;
typedef struct _KzStopReloadActionClass   KzStopReloadActionClass;

typedef enum {
	KZ_STOP_RELOAD_ACTION_STATE_STOP,
	KZ_STOP_RELOAD_ACTION_STATE_RELOAD
} KzStopReloadActionState;

struct _KzStopReloadAction
{
	GtkAction   parent;
  	KzStopReloadActionPrivate *priv;
};

struct _KzStopReloadActionClass
{
	GtkActionClass parent_class;
};

GType               kz_stop_reload_action_get_type  (void) G_GNUC_CONST;
KzStopReloadAction *kz_stop_reload_action_new       (KzWindow   *kz);

void	            kz_stop_reload_action_set_state (KzStopReloadAction *action,
						     KzStopReloadActionState state);

#endif /* KZ_STOP_RELOAD_ACTION_H */
