
#ifndef SWF_SOUNDSTREAM_H_INCLUDED
#define SWF_SOUNDSTREAM_H_INCLUDED

#include "block.h"
#include "input.h"

#define SWF_SOUNDSTREAM_COMPRESSION      0xf0
#define SWF_SOUNDSTREAM_NOT_COMPRESSED   (0<<4)
#define SWF_SOUNDSTREAM_ADPCM_COMPRESSED (1<<4)
#define SWF_SOUNDSTREAM_MP3_COMPRESSED   (2<<4)

#define SWF_SOUNDSTREAM_RATE             0x0c
#define SWF_SOUNDSTREAM_5KHZ             (0<<2)
#define SWF_SOUNDSTREAM_11KHZ            (1<<2)
#define SWF_SOUNDSTREAM_22KHZ            (2<<2)
#define SWF_SOUNDSTREAM_44KHZ            (3<<2)

#define SWF_SOUNDSTREAM_BITS             0x02
#define SWF_SOUNDSTREAM_8BITS            (0<<1)
#define SWF_SOUNDSTREAM_16BITS           (1<<1)

#define SWF_SOUNDSTREAM_CHANNELS         0x01
#define SWF_SOUNDSTREAM_MONO             (0<<0)
#define SWF_SOUNDSTREAM_STEREO           (1<<0)

struct _soundstream
{
  byte flags;
  byte isFinished;
  int delay;
  int start;
  int samplesPerFrame;
  int sampleRate;
  SWFInput input;
};
typedef struct _soundstream *SWFSoundStream;

#define SWFSOUNDSTREAM_SIZE sizeof(struct _soundstream)

SWFSoundStream newSWFSoundStream(FILE *file);
SWFSoundStream newSWFSoundStream_fromInput(SWFInput input);
void destroySWFSoundStream(SWFSoundStream soundstream);


#define SWFSOUNDSTREAM_INITIAL_DELAY 1663

struct _soundStreamBlock
{
  swfBlock block;
  SWFSoundStream soundstream;
  int numFrames;
  int delay;
  int length;
};
typedef struct _soundStreamBlock *SWFSoundStreamBlock;

#define SWFSOUNDSTREAMBLOCK_SIZE sizeof(struct _soundStreamBlock)

SWFBlock SWFSoundStream_getStreamHead(SWFSoundStream soundstream, float frameRate);
SWFBlock SWFSoundStream_getStreamBlock(SWFSoundStream soundstream);
void SWFSoundStream_rewind(SWFSoundStream soundstream);

#endif /* SWF_SOUNDSTREAM_H_INCLUDED */
