#ifndef SWF_MPEG_H_INCLUDED
#define SWF_MPEG_H_INCLUDED

#define MPEG_FRAME_SYNC       0xFFE00000

#define MPEG_VERSION          0x00180000
#define MPEG_VERSION_25       0x00000000
#define MPEG_VERSION_RESERVED 0x00080000
#define MPEG_VERSION_2        0x00100000
#define MPEG_VERSION_1        0x00180000

#define MPEG_LAYER            0x00060000
#define MPEG_LAYER_RESERVED   0x00000000
#define MPEG_LAYER_III        0x00020000
#define MPEG_LAYER_II         0x00040000
#define MPEG_LAYER_I          0x00060000

#define MPEG_PROTECTION               0x00010000
#define MPEG_PROTECTION_PROTECTED     0x00000000
#define MPEG_PROTECTION_NOT_PROTECTED 0x00010000

#define MPEG_BITRATE          0x0000f000
#define MPEG_BITRATE_SHIFT    12

#define MPEG_SAMPLERATE       0x00000C00
#define MPEG_SAMPLERATE_SHIFT 10

#define MPEG_PADDING            0x00000200
#define MPEG_PADDING_NOT_PADDED 0x00000000
#define MPEG_PADDING_PADDED     0x00000200
#define MPEG_PADDING_SHIFT      9

#define MPEG_PRIVATE          0x00000100
#define MPEG_PRIVATE_SHIFT    8

#define MPEG_CHANNEL          0x000000C0
#define MPEG_CHANNEL_STEREO   0x00000000
#define MPEG_CHANNEL_JOINT    0x00000040
#define MPEG_CHANNEL_DUAL     0x00000080
#define MPEG_CHANNEL_MONO     0x000000C0

int MPEG_getSamples(FILE* fp);

#endif /* SWF_MPEG_H_INCLUDED */
