/* This header defines the general outlines of the idea of a pseudo 
 * recursion scheme. It's used within Gnometoaster to e.g. recursive adding
 * of files to the filesystem editor while at the same time being able
 * to display a progress bar of sorts */

#ifndef PSEUDORECURSE_H
#define PSEUDORECURSE_H

typedef void *pseudorecurse_info;

#define PR_END 0
#define PR_CONTINUE 1
#define PR_MANUAL 2

typedef int
  (*pseudorecurse_processitem_t)(pseudorecurse_info *info,
				 void *currentstack,
				 void *data);

/* returns the current stack frame */
void *pseudorecurse_getcurrentstackframe(pseudorecurse_info *info);
/* adds stackframe as the topmost stackframe.
 * That's like going one level up in the recursion */
void pseudorecurse_pushstackframe(pseudorecurse_info *info,void *stackframe);
/* remove the topmost stackframe.
 * That's like going one level back, e.g. returning into the previous
 * stackframe */
void pseudorecurse_popstackframe(pseudorecurse_info *info);

/* perform a pseudo recursion.
 * This will take care of keeping the recursion going
 * until pseudorecurse_processitem will return psuedorecurse_end
 * or psuedorecurse_manual. 
 * The recursion shall end immediately after the return from the
 * current operation in this case with the pseudorecurse_info structure
 * being destroyed and all items removed from the stack.
 * Memory occupied by those items will not be freed, however.
 * Operation shall see to call any "done" callbacks as appropriate
 * In the latter case, operation is expected
 * to take matters into it's own hands and see to it that the next
 * iteration will be invoked eventually.*/
void pseudorecurse_execute(pseudorecurse_processitem_t operation,
			   void *data);

#endif // PSEUDORECURSE_H

