/* The Type of Track representing a raw cd track coming directly from cdrom */

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>

#include "config.h"
#include "int.h"

#include "tracks.h"
#include "precachetrack.h"
#include "preferences.h"
#include "datacopydlg.h"
#include "cddrives.h"
#include "layoutconfig.h"
#include "streamcopy.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

/* information handed to the several functions used via callback to
 * preread a track */

typedef struct
{
   tracks_trackinfo *dc;
   precachetrack_info *info;
   streamcopy_state *cs;
   datacopydlg_dlginfo *dlg;
   void (*callback)(tracks_trackinfo*,int);
}
precachetrack_copyinfo;

int precachetrack_openpipe(void*trackinfo)
{
   precachetrack_info *i;

   i=(precachetrack_info*)((tracks_trackinfo*)trackinfo)->data;

   if (i->filedes==-1)
     {
	i->filedes=open(i->tempfile,O_RDONLY);
	if (i->filedes==-1)
	  perror ("error opening data track");
     }
   ;
   return i->filedes;
}
;

void precachetrack_closepipe(void*trackinfo)
{
   precachetrack_info *i;

   i=(precachetrack_info*)((tracks_trackinfo*)trackinfo)->data;
   if (i->filedes!=-1)
     {
	close(i->filedes);
	i->filedes=-1;
     }
   ;

}
;

int precachetrack_tracksize(void*trackinfo)
{
   precachetrack_info *i;
   tracks_trackinfo *ti=(tracks_trackinfo*)trackinfo;
   struct stat buf;
   int ts;

   i=(precachetrack_info*)((tracks_trackinfo*)trackinfo)->data;

   stat(i->tempfile,&buf);
   ts=buf.st_size;
   /* adjust tracksize to sector boundary */
   ts=
     helpings_pad(ts,
		  tracks_tracktypesectorsizes[tracks_tracktypeid(ti->tracktype)]);

   return ts;
}
;

int precachetrack_dataavail(void*trackinfo)
{
   precachetrack_info *i;

   i=(precachetrack_info*)((tracks_trackinfo*)trackinfo)->data;

   return (i->filedes!=-1);
}
;

/* FIXME: add function tracks_invalidate() to tracks.h to regulate
 * the availability of the tracks located on a cdrom */
int  precachetrack_valid(void*trackinfo)
{
   return 1;
}
;

void precachetrack_destroy(void*trackinfo)
{
   precachetrack_info *i;

   i=(precachetrack_info*)((tracks_trackinfo*)trackinfo)->data;

   if (precachetrack_dataavail(trackinfo))
     close (i->filedes);

   remove(i->tempfile);

	/* free the client claimed by the precachetrack */
   tracks_unclaim(i->client);

   free(i);
}
;

void precachetrack_donecb(streamcopy_state *cs,precachetrack_copyinfo *copy)
{
   tracks_closepipe(copy->info->client);
   layoutconfig_widget_hide(copy->dlg->messagebox,"datacopydialog");
   datacopydlg_destroy(copy->dlg);

   if (cs->fatalerror)
     {
	/* degrade precache requirements of current track */
	if (copy->info->client->precacherequired>0)
	  copy->info->client->precacherequired--;

	/* return NULL instead of the new precachetrack and 0 to
	 * show that the operation was not successful */
	copy->callback(NULL,0);
     }
   else
     copy->callback(copy->dc,1);

   /* free the precache track,
    * If precaching couldn't be completed successfully,
    * this does also unclaim()s the client track for the precaching
    * routines .
    *
    * if our precaching was successful, this track
    * should have been claimed by the caller by now so this is
    * safe and simply decreases the users-counter by one...
    * If the caller did not claim the track,however,it is assumed
    * that it has thought better of it and does not need that track
    * any longer - the structure will hence be destroyed,including
    * the buffer containing the precached data */
   tracks_unclaim(copy->dc);

   free(copy);
};

/* stop precaching if requested */
void precachetrack_stopcb(GtkWidget *w,
			  precachetrack_copyinfo *copy)
{
   streamcopy_cancel(copy->cs);
};

tracks_trackinfo *precachetrack_create(tracks_trackinfo *client,
				       void (*callback)(tracks_trackinfo*,int)
				       )
{
   char copyname[1024];

   int readtrack;
   int writetrack;

   precachetrack_copyinfo *copyinfo;
   copyinfo=(precachetrack_copyinfo*)malloc(sizeof(precachetrack_copyinfo));
#ifdef DEBUG
   printf ("precachetrack: allocated preachetrack_copyinfo at %p\n",
	   copyinfo);
#endif
   copyinfo->info=(precachetrack_info*)malloc(sizeof(precachetrack_info));

   copyinfo->info->tempfile=helpings_fileinpath(TEMPDIR,"tcacheXXXXXX");
   

   copyinfo->info->client=client;
   copyinfo->info->filedes=-1;
   copyinfo->callback=callback;

	/* claim the client */
   tracks_claim(client);

   strcpy(copyname,copyinfo->info->client->name);
   strcat(copyname,_(" (precached)"));
   copyinfo->dc=tracks_create(copyname,

			      copyinfo->info->client->title,
			      copyinfo->info->client->performer,

			      copyinfo->info->client->tracktype,none,
			      precachetrack_openpipe,
			      precachetrack_closepipe,
			      precachetrack_tracksize,
			      precachetrack_dataavail,
			      precachetrack_valid,
			      precachetrack_destroy,
			      copyinfo->info);

   copyinfo->dlg=datacopydlg_create(_("precaching file..."),
				    GTK_SIGNAL_FUNC(precachetrack_stopcb),
				    copyinfo,
				    1, /* only one "thread" */

				    DATACOPYDLG_SHOWTHROUGHPUT|
				    DATACOPYDLG_SHOWTIME_REMAINING|
				    DATACOPYDLG_SHOWTIME_ELAPSED|
				    DATACOPYDLG_SHOWPROGRESS|
				    DATACOPYDLG_SHOWPROGRESSINTITLE,
				    "",
				    "",
				    tracks_tracksize(client)

				    );
   layoutconfig_widget_show(copyinfo->dlg->messagebox,"datacopydialog");

   writetrack=mkstemp(copyinfo->info->tempfile);
#ifdef DEBUG
   printf ("opening track %s for precaching,mem location %p.\n",
	   copyinfo->info->client->name,
	   copyinfo->info->client);
#endif
   readtrack=tracks_openpipe(copyinfo->info->client);

   copyinfo->cs=streamcopy_create(writetrack,
				  readtrack,
				  -1,
				  tracks_tracksize(client),
				  copyinfo->dlg,
				  STREAMCOPY_OPT_CLOSEDEST,
				  (streamcopy_callback)precachetrack_donecb,
				  copyinfo);

   return copyinfo->dc;
}
;

