/* The menubar */

#include "config.h"

#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif

#include "main.h"
#include "menufunc.h"
#include "menusys.h"
 
static menusys_menu file_menu[]=
{
        MENUSYS_ITEM_STOCK(N_("Change _Recorder"),
			   N_("Change the currently used recorder"),
			   menufunc_changerecorder,
			   GNOME_STOCK_PIXMAP_CDROM),
	MENUSYS_EXIT_ITEM(menufunc_quit,NULL),   
	MENUSYS_ITEM_END
};

static menusys_menu edit_menu[]=
{
// Currently, Cut is disabled as it ain't useful for most cases anyway   
//   	MENUSYS_CUT_ITEM(menufunc_cut,NULL),
 	MENUSYS_COPY_ITEM(menufunc_copy,NULL),
	MENUSYS_PASTE_ITEM(menufunc_paste,NULL),
        MENUSYS_ITEM_STOCK(N_("_Import session"),
			   N_("Import the last session of this cd"),
			   menufunc_importsession,
			   GNOME_STOCK_PIXMAP_CONVERT),
        MENUSYS_ITEM_STOCK(N_("_Delete Filesystem"),
			   N_("Delete the contents of fsedit"),
			   menufunc_deletefsedit,
			   GNOME_STOCK_PIXMAP_CLEAR),
	MENUSYS_PREFERENCES_ITEM(menufunc_preferences,NULL),
	MENUSYS_ITEM_END
};

static menusys_menu tools_menu[]=
{
	MENUSYS_ITEM_NONE(N_("_Refresh Tools list"),
			  N_("scan for new plugins"),
			  menufunc_refreshtoollist),
	MENUSYS_ITEM_END
};


static menusys_menu help_menu[]=
{
	MENUSYS_ABOUT_ITEM(menufunc_about,NULL),
	MENUSYS_ITEM_END
};

static menusys_menu menubar[]=
{
        MENUSYS_FILE_TREE(file_menu),
	MENUSYS_EDIT_TREE(edit_menu),
        MENUSYS_ITEM_SUBTREE(N_("_Tools"),tools_menu),
	MENUSYS_HELP_TREE(help_menu),   
	MENUSYS_ITEM_END
};

/* create a menubar here - its widget is not returned however,
 * as menubars are handled by Gnome internally */
void menubar_create()
{
	menusys_setmenubar(menubar);
};
	
	
