/* this implements the configfile handling functions */

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>

#include "configfile.h"

GList *configfile_sections=NULL;

int configfile_seeksection(FILE *f,char *section)
{
	char line[1024];
	int found;
	char *eol;
	
	found=0;
	do 
	  {		  
		  fgets(line,1024,f);
		  eol=strchr(line,13);
		  if (eol!=NULL) 
		      *eol=0;
		  eol=strchr(line,10);
		  if (eol!=NULL)
		      *eol=0;
		  if (!strcmp(line,section)) found=1;
	  }
	while ((!found) && (!feof(f)));
	return found;
}
;

void configfile_getnextentry(FILE *f,char *name,char *value)
{
	char line[1024];
	int finished;
	char *p2;
	char *eol;
	
	finished=0;
	do 
	  {
		  fgets(line,1024,f);
		  eol=strchr(line,13);
		  if (eol!=NULL) 
		      *eol=0;
		  eol=strchr(line,10);
		  if (eol!=NULL)
		      *eol=0;
		  if (strchr(line,"="[0])!=NULL)
		    {
			    p2=strchr(line,"="[0]);
			    *p2=0;
			    p2++;
			    strcpy(name,line);
			    strcpy(value,p2);
			    finished=1;
		    }
		  ;
		  /* an empty line defines the end of a section */
		  if (strlen(line)==0)
		    {
			    finished=1;
			    strcpy(name,"");
			    strcpy(value,"");
		    }
		  ;			    
	  }
	while ((!finished)&&(!feof(f)));
	if (!finished)
	  {
		  strcpy(name,"");
		  strcpy(value,"");
	  }
	;
}
;

/* this handler opens the config file and calls the various handlers
 * storing their respective data */
void configfile_save(char *name)
{
	GList *current;
	FILE  *f;
	configfile_section *s;
	
	f=fopen(name,"w+");
	if (f!=NULL)
	  {		  	
		  for (current=configfile_sections;
		       current!=NULL;
		       current=current->next)
		    {
			    s=(configfile_section*)current->data;
			    fprintf(f,
				    "%s\n",
				    s->name);
			    s->handler(f,s->data);
			    fprintf(f,"\n");
		    }
		  ;
		  fclose(f);
	  }
	;
}
;


/* register a section within the config file. handler is then called on
 * configfile_save with a stream descriptor to write its configuration data */
void configfile_registersection(char *section,
				configfile_store handler,
				gpointer data)
{
	configfile_section *s;
	
	s=(configfile_section*)malloc(sizeof(configfile_section));
	strcpy(s->name,section);
	s->handler=handler;
	s->data=data;
	
	configfile_sections=g_list_append(configfile_sections,
					  (gpointer)s);
}
;
