/* some functions to do lowlevel access to cdrom drives */

typedef enum 
{
   TRACKTYPE_DATA,
   TRACKTYPE_AUDIO,
   TRACKTYPE_UNKNOWN
} cdromlow_tracktype;

/* use this function to get a handle for TOC access */
int cdromlow_gettochandle(const char *device);
/* use this function to free the TOC access handle */
void cdromlow_closetochandle(int handle);

int cdromlow_hasdatatrack(int handle);
int cdromlow_tracks(int handle);
int cdromlow_tracksize_sectors(int handle,int num);
int cdromlow_tracksize(int handle,int num);
int cdromlow_datatracksize(int handle,int num);
int cdromlow_cddbnumber(int handle);
int cdromlow_trackoffset(int handle,int num);

cdromlow_tracktype cdromlow_gettracktype(int handle,int num);

/* retrieve CD Text informations */

char *cdromlow_gettitle(int handle,int num);
char *cdromlow_getperformer(int handle,int num);
char *cdromlow_getdisctitle(int handle);
char *cdromlow_getdiscperformer(int handle);
