/* handling functions for installed cdrom drives */

#ifndef CDDRIVES_H
#define CDDRIVES_H

#include <gtk/gtk.h>

#include "config.h"
#include "selectlist.h"
#include "tracks.h"
#include "cddb.h"

#ifdef HAVE_PTHREADS
# include <pthread.h>
#endif

typedef struct 
{
   
   /* configuration data */
   char model[20]; /* values obtained by bus scan */
   char manufacturer[20];
   
   char device[63];      /* the name of the device special file connected
			  * to the drive */
   char scsiid[256];     /* the scsi id is optional for normal cdroms but
			  * useful for cdda2wav calls as some drives
			  * perform significantly better when accessed
			  * using /dev/sg
			  * it is, of course, essential for writers
			  * This field has been extended to 256 characters
			  * to be able to use a device special file
			  * directly (e.g. with the new linux device
			  * filesystem), where cdrecord can't resolve
			  * a scsi id to a device special file */
   char mountpoint[256]; /* the mountpoint of that drive */
   int  is_recorder;     /* this flag is set (==1) for cd writers,
			  * and 0 for normal cdrom drives */
   int  dae_usesg;       /* this flag is set to true if the scsi
			  * generic interface should be used
			  * to read out audio data digitally */
      
   /* recorder runtime data */
   int  is_active;       /* true if the recorder is currently selected
			  * for recording */
   
   /* runtime data */   
   cddb_essentials es;   /* cddb code of the current cd */
   int tracks;
   int mediachange;      /* becomes true if the change detect routine
			  * detects a cd change */

   char disctitle[256];
   char discperformer[256];
   tracks_trackinfo *track[99];	
} cddrives_cdinfo;

typedef struct 
{
   /* this is the list of cd drives. it's a gtk clist 
    * it replaces cddrives_cdinfo *drive[CDDRIVES_MAXDRIVES],
    * a pointer to the cddrives_cdinfo structure can be obtained
    * with gtk_clist_get_row_data(drivelist,row) with row being
    * the former array index */
   GtkWidget *drivelist;
   int drivecount;
   GList *updatehandlers;
   /* these handlers get called on a cd change */
   GList *contentchange;
#ifdef HAVE_PTHREADS
   pthread_mutex_t locked; /* this is our mutex controlling the mt code */
#endif
} cddrives_drives_def;

extern cddrives_drives_def cddrives_drives;

void cddrives_init();
void cddrives_destroy();

/* register a new drive in the drive list */
void cddrives_register_drive(cddrives_cdinfo*);
/* the following two functions should usually not get called externally */
void cddrives_cdinfo_update(cddrives_cdinfo*);
cddrives_cdinfo *cddrives_cdinfo_create(char *model,
					char *manufacturer,
					char *device,
					char *scsiid,
					char *mountpoint,
					int  is_recorder,
					int  dae_usesg);
void cddrives_cdinfo_destroycontent(cddrives_cdinfo*);
void cddrives_cdinfo_destroy(cddrives_cdinfo*);

/* Return the total number of drives */
int cddrives_getnumdrives();
/* Together with the function above this function can be used to iterate
 * through the list of drives */
cddrives_cdinfo *cddrives_getdrivenum(int num);

/* return the cdrom where the cd with a given cddb code resides or NULL if
 * the requested cd couldnt be found */
cddrives_cdinfo *cddrives_getrombycddb(int cddb);
cddrives_cdinfo *cddrives_getrombydevicename(const char *);
cddrives_cdinfo *cddrives_getrombyscsiid(const char *);
cddrives_cdinfo *cddrives_getrecorder();

void cddrives_updateenable();
void cddrives_updatedisable();

/* Shows the recorder selection dialog */
void cddrives_selectrecorder();

#endif // CDDRIVES_H
