
#==============================================================================#
# $Id: scale.rb,v 1.1 2004/01/22 17:00:23 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/utility/scale.rb,v $
#==============================================================================#

module GRb

  module Chart

    class Scale

      def initialize(maximum = nil, minimum = nil, interval = nil)
        @maximum  = maximum
        @minimum  = minimum
        @interval = interval
      end

      attr_accessor :maximum, :minimum, :interval

      def delta
        return @maximum - @minimum
      end

      def raito(box)
        return box.dy.to_f / self.delta.to_f
      end

      def origin(box)
        return box.y2
      end

      def raito(delta)
        return delta.to_f / self.delta.to_f
      end

    end # Scale

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
