
#==============================================================================#
# $Id: axis_major_tics.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/axis_major_tics.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class AxisMajorTicsDecorator < NoChildDecoratorBase

      def initialzie
        @number  = nil
        @color   = nil
        @size    = nil
        @inside  = nil
        @outside = nil
      end

      attr_accessor :number, :color, :size, :inside, :outside

      def draw(image, box)
        width  = (box.dx - 1).to_f / @number.to_f
        start  = box.x
        number = @number + 1

        number.times { |i|
          x = (start + width * i).ceil
          image.line(x, box.y2, x, box.y2 - @size, @color) if @inside
          image.line(x, box.y2, x, box.y2 + @size, @color) if @outside
        }

        image.line(box.x, box.y2, box.x2, box.y2, @color)
      end

    end # AxisMajorTicsDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::AxisMajorTics.new.instance_eval {
      self.number  = 20
      self.color   = GRb::Color.red(128)
      self.size    = 5
      self.inside  = true
      self.outside = true
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
