
#==============================================================================#
# $Id: facade.rb,v 1.2 2004/01/23 00:38:04 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/line/facade.rb,v $
#==============================================================================#

require 'grb/chart/xy_base/facade'
require 'grb/chart/line/property'
require 'grb/chart/line/chart'
require 'grb/chart/base/parts/legend'

#==============================================================================#

module GRb

  module Chart

    class LineChartFacade < XYChartFacadeBase

      protected

      def create_property_chart
        return GRb::Chart::LineChartProperty.new
      end

      def create_legend(property)
        font   = property.font.create_font
        legend = GRb::Chart::Legend.new(property)

        @data.each { |item|
          if item[:marker]
            legend.add(font, item[:name], GRb::Chart::Legend::Marker::LineMarker.new(item[:color], item[:marker]))
          else
            legend.add(font, item[:name], GRb::Chart::Legend::Marker::Line.new(item[:color]))
          end
        }

        return legend
      end

      def create_chart_layer(property, major_scale, items)
        graph = GRb::Chart::LineChart.new(property, major_scale, items)

        @data.each { |item|
          graph.add_value(item[:name], item[:value], item[:color], item[:marker])
        }

        return graph
      end

      # FIXME: change method name
      def count_items
        return @data.collect { |item| item[:value].size }.max
      end

    end # LineChartFacade

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
