
#==============================================================================#
# $Id: fill.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/fill.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/fill'

#==============================================================================#

module GRb

  module Chart

    class FillProperty < PropertyBase

      def initialize
        @visible = nil
        @color   = nil
        @opacity = nil
      end

      attr_accessor :visible, :color, :opacity

      def create_decorator(child)
        if @visible
          decorator = FillDecorator.new(child)
          decorator.color   = @color   || Color.white
          decorator.opacity = @opacity || 100
          return decorator
        else
          return child
        end
      end

    end # FillProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
