
#==============================================================================#
# $Id: filled_pentagon.rb,v 1.2 2004/01/23 23:02:00 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/marker/filled_pentagon.rb,v $
#==============================================================================#

require 'grb/chart/base/marker/filled_base'
require 'grb/math_ex'

#==============================================================================#

module GRb

  module Chart

    class FilledPentagonMarker < FilledMarkerBase

      def point(poly, x, y, deg)
        xx = x + MathEx.sin(180 - deg) * @size
        yy = y + MathEx.cos(180 - deg) * @size
        poly.add(xx, yy)
      end

      def drawing(image, x, y, color, edge)
        poly = Polygon.new
        point(poly, x, y,   0)
        point(poly, x, y,  72)
        point(poly, x, y, 144)
        point(poly, x, y, 216)
        point(poly, x, y, 288)
        image.polygon(poly, edge, color)
      end

    end # FilledPentagonMarker

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
