
#==============================================================================#
# $Id: singular_base.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/singular_base.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/base'

#==============================================================================#

module GRb

  module Chart

    class SingularDecoratorBase < DecoratorBase

      def initialize(child)
        super()
        @child = child
      end

      def has_child?
        return !@child.nil?
      end
      protected :has_child?

      def draw(image, box)
        draw_self(image, box)
        draw_child(image, box) if self.has_child?
      end

      def draw_self(image, box)
        # nop
      end
      protected :draw_self

      def draw_child(image, box)
        # nop
      end
      protected :draw_child

      def child_dx
        return (@child ? @child.dx : 0)
      end
      protected :child_dx

      def child_dy
        return (@child ? @child.dy : 0)
      end
      protected :child_dy

      def dx
        return self.child_dx
      end

      def dy
        return self.child_dy
      end

    end # SingularDecoratorBase

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
