
#==============================================================================#
# $Id: align.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/align.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/plural_base'
require 'grb/chart/base/decorator/singular_base'

#==============================================================================#

module GRb

  module Chart

    class VerticalAlignDecorator < PluralDecoratorBase

      def initialize(*children)
        super(*children)
      end

      def draw_child(image, box)
        height = box.dy.to_f / self.size

        self.each_with_index { |child, index|
          child_box = GRb::Chart::Box.new
          child_box.x  = box.x
          child_box.y  = box.y + (height * index).floor
          child_box.dx = box.dx
          child_box.dy = height

          child.draw(image, child_box)
        }
      end

      def dx
        return self.collect { |child| child.dx }.max
      end

    end # VerticalAlignDecorator

    class VerticalAlignCenterDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dy = @child.dy

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x
        child_box.y  = box.y + box.dy / 2 - child_dy / 2
        child_box.dx = box.dx
        child_box.dy = child_dy

        @child.draw(image, child_box)
      end

    end # VerticalAlignCenterDecorator

    class VerticalAlignTopDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dy = @child.dy

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x
        child_box.y  = box.y
        child_box.dx = box.dx
        child_box.dy = child_dy

        @child.draw(image, child_box)
      end

    end # VerticalAlignTopDecorator

    class VerticalAlignBottomDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dy = @child.dy

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x
        child_box.y  = box.y + box.dy - child_dy
        child_box.dx = box.dx
        child_box.dy = child_dy

        @child.draw(image, child_box)
      end

    end # VerticalAlignBottomDecorator

    class HorizontalAlignDecorator < PluralDecoratorBase

      def initialize(*children)
        super(*children)
      end

      def draw_child(image, box)
        width = box.dx.to_f / self.size

        self.each_with_index { |child, index|
          child_box = GRb::Chart::Box.new
          child_box.x  = box.x + (width * index).floor
          child_box.y  = box.y
          child_box.dx = width.floor
          child_box.dy = box.dy

          child.draw(image, child_box)
        }
      end

      def dy
        return self.collect { |child| child.dy }.max
      end

    end # HorizontalAlignDecorator

    class HorizontalAlignCenterDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dx = @child.dx

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x + box.dx / 2 - child_dx / 2
        child_box.y  = box.y
        child_box.dx = child_dx
        child_box.dy = box.dy

        @child.draw(image, child_box)
      end

    end # HorizontalAlignCenterDecorator

    class HorizontalAlignLeftDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dx = @child.dx

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x
        child_box.y  = box.y
        child_box.dx = child_dx
        child_box.dy = box.dy

        @child.draw(image, child_box)
      end

    end # HorizontalAlignLeftDecorator

    class HorizontalAlignRightDecorator < SingularDecoratorBase

      def initialize(child)
        super(child)
      end

      def draw_child(image, box)
        child_dx = @child.dx

        child_box = GRb::Chart::Box.new
        child_box.x  = box.x + box.dx - child_dx
        child_box.y  = box.y
        child_box.dx = child_dx
        child_box.dy = box.dy

        @child.draw(image, child_box)
      end

    end # HorizontalAlignRightDecorator

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
