/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: search.h,v 1.18 2003/11/03 21:07:58 stamfest Exp $ */

#ifndef GQ_SEARCH_H_INCLUDED
#define GQ_SEARCH_H_INCLUDED

#include "common.h"
#include "mainwin.h"

#define SEARCHTAB(tab) (assert(tab->type == SEARCH_MODE), (struct tab_search *)tab->modeinfo)
struct tab_search {
     GtkWidget *search_combo;
     GtkWidget *serverlist_combo;
     GtkWidget *searchbase_combo;
     GtkWidget *main_clist;
     int populated_searchbase;
     int search_lock;

     /* set gets used to pass the current result for some
	callbacks. There was no simple other way except to hack */
     struct dn_on_server *set;
     GList *history;

     int last_options_tab;

     int scope;
     int chase_ref;
     int max_depth;
     GList *attrs;
};

struct attrs {
     char name[128];
     int column;
     struct attrs *next;
};

#define SEARCHBOX_PADDING 2

struct tab *new_searchmode();

char *make_filter(struct ldapserver *server, char *querystring);

void fill_out_search(struct tab *tab,
		     struct ldapserver *server,
		     const char *search_base_dn);


#endif /* GQ_SEARCH_H_INCLUDED */

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
