/*
              Copyright (C) 1993 - 2001   Masahito Yamaga

Permission to use, copy, and distribute this package and its documentation
for any purpose is granted, provided that this permission notice is included
in supporting documentation.

Permission to modify this package is also granted, but please send an e-mail
to Yamaga (ma@yama-ga.com) in case of distributing the modified code.

This package provides NO WARRANTY. You can use this at your own risks.

Copyrights on this package belong to Masahito Yamaga, but GNUPLOT's to Mr.
Thomas Williams and Mr. Colin Kelley (See "Copyright" in the original GNUPLOT
source package).

Distribution of GNUPLOT that has been applied this patch to (especially
binaries) has to be very carefully done. See "Copyright" in the original
GNUPLOT source package.

                                   2001/01/11 Masahito Yamaga(ma@yama-ga.com)
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#ifdef NO_STDLIB_H
int atoi();
#else
#include <stdlib.h>	/* for atoi */
#endif
#include "gp+lib.h"

#ifdef __STDC__
unsigned char *command_check(register unsigned char *str,
			register const char *comname, int com, int *ccom)
#else
unsigned char *command_check(str,comname,com,ccom)
unsigned char *str,*comname;
int com,*ccom;
#endif
{
	int i;

	for(i=0;comname[i]!='\0';i++){
		if (str[i]!=comname[i]) return str;
	}

	if (str[i]==' ' || str[i]=='\\' || str[i]=='{') {
		str+=strlen(comname);
		while(*str==' ') str++;
		*ccom=com;
	}
	return str;
}

#ifdef __STDC__
unsigned char *command_check2(register unsigned char *str,
					register const char *comname)
#else
unsigned char *command_check2(str,comname)
unsigned char *str,*comname;
#endif
{
	int i;

	for(i=0;comname[i]!='\0';i++){
		if (str[i]!=comname[i]) return str;
	}
	str+=strlen(comname);
	return str;
}

#ifdef __STDC__
unsigned char *command_check3(register unsigned char *str,
						register const char *comname)
#else
unsigned char *command_check3(str,comname)
unsigned char *str,*comname;
#endif
{
	int i;

	for(i=0;comname[i]!='\0';i++){
		if (str[i]!=comname[i]) return str;
	}

	if ((str[i]>='a'&&str[i]<='z')||(str[i]>='A'&&str[i]<='Z')) return str;

	str+=strlen(comname);
	return str;
}

#ifdef __STDC__
unsigned char *get_size(unsigned char *str,const char *comname, int *csize)
#else
unsigned char *get_size(str,comname,csize)
unsigned char *str;
char *comname;
int *csize;
#endif
{
	int i,j=0;
	char size[10];

	for(i=0;comname[i]!='\0';i++){
		if (str[i]!=comname[i]) return str;
	}

	str+=strlen(comname);
	while(*str==' '||*str=='+') str++;
	if (*str=='-'){size[j++]=*str;str++;}
	while(*str==' ') str++;

	while(*str>='0' && *str<='9'){
		size[j++]=*str;
		str++;
	}
	size[j]='\0';

	*csize=atoi(size);

	while(*str==' ') str++;

	return str;
}

#ifdef __STDC__
int addletter(register unsigned char *tmpstr,int i,register const char *letters)
#else
int addletter(tmpstr,i,letters)
unsigned char *tmpstr;
char *letters;
int i;
#endif
{
	while(*letters!='\0'){
		tmpstr[i++]=*letters;
		letters++;
	}
	return i;
}

#ifdef __STDC__
unsigned char *command_replace(register unsigned char *str)
#else
unsigned char *command_replace(str)
unsigned char *str;
#endif
{
	int i=0;
	int flag=FALSE;
	unsigned char *tmpstr,*tmp;

#define REPLACEWORD(x,y)	if (!flag){\
					if (str!=(tmp=command_check3(str,x))){\
					str=tmp;\
					i=addletter(tmpstr,i,y);\
					flag=TRUE;}}

	tmpstr=(unsigned char *)malloc(2*MAXLEN);

	while(*str!='\0'){
		flag=FALSE;

		switch(*str){
		case '\\':
#include "gp+command.h"
			break;
		case '{':
			REPLACEWORD("{}","{@NULL@}");
			break;
		default:
			break;
		}

		if (!flag) {
			tmpstr[i++]=*str;
			str++;
		}
	}
	tmpstr[i]='\0';

	strcpy((char *)str,(const char *)tmpstr);
	free(tmpstr);
	return str;
}

#ifdef __STDC__
unsigned char *brace_check(unsigned char *str)
#else
unsigned char *brace_check(str)
unsigned char *str;
#endif
{
	int i=0;
	int nbrace=0;
	int ndollor=0;
	int frac=0;
	int denom=FALSE;
	unsigned char *tmpstr;

	tmpstr=(unsigned char *)malloc(2*MAXLEN);

	while(*str!='\0'){
		switch(*str){
		case '$':
			ndollor++;
			break;
		case '{':
			if (denom) {
				denom=FALSE;
				i=addletter(tmpstr,i,"\\denom");
			}
			nbrace++;
			break;
		case '}':
			if (!nbrace)
				fprintf(stderr,"Error: } is illegally used\n");
			if (nbrace==frac) {frac=0;denom=TRUE;}
			nbrace--;
			break;
		case '\\':
			if ((*(str+1)=='f') && (*(str+2)=='r') &&
			(*(str+3)=='a') && (*(str+4)=='c') && (*(str+5)=='{'))
				frac=nbrace+1;
			break;
		default:
			break;
		}
		tmpstr[i++]=*str;
		str++;
	}
	tmpstr[i]='\0';

	if (nbrace) fprintf(stderr,"Error: } is missing\n");
	if (ndollor%2) fprintf(stderr,"Error: $'s not matched\n");

	strcpy((char *)str,(const char*)tmpstr);
	free(tmpstr);
	return str;
}
