REM Oracle version of distributed SQL file
REM 09-01-2003 - Created Farooq S. Khan 

spool wbgktbl.lst
set echo on ;

connect voipuser/voippass;

drop table t_gk_CDR;
drop table T_WB_Customer;


create table T_WB_Customer (
CUST_ID    INTEGER NOT NULL ,
THE_DATE    DATE default sysdate,
L_NAME    varchar2(32) ,
F_NAME    varchar2(32) ,
M_NAME    varchar2(32),
COMPANY_NAME    varchar2(32) ,
ADDR_LINE1    varchar2(64) ,
ADDR_LINE2    varchar2(64) ,
ADDR_CITY    varchar2(64) ,
ADDR_STATE    varchar2(64) ,
ADDR_ZIP    varchar2(16) ,
ADDR_COUNTRY    varchar2(64) ,
PHONE_D    varchar2(32) ,
PHONE_E    varchar2(32) ,
CUST_USER_ID    varchar2(32) not null ,
CUST_PASS    varchar2(16)  not null,
TIME_ZONE    varchar2(8) ,
CUST_LEVEL   integer,
ACCT_ACTIVE    varchar2(8) default 'A',
constraint pk_Customer primary key   (cust_id),
constraint uq_Customer unique   (CUST_USER_ID)
);


REM  The CDR 

create table T_GK_CDR(
TIME_STAMP DATE default sysdate,
GATEKEEPER_ID integer not null,
CALLNo  varchar2(64),
CALLID  varchar2(64),
DURATION  INTEGER,
StartTime DATE,
EndTime  DATE,
CallerIP  VARCHAR2(32),
CallerEndID  VARCHAR(16),
CalledIP  VARCHAR(32),
CalledEndID VARCHAR(16),
DestinationINFO VARCHAR(64),
SourceInfo VARCHAR(64),
GKName VARCHAR(64),
CALLER_CUST_ID    INTEGER NOT NULL ,
CALLED_CUST_ID    INTEGER NOT NULL ,
CALLER_GATEWAY_ID INTEGER NOT NULL ,
CALLED_GATEWAY_ID INTEGER NOT NULL ,
REGION_SERIAL 	  INTEGER NOT NULL ,
CALL_TERM_CODE	  Varchar2(32),
CONF_ID 	  Varchar2(32),
STATUS		  INTEGER,
cdr_posted        varchar2(8)
);


CREATE OR REPLACE TRIGGER It_gk_gcf
BEFORE INSERT
ON t_gk_gcf
FOR EACH ROW
BEGIN
  SELECT SYSDATE INTO :NEW.TIME_STAMP FROM DUAL;
END;
/

CREATE OR REPLACE TRIGGER Ut_gk_gcf
BEFORE UPDATE
ON t_gk_gcf
FOR EACH ROW
BEGIN
  SELECT SYSDATE INTO :NEW.TIME_STAMP FROM DUAL;
END;
/
