/*************************************************************************************************
 * Implementation of features of dynamic linking functions
 *                                                      Copyright (C) 2003-2004 Mikio Hirabayashi
 * This file is part of Estraier, a personal full-text search system.
 * Estraier is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 * Estraier is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Estraier;
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA.
 *************************************************************************************************/


#include "estcommon.h"



#if defined(MYDLFILTER)
/*************************************************************************************************
 * implementations
 *************************************************************************************************/


#include <dlfcn.h>


static void *estgetdlfunc_impl(const char *file, const char *symbol);
static void estdlclose(void *dlh);


int estisdlfunc = TRUE;
ESTFILTER (*estgetdlfunc)(const char *file, const char *symbol)
     = (ESTFILTER (*)(const char *, const char *))estgetdlfunc_impl;


/* Get the pointer of a function in a dynamic linking library. */
static void *estgetdlfunc_impl(const char *file, const char *symbol){
  static CBMAP *map = NULL;
  void *dlh;
  if(!map){
    map = cbmapopen();
    cbglobalgc(map, (void (*)(void *))cbmapclose);
  }
  if(!(dlh = (void *)cbmapget(map, file, -1, NULL))){
    if(!(dlh = dlopen(file, RTLD_LAZY))) return NULL;
    cbglobalgc(dlh, estdlclose);
  }
  return dlsym(dlh, symbol);
}


/* Close the handle of a dynamic linking library. */
static void estdlclose(void *dlh){
  dlclose(dlh);
}



#else
/*************************************************************************************************
 * dummy interfaces
 *************************************************************************************************/


int estisdlfunc = FALSE;
void *(*estgetdlfunc)(const char *file, const char *symbol) = NULL;



#endif



/* END OF FILE */
