/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive;

import org.argouml.language.csharp.importer.csparser.enums.IntegralType;
import org.argouml.language.csharp.importer.csparser.enums.NumberStyles;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.LiteralNode;
import org.argouml.language.csharp.importer.csparser.util.StringUtil;

public class IntegralPrimitive
extends LiteralNode {
    private String originalString;
    private IntegralType integralType;
    private long Value;

    public IntegralPrimitive(String value, IntegralType integralType) {
        this.originalString = value;
        this.integralType = integralType;
        switch (integralType) {
            case SByte: 
            case Byte: 
            case Short: 
            case Int: {
                break;
            }
            case UShort: {
                value = StringUtil.removeChar(value, new char[]{'U', 'u'});
                break;
            }
            case UInt: {
                value = StringUtil.removeChar(value, new char[]{'U', 'u'});
                break;
            }
            case Long: {
                value = StringUtil.removeChar(value, new char[]{'L', 'l'});
                break;
            }
            case ULong: {
                value = StringUtil.removeChar(value, new char[]{'L', 'l', 'U', 'u'});
                value = StringUtil.removeChar(value, new char[]{'L', 'l', 'U', 'u'});
                break;
            }
        }
        int radix = 10;
        int style = NumberStyles.Integer;
        if (value.toLowerCase().startsWith("0x")) {
            radix = 16;
            style = NumberStyles.HexNumber;
            value = value.substring(2);
        }
        this.Value = Long.parseLong(value, radix);
    }

    public IntegralType getIntegralType() {
        return this.integralType;
    }

    public void ToSource(StringBuilder sb) {
        sb.append(this.Value);
    }
}

