/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Section {
    private Map mAry = new HashMap();
    private static final Logger LOG = Logger.getLogger(Section.class);
    private static final String BEGIN = "// section ";
    private static final String END1 = " begin";
    private static final String END2 = " end";

    public Section() {
        this.mAry.clear();
    }

    public static String generate(String id, String indent) {
        String s = "";
        s = s + indent + BEGIN + id + END1 + "\n";
        s = s + indent + BEGIN + id + END2 + "\n";
        return s;
    }

    public void write(String filename, String indent) {
        try {
            LOG.debug((Object)"Start reading");
            FileReader f = new FileReader(filename);
            BufferedReader fr = new BufferedReader(f);
            FileWriter fw = new FileWriter(filename + ".out");
            LOG.debug((Object)("Total size of Map: " + this.mAry.size()));
            String line = "";
            while (line != null) {
                line = fr.readLine();
                if (line == null) continue;
                String sectionId = Section.getSectionId(line);
                if (sectionId != null) {
                    String content = (String)this.mAry.get(sectionId);
                    fw.write(line + "\n");
                    if (content != null) {
                        fw.write(content);
                    }
                    line = fr.readLine();
                    this.mAry.remove(sectionId);
                }
                fw.write(line + "\n");
            }
            if (!this.mAry.isEmpty()) {
                fw.write("/* lost code following: \n");
                Set mapEntries = this.mAry.entrySet();
                for (Map.Entry entry : mapEntries) {
                    fw.write(indent + BEGIN + entry.getKey() + END1 + "\n");
                    fw.write((String)entry.getValue());
                    fw.write(indent + BEGIN + entry.getKey() + END2 + "\n");
                }
            }
            fr.close();
            fw.close();
        }
        catch (IOException e) {
            LOG.debug((Object)("Error: " + e.toString()));
        }
    }

    public void read(String filename) {
        try {
            LOG.debug((Object)"Start reading");
            FileReader f = new FileReader(filename);
            BufferedReader fr = new BufferedReader(f);
            String line = "";
            String content = "";
            boolean inSection = false;
            while (line != null) {
                String sectionId;
                line = fr.readLine();
                if (line == null) continue;
                if (inSection) {
                    sectionId = Section.getSectionId(line);
                    if (sectionId != null) {
                        inSection = false;
                        this.mAry.put(sectionId, content);
                        content = "";
                        continue;
                    }
                    content = content + line + "\n";
                    continue;
                }
                sectionId = Section.getSectionId(line);
                if (sectionId == null) continue;
                inSection = true;
            }
            fr.close();
        }
        catch (IOException e) {
            LOG.debug((Object)("Error: " + e.toString()));
        }
    }

    private static String getSectionId(String line) {
        int first = line.indexOf(BEGIN);
        int second = line.indexOf(END1);
        if (second < 0) {
            second = line.indexOf(END2);
        }
        String s = null;
        if (first > 0 && second > 0) {
            s = line.substring(first += BEGIN.length(), second);
        }
        return s;
    }
}

