/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.ChainingDockBoundary;
import org.tigris.toolbar.layouts.DockBoundary;
import org.tigris.toolbar.layouts.DockingConstraints;
import org.tigris.toolbar.layouts.StackingDockBoundary;
import org.tigris.toolbar.layouts.ToolBarHandler;
import org.tigris.toolbar.layouts.WrappingDockBoundary;

public class DockLayout
implements LayoutManager,
LayoutManager2 {
    private DockBoundary ourNorthBoundary = null;
    private DockBoundary ourSouthBoundary = null;
    private DockBoundary ourEastBoundary = null;
    private DockBoundary ourWestBoundary = null;
    private Component ourContent = null;
    private Container ourTargetContainer = null;
    private int ourVerticalSpacing = 0;
    private int ourHorizontalSpacing = 0;
    private boolean ourVersionIsCompatible = false;
    public static final int CHAINING_STYLE = -1;
    public static final int WRAPPING_STYLE = 0;
    public static final int STACKING_STYLE = 1;
    public static final int MAX = Integer.MAX_VALUE;
    public static final int NORTH = 1;
    public static final int SOUTH = 5;
    public static final int EAST = 3;
    public static final int WEST = 7;
    public static final int CENTER = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String north = "North";
    public static final String south = "South";
    public static final String east = "East";
    public static final String west = "West";
    public static final String center = "Center";

    public DockLayout(Container container) {
        this(container, 0);
    }

    public DockLayout(Container container, int n) {
        this.ourTargetContainer = container;
        String string = System.getProperty("java.specification.version");
        try {
            float f = Float.parseFloat(string);
            if (f > 1.2f) {
                this.ourVersionIsCompatible = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installDockBoundary(this.createBoundary(n, 1, 2));
        this.installDockBoundary(this.createBoundary(n, 5, 2));
        this.installDockBoundary(this.createBoundary(n, 3, 2));
        this.installDockBoundary(this.createBoundary(n, 7, 2));
    }

    private DockBoundary createBoundary(int n, int n2, int n3) {
        if (n == 1) {
            return new StackingDockBoundary(n2, n3);
        }
        if (n == -1) {
            return new ChainingDockBoundary(n2, n3);
        }
        return new WrappingDockBoundary(n2, n3);
    }

    public void setHorizontalSpacing(int n) {
        this.ourHorizontalSpacing = n;
    }

    public void setVerticalSpacing(int n) {
        this.ourVerticalSpacing = n;
    }

    public void setToolBarSpacing(int n) {
        this.ourNorthBoundary.setSpacing(n);
        this.ourSouthBoundary.setSpacing(n);
        this.ourEastBoundary.setSpacing(n);
        this.ourWestBoundary.setSpacing(n);
    }

    public int getHorizontalSpacing() {
        return this.ourHorizontalSpacing;
    }

    public int getVerticalSpacing() {
        return this.ourVerticalSpacing;
    }

    public int getToolBarSpacing() {
        return this.ourNorthBoundary.getSpacing();
    }

    public void installDockBoundary(DockBoundary dockBoundary) {
        if (dockBoundary == null) {
            return;
        }
        if (!this.ourVersionIsCompatible && !(dockBoundary instanceof ChainingDockBoundary)) {
            dockBoundary = new ChainingDockBoundary(dockBoundary.getEdge());
        }
        int n = dockBoundary.getEdge();
        DockBoundary dockBoundary2 = this.getBoundary(n);
        JToolBar[] jToolBarArray = null;
        if (dockBoundary2 != null) {
            jToolBarArray = dockBoundary2.getToolBars();
        }
        if (jToolBarArray != null) {
            for (int i = 0; i < jToolBarArray.length; ++i) {
                dockBoundary.addToolBar(jToolBarArray[i], 0, Integer.MAX_VALUE);
            }
        }
        if (n == 1) {
            this.ourNorthBoundary = dockBoundary;
        } else if (n == 5) {
            this.ourSouthBoundary = dockBoundary;
        } else if (n == 3) {
            this.ourEastBoundary = dockBoundary;
        } else if (n == 7) {
            this.ourWestBoundary = dockBoundary;
        }
    }

    private DockBoundary getBoundary(int n) {
        if (n == 1) {
            return this.ourNorthBoundary;
        }
        if (n == 5) {
            return this.ourSouthBoundary;
        }
        if (n == 3) {
            return this.ourEastBoundary;
        }
        if (n == 7) {
            return this.ourWestBoundary;
        }
        return null;
    }

    private DockBoundary getBoundary(String string) {
        if (string.equals(north)) {
            return this.ourNorthBoundary;
        }
        if (string.equals(south)) {
            return this.ourSouthBoundary;
        }
        if (string.equals(east)) {
            return this.ourEastBoundary;
        }
        if (string.equals(west)) {
            return this.ourWestBoundary;
        }
        return null;
    }

    DockBoundary getBoundary(Point point) {
        if (this.ourNorthBoundary.contains(point)) {
            return this.ourNorthBoundary;
        }
        if (this.ourSouthBoundary.contains(point)) {
            return this.ourSouthBoundary;
        }
        if (this.ourWestBoundary.contains(point)) {
            return this.ourWestBoundary;
        }
        if (this.ourEastBoundary.contains(point)) {
            return this.ourEastBoundary;
        }
        return null;
    }

    DockBoundary getDockableBoundary(Point point) {
        if (this.ourNorthBoundary.isDockablePoint(point)) {
            return this.ourNorthBoundary;
        }
        if (this.ourSouthBoundary.isDockablePoint(point)) {
            return this.ourSouthBoundary;
        }
        if (this.ourWestBoundary.isDockablePoint(point)) {
            return this.ourWestBoundary;
        }
        if (this.ourEastBoundary.isDockablePoint(point)) {
            return this.ourEastBoundary;
        }
        return null;
    }

    Container getTargetContainer() {
        return this.ourTargetContainer;
    }

    private ToolBarHandler getHandler(JToolBar jToolBar) {
        if (jToolBar == null) {
            return null;
        }
        ToolBarHandler toolBarHandler = this.extractHandler(jToolBar);
        if (toolBarHandler == null) {
            String string = "ToolBarHandler";
            toolBarHandler = new ToolBarHandler(jToolBar, this);
            jToolBar.putClientProperty(string, toolBarHandler);
        }
        return toolBarHandler;
    }

    private ToolBarHandler extractHandler(JToolBar jToolBar) {
        if (jToolBar == null) {
            return null;
        }
        String string = "ToolBarHandler";
        Object object = jToolBar.getClientProperty(string);
        return (ToolBarHandler)object;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void addLayoutComponent(Component component, Object object) {
        String string = "";
        if (component instanceof JToolBar && object instanceof DockingConstraints) {
            JToolBar jToolBar = (JToolBar)component;
            ToolBarHandler toolBarHandler = this.getHandler(jToolBar);
            DockingConstraints dockingConstraints = (DockingConstraints)object;
            toolBarHandler.setConstraints(dockingConstraints);
            int n = toolBarHandler.getDockEdge();
            if (n == 1) {
                string = north;
            } else if (n == 5) {
                string = south;
            } else if (n == 7) {
                string = west;
            } else if (n == 3) {
                string = east;
            }
        } else if (object != null && object instanceof String) {
            string = object.toString();
        }
        this.addLayoutComponent(string, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                ToolBarHandler toolBarHandler = this.getHandler(jToolBar);
                DockBoundary dockBoundary = null;
                if (string != null) {
                    dockBoundary = this.getBoundary(string);
                }
                if (dockBoundary == null) {
                    dockBoundary = this.getBoundary(toolBarHandler.getDockEdge());
                }
                dockBoundary.addToolBar(jToolBar, toolBarHandler.getRowIndex(), toolBarHandler.getDockIndex());
                dockBoundary.refreshHandlers();
            } else {
                this.ourContent = component;
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        this.ourNorthBoundary.removeComponent(component);
        this.ourSouthBoundary.removeComponent(component);
        this.ourEastBoundary.removeComponent(component);
        this.ourWestBoundary.removeComponent(component);
        if (component == this.ourContent) {
            this.ourContent = null;
        }
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        this.ourTargetContainer = container;
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getWidth();
            int n2 = container.getHeight();
            Insets insets = container.getInsets();
            int n3 = insets.top;
            int n4 = n2 - insets.bottom;
            int n5 = insets.left;
            int n6 = n - insets.right;
            this.ourNorthBoundary.setPosition(n5, n3, n);
            this.ourSouthBoundary.setPosition(n5, n4, n);
            int n7 = this.ourNorthBoundary.getDepth();
            int n8 = this.ourSouthBoundary.getDepth();
            if (n7 > 0) {
                n7 += this.ourVerticalSpacing;
            }
            if (n8 > 0) {
                n8 += this.ourVerticalSpacing;
            }
            n2 = n4 - n3 - n7 - n8;
            this.ourWestBoundary.setPosition(n5, n3 += n7, n2);
            this.ourEastBoundary.setPosition(n6, n3, n2);
            int n9 = this.ourEastBoundary.getDepth();
            int n10 = this.ourWestBoundary.getDepth();
            if (n9 > 0) {
                n9 += this.ourHorizontalSpacing;
            }
            if (n10 > 0) {
                n10 += this.ourHorizontalSpacing;
            }
            n = n6 - n5 - n9 - n10;
            n5 += n10;
            if (this.ourContent != null) {
                this.ourContent.setBounds(n5, n3, n, n2);
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = null;
        dimension = this.ourContent != null ? this.ourContent.getPreferredSize() : new Dimension(0, 0);
        int n = this.ourNorthBoundary.getDepth();
        if (n > 0 && dimension.height > 0) {
            dimension.height += this.ourVerticalSpacing;
        }
        dimension.height += n;
        n = this.ourSouthBoundary.getDepth();
        if (n > 0 && dimension.height > 0) {
            dimension.height += this.ourVerticalSpacing;
        }
        dimension.height += n;
        n = this.ourWestBoundary.getDepth();
        if (n > 0 && dimension.width > 0) {
            dimension.width += this.ourHorizontalSpacing;
        }
        dimension.width += n;
        n = this.ourEastBoundary.getDepth();
        if (n > 0 && dimension.width > 0) {
            dimension.width += this.ourHorizontalSpacing;
        }
        dimension.width += n;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

